/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProductionStrategyHelper {
    public static ManufactureStrategyInfo getManufactureStrategy(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        ManufactureStrategyInfo strategy = null;
        MaterialPlanInfo materialPlanInfo = ProductionStrategyHelper.getMaterialPlanInfo(ctx, material, orgUnit);
        if (materialPlanInfo == null) {
            return strategy;
        }
        if (materialPlanInfo.getManufactureStrategy() != null) {
            strategy = materialPlanInfo.getManufactureStrategy();
        }
        return strategy;
    }

    public static ManufactureStrategyInfo getManufactureStrategyNotNull(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        ManufactureStrategyInfo mfc = ProductionStrategyHelper.getManufactureStrategy(ctx, material, orgUnit);
        if (mfc == null) {
            mfc = new ManufactureStrategyInfo();
            mfc.setId(BOSUuid.create((BOSObjectType)mfc.getBOSType()));
        }
        return mfc;
    }

    public static Map getManufactureStrategy(Context ctx, Set materialSet, String orgUnit) throws BOSException, EASBizException {
        HashMap<String, ManufactureStrategyInfo> result = new HashMap<String, ManufactureStrategyInfo>();
        Object strategy = null;
        CoreBaseCollection materialPlanCollection = ProductionStrategyHelper.getMaterialPlanInfo(ctx, materialSet, orgUnit);
        for (int i = 0; i < materialPlanCollection.size(); ++i) {
            MaterialPlanInfo mp = (MaterialPlanInfo)materialPlanCollection.get(i);
            if (mp.getManufactureStrategy() == null) {
                ManufactureStrategyInfo mfc = new ManufactureStrategyInfo();
                mfc.setId(BOSUuid.create((BOSObjectType)mfc.getBOSType()));
                result.put(mp.getMaterial().getId().toString(), mfc);
                continue;
            }
            if ("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(mp.getManufactureStrategy().getId().toString())) {
                mp.getManufactureStrategy().put("rule", (Object)mp.getIsolatedRule());
            }
            result.put(mp.getMaterial().getId().toString(), mp.getManufactureStrategy());
        }
        return result;
    }

    public static String getManufactureStrategy(Context ctx, MaterialPlanInfo materialPlan, MaterialInfo material, StorageOrgUnitInfo orgUnit) throws BOSException, EASBizException {
        ManufactureStrategyInfo strategy = null;
        String strategyId = "";
        MaterialPlanInfo materialPlanInfo = materialPlan;
        if (materialPlanInfo == null && (material == null || material.getId() == null || orgUnit == null || orgUnit.getId() == null)) {
            return strategyId;
        }
        strategy = materialPlanInfo == null ? ProductionStrategyHelper.getManufactureStrategy(ctx, material.getId().toString(), orgUnit.getId().toString()) : materialPlanInfo.getManufactureStrategy();
        if (strategy == null || strategy.getId() == null) {
            return strategyId;
        }
        strategyId = strategy.getId().toString();
        return strategyId;
    }

    public static boolean isATOorMTO(Context ctx, MaterialPlanInfo materialPlan, MaterialInfo material, StorageOrgUnitInfo orgUnit) throws BOSException, EASBizException {
        boolean isATOorMTO = false;
        String strategyId = ProductionStrategyHelper.getManufactureStrategy(ctx, materialPlan, material, orgUnit);
        if (strategyId.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
            isATOorMTO = true;
        }
        return isATOorMTO;
    }

    public static boolean isATOorMTO(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        boolean isATOorMTO = false;
        ManufactureStrategyInfo strategy = ProductionStrategyHelper.getManufactureStrategy(ctx, material, orgUnit);
        if (strategy != null && (strategy.getId().toString().equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategy.getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategy.getId().toString().equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategy.getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU="))) {
            isATOorMTO = true;
        }
        return isATOorMTO;
    }

    public static boolean isATO20orMTO20(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        boolean isATOorMTO = false;
        ManufactureStrategyInfo strategy = ProductionStrategyHelper.getManufactureStrategy(ctx, material, orgUnit);
        if (strategy != null && (strategy.getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategy.getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU="))) {
            isATOorMTO = true;
        }
        return isATOorMTO;
    }

    public static int isProjectRequire(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        ManufactureStrategyInfo strategy = ProductionStrategyHelper.getManufactureStrategy(ctx, material, orgUnit);
        int isProjectRequire = 0;
        if (strategy == null) {
            return isProjectRequire;
        }
        String strategyId = strategy.getId().toString();
        if (strategyId.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
            isProjectRequire = -1;
        } else if (strategyId.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategyId.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            isProjectRequire = 1;
        }
        return isProjectRequire;
    }

    public static int isTrackNumberRequire(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        MaterialPlanInfo materialPlanInfo = ProductionStrategyHelper.getMaterialPlanInfo(ctx, material, orgUnit);
        ManufactureStrategyInfo strategy = ProductionStrategyHelper.getManufactureStrategy(ctx, material, orgUnit);
        int isTrackNumberRequire = 0;
        if (strategy == null) {
            return isTrackNumberRequire;
        }
        String strategyId = strategy.getId().toString();
        if (strategyId.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
            isTrackNumberRequire = 1;
        }
        if ((strategyId.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategyId.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) && materialPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
            isTrackNumberRequire = 1;
        }
        return isTrackNumberRequire;
    }

    public static MaterialPlanInfo getMaterialPlanInfo(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        IMaterialPlan iMaterial = null;
        iMaterial = ctx == null ? MaterialPlanFactory.getRemoteInstance() : MaterialPlanFactory.getLocalInstance((Context)ctx);
        MaterialPlanInfo materialPlanInfo = null;
        if (material != null && orgUnit != null) {
            materialPlanInfo = iMaterial.getPlanInfo(material, orgUnit);
        }
        return materialPlanInfo;
    }

    public static CoreBaseCollection getMaterialPlanInfo(Context ctx, Set materialSet, String orgUnit) throws BOSException, EASBizException {
        IMaterialPlan iMaterial = null;
        iMaterial = ctx == null ? MaterialPlanFactory.getRemoteInstance() : MaterialPlanFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection mpc = null;
        if (materialSet != null && materialSet.size() > 0 && orgUnit != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnit, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialSet, CompareType.INCLUDE));
            evi.setFilter(filter);
            mpc = iMaterial.getCollection(evi);
        }
        return mpc;
    }
}

