/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.mm.common.ITotalLine;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class TotalLineHandler
implements ITotalLine {
    private static final Logger logger = Logger.getLogger(TotalLineHandler.class);
    private Map tableToSumField = new HashMap();
    private Map tableToSumIndex = new ConcurrentHashMap();
    private Map tablePropertyListener = new HashMap();

    @Override
    public void appendFootRow(KDTable table) {
        EventListener[] lisbak = this.removeTablePropertyChangeListener(table, KDTPropertyChangeListener.class);
        this.appendFootRow(table, null);
        this.restoreTableListeners(KDTPropertyChangeListener.class, table, lisbak);
    }

    @Override
    public void refreshFootROw(KDTable table) {
        this.appendFootRow(table, null);
    }

    private void appendFootRow(KDTable table, String columnKey) {
        if (this.tableToSumIndex.size() == 0) {
            return;
        }
        this.ConvertKeyToIndex(table);
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (Map.Entry entry : this.tableToSumIndex.entrySet()) {
            KDTable tableSum = (KDTable)entry.getKey();
            String[] field = (String[])entry.getValue();
            if (tableSum == null || field == null || table != null && table != tableSum) continue;
            columnMap.clear();
            for (int j = 0; j < field.length; ++j) {
                int keyIndex;
                if (field[j] == null || tableSum.getColumn(keyIndex = Integer.parseInt(field[j].split("@")[0])) == null || columnKey != null && !tableSum.getColumnKey(keyIndex).equals(columnKey)) continue;
                BigDecimal dbSum = new BigDecimal("0");
                for (int r = 0; r < tableSum.getRowCount(); ++r) {
                    if (tableSum.getRow(r).getStyleAttributes().isHided()) continue;
                    ICell cell = tableSum.getRow(r).getCell(keyIndex);
                    String cellValue = tableSum.getCellDisplayText(cell);
                    if (cellValue != null) {
                        cellValue = cellValue.toString().replaceAll(",", "");
                    }
                    if (!StringUtility.isNumber((String)cellValue)) {
                        Object cellObj = cell.getValue();
                        if (cellObj != null) {
                            cellValue = cellObj.toString();
                        }
                        if (!StringUtility.isNumber((String)cellValue)) continue;
                    }
                    BigDecimal bigdem = new BigDecimal(String.valueOf(cellValue).trim());
                    dbSum = dbSum.add(bigdem);
                }
                String strSum = dbSum.toString();
                columnMap.put(field[j], strSum);
            }
            if (columnMap.size() <= 0) continue;
            IRow footRow = null;
            KDTFootManager footRowManager = tableSum.getFootManager();
            if (footRowManager == null) {
                footRowManager = new KDTFootManager(tableSum);
                footRowManager.addFootView();
                tableSum.setFootManager(footRowManager);
            }
            if ((footRow = footRowManager.getFootRow(0)) == null) {
                int colIndex = -1;
                footRow = footRowManager.addFootRow(0);
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                tableSum.getIndexColumn().setWidthAdjustMode((short)1);
                tableSum.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
                footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
                for (Map.Entry colEntry : columnMap.entrySet()) {
                    if (colEntry.getKey() == null) continue;
                    String[] colArray = String.valueOf(colEntry.getKey()).split("@");
                    colIndex = Integer.parseInt(colArray[0]);
                    footRow.getCell(colIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                    footRow.getCell(colIndex).getStyleAttributes().setFontColor(Color.BLACK);
                }
            }
            for (Map.Entry colEntry : columnMap.entrySet()) {
                int colIndex = Integer.parseInt(String.valueOf(colEntry.getKey()).split("@")[0]);
                String colValue = (String)colEntry.getValue();
                if (!StringUtils.isEmpty((String)colValue)) {
                    try {
                        BigDecimal bd = new BigDecimal(colValue.trim());
                        StringBuffer formatStr = new StringBuffer("%{0");
                        if (bd.scale() > 0) {
                            formatStr.append(".");
                            int size = bd.scale();
                            for (int i = 0; i < size; ++i) {
                                formatStr.append("#");
                            }
                        }
                        formatStr.append("}f");
                        footRow.getCell(colIndex).getStyleAttributes().setNumberFormat(formatStr.toString());
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        footRow.getCell(colIndex).getStyleAttributes().setNumberFormat("%{0.##########}f");
                    }
                }
                footRow.getCell(colIndex).setValue((Object)colValue);
            }
        }
    }

    @Override
    public void setTableToSumField() {
    }

    @Override
    public void setTableToSumField(KDTable table, String[] columnFields) {
        if (this.tableToSumField.get(table) != null && columnFields != null) {
            Object[] sumFieldName = this.getSumFieldName(columnFields);
            Object[] sumField = (String[])this.tableToSumField.get(table);
            String[] allSumField = (String[])ArrayUtils.addAll((Object[])sumFieldName, (Object[])sumField);
            HashSet<String> set = new HashSet<String>(Arrays.asList(allSumField));
            ArrayList<String> list = new ArrayList<String>(set);
            list.remove(null);
            allSumField = list.toArray(new String[list.size()]);
            this.tableToSumField.put(table, allSumField);
            this.tableKeyToIndex(table, allSumField, this.tableToSumIndex);
            this.addTablePropertyList(table);
        } else {
            this.tableToSumField.put(table, columnFields);
            this.tableKeyToIndex(table, columnFields, this.tableToSumIndex);
            this.addTablePropertyList(table);
        }
    }

    private void ConvertKeyToIndex(KDTable table) {
        if (this.tableToSumField.containsKey(table)) {
            this.tableToSumIndex.remove(table);
            this.tableKeyToIndex(table, (String[])this.tableToSumField.get(table), this.tableToSumIndex);
        }
    }

    private String[] getSumFieldName(String[] columnFields) {
        if (columnFields != null) {
            String[] sumFieldName = new String[columnFields.length];
            for (int i = 0; i < columnFields.length; ++i) {
                String fieldName;
                if (columnFields[i] == null) continue;
                sumFieldName[i] = columnFields[i].indexOf("@") == -1 ? columnFields[i] : (fieldName = columnFields[i].substring(0, columnFields[i].indexOf("@")));
            }
            return sumFieldName;
        }
        return null;
    }

    private void tableKeyToIndex(KDTable table, String[] columnFields, Map indexMap) {
        if (columnFields != null) {
            String[] indexField = new String[columnFields.length];
            for (int i = 0; i < columnFields.length; ++i) {
                if (columnFields[i] == null) continue;
                String[] fieldKey = columnFields[i].split("@");
                int index = table.getColumnIndex(fieldKey[0]);
                indexField[i] = fieldKey.length > 1 ? index + "@" + fieldKey[1] : String.valueOf(index);
            }
            indexMap.put(table, indexField);
        }
    }

    public void addPropertyListener() {
        for (Map.Entry entry : this.tablePropertyListener.entrySet()) {
            KDTable tableSum = (KDTable)entry.getKey();
            KDTPropertyChangeListener listener = (KDTPropertyChangeListener)entry.getValue();
            tableSum.addKDTPropertyChangeListener(listener);
            this.appendFootRow(tableSum);
        }
    }

    public void removePropertyListener() {
        for (Map.Entry entry : this.tablePropertyListener.entrySet()) {
            KDTable tableSum = (KDTable)entry.getKey();
            KDTPropertyChangeListener listener = (KDTPropertyChangeListener)entry.getValue();
            tableSum.removeKDTPropertyChangeListener(listener);
        }
    }

    private void addTablePropertyList(final KDTable table) {
        KDTPropertyChangeListener propertyChangeListener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                int columnIndex;
                String colKey;
                if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue") && (colKey = table.getColumn(columnIndex = evt.getColIndex()).getKey()) != null) {
                    for (Map.Entry entry : TotalLineHandler.this.tableToSumField.entrySet()) {
                        KDTable tableSum = (KDTable)entry.getKey();
                        String[] fields = (String[])entry.getValue();
                        if (fields == null) continue;
                        for (int i = 0; i < fields.length; ++i) {
                            String[] colArray;
                            if (fields[i] == null || !(colArray = fields[i].split("@"))[0].equalsIgnoreCase(colKey)) continue;
                            TotalLineHandler.this.appendFootRow(tableSum, colKey);
                        }
                    }
                }
            }
        };
        table.addKDTPropertyChangeListener(propertyChangeListener);
        this.tablePropertyListener.put(table, propertyChangeListener);
    }

    public final void setFootFontColor(KDTable table, int rowIndex, String[] columnName, Color fontColor) {
        if (this.tableToSumField.get(table) != null) {
            List<Object> listColumn = null;
            if (fontColor == null) {
                return;
            }
            if (rowIndex <= -1) {
                rowIndex = 0;
            }
            if (columnName == null) {
                columnName = (String[])this.tableToSumField.get(table);
            }
            listColumn = new ArrayList(columnName.length);
            listColumn = Arrays.asList(columnName);
            KDTFootManager footRowManager = table.getFootManager();
            if (footRowManager != null) {
                IRow row = footRowManager.getFootRow(rowIndex);
                int columnCount = table.getColumnCount();
                for (int c = 0; c < columnCount; ++c) {
                    String fieldName = table.getColumn(c).getFieldName();
                    if (listColumn != null && !listColumn.contains(fieldName)) continue;
                    ICell cell = row.getCell(c);
                    cell.getStyleAttributes().setFontColor(fontColor);
                }
            }
        }
    }

    public void restoreAllTableListener(Class type, Map<KDTable, EventListener[]> AllTableListener) {
        if (AllTableListener == null || AllTableListener.size() == 0) {
            return;
        }
        for (Map.Entry<KDTable, EventListener[]> entry : AllTableListener.entrySet()) {
            KDTable detail = entry.getKey();
            if (detail == null) continue;
            EventListener[] lists = AllTableListener.get(detail);
            this.restoreTableListeners(type, detail, lists);
        }
    }

    public void restoreTableListeners(Class type, KDTable detail, EventListener[] lists) {
        if (detail != null) {
            EventListenerList eventList = detail.getListenerList();
            for (int i = 0; i < lists.length; ++i) {
                eventList.add(type, lists[i]);
            }
        }
    }

    public EventListener[] removeTablePropertyChangeListener(KDTable detail, Class type) {
        if (detail != null) {
            EventListenerList eventList = detail.getListenerList();
            EventListener[] lists = eventList.getListeners(type);
            if (lists != null) {
                for (int i = 0; i < lists.length; ++i) {
                    eventList.remove(type, lists[i]);
                }
            }
            return lists;
        }
        return null;
    }

    @Override
    public void removeFootRow() {
        if (this.tableToSumField.size() == 0) {
            return;
        }
        for (Map.Entry entry : this.tableToSumField.entrySet()) {
            KDTable tableSum = (KDTable)entry.getKey();
            if (tableSum == null || tableSum.getFootManager() == null || tableSum.getFootManager().getFoot() == null) continue;
            tableSum.getFootManager().getFoot().removeRow(0);
        }
    }
}

