/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.SACalcParamInfo;
import com.kingdee.eas.mm.control.SARuleEnum;
import com.kingdee.eas.mm.control.SATransactionEnum;
import com.kingdee.eas.mm.control.app.Field.StockAllocationAppFieldName;
import com.kingdee.eas.mm.control.app.util.StockAllocationUtil;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStockOperation
implements StockAllocationAppFieldName {
    private EntityViewInfo viewInfo;
    private Context context;
    private List keyIdList;
    private Map precisionMap;
    private StringBuffer precisionSql;
    private SACalcParamInfo calcParam;
    private SARuleEnum sARuleEnum;
    private SATransactionEnum sATransactionEnum;
    private Map receiptQtyMap;
    private String storageUnitId;
    private Set storeTypeID = new HashSet();
    private Set storeStatusID = new HashSet();
    private StorageOrgUnitInfo storageOrgUnitInfo;
    protected Map storagetQtyMap = new HashMap();
    protected Map transferBatchMap = new HashMap();
    protected Map stockReserveMap = new HashMap();
    protected Map stockSimulateMap = new HashMap();
    protected Map invMap = new HashMap();
    protected Map transferQtyMap = new HashMap();
    protected Map transferNoBatchQtyMap = new HashMap();
    protected Map sAStockMap;
    protected Map stIdDestEntryIdMap = new HashMap();

    public StorageOrgUnitInfo getStorageOrgUnitInfo() {
        return this.storageOrgUnitInfo;
    }

    public void setViewInfo(EntityViewInfo viewInfo) {
        this.viewInfo = viewInfo;
    }

    public EntityViewInfo getViewInfo() {
        return this.viewInfo;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public Map getPrecisionMap() {
        return this.precisionMap;
    }

    public void setPrecisionMap(Map precisionMap) {
        this.precisionMap = precisionMap;
    }

    public List getKeyIdList() {
        return this.keyIdList;
    }

    public SACalcParamInfo getCalcParam() {
        return this.calcParam;
    }

    public SARuleEnum getSARuleEnum() {
        return this.sARuleEnum;
    }

    public SATransactionEnum getSATransactionEnum() {
        return this.sATransactionEnum;
    }

    public Map getReceiptQtyMap() {
        return this.receiptQtyMap;
    }

    public String getStorageUnitId() {
        return this.storageUnitId;
    }

    public Set getStoreTypeID() {
        return this.storeTypeID;
    }

    public void setStoreTypeID(String storeTypeID) {
        if (!this.storeTypeID.contains(storeTypeID)) {
            this.storeTypeID.add(storeTypeID);
        }
    }

    public Set getStoreStatusID() {
        return this.storeStatusID;
    }

    public void setStoreStatusID(String storeStatusID) {
        if (!this.storeStatusID.contains(storeStatusID)) {
            this.storeStatusID.add(storeStatusID);
        }
    }

    protected AbstractStockOperation() {
        this.keyIdList = new ArrayList();
        this.precisionSql = new StringBuffer();
    }

    protected AbstractStockOperation(SACalcParamInfo calcParam, SARuleEnum sARuleEnum, SATransactionEnum sATransactionEnum, Map sASourceReQtyMap, String storageUnitId) {
        this.calcParam = calcParam;
        this.sARuleEnum = sARuleEnum;
        this.sATransactionEnum = sATransactionEnum;
        this.receiptQtyMap = sASourceReQtyMap;
        this.storageUnitId = storageUnitId;
    }

    protected Set getBillStatusSet() {
        return this.calcParam.getBaseStatus();
    }

    protected List SourceList(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, List orderIds, int Rule) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        String ids = this.getStrIds(orderIds);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(StockAllocationUtil.getSelectors());
        viewInfo.setFilter(this.getFilter(storageOrgUnitInfo, ids));
        viewInfo.setSorter(this.getSorter());
        this.setViewInfo(viewInfo);
        return resultList;
    }

    protected Object[] GetStockColl(Context ctx, ProductionOrderCollection ptOrderCollection) throws BOSException, EASBizException {
        Object[] objects = new Object[2];
        return objects;
    }

    protected Map Calculate(Context ctx, ProductionOrderCollection ptOrderCollection, ProductionOrderStockEntryCollection ptOrderStockCollection) throws BOSException, EASBizException, SQLException {
        this.setContext(ctx);
        return null;
    }

    protected String getStrIds(AbstractObjectCollection collection) {
        if (collection != null) {
            StringBuffer st = new StringBuffer();
            for (SCMBillBaseInfo info : collection) {
                st.append("'");
                st.append(info.getId());
                st.append("'");
                st.append(",");
            }
            return st.substring(0, st.toString().length() - 1);
        }
        return "";
    }

    private String getStrIds(List orderIds) {
        StringBuffer st = new StringBuffer();
        if (orderIds != null && orderIds.size() > 0) {
            for (String orderId : orderIds) {
                st.append(orderId);
                st.append(",");
            }
            return st.substring(0, st.toString().length() - 1);
        }
        return "";
    }

    private FilterInfo getFilter(StorageOrgUnitInfo storageOrgUnitInfo, String ids) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemCollection = filter.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        if (storageOrgUnitInfo != null) {
            filterItemCollection.add(new FilterItemInfo("storageOrgUnit", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private SorterItemCollection getSorter() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("startDate"));
        sorter.add(new SorterItemInfo("number"));
        return sorter;
    }

    protected void buildSql(String materialId, String unitId) {
        StringBuffer key = new StringBuffer();
        key.append(materialId);
        key.append(unitId);
        if (!this.getKeyIdList().contains(key.toString())) {
            this.keyIdList.add(key.toString());
            if (this.precisionSql.length() > 0) {
                this.precisionSql.append("or ");
            }
            this.precisionSql.append("(material.id = '").append(materialId).append("' and measureUnit.id = '").append(unitId).append("' ) ");
        }
    }

    protected void executePrecisionSql(Context ctx) throws BOSException {
        MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(" where " + this.precisionSql.toString());
        int precision = 0;
        String materialId = "";
        String unitId = "";
        String key = "";
        HashMap<String, Integer> precisionMap = new HashMap<String, Integer>();
        for (int i = 0; i < mmuc.size(); ++i) {
            precision = mmuc.get(i).getQtyPrecision();
            materialId = mmuc.get(i).getMaterial().getId().toString();
            unitId = mmuc.get(i).getMeasureUnit().getId().toString();
            key = materialId + unitId;
            precisionMap.put(key, new Integer(precision));
        }
        this.setPrecisionMap(precisionMap);
    }

    protected Map getMeasureUnitMapByStockColl(ProductionOrderStockEntryCollection stockCollection) throws BOSException {
        if (stockCollection == null || stockCollection.size() <= 0) {
            return null;
        }
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> measureUnitSet = new HashSet<String>();
        HashMap<String, MultiMeasureUnitInfo> multiMeasureUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
        for (int i = 0; i < stockCollection.size(); ++i) {
            ProductionOrderStockEntryInfo stockInfo = stockCollection.get(i);
            materialSet.add(stockInfo.getMaterial().getId().toString());
            measureUnitSet.add(stockInfo.getUnit().getId().toString());
            measureUnitSet.add(stockInfo.getBaseUnit() != null ? stockInfo.getBaseUnit().getId().toString() : stockInfo.getMaterial().getBaseUnit().getId().toString());
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.context);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", measureUnitSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        MultiMeasureUnitCollection multiMeasureUntiColl = multiUnit.getMultiMeasureUnitCollection(view);
        if (multiMeasureUntiColl != null && multiMeasureUntiColl.size() > 0) {
            for (int i = 0; i < multiMeasureUntiColl.size(); ++i) {
                MultiMeasureUnitInfo multiMeasureUnitInfo = multiMeasureUntiColl.get(i);
                String materialId = multiMeasureUnitInfo.getMaterial().getId().toString();
                String measureUnitId = multiMeasureUnitInfo.getMeasureUnit().getId().toString();
                multiMeasureUnitMap.put(materialId + measureUnitId, multiMeasureUnitInfo);
            }
        }
        return multiMeasureUnitMap;
    }

    protected BigDecimal getExchangePrecisionQty(Map multiMeasureUnitMap, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) {
        String otherUnitId;
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        if (unitInfo == null || otherUnitInfo == null) {
            return null;
        }
        String unitId = unitInfo.getId().toString();
        if (unitId.equals(otherUnitId = otherUnitInfo.getId().toString())) {
            return qty;
        }
        MultiMeasureUnitInfo multiUnifInfo = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(materialID + unitId);
        MultiMeasureUnitInfo othermultiUnifInfo = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(materialID + otherUnitId);
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, 16, 4);
        }
        return targetQty;
    }

    private boolean isTransferBatch() {
        return this.calcParam.getIsExportBatch().equals("true");
    }

    protected BigDecimal getTranferBatchQty(BigDecimal bsReceiptQty, BigDecimal transferBatchBaseQty) {
        if (!this.isTransferBatch() || transferBatchBaseQty.signum() <= 0) {
            return bsReceiptQty;
        }
        BigDecimal subtractDivdeTrabatch = bsReceiptQty.divide(transferBatchBaseQty, 0, 0);
        return subtractDivdeTrabatch.multiply(transferBatchBaseQty);
    }

    protected void mapId(Map resutlMap, String ptStockInfoId, String stInfoId) {
        if (resutlMap.get("idMap") == null) {
            resutlMap.put("idMap", new HashMap());
            Map idMap = (Map)resutlMap.get("idMap");
            idMap.put(ptStockInfoId, stInfoId);
            idMap.put(stInfoId, ptStockInfoId);
        } else {
            Map idMap = (Map)resutlMap.get("idMap");
            idMap.put(ptStockInfoId, stInfoId);
            idMap.put(stInfoId, ptStockInfoId);
        }
    }

    protected MeasureUnitInfo getMaterialUnit(SCMBillEntryBaseInfo StockInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)StockInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("productUnit.id"));
        selector.add(new SelectorItemInfo("productUnit.name"));
        selector.add(new SelectorItemInfo("productUnit.number"));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        viewer.setSelector(selector);
        MaterialPlanCollection plans = MaterialPlanFactory.getLocalInstance((Context)this.context).getMaterialPlanCollection(viewer);
        if (plans != null && plans.size() > 0) {
            MaterialPlanInfo planInfo = plans.get(0);
            return planInfo.getProductUnit();
        }
        return null;
    }

    protected void DeleteDestBill(Context ctx, Map billMap) throws BOSException, EASBizException {
        IObjectPK[] idArray;
        TransferOrderBillCollection toCollection = (TransferOrderBillCollection)billMap.get("transferOrderBillCollection");
        StockTransferBillCollection stCollection = (StockTransferBillCollection)billMap.get("stockTransferBillCollection");
        BOTRelationCollection botCol = (BOTRelationCollection)billMap.get("botRelationCollection");
        BOTRelationEntryCollection botEntryCol = (BOTRelationEntryCollection)billMap.get("botRelationEntryCollection");
        ITransferOrderBill transferOrderBill = TransferOrderBillFactory.getLocalInstance((Context)ctx);
        IStockTransferBill stockTransferBill = StockTransferBillFactory.getLocalInstance((Context)ctx);
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        if (botEntryCol != null && botEntryCol.size() > 0) {
            StringBuffer idStrs = new StringBuffer();
            for (int i = 0; i < botEntryCol.size(); ++i) {
                BOTRelationEntryInfo boEntryInfo = botEntryCol.get(i);
                idStrs.append("'" + boEntryInfo.getId().toString() + "', ");
            }
            String idStr = idStrs.toString().trim().substring(0, idStrs.toString().trim().length() - 1);
            String delSQL = "delete from  t_bot_relationentry where FID in (" + idStr + ")";
            DbUtil.execute((Context)ctx, (String)delSQL);
        }
        if (botCol != null && botCol.size() > 0) {
            for (int i = 0; i < botCol.size(); ++i) {
                BOTRelationInfo boInfo = botCol.get(i);
                botRelation.delete((IObjectPK)new ObjectUuidPK(boInfo.getId()));
            }
        }
        if (toCollection != null && toCollection.size() > 0) {
            idArray = new IObjectPK[toCollection.size()];
            for (int i = 0; i < toCollection.size(); ++i) {
                TransferOrderBillInfo toInfo = toCollection.get(i);
                this.pubFireVOChangeListener(ctx, toInfo.getId().toString(), true);
                idArray[i] = new ObjectUuidPK(toInfo.getId());
                if (transferOrderBill.exists(idArray[i])) {
                    transferOrderBill.delete(idArray[i]);
                }
                this.pubFireVOChangeListener(ctx, toInfo.getId().toString(), false);
            }
        }
        if (stCollection != null && stCollection.size() > 0) {
            idArray = new IObjectPK[stCollection.size()];
            for (int i = 0; i < stCollection.size(); ++i) {
                StockTransferBillInfo stInfo = stCollection.get(i);
                this.pubFireVOChangeListener(ctx, stInfo.getId().toString(), true);
                idArray[i] = new ObjectUuidPK(stInfo.getId());
                if (stockTransferBill.exists(idArray[i])) {
                    stockTransferBill.delete(idArray[i]);
                }
                this.pubFireVOChangeListener(ctx, stInfo.getId().toString(), false);
            }
        }
    }

    private void pubFireVOChangeListener(Context ctx, String id, boolean isLock) throws BOSException, EASBizException {
        String dcName;
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String string = dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
        if (isLock) {
            if (!iMutexServiceControl.requestObjIDForUpdate(id, SysContext.getSysContext().getUserName(), dcName)) {
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
        } else if (iMutexServiceControl.requestObjIDForUpdate(id, SysContext.getSysContext().getUserName(), dcName)) {
            iMutexServiceControl.releaseObjIDForUpdate(id);
        }
    }

    protected Map PrepareDestBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        this.context = ctx;
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)paramMap.get("storageOrgUnitInfo");
        return resultMap;
    }

    protected BizTypeInfo getBizTypeInfoById(String id) throws BOSException, EASBizException {
        IBizType bizType = BizTypeFactory.getLocalInstance((Context)this.context);
        BizTypeInfo bizTypeInfo = bizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        return bizTypeInfo;
    }

    protected int generateDestBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        boolean flag = true;
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)paramMap.get("storageOrgUnitInfo");
        String transferOrderPermission = "transferorder_new";
        String stockTransferPermission = "stocktransfer_new";
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK storagePk = new ObjectUuidPK(this.storageOrgUnitInfo.getId());
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        TransferOrderBillCollection toCollection = (TransferOrderBillCollection)paramMap.get("transferOrderBillCollection");
        StockTransferBillCollection stCollection = (StockTransferBillCollection)paramMap.get("stockTransferBillCollection");
        BOTRelationCollection botCol = (BOTRelationCollection)paramMap.get("botRelationCollection");
        BOTRelationEntryCollection botEntryCol = (BOTRelationEntryCollection)paramMap.get("botRelationEntryCollection");
        ITransferOrderBill transferOrderBill = TransferOrderBillFactory.getLocalInstance((Context)ctx);
        IStockTransferBill stockTransferBill = StockTransferBillFactory.getLocalInstance((Context)ctx);
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        int x = 0;
        if (toCollection != null && toCollection.size() > 0) {
            ipermission.checkFunctionPermission(userPK, (IObjectPK)storagePk, transferOrderPermission);
            for (int i = 0; i < toCollection.size(); ++i) {
                TransferOrderBillInfo toInfo = toCollection.get(i);
                this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(toInfo.getId()), (IObjectValue)toInfo, BOSObjectType.create((String)"5C2A1F0C"));
                if (!transferOrderBill.exists((IObjectPK)new ObjectUuidPK(toInfo.getId()))) {
                    transferOrderBill.save((CoreBaseInfo)toInfo);
                    continue;
                }
                flag = false;
                ++x;
            }
        }
        int y = 0;
        if (stCollection != null && stCollection.size() > 0) {
            ipermission.checkFunctionPermission(userPK, (IObjectPK)storagePk, stockTransferPermission);
            for (int i = 0; i < stCollection.size(); ++i) {
                StockTransferBillInfo stInfo = stCollection.get(i);
                this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(stInfo.getId()), (IObjectValue)stInfo, BOSObjectType.create((String)"2239F30A"));
                if (!stockTransferBill.exists((IObjectPK)new ObjectUuidPK(stInfo.getId()))) {
                    stockTransferBill.save((CoreBaseInfo)stInfo);
                    continue;
                }
                flag = false;
                ++y;
            }
        }
        if (botCol != null && botCol.size() > 0) {
            for (int i = 0; i < botCol.size(); ++i) {
                BOTRelationInfo boInfo = botCol.get(i);
                if (botRelation.exists((IObjectPK)new ObjectUuidPK(boInfo.getId()))) continue;
                botRelation.addnew(boInfo);
            }
        }
        if (botEntryCol != null && botEntryCol.size() > 0) {
            Connection conn = null;
            PreparedStatement batchStatement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                String batchStatementSql = "insert into t_bot_relationentry(FID,FSRCOBJECTID,FDESTOBJECTID,FSRCENTRYID,FDESTENTRYID,FSRCENTRYPROPNAME,FDESTENTRYPROPNAME,FSRCPROPERTYNAME,FDESTPROPERTYNAME,FVALUE,FKEYID) values (?,?,?,?,?,?,?,?,?,?,?)";
                batchStatement = conn.prepareStatement(batchStatementSql);
                for (int i = 0; i < botEntryCol.size(); ++i) {
                    BOTRelationEntryInfo boInfo = botEntryCol.get(i);
                    if (this.isRelationEntry(ctx, boInfo.getId().toString())) continue;
                    batchStatement.setString(1, boInfo.getId().toString());
                    batchStatement.setString(2, boInfo.getSrcObjectID());
                    batchStatement.setString(3, boInfo.getDestObjectID());
                    batchStatement.setString(4, boInfo.getSrcEntryID());
                    batchStatement.setString(5, boInfo.getDestEntryID());
                    batchStatement.setString(6, boInfo.getSrcEntryPropName());
                    batchStatement.setString(7, boInfo.getDestEntryPropName());
                    batchStatement.setString(8, boInfo.getSrcPropertyName());
                    batchStatement.setString(9, boInfo.getDestPropertyName());
                    batchStatement.setString(10, boInfo.getValue());
                    batchStatement.setString(11, boInfo.getRelation() != null ? boInfo.getRelation().getId().toString() : botCol.get(0).getId().toString());
                    batchStatement.addBatch();
                }
                batchStatement.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException(e.getMessage());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
        int iResult = 0;
        if (!flag) {
            iResult = x == toCollection.size() && y == stCollection.size() ? 1 : 2;
        }
        return iResult;
    }

    private boolean isRelationEntry(Context ctx, String relationEntryID) throws BOSException {
        String idSQL = "SELECT * FROM t_bot_relationentry WHERE FID='" + relationEntryID + "'";
        IRowSet idRs = DbUtil.executeQuery((Context)ctx, (String)idSQL);
        return idRs.size() > 0;
    }

    protected boolean checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model, BOSObjectType bosType) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (this.isSameNumber(ctx, pk, model, bosType)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{aSCMBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model, BOSObjectType bosType) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return StoreCommonUtil.exists((Context)ctx, (FilterInfo)filter, (BOSObjectType)bosType);
    }

    protected Map GetStockDataPrecision(Context ctx, ProductionOrderCollection ptOrderCollection) throws BOSException, EASBizException, SQLException {
        this.setContext(ctx);
        return null;
    }
}

