/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.util.ProductionStrategyHelper;
import com.kingdee.eas.mm.common.util.TransactionTypeHelper;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.FinishedRptCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryInfo;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.ProductionOrderException;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.app.AbstractFinishedRptFacadeControllerBean;
import com.kingdee.eas.mm.control.app.PoMaterialWithDraw;
import com.kingdee.eas.mm.control.util.FinishedRptUtil;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinishedRptFacadeControllerBean
extends AbstractFinishedRptFacadeControllerBean {
    private Map scmSubmitAuditParam = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.FinishedRptFacadeControllerBean");

    @Override
    protected void _backFlush(Context ctx, IObjectCollection finishedColls) throws BOSException, EASBizException {
        FinishedRptCollection colls = (FinishedRptCollection)finishedColls;
        FinishedRptInfo finishedInfo = null;
        ArrayList<String> sqlList = new ArrayList<String>();
        HashSet<String> materialIds = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            finishedInfo = colls.get(i);
            FinishedRptEntryCollection entryColls = finishedInfo.getEntrys();
            for (int j = 0; j < entryColls.size(); ++j) {
                FinishedRptEntryInfo entryInfo = entryColls.get(j);
                if (entryInfo.getOutputType().getValue() != 10710) continue;
                materialIds.add(entryInfo.getMaterial().getId().toString());
            }
            ProductionOrderStockEntryCollection sEntryColls = finishedInfo.getProductionOrder().getStockEntry();
            for (int j = 0; j < sEntryColls.size(); ++j) {
                if (!sEntryColls.get(j).isIsBackFlush()) continue;
                materialIds.add(sEntryColls.get(j).getMaterial().getId().toString());
            }
        }
        MultiMeasureUnitCollection multColls = this.getMultiMeasureUnit(ctx, materialIds);
        ArrayList<String> prdIdList = new ArrayList<String>();
        try {
            if (WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().disableEventListener();
            }
            for (int i = 0; i < colls.size(); ++i) {
                finishedInfo = colls.get(i);
                String productionOrderId = finishedInfo.getProductionOrder().getId().toString();
                prdIdList.add(productionOrderId);
                ProductionOrderInfo productionOrderInfo = finishedInfo.getProductionOrder();
                BigDecimal baseBackFlushTotalQty = productionOrderInfo.getBaseBackFlushTotalQty();
                if (baseBackFlushTotalQty == null) {
                    baseBackFlushTotalQty = new BigDecimal(String.valueOf(0.0));
                }
                BigDecimal[] commitQty = this.calculateMainCommitQty(ctx, finishedInfo, productionOrderInfo, multColls);
                ProductionOrderStockEntryCollection stockEntrys = this.calculateSendOutQty(ctx, productionOrderInfo, commitQty[1], multColls);
                IMaterialReqBill iMaterialReqBill = MaterialReqBillFactory.getLocalInstance((Context)ctx);
                MaterialReqBillInfo materialReqBillInfo = this.transform(ctx, iMaterialReqBill, finishedInfo, productionOrderInfo, stockEntrys);
                materialReqBillInfo = (MaterialReqBillInfo)MaterialReqBillFactory.getLocalInstance((Context)ctx).matchLotInfo((InvBillBaseInfo)materialReqBillInfo);
                IObjectPK pk = iMaterialReqBill.submit((CoreBaseInfo)materialReqBillInfo);
                boolean isAutoAudit = false;
                String billTypeId = materialReqBillInfo.getBillType().getId().toString();
                String orgUnitID = materialReqBillInfo.getStorageOrgUnit().getId().toString();
                String strAutoAudit = this.getScmSubmitAuditParam(ctx, orgUnitID, billTypeId);
                if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                    isAutoAudit = true;
                }
                if (!isAutoAudit) {
                    iMaterialReqBill.bachLoopAduit(new IObjectPK[]{pk});
                }
                StringBuffer sqlStr = new StringBuffer("update T_MM_ProductionOrder set FBackFlushTotalQty = FBackFlushTotalQty +" + commitQty[0]);
                sqlStr.append(",FBaseBackFlushTotalQty = FBaseBackFlushTotalQty +" + commitQty[1]);
                sqlStr.append(" where FID = '" + productionOrderId + "'");
                sqlList.add(sqlStr.toString());
                String relationID = BOSUuid.create((String)new BOTRelationInfo().getBOSType().toString()).toString();
                sqlStr = new StringBuffer();
                sqlStr.append("insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE)");
                sqlStr.append(" values ('" + relationID + "','" + new FinishedRptInfo().getBOSType().toString() + "','" + new MaterialReqBillInfo().getBOSType().toString() + "','" + finishedInfo.getId().toString() + "','" + pk.toString() + "',now(),'" + ctx.getUserName() + "',1,null,0)");
                sqlList.add(sqlStr.toString());
                relationID = BOSUuid.create((String)new BOTRelationInfo().getBOSType().toString()).toString();
                sqlStr = new StringBuffer();
                sqlStr.append("insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE)");
                sqlStr.append(" values ('" + relationID + "','" + new ProductionOrderInfo().getBOSType().toString() + "','" + new MaterialReqBillInfo().getBOSType().toString() + "','" + finishedInfo.getProductionOrder().getId().toString() + "','" + pk.toString() + "',now(),'" + ctx.getUserName() + "',1,null,0)");
                sqlList.add(sqlStr.toString());
                Iterator iter = stockEntrys.iterator();
                while (iter.hasNext()) {
                    ProductionOrderStockEntryInfo element = (ProductionOrderStockEntryInfo)iter.next();
                    sqlStr = new StringBuffer();
                    sqlStr.append("update T_MM_ProductionOrderSEntry set FSendOutTotalQty = FSendOutTotalQty + " + element.getSendOutTotalQty());
                    sqlStr.append(",FBaseSendOutTotalQty = FBaseSendOutTotalQty +" + element.getBaseSendOutTotalQty());
                    sqlStr.append(" where fid = '" + element.getId().toString() + "'");
                    sqlList.add(sqlStr.toString());
                }
                sqlStr = new StringBuffer();
                sqlStr.append("update T_MM_FinishedRpt set FIsBackFlushed = 1 where fid = '" + finishedInfo.getId().toString() + "'");
                sqlList.add(sqlStr.toString());
            }
            DBBatchUtil.executeBatch((Context)ctx, sqlList);
            ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(prdIdList, true);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        finally {
            if (!WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    private BigDecimal[] calculateMainCommitQty(Context ctx, FinishedRptInfo finishedRpt, ProductionOrderInfo productionOrder, MultiMeasureUnitCollection multColls) throws BOSException, EASBizException {
        if (null == finishedRpt || null == productionOrder) {
            throw new BOSException(FinishedRptUtil.getResource("finishedOrOrderNull", ctx));
        }
        BigDecimal commitQty = new BigDecimal(String.valueOf(0.0));
        BigDecimal baseCommitQty = new BigDecimal(String.valueOf(0.0));
        FinishedRptEntryCollection entrys = finishedRpt.getEntrys();
        if (null != entrys && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                FinishedRptEntryInfo item = entrys.get(i);
                if (item == null || item.getOutputType() == null || item.getOutputType().getValue() != 10710 || null == item.getBaseCommtQty()) continue;
                baseCommitQty = baseCommitQty.add(item.getBaseCommtQty());
            }
        }
        HashSet<String> materialIds = new HashSet<String>();
        materialIds.add(productionOrder.getMaterial().getId().toString());
        if (null != baseCommitQty) {
            commitQty = this.getExchangeQtyForServer(ctx, productionOrder.getMaterial().getId().toString(), productionOrder.getBaseUnit(), productionOrder.getUnit(), baseCommitQty, multColls);
        }
        return new BigDecimal[]{commitQty, baseCommitQty};
    }

    public ProductionOrderStockEntryCollection calculateSendOutQty(Context ctx, ProductionOrderInfo productionOrderInfo, BigDecimal mainProductBaseCommitQty, MultiMeasureUnitCollection multiUnitColls) throws EASBizException, BOSException {
        ProductionOrderStockEntryInfo stockEntryInfo;
        Iterator iter;
        ProductionOrderStockEntryCollection list = new ProductionOrderStockEntryCollection();
        if (null == productionOrderInfo || null == mainProductBaseCommitQty) {
            return list;
        }
        ProductionOrderStockEntryCollection stockEntrys = productionOrderInfo.getStockEntry();
        HashSet<String> stockMaterialIds = new HashSet<String>();
        if (null != stockEntrys && stockEntrys.size() > 0) {
            iter = stockEntrys.iterator();
            while (iter.hasNext()) {
                stockEntryInfo = (ProductionOrderStockEntryInfo)iter.next();
                stockMaterialIds.add(stockEntryInfo.getMaterial().getId().toString());
            }
            stockMaterialIds.add(productionOrderInfo.getMaterial().getId().toString());
        }
        if (null != stockEntrys && stockEntrys.size() > 0) {
            iter = stockEntrys.iterator();
            while (iter.hasNext()) {
                stockEntryInfo = (ProductionOrderStockEntryInfo)iter.next();
                BigDecimal sendOutQty = new BigDecimal(String.valueOf(0.0));
                BigDecimal sendOutBaseQty = new BigDecimal(String.valueOf(0.0));
                if (!stockEntryInfo.isIsBackFlush()) continue;
                sendOutBaseQty = mainProductBaseCommitQty.multiply(stockEntryInfo.getBaseQty()).divide(productionOrderInfo.getBaseQty(), 16, 4);
                sendOutQty = this.getExchangeQtyForServer(ctx, stockEntryInfo.getMaterial().getId().toString(), stockEntryInfo.getBaseUnit(), stockEntryInfo.getUnit(), sendOutBaseQty, multiUnitColls);
                sendOutBaseQty = sendOutBaseQty.divide(new BigDecimal("1"), stockEntryInfo.getBaseUnit().getQtyPrecision(), 4);
                if (!(sendOutQty.doubleValue() > 0.0)) continue;
                stockEntryInfo.setThisSendOutQty(sendOutQty);
                if (stockEntryInfo.getSendOutTotalQty() == null) {
                    stockEntryInfo.setSendOutTotalQty(new BigDecimal(String.valueOf(0.0)));
                }
                stockEntryInfo.setSendOutTotalQty(sendOutQty);
                stockEntryInfo.setBaseSendOutTotalQty(sendOutBaseQty);
                list.add(stockEntryInfo);
            }
        }
        return list;
    }

    public MultiMeasureUnitCollection getMultiMeasureUnit(Context ctx, Set materialIds) throws BOSException, EASBizException {
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("material.*");
        sic.add("measureUnit.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIds, CompareType.INCLUDE));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        env.setSelector(sic);
        MultiMeasureUnitCollection colls = multiUnit.getMultiMeasureUnitCollection(env);
        return colls;
    }

    public MaterialReqBillInfo transform(Context ctx, IMaterialReqBill iMaterialReqBill, FinishedRptInfo finishedRpt, ProductionOrderInfo productionOrderInfo, ProductionOrderStockEntryCollection stockEntrys) throws EASBizException, BOSException {
        MaterialReqBillInfo outBill = (MaterialReqBillInfo)iMaterialReqBill.createNewData(false);
        outBill.setSourceBillType(finishedRpt.getBillType());
        outBill.setAdminOrgUnit(finishedRpt.getWorkshop());
        outBill.setStorageOrgUnit(finishedRpt.getStorageOrgUnit());
        outBill.setBillType((BillTypeInfo)BillTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK("50957179-0105-1000-e000-0163c0a812fd463ED552")));
        outBill.setSourceBillId(finishedRpt.getId().toString());
        BOSUuid materialReqID = BOSUuid.create((String)"500AB75E");
        outBill.setId(materialReqID);
        CostObjectInfo coInfo = null;
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        String materialID = finishedRpt.getProductionOrder().getMaterial().getId().toString();
        CompanyOrgUnitInfo companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(finishedRpt.getStorageOrgUnit().getId());
        outBill.setSupplyStoreOrgUnit(finishedRpt.getStorageOrgUnit());
        outBill.setSupplyCompanyOrgUnit(companyOriUnitInfo);
        String lot = finishedRpt.getProductionOrder().getLotNo();
        if (companyOriUnitInfo != null) {
            coInfo = this.getDefaultCostObject(ctx, materialID, companyOriUnitInfo.getId().toString(), lot);
        }
        CostCenterOrgUnitInfo costCenter = finishedRpt.getProductionOrder().getProductLine().getCostCenterOrgUnit();
        TransactionTypeCollection ttiCol = TransactionTypeHelper.getTransactionType4MaterialReqOut((Context)ctx);
        TransactionTypeInfo tti = null;
        tti = ttiCol != null && ttiCol.size() == 1 ? ttiCol.get(0) : (TransactionTypeInfo)TransactionTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK("vLfUF0vKSKepVDxJN9eVQLAI3Kc="));
        outBill.setTransactionType(tti);
        outBill.setBizType((BizTypeInfo)BizTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK("0rSFjAEeEADgAAyMwKgSQiQHQ1w=")));
        BillTypeInfo productionOrderType = (BillTypeInfo)BillTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK("ejIZHXXTQliYCQJg9t4Re0Y+1VI="));
        BillTypeInfo finishedrptType = (BillTypeInfo)BillTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK("e3soUQaBR8un8D2R7UpNwkY+1VI="));
        outBill.setSourceBillType(finishedrptType);
        outBill.setIsBackflush(true);
        outBill.setCostCenterOrgUnit(costCenter);
        IDateOfMinDurability dateOfMD = DateOfMinDurabilityFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        InvUpdateTypeInfo ivtInfo = TransactionTypeHelper.getDefaultInvUpdateTypeByTransactionType((Context)ctx, (TransactionTypeInfo)tti);
        Iterator iter = stockEntrys.iterator();
        while (iter.hasNext()) {
            MaterialInventoryInfo info;
            ProductionOrderStockEntryInfo stockEntryInfo = (ProductionOrderStockEntryInfo)iter.next();
            MaterialReqBillEntryInfo outBillEntry = new MaterialReqBillEntryInfo();
            outBillEntry.setInvUpdateType(ivtInfo);
            outBillEntry.setWarehouse(stockEntryInfo.getDefaultWarehouse());
            if (stockEntryInfo.getDefaultWarehouse().isHasLocation()) {
                outBillEntry.setLocation(stockEntryInfo.getLocation());
            }
            outBillEntry.setCostObject(coInfo);
            outBillEntry.setSourceBillNumber(finishedRpt.getNumber());
            outBillEntry.setStorageOrgUnit(finishedRpt.getStorageOrgUnit());
            outBillEntry.setProductLine(finishedRpt.getProductLine());
            outBillEntry.setClassGroup(finishedRpt.getClassGroup());
            outBillEntry.setPerson(finishedRpt.getPerson());
            outBillEntry.setCostCenterOrgUnit(costCenter);
            outBillEntry.setAdminOrgUnit(finishedRpt.getWorkshop());
            if (ProductionStrategyHelper.isATO20orMTO20((Context)ctx, (String)stockEntryInfo.getMaterial().getId().toString(), (String)finishedRpt.getStorageOrgUnit().getId().toString())) {
                outBillEntry.setTraceNo(finishedRpt.getTraceNo());
                outBillEntry.setTrackNumber(finishedRpt.getTrackNumber());
            }
            outBillEntry.setMaterial(stockEntryInfo.getMaterial());
            outBillEntry.setUnit(stockEntryInfo.getUnit());
            outBillEntry.setBaseUnit(stockEntryInfo.getBaseUnit());
            outBillEntry.setIssueQty(stockEntryInfo.getThisSendOutQty());
            outBillEntry.setQty(stockEntryInfo.getThisSendOutQty());
            outBillEntry.setBaseQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)outBillEntry.getMaterial().getId().toString(), (MeasureUnitInfo)outBillEntry.getUnit(), (MeasureUnitInfo)outBillEntry.getBaseUnit(), (BigDecimal)outBillEntry.getQty()));
            outBillEntry.setProductLineWP(stockEntryInfo.getProductLineWP());
            outBillEntry.setPickingDate(new Timestamp(System.currentTimeMillis()));
            outBillEntry.setParent(outBill);
            outBillEntry.setOrderBillId(productionOrderInfo.getId().toString());
            outBillEntry.setOrderNumber(productionOrderInfo.getNumber());
            outBillEntry.setAssistUnit(stockEntryInfo.getMaterial().getAssistUnit());
            if (stockEntryInfo.getMaterial().getAssistUnit() != null) {
                outBillEntry.setAssistQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)outBillEntry.getMaterial().getId().toString(), (MeasureUnitInfo)outBillEntry.getUnit(), (MeasureUnitInfo)outBillEntry.getAssistUnit(), (BigDecimal)outBillEntry.getQty()));
            }
            if ((info = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(stockEntryInfo.getMaterial().getId().toString(), finishedRpt.getStorageOrgUnit().getId().toString())).isIsPeriodValid()) {
                oql.setLength(0);
                oql.append("select id,material,storageOrgUnit,lot,mfg,exp where ");
                oql.append("(storageOrgUnit = '").append(finishedRpt.getStorageOrgUnit().getId().toString()).append("' and ").append("material = '").append(stockEntryInfo.getMaterial().getId().toString()).append("' and ").append("lot = '").append(finishedRpt.getEntrys().get(0).getLotNo()).append("')");
                DateOfMinDurabilityCollection doc = dateOfMD.getDateOfMinDurabilityCollection(oql.toString());
                int size = doc.size();
                for (int i = 0; i < size; ++i) {
                    DateOfMinDurabilityInfo dod = doc.get(i);
                    outBillEntry.setMfg((Date)dod.getMfg());
                    outBillEntry.setExp((Date)dod.getExp());
                }
            }
            outBillEntry.setCoreBillNumber(productionOrderInfo.getNumber());
            outBillEntry.setCoreBillID(productionOrderInfo.getId().toString());
            outBillEntry.setCoreBillEntryID(stockEntryInfo.getId().toString());
            outBillEntry.setCoreBillType(productionOrderType);
            outBillEntry.setSourceBillType(finishedrptType);
            outBillEntry.setSourceBillId(finishedRpt.getId().toString());
            outBillEntry.setSourceBillEntryId(stockEntryInfo.getId().toString());
            outBillEntry.setSourceBillNumber(stockEntryInfo.getLineSeq());
            if ((productionOrderInfo.getMmBizType().equals((Object)BizTypeEnum.repair) || productionOrderInfo.getMmBizType().equals((Object)BizTypeEnum.rework)) && productionOrderInfo.getMaterial().getId().toString().equals(stockEntryInfo.getMaterial().getId().toString())) {
                outBillEntry.setIsReWork(true);
            } else {
                outBillEntry.setIsReWork(false);
            }
            outBill.getEntry().add(outBillEntry);
        }
        return outBill;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CostObjectInfo getDefaultCostObject(Context ctx, String materialId, String companyId, String lot) throws BOSException, EASBizException {
        CostObjectInfo costObjectInfo = null;
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = iMaterial.getCompanyInfo(materialId, companyId);
        if (aMaterialCompanyInfoInfo == null) return costObjectInfo;
        if (aMaterialCompanyInfoInfo.getAccountType() == null) return costObjectInfo;
        int countLot = 0;
        if ((lot == null || lot.length() == 0) && AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
            return costObjectInfo;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("select bill.fid as FID,bill.FCalculateMode as FCalculateMode");
        bf.append(" from T_BD_CostObject bill");
        bf.append(" inner join T_BD_CostObjectEntry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" where bill.FIsForbiden =0 and bill.FCompanyID=? and entry.FRelatedID=?");
        if (lot != null && lot.length() > 0 && AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
            bf.append(" and bill.FBatchNumber = ? ");
        }
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            String costId;
            block30: {
                conn = this.getConnection(ctx);
                pm = conn.prepareStatement(sql);
                pm.setString(1, companyId);
                pm.setString(2, materialId);
                if (lot != null && lot.length() > 0 && AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
                    pm.setString(3, lot);
                }
                rs = pm.executeQuery();
                String costIdByClass = null;
                String costIdByBatch = null;
                costId = null;
                int i = 0;
                while (rs.next()) {
                    i = new Integer(rs.getString("FCalculateMode"));
                    if (4 == i) {
                        costIdByBatch = rs.getString("FID");
                        ++countLot;
                        continue;
                    }
                    costIdByClass = rs.getString("FID");
                }
                if (AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
                    if (countLot > 1) {
                        CostObjectInfo costObjectInfo2 = costObjectInfo;
                        return costObjectInfo2;
                    }
                    if (lot != null && lot.length() > 0) {
                        costId = costIdByBatch;
                        break block30;
                    } else {
                        CostObjectInfo costObjectInfo3 = costObjectInfo;
                        return costObjectInfo3;
                    }
                }
                costId = costIdByClass;
            }
            if (costId == null) return costObjectInfo;
            if (costId.length() <= 0) return costObjectInfo;
            ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
            CostObjectInfo costObjectInfo4 = costObjectInfo = iCostObject.getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            return costObjectInfo4;
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
                if (null != pm) {
                    pm.close();
                }
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
    }

    protected String getScmSubmitAuditParam(Context ctx, String orgUnitID, String billTypeId) throws BOSException, EASBizException {
        ISCMBillParam scmParam;
        String key;
        String pValue;
        if (null == this.scmSubmitAuditParam) {
            this.scmSubmitAuditParam = new HashMap();
        }
        if (null == (pValue = (String)this.scmSubmitAuditParam.get(key = orgUnitID + "-" + billTypeId + "-" + 4)) && null != (pValue = (scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx)).getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeId))) {
            this.scmSubmitAuditParam.put(key, pValue);
        }
        return pValue;
    }

    public BigDecimal getExchangeQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty, MultiMeasureUnitCollection multiUnitColls) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        MultiMeasureUnitInfo multiUnifInfo = null;
        MultiMeasureUnitInfo othermultiUnifInfo = null;
        MultiMeasureUnitInfo tempInfo = null;
        for (int i = 0; i < multiUnitColls.size(); ++i) {
            tempInfo = multiUnitColls.get(i);
            if (tempInfo.getMaterial().getId().toString().equals(materialID) && tempInfo.getMeasureUnit().getId().toString().equals(unitInfo.getId().toString())) {
                multiUnifInfo = tempInfo;
            }
            if (!tempInfo.getMaterial().getId().toString().equals(materialID) || !tempInfo.getMeasureUnit().getId().toString().equals(otherUnitInfo.getId().toString())) continue;
            othermultiUnifInfo = tempInfo;
        }
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    @Override
    protected void _unBackFlush(Context ctx, IObjectCollection finishedColls) throws BOSException, EASBizException {
        FinishedRptCollection finiColls = (FinishedRptCollection)finishedColls;
        HashSet<String> materialIds = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> prdIdSet = new HashSet<String>();
        FinishedRptInfo finishedInfo = null;
        for (int i = 0; i < finiColls.size(); ++i) {
            finishedInfo = finiColls.get(i);
            FinishedRptEntryCollection entryColls = finishedInfo.getEntrys();
            for (int j = 0; j < entryColls.size(); ++j) {
                FinishedRptEntryInfo entryInfo = entryColls.get(j);
                if (entryInfo.getOutputType().getValue() != 10710) continue;
                materialIds.add(entryInfo.getMaterial().getId().toString());
            }
            idSet.add(finishedInfo.getId().toString());
            prdIdSet.add(finishedInfo.getProductionOrder().getId().toString());
            ProductionOrderStockEntryCollection sEntryColls = finishedInfo.getProductionOrder().getStockEntry();
            for (int j = 0; j < sEntryColls.size(); ++j) {
                if (!sEntryColls.get(j).isIsBackFlush()) continue;
                materialIds.add(sEntryColls.get(j).getMaterial().getId().toString());
            }
        }
        MultiMeasureUnitCollection multColls = this.getMultiMeasureUnit(ctx, materialIds);
        StringBuffer ids = new StringBuffer();
        Iterator ir = idSet.iterator();
        int count = 0;
        while (ir.hasNext()) {
            String id = ir.next().toString();
            if (count != 0) {
                ids.append(",");
            }
            ids.append("'" + id + "'");
            ++count;
        }
        StringBuffer prdIds = new StringBuffer();
        ir = prdIdSet.iterator();
        count = 0;
        while (ir.hasNext()) {
            String id = ir.next().toString();
            if (count != 0) {
                prdIds.append(",");
            }
            prdIds.append("'" + id + "'");
            ++count;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StorageOrgUnitInfo sou = ContextUtil.getCurrentStorageUnit((Context)ctx);
        ObjectUuidPK userId = new ObjectUuidPK(userInfo.getId());
        ObjectUuidPK orgId = new ObjectUuidPK(sou.getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_delete");
        }
        catch (EASBizException e) {
            throw new ProductionOrderException(ProductionOrderException.NOMATERIALREQ_DELETE);
        }
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_unAudit");
        }
        catch (EASBizException e) {
            throw new ProductionOrderException(ProductionOrderException.NOMATERIALREQ_UNAUDIT);
        }
        String sql = "update T_IM_MaterialReqBill set FIsBackflush = 0 where fsourcebillid in (" + ids + ")";
        DbUtil.execute((Context)ctx, (String)sql);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", idSet, CompareType.INCLUDE));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        IMaterialReqBill materialReq = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        MaterialReqBillCollection colls = materialReq.getMaterialReqBillCollection(env);
        StringBuffer materialReqIds = new StringBuffer();
        for (int i = 0; i < colls.size(); ++i) {
            if (0 != i) {
                materialReqIds.append(",");
            }
            materialReqIds.append("'").append(colls.get(i).getId().toString()).append("'");
            materialReq.unAudit((IObjectPK)new ObjectUuidPK(colls.get(i).getId().toString()));
        }
        sql = "delete from T_IM_MaterialReqBillEntry where fparentid in (select fid from T_IM_MaterialReqBill where fsourcebillid in (" + ids.toString() + "))";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(sql);
        sql = "delete from T_IM_MaterialReqBill where fsourcebillid in (" + ids + ")";
        sqlList.add(sql);
        sql = "update t_mm_finishedrpt set FIsBackFlushed = 0 where fid in (" + ids + ")";
        sqlList.add(sql);
        sql = "delete from t_bot_relation where FSrcEntityID = '" + new FinishedRptInfo().getBOSType().toString() + "' and FDestEntityID = '" + new MaterialReqBillInfo().getBOSType().toString() + "' and FSrcObjectID in (" + ids + ")";
        sqlList.add(sql);
        sql = "delete from t_bot_relation where FSrcEntityID = '" + new ProductionOrderInfo().getBOSType().toString() + "' and FDestEntityID = '" + new MaterialReqBillInfo().getBOSType().toString() + "' and FSrcObjectID in (" + prdIds + ") and fDestObjectId in (" + materialReqIds.toString() + ")";
        sqlList.add(sql);
        ArrayList<String> prdIdList = new ArrayList<String>();
        for (int i = 0; i < finiColls.size(); ++i) {
            ProductionOrderInfo orderInfo = finiColls.get(i).getProductionOrder();
            prdIdList.add(orderInfo.getId().toString());
            BigDecimal[] commitQty = this.calculateMainCommitQty(ctx, finiColls.get(i), orderInfo, multColls);
            ProductionOrderStockEntryCollection stockEntrys = this.calculateSendOutQty(ctx, orderInfo, commitQty[1], multColls);
            for (int j = 0; j < stockEntrys.size(); ++j) {
                ProductionOrderStockEntryInfo entryInfo = stockEntrys.get(j);
                sql = "update T_MM_ProductionOrderSEntry set FSendOutTotalQty = FSendOutTotalQty-" + entryInfo.getSendOutTotalQty() + ",FBaseSendOutTotalQty = FBaseSendOutTotalQty-" + entryInfo.getBaseSendOutTotalQty() + " where fid = '" + entryInfo.getId().toString() + "'";
                sqlList.add(sql);
            }
            sql = "update T_MM_ProductionOrder set FBackFlushTotalQty = FBackFlushTotalQty-" + commitQty[0] + ",FBaseBackFlushTotalQty=FBaseBackFlushTotalQty-" + commitQty[1] + " where fid = '" + orderInfo.getId().toString() + "'";
            sqlList.add(sql);
        }
        DBBatchUtil.executeBatch((Context)ctx, sqlList);
        PoMaterialWithDraw.updatePoABDate(ctx, prdIdList);
        ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(prdIdList, false);
    }
}

