/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.control.ProductionOrderException;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ManufactureRecBillWriteBackOrderUpdater
extends BillUpdater {
    private static final String currBillTypeID = "ejIZHXXTQliYCQJg9t4Re0Y+1VI=";
    private String billTypeID = null;
    private String[] billIds = null;
    private TransactionTypeInfo transactionTypeInfo = null;
    private boolean isUpdateEntry = false;

    public ManufactureRecBillWriteBackOrderUpdater() {
    }

    public ManufactureRecBillWriteBackOrderUpdater(Context ctx) {
        super(ctx);
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        if (!"50957179-0105-1000-e000-0167c0a812fd463ED552".equals(this.billTypeID)) {
            return false;
        }
        if (!this.checkDataCount()) {
            return false;
        }
        this.transactionTypeInfo = this.getSrcBillTransactionType(this.billIds[0]);
        this.insertTempTableData();
        this.isOrderClosed();
        if (this.isUpdateEntry) {
            this.setTargetTable("T_MM_ProductionOrderOEntry");
            this.setUpdateHead(false);
        } else {
            this.setTargetTable("T_MM_ProductionOrder");
            this.setUpdateHead(true);
        }
        this.setWriteBackFields();
        this.setOperationSign();
        this.setQtyCheckException();
        this.setTransfUnit(true);
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        return true;
    }

    private boolean checkDataCount() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(T.FID) iCount ");
        sb.append("from T_IM_ManufactureRecBill T ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                if (rows.getInt("iCount") <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void insertTempTableData() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(this.sourceDataTable);
        sb.append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ");
        sb.append("select head.FID, entry.FSourceBillID, entry.FSourceBillEntryId, abs(entry.FBaseQty), abs(entry.FQty) ");
        sb.append("from T_IM_MANUFACTURERECBILL head ");
        sb.append("inner join T_IM_MANUFACTURERECBILLENTRY entry on head.FID = entry.FParentId ");
        sb.append("where head.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" head.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    public void setBillTypeID(String billTypeID) {
        this.billTypeID = billTypeID;
    }

    public void setBillIds(String[] billIds) {
        this.billIds = billIds;
    }

    private void setWriteBackFields() {
        this.setBaseQtyFields(new String[]{"FBaseStockTotalQty"});
        this.setQtyFields(new String[]{"FStockTotalQty"});
    }

    private void setOperationSign() throws EASBizException, BOSException {
        String sign = "";
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        sign = 1 == bizDirection ? (this.isAuditAction ? "+" : "-") : (this.isAuditAction ? "-" : "+");
        this.setBaseQtyOperation(new String[]{sign});
        this.setQtyOperation(new String[]{sign});
    }

    private TransactionTypeInfo getSrcBillTransactionType(String srcBillId) throws BOSException, EASBizException {
        TransactionTypeInfo transactionTypeInfo = null;
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("select m.FTransactionTypeID FTransactionTypeID,entry.FSourceBillId FSourceBillId,entry.FSourceBillEntryId FSourceBillEntryId ").append(" from T_IM_MANUFACTURERECBILL m LEFT OUTER JOIN T_IM_MANUFACTURERECBILLENTRY entry ").append(" on entry.FParentID=m.FID ").append(" where m.FID = '").append(srcBillId).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
            if (rs != null && rs.size() > 0) {
                String transactionTypeId = null;
                String sourceBillEntryId = null;
                String sourceBillId = null;
                while (rs.next()) {
                    transactionTypeId = rs.getString("FTransactionTypeID");
                    sourceBillEntryId = rs.getString("FSourceBillEntryId");
                    sourceBillId = rs.getString("FSourceBillId");
                }
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("riType.id"));
                selector.add(new SelectorItemInfo("riType.name"));
                selector.add(new SelectorItemInfo("riType.number"));
                selector.add(new SelectorItemInfo("riType.bizDirection"));
                transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)this.ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeId), selector);
                if (sourceBillEntryId != null && !sourceBillEntryId.equals(sourceBillId)) {
                    this.isUpdateEntry = true;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return transactionTypeInfo;
    }

    private void isOrderClosed() throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("select top 1 fid from t_mm_productionorder where fbasestatus = 7 and fid in (").append("select FSourceBillID from ").append(this.sourceDataTable).append(" where FSourceBillId is not NULL ").append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
        try {
            if (rs.next()) {
                throw new ProductionOrderException(ProductionOrderException.SRCPOCLOSED, new String[]{""});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        boolean ret = true;
        if (this.isUpdateEntry) {
            return ret;
        }
        StringBuffer sqlBuf = new StringBuffer();
        if (this.isThrowException()) {
            sqlBuf.append("select top 1 * from ");
        } else {
            sqlBuf.append("select distinct FBillID from ");
        }
        sqlBuf.append(this.getQtyCheckSql());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            if (this.isThrowException()) {
                if (rs != null && rs.next()) {
                    ret = false;
                }
            } else {
                sqlBuf.setLength(0);
                sqlBuf.append("delete ").append(this.sourceDataTable).append(" where FBillID in (");
                int i = 0;
                HashMap<String, String> errMap = new HashMap<String, String>();
                while (rs != null && rs.next()) {
                    String billID = rs.getString("FBillID");
                    if (errMap.containsKey(billID)) continue;
                    this.batchResults.addError(billID, (Exception)((Object)this.throwExcpetion));
                    errMap.put(billID, "1");
                    sqlBuf.append(i > 0 ? "," : " ").append("?");
                    ++i;
                }
                sqlBuf.append(")");
                if (i > 0 && this.isDeleteTempData) {
                    DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString(), (Object[])errMap.keySet().toArray());
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private String getQtyCheckSql() {
        StringBuffer sqlBuf = new StringBuffer();
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        if (1 == bizDirection) {
            sqlBuf.append(this.targetTable).append(" t1").append(" inner join (select tmp.").append(this.getFID()).append(", sum(tmp.FBaseQty) as Sum_BaseQty from ").append(this.sourceDataTable).append(" tmp group by tmp.").append(this.getFID()).append(") t2 on t1.FId = t2.").append(this.getFID()).append(" inner join T_BD_MaterialPlan t3 on t3.FId = t1.FMaterialPlanID").append(" where t3.FIsStorageLimit =1 and t3.FRCVInHightLimit is not null and ((100 + t3.FRCVInHightLimit)/100) * ISNULL(t1.FBaseQty,0) - ISNULL(t1.FBaseStockTotalQty,0) < t2.Sum_BaseQty");
        } else {
            sqlBuf.append(this.targetTable).append(" t1").append(" inner join (select tmp.").append(this.getFID()).append(", sum(tmp.FBaseQty) as Sum_BaseQty from ").append(this.sourceDataTable).append(" tmp group by tmp.").append(this.getFID()).append(") t2 on t1.FId = t2.").append(this.getFID()).append(" where t1.FBaseStockTotalQty < t2.Sum_BaseQty");
        }
        return sqlBuf.toString();
    }

    private void setQtyCheckException() {
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        if (1 == bizDirection) {
            this.setThrowExcpetion(new ProductionOrderException(ProductionOrderException.OVERRCVINHIGHTLIMIT));
        } else {
            this.setThrowExcpetion(new ProductionOrderException(ProductionOrderException.OVERSTOCKTOTALQTY));
        }
    }

    protected void afterExecute() throws BOSException, EASBizException {
        List orderIds = this.getOrderId();
        if (orderIds == null || orderIds.size() < 1) {
            return;
        }
        if (this.isAuditAction) {
            ProductionOrderFacadeFactory.getLocalInstance(this.ctx).dealAutoFinished(orderIds, true);
        } else {
            ProductionOrderFacadeFactory.getLocalInstance(this.ctx).dealAutoFinished(orderIds, false);
        }
        super.afterExecute();
    }

    private List getOrderId() throws BOSException {
        ArrayList<String> orderIds = new ArrayList<String>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select distinct FSourceBillId from ").append(this.sourceDataTable).append(" where FSourceBillId is not NULL");
        IRowSet rowSetPick = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            while (rowSetPick.next()) {
                String id = rowSetPick.getString("FSourceBillId");
                orderIds.add(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orderIds;
    }
}

