/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.ParameterUtil;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.TransactionTypeHelper;
import com.kingdee.eas.mm.control.IPickingSlipBillEntry;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.ITaskDispBill;
import com.kingdee.eas.mm.control.PickingSlipBillEntryCollection;
import com.kingdee.eas.mm.control.PickingSlipBillEntryFactory;
import com.kingdee.eas.mm.control.PickingSlipBillEntryInfo;
import com.kingdee.eas.mm.control.PickingSlipBillException;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.PickingSlipBillInfo;
import com.kingdee.eas.mm.control.PickingSlipLineStatusEnum;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.TaskDispBillFactory;
import com.kingdee.eas.mm.control.TaskDispBillInfo;
import com.kingdee.eas.mm.control.app.AbstractPickingSlipBillControllerBean;
import com.kingdee.eas.mm.control.app.PoMaterialWithDraw;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PickingSlipBillControllerBean
extends AbstractPickingSlipBillControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.PickingSlipBillControllerBean");
    private boolean dividebyProductline = false;
    private boolean dividebyProductlineWP = false;
    private boolean dividebyBillNum = false;
    private boolean dividebyWareHouse = true;
    private static final int QTY_TO_BASEQTY = 1;
    private static final int BASEQTY_TO_QTY = 2;
    private static final BigDecimal ZERO = new BigDecimal(0);

    private void initPSParameter(Context ctx, String orgUnitID) throws EASBizException, BOSException {
        ParamItemInfo dividedbyPL_Value = ParameterUtil.getParamItemByCodeAndOrg((Context)ctx, (String)"DivideByProductLine", (String)orgUnitID);
        this.dividebyProductline = dividedbyPL_Value.getValue().equals("true");
        ParamItemInfo dividedbyPLWP_Value = ParameterUtil.getParamItemByCodeAndOrg((Context)ctx, (String)"DivideByProductLineWP", (String)orgUnitID);
        this.dividebyProductlineWP = dividedbyPLWP_Value.getValue().equals("true");
    }

    private void initPSParameterFromDBSet(Context ctx, String orgUnitID) throws EASBizException, BOSException {
        StringBuffer getSql = new StringBuffer();
        getSql.append("select FFlag from T_MM_IsDividingByNumber");
        IRowSet tempRs = DbUtil.executeQuery((Context)ctx, (String)getSql.toString());
        try {
            while (tempRs.next()) {
                this.dividebyBillNum = tempRs.getBoolean("FFlag");
            }
            if (this.dividebyBillNum) {
                this.dividebyWareHouse = false;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    @Override
    protected void _writeBackIssuedTotalQty(Context ctx, String tempTableName, BizActionEnum bizActionEnum) throws BOSException, EASBizException {
        String sign = " + ";
        String unSign = " - ";
        if (bizActionEnum.getValue() == 109) {
            sign = " - ";
            unSign = " + ";
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBillEntry as a ");
        sqlBuffer.append("set (fissuedtotalqty,fbaseissuedtotalqty,FAssociateQty) = ");
        sqlBuffer.append("(select a.fissuedtotalqty ").append(sign).append(" round(decimal(t.FBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision), ");
        sqlBuffer.append("a.fbaseissuedtotalqty ").append(sign).append(" t.FBaseQty, ");
        sqlBuffer.append("a.FAssociateQty ").append(unSign).append(" t.FBaseQty ");
        sqlBuffer.append("from  (select decimal(sum(FBaseQty),21,8) as FBaseQty,FSourceBillEntryId ");
        sqlBuffer.append("from ").append(tempTableName).append(" ");
        sqlBuffer.append("group by FSourceBillEntryId");
        sqlBuffer.append(") t,");
        sqlBuffer.append("t_bd_multimeasureunit  b ");
        sqlBuffer.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
        sqlBuffer.append("and a.fid = t.FSourceBillEntryId ");
        sqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
        sqlBuffer.setLength(0);
        sqlBuffer.append("update T_MM_ProductionOrderSEntry as a ");
        sqlBuffer.append("set (fsendouttotalqty,fbasesendouttotalqty) = ");
        sqlBuffer.append("(select a.fsendouttotalqty ").append(sign).append(" round(decimal(t.FBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision), ");
        sqlBuffer.append("a.fbasesendouttotalqty ").append(sign).append(" t.FBaseQty ");
        sqlBuffer.append("from  (select decimal(sum(t1.FBaseQty),21,8) as FBaseQty,t2.FSourceBillEntryId ");
        sqlBuffer.append("from ").append(tempTableName).append(" t1, ");
        sqlBuffer.append("T_MM_PickingSlipBillEntry t2  ");
        sqlBuffer.append("where t1.FSourceBillEntryId  = t2.FID ");
        sqlBuffer.append("group by t2.FSourceBillEntryId");
        sqlBuffer.append(") t,");
        sqlBuffer.append("t_bd_multimeasureunit  b ");
        sqlBuffer.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
        sqlBuffer.append("and a.fid = t.FSourceBillEntryId ");
        sqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    @Override
    protected void _redMateReqBillWriteBackReturnedTotalQty(Context ctx, String tempTableName, BizActionEnum bizActionEnum) throws BOSException, EASBizException {
        String sign = " + ";
        String unSign = " - ";
        if (bizActionEnum.getValue() == 109) {
            sign = " - ";
            unSign = " + ";
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBillEntry as a ");
        sqlBuffer.append("set (freturnedtotalqty,fbasereturnedtotalqty,FAssociateQty) = ");
        sqlBuffer.append("(select a.freturnedtotalqty ").append(sign).append(" round(decimal(t.FBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision), ");
        sqlBuffer.append("a.fbasereturnedtotalqty ").append(sign).append(" t.FBaseQty, ");
        sqlBuffer.append("a.FAssociateQty ").append(unSign).append(" t.FBaseQty ");
        sqlBuffer.append("from  (select decimal(sum(FBaseQty),21,8) as FBaseQty,FSourceBillEntryId ");
        sqlBuffer.append("from ").append(tempTableName).append(" ");
        sqlBuffer.append("group by FSourceBillEntryId");
        sqlBuffer.append(") t,");
        sqlBuffer.append("t_bd_multimeasureunit  b ");
        sqlBuffer.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
        sqlBuffer.append("and a.fid = t.FSourceBillEntryId ");
        sqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
        sqlBuffer.setLength(0);
        sqlBuffer.append("update T_MM_ProductionOrderSEntry as a ");
        sqlBuffer.append("set (funtreadtotalqty,fbaseuntreadtotalqty) = ");
        sqlBuffer.append("(select a.funtreadtotalqty ").append(sign).append(" round(decimal(t.FBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision), ");
        sqlBuffer.append("a.fbaseuntreadtotalqty ").append(sign).append(" t.FBaseQty ");
        sqlBuffer.append("from  (select decimal(sum(t1.FBaseQty),21,8) as FBaseQty,t2.FSourceBillEntryId ");
        sqlBuffer.append("from ").append(tempTableName).append(" t1, ");
        sqlBuffer.append("T_MM_PickingSlipBillEntry t2  ");
        sqlBuffer.append("where t1.FSourceBillEntryId  = t2.FID ");
        sqlBuffer.append("group by t2.FSourceBillEntryId");
        sqlBuffer.append(") t,");
        sqlBuffer.append("t_bd_multimeasureunit  b ");
        sqlBuffer.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
        sqlBuffer.append("and a.fid = t.FSourceBillEntryId ");
        sqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)model;
        if (psbInfo.getBaseStatus().getValue() == -2) {
            this.autoDealPickingBillStatusAndOrderStatus(ctx, psbInfo);
            Connection cn = null;
            try {
                cn = this.getConnection(ctx);
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)new PickingSlipBillInfo().getBOSType().toString()), (Context)ctx, (Connection)cn);
                dao.update((IObjectPK)new ObjectUuidPK(psbInfo.getId()), (IObjectValue)psbInfo);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
            return new ObjectUuidPK(psbInfo.getId());
        }
        this.validateData(ctx, psbInfo);
        PickingSlipBillEntryCollection psbeCol = psbInfo.getEntries();
        Iterator itr = psbeCol.iterator();
        while (itr.hasNext()) {
            PickingSlipBillEntryInfo psbeInfo = (PickingSlipBillEntryInfo)itr.next();
            psbeInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        IObjectPK pk = super._submit(ctx, model);
        boolean isAutoAudit = false;
        String orgUnitID = psbInfo.getStorageOrgUnit().getId().toString();
        if (psbInfo.getBillType() != null) {
            String billTypeID = psbInfo.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeID);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
        }
        if (isAutoAudit) {
            this._audit(ctx, pk);
        }
        return pk;
    }

    private boolean isComplete(PickingSlipBillEntryCollection psbeCol) {
        boolean isComplete = true;
        Iterator itr = psbeCol.iterator();
        while (itr.hasNext()) {
            PickingSlipBillEntryInfo psbeInfo = (PickingSlipBillEntryInfo)itr.next();
            if (PickingSlipLineStatusEnum.CLOSE != psbeInfo.getLineStatus()) {
                if (psbeInfo.getMaterialPlan() != null && psbeInfo.getMaterialPlan().isIsQuotaControl()) {
                    double d = psbeInfo.getBaseIssuedTotalQty().doubleValue() - psbeInfo.getBaseReturnedTotalQty().doubleValue();
                    double d2 = psbeInfo.getBaseReqQty().doubleValue();
                    double d3 = psbeInfo.getBaseSupplementTotalQty() == null ? new BigDecimal(0).doubleValue() : psbeInfo.getBaseSupplementTotalQty().doubleValue();
                    if (d >= (d2 - d3) * (1.0 - psbeInfo.getMaterialPlan().getIssInLowLimit().doubleValue() / 100.0)) {
                        psbeInfo.setBaseStatus(EntryBaseStatusEnum.FINISH);
                        continue;
                    }
                    psbeInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                    isComplete = false;
                    continue;
                }
                if (psbeInfo.getBaseIssuedTotalQty().doubleValue() - psbeInfo.getBaseReturnedTotalQty().doubleValue() >= psbeInfo.getBaseReqQty().doubleValue()) {
                    psbeInfo.setBaseStatus(EntryBaseStatusEnum.FINISH);
                    continue;
                }
                psbeInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                isComplete = false;
                continue;
            }
            psbeInfo.setBaseStatus(EntryBaseStatusEnum.FINISH);
        }
        return isComplete;
    }

    private PickingSlipBillEntryCollection validateDataForDoChange(Context ctx, PickingSlipBillInfo psbInfo) throws BOSException, EASBizException, PickingSlipBillException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.baseStatus"));
        selector.add(new SelectorItemInfo("entries.pickedTotalQty"));
        selector.add(new SelectorItemInfo("entries.issuedTotalQty"));
        selector.add(new SelectorItemInfo("entries.returnedTotalQty"));
        selector.add(new SelectorItemInfo("entries.supplementTotalQty"));
        StringBuffer errorMsg = new StringBuffer();
        PickingSlipBillInfo psb = (PickingSlipBillInfo)PickingSlipBillFactory.getLocalInstance(ctx).getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(psbInfo.getId()), selector);
        if (psb.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            errorMsg.append(this.getPSResource(ctx, "Msg_DoChangeSubmitStatusCheck") + "\n");
        }
        PickingSlipBillEntryCollection coll = psb.getEntries();
        HashMap<String, BigDecimal> qtyCatch1 = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> qtyCatch2 = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> qtyCatch3 = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> qtyCatch4 = new HashMap<String, BigDecimal>();
        for (int i = 0; i < coll.size(); ++i) {
            PickingSlipBillEntryInfo psbeInfo = coll.get(i);
            BigDecimal qty1 = psbeInfo.getPickedTotalQty();
            BigDecimal qty2 = psbeInfo.getIssuedTotalQty();
            BigDecimal qty3 = psbeInfo.getReturnedTotalQty();
            BigDecimal qty4 = psbeInfo.getSupplementTotalQty();
            qtyCatch1.put(psbeInfo.getId().toString(), qty1);
            qtyCatch2.put(psbeInfo.getId().toString(), qty2);
            qtyCatch3.put(psbeInfo.getId().toString(), qty3);
            qtyCatch4.put(psbeInfo.getId().toString(), qty4);
        }
        PickingSlipBillEntryCollection psbeCol = psbInfo.getEntries();
        Iterator itr = psbeCol.iterator();
        int i = 1;
        while (itr.hasNext()) {
            PickingSlipBillEntryInfo psbeInfo = (PickingSlipBillEntryInfo)itr.next();
            if (psbeInfo.getId() != null && qtyCatch1.containsKey(psbeInfo.getId().toString())) {
                BigDecimal qty1 = (BigDecimal)qtyCatch1.get(psbeInfo.getId().toString());
                BigDecimal qty2 = (BigDecimal)qtyCatch2.get(psbeInfo.getId().toString());
                BigDecimal qty3 = (BigDecimal)qtyCatch3.get(psbeInfo.getId().toString());
                BigDecimal qty4 = (BigDecimal)qtyCatch4.get(psbeInfo.getId().toString());
                if (psbeInfo.getPickedTotalQty().doubleValue() != qty1.doubleValue() || psbeInfo.getIssuedTotalQty().doubleValue() != qty2.doubleValue() || psbeInfo.getReturnedTotalQty().doubleValue() != qty3.doubleValue() || psbeInfo.getSupplementTotalQty().doubleValue() != qty4.doubleValue()) {
                    errorMsg.append(this.getPSResource(ctx, "Msg_DoChangeAssociateCheck") + "\n");
                    break;
                }
            }
            if (psbeInfo.getMaterialPlan().isIsQuotaControl()) {
                if (psbeInfo.getReqQty().doubleValue() < (psbeInfo.getPickedTotalQty().doubleValue() + psbeInfo.getIssuedTotalQty().doubleValue() - psbeInfo.getReturnedTotalQty().doubleValue()) / (1.0 + psbeInfo.getMaterialPlan().getIssInHightLimit().doubleValue() / 100.0)) {
                    errorMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i)}) + this.getPSResource(ctx, "Msg_DoChangeQtyCheck") + "\n");
                    break;
                }
            } else if (psbeInfo.getReqQty().doubleValue() < psbeInfo.getPickedTotalQty().doubleValue() + psbeInfo.getIssuedTotalQty().doubleValue() - psbeInfo.getReturnedTotalQty().doubleValue()) {
                errorMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i)}) + this.getPSResource(ctx, "Msg_DoChangeQtyCheck2") + "\n");
                break;
            }
            ++i;
        }
        if (errorMsg.length() > 0) {
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
        }
        return psbeCol;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)psbInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (psbInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)psbInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (psbInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)psbInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (psbInfo.getStorageOrgUnit() != null) {
            filterItem = new FilterItemInfo("storageOrgUnit.id", (Object)psbInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && psbInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(psbInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return super._exists(ctx, filter);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.rewriteSrcBillWhenDel(ctx, pk);
        super._delete(ctx, pk);
    }

    private void rewriteSrcBillWhenDel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)this.getValue(ctx, pk);
        if (psbInfo.isIsSupplement() && psbInfo.getSourcePsBillId() != null) {
            ObjectUuidPK srcPsPk = new ObjectUuidPK(psbInfo.getSourcePsBillId());
            SelectorItemCollection sicSrc = this.getSelectors();
            PickingSlipBillInfo srcPsbInfo = this.getPickingSlipBillInfo(ctx, (IObjectPK)srcPsPk, sicSrc);
            PickingSlipBillEntryCollection srcPsbEntryCol = srcPsbInfo.getEntries();
            PickingSlipBillEntryCollection psbEntryCol = psbInfo.getEntries();
            PickingSlipBillEntryInfo psbEntryInfo = null;
            PickingSlipBillEntryInfo srcPsbEntryInfo = null;
            if (psbInfo.isIsBySuite()) {
                srcPsbInfo.setSupplementTotalSuite(srcPsbInfo.getSupplementTotalSuite().subtract(psbInfo.getReqSuite()));
                srcPsbInfo.setBaseSupplementTotalSuite(srcPsbInfo.getBaseSupplementTotalSuite().subtract(psbInfo.getBaseReqSuite()));
            }
            Iterator it = psbEntryCol.iterator();
            Iterator srcIt = null;
            block0: while (it.hasNext()) {
                psbEntryInfo = (PickingSlipBillEntryInfo)it.next();
                srcIt = srcPsbEntryCol.iterator();
                while (srcIt.hasNext()) {
                    srcPsbEntryInfo = (PickingSlipBillEntryInfo)srcIt.next();
                    if (!srcPsbEntryInfo.getId().toString().equals(psbEntryInfo.getSourcePsEntryBillId())) continue;
                    srcPsbEntryInfo.setSupplementTotalQty(srcPsbEntryInfo.getSupplementTotalQty().subtract(psbEntryInfo.getReqQty()));
                    srcPsbEntryInfo.setBaseSupplementTotalQty(srcPsbEntryInfo.getBaseSupplementTotalQty().subtract(psbEntryInfo.getBaseReqQty()));
                    continue block0;
                }
            }
            this.autoDealPickingBillStatusAndOrderStatus(ctx, srcPsbInfo);
            this._update(ctx, (IObjectPK)srcPsPk, (IObjectValue)srcPsbInfo);
        } else if (psbInfo.getSourceBillType() != null && psbInfo.getSourceBillId() != null) {
            if (psbInfo.getSourceBillType().getId().toString().equals("ejIZHXXTQliYCQJg9t4Re0Y+1VI=")) {
                IProductionOrder ipo = ProductionOrderFactory.getLocalInstance(ctx);
                ProductionOrderInfo poInfo = (ProductionOrderInfo)ipo.getValue((IObjectPK)new ObjectUuidPK(psbInfo.getSourceBillId()));
                poInfo.setIsPickSlip(false);
                ipo.update((IObjectPK)new ObjectUuidPK(psbInfo.getSourceBillId()), (CoreBaseInfo)poInfo);
            } else if (psbInfo.getSourceBillType().getId().toString().equals("Tgx4hbjrTRCki6pl2V5aLkY+1VI=")) {
                ITaskDispBill itd = TaskDispBillFactory.getLocalInstance(ctx);
                TaskDispBillInfo tdbillInfo = itd.getTaskDispBillInfo((IObjectPK)new ObjectUuidPK(psbInfo.getSourceBillId()));
                tdbillInfo.setIsGeneratePick(false);
                itd.update((IObjectPK)new ObjectUuidPK(psbInfo.getSourceBillId()), (CoreBaseInfo)tdbillInfo);
            }
        }
    }

    protected boolean _checkOtherWhenDel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)model;
        if (psbInfo.getBaseStatus().getValue() == 6) {
            throw new PickingSlipBillException(PickingSlipBillException.CHECKBLOCKEDOK, new Object[]{psbInfo.getString("number"), ""});
        }
        if (psbInfo.getBaseStatus().getValue() == 90) {
            throw new PickingSlipBillException(PickingSlipBillException.CHECKFINISHEDOK, new Object[]{psbInfo.getString("number"), ""});
        }
        if (psbInfo.getBaseStatus().getValue() == 7) {
            throw new PickingSlipBillException(PickingSlipBillException.CHECKCLOSEDOK, new Object[]{psbInfo.getString("number"), ""});
        }
        return true;
    }

    private void validateData(Context ctx, PickingSlipBillInfo psbInfo) throws PickingSlipBillException {
        PickingSlipBillEntryCollection psbeCol;
        StringBuffer errorMsg = new StringBuffer();
        ArrayList<String> emptyMsgList = new ArrayList<String>();
        ArrayList<String> cache = new ArrayList<String>();
        if (psbInfo.getStorageOrgUnit() == null) {
            emptyMsgList.add(this.getPSResource(ctx, "Msg_StorageOrg"));
        }
        if (psbInfo.getWorkshop() == null) {
            emptyMsgList.add(this.getPSResource(ctx, "Msg_WorkShop"));
        }
        if (psbInfo.getProductLine() == null) {
            emptyMsgList.add(this.getPSResource(ctx, "Msg_ProductLine"));
        }
        if (psbInfo.getMmBizType() == null) {
            emptyMsgList.add(this.getPSResource(ctx, "Msg_MMBizType"));
        }
        if (psbInfo.getBizDate() == null) {
            emptyMsgList.add(this.getPSResource(ctx, "Msg_BizDate"));
        }
        if (emptyMsgList.size() > 0) {
            for (int j = 0; j < emptyMsgList.size(); ++j) {
                if (j > 0) {
                    errorMsg.append("\u3001");
                }
                errorMsg.append(emptyMsgList.get(j));
            }
            errorMsg.append(this.getPSResource(ctx, "Msg_NotNull") + "\n");
        }
        if ((psbeCol = psbInfo.getEntries()) != null && psbeCol.size() > 0) {
            PickingSlipBillEntryInfo entryInfo = null;
            for (int i = 0; i < psbeCol.size(); ++i) {
                StringBuffer blankMsg = new StringBuffer();
                entryInfo = psbeCol.get(i);
                if (entryInfo.getMaterial() == null) {
                    blankMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}) + this.getPSResource(ctx, "Msg_Material") + ",");
                }
                if (entryInfo.getUnit() == null) {
                    if (blankMsg.length() == 0) {
                        blankMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}));
                    }
                    blankMsg.append(this.getPSResource(ctx, "Msg_Unit") + ",");
                }
                if (entryInfo.getReqQty() == null) {
                    if (blankMsg.length() == 0) {
                        blankMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}));
                    }
                    blankMsg.append(this.getPSResource(ctx, "Msg_ReqQty") + ",");
                }
                if (entryInfo.getWarehouse() != null && entryInfo.getWarehouse().isHasLocation() && entryInfo.getLocation() == null) {
                    if (blankMsg.length() == 0) {
                        blankMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}));
                    }
                    blankMsg.append(this.getPSResource(ctx, "Msg_Location") + ",");
                }
                if (entryInfo.getReqDate() == null) {
                    if (blankMsg.length() == 0) {
                        blankMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}));
                    }
                    blankMsg.append(this.getPSResource(ctx, "Msg_ReqDate") + ",");
                }
                if (entryInfo.getPickingDate() == null) {
                    if (blankMsg.length() == 0) {
                        blankMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}));
                    }
                    blankMsg.append(this.getPSResource(ctx, "Msg_PickingDate") + ",");
                }
                if (entryInfo.getMaterial() != null) {
                    StringBuffer key = new StringBuffer();
                    key.append(entryInfo.getProductLineWP() == null ? "null" : entryInfo.getProductLineWP().getId().toString()).append("$").append(entryInfo.getMaterial().getId().toString()).append("$").append(entryInfo.getLotNo() == null ? "null" : entryInfo.getLotNo());
                    if (cache.contains(key.toString())) {
                        errorMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}) + this.getPSResource(ctx, "Msg_DupMaterialPLWP") + "\n");
                    } else {
                        cache.add(key.toString());
                    }
                }
                if (blankMsg.length() > 0) {
                    errorMsg.append(blankMsg.toString() + this.getPSResource(ctx, "Msg_NotNull") + "\n");
                }
                if (entryInfo.getReqQty() == null || entryInfo.getReqQty().compareTo(new BigDecimal(0)) > 0) continue;
                errorMsg.append(this.getHolderResource("Msg_Row", new String[]{String.valueOf(i + 1)}));
                errorMsg.append(this.getPSResource(ctx, "Msg_ReqQtyPositive") + "\n");
            }
        } else {
            errorMsg.append(this.getPSResource(ctx, "Msg_Entry_blank") + "\n");
        }
        if (errorMsg.length() > 0) {
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("productionOrder.id"));
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)this.getValue(ctx, pk, sic);
        if (psbInfo.getProductionOrder() != null && psbInfo.getProductionOrder().getId() != null) {
            ArrayList<String> orderIds = new ArrayList<String>();
            orderIds.add(psbInfo.getProductionOrder().getId().toString());
            ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        }
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._audit(ctx, pks);
    }

    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)model;
        this._submit(ctx, (IObjectValue)psbInfo);
        boolean isAutoAudit = false;
        String orgUnitID = psbInfo.getStorageOrgUnit().getId().toString();
        if (psbInfo.getBillType() != null) {
            String billTypeID = psbInfo.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeID);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
        }
        if (!isAutoAudit) {
            this._audit(ctx, pk);
        }
    }

    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _canPickingSlip_gather(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks.length > 1) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("isBySuite"));
            selectors.add(new SelectorItemInfo("storageOrgUnit.id"));
            selectors.add(new SelectorItemInfo("baseStatus"));
            selectors.add(new SelectorItemInfo("entries.supplyOrgUnit.id"));
            selectors.add(new SelectorItemInfo("entries.supplyOrgUnit.name"));
            PickingSlipBillInfo firstpsbInfo = (PickingSlipBillInfo)this.getValue(ctx, pks[0], selectors);
            String orgID = firstpsbInfo.getStorageOrgUnit().getId().toString();
            PickingSlipBillEntryCollection entryCol = new PickingSlipBillEntryCollection();
            for (int i = 0; i < pks.length; ++i) {
                PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)this.getValue(ctx, pks[i], selectors);
                if (!psbInfo.getStorageOrgUnit().getId().toString().equals(orgID)) {
                    throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_GatherOnlyOneORG")});
                }
                if (psbInfo.isIsBySuite() != firstpsbInfo.isIsBySuite()) {
                    throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_NotOnePickSlipType")});
                }
                if (!psbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                    throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_bill") + psbInfo.getNumber() + this.getPSResource(ctx, "NotAudited_CannotPickingSlip")});
                }
                entryCol.addCollection(psbInfo.getEntries());
            }
            this.validateSpanStorageForCompanyOrg(ctx, firstpsbInfo, entryCol);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        PickingSlipBillInfo psInfo = (PickingSlipBillInfo)this.getValue(ctx, pk);
        String orgUnitID = psInfo.getStorageOrgUnit().getId().toString();
        if (psInfo.getProductionOrder() != null && psInfo.getProductionOrder().getId() != null) {
            ArrayList<String> orderIds = new ArrayList<String>();
            orderIds.add(psInfo.getProductionOrder().getId().toString());
            ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        }
        if (psInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.scm.common.SCMResource.NotUnAudit", (Locale)ctx.getLocale()));
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
        }
        if (!this.isUnAudit(ctx, psInfo, orgUnitID, 4)) {
            throw new SCMBillException(SCMBillException.ISUNAUDITINPARAM);
        }
        if (SCMServerUtils.hasDestBill((Context)ctx, (String)pk.toString())) {
            errorMsg.append(this.getPSResource(ctx, "HASDESTBILL_CANNOTUNAUDIT"));
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
        }
        IObjectPK[] pks = new IObjectPK[]{pk};
        this.update_whileUnAudit(ctx, pks);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        PickingSlipBillInfo psInfo = null;
        for (int i = 0; i < pks.length; ++i) {
            psInfo = (PickingSlipBillInfo)this.getValue(ctx, pks[i]);
            String orgUnitID = psInfo.getStorageOrgUnit().getId().toString();
            if (psInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                errorMsg.append(psInfo.getNumber() + "\t");
                errorMsg.append(this.getPSResource(ctx, "Msg_NOTAUDITED") + "\n");
                continue;
            }
            if (!this.isUnAudit(ctx, psInfo, orgUnitID, 4)) {
                errorMsg.append(psInfo.getNumber() + "\t" + this.getPSResource(ctx, "ISUNAUDITINPARAM") + "\n");
                continue;
            }
            if (!SCMServerUtils.hasDestBill((Context)ctx, (String)pks[i].toString())) continue;
            errorMsg.append(psInfo.getNumber() + "\t" + this.getPSResource(ctx, "HASDESTBILL_CANNOTUNAUDIT") + "\n");
        }
        if (errorMsg.length() > 0) {
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
        }
        this.update_whileUnAudit(ctx, pks);
    }

    private void update_whileUnAudit(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        for (int i = 0; i < pks.length; ++i) {
            PickingSlipBillInfo model = (PickingSlipBillInfo)this.getValue(ctx, pks[i]);
            model.setAuditor(null);
            model.setAuditTime(null);
            model.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            model.setPickedTotalSuite(ZERO);
            model.setReturnedTotalSuite(ZERO);
            model.setBasePickedTotalSuite(ZERO);
            model.setBaseReturnedTotalSuite(ZERO);
            model.setSupplementTotalSuite(ZERO);
            model.setBaseSupplementTotalSuite(ZERO);
            PickingSlipBillEntryCollection psbeCol = model.getEntries();
            for (int j = 0; j < psbeCol.size(); ++j) {
                psbeCol.get(j).setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                psbeCol.get(j).setPickedTotalQty(ZERO);
                psbeCol.get(j).setBasePickedTotalQty(ZERO);
                psbeCol.get(j).setIssuedTotalQty(ZERO);
                psbeCol.get(j).setBaseIssuedTotalQty(ZERO);
                psbeCol.get(j).setReturnedTotalQty(ZERO);
                psbeCol.get(j).setBaseReturnedTotalQty(ZERO);
                psbeCol.get(j).setSupplementTotalQty(ZERO);
                psbeCol.get(j).setBaseSupplementTotalQty(ZERO);
            }
            this.update(ctx, pks[i], (CoreBaseInfo)model);
        }
    }

    @Override
    protected IRowSet _getLotsByMaterial(Context ctx, String materialID, String storageOrgUnitID, String unitid) throws BOSException, EASBizException {
        IMaterialReqBill imr = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        String tablename = imr.getLotsByMaterial(storageOrgUnitID, materialID);
        String curLocaleCode = ctx.getLocale().toString();
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("select t1.FLot,t1.FWarehouseID,t1.FLocationID,round(decimal(t1.FUseableQty/t4.FBaseConvsRate,21,8),t4.FQtyPrecision) as FUseableQty,");
        strBuffer.append(" t2.FName_" + curLocaleCode + " as FWarehouseName,");
        strBuffer.append(" t3.FName_" + curLocaleCode + " as FLocationName");
        strBuffer.append(" from " + tablename + " t1 ");
        strBuffer.append(" left join t_db_warehouse t2 on t1.FWarehouseID = t2.fid ");
        strBuffer.append(" left join t_db_location t3 on t1.FLocationID = t3.fid, ");
        strBuffer.append(" t_bd_multimeasureunit t4 ");
        strBuffer.append(" where t4.fmeasureunitid = '" + unitid + "' and t4.fmaterialid = '" + materialID + "'");
        strBuffer.append(" and t1.FWarehouseID is not null ");
        strBuffer.append(" and t1.FLot is not null ");
        IRowSet rs = DbUtil.executeQueryNoTx((Context)ctx, (String)strBuffer.toString());
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tablename);
        return rs;
    }

    @Override
    protected Map _pickingSlip_BySuite(Context ctx, Vector pickingSlipVec, String orgUnitID, IObjectPK[] pks, Map otherParam) throws BOSException, EASBizException {
        this.initPSParameter(ctx, orgUnitID);
        this.initPSParameterFromDBSet(ctx, orgUnitID);
        Iterator iter = pickingSlipVec.iterator();
        String tableName = this.createTempPSTable(ctx);
        this.writeBack_pickingSuite(ctx, pickingSlipVec);
        ArrayList keyList = new ArrayList();
        while (iter.hasNext()) {
            HashMap psb = (HashMap)iter.next();
            String pickingSlipid = psb.get("ID").toString();
            BigDecimal pickingSuite = (BigDecimal)psb.get("pickingSuite");
            this.insertDataIntoTempTable_bysuite(ctx, tableName, pickingSlipid, pickingSuite, "Picking");
            this.writeBack_PSTotalQty(ctx, tableName);
            this.updateForSpanOrgProvide(ctx, tableName, "Picking", otherParam);
            keyList.addAll(this.createMaterialReqBill(ctx, tableName, "Picking", orgUnitID, otherParam));
        }
        this._releaseTempTable(ctx, tableName);
        HashMap result = new HashMap();
        result.put("result", keyList);
        return result;
    }

    @Override
    protected Map _pickingSlip_Simple(Context ctx, String tableName, Vector pickingSlipVec, String orgUnitID, IObjectPK pk, Map otherParam) throws BOSException, EASBizException {
        this.initPSParameter(ctx, orgUnitID);
        this.initPSParameterFromDBSet(ctx, orgUnitID);
        this.updateTempTable(ctx, tableName, pickingSlipVec, "Picking", otherParam);
        this.writeBack_PSTotalQty_simple(ctx, tableName);
        List keyList = this.createMaterialReqBill(ctx, tableName, "Picking", orgUnitID, otherParam);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("result", keyList);
        return result;
    }

    protected void dealSupplementSimple(Context ctx, IObjectPK pk, Vector pickingSlipVec) throws EASBizException, BOSException {
        PickingSlipBillInfo srcpsbInfo = null;
        PickingSlipBillInfo supplementInfo = null;
        PickingSlipBillEntryInfo psbeInfo = null;
        HashMap<String, BigDecimal> supplementMap = new HashMap<String, BigDecimal>();
        HashMap rtMap2 = null;
        Iterator it = null;
        for (HashMap rtMap2 : pickingSlipVec) {
            if (((BigDecimal)rtMap2.get("supplementQty")).compareTo(ZERO) <= 0) continue;
            if (supplementMap.containsKey(rtMap2.get("ENTRYID").toString())) {
                BigDecimal supplement = (BigDecimal)supplementMap.get(rtMap2.get("ENTRYID"));
                supplement = supplement.add((BigDecimal)rtMap2.get("supplementQty"));
                continue;
            }
            supplementMap.put(rtMap2.get("ENTRYID").toString(), (BigDecimal)rtMap2.get("supplementQty"));
        }
        if (supplementMap.keySet() != null && supplementMap.keySet().size() > 0) {
            SelectorItemCollection sicSrc = this.getSelectors();
            srcpsbInfo = (PickingSlipBillInfo)this._getValue(ctx, pk, sicSrc);
            PickingSlipBillEntryCollection srcpsbEntryCol = srcpsbInfo.getEntries();
            it = srcpsbEntryCol.iterator();
            while (it.hasNext()) {
                psbeInfo = (PickingSlipBillEntryInfo)it.next();
                if (!supplementMap.containsKey(psbeInfo.getId().toString())) continue;
                psbeInfo.setSupplementTotalQty(psbeInfo.getSupplementTotalQty().add((BigDecimal)supplementMap.get(psbeInfo.getId().toString())));
                BigDecimal baseSupplementQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)psbeInfo.getMaterial().getId().toString(), (MeasureUnitInfo)psbeInfo.getUnit(), (MeasureUnitInfo)psbeInfo.getBaseUnit(), (BigDecimal)((BigDecimal)supplementMap.get(psbeInfo.getId().toString())));
                psbeInfo.setBaseSupplementTotalQty(psbeInfo.getBaseSupplementTotalQty().add(baseSupplementQty));
            }
            this.autoDealPickingBillStatusAndOrderStatus(ctx, srcpsbInfo);
            this.update(ctx, pk, (CoreBaseInfo)srcpsbInfo);
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", supplementMap.keySet(), CompareType.INCLUDE));
            viewInfo.setSelector(sic);
            viewInfo.setFilter(filter);
            IPickingSlipBillEntry ipsbe = PickingSlipBillEntryFactory.getLocalInstance(ctx);
            PickingSlipBillEntryCollection supplementEntryCol = ipsbe.getPickingSlipBillEntryCollection(viewInfo);
            supplementInfo = this.getPickingSlipBillInfo(ctx, pk, sic);
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String psNumber = codingRuleManager.getNumber((IObjectValue)supplementInfo, supplementInfo.getStorageOrgUnit().getId().toString());
            BOSUuid newid = BOSUuid.create((BOSObjectType)supplementInfo.getBOSType());
            supplementInfo.setIsSupplement(true);
            supplementInfo.setSourcePsBillId(pk.toString());
            supplementInfo.setNumber(psNumber);
            supplementInfo.setId(newid);
            supplementInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            supplementInfo.setAuditor(null);
            supplementInfo.setAuditTime(null);
            supplementInfo.setModifier(null);
            supplementInfo.setModificationTime(null);
            supplementInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            Date today = new Date();
            supplementInfo.setCreateTime(new Timestamp(today.getTime()));
            supplementInfo.setBizDate(today);
            supplementInfo.remove("entries");
            Calendar cal = Calendar.getInstance();
            BOTRelationInfo upToPsBot = new BOTRelationInfo();
            BOTRelationEntryCollection upToPsBotEntryCol = upToPsBot.getRelationEntries();
            BOTRelationEntryInfo upToPsBotEntry = null;
            if (supplementInfo.getSourceBillType() != null && supplementInfo.getSourceBillId() != null) {
                upToPsBot.setSrcEntityID(new ProductionOrderInfo().getBOSType().toString());
                upToPsBot.setDestEntityID("A06DF1E1");
                upToPsBot.setSrcObjectID(supplementInfo.getSourceBillId());
                upToPsBot.setDestObjectID(newid.toString());
                upToPsBot.setDate(cal.getTime());
                upToPsBot.setOperatorID(ctx.getCaller().toString());
                upToPsBot.setBOTMappingID(null);
                upToPsBot.setIsEffected(false);
                upToPsBot.setType(0);
            }
            BOTRelationInfo psToPsbot = new BOTRelationInfo();
            BOTRelationEntryCollection psToPsBotEntryCol = psToPsbot.getRelationEntries();
            BOTRelationEntryInfo psTopsBotEntry = null;
            psToPsbot.setSrcEntityID("A06DF1E1");
            psToPsbot.setDestEntityID("A06DF1E1");
            psToPsbot.setSrcObjectID(pk.toString());
            psToPsbot.setDestObjectID(newid.toString());
            psToPsbot.setDate(cal.getTime());
            psToPsbot.setOperatorID(ctx.getCaller().toString());
            psToPsbot.setBOTMappingID(null);
            psToPsbot.setIsEffected(false);
            psToPsbot.setType(0);
            it = supplementEntryCol.iterator();
            while (it.hasNext()) {
                psbeInfo = (PickingSlipBillEntryInfo)it.next();
                BigDecimal supplementQty = (BigDecimal)supplementMap.get(psbeInfo.getId().toString());
                psbeInfo.setReqQty(supplementQty);
                BigDecimal baseSupplementQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)psbeInfo.getMaterial().getId().toString(), (MeasureUnitInfo)psbeInfo.getUnit(), (MeasureUnitInfo)psbeInfo.getBaseUnit(), (BigDecimal)supplementQty);
                psbeInfo.setBaseReqQty(baseSupplementQty);
                psbeInfo.setBaseIssuedTotalQty(ZERO);
                psbeInfo.setIssuedTotalQty(ZERO);
                psbeInfo.setBaseReturnedTotalQty(ZERO);
                psbeInfo.setReturnedTotalQty(ZERO);
                psbeInfo.setBasePickedTotalQty(ZERO);
                psbeInfo.setPickedTotalQty(ZERO);
                psbeInfo.setBaseSupplementTotalQty(ZERO);
                psbeInfo.setSupplementTotalQty(ZERO);
                psbeInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                psbeInfo.setSourcePsBillId(psbeInfo.getParent().getId().toString());
                psbeInfo.setSourcePsEntryBillId(psbeInfo.getId().toString());
                BOSUuid entryId = BOSUuid.create((String)"5F932B11");
                psbeInfo.setId(entryId);
                psbeInfo.setParent(supplementInfo);
                psbeInfo.remove("entries1");
                if (supplementInfo.getSourceBillId() != null && psbeInfo.getSourceBillEntryId() != null) {
                    upToPsBotEntry = new BOTRelationEntryInfo();
                    upToPsBotEntry.setId(BOSUuid.create((String)"B99C354C"));
                    upToPsBotEntry.setSrcObjectID(supplementInfo.getSourceBillId());
                    upToPsBotEntry.setDestObjectID(newid.toString());
                    upToPsBotEntry.setSrcEntryID(psbeInfo.getSourceBillEntryId());
                    upToPsBotEntry.setDestEntryID(entryId.toString());
                    upToPsBotEntry.setSrcEntryPropName("_src.stockEntry");
                    upToPsBotEntry.setDestEntryPropName("_dest.entries");
                    upToPsBotEntry.setDestPropertyName("id");
                    upToPsBotEntryCol.add(upToPsBotEntry);
                }
                psTopsBotEntry = new BOTRelationEntryInfo();
                psTopsBotEntry.setId(BOSUuid.create((String)"B99C354C"));
                psTopsBotEntry.setSrcObjectID(pk.toString());
                psTopsBotEntry.setDestObjectID(newid.toString());
                psTopsBotEntry.setSrcEntryID(psbeInfo.getSourceBillEntryId());
                psTopsBotEntry.setDestEntryID(entryId.toString());
                psTopsBotEntry.setSrcEntryPropName("_src.stockEntry");
                psTopsBotEntry.setDestEntryPropName("_dest.entries");
                psTopsBotEntry.setDestPropertyName("id");
                psToPsBotEntryCol.add(psTopsBotEntry);
            }
            supplementInfo.put("entries", (Object)supplementEntryCol);
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            iBOTRelation.addnew(psToPsbot);
            if (supplementInfo.getSourceBillType() != null && supplementInfo.getSourceBillId() != null) {
                iBOTRelation.addnew(upToPsBot);
            }
            this._save(ctx, (IObjectValue)supplementInfo);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        sic.add(new SelectorItemInfo("material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.materialPlan.id"));
        sic.add(new SelectorItemInfo("entries.materialPlan.isQuotaControl"));
        sic.add(new SelectorItemInfo("entries.materialPlan.issInHightLimit"));
        sic.add(new SelectorItemInfo("entries.materialPlan.issInLowLimit"));
        return sic;
    }

    private void autoDealPickingBillStatusAndOrderStatus(Context ctx, PickingSlipBillInfo srcpsbInfo) throws BOSException, EASBizException {
        boolean isComplete = this.isComplete(srcpsbInfo.getEntries());
        if (isComplete) {
            srcpsbInfo.setBaseStatus(BillBaseStatusEnum.FINISH);
            if (srcpsbInfo.getProductionOrder() != null) {
                ArrayList<String> orderId = new ArrayList<String>();
                orderId.add(srcpsbInfo.getProductionOrder().getId().toString());
                ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(orderId, true);
            }
        } else {
            srcpsbInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        }
    }

    protected void dealSupplementBySuite(Context ctx, IObjectPK pk, BigDecimal supplementSuite) throws EASBizException, BOSException {
        MultiMeasureUnitInfo basemultiUnifInfo;
        MultiMeasureUnitInfo multiUnifInfo;
        IMultiMeasureUnit multiUnit;
        SelectorItemCollection sicSrc = this.getSelectors();
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)this._getValue(ctx, pk, sicSrc);
        PickingSlipBillInfo supplementInfo = (PickingSlipBillInfo)psbInfo.clone();
        PickingSlipBillEntryInfo psbeInfo = null;
        BigDecimal baseSupplementSuite = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)psbInfo.getMaterial().getId().toString(), (MeasureUnitInfo)psbInfo.getUnit(), (MeasureUnitInfo)psbInfo.getMaterial().getBaseUnit(), (BigDecimal)supplementSuite);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String psNumber = codingRuleManager.getNumber((IObjectValue)supplementInfo, supplementInfo.getStorageOrgUnit().getId().toString());
        supplementInfo.setSourcePsBillId(psbInfo.getId().toString());
        supplementInfo.setNumber(psNumber);
        supplementInfo.setIsSupplement(true);
        supplementInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        supplementInfo.setReqSuite(supplementSuite);
        supplementInfo.setBaseReqSuite(baseSupplementSuite);
        supplementInfo.setPickedTotalSuite(ZERO);
        supplementInfo.setBasePickedTotalSuite(ZERO);
        supplementInfo.setReturnedTotalSuite(ZERO);
        supplementInfo.setBaseReturnedTotalSuite(ZERO);
        supplementInfo.setSupplementTotalSuite(ZERO);
        supplementInfo.setSupplementTotalSuite(ZERO);
        BOSUuid newid = BOSUuid.create((String)"A06DF1E1");
        supplementInfo.setId(newid);
        supplementInfo.setSupplementTotalSuite(supplementSuite);
        supplementInfo.setAuditor(null);
        supplementInfo.setAuditTime(null);
        supplementInfo.setModifier(null);
        supplementInfo.setModificationTime(null);
        supplementInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date today = new Date();
        supplementInfo.setCreateTime(new Timestamp(today.getTime()));
        supplementInfo.setBizDate(today);
        psbInfo.setSupplementTotalSuite(psbInfo.getSupplementTotalSuite().add(supplementSuite));
        psbInfo.setBaseSupplementTotalSuite(psbInfo.getBaseSupplementTotalSuite().add(baseSupplementSuite));
        PickingSlipBillEntryCollection supplementEntryCol = supplementInfo.getEntries();
        Iterator newit = supplementEntryCol.iterator();
        Calendar cal = Calendar.getInstance();
        BOTRelationInfo upToPsBot = new BOTRelationInfo();
        BOTRelationEntryCollection upToPsBotEntryCol = upToPsBot.getRelationEntries();
        BOTRelationEntryInfo upToPsBotEntry = null;
        if (supplementInfo.getSourceBillType() != null && supplementInfo.getSourceBillId() != null) {
            upToPsBot.setSrcEntityID(new ProductionOrderInfo().getBOSType().toString());
            upToPsBot.setDestEntityID("A06DF1E1");
            upToPsBot.setSrcObjectID(supplementInfo.getSourceBillId());
            upToPsBot.setDestObjectID(newid.toString());
            upToPsBot.setDate(cal.getTime());
            upToPsBot.setOperatorID(ctx.getCaller().toString());
            upToPsBot.setBOTMappingID(null);
            upToPsBot.setIsEffected(false);
            upToPsBot.setType(0);
        }
        BOTRelationInfo psToPsbot = new BOTRelationInfo();
        BOTRelationEntryCollection psToPsbotEntryCol = psToPsbot.getRelationEntries();
        BOTRelationEntryInfo psTopsBotEntry = null;
        psToPsbot.setSrcEntityID("A06DF1E1");
        psToPsbot.setDestEntityID("A06DF1E1");
        psToPsbot.setSrcObjectID(pk.toString());
        psToPsbot.setDestObjectID(newid.toString());
        psToPsbot.setDate(cal.getTime());
        psToPsbot.setOperatorID(ctx.getCaller().toString());
        psToPsbot.setBOTMappingID(null);
        psToPsbot.setIsEffected(false);
        psToPsbot.setType(0);
        PickingSlipBillEntryCollection psbeCol = psbInfo.getEntries();
        Iterator iter = psbeCol.iterator();
        while (iter.hasNext()) {
            psbeInfo = (PickingSlipBillEntryInfo)iter.next();
            multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            multiUnifInfo = multiUnit.getMultiUnit(psbeInfo.getMaterial().getId().toString(), psbeInfo.getUnit().getId().toString());
            basemultiUnifInfo = multiUnit.getMultiUnit(psbeInfo.getMaterial().getId().toString(), psbeInfo.getBaseUnit().getId().toString());
            psbeInfo.setSupplementTotalQty(psbeInfo.getSupplementTotalQty().add(psbeInfo.getReqQty().multiply(supplementSuite).divide(psbInfo.getReqSuite(), multiUnifInfo.getQtyPrecision(), 4)));
            psbeInfo.setBaseSupplementTotalQty(psbeInfo.getBaseSupplementTotalQty().subtract(psbeInfo.getBaseReqQty().multiply(supplementSuite).divide(psbInfo.getReqSuite(), basemultiUnifInfo.getQtyPrecision(), 4)));
        }
        this.autoDealPickingBillStatusAndOrderStatus(ctx, psbInfo);
        this._update(ctx, pk, (IObjectValue)psbInfo);
        while (newit.hasNext()) {
            psbeInfo = (PickingSlipBillEntryInfo)newit.next();
            multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            multiUnifInfo = multiUnit.getMultiUnit(psbeInfo.getMaterial().getId().toString(), psbeInfo.getUnit().getId().toString());
            basemultiUnifInfo = multiUnit.getMultiUnit(psbeInfo.getMaterial().getId().toString(), psbeInfo.getBaseUnit().getId().toString());
            psbeInfo.setReqQty(psbeInfo.getReqQty().multiply(supplementSuite).divide(psbInfo.getReqSuite(), multiUnifInfo.getQtyPrecision(), 4));
            psbeInfo.setBaseReqQty(psbeInfo.getBaseReqQty().multiply(supplementSuite).divide(psbInfo.getReqSuite(), basemultiUnifInfo.getQtyPrecision(), 4));
            psbeInfo.setBaseIssuedTotalQty(ZERO);
            psbeInfo.setIssuedTotalQty(ZERO);
            psbeInfo.setBaseReturnedTotalQty(ZERO);
            psbeInfo.setReturnedTotalQty(ZERO);
            psbeInfo.setBasePickedTotalQty(ZERO);
            psbeInfo.setPickedTotalQty(ZERO);
            psbeInfo.setBaseSupplementTotalQty(ZERO);
            psbeInfo.setSupplementTotalQty(ZERO);
            psbeInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            psbeInfo.setSourcePsBillId(psbeInfo.getParent().getId().toString());
            psbeInfo.setSourcePsEntryBillId(psbeInfo.getId().toString());
            psbeInfo.remove("entries1");
            BOSUuid entryId = BOSUuid.create((String)"5F932B11");
            if (supplementInfo.getSourceBillId() != null && psbeInfo.getSourceBillEntryId() != null) {
                upToPsBotEntry = new BOTRelationEntryInfo();
                upToPsBotEntry.setId(BOSUuid.create((String)"B99C354C"));
                upToPsBotEntry.setSrcObjectID(supplementInfo.getSourceBillId());
                upToPsBotEntry.setDestObjectID(newid.toString());
                upToPsBotEntry.setSrcEntryID(psbeInfo.getSourceBillEntryId());
                upToPsBotEntry.setDestEntryID(entryId.toString());
                upToPsBotEntry.setSrcEntryPropName("_src.stockEntry");
                upToPsBotEntry.setDestEntryPropName("_dest.entries");
                upToPsBotEntry.setDestPropertyName("id");
                upToPsBotEntryCol.add(upToPsBotEntry);
            }
            psTopsBotEntry = new BOTRelationEntryInfo();
            psTopsBotEntry.setId(BOSUuid.create((String)"B99C354C"));
            psTopsBotEntry.setSrcObjectID(pk.toString());
            psTopsBotEntry.setDestObjectID(newid.toString());
            psTopsBotEntry.setSrcEntryID(psbeInfo.getId().toString());
            psTopsBotEntry.setDestEntryID(entryId.toString());
            psTopsBotEntry.setSrcEntryPropName("_src.entries");
            psTopsBotEntry.setDestEntryPropName("_dest.entries");
            psTopsBotEntry.setDestPropertyName("id");
            psToPsbotEntryCol.add(psTopsBotEntry);
            psbeInfo.setId(entryId);
            psbeInfo.setParent(null);
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        iBOTRelation.addnew(psToPsbot);
        if (supplementInfo.getSourceBillType() != null && supplementInfo.getSourceBillId() != null) {
            iBOTRelation.addnew(upToPsBot);
        }
        this._save(ctx, (IObjectValue)supplementInfo);
    }

    @Override
    protected Map _pickingSlip_Gather(Context ctx, String tableName, String srcDataTempTable, Vector pickingSlipVec, String orgUnitID, IObjectPK[] pks, Map otherParam) throws BOSException, EASBizException {
        this.initPSParameter(ctx, orgUnitID);
        this.initPSParameterFromDBSet(ctx, orgUnitID);
        if (this.dividebyBillNum) {
            this.updateTempTable_srcData(ctx, srcDataTempTable, pickingSlipVec);
            this.insertDataIntoTempTable_gather(ctx, tableName, srcDataTempTable, null);
            this.updateTempTable_gatherData(ctx, tableName, srcDataTempTable, pickingSlipVec);
        } else {
            this.updateTempTable_gather(ctx, tableName, pickingSlipVec);
        }
        this.updateForSpanOrgProvide(ctx, tableName, "Picking", otherParam);
        String entryTableName = this.createTempTable_gatherRelation(ctx);
        this.registerGatherRelation(ctx, tableName, srcDataTempTable, entryTableName);
        this.divideBasePickingQty(ctx, tableName, srcDataTempTable, entryTableName);
        this.writeBack_PSTotalQty(ctx, srcDataTempTable);
        ArrayList keyList = new ArrayList();
        String companyOrgId = this.createMaterialReqBill_gather(ctx, tableName, srcDataTempTable, entryTableName, orgUnitID, otherParam, keyList);
        this.updateMaterialReqBill(ctx, tableName, srcDataTempTable, entryTableName, companyOrgId);
        this._releaseTempTable(ctx, entryTableName);
        HashMap result = new HashMap();
        result.put("result", keyList);
        return result;
    }

    private void updateTempTable_srcData(Context ctx, String srcDataTempTable, Vector pickingSlipVec) throws BOSException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        StringBuffer params = new StringBuffer();
        StringBuffer update_psqty = new StringBuffer();
        update_psqty.append(" update " + srcDataTempTable);
        update_psqty.append(" set  FReqQty = ? where FID = ? and FEntryID = ? ");
        Iterator iter = pickingSlipVec.iterator();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(update_psqty.toString());
            while (iter.hasNext()) {
                HashMap psMap = (HashMap)iter.next();
                int index = 1;
                batchStatement.setBigDecimal(index++, (BigDecimal)psMap.get("pickingQty"));
                batchStatement.setString(index++, (String)psMap.get("ID"));
                batchStatement.setString(index++, (String)psMap.get("entryID"));
                batchStatement.addBatch();
                if (params != null && params.toString().trim().length() > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(psMap.get("ID"));
                params.append("'");
            }
            batchStatement.executeBatch();
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
            String sql = "delete from " + srcDataTempTable + " where fid not in(" + params.toString() + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            this.update_exchangeQty(ctx, srcDataTempTable, "FReqQty", "FBaseReqQty", 1);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private void updateTempTable_gatherData(Context ctx, String tableName, String srcDataTempTable, Vector pickingSlipVec) throws BOSException {
        StringBuffer updatePickQty = new StringBuffer();
        updatePickQty.append("update " + tableName + " as t1 set FPickingQty = FReqQty");
        DbUtil.execute((Context)ctx, (String)updatePickQty.toString());
        this.update_exchangeQty(ctx, tableName, "FPickingQty", "FBasePickingQty", 1);
        updatePickQty = new StringBuffer();
        updatePickQty.append("update " + tableName + " as t1 set FBaseReqQty = FBasePickingQty");
        DbUtil.execute((Context)ctx, (String)updatePickQty.toString());
        String sql2 = " update " + tableName + " as t1 set FMaterialReqEntryID = select newbosid('11774BB4') from " + tableName + " as t2  where t1.fid = t2.fid";
        DbUtil.execute((Context)ctx, (String)sql2);
    }

    @Override
    protected Map _returnSlip_BySuite(Context ctx, Vector returnSlipVec, String orgUnitID, IObjectPK[] pks, Map otherParam) throws BOSException, EASBizException {
        this.initPSParameter(ctx, orgUnitID);
        this.initPSParameterFromDBSet(ctx, orgUnitID);
        String tableName = this.createTempPSTable(ctx);
        this.writeBack_returnedSuite(ctx, returnSlipVec);
        ArrayList keyList = new ArrayList();
        for (HashMap psb : returnSlipVec) {
            String pickingSlipid = psb.get("ID").toString();
            BigDecimal suite = (BigDecimal)psb.get("returningSuite");
            BigDecimal supplementSuite = (BigDecimal)psb.get("supplementSuite");
            this.insertDataIntoTempTable_bysuite(ctx, tableName, pickingSlipid, suite, "Return");
            this.updateForSpanOrgProvide(ctx, tableName, "Return", otherParam);
            keyList.addAll(this.createMaterialReqBill(ctx, tableName, "Return", orgUnitID, otherParam));
            if (supplementSuite.compareTo(ZERO) <= 0) continue;
            this.dealSupplementBySuite(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)pickingSlipid)), supplementSuite);
        }
        HashMap result = new HashMap();
        result.put("result", keyList);
        this._releaseTempTable(ctx, tableName);
        return result;
    }

    @Override
    protected Map _returnSlip_Simple(Context ctx, String tableName, Vector returnSlipVec, String orgUnitID, IObjectPK pk, Map otherParam) throws BOSException, EASBizException {
        this.initPSParameter(ctx, orgUnitID);
        this.initPSParameterFromDBSet(ctx, orgUnitID);
        this.updateTempTable(ctx, tableName, returnSlipVec, "Return", otherParam);
        List keyList = this.createMaterialReqBill(ctx, tableName, "Return", orgUnitID, otherParam);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("result", keyList);
        this.dealSupplementSimple(ctx, pk, returnSlipVec);
        return result;
    }

    private List createMaterialReqBill(Context ctx, String tableName, String mode, String orgUnitID, Map otherParam) throws BOSException, EASBizException {
        return null;
    }

    private void updateMaterialReqBill(Context ctx, String tableName, String srcDataTempTable, String entryTableName, String companyOrgId) throws BOSException, EASBizException {
        try {
            String getMaterialReqEntry = "select FMaterialReqEntryID from " + tableName;
            StringBuffer getProductIdBuffer = new StringBuffer();
            getProductIdBuffer.append("select b.fproductid from ");
            getProductIdBuffer.append(entryTableName).append(" a inner join  ");
            getProductIdBuffer.append(srcDataTempTable).append(" b ");
            getProductIdBuffer.append("on a.fid = b.fid and a.fentryid = b.fentryid inner join ");
            getProductIdBuffer.append(tableName).append(" c ");
            getProductIdBuffer.append("on a.fgatherid = c.fid ");
            getProductIdBuffer.append("where c.FMaterialReqEntryID = ? ");
            String getProductId = getProductIdBuffer.toString();
            String updateMaterialReqEntry = "update T_IM_MaterialReqBillEntry set FCostObjectID = ? where FID = ? ";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getMaterialReqEntry);
            HashMap<String, CostObjectInfo> coInfoMap = new HashMap<String, CostObjectInfo>();
            while (rs.next()) {
                Iterator iterator;
                String productId;
                String materialReqEntryId = rs.getString(1);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getProductId, (Object[])new Object[]{materialReqEntryId});
                HashSet<String> set = new HashSet<String>();
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
                if (set.size() != 1 || (productId = (String)(iterator = set.iterator()).next()) == null) continue;
                CostObjectInfo coInfo = null;
                if (!coInfoMap.containsKey(productId)) {
                    coInfo = this.getDefaultCostObject(ctx, productId, companyOrgId, null);
                    coInfoMap.put(productId, coInfo);
                } else {
                    coInfo = (CostObjectInfo)coInfoMap.get(productId);
                }
                if (coInfo == null) continue;
                String coId = coInfo.getId().toString();
                params.add(new Object[]{coId, materialReqEntryId});
            }
            if (params.size() > 0) {
                DBBatchUtil.executeBatch((Context)ctx, (String)updateMaterialReqEntry, params);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CostObjectInfo getDefaultCostObject(Context ctx, String materialId, String companyId, String lot) throws BOSException, EASBizException {
        CostObjectInfo costObjectInfo = null;
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = iMaterial.getCompanyInfo(materialId, companyId);
        if (aMaterialCompanyInfoInfo == null) return costObjectInfo;
        if (aMaterialCompanyInfoInfo.getAccountType() == null) return costObjectInfo;
        int countLot = 0;
        if ((lot == null || lot.length() == 0) && AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
            return costObjectInfo;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("select bill.fid as FID,bill.FCalculateMode as FCalculateMode");
        bf.append(" from T_BD_CostObject bill");
        bf.append(" inner join T_BD_CostObjectEntry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" where bill.FIsForbiden =? and bill.FCompanyID=? and entry.FRelatedID=?");
        if (lot != null && lot.length() > 0 && AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
            bf.append(" and bill.FBatchNumber = ?");
        }
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            String costId;
            block30: {
                conn = this.getConnection(ctx);
                pm = conn.prepareStatement(sql);
                pm.setInt(1, 0);
                pm.setString(2, companyId);
                pm.setString(3, materialId);
                if (lot != null && lot.length() > 0 && AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
                    pm.setString(4, lot);
                }
                rs = pm.executeQuery();
                String costIdByClass = null;
                String costIdByBatch = null;
                costId = null;
                int i = 0;
                while (rs.next()) {
                    i = new Integer(rs.getString("FCalculateMode"));
                    if (4 == i) {
                        costIdByBatch = rs.getString("FID");
                        ++countLot;
                        continue;
                    }
                    costIdByClass = rs.getString("FID");
                }
                if (AccountType.SPECIAL_ACCT.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
                    if (countLot > 1) {
                        CostObjectInfo costObjectInfo2 = costObjectInfo;
                        return costObjectInfo2;
                    }
                    if (lot != null && lot.length() > 0) {
                        costId = costIdByBatch;
                        break block30;
                    } else {
                        CostObjectInfo costObjectInfo3 = costObjectInfo;
                        return costObjectInfo3;
                    }
                }
                costId = costIdByClass;
            }
            if (costId == null) return costObjectInfo;
            if (costId.length() <= 0) return costObjectInfo;
            ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
            CostObjectInfo costObjectInfo4 = costObjectInfo = iCostObject.getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            return costObjectInfo4;
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
                if (null != pm) {
                    pm.close();
                }
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
    }

    private String createMaterialReqBill_gather(Context ctx, String tableName, String srcDataTempTable, String entryTableName, String orgUnitID, Map otherParam, List keyList) throws BOSException, EASBizException {
        StorageOrgUnitInfo orgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgUnitID)));
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(orgUnitInfo.getId());
        if (companyOriUnitInfo == null) {
            throw new PickingSlipBillException(PickingSlipBillException.STORAGEORGNOTHASCOMPANYORG);
        }
        String creatorID = ctx.getCaller().toString();
        Connection conn = null;
        PreparedStatement batchStatement = null;
        PreparedStatement batchStatement2 = null;
        PreparedStatement batchStatement3 = null;
        PreparedStatement batchStatement4 = null;
        IRowSet rs = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        MaterialReqBillInfo mrbInfo = new MaterialReqBillInfo();
        mrbInfo.setStorageOrgUnit(orgUnitInfo);
        mrbInfo.setBizDate(new Date());
        mrbInfo.setCU(orgUnitInfo.getCU());
        StringBuffer sql_addMaterialReq = new StringBuffer();
        sql_addMaterialReq.append("insert into T_IM_MaterialReqBill(FID,FNUMBER,FSTORAGEORGUNITID,FADMINORGUNITID,");
        sql_addMaterialReq.append(" FTRANSACTIONTYPEID,");
        sql_addMaterialReq.append(" FBIZTYPEID,");
        sql_addMaterialReq.append(" FDemandCompanyOrgUnitID,");
        sql_addMaterialReq.append(" FSupplyStoreOrgUnitID,");
        sql_addMaterialReq.append(" FSupplyCompanyOrgUnitID,");
        sql_addMaterialReq.append(" FBILLTYPEID,FCONTROLUNITID,");
        sql_addMaterialReq.append(" FISREVERSED,");
        sql_addMaterialReq.append(" FSOURCEBILLTYPEID,FBASESTATUS,FCREATETIME,FBIZDATE,FCREATORID)");
        sql_addMaterialReq.append("values(?,?,?,?,?,?,?,?,?,");
        sql_addMaterialReq.append("'50957179-0105-1000-e000-0163c0a812fd463ED552','" + orgUnitInfo.getCU().getId() + "',");
        sql_addMaterialReq.append("0,");
        sql_addMaterialReq.append("'3fY8szOQTQmfaNi+Tm5SJUY+1VI=',1");
        sql_addMaterialReq.append(",now(),now(),'" + creatorID + "')");
        StringBuffer sql_addMaterialReqEntry = new StringBuffer();
        sql_addMaterialReqEntry.append("insert into T_IM_MaterialReqBillEntry(FID,FParentID,FSTORAGEORGUNITID,FMATERIALID,FUNITID,FBASEUNITID,");
        sql_addMaterialReqEntry.append("FCOMPANYORGUNITID,");
        sql_addMaterialReqEntry.append("FBASESTATUS,");
        sql_addMaterialReqEntry.append("FSOURCEBILLENTRYID,");
        sql_addMaterialReqEntry.append("FSeq,");
        sql_addMaterialReqEntry.append("FTRACKNUMBERID,");
        sql_addMaterialReqEntry.append("FISSUEQTY,FBASEISSUEQTY,FQTY,FBASEQTY,FLOT,");
        sql_addMaterialReqEntry.append("FWAREHOUSEID,");
        sql_addMaterialReqEntry.append("FSupplyWarehouseID,");
        sql_addMaterialReqEntry.append("FSupplyLocationID,");
        sql_addMaterialReqEntry.append("FLOCATIONID,FSTOCKERID,FPRODUCTLINEID,");
        sql_addMaterialReqEntry.append("FPRODUCTLINEWPID,FSALEORDERID,FSALEORDERNUM,FTRACENO,FPICKINGDATE,FDEMANDDATE, FAssistUnitId,FAssistQty) ");
        sql_addMaterialReqEntry.append("select  t1.FMaterialReqEntryID,t1.FMaterialReqBillID,t1.FStorageOrgUnitID,t1.FMaterialID,t1.FUnitID,t1.FBaseUnitID,");
        sql_addMaterialReqEntry.append("'" + companyOriUnitInfo.getId().toString() + "',");
        sql_addMaterialReqEntry.append("1,");
        sql_addMaterialReqEntry.append(" t1.fid,");
        sql_addMaterialReqEntry.append(" t1.fseq,");
        sql_addMaterialReqEntry.append(" t1.FtrackNumberID,");
        sql_addMaterialReqEntry.append("t1.FPickingQty,t1.FBasePickingQty,t1.FPickingQty,t1.FBasePickingQty,");
        sql_addMaterialReqEntry.append("case when t1.FLotNo='null value' then null else t1.FLotNo end as flotno,");
        sql_addMaterialReqEntry.append("t1.FRequirementWarehouseID,t1.FSupplyWarehouseID,FSupplyLocationID,FRequirementLocationID,");
        sql_addMaterialReqEntry.append("t1.FStoreAdminID,t1.FProductLineID,");
        sql_addMaterialReqEntry.append("t1.FProductLineWPEntryID,t1.FSaleOrderID,t2.fnumber,t1.FTraceNo,now(),t1.FPickingDate, ");
        sql_addMaterialReqEntry.append("t4.FAssistUnit,");
        sql_addMaterialReqEntry.append("ISNULL(ROUND(t1.FBasePickingQty/t5.FBaseConvsRate,t5.FQtyPrecision),0)");
        sql_addMaterialReqEntry.append("from " + tableName + " t1 ");
        sql_addMaterialReqEntry.append(" left join T_SD_SaleOrder t2 on t1.fsaleorderid = t2.fid");
        sql_addMaterialReqEntry.append(" left join T_BD_Material t4 on t4.fid = t1.FMaterialID");
        sql_addMaterialReqEntry.append(" left join t_bd_multiMeasureUnit t5 on t5.fmaterialId = t1.FMaterialID and t5.fMeasureUnitID = t4.FAssistUnit");
        if (this.dividebyBillNum) {
            sql_addMaterialReqEntry.append(" order by t1.fnumber,t1.fseq ");
        }
        StringBuffer sql_addMaterialReqPriceEntry = new StringBuffer();
        sql_addMaterialReqPriceEntry.append("insert into T_im_MaterialReqBillPriceInfo(FID,FParentID,FMATERIALID,FUNITID,FBASEUNITID,fmaterialreqentryid,fsourcebillentryid)");
        sql_addMaterialReqPriceEntry.append(" select newbosid('97A53E9B'), FMaterialReqBillID, FMaterialID , FUnitID, FBaseUnitID, FMaterialReqEntryID, fid ");
        sql_addMaterialReqPriceEntry.append(" from " + tableName);
        String sql_addRelation = "insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values(?,'A06DF1E1','500AB75E',?,?,now(),'" + creatorID + "',1,null,0)";
        StringBuffer sql_addRelationEntry = new StringBuffer();
        sql_addRelationEntry.append(" insert into t_bot_relationentry(FID,FSRCOBJECTID,FDESTOBJECTID,FSRCENTRYID,FDESTENTRYID,");
        sql_addRelationEntry.append("FSRCENTRYPROPNAME,FDESTENTRYPROPNAME,FSRCPROPERTYNAME,FDESTPROPERTYNAME,FVALUE,FKEYID)");
        sql_addRelationEntry.append(" select newbosid('B99C354C'),t2.FID,t1.FMaterialReqBillID,t2.FEntryID,t1.FMaterialReqEntryID");
        sql_addRelationEntry.append(",'__src.entries','__dest.entries',null,'id',null,t2.FRelationID ");
        sql_addRelationEntry.append(" from " + tableName + " t1," + entryTableName + " t2, " + srcDataTempTable + " t3 ");
        sql_addRelationEntry.append(" where t1.fid = t2.fgatherid and t2.fentryid = t3.fentryid ");
        sql_addRelationEntry.append(" and t3.FBasePickingQty >0");
        StringBuffer sql_PSMRRelation = new StringBuffer();
        sql_PSMRRelation.append(" insert into T_MM_PSMRRelation(FID,FSrcEntryID,FTempEntryID,");
        sql_PSMRRelation.append("FPickingQty,FBasePickingQty,FUnitID,FBaseUnitID,FPriority)");
        sql_PSMRRelation.append(" select newbosid('1A3CAE4B'),t3.FEntryID,t1.fid,");
        sql_PSMRRelation.append("t3.FPickingQty,t3.FBasePickingQty, ");
        sql_PSMRRelation.append("t3.FUnitID,t3.FBaseUnitID,t3.FPriority ");
        sql_PSMRRelation.append(" from " + tableName + " t1," + entryTableName + " t2, " + srcDataTempTable + " t3 ");
        sql_PSMRRelation.append(" where t1.fid = t2.fgatherid and t2.fentryid = t3.fentryid ");
        sql_PSMRRelation.append(" and t3.FBasePickingQty >0");
        String sql_updateTempTable = "update " + tableName + " set FMaterialReqBillID =? where FID = ?";
        StringBuffer sql_getGatherIds = new StringBuffer();
        sql_getGatherIds.append(" select  fid as gatherid from " + tableName);
        sql_getGatherIds.append(" where FStorageOrgUnitID = ?");
        sql_getGatherIds.append(" and FWorkshopID = ?");
        if (this.dividebyWareHouse) {
            sql_getGatherIds.append(" and isnull(FWarehouseID,'null value') = ?");
        }
        sql_getGatherIds.append(" and FProvideType = ?");
        sql_getGatherIds.append(" and FTransTypeID = ?");
        sql_getGatherIds.append(" and FBizTypeID = ?");
        sql_getGatherIds.append(" and FSupplyStorageOrgUnitID = ?");
        sql_getGatherIds.append(" and FSupplyCompanyUnitID = ?");
        sql_getGatherIds.append(" and FRequirementCompanyUnitID = ?");
        if (this.dividebyProductline) {
            sql_getGatherIds.append(" and FProductLineID = ?");
        }
        if (this.dividebyProductlineWP) {
            sql_getGatherIds.append(" and isnull(FProductLineWPEntryID,'null value') = ?");
        }
        StringBuffer sql_getPSIds = new StringBuffer();
        sql_getPSIds.append(" select distinct t2.fid as pickingslipid from " + tableName + " t1," + entryTableName + " t2");
        sql_getPSIds.append(" where t1.fid  = t2.fgatherid");
        sql_getPSIds.append(" and t1.FStorageOrgUnitID = ?");
        sql_getPSIds.append(" and t1.FWorkshopID = ?");
        if (this.dividebyWareHouse) {
            sql_getPSIds.append(" and isnull(t1.FWarehouseID,'null value') = ? ");
        }
        sql_getPSIds.append(" and FProvideType = ?");
        sql_getPSIds.append(" and FTransTypeID = ?");
        sql_getPSIds.append(" and FBizTypeID = ?");
        sql_getPSIds.append(" and FSupplyStorageOrgUnitID = ?");
        sql_getPSIds.append(" and FSupplyCompanyUnitID = ?");
        sql_getPSIds.append(" and FRequirementCompanyUnitID = ?");
        if (this.dividebyProductline) {
            sql_getPSIds.append(" and t1.FProductLineID = ?");
        }
        if (this.dividebyProductlineWP) {
            sql_getPSIds.append(" and isnull(t1.FProductLineWPEntryID,'null value') = ? ");
        }
        StringBuffer sql_updateTempEntry = new StringBuffer();
        sql_updateTempEntry.append(" update " + entryTableName + " set FRelationID = ?");
        sql_updateTempEntry.append(" where fid = ? and fgatherid in");
        sql_updateTempEntry.append("(select  fid as gatherid from " + tableName);
        sql_updateTempEntry.append(" where FStorageOrgUnitID = ?");
        sql_updateTempEntry.append(" and FWorkshopID = ?");
        sql_updateTempEntry.append(" and FProvideType = ?");
        sql_updateTempEntry.append(" and FTransTypeID = ?");
        sql_updateTempEntry.append(" and FBizTypeID = ?");
        sql_updateTempEntry.append(" and FSupplyStorageOrgUnitID = ?");
        sql_updateTempEntry.append(" and FSupplyCompanyUnitID = ?");
        sql_updateTempEntry.append(" and FRequirementCompanyUnitID = ?");
        if (this.dividebyProductline) {
            sql_updateTempEntry.append(" and FProductLineID = ? ");
        }
        if (this.dividebyProductlineWP) {
            sql_updateTempEntry.append(" and isnull(FProductLineWPEntryID,'null value') = ? ");
        }
        if (this.dividebyWareHouse) {
            sql_updateTempEntry.append(" and isnull(FWarehouseID,'null value') = ? ");
        }
        sql_updateTempEntry.append(" )");
        StringBuffer sql_dividing = new StringBuffer();
        sql_dividing.append("select  FStorageOrgUnitID,FWorkshopID");
        if (this.dividebyWareHouse) {
            sql_dividing.append(",FWarehouseID");
        }
        sql_dividing.append(",FProvideType,FTransTypeID, FBizTypeID,FSupplyStorageOrgUnitID,FSupplyCompanyUnitID ,FRequirementCompanyUnitID");
        if (this.dividebyProductline) {
            sql_dividing.append(",FProductLineID");
        }
        if (this.dividebyProductlineWP) {
            sql_dividing.append(",FProductLineWPEntryID");
        }
        sql_dividing.append(" from " + tableName);
        sql_dividing.append(" group by FStorageOrgUnitID,FWorkshopID");
        if (this.dividebyWareHouse) {
            sql_dividing.append(",FWarehouseID");
        }
        sql_dividing.append(",FProvideType, FTransTypeID, FBizTypeID,FSupplyStorageOrgUnitID,FSupplyCompanyUnitID ,FRequirementCompanyUnitID");
        if (this.dividebyProductline) {
            sql_dividing.append(",FProductLineID");
        }
        if (this.dividebyProductlineWP) {
            sql_dividing.append(",FProductLineWPEntryID");
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sql_addMaterialReq.toString());
            batchStatement2 = conn.prepareStatement(sql_addRelation);
            batchStatement3 = conn.prepareStatement(sql_updateTempTable);
            batchStatement4 = conn.prepareStatement(sql_updateTempEntry.toString());
            PreparedStatement ps = conn.prepareStatement(sql_getGatherIds.toString());
            PreparedStatement ps2 = conn.prepareStatement(sql_getPSIds.toString());
            ResultSet gatheridRs = null;
            ResultSet psidRs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql_dividing.toString());
            while (rs.next()) {
                BOSUuid materialReqID = BOSUuid.create((String)"500AB75E");
                keyList.add(materialReqID.toString());
                int index = 1;
                batchStatement.setString(index++, materialReqID.toString());
                batchStatement.setString(index++, codingRuleManager.getNumber((IObjectValue)mrbInfo, orgUnitID));
                batchStatement.setString(index++, rs.getString("FStorageOrgUnitID"));
                batchStatement.setString(index++, rs.getString("FWorkshopID"));
                batchStatement.setString(index++, rs.getString("FTransTypeID"));
                batchStatement.setString(index++, rs.getString("FBizTypeID"));
                batchStatement.setString(index++, rs.getString("FRequirementCompanyUnitID"));
                batchStatement.setString(index++, rs.getString("FSupplyStorageOrgUnitID"));
                batchStatement.setString(index++, rs.getString("FSupplyCompanyUnitID"));
                batchStatement.addBatch();
                int index2 = 1;
                ps.setString(index2++, rs.getString("FStorageOrgUnitID"));
                ps.setString(index2++, rs.getString("FWorkshopID"));
                if (this.dividebyWareHouse) {
                    if (rs.getString("FWarehouseID") == null) {
                        ps.setString(index2++, "null value");
                    } else {
                        ps.setString(index2++, rs.getString("FWarehouseID"));
                    }
                }
                ps.setInt(index2++, rs.getInt("FProvideType"));
                ps.setString(index2++, rs.getString("FTransTypeID"));
                ps.setString(index2++, rs.getString("FBizTypeID"));
                ps.setString(index2++, rs.getString("FSupplyStorageOrgUnitID"));
                ps.setString(index2++, rs.getString("FSupplyCompanyUnitID"));
                ps.setString(index2++, rs.getString("FRequirementCompanyUnitID"));
                if (this.dividebyProductline) {
                    ps.setString(index2++, rs.getString("FProductLineID"));
                }
                if (this.dividebyProductlineWP) {
                    if (rs.getString("FProductLineWPEntryID") == null) {
                        ps.setString(index2++, "null value");
                    } else {
                        ps.setString(index2++, rs.getString("FProductLineWPEntryID"));
                    }
                }
                gatheridRs = ps.executeQuery();
                while (gatheridRs.next()) {
                    batchStatement3.setString(1, materialReqID.toString());
                    batchStatement3.setString(2, gatheridRs.getString("gatherid"));
                    batchStatement3.addBatch();
                }
                int index3 = 1;
                ps2.setString(index3++, rs.getString("FStorageOrgUnitID"));
                ps2.setString(index3++, rs.getString("FWorkshopID"));
                if (this.dividebyWareHouse) {
                    if (rs.getString("FWarehouseID") == null) {
                        ps2.setString(index3++, "null value");
                    } else {
                        ps2.setString(index3++, rs.getString("FWarehouseID"));
                    }
                }
                ps2.setInt(index3++, rs.getInt("FProvideType"));
                ps2.setString(index3++, rs.getString("FTransTypeID"));
                ps2.setString(index3++, rs.getString("FBizTypeID"));
                ps2.setString(index3++, rs.getString("FSupplyStorageOrgUnitID"));
                ps2.setString(index3++, rs.getString("FSupplyCompanyUnitID"));
                ps2.setString(index3++, rs.getString("FRequirementCompanyUnitID"));
                if (this.dividebyProductline) {
                    ps2.setString(index3++, rs.getString("FProductLineID"));
                }
                if (this.dividebyProductlineWP) {
                    if (rs.getString("FProductLineWPEntryID") == null) {
                        ps2.setString(index3++, "null value");
                    } else {
                        ps2.setString(index3++, rs.getString("FProductLineWPEntryID"));
                    }
                }
                psidRs = ps2.executeQuery();
                while (psidRs.next()) {
                    BOSUuid relationID = BOSUuid.create((String)"59302EC6");
                    batchStatement2.setString(1, relationID.toString());
                    batchStatement2.setString(2, psidRs.getString("pickingslipid"));
                    batchStatement2.setString(3, materialReqID.toString());
                    batchStatement2.addBatch();
                    int index4 = 1;
                    batchStatement4.setString(index4++, relationID.toString());
                    batchStatement4.setString(index4++, psidRs.getString("pickingslipid"));
                    batchStatement4.setString(index4++, rs.getString("FStorageOrgUnitID"));
                    batchStatement4.setString(index4++, rs.getString("FWorkshopID"));
                    batchStatement4.setInt(index4++, rs.getInt("FProvideType"));
                    batchStatement4.setString(index4++, rs.getString("FTransTypeID"));
                    batchStatement4.setString(index4++, rs.getString("FBizTypeID"));
                    batchStatement4.setString(index4++, rs.getString("FSupplyStorageOrgUnitID"));
                    batchStatement4.setString(index4++, rs.getString("FSupplyCompanyUnitID"));
                    batchStatement4.setString(index4++, rs.getString("FRequirementCompanyUnitID"));
                    if (this.dividebyProductline) {
                        batchStatement4.setString(index4++, rs.getString("FProductLineID"));
                    }
                    if (this.dividebyProductlineWP) {
                        if (rs.getString("FProductLineWPEntryID") == null) {
                            batchStatement4.setString(index4++, "null value");
                        } else {
                            batchStatement4.setString(index4++, rs.getString("FProductLineWPEntryID"));
                        }
                    }
                    if (this.dividebyWareHouse) {
                        if (rs.getString("FWarehouseID") == null) {
                            batchStatement4.setString(index4++, "null value");
                        } else {
                            batchStatement4.setString(index4++, rs.getString("FWarehouseID"));
                        }
                    }
                    batchStatement4.addBatch();
                }
            }
            SQLUtils.cleanup(gatheridRs, (Statement)ps);
            SQLUtils.cleanup(psidRs, (Statement)ps2);
            batchStatement.executeBatch();
            batchStatement2.executeBatch();
            batchStatement3.executeBatch();
            batchStatement4.executeBatch();
            SQLUtils.cleanup((Statement)batchStatement2);
            SQLUtils.cleanup((Statement)batchStatement3);
            SQLUtils.cleanup((Statement)batchStatement4);
            SQLUtils.cleanup((ResultSet)rs, (Statement)batchStatement, (Connection)conn);
            if (this.dividebyBillNum) {
                this.updateGatherSeq(tableName, ctx);
            }
            DbUtil.execute((Context)ctx, (String)sql_addMaterialReqEntry.toString());
            DbUtil.execute((Context)ctx, (String)sql_addMaterialReqPriceEntry.toString());
            DbUtil.execute((Context)ctx, (String)sql_addRelationEntry.toString());
            DbUtil.execute((Context)ctx, (String)sql_PSMRRelation.toString());
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement2);
                SQLUtils.cleanup(batchStatement3);
                SQLUtils.cleanup(batchStatement4);
                SQLUtils.cleanup(rs, (Statement)batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement2);
        SQLUtils.cleanup((Statement)batchStatement3);
        SQLUtils.cleanup((Statement)batchStatement4);
        SQLUtils.cleanup((ResultSet)rs, (Statement)batchStatement, (Connection)conn);
        PickingSlipBillFactory.getLocalInstance(ctx).afterCreateMaterialReqBill(keyList);
        return companyOriUnitInfo.getId().toString();
    }

    private void updateGatherSeq(String tableName, Context ctx) throws BOSException {
        StringBuffer sql_gather = new StringBuffer();
        sql_gather.append(" select FMaterialReqBillID,FNumber,FId,FSeq from " + tableName + " order by FMaterialReqBillID,FNumber,FSeq");
        Connection conn = null;
        IRowSet rs = null;
        String updateQty = "update " + tableName + " set FSeq = ? where FMaterialReqBillID = ? and fnumber = ? and FSeq = ?";
        PreparedStatement batchStatement = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql_gather.toString());
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(updateQty);
            String str_MaterialReqBillID = null;
            int seq = 1;
            while (rs.next()) {
                String number = rs.getString("FNumber");
                int seqSource = rs.getInt("fseq");
                if (str_MaterialReqBillID == null) {
                    str_MaterialReqBillID = rs.getString("FMaterialReqBillID");
                } else if (!str_MaterialReqBillID.equals(rs.getString("FMaterialReqBillID"))) {
                    seq = 1;
                }
                batchStatement.setInt(1, seq++);
                batchStatement.setString(2, str_MaterialReqBillID);
                batchStatement.setString(3, number);
                batchStatement.setInt(4, seqSource);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private void insertDataIntoTempTable_bysuite(Context ctx, String tableName, String id, BigDecimal suite, String mode) throws BOSException {
        String sql = "delete from " + tableName;
        DbUtil.execute((Context)ctx, (String)sql);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tableName);
        sqlBuffer.append("(FID ,");
        sqlBuffer.append("FNumber,");
        sqlBuffer.append("FEntryID,");
        sqlBuffer.append("FSeq,");
        sqlBuffer.append("FStorageOrgUnitID,");
        sqlBuffer.append("FProvideType,");
        sqlBuffer.append("FSupplyStorageOrgUnitID,");
        sqlBuffer.append("FSupplyCompanyUnitID,");
        sqlBuffer.append("FRequirementCompanyUnitID,");
        sqlBuffer.append("FWorkshopID,");
        sqlBuffer.append("FClassGroupID,");
        sqlBuffer.append("FPersonID,");
        sqlBuffer.append("FProductLineID,");
        sqlBuffer.append("FTraceNo,");
        sqlBuffer.append("FTrackNumberID,");
        sqlBuffer.append("FProductionOrderID,");
        sqlBuffer.append("FSaleOrderID,");
        sqlBuffer.append("FMaterialID,");
        sqlBuffer.append("FLotNo,");
        sqlBuffer.append("FWarehouseID,");
        sqlBuffer.append("FLocationID,");
        sqlBuffer.append("FStoreAdminID,");
        sqlBuffer.append("FReqQty,");
        sqlBuffer.append("FPickingQty,");
        sqlBuffer.append("FUnitID,");
        sqlBuffer.append("FBaseUnitID,");
        sqlBuffer.append("FBasePickingQty,");
        sqlBuffer.append("FProductLineWPEntryID,");
        sqlBuffer.append("FPickingDate,");
        sqlBuffer.append("FDividingKey,");
        sqlBuffer.append("FMaterialReqBillID,");
        sqlBuffer.append("FMaterialReqEntryID,");
        sqlBuffer.append("FRelationID)");
        if (mode.equals("Picking")) {
            sqlBuffer.append(" select result.*,null,newbosid('11774BB4'),null from(");
            sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
            sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
            sqlBuffer.append("t2.FProvideType as provideType,");
            sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
            sqlBuffer.append("tour.FToUnitID as supplyCompanyUnitID,");
            sqlBuffer.append("tourEntry.FToUnitID as requirementCompanyUnitID,");
            sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
            sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,");
            sqlBuffer.append("t1.ftracknumberid as tracknumberid,");
            sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
            sqlBuffer.append("t2.fmaterialid as materialid,t2.flotno as lotno,t2.fwarehouseid as warehouseid,");
            sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
            sqlBuffer.append("t2.freqqty as reqqty,");
            sqlBuffer.append("round(decimal(t2.freqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t6.FQtyPrecision) as pickingQty,");
            sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
            sqlBuffer.append("round(decimal(t2.fbasereqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t7.FQtyPrecision) as basepickingQty,");
            sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
            sqlBuffer.append("t2.fpickingdate as pickingdate,");
            sqlBuffer.append("t1.fstorageorgunitid||t1.fworkshopid");
            if (this.dividebyWareHouse) {
                sqlBuffer.append("||isnull(t2.fwarehouseid,'')");
            }
            sqlBuffer.append("||to_char(t2.FProvideType)||t2.FSupplyStorageOrgUnitID || tour.FToUnitID || tourEntry.FToUnitID ");
            if (this.dividebyProductline) {
                sqlBuffer.append("||t1.fproductlineid");
            }
            if (this.dividebyProductlineWP) {
                sqlBuffer.append("||isnull(t2.fproductlinewpid,'')");
            }
            sqlBuffer.append(" as dividingKey ");
            sqlBuffer.append("from   t_mm_pickingslipbill t1 left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid,");
            sqlBuffer.append("t_mm_pickingslipbillentry t2 ,t_bd_multimeasureunit  t6,t_bd_multimeasureunit  t7 ");
            sqlBuffer.append(" left join (select distinct tou.FFromUnitID as FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
            sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
            sqlBuffer.append(" ) tour on 1=1");
            sqlBuffer.append(" left join (select distinct tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
            sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
            sqlBuffer.append(" ) tourEntry on 1=1");
            sqlBuffer.append(" where tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and tour.FFromUnitID = t1.FStorageOrgUnitID ");
            sqlBuffer.append("and t1.fid = t2.fparentid and t1.fid = '" + id + "' ");
            sqlBuffer.append("and  t2.FLineStatus != 2 ");
            sqlBuffer.append("and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid  ");
            sqlBuffer.append("and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid )");
            sqlBuffer.append(") as result");
        } else {
            sqlBuffer.append(" select result.*,null,newbosid('11774BB4'),null from(");
            sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
            sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
            sqlBuffer.append("t2.FProvideType as provideType,");
            sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
            sqlBuffer.append("tour.FToUnitID as supplyCompanyUnitID,");
            sqlBuffer.append("tourEntry.FToUnitID as requirementCompanyUnitID,");
            sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
            sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,");
            sqlBuffer.append("t1.ftracknumberid as tracknumberid,");
            sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
            sqlBuffer.append("t2.fmaterialid as materialid,null as lotno,t2.fwarehouseid as warehouseid,");
            sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
            sqlBuffer.append("t2.freqqty-t2.fpickedtotalqty+t2.freturnedtotalqty as reqqty,");
            sqlBuffer.append("round(decimal(t2.freqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t6.FQtyPrecision) as pickingQty,");
            sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
            sqlBuffer.append("round(decimal(t2.fbasereqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t7.FQtyPrecision) as basepickingQty,");
            sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
            sqlBuffer.append("t2.fpickingdate as pickingdate,");
            sqlBuffer.append("t1.fstorageorgunitid||t1.fworkshopid");
            if (this.dividebyWareHouse) {
                sqlBuffer.append("||isnull(t2.fwarehouseid,'')");
            }
            sqlBuffer.append("||to_char(t2.FProvideType)||t2.FSupplyStorageOrgUnitID || tour.FToUnitID || tourEntry.FToUnitID ");
            if (this.dividebyProductline) {
                sqlBuffer.append("||t1.fproductlineid");
            }
            if (this.dividebyProductlineWP) {
                sqlBuffer.append("||isnull(t2.fproductlinewpid,'')");
            }
            sqlBuffer.append(" as dividingKey ");
            sqlBuffer.append("from   t_mm_pickingslipbill t1 left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid ");
            sqlBuffer.append(" left join t_mm_pickingslipbillentry t2 on t1.fid = t2.fparentid ");
            sqlBuffer.append(" left join t_bd_materialinventory t3 on t2.fmaterialid = t3.fmaterialid and t1.fstorageorgunitid = t3.forgunit,");
            sqlBuffer.append("t_bd_multimeasureunit  t6,t_bd_multimeasureunit  t7 ");
            sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
            sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
            sqlBuffer.append(" )tour on 1 = 1");
            sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
            sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
            sqlBuffer.append(" )tourEntry on 1 = 1");
            sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID  and t2.FProvideType != 10930");
            sqlBuffer.append(" and t1.fid = '" + id + "' ");
            sqlBuffer.append(" and  t2.FLineStatus != 2");
            sqlBuffer.append(" and (t3.fislotnumber = 0 or t3.fislotnumber is null)");
            sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
            sqlBuffer.append(" and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid )");
            sqlBuffer.append(" union all ");
            sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
            sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
            sqlBuffer.append("t2.FProvideType as provideType,");
            sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
            sqlBuffer.append("tour.FToUnitID as supplyCompanyUnitID,");
            sqlBuffer.append("tourEntry.FToUnitID as requirementCompanyUnitID,");
            sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
            sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,");
            sqlBuffer.append("t1.ftracknumberid as tracknumberid,");
            sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
            sqlBuffer.append("t2.fmaterialid as materialid,t3.flot as lotno,t3.fwarehouseid as warehouseid,");
            sqlBuffer.append("t3.flocationid as locationid,t3.fstoreadminid as storeadminid,t3.fselectQty-t3.fpickedQty as reqqty,");
            sqlBuffer.append("round(decimal(t2.freqqty*(" + suite + "/to_number(t1.freqSuite))*((t3.FACTUALOUTSTOCKQTY-t3.FRETURNEDQTY)/to_number(t2.FISSUEDTOTALQTY-t2.FRETURNEDTOTALQTY)),21,8),t6.FQtyPrecision) as pickingQty,");
            sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
            sqlBuffer.append("round(decimal(t2.fbasereqqty*(" + suite + "/to_number(t1.freqSuite))*((t3.FACTUALOUTSTOCKQTY-t3.FRETURNEDQTY)/to_number(t2.FISSUEDTOTALQTY-t2.FRETURNEDTOTALQTY)),21,8),t7.FQtyPrecision) as basepickingQty,");
            sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
            sqlBuffer.append("t2.fpickingdate as pickingdate,");
            sqlBuffer.append("t1.fstorageorgunitid||t1.fworkshopid");
            if (this.dividebyWareHouse) {
                sqlBuffer.append("||isnull(t3.fwarehouseid,'')");
            }
            sqlBuffer.append("||to_char(t2.FProvideType)||t2.FSupplyStorageOrgUnitID || tour.FToUnitID || tourEntry.FToUnitID ");
            if (this.dividebyProductline) {
                sqlBuffer.append("||t1.fproductlineid");
            }
            if (this.dividebyProductlineWP) {
                sqlBuffer.append("||isnull(t2.fproductlinewpid,'')");
            }
            sqlBuffer.append(" as dividingKey ");
            sqlBuffer.append("from  t_mm_pickingslipbill t1  left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid,");
            sqlBuffer.append("      t_mm_pickingslipbillentry t2,t_mm_pickingsliplot t3 ,");
            sqlBuffer.append("      t_bd_multimeasureunit t6,t_bd_multimeasureunit t7 ");
            sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
            sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
            sqlBuffer.append(" )tour on 1 = 1");
            sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
            sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
            sqlBuffer.append(" )tourEntry on 1 = 1");
            sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID  and t2.FProvideType != 10930");
            sqlBuffer.append(" and t1.fid = t2.fparentid  and t2.fid = t3.fpickingslipentryid  and t2.FISSUEDTOTALQTY-t2.FRETURNEDTOTALQTY>0 ");
            sqlBuffer.append(" and t2.FLineStatus != 2");
            sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
            sqlBuffer.append(" and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid  ");
            sqlBuffer.append(" and t1.fid = '" + id + "'");
            sqlBuffer.append(")) as result");
        }
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
        String sql_delete = "delete from " + tableName + " where FBasePickingQty <=0 ";
        DbUtil.execute((Context)ctx, (String)sql_delete);
    }

    private void insertDataIntoTempTable_simple(Context ctx, String tableName, String id, String mode, FilterInfo productLineWPFilter) throws BOSException, EASBizException {
        String sql = "delete from " + tableName;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        DbUtil.execute((Context)ctx, (String)sql);
        if (mode.equals("Return")) {
            this.fillTempTable_returnSlip(ctx, tableName, ids);
        } else {
            this.fillTempTable_pickingSlip(ctx, tableName, ids, productLineWPFilter);
        }
    }

    private void insertDataIntoTempTable_srcData(Context ctx, String tableName, ArrayList ids, String mode, FilterInfo productLineWPFilter) throws BOSException, EASBizException {
        String sql = "delete from " + tableName;
        DbUtil.execute((Context)ctx, (String)sql);
        this.fillTempTable_pickingSlip(ctx, tableName, ids, productLineWPFilter);
        String sql_removeInvalidData = "delete from " + tableName + " where FBaseReqQty<=0";
        DbUtil.execute((Context)ctx, (String)sql_removeInvalidData);
    }

    private void fillTempTable_pickingSlip(Context ctx, String tableName, ArrayList ids, FilterInfo productLineWPFilter) throws BOSException {
        StringBuffer params = new StringBuffer();
        int c = ids.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(ids.get(i));
            params.append("'");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tableName);
        sqlBuffer.append("(FID,");
        sqlBuffer.append("FNumber,");
        sqlBuffer.append("FEntryID,");
        sqlBuffer.append("FSeq,");
        sqlBuffer.append("FStorageOrgUnitID,");
        sqlBuffer.append("FProvideType,");
        sqlBuffer.append("FSupplyStorageOrgUnitID,");
        sqlBuffer.append("FSupplyCompanyUnitID,");
        sqlBuffer.append("FRequirementCompanyUnitID,");
        sqlBuffer.append("FWorkshopID,");
        sqlBuffer.append("FClassGroupID,");
        sqlBuffer.append("FPersonID,");
        sqlBuffer.append("FProductLineID,");
        sqlBuffer.append("FTraceNo,");
        sqlBuffer.append("FProductID,");
        sqlBuffer.append("FTrackNumberID,");
        sqlBuffer.append("FProductionOrderID,");
        sqlBuffer.append("FSaleOrderID,");
        sqlBuffer.append("FMaterialID,");
        sqlBuffer.append("FWarehouseID,");
        sqlBuffer.append("FLocationID,");
        sqlBuffer.append("FStoreAdminID,");
        sqlBuffer.append("FReqQty,");
        sqlBuffer.append("FBaseReqQty,");
        sqlBuffer.append("FUpperLimitQty,");
        sqlBuffer.append("FBaseUpperLimitQty,");
        sqlBuffer.append("FExUpperLimitQty,");
        sqlBuffer.append("FBaseExUpperLimitQty,");
        sqlBuffer.append("FIsQuotaControl,");
        sqlBuffer.append("FReqDate,");
        sqlBuffer.append("FLotNo,");
        sqlBuffer.append("FUnitID,");
        sqlBuffer.append("FBaseUnitID,");
        sqlBuffer.append("FProductLineWPEntryID,");
        sqlBuffer.append("FPickingDate,");
        sqlBuffer.append("FDividingKey)");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tour.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,t1.FMaterialID as productid,");
        sqlBuffer.append("t1.FTrackNumberID as trackNumberId,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,t2.fwarehouseid as warehouseid,");
        sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
        sqlBuffer.append(" t2.freqqty-t2.fsupplementtotalqty-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty  as reqqty,");
        sqlBuffer.append(" t2.fbasereqqty-t2.fbasesupplementtotalqty-t2.fbasepickedtotalqty-t2.fbaseissuedtotalqty+t2.fbasereturnedtotalqty as basereqqty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then round(decimal((t2.freqqty-t2.fsupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty,21,8),t6.FQtyPrecision) ");
        sqlBuffer.append(" else 0 end as FUpperLimitQty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then round(decimal((t2.fbasereqqty-t2.fbasesupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fbasepickedtotalqty-t2.fbaseissuedtotalqty+t2.fbasereturnedtotalqty,21,8),t7.FQtyPrecision) ");
        sqlBuffer.append(" else 0 end as FBaseUpperLimitQty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then decimal((t2.freqqty-t2.fsupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty,21,8) ");
        sqlBuffer.append(" else 0 end as FExUpperLimitQty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then decimal((t2.fbasereqqty-t2.fbasesupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty,21,8) ");
        sqlBuffer.append(" else 0 end as FBaseExUpperLimitQty,");
        sqlBuffer.append("t3.FIsQuotaControl,t2.freqdate, t2.FLotNo, t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        sqlBuffer.append("t1.fstorageorgunitid||t1.fworkshopid");
        if (this.dividebyWareHouse) {
            sqlBuffer.append("||isnull(t2.fwarehouseid,'')");
        }
        sqlBuffer.append("||to_char(t2.FProvideType)||t2.FSupplyStorageOrgUnitID || tour.FToUnitID || tourEntry.FToUnitID ");
        if (this.dividebyProductline) {
            sqlBuffer.append("||t1.fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append("||isnull(t2.fproductlinewpid,'')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from   t_mm_pickingslipbill t1 ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2  on  t1.fid = t2.fparentid");
        sqlBuffer.append(" left join t_bd_materialplan t3 on t1.fstorageorgunitid = t3.forgunit ");
        sqlBuffer.append(" and t2.fmaterialid = t3.fmaterialid ");
        sqlBuffer.append(" left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid,");
        sqlBuffer.append(" t_bd_multimeasureunit  t6 ,t_bd_multimeasureunit t7 ");
        sqlBuffer.append(" left join (select distinct tou.FFromUnitID as FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" ) tour on 1=1");
        sqlBuffer.append(" left join (select distinct tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" ) tourEntry on 1=1");
        sqlBuffer.append(" where tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and tour.FFromUnitID = t1.FStorageOrgUnitID ");
        sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
        sqlBuffer.append(" and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid ");
        sqlBuffer.append(" and t2.FLineStatus != 2");
        if (productLineWPFilter != null && productLineWPFilter.getFilterItems().size() > 0) {
            for (FilterItemInfo filterItem : productLineWPFilter.getFilterItems()) {
                if (!"entryIds".equals(filterItem.getPropertyName())) continue;
                Set entryIds = (Set)filterItem.getCompareValue();
                String strIdLists = StringUtils.arrayToString((Object[])entryIds.toArray(), (String)"','");
                sqlBuffer.append(" and t2.fid ");
                sqlBuffer.append(filterItem.getCompareType().toString());
                sqlBuffer.append(" ('");
                sqlBuffer.append(strIdLists);
                sqlBuffer.append("')");
            }
        }
        if (ids.size() == 1) {
            sqlBuffer.append(" and t1.fid = " + params + ")");
        } else {
            sqlBuffer.append(" and t1.fid in (" + params + "))");
        }
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private void fillTempTable_returnSlip(Context ctx, String tableName, ArrayList ids) throws BOSException {
        StringBuffer params = new StringBuffer();
        int c = ids.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(ids.get(i));
            params.append("'");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tableName);
        sqlBuffer.append("(FID,");
        sqlBuffer.append("FNumber,");
        sqlBuffer.append("FEntryID,");
        sqlBuffer.append("FSeq,");
        sqlBuffer.append("FPSLotID,");
        sqlBuffer.append("FStorageOrgUnitID,");
        sqlBuffer.append("FProvideType,");
        sqlBuffer.append("FSupplyStorageOrgUnitID,");
        sqlBuffer.append("FSupplyCompanyUnitID,");
        sqlBuffer.append("FRequirementCompanyUnitID,");
        sqlBuffer.append("FWorkshopID,");
        sqlBuffer.append("FClassGroupID,");
        sqlBuffer.append("FPersonID,");
        sqlBuffer.append("FProductLineID,");
        sqlBuffer.append("FTraceNo,");
        sqlBuffer.append("FTrackNumberID,");
        sqlBuffer.append("FProductionOrderID,");
        sqlBuffer.append("FSaleOrderID,");
        sqlBuffer.append("FMaterialID,");
        sqlBuffer.append("FLotNo,");
        sqlBuffer.append("FWarehouseID,");
        sqlBuffer.append("FLocationID,");
        sqlBuffer.append("FStoreAdminID,");
        sqlBuffer.append("FReqQty,");
        sqlBuffer.append("FBaseReqQty,");
        sqlBuffer.append("FUnitID,");
        sqlBuffer.append("FBaseUnitID,");
        sqlBuffer.append("FProductLineWPEntryID,");
        sqlBuffer.append("FPickingDate,");
        sqlBuffer.append("FDividingKey)");
        sqlBuffer.append("(");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,'null value' as fpslotid,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tour.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,");
        sqlBuffer.append("t1.FTrackNumberID as trackNumberId,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,null as lotno,t2.fwarehouseid as warehouseid,");
        sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
        sqlBuffer.append("(t2.fissuedtotalqty-t2.freturnedtotalqty) as reqqty,");
        sqlBuffer.append("(t2.fbaseissuedtotalqty-t2.fbasereturnedtotalqty) as basereqqty,");
        sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        sqlBuffer.append("t1.fstorageorgunitid||t1.fworkshopid");
        if (this.dividebyWareHouse) {
            sqlBuffer.append("||isnull(t2.fwarehouseid,'')");
        }
        sqlBuffer.append("||to_char(t2.FProvideType)||t2.FSupplyStorageOrgUnitID || tour.FToUnitID || tourEntry.FToUnitID ");
        if (this.dividebyProductline) {
            sqlBuffer.append("||t1.fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append("||isnull(t2.fproductlinewpid,'')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from  t_mm_pickingslipbill t1 ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2  on  t1.fid = t2.fparentid ");
        sqlBuffer.append(" left join t_bd_materialinventory t3 on t1.fstorageorgunitid = t3.forgunit ");
        sqlBuffer.append(" and t2.fmaterialid = t3.fmaterialid ");
        sqlBuffer.append(" left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid ");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tour on 1 = 1");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tourEntry on 1 = 1");
        sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and t2.FProvideType != 10930");
        sqlBuffer.append(" and (t3.fislotnumber = 0 or t3.fislotnumber is null) ");
        sqlBuffer.append(" and t2.FLineStatus != 2");
        if (ids.size() == 1) {
            sqlBuffer.append(" and t1.fid = " + params + ")");
        } else {
            sqlBuffer.append(" and t1.fid in(" + params + "))");
        }
        sqlBuffer.append(" union ");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,t3.fid as fpslotid,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tour.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,");
        sqlBuffer.append("t1.FTrackNumberID as trackNumberId,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,t3.flot as lotno,t3.fwarehouseid as warehouseid,");
        sqlBuffer.append("t3.flocationid as locationid,t3.fstoreadminid as storeadminid,");
        sqlBuffer.append(" t3.factualoutstockqty-t3.freturnedQty as reqqty,");
        sqlBuffer.append(" round(decimal((t3.factualoutstockqty-t3.freturnedQty)*t6.FBaseConvsRate,21,8),t6.FQtyPrecision) as basereqqty,");
        sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        sqlBuffer.append("t1.fstorageorgunitid||t1.fworkshopid");
        if (this.dividebyWareHouse) {
            sqlBuffer.append("||isnull(t3.fwarehouseid,'')");
        }
        sqlBuffer.append("||to_char(t2.FProvideType)||t2.FSupplyStorageOrgUnitID || tour.FToUnitID || tourEntry.FToUnitID ");
        if (this.dividebyProductline) {
            sqlBuffer.append("||t1.fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append("||isnull(t2.fproductlinewpid,'')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from  t_mm_pickingslipbill t1 ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2  on  t1.fid = t2.fparentid ");
        sqlBuffer.append(" left join t_mm_pickingsliplot t3 on t2.fid = t3.fpickingslipentryid ");
        sqlBuffer.append(" left join t_bd_materialinventory t5 on t1.fstorageorgunitid = t5.forgunit ");
        sqlBuffer.append(" and t2.fmaterialid = t5.fmaterialid ");
        sqlBuffer.append(" left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid ");
        sqlBuffer.append(" ,t_bd_multimeasureunit t6  ");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tour on 1 = 1");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tourEntry on 1 = 1");
        sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and t2.FProvideType != 10930");
        sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
        sqlBuffer.append(" and t5.fislotnumber = 1 ");
        sqlBuffer.append(" and t2.FLineStatus != 2");
        if (ids.size() == 1) {
            sqlBuffer.append(" and t1.fid = " + params + ")");
        } else {
            sqlBuffer.append(" and t1.fid in(" + params + "))");
        }
        sqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    protected String getPSLotOutStockOverSelect(Context ctx, ArrayList ids) throws BOSException {
        StringBuffer params = new StringBuffer();
        int c = ids.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(ids.get(i));
            params.append("'");
        }
        String tableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_pickingslip (");
        createSql.append("fid VARCHAR(44),");
        createSql.append("flotreqqty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("flotpickedqty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("foverqty NUMERIC(21,8) DEFAULT 0)");
        try {
            tableName = this.createTempTable(ctx, createSql.toString());
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("insert into " + tableName + "(fid,flotreqqty,flotpickedqty,foverqty)");
            sqlBuffer.append(" (select t4.fid,isnull(sum(t4.fselectqty),0) as flotreqqty,");
            sqlBuffer.append(" isnull(sum(t4.fpickedqty),0) as flotpickedqty,");
            sqlBuffer.append(" isnull(sum(t4.foverqty),0) as foverqty ");
            sqlBuffer.append(" from( ");
            sqlBuffer.append(" select t2.fid ,t3.fselectqty,fpickedqty,");
            sqlBuffer.append(" case when  t3.factualoutstockqty > t3.freturnedQty + t3.fselectqty");
            sqlBuffer.append(" then t3.factualoutstockqty-t3.freturnedQty-t3.fselectqty");
            sqlBuffer.append(" else  0");
            sqlBuffer.append(" end as foverqty");
            sqlBuffer.append(" from  t_mm_pickingslipbill t1, ");
            sqlBuffer.append(" t_mm_pickingslipbillentry t2 ");
            sqlBuffer.append(" left join t_mm_pickingsliplot t3 on t2.fid = t3.fpickingslipentryid");
            if (ids.size() == 1) {
                sqlBuffer.append(" where t1.fid = " + params.toString());
            } else {
                sqlBuffer.append(" where t1.fid in(" + params.toString() + ")");
            }
            sqlBuffer.append(" and t1.fid = t2.fparentid) as t4");
            sqlBuffer.append(" group by t4.fid) ");
            DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void insertDataIntoTempTable_gather(Context ctx, String tableName, String srcDataTempTable, ArrayList ids) throws BOSException {
        String sql = "delete from " + tableName;
        DbUtil.execute((Context)ctx, (String)sql);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" insert into " + tableName);
        sqlBuffer.append(" (FID,FStorageOrgUnitID,FSeq,FNumber,");
        sqlBuffer.append("FProvideType, FSupplyStorageOrgUnitID,FSupplyCompanyUnitID,FRequirementCompanyUnitID,");
        sqlBuffer.append(" FWorkshopID,FMaterialID,FLotNo,FWarehouseID,FStoreAdminID,");
        sqlBuffer.append(" FLocationID,FSaleOrderID,FTraceNo,FTrackNumberID,FUnitID,FBaseUnitID,FReqQty,FBaseReqQty,");
        sqlBuffer.append(" FUpperLimitQty,FBaseUpperLimitQty,FPickingDate");
        if (this.dividebyProductline) {
            sqlBuffer.append(" ,FProductLineID");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append(" ,FProductLineWPEntryID");
        }
        if (this.dividebyBillNum) {
            sqlBuffer.append(" ,FEntryID");
        }
        sqlBuffer.append(") select newbosid('11774BB4') as fgatherid,result.*  from ");
        sqlBuffer.append("(select distinct fstorageorgunitid,FSeq,FNumber,");
        sqlBuffer.append("fprovideType,fsupplyStorageOrgUnitID,fsupplyCompanyUnitID,frequirementCompanyUnitID,");
        sqlBuffer.append("fworkshopid,fmaterialid,flotno,fwarehouseid,fstoreadminid,");
        sqlBuffer.append("  flocationid,fsaleorderid,ftraceno,FTrackNumberID,funitid,fbaseunitid,frealreqqty,fbasereqqty,");
        sqlBuffer.append("  FRealUpperLimitQty,FBaseUpperLimitQty,fpickingdate");
        if (this.dividebyProductline) {
            sqlBuffer.append(" ,fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append(" ,fproductlinewpentryid");
        }
        if (this.dividebyBillNum) {
            sqlBuffer.append(" ,FEntryID");
        }
        sqlBuffer.append(" from (");
        this.isTwoTempQueryUnitSame(srcDataTempTable, sqlBuffer);
        sqlBuffer.append(" ) as result");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private void isTwoTempQueryUnitSame(String srcDataTempTable, StringBuffer sqlBuffer) {
        sqlBuffer.append(" select t10.*,t20.fbaseunitid,");
        sqlBuffer.append(" case when t10.countNoUnit > t20.countWithUnit then t20.fbaseunitid else t20.funitid end as funitid, ");
        sqlBuffer.append(" case when t10.countNoUnit > t20.countWithUnit then t10.fbasereqqty  else t10.freqqty end as frealreqqty ,");
        sqlBuffer.append(" case when t10.countNoUnit > t20.countWithUnit then t10.FBaseUpperLimitQty  else t10.FUpperLimitQty end as FRealUpperLimitQty ");
        sqlBuffer.append(" from ");
        this.queryGatherQty(srcDataTempTable, sqlBuffer);
        this.queryMergeData(srcDataTempTable, sqlBuffer);
        sqlBuffer.append(" where t10.fstorageorgunitid = t20.fstorageorgunitid");
        sqlBuffer.append("  and t10.FProvideType = t20.FProvideType");
        sqlBuffer.append("  and t10.FSupplyStorageOrgUnitID = t20.FSupplyStorageOrgUnitID");
        sqlBuffer.append("  and t10.FSupplyCompanyUnitID = t20.FSupplyCompanyUnitID");
        sqlBuffer.append("  and t10.FRequirementCompanyUnitID = t20.FRequirementCompanyUnitID");
        sqlBuffer.append(" and t10.fworkshopid = t20.fworkshopid");
        sqlBuffer.append(" and t10.fmaterialid = t20.fmaterialid");
        sqlBuffer.append(" and isnull(t10.flotno,'null value') = isnull(t20.flotno,'null value')");
        sqlBuffer.append(" and isnull(t10.fsaleorderid,'null value') = isnull(t20.fsaleorderid,'null value') ");
        sqlBuffer.append(" and isnull(t10.ftraceno,'null value') = isnull(t20.ftraceno,'null value')");
        sqlBuffer.append(" and isnull(t10.FTrackNumberID,'null value') = isnull(t20.FTrackNumberID,'null value')");
        sqlBuffer.append(" and isnull(t10.fwarehouseid,'null value') = isnull(t20.fwarehouseid,'null value') ");
        if (this.dividebyProductline) {
            sqlBuffer.append(" and t10.fproductlineid = t20.fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append(" and isnull(t10.fproductlinewpentryid,'null value') = isnull(t20.fproductlinewpentryid,'null value') ");
        }
        sqlBuffer.append(" and isnull(t10.flocationid,'null value') = isnull(t20.flocationid,'null value')) as t30");
    }

    private void queryMergeData(String srcDataTempTable, StringBuffer sqlBuffer) {
        sqlBuffer.append("(select temp.fstorageorgunitid,temp.FSeq,temp.FNumber,");
        sqlBuffer.append("temp.FProvideType,temp.FSupplyStorageOrgUnitID,temp.FSupplyCompanyUnitID,temp.FRequirementCompanyUnitID,");
        sqlBuffer.append(" temp.fworkshopid,temp.fmaterialid ,temp.flotno, temp.fwarehouseid,");
        sqlBuffer.append(" temp.flocationid,temp.fsaleorderid,temp.ftraceno,temp.FTrackNumberID,temp.funitid,temp.fbaseunitid,count(1) as countWithUnit");
        if (this.dividebyProductline) {
            sqlBuffer.append(",temp.fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append(",temp.fproductlinewpentryid");
        }
        if (this.dividebyBillNum) {
            sqlBuffer.append(",temp.FEntryID ");
        }
        sqlBuffer.append(" from " + srcDataTempTable + " as temp");
        sqlBuffer.append(" group by temp.fstorageorgunitid,temp.FSeq,temp.FNumber,");
        sqlBuffer.append(" temp.FProvideType,temp.FSupplyStorageOrgUnitID,temp.FSupplyCompanyUnitID,temp.FRequirementCompanyUnitID,");
        sqlBuffer.append(" temp.fworkshopid,temp.fmaterialid,temp.funitid,temp.fbaseunitid,temp.flotno,temp.fwarehouseid,temp.flocationid,");
        if (this.dividebyProductline) {
            sqlBuffer.append("temp.fproductlineid,");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append("temp.fproductlinewpentryid,");
        }
        if (this.dividebyBillNum) {
            sqlBuffer.append("temp.FEntryID,");
        }
        sqlBuffer.append(" temp.fsaleorderid,temp.ftraceno,temp.FTrackNumberID) as t20");
    }

    private void queryGatherQty(String srcDataTempTable, StringBuffer sqlBuffer) {
        sqlBuffer.append("( select temp.fstorageorgunitid,temp.FSeq,temp.FNumber,");
        sqlBuffer.append("temp.FProvideType,temp.FSupplyStorageOrgUnitID,temp.FSupplyCompanyUnitID,temp.FRequirementCompanyUnitID,");
        sqlBuffer.append(" temp.fworkshopid,temp.fmaterialid,temp.flotno, temp.fwarehouseid,");
        sqlBuffer.append(" temp.fstoreadminid,temp.flocationid,temp.fsaleorderid,temp.ftraceno,temp.FTrackNumberID,");
        sqlBuffer.append(" sum(temp.freqqty) as freqqty,min(temp.fpickingdate) as fpickingdate,");
        sqlBuffer.append(" sum(temp.FExUpperLimitQty) as FUpperLimitQty,sum(temp.FExUpperLimitQty) as FBaseUpperLimitQty,");
        sqlBuffer.append(" sum(temp.fbasereqqty) as fbasereqqty,count(1) as countNoUnit");
        if (this.dividebyProductline) {
            sqlBuffer.append(",temp.fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append(",temp.fproductlinewpentryid");
        }
        if (this.dividebyBillNum) {
            sqlBuffer.append(",temp.FEntryID");
        }
        sqlBuffer.append(" from " + srcDataTempTable + " as temp");
        sqlBuffer.append(" group by temp.fstorageorgunitid,temp.FSeq,temp.FNumber,");
        sqlBuffer.append(" temp.FProvideType,temp.FSupplyStorageOrgUnitID,temp.FSupplyCompanyUnitID,temp.FRequirementCompanyUnitID,");
        sqlBuffer.append(" temp.fworkshopid,temp.fmaterialid,temp.flotno,temp.fwarehouseid,temp.fstoreadminid,temp.flocationid,");
        if (this.dividebyProductline) {
            sqlBuffer.append("temp.fproductlineid,");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append("temp.fproductlinewpentryid,");
        }
        if (this.dividebyBillNum) {
            sqlBuffer.append("temp.FEntryID,");
        }
        sqlBuffer.append(" temp.fsaleorderid,temp.ftraceno,temp.FTrackNumberID) as t10,");
    }

    private void divideBasePickingQty(Context ctx, String tableName, String srcDataTempTable, String entryTableName) throws BOSException {
        StringBuffer sql_gather = new StringBuffer();
        sql_gather.append(" select t1.FID,t1.FBaseReqQty,t1.FBasePickingQty ,t2.FIsQuotaControl");
        sql_gather.append(" from " + tableName + " t1");
        sql_gather.append(" left join t_bd_materialplan t2 on t1.fstorageorgunitid = t2.forgunit ");
        sql_gather.append(" and t1.fmaterialid = t2.fmaterialid ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_gather.toString());
        StringBuffer sql_src = new StringBuffer();
        sql_src.append(" select t2.FEntryID,t2.FBaseReqQty,t2.FBaseUpperLimitQty,t2.FBaseUpperLimitQty-t2.FBaseReqQty as FBaseOverQty");
        sql_src.append(" from  " + tableName + " t1," + srcDataTempTable + " t2, " + entryTableName + " t3");
        sql_src.append(" where  t1.fid = t3.fgatherid and t3.FEntryID = t2.FEntryID");
        sql_src.append(" and t1.FID = ?");
        sql_src.append(" order by t2.freqdate ,t2.fnumber asc");
        IRowSet srcRS = null;
        Connection conn = null;
        String updatePSQty = "update " + srcDataTempTable + " set FBasePickingQty = ?,FPriority = ? where FEntryID = ? ";
        PreparedStatement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(updatePSQty);
            block4: while (rs.next()) {
                int index;
                BigDecimal undivideQty;
                srcRS = DbUtil.executeQuery((Context)ctx, (String)sql_src.toString(), (Object[])new Object[]{rs.getString("FID")});
                int priority = 1;
                if (rs.getInt("FIsQuotaControl") == 1) {
                    if (rs.getBigDecimal("FBasePickingQty").compareTo(rs.getBigDecimal("FBaseReqQty")) <= 0) {
                        undivideQty = rs.getBigDecimal("FBasePickingQty");
                        while (srcRS.next()) {
                            index = 1;
                            if (undivideQty.compareTo(srcRS.getBigDecimal("FBaseReqQty")) > 0) {
                                undivideQty = undivideQty.subtract(srcRS.getBigDecimal("FBaseReqQty"));
                                batchStatement.setBigDecimal(index++, srcRS.getBigDecimal("FBaseReqQty"));
                                batchStatement.setInt(index++, priority++);
                                batchStatement.setString(index++, srcRS.getString("FEntryID"));
                                batchStatement.addBatch();
                                continue;
                            }
                            batchStatement.setBigDecimal(index++, undivideQty);
                            batchStatement.setInt(index++, priority++);
                            batchStatement.setString(index++, srcRS.getString("FEntryID"));
                            batchStatement.addBatch();
                            continue block4;
                        }
                        continue;
                    }
                    undivideQty = rs.getBigDecimal("FBasePickingQty").subtract(rs.getBigDecimal("FBaseReqQty"));
                    while (srcRS.next()) {
                        index = 1;
                        if (srcRS.isLast()) {
                            batchStatement.setBigDecimal(index++, srcRS.getBigDecimal("FBaseReqQty").add(undivideQty));
                            batchStatement.setInt(index++, priority++);
                            batchStatement.setString(index++, srcRS.getString("FEntryID"));
                            batchStatement.addBatch();
                            continue block4;
                        }
                        if (undivideQty.compareTo(srcRS.getBigDecimal("FBaseOverQty")) >= 0) {
                            undivideQty = undivideQty.subtract(srcRS.getBigDecimal("FBaseOverQty"));
                            batchStatement.setBigDecimal(index++, srcRS.getBigDecimal("FBaseUpperLimitQty"));
                            batchStatement.setInt(index++, priority++);
                            batchStatement.setString(index++, srcRS.getString("FEntryID"));
                            batchStatement.addBatch();
                            continue;
                        }
                        if (undivideQty.compareTo(new BigDecimal(0)) > 0) {
                            batchStatement.setBigDecimal(index++, srcRS.getBigDecimal("FBaseReqQty").add(undivideQty));
                            batchStatement.setInt(index++, priority++);
                            batchStatement.setString(index++, srcRS.getString("FEntryID"));
                            batchStatement.addBatch();
                            undivideQty = new BigDecimal(0);
                            continue;
                        }
                        if (undivideQty.compareTo(new BigDecimal(0)) != 0) continue;
                        batchStatement.setBigDecimal(index++, srcRS.getBigDecimal("FBaseReqQty"));
                        batchStatement.setInt(index++, priority++);
                        batchStatement.setString(index++, srcRS.getString("FEntryID"));
                        batchStatement.addBatch();
                    }
                    continue;
                }
                undivideQty = rs.getBigDecimal("FBasePickingQty");
                while (srcRS.next()) {
                    index = 1;
                    if (srcRS.isLast() || undivideQty.compareTo(srcRS.getBigDecimal("FBaseReqQty")) <= 0) {
                        batchStatement.setBigDecimal(index++, undivideQty);
                        batchStatement.setInt(index++, priority++);
                        batchStatement.setString(index++, srcRS.getString("FEntryID"));
                        batchStatement.addBatch();
                        continue block4;
                    }
                    undivideQty = undivideQty.subtract(srcRS.getBigDecimal("FBaseReqQty"));
                    batchStatement.setBigDecimal(index++, srcRS.getBigDecimal("FBaseReqQty"));
                    batchStatement.setInt(index++, priority++);
                    batchStatement.setString(index++, srcRS.getString("FEntryID"));
                    batchStatement.addBatch();
                }
            }
            batchStatement.executeBatch();
            String sql = "delete from " + srcDataTempTable + " where FBasePickingQty <=0";
            DbUtil.execute((Context)ctx, (String)sql);
            this.update_exchangeQty(ctx, srcDataTempTable, "FPickingQty", "FBasePickingQty", 2);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs);
                SQLUtils.cleanup(srcRS, (Statement)batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((ResultSet)srcRS, (Statement)batchStatement, (Connection)conn);
    }

    private void registerGatherRelation(Context ctx, String tableName, String srcDataTempTable, String entryTableName) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" insert into " + entryTableName + "(FID,FEntryID,FGatherID)");
        sqlBuffer.append(" select distinct t2.fid as fid,t2.fentryid as fentryid,t1.fid as fgatherid ");
        sqlBuffer.append(" from  " + tableName + " t1," + srcDataTempTable + " t2 ");
        sqlBuffer.append(" where  t1.fstorageorgunitid = t2.fstorageorgunitid");
        sqlBuffer.append(" and t1.fworkshopid = t2.fworkshopid");
        sqlBuffer.append(" and t1.fmaterialid = t2.fmaterialid");
        sqlBuffer.append(" and isnull(t1.fsaleorderid,'null value') = isnull(t2.fsaleorderid,'null value')");
        sqlBuffer.append(" and isnull(t1.ftraceno,'null value') = isnull(t2.ftraceno,'null value')");
        sqlBuffer.append(" and isnull(t1.FTrackNumberID,'null value') = isnull(t2.FTrackNumberID,'null value')");
        if (this.dividebyProductline) {
            sqlBuffer.append(" and t1.fproductlineid = t2.fproductlineid");
        }
        if (this.dividebyProductlineWP) {
            sqlBuffer.append(" and isnull(t1.fproductlinewpentryid,'null value') = isnull(t2.fproductlinewpentryid,'null value')");
        }
        sqlBuffer.append("  and t1.FProvideType = t2.FProvideType");
        sqlBuffer.append("  and t1.FSupplyStorageOrgUnitID = t2.FSupplyStorageOrgUnitID");
        sqlBuffer.append("  and t1.FSupplyCompanyUnitID = t2.FSupplyCompanyUnitID");
        sqlBuffer.append("  and t1.FRequirementCompanyUnitID = t2.FRequirementCompanyUnitID");
        if (this.dividebyWareHouse) {
            sqlBuffer.append(" and isnull(t1.fwarehouseid,'null value') = isnull(t2.fwarehouseid,'null value')");
        }
        sqlBuffer.append(" and isnull(t1.flocationid,'null value') = isnull(t2.flocationid,'null value')");
        if (this.dividebyBillNum) {
            sqlBuffer.append(" and isnull(t1.FEntryID,'null value') = isnull(t2.FEntryID,'null value')");
        }
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private void update_exchangeQty(Context ctx, String tableName, String qtyColName, String baseQtyColName, int exchangeDirection) throws BOSException {
        StringBuffer update_basepsqty = new StringBuffer();
        update_basepsqty.append(" update " + tableName + " as  a set ");
        if (exchangeDirection == 2) {
            update_basepsqty.append(qtyColName + " = select  round(decimal(a." + baseQtyColName + "/b.FBaseConvsRate,21,8),b.FQtyPrecision)");
        } else if (exchangeDirection == 1) {
            update_basepsqty.append(baseQtyColName + " =select  round(decimal(a." + qtyColName + "*b.FBaseConvsRate,21,8),b.FQtyPrecision)");
        }
        update_basepsqty.append(" from t_bd_multimeasureunit  b");
        update_basepsqty.append(" where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
        DbUtil.execute((Context)ctx, (String)update_basepsqty.toString());
    }

    @Override
    protected String _createTempPSTable(Context ctx) throws BOSException, EASBizException {
        String tableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_pickingslip (");
        createSql.append("FID VARCHAR(44),");
        createSql.append("FNumber NVARCHAR(80),");
        createSql.append("FEntryID VARCHAR(44),");
        createSql.append("FSeq INT,");
        createSql.append("FPSLotID VARCHAR(44),");
        createSql.append("FStorageOrgUnitID VARCHAR(44),");
        createSql.append("FProvideType INT,");
        createSql.append("FSupplyStorageOrgUnitID VARCHAR(44),");
        createSql.append("FSupplyCompanyUnitID VARCHAR(44),");
        createSql.append("FRequirementCompanyUnitID VARCHAR(44),");
        createSql.append("FTransTypeID VARCHAR(44),");
        createSql.append("FBizTypeID VARCHAR(44),");
        createSql.append("FSupplyWarehouseID VARCHAR(44),");
        createSql.append("FRequirementWarehouseID VARCHAR(44),");
        createSql.append("FSupplyLocationID VARCHAR(44),");
        createSql.append("FRequirementLocationID VARCHAR(44),");
        createSql.append("FWorkshopID VARCHAR(44),");
        createSql.append("FClassGroupID VARCHAR(44),");
        createSql.append("FPersonID VARCHAR(44),");
        createSql.append("FProductLineID VARCHAR(44),");
        createSql.append("FTraceNo NVARCHAR(80),");
        createSql.append("FProductID VARCHAR(44),");
        createSql.append("FTrackNumberID VARCHAR(44),");
        createSql.append("FProductionOrderID VARCHAR(44),");
        createSql.append("FSaleOrderID VARCHAR(44),");
        createSql.append("FMaterialID VARCHAR(44),");
        createSql.append("FLotNo NVARCHAR(80),");
        createSql.append("FWarehouseID VARCHAR(44),");
        createSql.append("FLocationID VARCHAR(44),");
        createSql.append("FStoreAdminID VARCHAR(44),");
        createSql.append("FReqQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FReqDate DateTime,");
        createSql.append("FPriority INT,");
        createSql.append("FIsQuotaControl INT,");
        createSql.append("FUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FExUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseExUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseReqQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FPickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FUnitID VARCHAR(44),");
        createSql.append("FBaseUnitID VARCHAR(44),");
        createSql.append("FBasePickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FProductLineWPEntryID VARCHAR(44),");
        createSql.append("FPickingDate DateTime,");
        createSql.append("FDividingKey NVARCHAR(255),");
        createSql.append("FMaterialReqBillID VARCHAR(44),");
        createSql.append("FMaterialReqEntryID VARCHAR(44),");
        createSql.append("FRelationID VARCHAR(44))");
        try {
            tableName = this.createTempTable(ctx, createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    @Override
    protected String _createTempTable_gather(Context ctx) throws BOSException, EASBizException {
        String tableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_pickingslipgather (");
        createSql.append("FID VARCHAR(44),");
        createSql.append("FEntryID VARCHAR(44),");
        createSql.append("FSeq INT,");
        createSql.append("FNumber NVARCHAR(80),");
        createSql.append("FStorageOrgUnitID VARCHAR(44),");
        createSql.append("FProvideType INT,");
        createSql.append("FSupplyStorageOrgUnitID VARCHAR(44),");
        createSql.append("FSupplyCompanyUnitID VARCHAR(44),");
        createSql.append("FRequirementCompanyUnitID VARCHAR(44),");
        createSql.append("FTransTypeID VARCHAR(44),");
        createSql.append("FBizTypeID VARCHAR(44),");
        createSql.append("FSupplyWarehouseID VARCHAR(44),");
        createSql.append("FRequirementWarehouseID VARCHAR(44),");
        createSql.append("FSupplyLocationID VARCHAR(44),");
        createSql.append("FRequirementLocationID VARCHAR(44),");
        createSql.append("FWorkshopID VARCHAR(44),");
        createSql.append("FProductLineID VARCHAR(44),");
        createSql.append("FSaleOrderID\t NVARCHAR(80),");
        createSql.append("FTraceNo NVARCHAR(80),");
        createSql.append("FTrackNumberID VARCHAR(44),");
        createSql.append("FMaterialID VARCHAR(44),");
        createSql.append("FLotNo NVARCHAR(80),");
        createSql.append("FWarehouseID VARCHAR(44),");
        createSql.append("FLocationID VARCHAR(44),");
        createSql.append("FStoreAdminID VARCHAR(44),");
        createSql.append("FProductLineWPEntryID VARCHAR(44),");
        createSql.append("FReqQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseReqQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FPickingDate DateTime,");
        createSql.append("FUnitID VARCHAR(44),");
        createSql.append("FBaseUnitID VARCHAR(44),");
        createSql.append("FPickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBasePickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FMaterialReqBillID VARCHAR(44),");
        createSql.append("FMaterialReqEntryID VARCHAR(44))");
        try {
            tableName = this.createTempTable(ctx, createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String createTempTable_gatherRelation(Context ctx) throws BOSException {
        String tableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_gatherEntry (");
        createSql.append("FID VARCHAR(44),");
        createSql.append("FEntryID VARCHAR(44),");
        createSql.append("FGatherID VARCHAR(44),");
        createSql.append("FRelationID VARCHAR(44))");
        try {
            tableName = this.createTempTable(ctx, createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    protected void writeBack_pickingSuite(Context ctx, Vector pickingSlipVec) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        PreparedStatement batchStatement1 = null;
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlBuffer1 = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBill as a set FPICKEDTOTALSUITE = FPICKEDTOTALSUITE+? where  fid = ?");
        sqlBuffer1.append("update T_MM_PickingSlipBill as a set FBASEPICKEDTOTALSUITE =");
        sqlBuffer1.append("(select a.FBASEPICKEDTOTALSUITE+ round(decimal( ?*b.FBaseConvsRate,21,8),b.FQtyPrecision) ");
        sqlBuffer1.append("from t_bd_multimeasureunit  b ");
        sqlBuffer1.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid )");
        sqlBuffer1.append("where fid = ? ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sqlBuffer.toString());
            batchStatement1 = conn.prepareStatement(sqlBuffer1.toString());
            for (HashMap psb : pickingSlipVec) {
                int index = 1;
                batchStatement.setBigDecimal(index++, (BigDecimal)psb.get("pickingSuite"));
                batchStatement.setString(index++, psb.get("ID").toString());
                batchStatement.addBatch();
                batchStatement1.setBigDecimal(1, (BigDecimal)psb.get("pickingSuite"));
                batchStatement1.setString(2, psb.get("ID").toString());
                batchStatement1.addBatch();
            }
            batchStatement.executeBatch();
            batchStatement1.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement);
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    protected void writeBack_returnedSuite(Context ctx, Vector pickingSlipVec) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        PreparedStatement batchStatement1 = null;
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlBuffer1 = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBill as a set FRETURNEDTOTALSUITE = FRETURNEDTOTALSUITE+ ? where  fid = ?");
        sqlBuffer1.append("update T_MM_PickingSlipBill as a set FBASERETURNEDTOTALSUITE =");
        sqlBuffer1.append("(select a.FBASERETURNEDTOTALSUITE+ round(decimal( ?*b.FBaseConvsRate,21,8),b.FQtyPrecision) ");
        sqlBuffer1.append("from t_bd_multimeasureunit  b ");
        sqlBuffer1.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid )");
        sqlBuffer1.append("where fid = ? ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sqlBuffer.toString());
            batchStatement1 = conn.prepareStatement(sqlBuffer1.toString());
            for (HashMap psb : pickingSlipVec) {
                int index = 1;
                batchStatement.setBigDecimal(index++, (BigDecimal)psb.get("returningSuite"));
                batchStatement.setString(index++, psb.get("ID").toString());
                batchStatement.addBatch();
                batchStatement1.setBigDecimal(1, (BigDecimal)psb.get("returningSuite"));
                batchStatement1.setString(2, psb.get("ID").toString());
                batchStatement1.addBatch();
            }
            batchStatement.executeBatch();
            batchStatement1.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement);
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    protected void writeBack_pickingTotalQty(Context ctx, Vector pickingSlipVec) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        PreparedStatement batchStatement1 = null;
        Statement batchStatement2 = null;
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlBuffer1 = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBillEntry as a set FPICKEDTOTALQTY =");
        sqlBuffer.append("(select a.FPICKEDTOTALQTY+ round(decimal(a.FREQQTY*( ?/c.FREQSUITE),21,8),b.FQtyPrecision)  ");
        sqlBuffer.append("from t_bd_multimeasureunit  b ,T_MM_PickingSlipBill c ");
        sqlBuffer.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
        sqlBuffer.append(" and a.FParentID = c.FID )");
        sqlBuffer.append("where FID = ? ");
        sqlBuffer1.append("update T_MM_PickingSlipBillEntry as a set FBASEPICKEDTOTALQTY =");
        sqlBuffer1.append("(select a.FBASEPICKEDTOTALQTY+ round(decimal(a.FREQQTY*( ?/c.FREQSUITE)*b.FBaseConvsRate,21,8),b.FQtyPrecision)");
        sqlBuffer1.append("from t_bd_multimeasureunit  b ,T_MM_PickingSlipBill c  ");
        sqlBuffer1.append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ");
        sqlBuffer1.append(" and a.FParentID = c.FID ) ");
        sqlBuffer1.append("where FID = ? ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sqlBuffer.toString());
            batchStatement1 = conn.prepareStatement(sqlBuffer1.toString());
            for (HashMap psb : pickingSlipVec) {
                int index = 1;
                batchStatement.setBigDecimal(index++, (BigDecimal)psb.get("pickingSuite"));
                batchStatement.setString(index++, psb.get("ID").toString());
                batchStatement.addBatch();
                batchStatement1.setBigDecimal(1, (BigDecimal)psb.get("pickingSuite"));
                batchStatement1.setString(2, psb.get("ID").toString());
                batchStatement1.addBatch();
            }
            batchStatement.executeBatch();
            batchStatement1.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement1);
                SQLUtils.cleanup(batchStatement2);
                SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement1);
        SQLUtils.cleanup(batchStatement2);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    protected void writeBack_PSTotalQty_simple(Context ctx, String tableName) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBillEntry as a set (FPICKEDTOTALQTY,FBASEPICKEDTOTALQTY) = ");
        sqlBuffer.append("(select a.FPICKEDTOTALQTY + b.FPickingQty,");
        sqlBuffer.append(" a.FBASEPICKEDTOTALQTY + b.FBasePickingQty");
        sqlBuffer.append(" from ");
        sqlBuffer.append("(select t1.fid,t1.fentryid,sum(t1.FPickingQty) as FPickingQty,");
        sqlBuffer.append(" sum(t1.FBasePickingQty) as FBasePickingQty");
        sqlBuffer.append(" from " + tableName + " t1 ");
        sqlBuffer.append(" group by t1.fid,t1.fentryid ) as b");
        sqlBuffer.append(" where  a.FParentID = b.FID    and a.FID = FEntryID)");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    protected void writeBack_PSTotalQty(Context ctx, String tableName) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBillEntry as a set (FPICKEDTOTALQTY,FBASEPICKEDTOTALQTY) = ");
        sqlBuffer.append("(select a.FPICKEDTOTALQTY + b.FPickingQty,");
        sqlBuffer.append(" a.FBASEPICKEDTOTALQTY + b.FBasePickingQty");
        sqlBuffer.append(" from " + tableName + " as b ");
        sqlBuffer.append(" where  a.FParentID = b.FID    and a.FID = b.FEntryID ");
        sqlBuffer.append(" and  b.FBasePickingQty > 0 )");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    @Override
    protected IRowSet _buildTempTable(Context ctx, String id, String tableName, String orgUnitID, String mode, FilterInfo productLineWPFilter) throws BOSException, EASBizException {
        this.initPSParameter(ctx, orgUnitID);
        this.initPSParameterFromDBSet(ctx, orgUnitID);
        this.insertDataIntoTempTable_simple(ctx, tableName, id, mode, productLineWPFilter);
        String curLocaleCode = ctx.getLocale().toString();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select t1.FID,t1.FEntryID,t1.FPSLotID,ISNULL(t1.FReqQty,0) as FReqQty,t1.FLotNo,t1.FUpperLimitQty,t2.FQtyPrecision,t1.FIsQuotaControl,");
        sqlBuffer.append(" t9.fnumber as trackNumber, ");
        sqlBuffer.append(" t3.fnumber as material, ");
        sqlBuffer.append(" t3.");
        sqlBuffer.append(this.getFieldName(ctx));
        sqlBuffer.append(" as materialName,");
        sqlBuffer.append(" t3.fmodel as model, ");
        sqlBuffer.append(" t4.fname_" + curLocaleCode + " as unit, ");
        sqlBuffer.append(" t5.fname_" + curLocaleCode + " as warehouse, ");
        sqlBuffer.append(" t6.fname_" + curLocaleCode + " as location, ");
        sqlBuffer.append(" t7.fname_" + curLocaleCode + " as workshop, ");
        sqlBuffer.append(" t8.fname_" + curLocaleCode + " as productline ");
        sqlBuffer.append(" from " + tableName + " t1 left join t_mm_productline t8 on t1.FProductLineID= t8.fid ");
        sqlBuffer.append(" left join t_db_warehouse t5 on t1.FWarehouseID= t5.fid");
        sqlBuffer.append(" left join t_db_location t6 on t1.FLocationID= t6.fid");
        sqlBuffer.append(" left join t_mm_trackNumber t9 on t1.FTrackNumberID= t9.fid,");
        sqlBuffer.append(" t_bd_multimeasureunit  t2,t_bd_material t3, t_bd_measureunit t4,");
        sqlBuffer.append(" T_ORG_Admin t7 ");
        sqlBuffer.append(" where t1.fmaterialid= t2.fmaterialid and t1.funitid = t2.fmeasureunitid");
        sqlBuffer.append(" and t1.fmaterialid= t3.fid ");
        sqlBuffer.append(" and t1.FUnitID= t4.fid ");
        sqlBuffer.append(" and t1.FWorkshopID= t7.fid ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        return rs;
    }

    @Override
    protected IRowSet _buildTempTable_Gather(Context ctx, ArrayList ids, String gatherDataTempTable, String srcDataTempTable, String orgUnitID, FilterInfo productLineWPFilter) throws BOSException, EASBizException {
        this.initPSParameter(ctx, orgUnitID);
        this.initPSParameterFromDBSet(ctx, orgUnitID);
        this.insertDataIntoTempTable_srcData(ctx, srcDataTempTable, ids, "Picking", productLineWPFilter);
        String curLocaleCode = ctx.getLocale().toString();
        StringBuffer sqlBuffer = new StringBuffer();
        if (this.dividebyBillNum) {
            sqlBuffer.append(this.getDataFromSrcDataTempTable(ctx, curLocaleCode, srcDataTempTable));
        } else {
            this.insertDataIntoTempTable_gather(ctx, gatherDataTempTable, srcDataTempTable, ids);
            sqlBuffer.append("select t1.FID,t1.FLotNo,t1.FReqQty,FUpperLimitQty,t1.FPickingDate,t2.FQtyPrecision,");
            sqlBuffer.append(" t1.FTraceNo,t9.FNumber as SaleOrderNum,t10.FIsQuotaControl,");
            sqlBuffer.append(" t11.fnumber as trackNumber, ");
            sqlBuffer.append(" t3.fnumber as material, ");
            sqlBuffer.append(" t3.");
            sqlBuffer.append(this.getFieldName(ctx));
            sqlBuffer.append(" as materialName,");
            sqlBuffer.append(" t3.fmodel as model, ");
            sqlBuffer.append(" t4.fname_" + curLocaleCode + " as unit, ");
            sqlBuffer.append(" t5.fname_" + curLocaleCode + " as warehouse, ");
            sqlBuffer.append(" t6.fname_" + curLocaleCode + " as location, ");
            sqlBuffer.append(" t7.fname_" + curLocaleCode + " as workshop, ");
            sqlBuffer.append(" t8.fname_" + curLocaleCode + " as productline ");
            sqlBuffer.append(" from " + gatherDataTempTable + " t1 left join t_mm_productline t8 on t1.FProductLineID= t8.fid ");
            sqlBuffer.append(" left join t_db_warehouse t5 on t1.FWarehouseID= t5.fid  ");
            sqlBuffer.append(" left join t_db_location t6 on t1.FLocationID= t6.fid  ");
            sqlBuffer.append(" left join T_SD_SaleOrder t9 on t1.fsaleorderid = t9.fid ");
            sqlBuffer.append(" left join t_bd_materialplan t10 on t1.fstorageorgunitid = t10.forgunit ");
            sqlBuffer.append(" and t1.fmaterialid = t10.fmaterialid ");
            sqlBuffer.append(" left join t_mm_trackNumber t11 on t1.FTrackNumberID= t11.fid,");
            sqlBuffer.append(" t_bd_multimeasureunit  t2,t_bd_material t3, t_bd_measureunit t4,");
            sqlBuffer.append(" T_ORG_Admin t7 ");
            sqlBuffer.append(" where t1.fmaterialid= t2.fmaterialid and t1.funitid = t2.fmeasureunitid");
            sqlBuffer.append(" and t1.fmaterialid= t3.fid ");
            sqlBuffer.append(" and t1.FUnitID= t4.fid ");
            sqlBuffer.append(" and t1.FWorkshopID= t7.fid ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        return rs;
    }

    private Object getDataFromSrcDataTempTable(Context ctx, String curLocaleCode, String srcDataTempTable) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select t1.FID,t1.fnumber,t1.FLotNo,t1.FReqQty,FUpperLimitQty,t1.FPickingDate,t2.FQtyPrecision,");
        sqlBuffer.append(" t1.FTraceNo,t9.FNumber as SaleOrderNum,t10.FIsQuotaControl,");
        sqlBuffer.append(" t11.fnumber as trackNumber, ");
        sqlBuffer.append(" t3.fnumber as material, ");
        sqlBuffer.append(" t3.");
        sqlBuffer.append(this.getFieldName(ctx));
        sqlBuffer.append(" as materialName,");
        sqlBuffer.append(" t3.fmodel as model, ");
        sqlBuffer.append(" t4.fname_" + curLocaleCode + " as unit, ");
        sqlBuffer.append(" t5.fname_" + curLocaleCode + " as warehouse, ");
        sqlBuffer.append(" t6.fname_" + curLocaleCode + " as location, ");
        sqlBuffer.append(" t7.fname_" + curLocaleCode + " as workshop, ");
        sqlBuffer.append(" t8.fname_" + curLocaleCode + " as productline, ");
        sqlBuffer.append(" t1.FEntryID ");
        sqlBuffer.append(" from " + srcDataTempTable + " t1 left join t_mm_productline t8 on t1.FProductLineID= t8.fid ");
        sqlBuffer.append(" left join t_db_warehouse t5 on t1.FWarehouseID= t5.fid  ");
        sqlBuffer.append(" left join t_db_location t6 on t1.FLocationID= t6.fid  ");
        sqlBuffer.append(" left join T_SD_SaleOrder t9 on t1.fsaleorderid = t9.fid ");
        sqlBuffer.append(" left join t_bd_materialplan t10 on t1.fstorageorgunitid = t10.forgunit ");
        sqlBuffer.append(" and t1.fmaterialid = t10.fmaterialid ");
        sqlBuffer.append(" left join t_mm_trackNumber t11 on t1.FTrackNumberID= t11.fid,");
        sqlBuffer.append(" t_bd_multimeasureunit  t2,t_bd_material t3, t_bd_measureunit t4,");
        sqlBuffer.append(" T_ORG_Admin t7 ");
        sqlBuffer.append(" where t1.fmaterialid= t2.fmaterialid and t1.funitid = t2.fmeasureunitid");
        sqlBuffer.append(" and t1.fmaterialid= t3.fid ");
        sqlBuffer.append(" and t1.FUnitID= t4.fid ");
        sqlBuffer.append(" and t1.FWorkshopID= t7.fid ");
        if (this.dividebyBillNum) {
            sqlBuffer.append(" order by t1.fnumber ");
        }
        return sqlBuffer;
    }

    private void updateTempTable(Context ctx, String tableName, Vector pickingSlipVec, String mode, Map otherParam) throws BOSException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        StringBuffer update_psqty = new StringBuffer();
        update_psqty.append(" update " + tableName);
        update_psqty.append(" set FPickingQty = ?,FMaterialReqEntryID = newbosid('11774BB4') where FID = ? and FEntryID = ? ");
        if (mode.equals("Return")) {
            update_psqty.append(" and FPSLotID = ?");
        }
        Iterator iter = pickingSlipVec.iterator();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(update_psqty.toString());
            while (iter.hasNext()) {
                HashMap psMap = (HashMap)iter.next();
                int index = 1;
                batchStatement.setBigDecimal(index++, (BigDecimal)psMap.get("pickingQty"));
                batchStatement.setString(index++, psMap.get("ID").toString());
                batchStatement.setString(index++, psMap.get("ENTRYID").toString());
                if (mode.equals("Return")) {
                    batchStatement.setString(index++, psMap.get("PSLOTID").toString());
                }
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
            DbUtil.execute((Context)ctx, (String)("delete from " + tableName + " where FPickingQty <= 0"));
            this.update_exchangeQty(ctx, tableName, "FPickingQty", "FBasePickingQty", 1);
            this.updateForSpanOrgProvide(ctx, tableName, mode, otherParam);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private void updateForSpanOrgProvide(Context ctx, String tableName, String mode, Map otherParam) throws BOSException {
        StringBuffer update_transType_spanOrg = new StringBuffer();
        StringBuffer update_transType_spanCompany = new StringBuffer();
        StringBuffer update_transType_curOrg = new StringBuffer();
        StringBuffer update_supplyWarehouse = new StringBuffer();
        StringBuffer update_RequirementWarehouse = new StringBuffer();
        if (mode.equals("Picking")) {
            if (otherParam.get("priceMethod") != null) {
                if ("0".equals(otherParam.get("priceMethod"))) {
                    update_transType_spanOrg.append(" update " + tableName + " as a set FTransTypeID = 'rxoJSqctQT6C/udSvXyTRLAI3Kc=',FBizTypeID='YJN9V65PSkutQxeUH6F72SQHQ1w=' where FStorageOrgUnitID != FSupplyStorageOrgUnitID and FSupplyCompanyUnitID = FRequirementCompanyUnitID and FProvideType = " + 10930);
                } else {
                    update_transType_spanOrg.append(" update " + tableName + " as a set FTransTypeID = 'DOp01ZuATqiQBKX+FuKsHbAI3Kc=',FBizTypeID='i6DbShN4SLaNlFkX90UXOiQHQ1w=' where FStorageOrgUnitID != FSupplyStorageOrgUnitID and FSupplyCompanyUnitID = FRequirementCompanyUnitID and FProvideType = " + 10930);
                }
            }
            update_transType_spanCompany.append(" update " + tableName + " as a set FTransTypeID = 'vLScvt+3RVSYhfatgNOK67AI3Kc=',FBizTypeID = 'nhvcdx82RzuTw48FSlV79CQHQ1w=' where FStorageOrgUnitID != FSupplyStorageOrgUnitID and FSupplyCompanyUnitID != FRequirementCompanyUnitID and FProvideType = " + 10930);
            update_transType_curOrg.append(" update " + tableName + " as a set FTransTypeID = '" + "36ee5c70-2239-4c64-a58a-a1c06b9a6436B008DCA7" + "', FBizTypeID = '" + "0rSFjAEeEADgAAyMwKgSQiQHQ1w=" + "' where FProvideType != " + 10930);
            update_supplyWarehouse.append(" update " + tableName + " as  a set FSupplyWarehouseID = FWarehouseID, FSupplyLocationID= FLocationId where FProvideType = " + 10930);
            update_RequirementWarehouse.append(" update " + tableName + " as  a set FRequirementWarehouseID = FWarehouseID,FRequirementLocationID = FLocationId where FProvideType != " + 10930);
        } else {
            update_transType_curOrg.append(" update " + tableName + " as  a set FTransTypeID = '" + "35ee5c70-2239-4c64-a58a-a1c06b9a6435B008DCA7" + "', FBizTypeID = '" + "0rSFjAEeEADgAAyMwKgSQiQHQ1w=" + "' where FProvideType != " + 10930);
            update_RequirementWarehouse.append(" update " + tableName + " as  a set FRequirementWarehouseID = FWarehouseID, FRequirementLocationID = FLocationId where FProvideType != " + 10930);
        }
        ArrayList<String> updateSqlList = new ArrayList<String>();
        if (update_transType_spanOrg.length() > 0) {
            updateSqlList.add(update_transType_spanOrg.toString());
        }
        if (update_transType_spanCompany.length() > 0) {
            updateSqlList.add(update_transType_spanCompany.toString());
        }
        if (update_transType_curOrg.length() > 0) {
            updateSqlList.add(update_transType_curOrg.toString());
        }
        if (update_supplyWarehouse.length() > 0) {
            updateSqlList.add(update_supplyWarehouse.toString());
        }
        if (update_RequirementWarehouse.length() > 0) {
            updateSqlList.add(update_RequirementWarehouse.toString());
        }
        DBBatchUtil.executeBatch((Context)ctx, updateSqlList);
    }

    private void updateTempTable_gather(Context ctx, String tableName, Vector pickingSlipVec) throws BOSException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        StringBuffer params = new StringBuffer();
        StringBuffer update_psqty = new StringBuffer();
        update_psqty.append(" update " + tableName);
        update_psqty.append(" set FPickingQty = ? where FID = ?");
        Iterator iter = pickingSlipVec.iterator();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(update_psqty.toString());
            while (iter.hasNext()) {
                HashMap psMap = (HashMap)iter.next();
                int index = 1;
                batchStatement.setBigDecimal(index++, (BigDecimal)psMap.get("pickingQty"));
                batchStatement.setString(index++, (String)psMap.get("ID"));
                batchStatement.addBatch();
                if (params != null && params.toString().trim().length() > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(psMap.get("ID"));
                params.append("'");
            }
            batchStatement.executeBatch();
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
            String sql = "delete from " + tableName + " where fid not in(" + params.toString() + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            this.update_exchangeQty(ctx, tableName, "FPickingQty", "FBasePickingQty", 1);
            String sql2 = " update " + tableName + " as t1 set FMaterialReqEntryID = select newbosid('11774BB4') from " + tableName + " as t2  where t1.fid = t2.fid";
            DbUtil.execute((Context)ctx, (String)sql2);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    @Override
    protected void _blankOut(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        StringBuffer params = new StringBuffer();
        StringBuffer errorBuffer = new StringBuffer();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < pks.length; ++i) {
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
            params.append(",");
            ids.add(pks[i].toString());
        }
        StringBuffer sql_checkstatus = new StringBuffer();
        sql_checkstatus.append("select FID,FNumber,FBaseStatus from T_MM_PickingSlipBill where FBaseStatus != 2");
        sql_checkstatus.append(" and FID in (" + params.substring(0, params.length() - 1) + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_checkstatus.toString());
        if (rs != null && rs.size() > 0) {
            errorBuffer.append(this.getPSResource(ctx, "NotSubmitted_CannotBlankOut") + "\n");
            try {
                while (rs.next()) {
                    errorBuffer.append(this.getPSResource(ctx, "Error_BlankOut1"));
                    errorBuffer.append(rs.getString("FNumber"));
                    errorBuffer.append(this.getPSResource(ctx, "Error_BlankOut2"));
                    String status = ResourceBase.getString((String)"com.kingdee.eas.scm.common.BillBaseStatusEnum", (String)BillBaseStatusEnum.getEnum((int)rs.getInt("FBaseStatus")).getName(), (Locale)ctx.getLocale());
                    errorBuffer.append(status);
                    errorBuffer.append(this.getPSResource(ctx, "Error_BlankOut3") + "\n");
                    ids.remove(rs.getString("FID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (errorBuffer.length() > 0) {
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorBuffer.toString()});
        }
        if (ids.size() > 0) {
            Iterator itr = ids.iterator();
            while (itr.hasNext()) {
                params.append("'");
                params.append(itr.next().toString());
                params.append("'");
                params.append(",");
            }
            String sql_update = "update T_MM_PickingSlipBill set FBaseStatus = 3where FID in (" + params.substring(0, params.length() - 1) + ")";
            DbUtil.execute((Context)ctx, (String)sql_update);
        }
    }

    @Override
    protected void _blankOut(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PickingSlipBillInfo psInfo = (PickingSlipBillInfo)this.getValue(ctx, pk);
        StringBuffer errorBuffer = new StringBuffer();
        if (psInfo.getProductionOrder() != null && psInfo.getProductionOrder().getId() != null) {
            ArrayList<String> orderIds = new ArrayList<String>();
            orderIds.add(psInfo.getProductionOrder().getId().toString());
            ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        }
        if (psInfo.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            errorBuffer.append(this.getPSResource(ctx, "NotSubmitted_CannotBlankOut"));
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorBuffer.toString()});
        }
        psInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        super._update(ctx, pk, (IObjectValue)psInfo);
    }

    private String getPSResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getHolderResource(String key, String[] params) {
        return ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)key, (String[])params);
    }

    @Override
    protected void _handleWriteBack(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        MaterialReqBillInfo mrbillInfo = (MaterialReqBillInfo)model;
        String curLocaleCode = ctx.getLocale().toString();
        if (this.isGenerateRelation(mrbillInfo.getId().toString(), ctx)) {
            TransactionTypeInfo transactionTypeInfo = mrbillInfo.getTransactionType();
            if (transactionTypeInfo != null) {
                transactionTypeInfo = TransactionTypeHelper.getTransactionTypeDataByID((Context)ctx, (String)transactionTypeInfo.getId().toString());
            }
            if (transactionTypeInfo.getRiType() == null || transactionTypeInfo.getRiType().getBizDirection() == null) {
                return;
            }
            this.checkOrderStatus(ctx, mrbillInfo, true);
            MaterialReqBillEntryCollection coll = mrbillInfo.getEntry();
            ArrayList<String> tempEntryIds = new ArrayList<String>();
            List orderIds = new ArrayList();
            if (coll != null) {
                int c = coll.size();
                for (int i = 0; i < c; ++i) {
                    MaterialReqBillEntryInfo entryinfo = coll.get(i);
                    ObjectUuidPK pk = new ObjectUuidPK(entryinfo.getId().toString());
                    SelectorItemCollection selectorsReqBill = new SelectorItemCollection();
                    selectorsReqBill.add(new SelectorItemInfo("*"));
                    selectorsReqBill.add(new SelectorItemInfo("unit.id"));
                    selectorsReqBill.add(new SelectorItemInfo("warehouse.id"));
                    selectorsReqBill.add(new SelectorItemInfo("location.id"));
                    selectorsReqBill.add(new SelectorItemInfo("unit.name"));
                    selectorsReqBill.add(new SelectorItemInfo("unit.number"));
                    selectorsReqBill.add(new SelectorItemInfo("material.id"));
                    selectorsReqBill.add(new SelectorItemInfo("material.name"));
                    selectorsReqBill.add(new SelectorItemInfo("material.number"));
                    entryinfo = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx).getMaterialReqBillEntryInfo((IObjectPK)pk, selectorsReqBill);
                    MaterialPlanInfo planInfo = MaterialPlanFactory.getLocalInstance((Context)ctx).getPlanInfo(entryinfo.getMaterial().getId().toString(), mrbillInfo.getStorageOrgUnit().getId().toString());
                    if (entryinfo.getBaseQty().compareTo(new BigDecimal(0)) == 0) {
                        return;
                    }
                    tempEntryIds.add(entryinfo.getSourceBillEntryId().toString());
                    StringBuffer sql_temp = new StringBuffer();
                    sql_temp.append(" select t6.FNumber,t2.FSeq,t1.fid,t1.FUnitID,t1.FSrcEntryID,FTempEntryID,T3.FName_" + curLocaleCode + " as FMaterialName,");
                    sql_temp.append(" t4.FIsQuotaControl,t1.FPickingQty,t1.FBasePickingQty,");
                    sql_temp.append(" t2.FbaseIssuedTotalQty,t2.FbaseReturnedTotalQty,");
                    sql_temp.append(" t1.FBasePickingQty-t1.FBaseIssuedQty  as FBaseIssueLessReqQty,");
                    sql_temp.append(" case when t4.FIsQuotaControl = 1");
                    sql_temp.append(" then round(decimal((t2.fbasereqqty-t2.fbasesupplementtotalqty)*(1+t4.FISSInHightLimit/100) ");
                    sql_temp.append("-t2.fbaseissuedtotalqty+t2.fbasereturnedtotalqty,21,8),t5.FQtyPrecision) ");
                    sql_temp.append(" else 0 end as FBaseOverQty, ");
                    sql_temp.append(" case when t4.FIsQuotaControl = 1");
                    sql_temp.append(" then round(decimal((t2.fbasereqqty-t2.fbasesupplementtotalqty)*(1+t4.FISSInHightLimit/100) ");
                    sql_temp.append("-t2.fbaseissuedtotalqty+t2.fbasereturnedtotalqty,21,8)-(t1.FBasePickingQty-t1.FBaseIssuedQty),t5.FQtyPrecision) ");
                    sql_temp.append(" else 0 end as FBaseAbleQty ");
                    sql_temp.append(" from T_MM_PSMRRelation t1,T_MM_PickingSlipBillEntry t2,");
                    sql_temp.append(" T_MM_PickingSlipBill t6,");
                    sql_temp.append(" T_BD_Material t3,T_BD_MaterialPlan t4,t_bd_multimeasureunit t5");
                    sql_temp.append(" where t1.FSrcEntryID = T2.FID ");
                    sql_temp.append(" and t2.FMaterialID = T3.FID ");
                    sql_temp.append(" and t6.fid = t2.fparentid ");
                    sql_temp.append(" and t6.fstorageorgunitid = t4.forgunit ");
                    sql_temp.append(" and t2.fmaterialid = t4.fmaterialid ");
                    sql_temp.append(" and t2.fmaterialid= t5.fmaterialid and t2.funitid = t5.fmeasureunitid ");
                    sql_temp.append(" and t1.FTempEntryID='" + entryinfo.getSourceBillEntryId().toString() + "'");
                    String sql_temp2 = sql_temp.toString();
                    sql_temp.append(" order by FPriority ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_temp.toString());
                    IRowSet rsTotal = null;
                    PreparedStatement batchStatement = null;
                    Connection conn = null;
                    try {
                        if (rs.size() == 1) {
                            StringBuffer sql_updateTemp;
                            rs.next();
                            BigDecimal changgeQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryinfo.getMaterial().getId().toString(), (String)entryinfo.getBaseUnit().getId().toString(), (BigDecimal)entryinfo.getBaseQty(), (String)rs.getString("FUnitID"));
                            this.updateLot(entryinfo, changgeQty, rs.getString("FSrcEntryID"), ctx);
                            if (transactionTypeInfo.getRiType().getBizDirection().getValue() == 1) {
                                if (rs.getInt("FIsQuotaControl") == 1 && entryinfo.getBaseQty().compareTo(rs.getBigDecimal("FBaseOverQty")) > 0) {
                                    throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"26_PickingSlipBillListUI", (Locale)ctx.getLocale()) + rs.getString("FNumber") + " " + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"16_MaterialLotTraceListUI", (Locale)ctx.getLocale()) + rs.getString("FSeq") + " " + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"5_PickingSlipBillControllerBean", (Locale)ctx.getLocale()) + rs.getString("FMaterialName") + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"6_PickingSlipBillControllerBean", (Locale)ctx.getLocale())});
                                }
                                sql_updateTemp = new StringBuffer();
                                sql_updateTemp.append(" update T_MM_PSMRRelation as a set (FIssuedQty,FBaseIssuedQty) = ");
                                sql_updateTemp.append("(select a.FIssuedQty +round(decimal(");
                                sql_updateTemp.append(entryinfo.getBaseQty() + "/b.FBaseConvsRate,21,8),b.FQtyPrecision), ");
                                sql_updateTemp.append("a.FBaseIssuedQty+" + entryinfo.getBaseQty());
                                sql_updateTemp.append("  from T_MM_PickingSlipBillEntry c,t_bd_multimeasureunit b ");
                                sql_updateTemp.append("  where a.FSrcEntryID = c.FID ");
                                sql_updateTemp.append("  and a.fid = '" + rs.getString("fid") + "'");
                                sql_updateTemp.append("  and c.FMaterialID = b.FMaterialID and c.FUnitID = b.fmeasureunitid) ");
                                sql_updateTemp.append("  where a.fid = '" + rs.getString("fid") + "'");
                                DbUtil.execute((Context)ctx, (String)sql_updateTemp.toString());
                                continue;
                            }
                            if (transactionTypeInfo.getRiType().getBizDirection().getValue() != -1) continue;
                            if (entryinfo.getBaseQty().negate().compareTo(rs.getBigDecimal("FbaseIssuedTotalQty").subtract(rs.getBigDecimal("FbaseReturnedTotalQty"))) > 0) {
                                throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"2_PickingSlipBillControllerBean", (Locale)ctx.getLocale()) + rs.getString("FMaterialName") + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"4_PickingSlipBillControllerBean", (Locale)ctx.getLocale())});
                            }
                            sql_updateTemp = new StringBuffer();
                            sql_updateTemp.append("update T_MM_PSMRRelation as a set (FIssuedQty,FBaseIssuedQty) = ");
                            sql_updateTemp.append("(select a.FIssuedQty +round(decimal(");
                            sql_updateTemp.append(entryinfo.getBaseQty().negate() + "/b.FBaseConvsRate,21,8),b.FQtyPrecision), ");
                            sql_updateTemp.append("a.FBaseIssuedQty+" + entryinfo.getBaseQty().negate());
                            sql_updateTemp.append(" from  t_bd_multimeasureunit b,T_MM_PickingSlipBillEntry c ");
                            sql_updateTemp.append(" where a.FSrcEntryID = c.FID   ");
                            sql_updateTemp.append(" and c.FMaterialID = b.FMaterialID and c.FUnitID = b.fmeasureunitid) ");
                            sql_updateTemp.append(" where a.fid = '" + rs.getString("fid") + "'");
                            DbUtil.execute((Context)ctx, (String)sql_updateTemp.toString());
                            continue;
                        }
                        if (rs.size() <= 1) continue;
                        StringBuffer sql_updateIssueQty = new StringBuffer();
                        sql_updateIssueQty.append(" update T_MM_PSMRRelation  ");
                        sql_updateIssueQty.append(" set FIssuedQty = FIssuedQty + ?, ");
                        sql_updateIssueQty.append(" FBaseIssuedQty = FBaseIssuedQty + ? ");
                        sql_updateIssueQty.append(" where  fid = ?");
                        conn = EJBFactory.getConnection((Context)ctx);
                        batchStatement = conn.prepareStatement(sql_updateIssueQty.toString());
                        BigDecimal undivideQty = entryinfo.getBaseQty();
                        BigDecimal issueQty = null;
                        if (planInfo.isIsQuotaControl()) {
                            String sql = "select sum(FBaseIssueLessReqQty) as  FBaseTotalIssueLessReqQty,sum(FBaseOverQty) as FTotalBaseOverQty from (" + sql_temp2 + ") as temp group by FTempEntryID";
                            rsTotal = DbUtil.executeQuery((Context)ctx, (String)sql);
                            rsTotal.next();
                            if (entryinfo.getBaseQty().compareTo(rsTotal.getBigDecimal("FTotalBaseOverQty")) > 0) {
                                throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"5_PickingSlipBillControllerBean", (Locale)ctx.getLocale()) + rs.getString("FMaterialName") + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"6_PickingSlipBillControllerBean", (Locale)ctx.getLocale())});
                            }
                            BigDecimal baseTotalLessQty = entryinfo.getBaseQty().subtract(rsTotal.getBigDecimal("FBaseTotalIssueLessReqQty"));
                            while (rs.next()) {
                                int index = 1;
                                if (undivideQty.compareTo(new BigDecimal("0")) > 0) {
                                    BigDecimal baseActualQty = new BigDecimal("0");
                                    if (entryinfo.getBaseQty().compareTo(rsTotal.getBigDecimal("FBaseTotalIssueLessReqQty")) <= 0) {
                                        baseActualQty = undivideQty.compareTo(rs.getBigDecimal("FBaseIssueLessReqQty")) >= 0 ? rs.getBigDecimal("FBaseIssueLessReqQty") : undivideQty;
                                        if (baseActualQty.compareTo(rs.getBigDecimal("FBaseOverQty")) > 0) {
                                            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"26_PickingSlipBillListUI", (Locale)ctx.getLocale()) + rs.getString("FNumber") + " " + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"16_MaterialLotTraceListUI", (Locale)ctx.getLocale()) + rs.getString("FSeq") + " " + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"5_PickingSlipBillControllerBean", (Locale)ctx.getLocale()) + rs.getString("FMaterialName") + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"6_PickingSlipBillControllerBean", (Locale)ctx.getLocale())});
                                        }
                                        undivideQty = undivideQty.subtract(baseActualQty);
                                        issueQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryinfo.getMaterial().getId().toString(), (String)entryinfo.getBaseUnit().getId().toString(), (BigDecimal)baseActualQty, (String)rs.getString("FUnitID"));
                                        batchStatement.setBigDecimal(index++, issueQty);
                                        batchStatement.setBigDecimal(index++, baseActualQty);
                                        batchStatement.setString(index++, rs.getString("FID"));
                                        batchStatement.addBatch();
                                        this.updateLot(entryinfo, baseActualQty, rs.getString("FSrcEntryID"), ctx);
                                        continue;
                                    }
                                    baseActualQty = rs.getBigDecimal("FBaseIssueLessReqQty");
                                    if (baseActualQty.compareTo(rs.getBigDecimal("FBaseOverQty")) > 0) {
                                        throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"26_PickingSlipBillListUI", (Locale)ctx.getLocale()) + rs.getString("FNumber") + " " + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"16_MaterialLotTraceListUI", (Locale)ctx.getLocale()) + rs.getString("FSeq") + " " + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"5_PickingSlipBillControllerBean", (Locale)ctx.getLocale()) + rs.getString("FMaterialName") + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"6_PickingSlipBillControllerBean", (Locale)ctx.getLocale())});
                                    }
                                    if (baseTotalLessQty.compareTo(rs.getBigDecimal("FBaseAbleQty")) >= 0) {
                                        baseTotalLessQty = baseTotalLessQty.subtract(rs.getBigDecimal("FBaseAbleQty"));
                                        baseActualQty = rs.getBigDecimal("FBaseOverQty");
                                    } else {
                                        baseTotalLessQty = new BigDecimal("0");
                                        baseActualQty = baseActualQty.add(baseTotalLessQty);
                                    }
                                    undivideQty = undivideQty.subtract(baseActualQty);
                                    issueQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryinfo.getMaterial().getId().toString(), (String)entryinfo.getBaseUnit().getId().toString(), (BigDecimal)baseActualQty, (String)rs.getString("FUnitID"));
                                    batchStatement.setBigDecimal(index++, issueQty);
                                    batchStatement.setBigDecimal(index++, baseActualQty);
                                    batchStatement.setString(index++, rs.getString("FID"));
                                    batchStatement.addBatch();
                                    this.updateLot(entryinfo, baseActualQty, rs.getString("FSrcEntryID"), ctx);
                                    continue;
                                }
                                break;
                            }
                        } else {
                            while (rs.next()) {
                                int index = 1;
                                if (rs.isLast() || undivideQty.compareTo(rs.getBigDecimal("FBaseIssueLessReqQty")) <= 0) {
                                    issueQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryinfo.getMaterial().getId().toString(), (String)entryinfo.getBaseUnit().getId().toString(), (BigDecimal)undivideQty, (String)rs.getString("FUnitID"));
                                    batchStatement.setBigDecimal(index++, issueQty);
                                    batchStatement.setBigDecimal(index++, undivideQty);
                                    batchStatement.setString(index++, rs.getString("FID"));
                                    batchStatement.addBatch();
                                    this.updateLot(entryinfo, issueQty, rs.getString("FSrcEntryID"), ctx);
                                    break;
                                }
                                undivideQty = undivideQty.subtract(rs.getBigDecimal("FBaseIssueLessReqQty"));
                                issueQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryinfo.getMaterial().getId().toString(), (String)entryinfo.getBaseUnit().getId().toString(), (BigDecimal)rs.getBigDecimal("FBaseIssueLessReqQty"), (String)rs.getString("FUnitID"));
                                batchStatement.setBigDecimal(index++, issueQty);
                                batchStatement.setBigDecimal(index++, rs.getBigDecimal("FBaseIssueLessReqQty"));
                                batchStatement.setString(index++, rs.getString("FID"));
                                batchStatement.addBatch();
                                this.updateLot(entryinfo, issueQty, rs.getString("FSrcEntryID"), ctx);
                            }
                        }
                        batchStatement.executeBatch();
                        continue;
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rs);
                        SQLUtils.cleanup(rsTotal);
                        SQLUtils.cleanup(batchStatement, conn);
                    }
                }
                StringBuffer updatePSEntry = new StringBuffer();
                StringBuffer updateEntryStatus = new StringBuffer();
                StringBuffer updateProdStockEntry = new StringBuffer();
                if (transactionTypeInfo.getRiType().getBizDirection().getValue() == 1) {
                    updatePSEntry.append(" update T_MM_PickingSlipBillEntry as t0 ");
                    updatePSEntry.append(" set (FIssuedTotalQty,FBaseIssuedTotalQty,FPickedTotalQty,FBasePickedTotalQty) = ");
                    updatePSEntry.append("(select t1.FIssuedTotalQty+t2.FIssuedQty,");
                    updatePSEntry.append(" t1.FBaseIssuedTotalQty+t2.FBaseIssuedQty,");
                    updatePSEntry.append(" t1.FPickedTotalQty-t2.FPickingQty,");
                    updatePSEntry.append(" t1.FBasePickedTotalQty-t2.FBasePickingQty");
                    updatePSEntry.append(" from  T_MM_PSMRRelation t2,");
                    updatePSEntry.append("   T_MM_PickingSlipBillEntry t1");
                    updatePSEntry.append(" where  t1.fid=t0.fid and t1.FID in (select FSrcEntryID from T_MM_PSMRRelation where fid = t2.fid) and t2.FTempEntryID in ");
                    updatePSEntry.append(" (select distinct t4.FSourceBillEntryID");
                    updatePSEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updatePSEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + mrbillInfo.getId().toString() + "'))");
                    updateEntryStatus.append(" update T_MM_PickingSlipBillEntry  ");
                    updateEntryStatus.append(" set  FBaseStatus = 9");
                    updateEntryStatus.append(" where FLineStatus != 2 and FID in");
                    updateEntryStatus.append("(select distinct t1.fid");
                    updateEntryStatus.append(" from  T_MM_PickingSlipBillEntry t1,T_MM_PSMRRelation t2,");
                    updateEntryStatus.append(" T_IM_MaterialReqBillEntry t3,T_BD_MaterialPlan t4");
                    updateEntryStatus.append(" where t3.FParentID = '" + mrbillInfo.getId().toString() + "'");
                    updateEntryStatus.append(" and t2.FTempEntryID = t3.FSourceBillEntryID");
                    updateEntryStatus.append(" and t1.FID = t2.FSrcEntryID  ");
                    updateEntryStatus.append(" and t1.FMaterialPlanID = t4.FID");
                    updateEntryStatus.append(" and t1.FBaseStatus = 4");
                    updateEntryStatus.append(" and ((t4.FIsQuotaControl = 1 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty >=");
                    updateEntryStatus.append(" (t1.FBaseReqQty-t1.FBaseSupplementTotalQty)*(1-t4.FISSInLowLimit/100))");
                    updateEntryStatus.append(" or (t4.FIsQuotaControl = 0 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty >= t1.FBaseReqQty)))");
                    updateProdStockEntry.append(" update T_MM_ProductionOrderSEntry as t1 ");
                    updateProdStockEntry.append(" set (FSendOutTotalQty,FBaseSendOutTotalQty) = ");
                    updateProdStockEntry.append("(select t1.FSendOutTotalQty+t7.FIssuedQty,");
                    updateProdStockEntry.append(" t1.FBaseSendOutTotalQty+t7.FBaseIssuedQty");
                    updateProdStockEntry.append(" from(");
                    updateProdStockEntry.append(" select t6.fid,sum(t2.FIssuedQty) as FIssuedQty,sum(t2.FBaseIssuedQty) as FBaseIssuedQty");
                    updateProdStockEntry.append(" from (select * from T_MM_PSMRRelation ");
                    updateProdStockEntry.append(" where  FTempEntryID in ");
                    updateProdStockEntry.append("(select distinct t4.FSourceBillEntryID");
                    updateProdStockEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updateProdStockEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + mrbillInfo.getId().toString() + "')");
                    updateProdStockEntry.append(" ) t2,");
                    updateProdStockEntry.append(" T_MM_PickingSlipBillEntry t5,T_MM_ProductionOrderSEntry t6");
                    updateProdStockEntry.append(" where  t5.FSourceBillEntryID = t6.FID  and t2.FSrcEntryID = t5.FID ");
                    updateProdStockEntry.append(" group by t6.FID) as t7 ");
                    updateProdStockEntry.append(" where t1.FID = t7.FID )");
                } else if (transactionTypeInfo.getRiType().getBizDirection().getValue() == -1) {
                    updatePSEntry.append(" update T_MM_PickingSlipBillEntry as t1 ");
                    updatePSEntry.append(" set (FReturnedTotalQty,FBaseReturnedTotalQty) = ");
                    updatePSEntry.append("(select t1.FReturnedTotalQty+t5.FIssuedQty,");
                    updatePSEntry.append(" t1.FBaseReturnedTotalQty+t5.FBaseIssuedQty");
                    updatePSEntry.append(" from(select t2.FSrcEntryID,sum(t2.FIssuedQty) as FIssuedQty,");
                    updatePSEntry.append(" sum(t2.FBaseIssuedQty) as FBaseIssuedQty");
                    updatePSEntry.append(" from   T_MM_PSMRRelation t2 ");
                    updatePSEntry.append(" where  t2.FTempEntryID in ");
                    updatePSEntry.append("(select distinct t4.FSourceBillEntryID");
                    updatePSEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updatePSEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + mrbillInfo.getId().toString() + "')");
                    updatePSEntry.append("group by t2.FSrcEntryID) t5 ");
                    updatePSEntry.append(" where t1.FID = t5.FSrcEntryID)");
                    updateEntryStatus.append(" update T_MM_PickingSlipBillEntry  ");
                    updateEntryStatus.append(" set  FBaseStatus = 4");
                    updateEntryStatus.append(" where FLineStatus != 2 and FID in");
                    updateEntryStatus.append("(select distinct t1.fid");
                    updateEntryStatus.append(" from  T_MM_PickingSlipBillEntry t1,T_MM_PSMRRelation t2,");
                    updateEntryStatus.append(" T_IM_MaterialReqBillEntry t3,T_BD_MaterialPlan t4");
                    updateEntryStatus.append(" where t3.FParentID = '" + mrbillInfo.getId().toString() + "'");
                    updateEntryStatus.append(" and t2.FTempEntryID = t3.FSourceBillEntryID");
                    updateEntryStatus.append(" and t1.FID = t2.FSrcEntryID  ");
                    updateEntryStatus.append(" and t1.FMaterialPlanID = t4.FID");
                    updateEntryStatus.append(" and t1.FBaseStatus = 9");
                    updateEntryStatus.append(" and ((t4.FIsQuotaControl = 1 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty <");
                    updateEntryStatus.append(" (t1.FBaseReqQty-t1.FBaseSupplementTotalQty)*(1-t4.FISSInLowLimit/100))");
                    updateEntryStatus.append(" or (t4.FIsQuotaControl = 0 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty < t1.FBaseReqQty)))");
                    updateProdStockEntry.append(" update T_MM_ProductionOrderSEntry as t1 ");
                    updateProdStockEntry.append(" set (FUntreadTotalQty,FBaseUntreadTotalQty) = ");
                    updateProdStockEntry.append("(select t1.FUntreadTotalQty+t7.FIssuedQty,");
                    updateProdStockEntry.append(" t1.FBaseUntreadTotalQty+t7.FBaseIssuedQty");
                    updateProdStockEntry.append(" from(");
                    updateProdStockEntry.append(" select t6.fid,sum(t2.FIssuedQty) as FIssuedQty,sum(t2.FBaseIssuedQty) as FBaseIssuedQty");
                    updateProdStockEntry.append(" from  T_MM_PSMRRelation t2,T_MM_PickingSlipBillEntry t5,T_MM_ProductionOrderSEntry t6");
                    updateProdStockEntry.append(" where  t5.FSourceBillEntryID = t6.FID  and t2.FSrcEntryID = t5.FID ");
                    updateProdStockEntry.append(" and t2.FTempEntryID in ");
                    updateProdStockEntry.append("(select distinct t4.FSourceBillEntryID");
                    updateProdStockEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updateProdStockEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + mrbillInfo.getId().toString() + "')");
                    updateProdStockEntry.append(" group by t6.FID) as t7 ");
                    updateProdStockEntry.append(" where t1.FID = t7.FID )");
                }
                DbUtil.execute((Context)ctx, (String)updatePSEntry.toString());
                DbUtil.execute((Context)ctx, (String)updateEntryStatus.toString());
                DbUtil.execute((Context)ctx, (String)updateProdStockEntry.toString());
                orderIds = this.getUpdatePoIDSet(ctx, tempEntryIds);
                PoMaterialWithDraw.updatePoABDate(ctx, orderIds);
                this.updatePickingAndOrderStatus(mrbillInfo.getId().toString(), ctx);
            }
        } else {
            return;
        }
    }

    private List getUpdatePoIDSet(Context ctx, List tempEntryIds) throws BOSException {
        ArrayList<String> orderIds = new ArrayList<String>();
        if (tempEntryIds != null && tempEntryIds.size() > 0) {
            StringBuffer sqlProOrderIDs = new StringBuffer();
            sqlProOrderIDs.append(" select distinct(p.FProductionorderID) as FORDERID from T_MM_PickingSlipBill p ");
            sqlProOrderIDs.append(" inner join T_MM_PickingSlipBillEntry pe on p.fid = pe.FParentID ");
            sqlProOrderIDs.append(" inner join T_MM_PSMRRelation psm on psm.fsrcentryid = pe.fid ");
            sqlProOrderIDs.append(" where psm.ftempentryid in ( ").append(PoMaterialWithDraw.exchangeSetToString(tempEntryIds)).append(" )");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlProOrderIDs.toString());
            if (rs != null) {
                try {
                    while (rs.next()) {
                        orderIds.add(rs.getString("FORDERID"));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return orderIds;
    }

    private void checkOrderStatus(Context ctx, MaterialReqBillInfo mrbillInfo, boolean isAudit) throws BOSException, PickingSlipBillException {
        String sqlCheckPickingSlip = "select a.FSrcObjectID,b.FBaseStatus from t_bot_relation a,T_MM_PickingSlipBill b  where a.FSrcObjectID = b.FID and FdestEntityID= '500AB75E' and  FSrcEntityId='A06DF1E1' and FDestObjectID = '" + mrbillInfo.getId().toString() + "'";
        IRowSet psRs = DbUtil.executeQuery((Context)ctx, (String)sqlCheckPickingSlip);
        ArrayList<String> pickIds = new ArrayList<String>();
        ArrayList orderIds = new ArrayList();
        StringBuffer sqlSelectOrderBuff = new StringBuffer();
        StringBuffer ids = new StringBuffer();
        try {
            while (psRs.next()) {
                pickIds.add(psRs.getString("FSrcObjectID"));
            }
            if (pickIds.size() > 0) {
                this.getOrderId(ctx, pickIds, orderIds, ids, sqlSelectOrderBuff);
                if (orderIds.size() > 0) {
                    this.checkOrderStatusExcute(ctx, orderIds, ids, sqlSelectOrderBuff, isAudit);
                }
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        finally {
            SQLUtils.cleanup((ResultSet)psRs);
        }
    }

    private void checkOrderStatusExcute(Context ctx, List orderIds, StringBuffer ids, StringBuffer sqlSelectOrderBuff, boolean isAudit) throws BOSException, SQLException, PickingSlipBillException {
        ids = new StringBuffer();
        for (int i = 0; i < orderIds.size(); ++i) {
            ids.append("'");
            ids.append(orderIds.get(i));
            ids.append("'");
            ids.append(",");
        }
        ids = ids.replace(ids.length() - 1, ids.length(), "");
        sqlSelectOrderBuff = new StringBuffer();
        sqlSelectOrderBuff.append(" select count(*) as statusCount from T_MM_ProductionOrder where  FBaseStatus =7");
        sqlSelectOrderBuff.append(" and fid in (" + ids + ")");
        IRowSet rowSetOrder = DbUtil.executeQuery((Context)ctx, (String)sqlSelectOrderBuff.toString());
        if (rowSetOrder.next() && rowSetOrder.getInt("statusCount") > 0) {
            if (isAudit) {
                throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_OrderStatusCheckForReqAudit")});
            }
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_OrderStatusCheckForReqUnAudit")});
        }
    }

    private void updateLot(MaterialReqBillEntryInfo entryinfo, BigDecimal qty, String PickingBillID, Context ctx) throws BOSException, EASBizException {
        if (entryinfo == null || entryinfo.getLot() == null || entryinfo.getLot().length() <= 0) {
            return;
        }
        StringBuffer SqlSelectLot = new StringBuffer();
        SqlSelectLot.append("select fid,freturnedQty,factualOutStockQty from T_MM_PickingslipLot ");
        SqlSelectLot.append(this.buildWhereSql(entryinfo, PickingBillID));
        StringBuffer updateSql = new StringBuffer();
        boolean LotFlag = true;
        IRowSet rowStatus2 = DbUtil.executeQuery((Context)ctx, (String)SqlSelectLot.toString());
        if (qty.compareTo(new BigDecimal(0)) < 0) {
            try {
                while (rowStatus2.next()) {
                    StringBuffer checkFactualOutStockQty = new StringBuffer();
                    checkFactualOutStockQty.append(" select FPickingSlipEntryId,sum(factualOutStockQty) factualOutStockQty, sum(freturnedQty) freturnedQty from T_MM_PickingslipLot  ");
                    checkFactualOutStockQty.append(" where fpickingslipentryid= '" + PickingBillID + "'");
                    checkFactualOutStockQty.append(" group by FPickingSlipEntryId ");
                    IRowSet resultRet = DbUtil.executeQuery((Context)ctx, (String)checkFactualOutStockQty.toString());
                    resultRet.next();
                    if (entryinfo.getQty().negate().compareTo(resultRet.getBigDecimal("factualOutStockQty").subtract(resultRet.getBigDecimal("freturnedQty"))) > 0) {
                        throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"2_PickingSlipBillControllerBean", (Locale)ctx.getLocale()) + entryinfo.getMaterial().getName() + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"7_PickingSlipBillControllerBean", (Locale)ctx.getLocale()) + entryinfo.getLot() + ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"8_PickingSlipBillControllerBean", (Locale)ctx.getLocale())});
                    }
                    LotFlag = false;
                    updateSql.append(" update T_MM_PickingslipLot set FActualOutStockQty = FActualOutStockQty");
                    updateSql.append("+");
                    updateSql.append(qty);
                    updateSql.append(this.buildWhereSql(entryinfo, PickingBillID));
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowStatus2);
            }
        }
        if (entryinfo.getLot() != null && entryinfo.getLot().length() > 0) {
            try {
                while (rowStatus2.next()) {
                    LotFlag = false;
                    updateSql.append(" update T_MM_PickingslipLot set FActualOutStockQty = FActualOutStockQty");
                    updateSql.append("+");
                    updateSql.append(qty);
                    updateSql.append(this.buildWhereSql(entryinfo, PickingBillID));
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowStatus2);
            }
        }
        if (LotFlag) {
            StringBuffer insertLotSql = new StringBuffer();
            insertLotSql.append("Insert into T_MM_PickingslipLot(FID,FPickingSlipEntryId,FWareHouseId,FLot,");
            if (entryinfo.getLocation() != null) {
                insertLotSql.append("FLocationId,");
            }
            insertLotSql.append(" FActualOutStockQty )");
            insertLotSql.append(" values( newbosid('6003B237'),");
            insertLotSql.append("'" + PickingBillID + "',");
            insertLotSql.append("'" + entryinfo.getWarehouse().getId().toString() + "',");
            insertLotSql.append("'" + entryinfo.getLot() + "',");
            if (entryinfo.getLocation() != null) {
                insertLotSql.append("'" + entryinfo.getLocation().getId().toString() + "',");
            }
            insertLotSql.append(qty);
            insertLotSql.append(")");
            DbUtil.execute((Context)ctx, (String)insertLotSql.toString());
        }
    }

    private String buildWhereSql(MaterialReqBillEntryInfo entryinfo, String billID) {
        StringBuffer result = new StringBuffer();
        result.append("  where ");
        result.append("FPickingSlipEntryId =  '" + billID + "'");
        result.append(" and FLot =  '" + entryinfo.getLot() + "'");
        if (entryinfo.getWarehouse() != null) {
            result.append(" and FWareHouseId = '" + entryinfo.getWarehouse().getId().toString());
            result.append("'");
        } else {
            result.append(" and FWareHouseId is null");
        }
        if (entryinfo.getLocation() != null) {
            result.append(" and FLocationId = '" + entryinfo.getLocation().getId().toString());
            result.append("'");
        } else {
            result.append(" and FLocationId is null ");
        }
        return result.toString();
    }

    private boolean isGenerateRelation(String DestId, Context ctx) throws EASBizException, BOSException {
        boolean returnValueFlag = false;
        String sqlCheckPickingSlip = "select FSrcObjectID from t_bot_relation where FdestEntityID= '500AB75E' and  FSrcEntityId='A06DF1E1' and FDestObjectID = '" + DestId + "'";
        IRowSet rowSelectSql = DbUtil.executeQuery((Context)ctx, (String)sqlCheckPickingSlip);
        try {
            while (rowSelectSql.next()) {
                returnValueFlag = true;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSelectSql);
        }
        return returnValueFlag;
    }

    @Override
    protected void _handleWriteBack_UnAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        MaterialReqBillInfo MoveOutVo = (MaterialReqBillInfo)model;
        if (this.isGenerateRelation(MoveOutVo.getId().toString(), ctx)) {
            Connection conn = null;
            PreparedStatement ps = null;
            TransactionTypeInfo transactionTypeInfo = MoveOutVo.getTransactionType();
            if (transactionTypeInfo != null) {
                transactionTypeInfo = TransactionTypeHelper.getTransactionTypeDataByID((Context)ctx, (String)transactionTypeInfo.getId().toString());
            }
            if (transactionTypeInfo.getRiType() == null || transactionTypeInfo.getRiType().getBizDirection() == null) {
                return;
            }
            this.checkOrderStatus(ctx, MoveOutVo, false);
            try {
                ArrayList<String> tempEntryIds = new ArrayList<String>();
                List orderIds = new ArrayList();
                StringBuffer updatePSEntry = new StringBuffer();
                StringBuffer updateProdStockEntry = new StringBuffer();
                if (transactionTypeInfo.getRiType().getBizDirection().getValue() == 1) {
                    StringBuffer updatePSLot = new StringBuffer();
                    updatePSLot.append(" update T_MM_PickingSlipLot as t1 ");
                    updatePSLot.append(" set (FActualOutStockQty) = ");
                    updatePSLot.append("(select t1.FActualOutStockQty- ");
                    updatePSLot.append(" round(decimal(t2.FBaseQty/t5.FBaseConvsRate,21,8),t5.FQtyPrecision) as FActualOutStockQty");
                    updatePSLot.append(" from  T_IM_MaterialReqBillEntry t2,T_MM_PSMRRelation t3,");
                    updatePSLot.append(" T_MM_PickingSlipBillEntry t4,t_bd_multimeasureunit t5 ");
                    updatePSLot.append(" where t2.FParentID = ? ");
                    updatePSLot.append(" and t2.fid = ? ");
                    updatePSLot.append(" and t2.FSourceBillEntryID = t3.FTempEntryID ");
                    updatePSLot.append(" and t3.FSrcEntryID = t4.FID ");
                    updatePSLot.append(" and t4.FMaterialID = t5.FMaterialID and t4.FUnitID = t5.FMeasureUnitID ");
                    updatePSLot.append(" and t1.FPickingSlipEntryID = t4.fid and t1.flot = t2.flot");
                    updatePSLot.append(" and isnull(t1.FWarehouseID,'null value') = isnull(t2.FWarehouseID,'null value')");
                    updatePSLot.append(" and isnull(t1.FLocationID,'null value') = isnull(t2.FLocationID,'null value'))");
                    updatePSLot.append(" where FPickingSlipEntryID in (");
                    updatePSLot.append("select t4.fid from T_IM_MaterialReqBillEntry t2,T_MM_PSMRRelation t3,");
                    updatePSLot.append("T_MM_PickingSlipBillEntry t4 where  ");
                    updatePSLot.append("t2.fid = ? ");
                    updatePSLot.append("and t2.FSourceBillEntryID = t3.FTempEntryID ");
                    updatePSLot.append("and t3.FSrcEntryID = t4.FID) ");
                    conn = EJBFactory.getConnection((Context)ctx);
                    ps = conn.prepareStatement(updatePSLot.toString());
                    MaterialReqBillEntryCollection entryCol = MoveOutVo.getEntry();
                    int m = entryCol.size();
                    for (int i = 0; i < m; ++i) {
                        String mrbEntryId = entryCol.get(i).getId().toString();
                        ps.setString(1, MoveOutVo.getId().toString());
                        ps.setString(2, mrbEntryId);
                        ps.setString(3, mrbEntryId);
                        ps.addBatch();
                        tempEntryIds.add(mrbEntryId);
                    }
                    ps.executeBatch();
                    StringBuffer deletePSLot = new StringBuffer();
                    deletePSLot.append(" delete from T_MM_PickingSlipLot ");
                    deletePSLot.append(" where  fid in ");
                    deletePSLot.append(" (select distinct t5.FID");
                    deletePSLot.append(" from  T_IM_MaterialReqBill t2,T_IM_MaterialReqBillEntry t3,T_MM_PSMRRelation t4,");
                    deletePSLot.append(" T_MM_PickingSlipLot t5");
                    deletePSLot.append(" where t2.FID = '" + MoveOutVo.getId().toString() + "'");
                    deletePSLot.append(" and t2.FID = t3.FParentID and t3.FSourceBillEntryID = t4.FTempEntryID ");
                    deletePSLot.append(" and t4.FSrcEntryID = t5.FPickingSlipEntryID and t5.FActualOutStockQty = 0)");
                    DbUtil.execute((Context)ctx, (String)deletePSLot.toString());
                    updatePSEntry.append(" update T_MM_PickingSlipBillEntry as t0 ");
                    updatePSEntry.append(" set (FIssuedTotalQty,FBaseIssuedTotalQty,FPickedTotalQty,FBasePickedTotalQty) = ");
                    updatePSEntry.append("(select t1.FIssuedTotalQty-t2.FIssuedQty,");
                    updatePSEntry.append(" t1.FBaseIssuedTotalQty-t2.FBaseIssuedQty,");
                    updatePSEntry.append(" t1.FPickedTotalQty+t2.FPickingQty,");
                    updatePSEntry.append(" t1.FBasePickedTotalQty+t2.FBasePickingQty");
                    updatePSEntry.append(" from  T_MM_PickingSlipBillEntry t1,T_MM_PSMRRelation t2");
                    updatePSEntry.append(" where t0.fid = t1.fid and t1.FID in (select FSrcEntryID from T_MM_PSMRRelation where fid=t2.fid) and t2.FTempEntryID in ");
                    updatePSEntry.append(" (select distinct t4.FSourceBillEntryID");
                    updatePSEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updatePSEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + MoveOutVo.getId().toString() + "'))");
                    DbUtil.execute((Context)ctx, (String)updatePSEntry.toString());
                    StringBuffer updateEntryStatus = new StringBuffer();
                    updateEntryStatus.append(" update T_MM_PickingSlipBillEntry  ");
                    updateEntryStatus.append(" set  FBaseStatus = 4");
                    updateEntryStatus.append(" where FLineStatus != 2 and FID in");
                    updateEntryStatus.append("(select distinct t1.fid");
                    updateEntryStatus.append(" from  T_MM_PickingSlipBillEntry t1,T_MM_PSMRRelation t2,");
                    updateEntryStatus.append(" T_IM_MaterialReqBillEntry t3,T_BD_MaterialPlan t4");
                    updateEntryStatus.append(" where t3.FParentID = '" + MoveOutVo.getId().toString() + "'");
                    updateEntryStatus.append(" and t2.FTempEntryID = t3.FSourceBillEntryID");
                    updateEntryStatus.append(" and t1.FID = t2.FSrcEntryID  ");
                    updateEntryStatus.append(" and t1.FMaterialPlanID = t4.FID");
                    updateEntryStatus.append(" and t1.FBaseStatus = 9");
                    updateEntryStatus.append(" and ((t4.FIsQuotaControl = 1 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty <");
                    updateEntryStatus.append(" (t1.FBaseReqQty-t1.FBaseSupplementTotalQty)*(1-t4.FISSInLowLimit/100))");
                    updateEntryStatus.append(" or (t4.FIsQuotaControl = 0 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty < t1.FBaseReqQty)))");
                    DbUtil.execute((Context)ctx, (String)updateEntryStatus.toString());
                    updateProdStockEntry.append(" update T_MM_ProductionOrderSEntry as t1 ");
                    updateProdStockEntry.append(" set (FSendOutTotalQty,FBaseSendOutTotalQty) = ");
                    updateProdStockEntry.append("(select t1.FSendOutTotalQty-t7.FIssuedQty,");
                    updateProdStockEntry.append(" t1.FBaseSendOutTotalQty-t7.FBaseIssuedQty");
                    updateProdStockEntry.append(" from(");
                    updateProdStockEntry.append(" select t6.fid,sum(t2.FIssuedQty) as FIssuedQty,sum(t2.FBaseIssuedQty) as FBaseIssuedQty");
                    updateProdStockEntry.append(" from (select * from  T_MM_PSMRRelation");
                    updateProdStockEntry.append(" where FTempEntryID in ");
                    updateProdStockEntry.append("(select distinct t4.FSourceBillEntryID");
                    updateProdStockEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updateProdStockEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + MoveOutVo.getId().toString() + "')");
                    updateProdStockEntry.append(" ) t2,T_MM_PickingSlipBillEntry t5,T_MM_ProductionOrderSEntry t6");
                    updateProdStockEntry.append(" where  t5.FSourceBillEntryID = t6.FID  and t2.FSrcEntryID = t5.FID ");
                    updateProdStockEntry.append(" group by t6.FID) as t7 ");
                    updateProdStockEntry.append(" where t1.FID = t7.FID )");
                    DbUtil.execute((Context)ctx, (String)updateProdStockEntry.toString());
                    StringBuffer updateTempPSQty = new StringBuffer();
                    updateTempPSQty.append(" update T_MM_PSMRRelation  ");
                    updateTempPSQty.append(" set FIssuedQty = 0, ");
                    updateTempPSQty.append(" FBaseIssuedQty = 0 ");
                    updateTempPSQty.append(" where  FTempEntryID in ");
                    updateTempPSQty.append("(select distinct t4.FSourceBillEntryID");
                    updateTempPSQty.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updateTempPSQty.append(" where t3.FID = t4.FParentID  and t3.FID = '" + MoveOutVo.getId().toString() + "')");
                    DbUtil.execute((Context)ctx, (String)updateTempPSQty.toString());
                } else if (transactionTypeInfo.getRiType().getBizDirection().getValue() == -1) {
                    StringBuffer updatePSLot = new StringBuffer();
                    updatePSLot.append(" update T_MM_PickingSlipLot as t1 ");
                    updatePSLot.append(" set (FActualOutStockQty) = ");
                    updatePSLot.append("(select t1.FActualOutStockQty + ");
                    updatePSLot.append(" round(decimal(-1*t2.FBaseQty/t5.FBaseConvsRate,21,8),t5.FQtyPrecision)");
                    updatePSLot.append(" from  T_IM_MaterialReqBillEntry t2,T_MM_PSMRRelation t3,");
                    updatePSLot.append(" T_MM_PickingSlipBillEntry t4,t_bd_multimeasureunit t5");
                    updatePSLot.append(" where t2.FParentID = '" + MoveOutVo.getId().toString() + "'");
                    updatePSLot.append(" and t2.FSourceBillEntryID = t3.FTempEntryID ");
                    updatePSLot.append(" and t3.FSrcEntryID = t4.FID ");
                    updatePSLot.append(" and t4.FMaterialID = t5.FMaterialID and t4.FUnitID = t5.FMeasureUnitID ");
                    updatePSLot.append(" and t1.FPickingSlipEntryID = t4.FID and t1.flot = t2.flot");
                    updatePSLot.append(" and isnull(t1.FWarehouseID,'null value') = isnull(t2.FWarehouseID,'null value')");
                    updatePSLot.append(" and isnull(t1.FLocationID,'null value') = isnull(t2.FLocationID,'null value'))");
                    updatePSLot.append(" where t1.FPickingSlipEntryID in (");
                    updatePSLot.append(" select t4.fid from  T_IM_MaterialReqBillEntry t2,T_MM_PSMRRelation t3,");
                    updatePSLot.append(" T_MM_PickingSlipBillEntry t4 where  ");
                    updatePSLot.append(" t2.FParentID = '" + MoveOutVo.getId().toString() + "'");
                    updatePSLot.append(" and t2.FSourceBillEntryID = t3.FTempEntryID ");
                    updatePSLot.append(" and t3.FSrcEntryID = t4.FID) ");
                    DbUtil.execute((Context)ctx, (String)updatePSLot.toString());
                    updatePSEntry.append(" update T_MM_PickingSlipBillEntry as t1 ");
                    updatePSEntry.append(" set (FReturnedTotalQty,FBaseReturnedTotalQty) = ");
                    updatePSEntry.append("(select t1.FReturnedTotalQty-t5.FIssuedQty,");
                    updatePSEntry.append(" t1.FBaseReturnedTotalQty-t5.FBaseIssuedQty");
                    updatePSEntry.append(" from(select t2.FSrcEntryID,sum(t2.FIssuedQty) as FIssuedQty,");
                    updatePSEntry.append(" sum(t2.FBaseIssuedQty) as FBaseIssuedQty");
                    updatePSEntry.append(" from   T_MM_PSMRRelation t2 ");
                    updatePSEntry.append(" where  t2.FTempEntryID in ");
                    updatePSEntry.append("(select distinct t4.FSourceBillEntryID");
                    updatePSEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updatePSEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + MoveOutVo.getId().toString() + "')");
                    updatePSEntry.append("group by t2.FSrcEntryID) t5 ");
                    updatePSEntry.append(" where t1.FID = t5.FSrcEntryID)");
                    DbUtil.execute((Context)ctx, (String)updatePSEntry.toString());
                    StringBuffer updateEntryStatus = new StringBuffer();
                    updateEntryStatus.append(" update T_MM_PickingSlipBillEntry  ");
                    updateEntryStatus.append(" set  FBaseStatus = 9");
                    updateEntryStatus.append(" where FID in");
                    updateEntryStatus.append("(select distinct t1.fid");
                    updateEntryStatus.append(" from  T_MM_PickingSlipBillEntry t1,T_MM_PSMRRelation t2,");
                    updateEntryStatus.append(" T_IM_MaterialReqBillEntry t3,T_BD_MaterialPlan t4");
                    updateEntryStatus.append(" where t3.FParentID = '" + MoveOutVo.getId().toString() + "'");
                    updateEntryStatus.append(" and t2.FTempEntryID = t3.FSourceBillEntryID");
                    updateEntryStatus.append(" and t1.FID = t2.FSrcEntryID  ");
                    updateEntryStatus.append(" and t1.FMaterialPlanID = t4.FID");
                    updateEntryStatus.append(" and t1.FBaseStatus = 4");
                    updateEntryStatus.append(" and ((t4.FIsQuotaControl = 1 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty >=");
                    updateEntryStatus.append(" (t1.FBaseReqQty-t1.FBaseSupplementTotalQty)*(1-t4.FISSInLowLimit/100))");
                    updateEntryStatus.append(" or (t4.FIsQuotaControl = 0 and  t1.FBaseIssuedTotalQty-t1.FBaseReturnedTotalQty >= t1.FBaseReqQty)))");
                    DbUtil.execute((Context)ctx, (String)updateEntryStatus.toString());
                    updateProdStockEntry.append(" update T_MM_ProductionOrderSEntry as t1 ");
                    updateProdStockEntry.append(" set (FUntreadTotalQty,FBaseUntreadTotalQty) = ");
                    updateProdStockEntry.append("(select t1.FUntreadTotalQty-t7.FIssuedQty,");
                    updateProdStockEntry.append(" t1.FBaseUntreadTotalQty-t7.FBaseIssuedQty");
                    updateProdStockEntry.append(" from(");
                    updateProdStockEntry.append(" select t6.fid,sum(t2.FIssuedQty) as FIssuedQty,sum(t2.FBaseIssuedQty) as FBaseIssuedQty");
                    updateProdStockEntry.append(" from  T_MM_PSMRRelation t2,T_MM_PickingSlipBillEntry t5,T_MM_ProductionOrderSEntry t6");
                    updateProdStockEntry.append(" where  t5.FSourceBillEntryID = t6.FID  and t2.FSrcEntryID = t5.FID ");
                    updateProdStockEntry.append(" and t2.FTempEntryID in ");
                    updateProdStockEntry.append("(select distinct t4.FSourceBillEntryID");
                    updateProdStockEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updateProdStockEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + MoveOutVo.getId().toString() + "')");
                    updateProdStockEntry.append(" group by t6.FID) as t7 ");
                    updateProdStockEntry.append(" where t1.FID = t7.FID )");
                    DbUtil.execute((Context)ctx, (String)updateProdStockEntry.toString());
                    StringBuffer updateTempPSQty = new StringBuffer();
                    updateTempPSQty.append(" update T_MM_PSMRRelation  ");
                    updateTempPSQty.append(" set FIssuedQty = 0, ");
                    updateTempPSQty.append(" FBaseIssuedQty = 0 ");
                    updateTempPSQty.append(" where  FTempEntryID in ");
                    updateTempPSQty.append("(select distinct t4.FSourceBillEntryID");
                    updateTempPSQty.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
                    updateTempPSQty.append(" where t3.FID = t4.FParentID  and t3.FID = '" + MoveOutVo.getId().toString() + "')");
                    DbUtil.execute((Context)ctx, (String)updateTempPSQty.toString());
                }
                orderIds = this.getUpdatePoIDSet(ctx, tempEntryIds);
                PoMaterialWithDraw.updatePoABDate(ctx, orderIds);
                this.updatePickingAndOrderStatus(MoveOutVo.getId().toString(), ctx);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(ps, conn);
            }
        }
    }

    @Override
    protected void _handleWriteBack_MREntryDelete(Context ctx, IObjectPK materialReqBillPK, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks.length == 0) {
            return;
        }
        StringBuffer params = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        SelectorItemCollection itemColl = new SelectorItemCollection();
        itemColl.add(new SelectorItemInfo("*"));
        itemColl.add(new SelectorItemInfo("transactionType.*"));
        MaterialReqBillInfo model = (MaterialReqBillInfo)MaterialReqBillFactory.getLocalInstance((Context)ctx).getValue(materialReqBillPK, itemColl);
        TransactionTypeInfo transactionTypeInfo = model.getTransactionType();
        if (transactionTypeInfo != null) {
            transactionTypeInfo = TransactionTypeHelper.getTransactionTypeDataByID((Context)ctx, (String)transactionTypeInfo.getId().toString());
        }
        if (transactionTypeInfo.getRiType() == null || transactionTypeInfo.getRiType().getBizDirection() == null) {
            return;
        }
        if (transactionTypeInfo.getRiType().getBizDirection().getValue() == 1) {
            StringBuffer updatePSEntry = new StringBuffer();
            updatePSEntry.append(" update T_MM_PickingSlipBillEntry as t1 ");
            updatePSEntry.append(" set (FPickedTotalQty,FBasePickedTotalQty) = ");
            updatePSEntry.append("(select t1.FPickedTotalQty-t2.FPickingQty,");
            updatePSEntry.append(" t1.FBasePickedTotalQty-t2.FBasePickingQty");
            updatePSEntry.append(" from  T_MM_PSMRRelation t2");
            updatePSEntry.append(" where t1.FID = t2.FSrcEntryID  and t2.FTempEntryID in");
            updatePSEntry.append(" (select distinct t3.FSourceBillEntryID");
            updatePSEntry.append(" from T_IM_MaterialReqBillEntry t3");
            if (pks.length == 1) {
                updatePSEntry.append(" where t3.FID = " + params + "))");
            } else {
                updatePSEntry.append(" where t3.FID in (" + params + ")))");
            }
            DbUtil.execute((Context)ctx, (String)updatePSEntry.toString());
            StringBuffer getSrcIdCount = new StringBuffer();
            getSrcIdCount.append("select count(t0.fid) as num FROM T_MM_PickingSlipBill t0 inner join T_MM_PickingSlipBillEntry t1 on t0.fid=t1.fparentid");
            getSrcIdCount.append(" inner join  T_MM_PSMRRelation t2 on t2.FSrcEntryID= t1.fid");
            getSrcIdCount.append(" inner join  T_IM_MaterialReqBillEntry t3 on t3.FSourceBillEntryID= t2.FTempEntryID");
            if (pks.length == 1) {
                getSrcIdCount.append(" where t3.FID = " + params + " and t0.fisbysuite=1");
            } else {
                getSrcIdCount.append(" where t3.FID in (" + params + ") and t0.fisbysuite=1");
            }
            IRowSet srcIdCount = DbUtil.executeQuery((Context)ctx, (String)getSrcIdCount.toString());
            int num = 0;
            try {
                while (srcIdCount.next()) {
                    num = srcIdCount.getInt("num");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (num > 0) {
                StringBuffer getSrcId = new StringBuffer();
                getSrcId.append("select distinct t0.fid FROM T_MM_PickingSlipBill t0 inner join T_MM_PickingSlipBillEntry t1 on t0.fid=t1.fparentid");
                getSrcId.append(" inner join  T_MM_PSMRRelation t2 on t2.FSrcEntryID= t1.fid");
                getSrcId.append(" inner join  T_IM_MaterialReqBillEntry t3 on t3.FSourceBillEntryID= t2.FTempEntryID");
                if (pks.length == 1) {
                    getSrcId.append(" where t3.FID = " + params + " and t0.fisbysuite=1");
                } else {
                    getSrcId.append(" where t3.FID in (" + params + ") and t0.fisbysuite=1");
                }
                IRowSet srcIds = DbUtil.executeQuery((Context)ctx, (String)getSrcId.toString());
                ArrayList<String> srcIdResult = new ArrayList<String>();
                try {
                    while (srcIds.next()) {
                        srcIdResult.add(srcIds.getString("fid"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (srcIdResult.size() > 0) {
                    StringBuffer updatePS = new StringBuffer();
                    updatePS.append(" update T_MM_PickingSlipBill as t0 ");
                    updatePS.append(" set FPickedTotalSuite = ");
                    updatePS.append(" (select min(decimal((t1.FPickedTotalQty + t1.FIssuedTotalQty) / t1.FReqQty,21,8) * t2.FReqSuite) from T_MM_PickingSlipBillEntry t1 inner join T_MM_PickingSlipBill t2 on t1.fparentid = t2.fid  where t2.fid = t0.fid )");
                    if (srcIdResult.size() == 1) {
                        updatePS.append(" where t0.fid = '" + srcIdResult.get(0) + "'");
                    } else {
                        String strIdLists = StringUtils.arrayToString((Object[])srcIdResult.toArray(), (String)"','");
                        updatePS.append(" where t0.fid in  ('" + strIdLists + "')");
                    }
                    DbUtil.execute((Context)ctx, (String)updatePS.toString());
                }
            }
        }
        StringBuffer deleteTemp = new StringBuffer();
        deleteTemp.append(" delete from  T_MM_PSMRRelation  ");
        deleteTemp.append(" where fid in ");
        deleteTemp.append("(select  distinct t2.fid ");
        deleteTemp.append(" from  T_IM_MaterialReqBillEntry t1,T_MM_PSMRRelation t2");
        deleteTemp.append(" where t1.FSourceBillEntryID = t2.FTempEntryID  ");
        if (pks.length == 1) {
            deleteTemp.append(" and t1.FID = " + params + ")");
        } else {
            deleteTemp.append(" and t1.FID in (" + params + "))");
        }
        DbUtil.execute((Context)ctx, (String)deleteTemp.toString());
    }

    @Override
    protected void _handleWriteBack_MRDelete(Context ctx, IObjectPK materialReqBillID) throws BOSException, EASBizException {
        SelectorItemCollection itemColl = new SelectorItemCollection();
        itemColl.add(new SelectorItemInfo("*"));
        itemColl.add(new SelectorItemInfo("transactionType.*"));
        MaterialReqBillInfo model = (MaterialReqBillInfo)MaterialReqBillFactory.getLocalInstance((Context)ctx).getValue(materialReqBillID, itemColl);
        TransactionTypeInfo transactionTypeInfo = model.getTransactionType();
        if (transactionTypeInfo != null) {
            transactionTypeInfo = TransactionTypeHelper.getTransactionTypeDataByID((Context)ctx, (String)transactionTypeInfo.getId().toString());
        }
        if (transactionTypeInfo.getRiType() != null && transactionTypeInfo.getRiType().getBizDirection().getValue() == 1) {
            StringBuffer updatePSEntry = new StringBuffer();
            updatePSEntry.append(" update T_MM_PickingSlipBillEntry as t1 ");
            updatePSEntry.append(" set (FPickedTotalQty,FBasePickedTotalQty) = ");
            updatePSEntry.append("(select t1.FPickedTotalQty-t2.FPickingQty,");
            updatePSEntry.append(" t1.FBasePickedTotalQty-t2.FBasePickingQty");
            updatePSEntry.append(" from  T_MM_PSMRRelation t2");
            updatePSEntry.append(" where t1.FID = t2.FSrcEntryID  and t2.FTempEntryID in");
            updatePSEntry.append(" (select distinct t4.FSourceBillEntryID");
            updatePSEntry.append(" from T_IM_MaterialReqBill t3,T_IM_MaterialReqBillEntry t4");
            updatePSEntry.append(" where t3.FID = t4.FParentID  and t3.FID = '" + materialReqBillID + "'))");
            DbUtil.execute((Context)ctx, (String)updatePSEntry.toString());
            StringBuffer getSrcIdCount = new StringBuffer();
            getSrcIdCount.append("select count(t0.fid) as num FROM T_MM_PickingSlipBill t0 inner join T_MM_PickingSlipBillEntry t1 on t0.fid=t1.fparentid");
            getSrcIdCount.append(" inner join  T_MM_PSMRRelation t2 on t2.FSrcEntryID= t1.fid");
            getSrcIdCount.append(" inner join  T_IM_MaterialReqBillEntry t4 on t4.FSourceBillEntryID= t2.FTempEntryID");
            getSrcIdCount.append(" inner join  T_IM_MaterialReqBill t3 on t3.fid= t4.FParentID");
            getSrcIdCount.append(" where t3.FID = '" + materialReqBillID + "' and t0.fisbysuite=1");
            IRowSet srcIdCount = DbUtil.executeQuery((Context)ctx, (String)getSrcIdCount.toString());
            int num = 0;
            try {
                while (srcIdCount.next()) {
                    num = srcIdCount.getInt("num");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (num > 0) {
                StringBuffer getSrcId = new StringBuffer();
                getSrcId.append("select distinct t0.fid FROM T_MM_PickingSlipBill t0 inner join T_MM_PickingSlipBillEntry t1 on t0.fid=t1.fparentid");
                getSrcId.append(" inner join  T_MM_PSMRRelation t2 on t2.FSrcEntryID= t1.fid");
                getSrcId.append(" inner join  T_IM_MaterialReqBillEntry t4 on t4.FSourceBillEntryID= t2.FTempEntryID");
                getSrcId.append(" inner join  T_IM_MaterialReqBill t3 on t3.fid= t4.FParentID");
                getSrcId.append(" where t3.FID = '" + materialReqBillID + "' and t0.fisbysuite=1");
                IRowSet srcIds = DbUtil.executeQuery((Context)ctx, (String)getSrcId.toString());
                ArrayList<String> srcIdResult = new ArrayList<String>();
                try {
                    while (srcIds.next()) {
                        srcIdResult.add(srcIds.getString("fid"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (srcIdResult.size() > 0) {
                    StringBuffer updatePS = new StringBuffer();
                    updatePS.append(" update T_MM_PickingSlipBill as t0 ");
                    updatePS.append(" set FPickedTotalSuite = ");
                    updatePS.append(" (select min(decimal((t1.FPickedTotalQty + t1.FIssuedTotalQty) / t1.FReqQty,21,8) * t2.FReqSuite) from T_MM_PickingSlipBillEntry t1 inner join T_MM_PickingSlipBill t2 on t1.fparentid = t2.fid  where t2.fid = t0.fid )");
                    if (srcIdResult.size() == 1) {
                        updatePS.append(" where t0.fid = '" + srcIdResult.get(0) + "'");
                    } else {
                        String strIdLists = StringUtils.arrayToString((Object[])srcIdResult.toArray(), (String)"','");
                        updatePS.append(" where t0.fid in  ('" + strIdLists + "')");
                    }
                    DbUtil.execute((Context)ctx, (String)updatePS.toString());
                }
            }
        }
        StringBuffer deleteTemp = new StringBuffer();
        deleteTemp.append(" delete from  T_MM_PSMRRelation  ");
        deleteTemp.append(" where fid in ");
        deleteTemp.append("(select  distinct t3.fid ");
        deleteTemp.append(" from  T_IM_MaterialReqBill t1,T_IM_MaterialReqBillEntry t2,T_MM_PSMRRelation t3");
        deleteTemp.append(" where t1.FID = t2.FParentID  and t2.FSourceBillEntryID = t3.FTempEntryID  ");
        deleteTemp.append(" and t1.FID = '" + materialReqBillID + "')");
        DbUtil.execute((Context)ctx, (String)deleteTemp.toString());
    }

    private void updatePickingAndOrderStatus(String DestId, Context ctx) throws EASBizException, BOSException {
        String sqlCheckPickingSlip = "select a.FSrcObjectID,b.FBaseStatus from t_bot_relation a,T_MM_PickingSlipBill b  where a.FSrcObjectID = b.FID and FdestEntityID= '500AB75E' and  FSrcEntityId='A06DF1E1' and FDestObjectID = '" + DestId + "'";
        IRowSet psRs = DbUtil.executeQuery((Context)ctx, (String)sqlCheckPickingSlip);
        IRowSet psEntryRs = null;
        ArrayList<String> idAudit = new ArrayList<String>();
        ArrayList<String> idUnAudit = new ArrayList<String>();
        ArrayList orderAudit = new ArrayList();
        ArrayList orderUnAudit = new ArrayList();
        try {
            while (psRs.next()) {
                String UpdateSql;
                String SqlSelectEntry = "select count(1) as statusCount from T_MM_PickingSlipBillEntry  where FParentID = '" + psRs.getString("FSrcObjectID") + "' and FBaseStatus= " + 4;
                psEntryRs = DbUtil.executeQuery((Context)ctx, (String)SqlSelectEntry);
                if (psRs.getInt("FBaseStatus") == 4) {
                    if (!psEntryRs.next() || psEntryRs.getInt("statusCount") != 0) continue;
                    UpdateSql = " update T_mm_PickingSlipBill Set FBaseStatus= 90 where fid = '" + psRs.getString("FSrcObjectID") + "'";
                    idAudit.add(psRs.getString("FSrcObjectID"));
                    DbUtil.execute((Context)ctx, (String)UpdateSql);
                    continue;
                }
                if (psRs.getInt("FBaseStatus") != 90 || !(psEntryRs = DbUtil.executeQuery((Context)ctx, (String)SqlSelectEntry)).next() || psEntryRs.getInt("statusCount") <= 0) continue;
                UpdateSql = " update T_mm_PickingSlipBill Set FBaseStatus= 4 where fid = '" + psRs.getString("FSrcObjectID") + "'";
                idUnAudit.add(psRs.getString("FSrcObjectID"));
                DbUtil.execute((Context)ctx, (String)UpdateSql);
            }
            StringBuffer ids = new StringBuffer();
            StringBuffer sqlSelectOrderBuff = new StringBuffer();
            if (idAudit.size() > 0) {
                this.getOrderId(ctx, idAudit, orderAudit, ids, sqlSelectOrderBuff);
                ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(orderAudit, true);
            }
            if (idUnAudit.size() > 0) {
                this.getOrderId(ctx, idUnAudit, orderUnAudit, ids, sqlSelectOrderBuff);
                ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(orderUnAudit, false);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        finally {
            SQLUtils.cleanup((ResultSet)psRs);
        }
    }

    private void getOrderId(Context ctx, List idAudit, List orderAudit, StringBuffer ids, StringBuffer sqlSelectOrderBuff) throws BOSException, SQLException {
        String id;
        for (int i = 0; i < idAudit.size(); ++i) {
            ids.append("'");
            ids.append(idAudit.get(i));
            ids.append("'");
            ids.append(",");
        }
        ids = ids.replace(ids.length() - 1, ids.length(), "");
        sqlSelectOrderBuff.append(" select distinct FProductionOrderID from T_MM_PickingSlipBill where  FProductionOrderID is not null and fsourceBillId is not null");
        sqlSelectOrderBuff.append(" and fid in (" + ids + ")");
        IRowSet rowSetPick = DbUtil.executeQuery((Context)ctx, (String)sqlSelectOrderBuff.toString());
        sqlSelectOrderBuff = new StringBuffer();
        sqlSelectOrderBuff.append(" select distinct task.FProductionOrderID from T_MM_TaskDispBill task inner join T_MM_PickingSlipBill pick on task.fid = pick.FTaskDispID where");
        sqlSelectOrderBuff.append(" pick.fid in (" + ids + ")");
        sqlSelectOrderBuff.append(" and pick.fsourceBillId is not null");
        IRowSet rowSetTask = DbUtil.executeQuery((Context)ctx, (String)sqlSelectOrderBuff.toString());
        while (rowSetPick.next()) {
            id = rowSetPick.getString("FProductionOrderID");
            orderAudit.add(id);
        }
        while (rowSetTask.next()) {
            id = rowSetTask.getString("FProductionOrderID");
            orderAudit.add(id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SCMLockInvDataVO _getMaterialInventory(Context ctx, SCMLockInvDataVO dataVO, Date reqDate) throws BOSException, EASBizException {
        IInventory iInventory = InventoryFactory.getLocalInstance((Context)ctx);
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
        ILocation iLocation = LocationFactory.getLocalInstance((Context)ctx);
        IStoreType iStoreType = StoreTypeFactory.getLocalInstance((Context)ctx);
        IStoreState iStoreState = StoreStateFactory.getLocalInstance((Context)ctx);
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(dataVO.getViewInfo().getFilter());
        SelectorItemCollection invSic = new SelectorItemCollection();
        invSic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(invSic);
        InventoryCollection inventoryIdCol = iInventory.getInventoryCollection(viewInfo);
        StringBuffer strInvIDs = new StringBuffer();
        InventoryCollection aInventoryCollection = new InventoryCollection();
        HashMap<String, java.sql.Date> expCach = new HashMap<String, java.sql.Date>();
        if (inventoryIdCol.size() > 0) {
            java.sql.Date ts;
            int c = inventoryIdCol.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    strInvIDs.append(",");
                }
                strInvIDs.append("'");
                strInvIDs.append(((InventoryInfo)inventoryIdCol.getObject(i)).getId().toString());
                strInvIDs.append("'");
            }
            Connection conn = null;
            PreparedStatement perStmt = null;
            ResultSet rs = null;
            StringBuffer sb = new StringBuffer();
            HashSet<String> invIdSet = new HashSet<String>();
            if (reqDate != null) {
                sb.append("Select A.FID,C.FExp as FExp From T_IM_Inventory A ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_IM_DateOfMinDurability C on A.FLot = C.FLot AND A.FStorageOrgUnitID = C.FStorageOrgUnitID AND A.FMaterialID= C.FMaterialID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeParam D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
                sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 1 AND C.FEXP>=?");
                sb.append(" AND ( D.FID is null ");
                sb.append("   OR ( ");
                sb.append("((D.FIsNormal  =1 AND  A.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierBorrow =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierStorage =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
                sb.append(" AND ");
                sb.append("((D.FIsAvailable  =1 AND  A.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsProvisionalFreeze =1 AND A.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsOutGoodsCheck =1 AND A.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsCheckStorageFreeze =1 AND A.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5')) ");
                sb.append(" AND ");
                sb.append("(D.FIsAllStorage = 1 ");
                sb.append(" OR (D.FIsAllStorage = 0 AND A.FWarehouseID = E.FWarhouseID)) ");
                sb.append("   )) ");
                sb.append(" UNION ALL ");
                sb.append("Select A.FID, null as FExp From T_IM_Inventory A ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeParam D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
                sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 0 ");
                sb.append(" AND ( D.FID is null ");
                sb.append("   OR (");
                sb.append("((D.FIsNormal  =1 AND  A.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierBorrow =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierStorage =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
                sb.append(" AND ");
                sb.append("((D.FIsAvailable  =1 AND  A.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsProvisionalFreeze =1 AND A.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsOutGoodsCheck =1 AND A.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsCheckStorageFreeze =1 AND A.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5'))");
                sb.append(" AND ");
                sb.append("(D.FIsAllStorage = 1 ");
                sb.append(" OR (D.FIsAllStorage = 0 AND A.FWarehouseID = E.FWarhouseID))");
                sb.append("   )) ");
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    perStmt = conn.prepareStatement(sb.toString());
                    perStmt.setDate(1, new java.sql.Date(reqDate.getTime()));
                    rs = perStmt.executeQuery();
                    while (rs.next()) {
                        invIdSet.add(rs.getString("FID"));
                        ts = rs.getDate("FExp");
                        expCach.put(rs.getString("FID"), ts);
                    }
                }
                catch (SQLException ex) {
                    throw new BOSException((Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
                }
            }
            sb.append("Select A.FID,C.FExp From T_IM_Inventory A ");
            sb.append("LEFT OUTER JOIN T_IM_DateOfMinDurability C on A.FLot = C.FLot AND A.FStorageOrgUnitID = C.FStorageOrgUnitID AND A.FMaterialID= C.FMaterialID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanRangeParam D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
            sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") ");
            sb.append(" AND ( D.FID is null ");
            sb.append("   OR ( ");
            sb.append("((D.FIsNormal  =1 AND  A.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
            sb.append(" OR (D.FIsSupplierBorrow =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
            sb.append(" OR (D.FIsSupplierStorage =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
            sb.append(" AND ");
            sb.append("((D.FIsAvailable  =1 AND  A.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
            sb.append(" OR (D.FIsProvisionalFreeze =1 AND A.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
            sb.append(" OR (D.FIsOutGoodsCheck =1 AND A.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
            sb.append(" OR (D.FIsCheckStorageFreeze =1 AND A.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5')) ");
            sb.append(" AND ");
            sb.append("(D.FIsAllStorage = 1 ");
            sb.append(" OR (D.FIsAllStorage = 0 AND A.FWarehouseID = E.FWarhouseID)) ");
            sb.append("   )) ");
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                perStmt = conn.prepareStatement(sb.toString());
                rs = perStmt.executeQuery();
                while (rs.next()) {
                    invIdSet.add(rs.getString("FID"));
                    ts = rs.getDate("FExp");
                    expCach.put(rs.getString("FID"), ts);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, perStmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", invIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            aInventoryCollection = iInventory.getInventoryCollection(view);
        }
        HashMap<String, WarehouseInfo> wareHouseMap = new HashMap<String, WarehouseInfo>();
        HashMap<String, LocationInfo> locationMap = new HashMap<String, LocationInfo>();
        HashMap<String, StoreTypeInfo> storeTypeMap = new HashMap<String, StoreTypeInfo>();
        HashMap<String, StoreStateInfo> storeStateMap = new HashMap<String, StoreStateInfo>();
        HashMap<String, SupplierInfo> supplierMap = new HashMap<String, SupplierInfo>();
        HashMap<String, CustomerInfo> customerMap = new HashMap<String, CustomerInfo>();
        HashMap<String, MeasureUnitInfo> invUnitMap = new HashMap<String, MeasureUnitInfo>();
        HashMap<String, StorageOrgUnitInfo> storageMap = new HashMap<String, StorageOrgUnitInfo>();
        HashMap<String, MultiMeasureUnitInfo> mmuMap = new HashMap<String, MultiMeasureUnitInfo>();
        HashMap<String, TrackNumberInfo> trackNumberMap = new HashMap<String, TrackNumberInfo>();
        HashMap<String, InventoryInfo> inventoryMap = new HashMap<String, InventoryInfo>();
        String invID = null;
        ObjectUuidPK[] invIdList = new ObjectUuidPK[aInventoryCollection.size()];
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        int i = 0;
        int n = aInventoryCollection.size();
        while (true) {
            if (i >= n) {
                dataVO.setWareHouseMap(wareHouseMap);
                dataVO.setLocationMap(locationMap);
                dataVO.setStoreTypeMap(storeTypeMap);
                dataVO.setStorageMap(storageMap);
                dataVO.setStoreStateMap(storeStateMap);
                dataVO.setCustomerMap(customerMap);
                dataVO.setSupplierMap(supplierMap);
                dataVO.setInvUnitMap(invUnitMap);
                dataVO.setInvIdList((IObjectPK[])invIdList);
                dataVO.setInventoryMap(inventoryMap);
                dataVO.setMmuPrecisions(mmuMap);
                dataVO.setTrackNumberMap(trackNumberMap);
                return dataVO;
            }
            InventoryInfo aInventoryInfo = (InventoryInfo)aInventoryCollection.getObject(i);
            invIdList[i] = new ObjectUuidPK(aInventoryInfo.getId());
            invID = aInventoryInfo.getId().toString();
            aInventoryInfo.setExp((Date)expCach.get(invID));
            inventoryMap.put(invID, aInventoryInfo);
            if (aInventoryInfo.getWarehouse() != null) {
                wareHouseMap.put(invID, iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getWarehouse().getId().toString()), sic));
            }
            if (aInventoryInfo.getLocation() != null) {
                locationMap.put(invID, iLocation.getLocationInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getLocation().getId().toString()), sic));
            }
            if (aInventoryInfo.getStoretype() != null) {
                storeTypeMap.put(invID, iStoreType.getStoreTypeInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStoretype().getId().toString()), sic));
            }
            if (aInventoryInfo.getStorestatus() != null) {
                storeStateMap.put(invID, iStoreState.getStoreStateInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStorestatus().getId().toString()), sic));
            }
            if (aInventoryInfo.getSupplier() != null) {
                supplierMap.put(invID, iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getSupplier().getId().toString()), sic));
            }
            if (aInventoryInfo.getCustomer() != null) {
                customerMap.put(invID, iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getCustomer().getId().toString()), sic));
            }
            if (aInventoryInfo.getUnit() != null) {
                invUnitMap.put(invID, iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getUnit().getId()), sic));
            }
            if (aInventoryInfo.getStorageOrgUnit() != null) {
                storageMap.put(invID, iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStorageOrgUnit().getId().toString()), sic));
            }
            if (aInventoryInfo.getMaterial() != null && aInventoryInfo.getUnit() != null) {
                mmuMap.put(aInventoryInfo.getMaterial().getId().toString() + aInventoryInfo.getUnit().getId().toString(), imultiUnit.getMultiUnit(aInventoryInfo.getMaterial().getId().toString(), aInventoryInfo.getUnit().getId().toString()));
            }
            if (aInventoryInfo.getTrackNumber() != null) {
                trackNumberMap.put(invID, iTrackNumber.getTrackNumberInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getTrackNumber().getId().toString()), sic));
            }
            ++i;
        }
    }

    private String getFieldName(Context ctx) {
        return "FName_" + ctx.getLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _saveByBatch(Context ctx, IObjectValue[] objects) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)new PickingSlipBillEntryInfo().getBOSType().toString()), (Context)ctx, (Connection)cn);
            for (int i = 0; i < objects.length; ++i) {
                PickingSlipBillEntryInfo detailData = (PickingSlipBillEntryInfo)objects[i];
                dao.update((IObjectPK)new ObjectUuidPK(detailData.getId()), (IObjectValue)detailData);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected boolean _isComplete(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)model;
        this.validateData(ctx, psbInfo);
        PickingSlipBillEntryCollection psbeCol = this.validateDataForDoChange(ctx, psbInfo);
        return this.isComplete(psbeCol);
    }

    @Override
    protected IObjectValue _checkSpanOrgProvide(Context ctx, IObjectPK pk, String mode, boolean isEdit) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("taskDisp.id"));
        sic.add(new SelectorItemInfo("taskDisp.number"));
        sic.add(new SelectorItemInfo("taskDisp.lotNo"));
        sic.add(new SelectorItemInfo("productionOrder.id"));
        sic.add(new SelectorItemInfo("productionOrder.lotNo"));
        sic.add(new SelectorItemInfo("productionOrder.number"));
        sic.add(new SelectorItemInfo("entries.provideType"));
        sic.add(new SelectorItemInfo("entries.supplyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.supplyOrgUnit.name"));
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(pk.toString()), sic);
        PickingSlipBillEntryCollection entryCol = psbInfo.getEntries();
        PickingSlipBillEntryInfo entryInfo = null;
        if (psbInfo.getProductionOrder() != null && psbInfo.getProductionOrder().getId() != null) {
            ArrayList<String> orderIds = new ArrayList<String>();
            orderIds.add(psbInfo.getProductionOrder().getId().toString());
            ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        }
        if ("Picking".equals(mode)) {
            if (!psbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                errorMsg.append(this.getPSResource(ctx, "Msg_bill") + this.getPSResource(ctx, "NotAudited_CannotPickingSlip"));
                throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
            }
        } else {
            if (!psbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && !psbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.FINISH)) {
                if (isEdit) {
                    errorMsg.append(this.getPSResource(ctx, "Msg_bill") + this.getPSResource(ctx, "NotAuditOrFinish_CannotReturnSlip"));
                } else {
                    errorMsg.append(this.getPSResource(ctx, "Msg_bill") + psbInfo.getNumber() + this.getPSResource(ctx, "NotAuditOrFinish_CannotReturnSlip"));
                }
                throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
            }
            int require = entryCol.size();
            for (int i = entryCol.size() - 1; i >= 0; --i) {
                entryInfo = entryCol.get(i);
                if (MaterialProvideTypeEnum.SPANORGPROVIDE == entryInfo.getProvideType()) {
                    entryCol.removeObject(i);
                    continue;
                }
                if (PickingSlipLineStatusEnum.CLOSE != entryInfo.getLineStatus()) continue;
                entryCol.removeObject(i);
            }
            if (entryCol.size() == 0) {
                errorMsg.append(this.getPSResource(ctx, "Msg_ReturnSlip_check"));
                throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{errorMsg.toString()});
            }
            if (entryCol.size() < require) {
                psbInfo.put("message", Boolean.TRUE);
            }
        }
        this.validateSpanStorageForCompanyOrg(ctx, psbInfo, entryCol);
        return psbInfo;
    }

    private void validateSpanStorageForCompanyOrg(Context ctx, PickingSlipBillInfo psbInfo, PickingSlipBillEntryCollection entryCol) throws BOSException, EASBizException, PickingSlipBillException {
        PickingSlipBillEntryInfo entryInfo = null;
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(psbInfo.getStorageOrgUnit().getId());
        if (companyOriUnitInfo == null) {
            throw new PickingSlipBillException(PickingSlipBillException.STORAGEORGNOTHASCOMPANYORG);
        }
        for (int i = 0; i <= entryCol.size() - 1; ++i) {
            entryInfo = entryCol.get(i);
            StorageOrgUnitInfo suppluOrg = entryInfo.getSupplyOrgUnit();
            companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(suppluOrg.getId());
            if (companyOriUnitInfo != null) continue;
            throw new PickingSlipBillException(PickingSlipBillException.SUPPLYSTORAGEORGNOTHASCOMPANYORG, new Object[]{suppluOrg.getName()});
        }
    }

    @Override
    protected boolean _isNeedPriceMethodChoose(Context ctx, String tempTable, Vector pickingSlipVec, boolean isGather) throws BOSException {
        ArrayList idList;
        StringBuffer sql_isNeedChoose = new StringBuffer();
        if (isGather) {
            idList = new ArrayList();
            for (HashMap psMap : pickingSlipVec) {
                idList.add(psMap.get("ID"));
            }
            String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
            sql_isNeedChoose.append("select * from " + tempTable + " where fid in ('");
            sql_isNeedChoose.append(strIdLists + "') and FStorageOrgUnitID != FSupplyStorageOrgUnitID and FSupplyCompanyUnitID = FRequirementCompanyUnitID and FProvideType = " + 10930);
        } else {
            idList = new ArrayList();
            for (HashMap psMap : pickingSlipVec) {
                idList.add(psMap.get("ENTRYID"));
            }
            String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
            sql_isNeedChoose.append("select * from " + tempTable + " where FEntryID in ('");
            sql_isNeedChoose.append(strIdLists + "') and FStorageOrgUnitID != FSupplyStorageOrgUnitID and FSupplyCompanyUnitID = FRequirementCompanyUnitID and FProvideType = " + 10930);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_isNeedChoose.toString());
        return rs.size() > 0;
    }

    @Override
    protected void _afterCreateMaterialReqBill(Context ctx, List objectIds) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateIsAutoOpenDesc(Context ctx, boolean isAuto) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_IsAutoOpenDesc set FIsAuto = ");
        if (isAuto) {
            updateSql.append("1");
        } else {
            updateSql.append("0");
        }
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    @Override
    protected int _getIsAutoOpenDesc(Context ctx) throws BOSException {
        StringBuffer getSql = new StringBuffer();
        int isAuto = 1;
        getSql.append("select FIsAuto from T_MM_IsAutoOpenDesc");
        IRowSet tempRs = DbUtil.executeQuery((Context)ctx, (String)getSql.toString());
        try {
            while (tempRs.next()) {
                isAuto = tempRs.getInt("FIsAuto");
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return isAuto;
    }

    @Override
    protected boolean _getIsDividingByNumber(Context ctx) throws BOSException, EASBizException {
        this.initPSParameterFromDBSet(ctx, null);
        return this.dividebyBillNum;
    }
}

