/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.planning.PLSEntryFactory;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class PrdLotServerUtils {
    public static final String RES_PRD_NEXT_ORDER = "com.kingdee.eas.mm.control.ProductionOrderNextResource";

    public static void dealLotNo(Context ctx, ProductionOrderInfo orderInfo) throws EASBizException, BOSException {
        if (orderInfo.getMaterial() == null || orderInfo.getStorageOrgUnit() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)orderInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orderInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
        if (inv.size() <= 0) {
            return;
        }
        MaterialInventoryInfo invInfo = inv.get(0);
        if (!invInfo.isIsLotNumber()) {
            return;
        }
        LotParamValueInfo param = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(orderInfo.getStorageOrgUnit().getId().toString());
        boolean isPlanOrderGene = param.isProductionOrderPlan();
        boolean isPrdOrderGene = param.isProductionOrderProduction();
        boolean isDefaultCarried = param.isProductionOrderProsee();
        BillTypeInfo billType = orderInfo.getSourceBillType();
        if (billType != null) {
            if (billType.getId().toString().equals("OC9YcwEhEADgAAApfwAAAUY+1VI=")) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("srcType");
                sic.add("sourceBillId");
                PLSEntryInfo plsEntry = (PLSEntryInfo)PLSEntryFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(orderInfo.getSourceBillEntry()), sic);
                if (plsEntry.getSrcType() == null) {
                    plsEntry.setSrcType(SrcTypeEnum.MANUAL);
                }
                if (isPlanOrderGene) {
                    if (isPrdOrderGene) {
                        if (isDefaultCarried) {
                            switch (plsEntry.getSrcType().getValue()) {
                                case 20: {
                                    PrdLotServerUtils.carriedLotNo(ctx, plsEntry.getSourceBillId(), orderInfo);
                                    break;
                                }
                                case 10: 
                                case 30: {
                                    PrdLotServerUtils.dealLotRule(ctx, orderInfo);
                                }
                            }
                        } else {
                            PrdLotServerUtils.dealLotRule(ctx, orderInfo);
                        }
                    } else {
                        switch (plsEntry.getSrcType().getValue()) {
                            case 20: {
                                PrdLotServerUtils.carriedLotNo(ctx, plsEntry.getSourceBillId(), orderInfo);
                                break;
                            }
                            case 10: 
                            case 30: {
                                PrdLotServerUtils.dealLotRule(ctx, orderInfo);
                            }
                        }
                    }
                } else if (isPrdOrderGene) {
                    PrdLotServerUtils.dealLotRule(ctx, orderInfo);
                }
            } else if (billType.getId().toString().equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
                if (isPlanOrderGene) {
                    if (isPrdOrderGene) {
                        if (isDefaultCarried) {
                            PrdLotServerUtils.carriedLotNo(ctx, orderInfo.getSourceBillId(), orderInfo);
                        } else {
                            PrdLotServerUtils.dealLotRule(ctx, orderInfo);
                        }
                    } else {
                        PrdLotServerUtils.carriedLotNo(ctx, orderInfo.getSourceBillId(), orderInfo);
                    }
                } else if (isPrdOrderGene) {
                    PrdLotServerUtils.dealLotRule(ctx, orderInfo);
                }
            }
        } else if (isPlanOrderGene || !isPlanOrderGene && isPrdOrderGene) {
            PrdLotServerUtils.dealLotRule(ctx, orderInfo);
        }
    }

    private static void carriedLotNo(Context ctx, String planOrderId, ProductionOrderInfo orderInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = new SelectorItemCollection();
        sic.add("lot");
        PlannedOrderInfo plOrderInfo = (PlannedOrderInfo)PlannedOrderFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(planOrderId), sic);
        orderInfo.setLotNo(plOrderInfo.getLot());
    }

    private static void dealLotRule(Context ctx, ProductionOrderInfo orderInfo) throws EASBizException, BOSException {
        LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrame(orderInfo.getMaterial().getId().toString(), orderInfo.getStorageOrgUnit().getId().toString());
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            LotFrameManu lot = new LotFrameManu();
            lot.setSeq(lotFrame.getSeq());
            lot.setSysDate(lotFrame.getSysDate());
            lot.setCurrentSerial(lotFrame.getCurrentSerial());
            lot.setLotRule(lotFrame.getLotRule());
            lot.setBillNumber(orderInfo.getNumber());
            lot.setMainBizOrg(orderInfo.getStorageOrgUnit().getNumber());
            lot.setMaterial(orderInfo.getMaterial().getNumber());
            lot.setFreeProp1(orderInfo.getProductLine().getNumber());
            lot.setMfg(orderInfo.getEndDate());
            lot.setBizDate(orderInfo.getBizDate());
            long currentSerial = BatchFileFactory.getLocalInstance((Context)ctx).updateLotRuleAssign(orderInfo.getMaterial().getId().toString(), orderInfo.getStorageOrgUnit().getId().toString());
            lot.setCurrentSerial(currentSerial);
            String lotNo = lot.getLotNumber();
            orderInfo.setLotNo(lotNo);
        }
    }

    public static String checkPrdLotInfo(Context ctx, String ids) throws EASBizException, BOSException {
        if (ids.length() > 0) {
            String[] idStrs = ids.split(",");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < idStrs.length; ++i) {
                idSet.add(idStrs[i].replaceAll("'", ""));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            EntityViewInfo viewer = new EntityViewInfo();
            viewer.setFilter(filter);
            ProductionOrderCollection orders = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderCollection(viewer);
            StringBuffer errNumber = new StringBuffer();
            for (int i = 0; i < orders.size(); ++i) {
                MaterialInventoryInfo invInfo;
                ProductionOrderInfo order = orders.get(i);
                viewer = new EntityViewInfo();
                filter = new FilterInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("isLotNumber");
                viewer.setSelector(selector);
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)order.getMaterial().getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)order.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                viewer.setFilter(filter);
                MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
                if (inv.size() <= 0 || !(invInfo = inv.get(0)).isIsLotNumber()) continue;
                LotFrame lotFrame = new LotFrame();
                lotFrame.setMainBizOrg(order.getStorageOrgUnit().getId().toString());
                lotFrame.setMaterial(order.getMaterial().getId().toString());
                List lotList = new ArrayList<LotFrame>();
                lotList.add(lotFrame);
                lotList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotList);
                if (lotList != null && lotList.size() > 0) {
                    lotFrame = (LotFrame)lotList.get(0);
                }
                LotParamValueInfo param = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(order.getStorageOrgUnit().getId().toString());
                boolean isPlanOrderGene = param.isProductionOrderPlan();
                boolean isPrdOrderGene = param.isProductionOrderProduction();
                if (lotFrame == null || lotFrame.getLotRule() == null) {
                    if (!isPlanOrderGene && !isPrdOrderGene || order.getLotNo() != null && !order.getLotNo().trim().equals("")) continue;
                    errNumber.append(order.getNumber() + ",");
                    continue;
                }
                if (isPlanOrderGene) {
                    if (order.getLotNo() != null && !order.getLotNo().trim().equals("")) continue;
                    errNumber.append(order.getNumber() + ",");
                    continue;
                }
                if (!isPrdOrderGene || order.getLotNo() != null && !order.getLotNo().trim().equals("")) continue;
                errNumber.append(order.getNumber() + ",");
            }
            if (errNumber.length() > 0) {
                return errNumber.replace(errNumber.length() - 1, errNumber.length(), "").toString();
            }
            return "";
        }
        return "";
    }

    public static void checkPrdLotInfo(Context ctx, String ids, BatchActionResults batchResults) throws EASBizException, BOSException {
        if (ids.length() > 0) {
            String[] idStrs = ids.split(",");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < idStrs.length; ++i) {
                idSet.add(idStrs[i].replaceAll("'", ""));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            EntityViewInfo viewer = new EntityViewInfo();
            viewer.setFilter(filter);
            ProductionOrderCollection orders = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderCollection(viewer);
            for (int i = 0; i < orders.size(); ++i) {
                MaterialInventoryInfo invInfo;
                ProductionOrderInfo order = orders.get(i);
                viewer = new EntityViewInfo();
                filter = new FilterInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("isLotNumber");
                viewer.setSelector(selector);
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)order.getMaterial().getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)order.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                viewer.setFilter(filter);
                MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
                if (inv.size() <= 0 || !(invInfo = inv.get(0)).isIsLotNumber()) continue;
                LotFrame lotFrame = new LotFrame();
                lotFrame.setMainBizOrg(order.getStorageOrgUnit().getId().toString());
                lotFrame.setMaterial(order.getMaterial().getId().toString());
                List lotList = new ArrayList<LotFrame>();
                lotList.add(lotFrame);
                lotList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotList);
                if (lotList != null && lotList.size() > 0) {
                    lotFrame = (LotFrame)lotList.get(0);
                }
                LotParamValueInfo param = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(order.getStorageOrgUnit().getId().toString());
                boolean isPlanOrderGene = param.isProductionOrderPlan();
                boolean isPrdOrderGene = param.isProductionOrderProduction();
                if (lotFrame == null || lotFrame.getLotRule() == null) {
                    if (!isPlanOrderGene && !isPrdOrderGene || order.getLotNo() != null && !order.getLotNo().trim().equals("")) continue;
                    batchResults.addError(order.getId().toString(), PrdLotServerUtils.getResourceMsg("lotNull", ctx));
                    continue;
                }
                if (isPlanOrderGene) {
                    if (order.getLotNo() != null && !order.getLotNo().trim().equals("")) continue;
                    batchResults.addError(order.getId().toString(), PrdLotServerUtils.getResourceMsg("lotNull", ctx));
                    continue;
                }
                if (!isPrdOrderGene || order.getLotNo() != null && !order.getLotNo().trim().equals("")) continue;
                batchResults.addError(order.getId().toString(), PrdLotServerUtils.getResourceMsg("lotNull", ctx));
            }
        }
    }

    private static String getResourceMsg(String key, Context ctx) {
        return ResourceManage.getResource((String)RES_PRD_NEXT_ORDER, (String)key, (Locale)ctx.getLocale());
    }
}

