/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.mm.common.backFlush.BFBillCollection;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordCollection;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordInfo;
import com.kingdee.eas.mm.common.backFlush.app.IBFDataParser;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ProductionOrderParser
implements IBFDataParser {
    private Context ctx;

    public ProductionOrderParser() {
    }

    public ProductionOrderParser(Context context) {
        this.ctx = context;
    }

    public CoreBillBaseCollection parseData(BackFlushRecordCollection records) throws EASBizException, BOSException {
        BFBillCollection orderCol = new BFBillCollection();
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> entryIdSet = new HashSet<String>();
        HashMap bfMap = new HashMap();
        BackFlushRecordInfo info2 = null;
        for (BackFlushRecordInfo info2 : records) {
            idSet.add(info2.getOrderId());
            entryIdSet.add(info2.getOrderEntryId());
            this.groupBackFlushRecord(bfMap, info2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        entryFilter.setEntryName("stockEntry");
        view.setFilter(filter);
        view.getEntryFilters().add(entryFilter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("stockEntry.*"));
        ProductionOrderCollection poCol = this.getBizInterface().getProductionOrderCollection(view);
        ProductionOrderInfo poInfo = null;
        Iterator ite = poCol.iterator();
        while (ite.hasNext()) {
            poInfo = (ProductionOrderInfo)ite.next();
            this.parseToOrder(bfMap, poInfo, orderCol);
        }
        return orderCol;
    }

    private void parseToOrder(Map bfMap, ProductionOrderInfo poInfo, BFBillCollection orderCol) {
        Map map = (Map)bfMap.get(poInfo.getId().toString());
        BackFlushRecordCollection col = null;
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
            col = (BackFlushRecordCollection)entry2.getValue();
            if (col == null || col.size() <= 0) continue;
            orderCol.addBFBill((IObjectValue)this.doParse(poInfo, col));
        }
    }

    private ProductionOrderInfo doParse(ProductionOrderInfo poInfo, BackFlushRecordCollection col) {
        ProductionOrderInfo cloneInfo = (ProductionOrderInfo)poInfo.clone();
        cloneInfo.setBackFlushBillId(col.get(0).getSrcBillId());
        cloneInfo.setBackFlushBillEntryId(col.get(0).getSrcBillEntryId());
        cloneInfo.setBizDate(col.get(0).getBackFlushDate());
        ProductionOrderStockEntryInfo entryInfo = null;
        BackFlushRecordInfo bfInfo2 = null;
        boolean isExsit = false;
        Iterator ite = cloneInfo.getStockEntry().iterator();
        while (ite.hasNext()) {
            entryInfo = (ProductionOrderStockEntryInfo)ite.next();
            isExsit = false;
            for (BackFlushRecordInfo bfInfo2 : col) {
                if (!bfInfo2.getOrderEntryId().equals(entryInfo.getId().toString())) continue;
                entryInfo.setQty(bfInfo2.getPlanBFQty().subtract(bfInfo2.getTotalBFQty()));
                entryInfo.setBaseQty(bfInfo2.getBasePlanBFQty().subtract(bfInfo2.getBaseTotalBFQty()));
                isExsit = true;
            }
            if (isExsit) continue;
            ite.remove();
        }
        return cloneInfo;
    }

    private void groupBackFlushRecord(Map bfMap, BackFlushRecordInfo info) {
        Map<String, BackFlushRecordCollection> map = null;
        BackFlushRecordCollection col = null;
        if (bfMap.containsKey(info.getOrderId())) {
            map = (Map)bfMap.get(info.getOrderId());
            if (map.containsKey(info.getSrcBillEntryId())) {
                col = (BackFlushRecordCollection)map.get(info.getSrcBillEntryId());
                col.add(info);
            } else {
                col = new BackFlushRecordCollection();
                col.add(info);
                map.put(info.getSrcBillEntryId(), col);
            }
        } else {
            map = new HashMap();
            col = new BackFlushRecordCollection();
            col.add(info);
            map.put(info.getSrcBillEntryId(), col);
            bfMap.put(info.getOrderId(), map);
        }
    }

    protected IProductionOrder getBizInterface() throws BOSException {
        return ProductionOrderFactory.getLocalInstance(this.ctx);
    }

    public void setContext(Context context) {
        this.ctx = context;
    }
}

