/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryFactory;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.ProductionStrategyHelper;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.SACalcParamInfo;
import com.kingdee.eas.mm.control.SAGroupEnum;
import com.kingdee.eas.mm.control.SARuleEnum;
import com.kingdee.eas.mm.control.SASourceInfo;
import com.kingdee.eas.mm.control.SAStockInfo;
import com.kingdee.eas.mm.control.SATransactionEnum;
import com.kingdee.eas.mm.control.TransactionTypeEnum;
import com.kingdee.eas.mm.control.app.AbstractStockOperation;
import com.kingdee.eas.mm.control.app.util.StockAllocationUtil;
import com.kingdee.eas.mm.control.util.ProductionOrderHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class StockAllocationOperation
extends AbstractStockOperation {
    protected StockAllocationOperation() {
    }

    protected StockAllocationOperation(SACalcParamInfo calcParam, SARuleEnum sARuleEnum, SATransactionEnum sATransactionEnum, Map sASourceReQtyMap, String storageUnitId) {
        super(calcParam, sARuleEnum, sATransactionEnum, sASourceReQtyMap, storageUnitId);
    }

    @Override
    protected List SourceList(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, List orderIds, int saRule) throws BOSException, EASBizException {
        List resultList = super.SourceList(ctx, storageOrgUnitInfo, orderIds, saRule);
        IProductionOrder prodOrder = ProductionOrderFactory.getLocalInstance(ctx);
        ProductionOrderCollection ptOrderCollection = prodOrder.getProductionOrderCollection(this.getViewInfo());
        this.setPrecisionMap(ctx, ptOrderCollection);
        Object[] objects = this.GetStockColl(ctx, ptOrderCollection);
        resultList.add(ptOrderCollection);
        resultList.add(objects[0]);
        resultList.add(this.getPrecisionMap());
        resultList.add(objects[1]);
        return resultList;
    }

    private void setPrecisionMap(Context ctx, ProductionOrderCollection ptOrderCollection) throws BOSException {
        if (ptOrderCollection != null && ptOrderCollection.size() > 0) {
            Iterator it = ptOrderCollection.iterator();
            while (it.hasNext()) {
                ProductionOrderInfo ptOrderInfo = (ProductionOrderInfo)it.next();
                String materialId = ptOrderInfo.getMaterial().getId().toString();
                String unitId = ptOrderInfo.getUnit().getId().toString();
                this.buildSql(materialId, unitId);
                ProductionOrderStockEntryCollection ptOrderStockCollection = ptOrderInfo.getStockEntry();
                if (ptOrderStockCollection == null || ptOrderStockCollection.size() <= 0) continue;
                for (int i = 0; i < ptOrderStockCollection.size(); ++i) {
                    ProductionOrderStockEntryInfo ptOrderStockInfo = ptOrderStockCollection.get(i);
                    this.buildSql(ptOrderStockInfo.getMaterial().getId().toString(), ptOrderStockInfo.getUnit().getId().toString());
                }
            }
        }
        this.executePrecisionSql(ctx);
    }

    @Override
    protected Object[] GetStockColl(Context ctx, ProductionOrderCollection ptOrderCollection) throws BOSException, EASBizException {
        Object[] objects = new Object[2];
        HashMap<String, SASourceInfo> sASourceMap = new HashMap<String, SASourceInfo>();
        ProductionOrderStockEntryCollection ptStaticOrderStockCollection = new ProductionOrderStockEntryCollection();
        Iterator it = ptOrderCollection.iterator();
        while (it.hasNext()) {
            ProductionOrderInfo ptOrderInfo = (ProductionOrderInfo)it.next();
            ProductionOrderStockEntryCollection ptOrderStockCollection = ptOrderInfo.getStockEntry();
            BigDecimal maxBaseReceiptQty = SysConstant.BIGZERO;
            BigDecimal minBaseReceiptQty = SysConstant.BIGZERO;
            if (ptOrderStockCollection != null && ptOrderStockCollection.size() > 0) {
                int count = 0;
                for (int i = 0; i < ptOrderStockCollection.size(); ++i) {
                    ProductionOrderStockEntryInfo ptOrderStockInfo = ptOrderStockCollection.get(i);
                    boolean isStock = ptOrderStockInfo.isIsStock();
                    MaterialIssueModeEnum issueMode = ptOrderStockInfo.getIssMode();
                    MaterialProvideTypeEnum provideType = ptOrderStockInfo.getProvideType();
                    if (!isStock || issueMode != MaterialIssueModeEnum.PRODUCEISSMODE || provideType != MaterialProvideTypeEnum.CURRENTORGPROVIDE && provideType != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) continue;
                    ptStaticOrderStockCollection.add(ptOrderStockInfo);
                    BigDecimal unitBaseQty = this.getBaseUnitQty(ctx, ptOrderStockInfo, ptOrderInfo);
                    BigDecimal totalTransferInBaseQty = ptOrderStockInfo.getTotalTransferInBaseQty();
                    this.setParentInfo(ptOrderInfo, ptOrderStockInfo);
                    if (totalTransferInBaseQty == null) {
                        totalTransferInBaseQty = SysConstant.BIGZERO;
                    }
                    BigDecimal unitBaseQtyDivTR = SysConstant.BIGZERO;
                    if (totalTransferInBaseQty.compareTo(SysConstant.BIGZERO) > 0 && unitBaseQty.compareTo(SysConstant.BIGZERO) != 0) {
                        unitBaseQtyDivTR = totalTransferInBaseQty.divide(unitBaseQty, 16, 4);
                    }
                    if (count == 0) {
                        maxBaseReceiptQty = unitBaseQtyDivTR;
                        minBaseReceiptQty = unitBaseQtyDivTR;
                    } else {
                        if (unitBaseQtyDivTR.compareTo(maxBaseReceiptQty) > 0) {
                            maxBaseReceiptQty = unitBaseQtyDivTR;
                        }
                        if (unitBaseQtyDivTR.compareTo(minBaseReceiptQty) < 0) {
                            minBaseReceiptQty = unitBaseQtyDivTR;
                        }
                    }
                    ++count;
                }
            }
            SASourceInfo saSourceInfo = new SASourceInfo();
            saSourceInfo.setOrderId(ptOrderInfo.getId().toString());
            saSourceInfo.setPrdId(ptOrderInfo.getMaterial().getId().toString());
            saSourceInfo.setUnitId(ptOrderInfo.getUnit().getId().toString());
            if (ptOrderInfo.getMaterial().getBaseUnit() == null) {
                ObjectUuidPK pk = new ObjectUuidPK(ptOrderInfo.getMaterial().getId().toString());
                MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)pk);
                saSourceInfo.setBsUnitId(materialInfo.getBaseUnit().getId().toString());
            } else {
                saSourceInfo.setBsUnitId(ptOrderInfo.getMaterial().getBaseUnit().getId().toString());
            }
            saSourceInfo.setBsMaxReceiptQty(maxBaseReceiptQty.setScale(16, 4));
            saSourceInfo.setBsMinReceiptQty(minBaseReceiptQty.setScale(16, 4));
            saSourceInfo.setMaxReceiptQty(maxBaseReceiptQty.setScale(16, 4));
            saSourceInfo.setMinReceiptQty(minBaseReceiptQty.setScale(16, 4));
            sASourceMap.put(ptOrderInfo.getId().toString(), saSourceInfo);
        }
        objects[0] = sASourceMap;
        objects[1] = ptStaticOrderStockCollection;
        return objects;
    }

    private BigDecimal getBaseUnitQty(Context ctx, ProductionOrderStockEntryInfo ptfStockInfo, ProductionOrderInfo ptinfo) throws EASBizException, BOSException {
        BigDecimal baseUnitQty = ProductionOrderHelper.emptyToZero(ptfStockInfo.getBaseQty().divide(ptinfo.getBaseQty(), 16, 4));
        return baseUnitQty;
    }

    protected void setParentInfo(ProductionOrderInfo ptOrderInfo, ProductionOrderStockEntryInfo ptOrderStockInfo) {
        ptOrderStockInfo.setParent(ptOrderInfo);
    }

    @Override
    protected Map Calculate(Context ctx, ProductionOrderCollection ptOrderCollection, ProductionOrderStockEntryCollection ptOrderStockCollection) throws BOSException, EASBizException, SQLException {
        this.setContext(ctx);
        ProductionOrderStockEntryCollection ptStockCollection = this.filterByParamInfo(ptOrderStockCollection);
        this.calcStorageQty(ptStockCollection);
        this.calcReserveMap(ptOrderCollection, ptStockCollection);
        this.calcSimulateInvMap(ptStockCollection);
        return this.manageMaps(ptStockCollection);
    }

    private void calcStorageQty(ProductionOrderStockEntryCollection ptStockCollection) throws BOSException, EASBizException, SQLException {
        if (ptStockCollection != null) {
            for (int i = 0; i < ptStockCollection.size(); ++i) {
                ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                this.setStoragQty(ptStockInfo);
                this.setTransferBatch(ptStockInfo);
            }
        }
    }

    private void setStoragQty(ProductionOrderStockEntryInfo ptStockInfo) throws BOSException, SQLException, EASBizException {
        String strategyId;
        IInventory inventory = InventoryFactory.getLocalInstance((Context)this.getContext());
        if (ptStockInfo.getDefaultWarehouse() == null) {
            this.storagetQtyMap.put(ptStockInfo.getId().toString(), SysConstant.BIGZERO);
            return;
        }
        String materialId = ptStockInfo.getMaterial().getId().toString();
        String warehouseId = ptStockInfo.getDefaultWarehouse().getId().toString();
        String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, materialId);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseId));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageUnitId()));
        ResultSet rs = StoreCommonUtil.getPlanVersionSetStoretypeAndStorestate((Context)this.getContext(), (String)"901", (String)this.getStorageUnitId());
        while (rs.next()) {
            this.setStoreTypeID(rs.getString("fstoretype"));
            this.setStoreStatusID(rs.getString("fstorestate"));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storeType.id", (Object)this.getStoreTypeID(), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("storestatus.id", (Object)this.getStoreStatusID(), CompareType.INCLUDE));
        ManufactureStrategyInfo manufactureStrategyInfo = ProductionStrategyHelper.getManufactureStrategy((Context)this.getContext(), (String)materialId, (String)this.getStorageUnitId());
        if (manufactureStrategyInfo != null && ((strategyId = manufactureStrategyInfo.getId().toString()).equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && ptStockInfo.getParent().getTrackNumber() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)ptStockInfo.getParent().getTrackNumber().getId().toString()));
        }
        view.setFilter(filterInfo);
        InventoryCollection inventoryCollection = inventory.getInventoryCollection(view);
        BigDecimal sumBaseBaseQty = SysConstant.BIGZERO;
        if (inventoryCollection != null) {
            for (int i = 0; i < inventoryCollection.size(); ++i) {
                InventoryInfo inventoryInfo = inventoryCollection.get(i);
                BigDecimal baseQty = inventoryInfo.getBaseQty();
                sumBaseBaseQty = sumBaseBaseQty.add(baseQty);
            }
            this.storagetQtyMap.put(ptStockInfo.getId().toString(), sumBaseBaseQty);
            this.storagetQtyMap.put(materialId + warehouseId + trackNumberId, sumBaseBaseQty);
        }
    }

    private void setTransferBatch(ProductionOrderStockEntryInfo ptStockInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)ptStockInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getStorageUnitId(), CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("productUnit.id"));
        selector.add(new SelectorItemInfo("productUnit.name"));
        selector.add(new SelectorItemInfo("productUnit.number"));
        selector.add(new SelectorItemInfo("transferBatch"));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        viewer.setSelector(selector);
        MaterialPlanCollection plans = MaterialPlanFactory.getLocalInstance((Context)this.getContext()).getMaterialPlanCollection(viewer);
        if (plans != null && plans.size() > 0) {
            MeasureUnitInfo productUnit;
            MaterialPlanInfo planInfo = plans.get(0);
            BigDecimal transferBatchQty = planInfo.getTransferBatch();
            if (transferBatchQty == null) {
                transferBatchQty = SysConstant.BIGZERO;
            }
            if ((productUnit = planInfo.getProductUnit()) != null && productUnit.getId() != null) {
                BigDecimal transferBatchBaseQty = SysConstant.BIGZERO;
                if (ptStockInfo.getMaterial().getBaseUnit() == null) {
                    ObjectUuidPK pk = new ObjectUuidPK(ptStockInfo.getMaterial().getId().toString());
                    MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)this.getContext()).getMaterialInfo((IObjectPK)pk);
                    transferBatchBaseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)productUnit, (MeasureUnitInfo)materialInfo.getBaseUnit(), (BigDecimal)transferBatchQty);
                } else {
                    transferBatchBaseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)productUnit, (MeasureUnitInfo)ptStockInfo.getMaterial().getBaseUnit(), (BigDecimal)transferBatchQty);
                }
                this.transferBatchMap.put(ptStockInfo.getId().toString(), transferBatchBaseQty);
            } else {
                this.transferBatchMap.put(ptStockInfo.getId().toString(), SysConstant.BIGZERO);
            }
        }
    }

    private void calcReserveMap(ProductionOrderCollection ptOrderCollection, ProductionOrderStockEntryCollection ptStockCollection) throws BOSException, EASBizException {
        String poIds = this.getStrIds(ptOrderCollection);
        boolean isOutSourceFlag = false;
        if (ptOrderCollection.size() > 0) {
            isOutSourceFlag = ptOrderCollection.get(0).isOutSourceFlag();
        }
        if (ptStockCollection != null) {
            for (int i = 0; i < ptStockCollection.size(); ++i) {
                ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                if (ptStockInfo.getDefaultWarehouse() == null) {
                    this.stockReserveMap.put(ptStockInfo.getId().toString(), SysConstant.BIGZERO);
                    continue;
                }
                String materialId = ptStockInfo.getMaterial().getId().toString();
                String warehouseId = ptStockInfo.getDefaultWarehouse().getId().toString();
                String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, materialId);
                BigDecimal poOccupyBaseQty = null;
                StringBuffer poOcuSqlBuffer = new StringBuffer();
                poOcuSqlBuffer.append("select sum(case when e.FQty-e.FSendOutTotalQty+e.FUntreadTotalQty-isnull(e.FTotleReceiveQty,0)<0 then 0 else e.FQty-e.FSendOutTotalQty+e.FUntreadTotalQty-isnull(e.FTotleReceiveQty,0) end) as poOccupyQty ");
                poOcuSqlBuffer.append(", ");
                poOcuSqlBuffer.append("sum(case when e.FBaseQty-e.FbaseSendOutTotalQty+e.FbaseUntreadTotalQty-isnull(e.FBaseTotleReceiveQty,0)<0 then 0 else e.FBaseQty-e.FbaseSendOutTotalQty+e.FbaseUntreadTotalQty-isnull(e.FBaseTotleReceiveQty,0) end) as  poOccupyBaseQty ");
                poOcuSqlBuffer.append(" FROM T_MM_ProductionOrderSEntry e ");
                poOcuSqlBuffer.append("inner join T_MM_ProductionOrder o on o.FID = e.FParentID ");
                poOcuSqlBuffer.append("inner join T_DB_warehouse h on h.FID=e.FDefaultWarehouseID ");
                poOcuSqlBuffer.append("where ");
                poOcuSqlBuffer.append("o.FID NOT IN (" + poIds + ") ");
                if (isOutSourceFlag) {
                    poOcuSqlBuffer.append("and o.FOutSourceFlag =1 ");
                } else {
                    poOcuSqlBuffer.append("and o.FOutSourceFlag =0 ");
                }
                if (this.getBillStatusSet() != null) {
                    Set tempSet = this.getBillStatusSet();
                    if (tempSet.contains(new Integer(2))) {
                        tempSet.remove(new Integer(2));
                    }
                    poOcuSqlBuffer.append("and o.FBaseStatus in (" + tempSet + ") ");
                }
                poOcuSqlBuffer.append("and e.FmaterialId ='" + materialId + "' ");
                poOcuSqlBuffer.append("and e.FDefaultWarehouseID = '" + warehouseId + "' ");
                poOcuSqlBuffer.append("and o.FStorageOrgUnitID = '" + this.getStorageUnitId() + "' ");
                if (trackNumberId != null && trackNumberId.length() > 0) {
                    poOcuSqlBuffer.append("and o.FTrackNumberID = '" + trackNumberId + "' ");
                }
                poOcuSqlBuffer.append("and e.fissmode IN (11010,11020) ");
                poOcuSqlBuffer.append("and e.fprovidetype IN (10910,10920) ");
                try {
                    IRowSet poRs = DbUtil.executeQuery((Context)this.getContext(), (String)poOcuSqlBuffer.toString());
                    while (poRs.next()) {
                        poOccupyBaseQty = poRs.getBigDecimal("poOccupyBaseQty") != null ? poRs.getBigDecimal("poOccupyBaseQty") : SysConstant.BIGZERO;
                    }
                    BigDecimal occupyQty = poOccupyBaseQty;
                    this.stockReserveMap.put(ptStockInfo.getId().toString(), occupyQty);
                    this.stockReserveMap.put(materialId + warehouseId + trackNumberId, occupyQty);
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void calcSimulateInvMap(ProductionOrderStockEntryCollection ptStockCollection) throws EASBizException, BOSException {
        Map stockGroupMap = this.groupStockByMeterialWarehouse(ptStockCollection);
        List o = (List)stockGroupMap.remove("withoutWarehouseList");
        this.calcWithoutWarsehosueTransferQty(o);
        this.calcSimulateInvTransferQty(stockGroupMap);
    }

    private Map groupStockByMeterialWarehouse(ProductionOrderStockEntryCollection sortedStockCollection) throws EASBizException, BOSException {
        HashMap stockGroupMap = new HashMap();
        ArrayList<ProductionOrderStockEntryInfo> noWarehouseList = new ArrayList<ProductionOrderStockEntryInfo>();
        stockGroupMap.put("withoutWarehouseList", noWarehouseList);
        if (sortedStockCollection != null && sortedStockCollection.size() > 0) {
            for (int i = 0; i < sortedStockCollection.size(); ++i) {
                List<ProductionOrderStockEntryInfo> stockList;
                ProductionOrderStockEntryInfo ptStockInfo = sortedStockCollection.get(i);
                if (ptStockInfo.getDefaultWarehouse() == null) {
                    this.stockSimulateMap.put(ptStockInfo.getId().toString(), SysConstant.BIGZERO);
                    this.invMap.put(ptStockInfo.getId().toString(), SysConstant.BIGZERO);
                    noWarehouseList.add(ptStockInfo);
                    continue;
                }
                String materialId = ptStockInfo.getMaterial().getId().toString();
                String warehouseId = ptStockInfo.getDefaultWarehouse().getId().toString();
                String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, materialId);
                if (!stockGroupMap.containsKey(materialId + warehouseId + trackNumberId)) {
                    stockList = new ArrayList<ProductionOrderStockEntryInfo>();
                    stockList.add(ptStockInfo);
                    stockGroupMap.put(materialId + warehouseId + trackNumberId, stockList);
                    continue;
                }
                stockList = (List)stockGroupMap.get(materialId + warehouseId + trackNumberId);
                stockList.add(ptStockInfo);
            }
        }
        return stockGroupMap;
    }

    private void calcWithoutWarsehosueTransferQty(List withoutWarehouseList) throws EASBizException, BOSException {
        if (withoutWarehouseList != null && withoutWarehouseList.size() > 0) {
            for (int i = 0; i < withoutWarehouseList.size(); ++i) {
                ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)withoutWarehouseList.get(i);
                this.calcTranferQty(ptStockInfo);
            }
        }
    }

    private void calcTranferQty(ProductionOrderStockEntryInfo ptStockInfo) throws EASBizException, BOSException {
        String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, ptStockInfo.getMaterial().getId().toString());
        BigDecimal baseQty = ptStockInfo.getBaseQty();
        BigDecimal totalReceiptBaseQty = ptStockInfo.getTotalTransferInBaseQty();
        BigDecimal baseSendOutTotalQty = ptStockInfo.getBaseSendOutTotalQty();
        BigDecimal baseUntreadTotalQty = ptStockInfo.getBaseUntreadTotalQty();
        BigDecimal receitpQty = this.getReceiptQtyMap() != null ? (BigDecimal)this.getReceiptQtyMap().get(ptStockInfo.getParent().getId().toString()) : SysConstant.BIGZERO;
        BigDecimal unitBaseQty = this.getBaseUnitQty(this.getContext(), ptStockInfo, ptStockInfo.getParent());
        BigDecimal unitQty = SysConstant.BIGZERO;
        if (ptStockInfo.getMaterial().getBaseUnit() == null) {
            ObjectUuidPK pk = new ObjectUuidPK(ptStockInfo.getMaterial().getId().toString());
            MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)this.getContext()).getMaterialInfo((IObjectPK)pk);
            unitQty = StockAllocationUtil.getExchangePrecisionQtyForServer(this.getContext(), ptStockInfo.getMaterial().getId().toString(), materialInfo.getBaseUnit(), ptStockInfo.getUnit(), unitBaseQty);
        } else {
            unitQty = StockAllocationUtil.getExchangePrecisionQtyForServer(this.getContext(), ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), unitBaseQty);
        }
        BigDecimal invBaseQty = SysConstant.BIGZERO;
        if (ptStockInfo.getDefaultWarehouse() != null) {
            invBaseQty = (BigDecimal)this.invMap.get(ptStockInfo.getMaterial().getId().toString() + ptStockInfo.getDefaultWarehouse().getId().toString() + trackNumberId);
        }
        BigDecimal resultTransferBaseQty = SysConstant.BIGZERO;
        BigDecimal resultNoBatchTransferBaseQty = SysConstant.BIGZERO;
        if (this.getSARuleEnum() == SARuleEnum.NORMAL) {
            BigDecimal requiredBaseQty = SysConstant.BIGZERO;
            requiredBaseQty = this.getSATransactionEnum() == SATransactionEnum.WAREHOUSERESTOCK ? baseQty.subtract(baseSendOutTotalQty).add(baseUntreadTotalQty).subtract(ptStockInfo.getBaseTotleReceiveQty()) : baseQty.subtract(totalReceiptBaseQty);
            if (requiredBaseQty.compareTo(SysConstant.BIGZERO) < 0) {
                requiredBaseQty = SysConstant.BIGZERO;
            }
            resultNoBatchTransferBaseQty = requiredBaseQty;
            resultTransferBaseQty = this.getCalcParam().getIsEnableQty().equals("true") ? (requiredBaseQty.subtract(invBaseQty).compareTo(SysConstant.BIGZERO) > 0 ? requiredBaseQty.subtract(invBaseQty) : SysConstant.BIGZERO) : (requiredBaseQty.compareTo(SysConstant.BIGZERO) > 0 ? requiredBaseQty : SysConstant.BIGZERO);
        } else if (this.getSARuleEnum() == SARuleEnum.SUIT) {
            BigDecimal z = unitQty.multiply(receitpQty);
            z = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)ptStockInfo.getUnit(), (MeasureUnitInfo)ptStockInfo.getMaterial().getBaseUnit(), (BigDecimal)z);
            if (z.compareTo(SysConstant.BIGZERO) < 0) {
                z = SysConstant.BIGZERO;
            }
            resultNoBatchTransferBaseQty = z;
            resultTransferBaseQty = this.getCalcParam().getIsEnableQty().equals("true") ? (z.subtract(invBaseQty).compareTo(SysConstant.BIGZERO) > 0 ? z.subtract(invBaseQty) : SysConstant.BIGZERO) : z;
        } else if (this.getSARuleEnum() == SARuleEnum.REINFORCE) {
            BigDecimal y = unitQty.multiply(receitpQty);
            y = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)ptStockInfo.getUnit(), (MeasureUnitInfo)ptStockInfo.getMaterial().getBaseUnit(), (BigDecimal)y);
            if ((y = y.subtract(totalReceiptBaseQty)).compareTo(SysConstant.BIGZERO) < 0) {
                y = SysConstant.BIGZERO;
            }
            resultNoBatchTransferBaseQty = y;
            resultTransferBaseQty = this.getCalcParam().getIsEnableQty().equals("true") ? (y.subtract(invBaseQty).compareTo(SysConstant.BIGZERO) > 0 ? y.subtract(invBaseQty) : SysConstant.BIGZERO) : y;
        }
        this.transferQtyMap.put(ptStockInfo.getId().toString(), resultTransferBaseQty);
        this.transferNoBatchQtyMap.put(ptStockInfo.getId().toString(), resultNoBatchTransferBaseQty);
    }

    private void calcSimulateInvTransferQty(Map stockGroupMap) throws EASBizException, BOSException {
        Set stockGroupSet = stockGroupMap.keySet();
        if (stockGroupSet != null && stockGroupSet.size() > 0) {
            Iterator it = stockGroupSet.iterator();
            while (it.hasNext()) {
                List stockList = (List)stockGroupMap.get(it.next());
                if (stockList == null || stockList.size() <= 0) continue;
                BigDecimal simulateBaseQty = null;
                BigDecimal wholeInvQty = null;
                for (int i = 0; i < stockList.size(); ++i) {
                    ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)stockList.get(i);
                    String materialId = ptStockInfo.getMaterial().getId().toString();
                    String warehouseId = ptStockInfo.getDefaultWarehouse().getId().toString();
                    String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, materialId);
                    if (i == 0) {
                        this.stockSimulateMap.put(ptStockInfo.getId().toString(), SysConstant.BIGZERO);
                        this.stockSimulateMap.put(materialId + warehouseId + trackNumberId, SysConstant.BIGZERO);
                        BigDecimal storageQty = (BigDecimal)this.storagetQtyMap.get(materialId + warehouseId + trackNumberId);
                        BigDecimal reserveQty = this.stockReserveMap.get(materialId + warehouseId + trackNumberId) != null ? (BigDecimal)this.stockReserveMap.get(materialId + warehouseId + trackNumberId) : SysConstant.BIGZERO;
                        BigDecimal invQty = storageQty.subtract(reserveQty);
                        this.invMap.put(materialId + warehouseId + trackNumberId, invQty.compareTo(SysConstant.BIGZERO) >= 0 ? invQty : SysConstant.BIGZERO);
                        this.calcTranferQty(ptStockInfo);
                        BigDecimal[] qtyArray = this.calcNextSimuAndInv(ptStockInfo);
                        simulateBaseQty = qtyArray[0];
                        wholeInvQty = qtyArray[1];
                        continue;
                    }
                    this.stockSimulateMap.put(ptStockInfo.getId().toString(), simulateBaseQty);
                    this.stockSimulateMap.put(materialId + warehouseId + trackNumberId, simulateBaseQty);
                    this.invMap.put(materialId + warehouseId + trackNumberId, wholeInvQty);
                    this.calcTranferQty(ptStockInfo);
                    BigDecimal[] SI = this.calcNextSimuAndInv(ptStockInfo, simulateBaseQty, wholeInvQty);
                    simulateBaseQty = SI[0];
                    wholeInvQty = SI[1];
                }
            }
        }
    }

    private BigDecimal[] calcNextSimuAndInv(ProductionOrderStockEntryInfo ptStockInfo) throws EASBizException, BOSException {
        BigDecimal[] qtyArray = new BigDecimal[2];
        BigDecimal simulateBaseQty = SysConstant.BIGZERO;
        BigDecimal wholeInvQty = SysConstant.BIGZERO;
        String materialId = ptStockInfo.getMaterial().getId().toString();
        String warehouseId = ptStockInfo.getDefaultWarehouse().getId().toString();
        String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, materialId);
        BigDecimal invQty = this.invMap.get(materialId + warehouseId + trackNumberId) != null ? (BigDecimal)this.invMap.get(materialId + warehouseId + trackNumberId) : SysConstant.BIGZERO;
        BigDecimal transferQty = (BigDecimal)this.transferNoBatchQtyMap.get(ptStockInfo.getId().toString());
        if (!this.getCalcParam().getIsEnableQty().equals("true")) {
            qtyArray[0] = simulateBaseQty;
            qtyArray[1] = invQty;
            return qtyArray;
        }
        BigDecimal subtract = transferQty.subtract(invQty);
        if (subtract.compareTo(SysConstant.BIGZERO) > 0) {
            simulateBaseQty = invQty;
            wholeInvQty = SysConstant.BIGZERO;
        } else {
            simulateBaseQty = transferQty;
            wholeInvQty = invQty.subtract(transferQty);
        }
        qtyArray[0] = simulateBaseQty;
        qtyArray[1] = wholeInvQty;
        return qtyArray;
    }

    private BigDecimal[] calcNextSimuAndInv(ProductionOrderStockEntryInfo ptStockInfo, BigDecimal simulateBaseQty, BigDecimal wholeInvQty) throws EASBizException, BOSException {
        BigDecimal[] qtyArray = new BigDecimal[2];
        String materialId = ptStockInfo.getMaterial().getId().toString();
        String warehouseId = ptStockInfo.getDefaultWarehouse().getId().toString();
        String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, materialId);
        BigDecimal invQty = (BigDecimal)this.invMap.get(materialId + warehouseId + trackNumberId);
        BigDecimal transferQty = (BigDecimal)this.transferNoBatchQtyMap.get(ptStockInfo.getId().toString());
        if (!this.getCalcParam().getIsEnableQty().equals("true")) {
            qtyArray[0] = simulateBaseQty;
            qtyArray[1] = invQty;
            return qtyArray;
        }
        BigDecimal subtract = transferQty.subtract(invQty);
        if (subtract.compareTo(SysConstant.BIGZERO) > 0) {
            simulateBaseQty = invQty.add(simulateBaseQty);
            wholeInvQty = SysConstant.BIGZERO;
        } else {
            simulateBaseQty = transferQty.add(simulateBaseQty);
            wholeInvQty = invQty.subtract(transferQty);
        }
        qtyArray[0] = simulateBaseQty;
        qtyArray[1] = wholeInvQty;
        return qtyArray;
    }

    private Map manageMaps(ProductionOrderStockEntryCollection ptStockCollection) throws EASBizException, BOSException {
        Map multiMeasureUnitMap = this.getMeasureUnitMapByStockColl(ptStockCollection);
        TreeMap<String, Object> resutlMap = new TreeMap<String, Object>();
        if (this.getCalcParam().getSumWayValue().equals(String.valueOf(10))) {
            if (ptStockCollection != null && ptStockCollection.size() > 0) {
                for (int i = 0; i < ptStockCollection.size(); ++i) {
                    ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                    this.refSTInfo(resutlMap, multiMeasureUnitMap, ptStockInfo);
                }
            }
            resutlMap.put("ptStockCollection", (Object)ptStockCollection);
        } else if (this.getCalcParam().getSumWayValue().equals(String.valueOf(20))) {
            Map groupedCollectionMap = this.groupStockByMeterial(ptStockCollection);
            ProductionOrderStockEntryCollection resultCollection = new ProductionOrderStockEntryCollection();
            Set stockGroupSet = groupedCollectionMap.keySet();
            if (stockGroupSet != null && stockGroupSet.size() > 0) {
                for (String key : stockGroupSet) {
                    List stockList = (List)groupedCollectionMap.get(key);
                    if (stockList == null || stockList.size() <= 0) continue;
                    if (stockList.size() > 1) {
                        ObjectUuidPK pk;
                        HashMap billRelationMap = new HashMap();
                        BigDecimal bsInvQty = SysConstant.BIGZERO;
                        BigDecimal bsStockReserveQty = SysConstant.BIGZERO;
                        BigDecimal bsReqQty = SysConstant.BIGZERO;
                        BigDecimal bsReceiptReqQty = SysConstant.BIGZERO;
                        BigDecimal bsReceiptQty = SysConstant.BIGZERO;
                        BigDecimal bsTotalReceiptQty = SysConstant.BIGZERO;
                        BigDecimal bsTransferBatch = SysConstant.BIGZERO;
                        Date demandTime = null;
                        for (int i = 0; i < stockList.size(); ++i) {
                            Set<String> entrySet;
                            ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)stockList.get(i);
                            if (billRelationMap.get(ptStockInfo.getParent().getId().toString()) != null) {
                                entrySet = (Set)billRelationMap.get(ptStockInfo.getParent().getId().toString());
                                entrySet.add(ptStockInfo.getId().toString());
                            } else {
                                entrySet = new HashSet<String>();
                                entrySet.add(ptStockInfo.getId().toString());
                                billRelationMap.put(ptStockInfo.getParent().getId().toString(), entrySet);
                            }
                            if (i == 0) {
                                bsInvQty = (BigDecimal)this.storagetQtyMap.get(ptStockInfo.getId().toString());
                                bsStockReserveQty = this.stockReserveMap.get(ptStockInfo.getId().toString()) != null ? (BigDecimal)this.stockReserveMap.get(ptStockInfo.getId().toString()) : SysConstant.BIGZERO;
                                BigDecimal _ = this.stockSimulateMap.get(ptStockInfo.getId().toString()) != null ? (BigDecimal)this.stockSimulateMap.get(ptStockInfo.getId().toString()) : SysConstant.BIGZERO;
                                bsStockReserveQty = bsStockReserveQty.add(_);
                            }
                            bsReqQty = bsReqQty.add(ptStockInfo.getBaseQty());
                            BigDecimal temp = SysConstant.BIGZERO;
                            bsReceiptQty = bsReceiptQty.add(this.transferQtyMap.get(ptStockInfo.getId().toString()) != null ? (BigDecimal)this.transferQtyMap.get(ptStockInfo.getId().toString()) : SysConstant.BIGZERO);
                            if (this.getSATransactionEnum() == SATransactionEnum.WAREHOUSERESTOCK) {
                                bsReceiptReqQty = bsReceiptReqQty.add(ptStockInfo.getBaseQty().subtract(ptStockInfo.getBaseSendOutTotalQty()).add(ptStockInfo.getBaseUntreadTotalQty()).subtract(ptStockInfo.getBaseTotleReceiveQty()));
                                temp = ptStockInfo.getBaseQty().subtract(ptStockInfo.getBaseSendOutTotalQty()).add(ptStockInfo.getBaseUntreadTotalQty());
                            } else {
                                bsReceiptReqQty = bsReceiptReqQty.add(ptStockInfo.getBaseQty().subtract(ptStockInfo.getTotalTransferInBaseQty()));
                                temp = ptStockInfo.getBaseQty().subtract(ptStockInfo.getTotalTransferInBaseQty());
                            }
                            if ((this.getSARuleEnum() == SARuleEnum.NORMAL || this.getSARuleEnum() == SARuleEnum.REINFORCE) && temp.compareTo(SysConstant.BIGZERO) < 0) {
                                bsReceiptQty = bsReceiptQty.add(temp);
                            }
                            bsTotalReceiptQty = bsTotalReceiptQty.add(ptStockInfo.getTotalTransferInBaseQty());
                            if (i == 0) {
                                BigDecimal bigDecimal = bsTransferBatch = this.transferBatchMap.get(ptStockInfo.getId().toString()) != null ? (BigDecimal)this.transferBatchMap.get(ptStockInfo.getId().toString()) : SysConstant.BIGZERO;
                            }
                            if (ptStockInfo.getStartDate() == null) continue;
                            if (i == 0) {
                                demandTime = ptStockInfo.getStartDate();
                                continue;
                            }
                            if (demandTime.compareTo(ptStockInfo.getStartDate()) <= 0) continue;
                            demandTime = ptStockInfo.getStartDate();
                        }
                        ProductionOrderStockEntryInfo ptStockInfo = new ProductionOrderStockEntryInfo();
                        SAStockInfo sAStockInfo = new SAStockInfo();
                        ptStockInfo.setMaterial(((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial());
                        BOSUuid id = BOSUuid.create((String)"3356CB49");
                        sAStockInfo.setId(id.toString());
                        ptStockInfo.setId(id);
                        ptStockInfo.setUnit(this.getMaterialUnit((ProductionOrderStockEntryInfo)stockList.get(0)));
                        ptStockInfo.setStartDate(demandTime);
                        ptStockInfo.setDefaultWarehouse(((ProductionOrderStockEntryInfo)stockList.get(0)).getDefaultWarehouse());
                        ptStockInfo.setMoveOutStorageOrgUnit(((ProductionOrderStockEntryInfo)stockList.get(0)).getMoveOutStorageOrgUnit());
                        ptStockInfo.setMoveOutWarehouse(((ProductionOrderStockEntryInfo)stockList.get(0)).getMoveOutWarehouse());
                        ptStockInfo.setTransactionType(((ProductionOrderStockEntryInfo)stockList.get(0)).getTransactionType());
                        String trackNumberId = this.getMStragyTrackNumber((ProductionOrderStockEntryInfo)stockList.get(0), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString());
                        sAStockInfo.setTrackNumberId(trackNumberId);
                        sAStockInfo.setProductLineId(((ProductionOrderStockEntryInfo)stockList.get(0)).getParent().getProductLine() != null ? ((ProductionOrderStockEntryInfo)stockList.get(0)).getParent().getProductLine().getId().toString() : "");
                        sAStockInfo.setMaterialId(((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString());
                        if (((ProductionOrderStockEntryInfo)stockList.get(0)).getProductLineWP() != null) {
                            if (((ProductionOrderStockEntryInfo)stockList.get(0)).getProductLineWP().getNumber() == null) {
                                pk = new ObjectUuidPK(((ProductionOrderStockEntryInfo)stockList.get(0)).getProductLineWP().getId().toString());
                                ProductLineWPEntryInfo productLineWPEntryInfo = ProductLineWPEntryFactory.getLocalInstance((Context)this.getContext()).getProductLineWPEntryInfo((IObjectPK)pk);
                                sAStockInfo.setOperationNo(productLineWPEntryInfo.getNumber());
                                sAStockInfo.setOperationName(productLineWPEntryInfo.getName());
                            } else {
                                sAStockInfo.setOperationNo(((ProductionOrderStockEntryInfo)stockList.get(0)).getProductLineWP().getNumber());
                                sAStockInfo.setOperationName(((ProductionOrderStockEntryInfo)stockList.get(0)).getProductLineWP().getName());
                            }
                        } else {
                            sAStockInfo.setOperationNo("");
                            sAStockInfo.setOperationName("");
                        }
                        if (((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit() != null) {
                            sAStockInfo.setBsUnitId(((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit().getId().toString());
                        } else if (((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit() != null) {
                            sAStockInfo.setBsUnitId(((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit().getId().toString());
                        } else {
                            pk = new ObjectUuidPK(((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString());
                            MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)this.getContext()).getMaterialInfo((IObjectPK)pk);
                            sAStockInfo.setBsUnitId(materialInfo.getBaseUnit().getId().toString());
                        }
                        sAStockInfo.setBsInvQty(bsInvQty);
                        sAStockInfo.setInvQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getUnit(), sAStockInfo.getBsInvQty()));
                        sAStockInfo.setBsStockReserveQty(bsStockReserveQty);
                        sAStockInfo.setStockReserveQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getUnit(), sAStockInfo.getBsStockReserveQty()));
                        sAStockInfo.setBsReqQty(bsReqQty);
                        sAStockInfo.setReqQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getUnit(), sAStockInfo.getBsReqQty()));
                        sAStockInfo.setBsReceiptReqQty(bsReceiptReqQty.compareTo(SysConstant.BIGZERO) > 0 ? bsReceiptReqQty : SysConstant.BIGZERO);
                        sAStockInfo.setReceiptReqQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getUnit(), sAStockInfo.getBsReceiptReqQty()));
                        sAStockInfo.setBsTransferBatch(bsTransferBatch);
                        sAStockInfo.setTransferBatch(this.getQtyByKindsUnit(multiMeasureUnitMap, ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getUnit(), sAStockInfo.getBsTransferBatch()));
                        bsReceiptQty = bsReceiptQty.compareTo(SysConstant.BIGZERO) > 0 ? bsReceiptQty : SysConstant.BIGZERO;
                        BigDecimal tranferBatchBaseQty = this.getTranferBatchQty(bsReceiptQty, bsTransferBatch);
                        sAStockInfo.setBsReceiptQty(tranferBatchBaseQty);
                        sAStockInfo.setReceiptQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getUnit(), sAStockInfo.getBsReceiptQty()));
                        sAStockInfo.setBsTotalReceiptQty(bsTotalReceiptQty);
                        sAStockInfo.setTotalReceiptQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getId().toString(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getMaterial().getBaseUnit(), ((ProductionOrderStockEntryInfo)stockList.get(0)).getUnit(), sAStockInfo.getBsTotalReceiptQty()));
                        sAStockInfo.setBillRelationMap(billRelationMap);
                        resutlMap.put(sAStockInfo.getId(), sAStockInfo);
                        this.mapId(resutlMap, ptStockInfo.getId().toString(), sAStockInfo.getId().toString());
                        resultCollection.add(ptStockInfo);
                    } else {
                        ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)stockList.get(0);
                        this.refSTInfo(resutlMap, multiMeasureUnitMap, ptStockInfo);
                        resultCollection.add(ptStockInfo);
                    }
                    resutlMap.put("ptStockCollection", (Object)resultCollection);
                }
            }
        }
        return resutlMap;
    }

    private void refSTInfo(Map resutlMap, Map multiMeasureUnitMap, ProductionOrderStockEntryInfo ptStockInfo) throws EASBizException, BOSException {
        SAStockInfo sAStockInfo = new SAStockInfo();
        String id = BOSUuid.create((String)"3356CB49").toString();
        sAStockInfo.setId(id);
        sAStockInfo.setOrderId(ptStockInfo.getParent().getId().toString());
        String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, ptStockInfo.getMaterial().getId().toString());
        sAStockInfo.setTrackNumberId(trackNumberId);
        sAStockInfo.setStockEntryId(ptStockInfo.getId().toString());
        sAStockInfo.setMaterialId(ptStockInfo.getMaterial().getId().toString());
        sAStockInfo.setProductLineId(ptStockInfo.getParent().getProductLine() != null ? ptStockInfo.getParent().getProductLine().getId().toString() : "");
        if (ptStockInfo.getProductLineWP() != null) {
            if (ptStockInfo.getProductLineWP().getNumber() == null) {
                ObjectUuidPK pk = new ObjectUuidPK(ptStockInfo.getProductLineWP().getId().toString());
                ProductLineWPEntryInfo productLineWPEntryInfo = ProductLineWPEntryFactory.getLocalInstance((Context)this.getContext()).getProductLineWPEntryInfo((IObjectPK)pk);
                sAStockInfo.setOperationNo(productLineWPEntryInfo.getNumber());
                sAStockInfo.setOperationName(productLineWPEntryInfo.getName());
            } else {
                sAStockInfo.setOperationNo(ptStockInfo.getProductLineWP().getNumber());
                sAStockInfo.setOperationName(ptStockInfo.getProductLineWP().getName());
            }
        } else {
            sAStockInfo.setOperationNo("");
            sAStockInfo.setOperationName("");
        }
        sAStockInfo.setUnitId(ptStockInfo.getUnit().getId().toString());
        sAStockInfo.setBsUnitId(ptStockInfo.getBaseUnit().getId().toString());
        sAStockInfo.setBsInvQty((BigDecimal)this.storagetQtyMap.get(ptStockInfo.getId().toString()));
        sAStockInfo.setInvQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getBaseUnit(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), sAStockInfo.getBsInvQty()));
        BigDecimal stockReserve = this.stockReserveMap.get(ptStockInfo.getId().toString()) != null ? (BigDecimal)this.stockReserveMap.get(ptStockInfo.getId().toString()) : SysConstant.BIGZERO;
        BigDecimal stockSimulate = this.stockSimulateMap.get(ptStockInfo.getId().toString()) != null ? (BigDecimal)this.stockSimulateMap.get(ptStockInfo.getId().toString()) : SysConstant.BIGZERO;
        sAStockInfo.setBsStockReserveQty(stockReserve.add(stockSimulate));
        sAStockInfo.setStockReserveQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getBaseUnit(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), sAStockInfo.getBsStockReserveQty()));
        sAStockInfo.setDemandTime(ptStockInfo.getStartDate().toString());
        sAStockInfo.setBsReqQty(ptStockInfo.getBaseQty());
        sAStockInfo.setReqQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getBaseUnit(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), sAStockInfo.getBsReqQty()));
        BigDecimal bsReceiptReqQty = SysConstant.BIGZERO;
        bsReceiptReqQty = this.getSATransactionEnum() == SATransactionEnum.WAREHOUSERESTOCK ? ptStockInfo.getBaseQty().subtract(ptStockInfo.getBaseSendOutTotalQty()).add(ptStockInfo.getBaseUntreadTotalQty()).subtract(ptStockInfo.getBaseTotleReceiveQty()) : ptStockInfo.getBaseQty().subtract(ptStockInfo.getTotalTransferInBaseQty());
        sAStockInfo.setBsReceiptReqQty(bsReceiptReqQty.compareTo(SysConstant.BIGZERO) > 0 ? bsReceiptReqQty : SysConstant.BIGZERO);
        sAStockInfo.setReceiptReqQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getBaseUnit(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), sAStockInfo.getBsReceiptReqQty()));
        BigDecimal bsReceiptQty = this.transferQtyMap.get(ptStockInfo.getId().toString()) != null ? (BigDecimal)this.transferQtyMap.get(ptStockInfo.getId().toString()) : SysConstant.BIGZERO;
        BigDecimal transferBatchBaseQty = (BigDecimal)this.transferBatchMap.get(ptStockInfo.getId().toString());
        sAStockInfo.setBsTransferBatch(transferBatchBaseQty);
        sAStockInfo.setTransferBatch(this.getQtyByKindsUnit(multiMeasureUnitMap, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getBaseUnit(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), sAStockInfo.getBsTransferBatch()));
        sAStockInfo.setBsReceiptQty(this.getTranferBatchQty(bsReceiptQty, transferBatchBaseQty));
        sAStockInfo.setReceiptQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getBaseUnit(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), sAStockInfo.getBsReceiptQty()));
        sAStockInfo.setBsTotalReceiptQty(ptStockInfo.getTotalTransferInBaseQty());
        sAStockInfo.setTotalReceiptQty(this.getQtyByKindsUnit(multiMeasureUnitMap, ptStockInfo.getMaterial().getId().toString(), ptStockInfo.getBaseUnit(), ptStockInfo.getMaterial().getBaseUnit(), ptStockInfo.getUnit(), sAStockInfo.getBsTotalReceiptQty()));
        sAStockInfo.setWarehouseId(ptStockInfo.getDefaultWarehouse() != null ? ptStockInfo.getDefaultWarehouse().getId().toString() : "");
        sAStockInfo.setFromStorageOrgId(ptStockInfo.getMoveOutStorageOrgUnit() != null ? ptStockInfo.getMoveOutStorageOrgUnit().getId().toString() : "");
        sAStockInfo.setFromWarehsId(ptStockInfo.getMoveOutWarehouse() != null ? ptStockInfo.getMoveOutWarehouse().getId().toString() : "");
        if (ptStockInfo.getRemark() != null) {
            if (ptStockInfo.getRemark().length() > 80) {
                sAStockInfo.setRemark(ptStockInfo.getRemark().substring(0, 80));
            } else {
                sAStockInfo.setRemark(ptStockInfo.getRemark());
            }
        } else {
            sAStockInfo.setRemark("");
        }
        resutlMap.put(sAStockInfo.getId(), sAStockInfo);
        this.mapId(resutlMap, ptStockInfo.getId().toString(), sAStockInfo.getId().toString());
        HashMap billRelationMap = new HashMap();
        HashSet<String> entrySet = new HashSet<String>();
        entrySet.add(ptStockInfo.getId().toString());
        billRelationMap.put(ptStockInfo.getParent().getId().toString(), entrySet);
        sAStockInfo.setBillRelationMap(billRelationMap);
    }

    private ProductionOrderStockEntryCollection filterByParamInfo(ProductionOrderStockEntryCollection ptOrderStockCollection) throws BOSException {
        if (this.getCalcParam() == null) {
            return ptOrderStockCollection;
        }
        String materialNumFrom = this.getCalcParam().getMaterialNumFrom();
        String materialNumTo = this.getCalcParam().getMaterialNumTo();
        String dateRequiredFrom = this.getCalcParam().getDateRequiredFrom();
        String dateRequiredTo = this.getCalcParam().getDateRequiredTo();
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        Date dateFrom = null;
        Date dateTo = null;
        try {
            if (dateRequiredFrom != null && dateRequiredFrom.length() > 0) {
                dateFrom = dtformat.parse(dateRequiredFrom);
            }
            if (dateRequiredTo != null && dateRequiredTo.length() > 0) {
                dateTo = dtformat.parse(dateRequiredTo);
            }
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage());
        }
        Set pickingWarehouseNumSet = this.getCalcParam().getPickingWarehouseNum();
        Set exportStorageUnitNumSet = this.getCalcParam().getExportStorageUnitNum();
        Set exportWarehouseNumSet = this.getCalcParam().getExportWarehouseNum();
        String backFlushValue = this.getCalcParam().getBackFlushValue();
        if (ptOrderStockCollection != null && ptOrderStockCollection.size() > 0) {
            for (int i = 0; i < ptOrderStockCollection.size(); ++i) {
                ProductionOrderStockEntryInfo productionOrderStockInfo = ptOrderStockCollection.get(i);
                if (this.getSATransactionEnum() == SATransactionEnum.SPECIFIEDORDER) {
                    BigDecimal receiptQty;
                    BigDecimal bigDecimal = receiptQty = this.getReceiptQtyMap() != null ? (BigDecimal)this.getReceiptQtyMap().get(productionOrderStockInfo.getParent().getId().toString()) : SysConstant.BIGZERO;
                    if (receiptQty.compareTo(SysConstant.BIGZERO) <= 0) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                }
                if (materialNumFrom != null && materialNumFrom.length() > 0 && materialNumTo != null && materialNumTo.length() > 0) {
                    if (productionOrderStockInfo.getMaterial().getNumber().compareTo(materialNumFrom) < 0 || productionOrderStockInfo.getMaterial().getNumber().compareTo(materialNumTo) > 0) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                } else if (materialNumFrom != null && materialNumFrom.length() > 0 && (materialNumTo == null || materialNumTo.length() == 0)) {
                    if (productionOrderStockInfo.getMaterial().getNumber().compareTo(materialNumFrom) < 0) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                } else if (materialNumTo != null && materialNumTo.length() > 0 && (materialNumFrom == null || materialNumFrom.length() == 0) && productionOrderStockInfo.getMaterial().getNumber().compareTo(materialNumTo) > 0) {
                    ptOrderStockCollection.remove(productionOrderStockInfo);
                    --i;
                    continue;
                }
                if (dateRequiredFrom != null && dateRequiredFrom.length() > 0 && dateRequiredTo != null && dateRequiredTo.length() > 0) {
                    if (productionOrderStockInfo.getStartDate().compareTo(dateFrom) < 0 || productionOrderStockInfo.getEndDate().compareTo(dateTo) > 0) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                } else if (dateRequiredFrom != null && dateRequiredFrom.length() > 0 && (dateRequiredTo == null || dateRequiredTo.length() == 0)) {
                    if (productionOrderStockInfo.getStartDate().compareTo(dateFrom) < 0) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                } else if (dateRequiredTo != null && dateRequiredTo.length() > 0 && (dateRequiredFrom == null || dateRequiredFrom.length() == 0) && productionOrderStockInfo.getEndDate().compareTo(dateTo) > 0) {
                    ptOrderStockCollection.remove(productionOrderStockInfo);
                    --i;
                    continue;
                }
                if (pickingWarehouseNumSet != null && pickingWarehouseNumSet.size() > 0 && productionOrderStockInfo.getDefaultWarehouse() != null) {
                    boolean flag = false;
                    for (String pickingWarehouseNum : pickingWarehouseNumSet) {
                        if (!productionOrderStockInfo.getDefaultWarehouse().getNumber().equals(pickingWarehouseNum)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                }
                if (exportStorageUnitNumSet != null && exportStorageUnitNumSet.size() > 0 && productionOrderStockInfo.getMoveOutStorageOrgUnit() != null) {
                    boolean flag = false;
                    for (String exportStorageUnitNum : exportStorageUnitNumSet) {
                        if (!productionOrderStockInfo.getMoveOutStorageOrgUnit().getNumber().equals(exportStorageUnitNum)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                }
                if (exportWarehouseNumSet != null && exportWarehouseNumSet.size() > 0 && productionOrderStockInfo.getMoveOutWarehouse() != null) {
                    boolean flag = false;
                    for (String exportWarehouseNum : exportWarehouseNumSet) {
                        if (!productionOrderStockInfo.getMoveOutWarehouse().getNumber().equals(exportWarehouseNum)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        ptOrderStockCollection.remove(productionOrderStockInfo);
                        --i;
                        continue;
                    }
                }
                if (backFlushValue == null || backFlushValue.length() <= 0) continue;
                if (Integer.parseInt(backFlushValue) == 10) {
                    if (productionOrderStockInfo.isIsBackFlush()) continue;
                    ptOrderStockCollection.remove(productionOrderStockInfo);
                    --i;
                    continue;
                }
                if (Integer.parseInt(backFlushValue) != 20 || !productionOrderStockInfo.isIsBackFlush()) continue;
                ptOrderStockCollection.remove(productionOrderStockInfo);
                --i;
            }
        }
        return ptOrderStockCollection;
    }

    private Map groupStockByMeterial(ProductionOrderStockEntryCollection sortedStockCollection) throws EASBizException, BOSException {
        HashMap stockGroupMap = new HashMap();
        if (sortedStockCollection != null && sortedStockCollection.size() > 0) {
            for (int i = 0; i < sortedStockCollection.size(); ++i) {
                List<ProductionOrderStockEntryInfo> stockList;
                ProductionOrderStockEntryInfo ptStockInfo = sortedStockCollection.get(i);
                String materialKey = ptStockInfo.getMaterial().getId().toString();
                String warehouseKey = null;
                String exportStorageUnitKey = null;
                String exportWarehouseKey = null;
                String trackNumberKey = this.getMStragyTrackNumber(ptStockInfo, materialKey);
                warehouseKey = ptStockInfo.getDefaultWarehouse() == null ? "wnull" : ptStockInfo.getDefaultWarehouse().getId().toString();
                exportStorageUnitKey = ptStockInfo.getMoveOutStorageOrgUnit() == null ? "esnull" : ptStockInfo.getMoveOutStorageOrgUnit().getId().toString();
                exportWarehouseKey = ptStockInfo.getMoveOutWarehouse() == null ? "ewnull" : ptStockInfo.getMoveOutWarehouse().getId().toString();
                if ("".equals(trackNumberKey)) {
                    trackNumberKey = "tnnull";
                }
                if (!stockGroupMap.containsKey(materialKey + warehouseKey + exportStorageUnitKey + exportWarehouseKey + trackNumberKey)) {
                    stockList = new ArrayList<ProductionOrderStockEntryInfo>();
                    stockList.add(ptStockInfo);
                    stockGroupMap.put(materialKey + warehouseKey + exportStorageUnitKey + exportWarehouseKey + trackNumberKey, stockList);
                    continue;
                }
                stockList = (List)stockGroupMap.get(materialKey + warehouseKey + exportStorageUnitKey + exportWarehouseKey + trackNumberKey);
                stockList.add(ptStockInfo);
            }
        }
        return stockGroupMap;
    }

    @Override
    protected Map PrepareDestBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Map sAStockMap;
        Map resultMap = super.PrepareDestBill(ctx, paramMap);
        TransferOrderBillCollection transferOrderBillCollection = new TransferOrderBillCollection();
        StockTransferBillCollection stockTransferBillCollection = new StockTransferBillCollection();
        BOTRelationCollection botRelationCollection = new BOTRelationCollection();
        BOTRelationEntryCollection botRelationEntryCollection = new BOTRelationEntryCollection();
        SAGroupEnum groupEnum = (SAGroupEnum)((Object)paramMap.get("SAGroupEnum"));
        this.sAStockMap = sAStockMap = (Map)paramMap.get("SAStockMap");
        ProductionOrderStockEntryCollection ptStockCollection = (ProductionOrderStockEntryCollection)((Object)sAStockMap.get("ptStockCollection"));
        Map groupMap = this.group(ptStockCollection, groupEnum);
        resultMap = this.assembleBillCollection(groupMap, groupEnum, transferOrderBillCollection, stockTransferBillCollection, botRelationCollection, botRelationEntryCollection);
        resultMap.put("transferOrderBillCollection", transferOrderBillCollection);
        resultMap.put("stockTransferBillCollection", stockTransferBillCollection);
        resultMap.put("botRelationCollection", botRelationCollection);
        resultMap.put("botRelationEntryCollection", botRelationEntryCollection);
        resultMap.put("isBuild", new Boolean(false));
        return resultMap;
    }

    private Map group(ProductionOrderStockEntryCollection ptStockCollection, SAGroupEnum groupEnum) {
        HashMap stockGroupMap;
        block6: {
            block8: {
                block7: {
                    stockGroupMap = new HashMap();
                    if (ptStockCollection == null) break block6;
                    if (groupEnum != SAGroupEnum.NOGROUP) break block7;
                    for (int i = 0; i < ptStockCollection.size(); ++i) {
                        ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                        if (this.fromptPTStockInfoToSAStockInfo(ptStockInfo) == null) continue;
                        ArrayList<ProductionOrderStockEntryInfo> stockList = new ArrayList<ProductionOrderStockEntryInfo>();
                        stockList.add(ptStockInfo);
                        stockGroupMap.put(ptStockInfo.getId().toString(), stockList);
                    }
                    break block6;
                }
                if (groupEnum != SAGroupEnum.OUTSTORAGEWAREHOUSE) break block8;
                if (ptStockCollection == null || ptStockCollection.size() <= 0) break block6;
                for (int i = 0; i < ptStockCollection.size(); ++i) {
                    List<ProductionOrderStockEntryInfo> stockList;
                    ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                    if (this.fromptPTStockInfoToSAStockInfo(ptStockInfo) == null) continue;
                    String exportStorageId = null;
                    String exportWarehouseId = null;
                    exportStorageId = ptStockInfo.getMoveOutStorageOrgUnit() != null ? ptStockInfo.getMoveOutStorageOrgUnit().getId().toString() : "esnull";
                    exportStorageId = ptStockInfo.getMoveOutWarehouse() != null ? ptStockInfo.getMoveOutWarehouse().getId().toString() : "ewnull";
                    if (!stockGroupMap.containsKey(exportStorageId + exportWarehouseId)) {
                        stockList = new ArrayList<ProductionOrderStockEntryInfo>();
                        stockList.add(ptStockInfo);
                        stockGroupMap.put(exportStorageId + exportWarehouseId, stockList);
                        continue;
                    }
                    stockList = (List)stockGroupMap.get(exportStorageId + exportWarehouseId);
                    stockList.add(ptStockInfo);
                }
                break block6;
            }
            if (groupEnum == SAGroupEnum.OUTSTORAGE && ptStockCollection != null && ptStockCollection.size() > 0) {
                for (int i = 0; i < ptStockCollection.size(); ++i) {
                    List<ProductionOrderStockEntryInfo> stockList;
                    ProductionOrderStockEntryInfo ptStockInfo = ptStockCollection.get(i);
                    if (this.fromptPTStockInfoToSAStockInfo(ptStockInfo) == null) continue;
                    String exportStorageId = null;
                    exportStorageId = ptStockInfo.getMoveOutStorageOrgUnit() != null ? ptStockInfo.getMoveOutStorageOrgUnit().getId().toString() : "esnull";
                    if (!stockGroupMap.containsKey(exportStorageId)) {
                        stockList = new ArrayList<ProductionOrderStockEntryInfo>();
                        stockList.add(ptStockInfo);
                        stockGroupMap.put(exportStorageId, stockList);
                        continue;
                    }
                    stockList = (List)stockGroupMap.get(exportStorageId);
                    stockList.add(ptStockInfo);
                }
            }
        }
        return stockGroupMap;
    }

    private Map assembleBillCollection(Map groupMap, SAGroupEnum groupEnum, TransferOrderBillCollection transferOrderBillCollection, StockTransferBillCollection stockTransferBillCollection, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection) throws EASBizException, BOSException {
        HashMap resultMap = new HashMap();
        Set keySet = groupMap.keySet();
        if (keySet != null && keySet.size() > 0) {
            for (String key : keySet) {
                List stockList = (List)groupMap.get(key);
                TransferOrderBillInfo transferOrderBillInfo = new TransferOrderBillInfo();
                StockTransferBillInfo stockTransferBillInfo = new StockTransferBillInfo();
                this.assembleBillInfo(stockList, groupEnum, transferOrderBillInfo, stockTransferBillInfo, botRelationCollection, botRelationEntryCollection);
                if (transferOrderBillInfo != null && transferOrderBillInfo.getEntry() != null && transferOrderBillInfo.getEntry().size() > 0) {
                    transferOrderBillCollection.add(transferOrderBillInfo);
                }
                if (stockTransferBillInfo == null || stockTransferBillInfo.getEntry() == null || stockTransferBillInfo.getEntry().size() <= 0) continue;
                stockTransferBillCollection.add(stockTransferBillInfo);
            }
        }
        return resultMap;
    }

    private void assembleBillInfo(List stockList, SAGroupEnum groupEnum, TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection) throws BOSException, EASBizException {
        if (groupEnum == SAGroupEnum.NOGROUP) {
            ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)stockList.get(0);
            if (this.fromptPTStockInfoToSAStockInfo(ptStockInfo) == null) {
                return;
            }
            this.assembleDetail(ptStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
            this.convertBOTP(transferOrderBillInfo, stockTransferBillInfo, botRelationCollection, botRelationEntryCollection, ptStockInfo);
        } else if (groupEnum == SAGroupEnum.OUTSTORAGEWAREHOUSE || groupEnum == SAGroupEnum.OUTSTORAGE) {
            for (int i = 0; i < stockList.size(); ++i) {
                ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)stockList.get(i);
                if (this.fromptPTStockInfoToSAStockInfo(ptStockInfo) == null) continue;
                if (i == 0) {
                    this.assembleDetail(ptStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
                    continue;
                }
                TransactionTypeEnum orderTransEnum = ptStockInfo.getTransactionType();
                if (orderTransEnum == TransactionTypeEnum.CROSSWAREHOUSETRANSFER || orderTransEnum == TransactionTypeEnum.CROSSSTORAGETRANSFER) {
                    if (stockTransferBillInfo.getId() != null) {
                        this.assembleDetail(ptStockInfo, transferOrderBillInfo, stockTransferBillInfo, false);
                        continue;
                    }
                    this.assembleDetail(ptStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
                    continue;
                }
                if (orderTransEnum != TransactionTypeEnum.CROSSFUNDTRANSFER) continue;
                if (transferOrderBillInfo.getId() != null) {
                    this.assembleDetail(ptStockInfo, transferOrderBillInfo, stockTransferBillInfo, false);
                    continue;
                }
                this.assembleDetail(ptStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
            }
            this.convertBOTP(transferOrderBillInfo, stockTransferBillInfo, botRelationCollection, botRelationEntryCollection, stockList);
        }
    }

    private void assembleDetail(ProductionOrderStockEntryInfo ptStockInfo, TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, boolean flag) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.getContext());
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.getContext());
        Timestamp bizDate = iSCMBillCommonFacade.getServerDate();
        StorageOrgUnitInfo exportStorageInfo = ptStockInfo.getMoveOutStorageOrgUnit();
        CompanyOrgUnitInfo companyOriUnitInfo = null;
        if (exportStorageInfo != null) {
            companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(exportStorageInfo.getId());
        }
        StorageOrgUnitInfo inStorageOrgUnitInfo = this.getStorageOrgUnitInfo();
        CompanyOrgUnitInfo inCompanyOriUnitInfo = null;
        if (inStorageOrgUnitInfo != null) {
            inCompanyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(inStorageOrgUnitInfo.getId());
        }
        TransactionTypeEnum orderTransEnum = ptStockInfo.getTransactionType();
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"ejIZHXXTQliYCQJg9t4Re0Y+1VI="));
        if (orderTransEnum == TransactionTypeEnum.CROSSSTORAGETRANSFER || orderTransEnum == TransactionTypeEnum.CROSSWAREHOUSETRANSFER) {
            if (flag) {
                stockTransferBillInfo.setId(BOSUuid.create((BOSObjectType)stockTransferBillInfo.getBOSType()));
                this.setStockBizType(stockTransferBillInfo, ptStockInfo);
                stockTransferBillInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)stockTransferBillInfo, this.getStorageOrgUnitInfo().getId().toString()));
                stockTransferBillInfo.setBizDate((Date)bizDate);
                stockTransferBillInfo.setIssueCompanyOrgUnit(companyOriUnitInfo);
                stockTransferBillInfo.setIssueStorageOrgUnit(exportStorageInfo);
                stockTransferBillInfo.setReceiptCompanyOrgUnit(inCompanyOriUnitInfo);
                stockTransferBillInfo.setReceiptStorageOrgUnit(inStorageOrgUnitInfo);
                stockTransferBillInfo.setReceiptAdminOrgUnit(ptStockInfo.getParent() != null ? ptStockInfo.getParent().getWorkShop() : null);
                stockTransferBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                stockTransferBillInfo.setSourceBillType(billTypeInfo);
            }
            StockTransferBillEntryInfo entryInfo = new StockTransferBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setMaterial(ptStockInfo.getMaterial());
            Map idMap = (Map)this.sAStockMap.get("idMap");
            String stId = (String)idMap.get(ptStockInfo.getId().toString());
            SAStockInfo saStockInfo = (SAStockInfo)this.sAStockMap.get(stId);
            BigDecimal qty = saStockInfo.getReceiptQty();
            entryInfo.setBaseUnit(ptStockInfo.getMaterial().getBaseUnit());
            entryInfo.setQty(qty);
            BigDecimal baseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)ptStockInfo.getUnit(), (MeasureUnitInfo)ptStockInfo.getMaterial().getBaseUnit(), (BigDecimal)qty);
            entryInfo.setBaseQty(baseQty);
            entryInfo.setUnit(ptStockInfo.getUnit());
            MaterialInventoryInfo inventory = MaterialInventoryFactory.getLocalInstance((Context)this.getContext()).getInventoryInfo(ptStockInfo.getMaterial().getId().toString(), this.getStorageOrgUnitInfo().getId().toString());
            if (inventory.isIsLotNumber()) {
                entryInfo.setLot(ptStockInfo.getLotNo());
            }
            entryInfo.setAssistUnit(ptStockInfo.getMaterial().getAssistUnit());
            BigDecimal assistQty = SysConstant.BIGZERO;
            if (ptStockInfo.getMaterial().getAssistUnit() != null && (assistQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)ptStockInfo.getMaterial().getAssistUnit(), (MeasureUnitInfo)ptStockInfo.getMaterial().getBaseUnit(), (BigDecimal)baseQty)) == SysConstant.BIGZERO) {
                assistQty = baseQty;
            }
            entryInfo.setAssistQty(assistQty);
            entryInfo.setIssuePlanDate(ptStockInfo.getStartDate());
            entryInfo.setReceiptPlanDate(ptStockInfo.getStartDate());
            entryInfo.setIssueWarehouse(ptStockInfo.getMoveOutWarehouse());
            entryInfo.setReceiptWarehouse(ptStockInfo.getDefaultWarehouse());
            String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, ptStockInfo.getMaterial().getId().toString());
            if (!"".equals(trackNumberId)) {
                ObjectUuidPK trackNumberPK = new ObjectUuidPK(trackNumberId);
                TrackNumberInfo trackNumber = TrackNumberFactory.getLocalInstance((Context)this.getContext()).getTrackNumberInfo((IObjectPK)trackNumberPK);
                entryInfo.setTrackNumber(trackNumber);
            } else {
                entryInfo.setTrackNumber(null);
            }
            entryInfo.setProject(null);
            entryInfo.setSourceBillType(billTypeInfo);
            this.setStockStoreType(entryInfo);
            this.setStoreState2(entryInfo);
            entryInfo.setRemark(saStockInfo.getRemark());
            stockTransferBillInfo.getEntry().add(entryInfo);
            entryInfo.setParent(stockTransferBillInfo);
            String[] ids = new String[]{stockTransferBillInfo.getId().toString(), entryInfo.getId().toString()};
            this.stIdDestEntryIdMap.put(stId, ids);
        } else if (orderTransEnum == TransactionTypeEnum.CROSSFUNDTRANSFER) {
            if (flag) {
                transferOrderBillInfo.setId(BOSUuid.create((BOSObjectType)transferOrderBillInfo.getBOSType()));
                this.setTransferBizType(transferOrderBillInfo);
                transferOrderBillInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)transferOrderBillInfo, this.getStorageOrgUnitInfo().getId().toString()));
                transferOrderBillInfo.setBizDate((Date)bizDate);
                transferOrderBillInfo.setIssueCompanyOrgUnit(companyOriUnitInfo);
                transferOrderBillInfo.setReceiptCompanyOrgUnit(inCompanyOriUnitInfo);
                transferOrderBillInfo.setIssueStorageOrgUnit(exportStorageInfo);
                transferOrderBillInfo.setReceiptStorageOrgUnit(inStorageOrgUnitInfo);
                transferOrderBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                transferOrderBillInfo.setSourceBillType(billTypeInfo);
            }
            TransferOrderBillEntryInfo entryInfo = new TransferOrderBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setMaterial(ptStockInfo.getMaterial());
            Map idMap = (Map)this.sAStockMap.get("idMap");
            String stId = (String)idMap.get(ptStockInfo.getId().toString());
            SAStockInfo saStockInfo = (SAStockInfo)this.sAStockMap.get(stId);
            BigDecimal qty = saStockInfo.getReceiptQty();
            entryInfo.setBaseUnit(ptStockInfo.getMaterial().getBaseUnit());
            entryInfo.setQty(qty);
            BigDecimal baseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)ptStockInfo.getUnit(), (MeasureUnitInfo)ptStockInfo.getMaterial().getBaseUnit(), (BigDecimal)qty);
            entryInfo.setBaseQty(baseQty);
            entryInfo.setUnit(ptStockInfo.getUnit());
            entryInfo.setAssistUnit(ptStockInfo.getMaterial().getAssistUnit());
            BigDecimal assistQty = SysConstant.BIGZERO;
            if (ptStockInfo.getMaterial().getAssistUnit() != null && (assistQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.getContext(), (String)ptStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)ptStockInfo.getMaterial().getAssistUnit(), (MeasureUnitInfo)ptStockInfo.getMaterial().getBaseUnit(), (BigDecimal)baseQty)) == SysConstant.BIGZERO) {
                assistQty = baseQty;
            }
            entryInfo.setAssistQty(assistQty);
            entryInfo.setIssueWarehouse(ptStockInfo.getMoveOutWarehouse());
            entryInfo.setReceiptWarehouse(ptStockInfo.getDefaultWarehouse());
            entryInfo.setIssueStorageOrgUnit(exportStorageInfo);
            entryInfo.setReceiveStorageOrgUnit(inStorageOrgUnitInfo);
            entryInfo.setIssuePlanDate(ptStockInfo.getStartDate());
            entryInfo.setReceiptPlanDate(ptStockInfo.getStartDate());
            String trackNumberId = this.getMStragyTrackNumber(ptStockInfo, ptStockInfo.getMaterial().getId().toString());
            if (!"".equals(trackNumberId)) {
                ObjectUuidPK trackNumberPK = new ObjectUuidPK(trackNumberId);
                TrackNumberInfo trackNumber = TrackNumberFactory.getLocalInstance((Context)this.getContext()).getTrackNumberInfo((IObjectPK)trackNumberPK);
                entryInfo.setTrackNumber(trackNumber);
            } else {
                entryInfo.setTrackNumber(null);
            }
            entryInfo.setProject(null);
            entryInfo.setSourceBillType(billTypeInfo);
            entryInfo.setRemark(saStockInfo.getRemark());
            transferOrderBillInfo.getEntry().add(entryInfo);
            entryInfo.setParent(transferOrderBillInfo);
            String[] ids = new String[]{transferOrderBillInfo.getId().toString(), entryInfo.getId().toString()};
            this.stIdDestEntryIdMap.put(stId, ids);
        }
    }

    private void setStockBizType(StockTransferBillInfo stockTransferBillInfo, ProductionOrderStockEntryInfo ptStockInfo) throws EASBizException, BOSException {
        BizTypeInfo bizTypeInfo = null;
        bizTypeInfo = ptStockInfo.getTransactionType() == TransactionTypeEnum.CROSSSTORAGETRANSFER ? this.getBizTypeInfoById("d8e80652-011a-1000-e000-04c5c0a812202407435C") : this.getBizTypeInfoById("d8e80652-011b-1000-e000-04c5c0a812202407435C");
        stockTransferBillInfo.setBizType(bizTypeInfo);
    }

    private void setStockStoreType(StockTransferBillEntryInfo entryInfo) {
        StoreTypeInfo storeTypeInfo = new StoreTypeInfo();
        storeTypeInfo.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
        entryInfo.setStoreType(storeTypeInfo);
    }

    private void setStoreState2(StockTransferBillEntryInfo entryInfo) {
        StoreStateInfo storeStateInfo = new StoreStateInfo();
        storeStateInfo.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
        entryInfo.setStoreState(storeStateInfo);
    }

    private void setTransferBizType(TransferOrderBillInfo transferOrderBillInfo) throws BOSException, EASBizException, UuidException {
        BizTypeInfo bizTypeInfo = this.getBizTypeInfoById("d8e80652-0117-1000-e000-04c5c0a812202407435C");
        transferOrderBillInfo.setBizType(bizTypeInfo);
    }

    private void convertBOTP(TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection, ProductionOrderStockEntryInfo ptStockInfo) throws BOSException {
        Map idMap = (Map)this.sAStockMap.get("idMap");
        String stId = (String)idMap.get(ptStockInfo.getId().toString());
        SAStockInfo saStockInfo = (SAStockInfo)this.sAStockMap.get(stId);
        if (this.fromptPTStockInfoToSAStockInfo(ptStockInfo) == null) {
            return;
        }
        Map billRelationMap = saStockInfo.getBillRelationMap();
        Set mapEntrySet = billRelationMap.entrySet();
        for (Map.Entry mapEntry : mapEntrySet) {
            String orderId = (String)mapEntry.getKey();
            BOTRelationInfo botRelationInfo = new BOTRelationInfo();
            botRelationInfo.setId(BOSUuid.create((BOSObjectType)botRelationInfo.getBOSType()));
            botRelationInfo.setSrcEntityID("1F66774E");
            botRelationInfo.setSrcObjectID(orderId);
            if (transferOrderBillInfo != null && transferOrderBillInfo.getEntry() != null && transferOrderBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID("5C2A1F0C");
                botRelationInfo.setDestObjectID(transferOrderBillInfo.getId().toString());
            } else if (stockTransferBillInfo != null && stockTransferBillInfo.getEntry() != null && stockTransferBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID("2239F30A");
                botRelationInfo.setDestObjectID(stockTransferBillInfo.getId().toString());
            }
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.getContext());
            Timestamp currentDate = iSCMBillCommonFacade.getServerDate();
            botRelationInfo.setDate((Date)currentDate);
            botRelationInfo.setOperatorID(this.getContext().getCaller().toString());
            botRelationInfo.setIsEffected(true);
            botRelationInfo.setType(0);
            botRelationCollection.add(botRelationInfo);
            Set stockIdSet = (Set)mapEntry.getValue();
            for (String stockId : stockIdSet) {
                String[] destObjectEntryId = (String[])this.stIdDestEntryIdMap.get(stId);
                BOTRelationEntryInfo botRelationEntryInfo = new BOTRelationEntryInfo();
                botRelationEntryInfo.setId(BOSUuid.create((BOSObjectType)botRelationEntryInfo.getBOSType()));
                botRelationEntryInfo.setSrcEntryID(stockId);
                botRelationEntryInfo.setSrcObjectID(orderId);
                botRelationEntryInfo.setDestObjectID(destObjectEntryId[0]);
                botRelationEntryInfo.setDestEntryID(destObjectEntryId[1]);
                botRelationEntryInfo.setSrcEntryPropName("__src.stockEntry");
                botRelationEntryInfo.setDestEntryPropName("__dest.entry");
                botRelationEntryInfo.setDestPropertyName("id");
                botRelationInfo.getRelationEntries().add(botRelationEntryInfo);
                botRelationEntryInfo.setRelation(botRelationInfo);
            }
        }
    }

    private void convertBOTP(TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection, List stockList) throws BOSException {
        Map idMap = (Map)this.sAStockMap.get("idMap");
        HashSet<String> orderIdSet = new HashSet<String>();
        for (int i = 0; i < stockList.size(); ++i) {
            ProductionOrderStockEntryInfo ptStockInfo = (ProductionOrderStockEntryInfo)stockList.get(i);
            String stId = (String)idMap.get(ptStockInfo.getId().toString());
            SAStockInfo saStockInfo = (SAStockInfo)this.sAStockMap.get(stId);
            Map idRelationMap = saStockInfo.getBillRelationMap();
            Set orderSet = idRelationMap.keySet();
            for (String orderId : orderSet) {
                orderIdSet.add(orderId);
                Set stockSet = (Set)idRelationMap.get(orderId);
                for (String stockId : stockSet) {
                    String[] destObjectEntryId = (String[])this.stIdDestEntryIdMap.get(stId);
                    BOTRelationEntryInfo botRelationEntryInfo = new BOTRelationEntryInfo();
                    botRelationEntryInfo.setId(BOSUuid.create((BOSObjectType)botRelationEntryInfo.getBOSType()));
                    botRelationEntryInfo.setSrcEntryID(stockId);
                    botRelationEntryInfo.setSrcObjectID(orderId);
                    botRelationEntryInfo.setDestObjectID(destObjectEntryId[0]);
                    botRelationEntryInfo.setDestEntryID(destObjectEntryId[1]);
                    botRelationEntryInfo.setSrcEntryPropName("__src.entries");
                    botRelationEntryInfo.setDestEntryPropName("__dest.entries");
                    botRelationEntryInfo.setDestPropertyName("id");
                    botRelationEntryCollection.add(botRelationEntryInfo);
                }
            }
        }
        for (String orderId : orderIdSet) {
            BOTRelationInfo botRelationInfo = new BOTRelationInfo();
            botRelationInfo.setId(BOSUuid.create((BOSObjectType)botRelationInfo.getBOSType()));
            botRelationInfo.setSrcEntityID("1F66774E");
            botRelationInfo.setSrcObjectID(orderId);
            if (transferOrderBillInfo != null && transferOrderBillInfo.getEntry() != null && transferOrderBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID("5C2A1F0C");
                botRelationInfo.setDestObjectID(transferOrderBillInfo.getId().toString());
            } else if (stockTransferBillInfo != null && stockTransferBillInfo.getEntry() != null && stockTransferBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID("2239F30A");
                botRelationInfo.setDestObjectID(stockTransferBillInfo.getId().toString());
            }
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.getContext());
            Timestamp currentDate = iSCMBillCommonFacade.getServerDate();
            botRelationInfo.setDate((Date)currentDate);
            botRelationInfo.setOperatorID(this.getContext().getCaller().toString());
            botRelationInfo.setIsEffected(true);
            botRelationInfo.setType(0);
            botRelationCollection.add(botRelationInfo);
        }
    }

    private SAStockInfo fromptPTStockInfoToSAStockInfo(ProductionOrderStockEntryInfo ptStockInfo) {
        Map idMap = (Map)this.sAStockMap.get("idMap");
        String stId = (String)idMap.get(ptStockInfo.getId().toString());
        SAStockInfo saStockInfo = (SAStockInfo)this.sAStockMap.get(stId);
        return saStockInfo;
    }

    @Override
    protected Map GetStockDataPrecision(Context ctx, ProductionOrderCollection poOrderCollection) throws BOSException, EASBizException, SQLException {
        Map resultMap = super.GetStockDataPrecision(ctx, poOrderCollection);
        this.setPrecisionMap(ctx, poOrderCollection);
        resultMap = this.getPrecisionMap();
        return resultMap;
    }

    private String getMStragyTrackNumber(ProductionOrderStockEntryInfo ptStockInfo, String materialId) throws EASBizException, BOSException {
        String strategyId;
        String trackNumberId = "";
        ManufactureStrategyInfo manufactureStrategyInfo = null;
        manufactureStrategyInfo = this.getStorageOrgUnitInfo() != null ? ProductionStrategyHelper.getManufactureStrategy((Context)this.getContext(), (String)materialId, (String)this.getStorageOrgUnitInfo().getId().toString()) : ProductionStrategyHelper.getManufactureStrategy((Context)this.getContext(), (String)materialId, (String)this.getStorageUnitId());
        if (manufactureStrategyInfo != null && ((strategyId = manufactureStrategyInfo.getId().toString()).equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU="))) {
            if (ptStockInfo.getParent() == null) {
                SAStockInfo saStockInfo = this.fromptPTStockInfoToSAStockInfo(ptStockInfo);
                trackNumberId = saStockInfo.getTrackNumberId();
            } else if (ptStockInfo.getParent().getTrackNumber() != null) {
                trackNumberId = ptStockInfo.getParent().getTrackNumber().getId().toString();
            }
        }
        return trackNumberId;
    }

    private BigDecimal getQtyByKindsUnit(Map multiMeasureUnitMap, String materialID, MeasureUnitInfo unitInfo_first, MeasureUnitInfo unitInfo_second, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws EASBizException, BOSException {
        BigDecimal resultQty = SysConstant.BIGZERO;
        if (unitInfo_first != null) {
            resultQty = this.getExchangePrecisionQty(multiMeasureUnitMap, materialID, unitInfo_first, otherUnitInfo, qty);
        } else if (unitInfo_second != null) {
            resultQty = this.getExchangePrecisionQty(multiMeasureUnitMap, materialID, unitInfo_second, otherUnitInfo, qty);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(materialID);
            MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)this.getContext()).getMaterialInfo((IObjectPK)pk);
            resultQty = this.getExchangePrecisionQty(multiMeasureUnitMap, materialID, materialInfo.getBaseUnit(), otherUnitInfo, qty);
        }
        return resultQty;
    }
}

