/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.ParameterUtil;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.PickingSlipBillInfo;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.control.TaskDispBillCompleteException;
import com.kingdee.eas.mm.control.TaskDispBillGenerateException;
import com.kingdee.eas.mm.control.TaskDispBillInfo;
import com.kingdee.eas.mm.control.TaskDispBillUnAuditException;
import com.kingdee.eas.mm.control.app.AbstractTaskDispBillControllerBean;
import com.kingdee.eas.mm.control.app.TaskDispLotServerUtils;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaskDispBillControllerBean
extends AbstractTaskDispBillControllerBean {
    private static final long serialVersionUID = 5421465836898876106L;
    private IParamControl iParamControl = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.TaskDispBillControllerBean");
    public static final String RES_TASKDISP = "com.kingdee.eas.mm.control.TaskDispBillResource";

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        TaskDispBillInfo billInfo = new TaskDispBillInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        billInfo.setBizDate(curDate);
        billInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        return billInfo;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkEmpty(ctx, model);
        this.validateStartEndDate(ctx, model);
        boolean flag = false;
        TaskDispBillInfo billInfo = (TaskDispBillInfo)model;
        String orgUnitID = billInfo.getStorageOrgUnit().getId().toString();
        if (billInfo.getBillType() != null) {
            String billTypeId = billInfo.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeId);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                flag = true;
            }
        }
        if (flag) {
            super._submit(ctx, model);
            ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
            ObjectUuidPK[] pks = new ObjectUuidPK[]{pk};
            this._auditForTaskDispBill(ctx, (IObjectPK[])pks);
            return pk;
        }
        return super._submit(ctx, model);
    }

    protected void verifyInput(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _manuRecBillWriteBackStockTotalQty(Context ctx, String strMenuRecBillIds, BizActionEnum bizActionEnum) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" update T_MM_TaskDispBill a set a.fstocktotalqty = ");
        sqlBuffer.append(" (select a.fstocktotalqty ");
        if (bizActionEnum.getValue() == 103) {
            sqlBuffer.append(" + ");
        } else if (bizActionEnum.getValue() == 109) {
            sqlBuffer.append(" - ");
        }
        sqlBuffer.append(" b.fqty ");
        sqlBuffer.append("from T_IM_ManufactureRecBillEntry b ");
        sqlBuffer.append(" where a.fid = b.fsourcebillid and b.fsourcebillid in (");
        sqlBuffer.append(strMenuRecBillIds);
        sqlBuffer.append(")),");
        sqlBuffer.append(" a.fbaseissuedtotalqty= ");
        sqlBuffer.append(" (select a.fbaseissuedtotalqty ");
        if (bizActionEnum.getValue() == 103) {
            sqlBuffer.append(" + ");
        } else if (bizActionEnum.getValue() == 109) {
            sqlBuffer.append(" - ");
        }
        sqlBuffer.append(" b.fbaseqty ");
        sqlBuffer.append(" from   T_IM_ManufactureRecBillEntry b ");
        sqlBuffer.append(" where   a.fid = b.fsourcebillid and b.fsourcebillid in (");
        sqlBuffer.append(strMenuRecBillIds);
        sqlBuffer.append("))");
        sqlBuffer.append("WHERE EXISTS(SELECT 1 FROM T_IM_ManufactureRecBillEntry b WHERE a.fid = b.fsourcebillid ");
        sqlBuffer.append(" and b.fsourcebillid in (");
        sqlBuffer.append(strMenuRecBillIds);
        sqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private String getGenPickingBillIds(Context ctx, IObjectPK[] pks, boolean forAutoGen) throws BOSException, TaskDispBillGenerateException, EASBizException {
        String id;
        String strIdLists = StringUtils.arrayToString((Object[])pks, (String)"','");
        ArrayList<String> strIds = new ArrayList<String>(Arrays.asList(strIdLists.split("','")));
        StringBuffer error = new StringBuffer();
        String sql_statusCheck = "select fid, fnumber,fStorageOrgUnitID, fbasestatus,fIsManualFinish from t_mm_taskdispbill where fid in ('" + strIdLists + "')";
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck);
        ParamUtil paramUtil = new ParamUtil(ctx);
        String autoGen = null;
        String enabledPick = null;
        try {
            while (rowStatus.next()) {
                int status = rowStatus.getInt("fbasestatus");
                int isManualFinish = rowStatus.getInt("fIsManualFinish");
                id = rowStatus.getString("fid");
                String fStorageOrgUnitID = rowStatus.getString("fStorageOrgUnitID");
                if (status != 4 && (status != 8 || isManualFinish != 0)) {
                    error.append("," + rowStatus.getString("fnumber"));
                    strIds.remove(id);
                }
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                autoGen = paramUtil.getAutoGenPickBillParam("false");
                enabledPick = paramUtil.getEnabledPickBillParam("true");
                if ("true".equals(enabledPick) && "true".equals(autoGen)) continue;
                strIds.remove(id);
            }
            if (!forAutoGen && error.length() > 0) {
                throw new TaskDispBillGenerateException(TaskDispBillGenerateException.NOAUDIT, new Object[]{error.substring(1)});
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String selectSql = "select P.Fnumber,t.FSRCOBJECTID from  t_bot_relation t ,t_mm_taskdispbill P where t.FSRCOBJECTID=P.FID and  t.FdestEntityID= 'A06DF1E1' AND t.FSRCOBJECTID in ('" + strIdLists + "')";
        IRowSet rowS = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            if (!forAutoGen && rowS.next()) {
                throw new TaskDispBillGenerateException(TaskDispBillGenerateException.YETGENERATEPICK, new Object[]{rowS.getString("fnumber")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            while (rowS.next()) {
                id = rowS.getString("FSRCOBJECTID");
                strIds.remove(id);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer stockError = new StringBuffer();
        if (null != pks) {
            for (int i = 0; i < pks.length; ++i) {
                StringBuffer sqlStock = new StringBuffer();
                sqlStock.append(" select count(*) snum , a.fid ,a.fnumber ,s.FIsBackFlush  ");
                sqlStock.append(" from t_mm_taskdispbill a inner  join t_mm_productionorder b on a.fproductionorderid = b.fid ");
                sqlStock.append(" left outer join (select fparentid,FIsBackFlush,FQty,FIssMode from t_mm_productionordersentry where FIsBackFlush = 0 and FQty <> 0 and FIssMode = 11010 ) s ");
                sqlStock.append(" on b.fid =s.fparentid where a.FID = ?  group by  a.fid,a.fnumber ,s.FIsBackFlush ");
                IRowSet row1 = DbUtil.executeQuery((Context)ctx, (String)sqlStock.toString(), (Object[])new Object[]{pks[i].toString()});
                if (null == row1) continue;
                try {
                    while (row1.next()) {
                        if (row1.getInt("snum") > 1 || row1.getString("FIsBackFlush") != null) continue;
                        String id2 = row1.getString("fid");
                        String number = row1.getString("fnumber");
                        stockError.append(number).append(",");
                        strIds.remove(id2);
                    }
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (!forAutoGen && null != stockError && stockError.length() > 0) {
            throw new TaskDispBillGenerateException(TaskDispBillGenerateException.CANNOT_GENERATEPICK, new Object[]{stockError.substring(0, stockError.lastIndexOf(","))});
        }
        if (!forAutoGen) {
            return strIdLists;
        }
        if (strIds.size() > 0) {
            return StringUtils.arrayToString((Object[])strIds.toArray(), (String)"','");
        }
        return null;
    }

    private void genPickingSlipBill(Context ctx, String strIdLists, boolean forAutoGen) throws BOSException, EASBizException {
        StringBuffer sqlBufFirst = new StringBuffer();
        String creatorID = ctx.getCaller().toString();
        sqlBufFirst.append("Insert into T_MM_PickingSlipBill(FID,FStorageOrgUnitID,FMaterialID,FUnitID,FReqSuite,FBaseReqSuite,FSourceBillID,FSourceBillTypeID,FBillTypeId,FPRODUCTIONORDERID,FTaskDispID,FSaleOrderID,FWorkshopID,FControlUnitId,FProductLineID,FShiftID,FCLASSGROUPID,FTRACENO,FTrackNumberID,FBaseStatus,FBizDate,FCreateTime,FCreatorID,FLastUpdateTime,FLastUpdateUserID,Fdescription,FMmBizType,FIsSupplement )select newbosid('A06DF1E1'),r2.FStorageOrgUnitID,r2.FMaterialID,r2.FUnitID,r2.FProductQty,r2.FBaseProductQty,r2.FID,'Tgx4hbjrTRCki6pl2V5aLkY+1VI=','3fY8szOQTQmfaNi+Tm5SJUY+1VI=',r2.FSOURCEBILLID,r2.FID,r2.FSaleOrderID,r2.FWorkshopID,r2.FControlUnitId,r2.FProductLineID,r2.FShiftID,r2.FCLASSGROUPID,r2.FTRACENO,r2.FTrackNumberID,1,GETDATE(),GETDATE(),'" + creatorID + "',GETDATE(),'" + creatorID + "',r2.FRemark,r2.FBusinessType,0from t_mm_taskdispbill r2 where r2.fid  ");
        sqlBufFirst.append(" in( '");
        sqlBufFirst.append(strIdLists);
        sqlBufFirst.append("')");
        DbUtil.execute((Context)ctx, (String)sqlBufFirst.toString());
        StringBuffer sqlBufSecond = new StringBuffer();
        sqlBufSecond.append("Insert into T_MM_PickingSlipBillEntry(FID,FParentID,FMaterialPlanID,FProductLineWpID,FMaterialID,FBaseUnitID,FUnitID,FLotNo,FLocationID,FWarehouseID,FREQDATE,FPICKINGDATE,FReqQty,FBaseReqQty,FSOURCEBILLENTRYID,FLineType,FLineStatus,FProvideType,FSupplyStorageOrgUnitID,FBaseStatus )select newbosid('5F932B11'),pick.fid,proEn.FMaterialInventoryID,proEn.FPRODUCTLINEWPID,proEn.FMATERIALID,proEn.FBaseUnitID,proEn.FUnitID,proEn.FLotNo,proEn.FLocationID,proEn.FDefaultWarehouseID,task.FStartDate,task.FStartDate,round(decimal((task.FProductQty/prod.FQty)*proEn.FQty,21,8),t6.FQtyPrecision),round(decimal((task.FBaseProductQty/prod.FBaseQty)*proEn.FBaseQty,21,8),t6.FQtyPrecision),proEn.fid,1,1,proEn.FProvideType,proEn.FSupplyStorageOrgUnitID,1 from T_MM_PickingSlipBill pick,T_MM_ProductionOrder prod, T_MM_ProductionOrderSEntry proEn, T_MM_taskdispbill task,  t_bd_multimeasureunit t6  where  pick.FSourceBillID = task.fid and proEn.FMaterialID = t6.FMaterialID and proEn.FUnitID = t6.fmeasureunitid  and proEn.FParentID = prod.fid and pick.FPRODUCTIONORDERID = prod.fid  and proEn.FIsBackFlush = 0  and proEn.FQty <> 0 and proEn.FIssMode = 11010  and task.fid ");
        sqlBufSecond.append(" in( '");
        sqlBufSecond.append(strIdLists);
        sqlBufSecond.append("')");
        DbUtil.execute((Context)ctx, (String)sqlBufSecond.toString());
        StringBuffer sql_getPickDate = new StringBuffer();
        sql_getPickDate.append(" select distinct(s.fid) fid ,p.fworkdate fpickingdate,s.fPickingDate fCurPickingDate,to_char(ADD_MINUTES(s.fPickingDate,z.FPickingLeadTime*-1),'YYYY-MM-DD HH24:MI:SS') fpickingTime ");
        sql_getPickDate.append(" from t_mm_pickingSlipBillEntry s ");
        sql_getPickDate.append(" left join t_mm_pickingSlipBill u on s.fparentid = u.fid ");
        sql_getPickDate.append(" left join T_MM_ProductionOrderSEntry z on z.fid = s.fSOURCEBILLENTRYID ");
        sql_getPickDate.append(" left join (select ec.fstorageorgunitid fstorageorgunitid, ece.FProductLineID FProductLineID, ec.FWorkDate FWorkDate ");
        sql_getPickDate.append(" \t\t\tfrom t_mm_equipmentcalendar ec ");
        sql_getPickDate.append("\t\t\tinner join t_mm_equipmentcalendarentry ece on ec.fid = ece.FParentID ");
        sql_getPickDate.append("\t\t\t) p on \tu.fproductlineid = p.FProductLineID and p.fstorageorgunitid = u.fstorageorgunitid ");
        sql_getPickDate.append(" where u.fNumber is null and u.fSourceBillID in( '" + strIdLists + "' )");
        sql_getPickDate.append(" and p.fworkdate=( ");
        sql_getPickDate.append("\t\t\t\t\tselect max(e.fworkdate) ");
        sql_getPickDate.append("\t\t\t\t\tfrom  t_mm_equipmentcalendarentry f inner join t_mm_equipmentcalendar e on f.fparentid=e.fid ");
        sql_getPickDate.append("\t\t\t\t\twhere  ");
        sql_getPickDate.append("\t\t\t\t\te.fstorageorgunitid = u.FStorageOrgUnitID and f.fproductlineid=u.fproductlineid  ");
        sql_getPickDate.append("\t\t\t\t\tand to_char(e.fworkdate,'yyyy-mm-dd')<= to_char(ADD_MINUTES(s.fPickingDate,z.FPickingLeadTime*-1),'yyyy-mm-dd') and YEAR(NOW())=YEAR(e.fworkdate) and e.FWorkDay=1 and f.fAbility>0 ");
        sql_getPickDate.append("\t\t\t\t ) ");
        IRowSet row1 = DbUtil.executeQuery((Context)ctx, (String)sql_getPickDate.toString());
        Connection conn1 = null;
        Statement batchStatementFirst = null;
        PreparedStatement updatePkDtPrpStmt = null;
        try {
            conn1 = EJBFactory.getConnection((Context)ctx);
            batchStatementFirst = conn1.createStatement();
            String sql_pickingDate = "update T_MM_PickingSlipBillEntry set fpickingdate = ? where fid = ?";
            updatePkDtPrpStmt = conn1.prepareStatement(sql_pickingDate);
            while (row1.next()) {
                Timestamp fpickingdate = row1.getTimestamp("fpickingdate");
                Timestamp fCurPickingDate = row1.getTimestamp("fCurPickingDate");
                Timestamp fpickingTime = row1.getTimestamp("fpickingTime");
                Timestamp calPickingDate = null;
                if (fpickingdate != null && fCurPickingDate != null && fpickingTime != null) {
                    if (fpickingdate != null) {
                        calPickingDate = fpickingdate;
                    }
                    if (fCurPickingDate != null && calPickingDate == null) {
                        calPickingDate = fCurPickingDate;
                    }
                    if (fpickingTime != null && calPickingDate != null) {
                        calPickingDate.setHours(fpickingTime.getHours());
                        calPickingDate.setMinutes(fpickingTime.getMinutes());
                        calPickingDate.setSeconds(fpickingTime.getSeconds());
                    }
                }
                updatePkDtPrpStmt.setTimestamp(1, calPickingDate);
                updatePkDtPrpStmt.setString(2, row1.getString("fid"));
                updatePkDtPrpStmt.addBatch();
            }
            updatePkDtPrpStmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatementFirst, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatementFirst, (Connection)conn1);
        String sql = "select fid,FSourceBillID,fstorageorgunitid from T_MM_PickingSlipBill where FSourceBillID in ('" + strIdLists + "')";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        Connection conn = null;
        Statement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            PickingSlipBillInfo psInfo = new PickingSlipBillInfo();
            psInfo.setBizDate(new Date());
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            while (row.next()) {
                String number = codingRuleManager.getNumber((IObjectValue)psInfo, row.getString("fstorageorgunitid"));
                String sql_updateNumber = "update T_MM_PickingSlipBill set fnumber = '" + number + "' where fid = '" + row.getString("fid") + "'";
                batchStatement.addBatch(sql_updateNumber);
                String insertSql = "Insert into t_bot_relation (FID,FSRCENTITYID, FDESTENTITYID, FSRCOBJECTID, FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE)values (newbosid('59302EC6'),'4D11B6D5','A06DF1E1','" + row.getString("FSourceBillID") + "','" + row.getString("fid") + "',now(),'" + ctx.getCaller().toString() + "',1,null,0)";
                batchStatement.addBatch(insertSql);
            }
            String sql_updateStatus = "update T_MM_TaskDispBill set FIsGeneRatePick = 1 where fid in ('" + strIdLists + "')";
            batchStatement.addBatch(sql_updateStatus);
            batchStatement.executeBatch();
            if (forAutoGen) {
                StringBuffer ckSql = new StringBuffer();
                ckSql.append(" select pick.fid as pickId,p.fstorageorgunitid as taskOrgId,pick.fstorageOrgUnitId as pickOrgId  from t_mm_pickingSlipBill pick  ");
                ckSql.append(" inner join t_bot_relation r on  r.fdestObjectID = pick.fid ");
                ckSql.append(" inner join t_mm_taskdispbill p on pick.FTaskDispID = p.fid  and r.fsrcObjectID  = p.fid ");
                ckSql.append(" where r.fsrcEntityID = ? and r.fdestEntityID = ? and p.fid in ('");
                ckSql.append(strIdLists);
                ckSql.append("')");
                IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)ckSql.toString(), (Object[])new Object[]{new TaskDispBillInfo().getBOSType().toString(), new PickingSlipBillInfo().getBOSType().toString()});
                IPickingSlipBill iPicking = PickingSlipBillFactory.getLocalInstance(ctx);
                while (rs.next()) {
                    String pickId = rs.getString("pickId");
                    String taskOrgId = rs.getString("taskOrgId");
                    String pickOrgId = rs.getString("pickOrgId");
                    String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(taskOrgId), (String)"GenPickingAutoAudit");
                    if (value == null || value.trim().equals("") || !value.trim().equals("true")) continue;
                    PickingSlipBillInfo pickInfo = (PickingSlipBillInfo)iPicking.getValue((IObjectPK)new ObjectUuidPK(pickId));
                    iPicking.submit((CoreBaseInfo)pickInfo);
                    ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
                    String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, pickOrgId, "3fY8szOQTQmfaNi+Tm5SJUY+1VI=");
                    if (strAutoAudit == null || strAutoAudit.trim().equals("") || strAutoAudit.trim().equals("1")) continue;
                    iPicking.audit((IObjectPK)new ObjectUuidPK(pickId));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    @Override
    protected boolean _taskComplete(Context ctx, IObjectPK[] pks) throws BOSException, TaskDispBillCompleteException, EASBizException {
        String idStringList = StringUtils.arrayToString((Object[])pks, (String)"','");
        StringBuffer error = new StringBuffer();
        String sql_statusCheck = "select Fid,FSOURCEBILLID,fnumber,fbasestatus from t_mm_taskDispBill    where fid in ('" + idStringList + "')";
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck);
        ArrayList<ObjectUuidPK> finishedOrderPKS = new ArrayList<ObjectUuidPK>();
        try {
            while (rowStatus.next()) {
                if (rowStatus.getInt("fbasestatus") != 4) {
                    error.append("," + rowStatus.getString("fnumber"));
                    continue;
                }
                String checkProd = "select a.fbasestatus  from t_mm_taskdispbill a, t_mm_taskdispbill b  where b.FSOURCEBILLID=a.FSOURCEBILLID and a.fid!= b.fid  and a.fbasestatus <> 8 and a.fbasestatus <> 7 and b.fid ='" + rowStatus.getString("Fid") + "'";
                IRowSet rowCheckProd = DbUtil.executeQuery((Context)ctx, (String)checkProd);
                if (!rowCheckProd.next()) {
                    Timestamp actualEndDate = new Timestamp(new Date().getTime());
                    String sqlUpdateProd = "update t_mm_productionorder set fbasestatus = 8, FActualEndDate = ? where fid = '" + rowStatus.getString("FSOURCEBILLID") + "'";
                    DbUtil.execute((Context)ctx, (String)sqlUpdateProd, (Object[])new Object[]{actualEndDate});
                    BOSUuid orderId = BOSUuid.read((String)rowStatus.getString("FSOURCEBILLID"));
                    ObjectUuidPK finishedOrderPK = new ObjectUuidPK(orderId);
                    finishedOrderPKS.add(finishedOrderPK);
                }
                String sql_update = "update t_mm_taskDispBill  set fbasestatus = 8   where fid in ('" + idStringList + "')";
                DbUtil.execute((Context)ctx, (String)sql_update);
                String sql_secondUpdate = "update T_MM_PickingSlipBill  set fbasestatus = 8 where FSourceBillID in ('" + idStringList + "')";
                DbUtil.execute((Context)ctx, (String)sql_secondUpdate);
            }
            if (error.length() > 0) {
                throw new TaskDispBillCompleteException(TaskDispBillCompleteException.EXCEPTION0, new Object[]{error.substring(1)});
            }
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < finishedOrderPKS.size(); ++i) {
                idList.add(finishedOrderPKS.get(i).toString());
            }
            ProductionOrderFacadeFactory.getLocalInstance(ctx).updatePLSStatus(idList, true);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return true;
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._unAuditForTaskDispBill(ctx, pks);
    }

    @Override
    protected boolean _unAuditForTaskDispBill(Context ctx, IObjectPK[] pks) throws BOSException, TaskDispBillUnAuditException, EASBizException {
        StringBuffer error = new StringBuffer();
        String strIdLists = StringUtils.arrayToString((Object[])pks, (String)"','");
        HashMap<String, String> hs = new HashMap<String, String>();
        HashSet<String> hs1 = new HashSet<String>();
        if (pks != null && pks.length > 0) {
            for (int i = 0; i < pks.length; ++i) {
                ISCMBillParam scmParam;
                String strCanUnAudit;
                ObjectUuidPK pk = (ObjectUuidPK)pks[i];
                TaskDispBillInfo taskDispBillInfo = this.getTaskDispBillInfo(ctx, (IObjectPK)pk);
                String orgUnitID = taskDispBillInfo.getStorageOrgUnit().getId().toString();
                String billTypeId = taskDispBillInfo.getBillType().getId().toString();
                if (taskDispBillInfo.getProductionOrder() != null && taskDispBillInfo.getProductionOrder().getId() != null) {
                    ArrayList<String> orderIds = new ArrayList<String>();
                    orderIds.add(taskDispBillInfo.getProductionOrder().getId().toString());
                    ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
                }
                if ((strCanUnAudit = (scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx)).getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId)) != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().toLowerCase().equals("1")) continue;
                throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.ISUNAUDITINPARAM);
            }
        }
        String sql_statusCheck = "select fbasestatus ,fnumber,fid from t_mm_TaskDispbill where fid in ('" + strIdLists + "')";
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck);
        try {
            while (rowStatus.next()) {
                if (rowStatus.getInt("fbasestatus") != 4) {
                    error.append("," + rowStatus.getString("fnumber"));
                    continue;
                }
                hs.put(rowStatus.getString("fid"), rowStatus.getString("fnumber"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (error.length() > 0) {
            throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.UNAUDITEXCEPTION, new Object[]{error.substring(1)});
        }
        error.setLength(0);
        String sqlCheckFinish = "select f.FBaseStatus,f.fnumber,t.FSrcObjectID from t_MM_Finishedrpt f  inner join t_bot_relation t on  t.FdestEntityID= 'F2901DDD' and f.fid = t.FDestObjectID  and t.FSrcObjectID in ('" + strIdLists + "')";
        IRowSet rowStatus1 = DbUtil.executeQuery((Context)ctx, (String)sqlCheckFinish);
        try {
            while (rowStatus1.next()) {
                if (rowStatus1.getInt("fbasestatus") == 2 && rowStatus1.getInt("fbasestatus") == 1) continue;
                hs1.add(rowStatus1.getString("fsrcobjectid"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (hs1.size() > 0) {
            Iterator it = hs1.iterator();
            while (it.hasNext()) {
                error.append("," + hs.get(it.next()));
            }
            throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.UNAUDITHASOTHERBILL, new Object[]{error.substring(1)});
        }
        error.setLength(0);
        hs1 = new HashSet();
        String sqlCheckPickingSlip = "select f.FBaseStatus,f.fnumber,t.FSrcObjectID from T_MM_PickingSlipBill f  inner join t_bot_relation t on  t.FdestEntityID= 'A06DF1E1' and f.fid = t.FDestObjectID  and t.FSrcObjectID in ('" + strIdLists + "')";
        IRowSet rowStatus2 = DbUtil.executeQuery((Context)ctx, (String)sqlCheckPickingSlip);
        try {
            while (rowStatus2.next()) {
                if (rowStatus2.getInt("fbasestatus") == 2) continue;
                hs1.add(rowStatus2.getString("fsrcobjectid"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (hs1.size() > 0) {
            Iterator it = hs1.iterator();
            while (it.hasNext()) {
                error.append("," + hs.get(it.next()));
            }
            throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.UNAUDITHASOTHERBILL, new Object[]{error.substring(1)});
        }
        boolean returnFlag = this._confirmUnaudit(ctx, strIdLists);
        String[] ids = new String[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            ids[i] = pks[i].toString();
        }
        LotFacadeFactory.getLocalInstance((Context)ctx).productionOrderdisTaskDispatchDeleteLot(ids);
        return returnFlag;
    }

    private boolean _confirmUnaudit(Context ctx, String idString) throws BOSException, EASBizException {
        String deleteFinishRptSql1 = "delete from  t_MM_Finishedrpt   where fid in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'F2901DDD' and t.FSrcObjectID in ('" + idString + "'))";
        String deleteFinishRptSql2 = "delete from  t_mm_finishedrptentry   where FParentID in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'F2901DDD' and t.FSrcObjectID in ('" + idString + "'))";
        String deleteFinRptRelSql = "delete from t_bot_relation  where FdestEntityID= 'F2901DDD' and FSrcObjectID in ('" + idString + "')";
        String deletePickingSql1 = "delete from  T_MM_PickingSlipBill   where fid in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'A06DF1E1' and t.FSrcObjectID in ('" + idString + "'))";
        String deletePickingSql2 = "delete from  T_MM_PickingSlipBillEntry   where FParentID in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'A06DF1E1' and t.FSrcObjectID in ('" + idString + "'))";
        String deletePickRelSql = "delete from t_bot_relation where FdestEntityID= 'A06DF1E1' and FSrcObjectID in ('" + idString + "')";
        Connection conn1 = null;
        Statement batchStatementFirst = null;
        try {
            conn1 = EJBFactory.getConnection((Context)ctx);
            batchStatementFirst = conn1.createStatement();
            batchStatementFirst.addBatch(deleteFinishRptSql1);
            batchStatementFirst.addBatch(deleteFinishRptSql2);
            batchStatementFirst.addBatch(deleteFinRptRelSql);
            batchStatementFirst.addBatch(deletePickingSql1);
            batchStatementFirst.addBatch(deletePickingSql2);
            batchStatementFirst.addBatch(deletePickRelSql);
            batchStatementFirst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatementFirst, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatementFirst, (Connection)conn1);
        String[] ids = StringUtils.split((String)idString, (String)"','");
        if (null != ids && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
                TaskDispBillInfo info = (TaskDispBillInfo)this._getValue(ctx, (IObjectPK)pk);
                info.setAuditor(null);
                info.setAuditTime(null);
                info.setIsGeneratePick(false);
                info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
            }
        }
        return true;
    }

    @Override
    protected String _taskDispBillClosed(Context ctx, IObjectPK[] pks) throws BOSException, TaskDispBillUnAuditException, EASBizException {
        StringBuffer error = new StringBuffer();
        String strIdLists = StringUtils.arrayToString((Object[])pks, (String)"','");
        String sql_statusCheck = "select fbasestatus  ,fnumber from t_mm_TaskDispbill where fid in ('" + strIdLists + "')";
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck);
        try {
            while (rowStatus.next()) {
                if (rowStatus.getInt("fbasestatus") == 8) continue;
                error.append("," + rowStatus.getString("fnumber"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (error.length() > 0) {
            throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.CLOSEEXCEPTION, new Object[]{error.substring(1)});
        }
        boolean flag = true;
        StringBuffer error1 = new StringBuffer();
        String sqlCheckFinish = "select f.FBaseStatus,f.fnumber from t_MM_Finishedrpt f  where f.fid in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'F2901DDD' and t.FSrcObjectID in ('" + strIdLists + "'))";
        IRowSet rowStatus1 = DbUtil.executeQuery((Context)ctx, (String)sqlCheckFinish);
        try {
            while (rowStatus1.next()) {
                if (rowStatus1.getInt("fbasestatus") == 8) continue;
                error1.append(rowStatus1.getString("fnumber") + ",");
                flag = false;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer error2 = new StringBuffer();
        String sqlCheckPickingSlip = "select f.FBaseStatus,f.fnumber from T_MM_PickingSlipBill f where f.fid in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'A06DF1E1' and t.FSrcObjectID in ('" + strIdLists + "'))";
        IRowSet rowStatus2 = DbUtil.executeQuery((Context)ctx, (String)sqlCheckPickingSlip);
        try {
            while (rowStatus2.next()) {
                if (rowStatus2.getInt("fbasestatus") == 8) continue;
                error2.append(rowStatus2.getString("fnumber") + ",");
                flag = false;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (flag) {
            this._confirmClose(ctx, strIdLists);
        }
        String result = this.contactString(error1.toString(), error2.toString());
        return result;
    }

    @Override
    protected boolean _confirmClose(Context ctx, String idString) throws BOSException, EASBizException {
        String updateSql = "update t_mm_TaskDispbill set FBaseStatus= 7   where fid in ('" + idString + "')";
        String updateSql1 = "update t_MM_Finishedrpt set FBaseStatus= 7  where fid in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'F2901DDD' and t.FSrcObjectID in ('" + idString + "'))";
        String updateSql2 = "update T_MM_PickingSlipBill set FBaseStatus= 7 where fid in(select t.FDestObjectID from t_bot_relation t where t.FdestEntityID= 'A06DF1E1' and t.FSrcObjectID in ('" + idString + "'))";
        Connection conn1 = null;
        Statement batchStatementFirst = null;
        try {
            conn1 = EJBFactory.getConnection((Context)ctx);
            batchStatementFirst = conn1.createStatement();
            batchStatementFirst.addBatch(updateSql);
            batchStatementFirst.addBatch(updateSql1);
            batchStatementFirst.addBatch(updateSql2);
            batchStatementFirst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatementFirst, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatementFirst, (Connection)conn1);
        return true;
    }

    private String contactString(String first, String second) {
        StringBuffer result = new StringBuffer();
        if (first.length() > 0 && second.length() > 0) {
            result.append(first);
            result.append("@");
            result.append(second);
        }
        if (first.length() > 0 && second.length() < 0) {
            result.append(first);
            result.append("@");
            result.append("");
        }
        if (first.length() < 0 && second.length() > 0) {
            result.append("");
            result.append("@");
            result.append(second);
        }
        if (first.length() < 0 && second.length() < 0) {
            result.setLength(0);
        }
        return result.toString();
    }

    @Override
    protected boolean _verifyDuplateDate(Context ctx, Date startDate, Date endDate, String Id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct  b.fid from t_mm_taskdispbill a, t_mm_taskdispbill b where a.fid = '" + Id + "' and a.fid != b.fid and((b.fstartdate <= to_date( '" + startDate + "') and b.fenddate <= to_date( '" + endDate + "') and b.fenddate >= to_date( '" + startDate + "')) or( b.fstartdate >= to_date( '" + startDate + "') and b.fstartdate <= to_date( '" + endDate + "') and b.fenddate >= to_date( '" + endDate + "')) or(b.fstartdate >= to_date( '" + startDate + "') and b.fstartdate <= to_date( '" + endDate + "') and b.fenddate >= to_date( '" + startDate + "') and b.fenddate <= to_date( '" + endDate + "')))");
        IRowSet rowResult = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowResult.next()) {
                return true;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return false;
    }

    @Override
    protected int _updatePrintCount(Context ctx, IObjectPK pk, boolean flag, int printTime) throws BOSException, EASBizException {
        TaskDispBillInfo task = this.getTaskDispBillInfo(ctx, pk);
        if (flag) {
            task.setPrintCount(task.getPrintCount() + printTime);
        } else {
            task.setIsPrint(true);
            task.setPrintCount(printTime);
        }
        this.update(ctx, pk, (CoreBaseInfo)task);
        return task.getPrintCount();
    }

    private void checkEmpty(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaskDispBillInfo task = (TaskDispBillInfo)model;
        StringBuffer error = new StringBuffer();
        if (!(task.getBaseStatus().getValue() != 2 && task.getBaseStatus().getValue() != 1 || this.exists(ctx, (IObjectPK)new ObjectUuidPK(task.getId())))) {
            error.append(ResourceUtils.getMessageForServer((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND"));
        }
        if (error.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(error.toString());
            throw bizExp;
        }
        if (task.getStartDate() == null) {
            error.append(this.getResource("startDateNotNull") + "\n");
        }
        if (task.getEndDate() == null) {
            error.append(this.getResource("endDateNotNull") + "\n");
        }
        if (task.getBizDate() == null) {
            error.append(this.getResource("bizDateNotNull") + "\n");
        }
        if (error.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(error.toString());
            throw bizExp;
        }
    }

    private void validateStartEndDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaskDispBillInfo task = (TaskDispBillInfo)model;
        StringBuffer error = new StringBuffer();
        if (task.getStartDate() != null && task.getEndDate() != null && task.getStartDate().after(task.getEndDate())) {
            error.append(this.getResource("sDateCannotAfterEDate") + "\n");
        }
        if (error.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(error.toString());
            throw bizExp;
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Object[] pks = new ObjectUuidPK[]{(ObjectUuidPK)pk};
        StringBuffer error = new StringBuffer();
        String strIdLists = StringUtils.arrayToString((Object[])pks, (String)"','");
        this.checkAudit(ctx, error, strIdLists, false);
        String updateSql = "update t_mm_TaskDispbill set FBaseStatus= 4, fauditorId = '" + ctx.getCaller().toString() + "', fauditTime = GETDATE()   where fid in ('" + strIdLists + "')";
        DbUtil.execute((Context)ctx, (String)updateSql);
        strIdLists = this.getGenPickingBillIds(ctx, (IObjectPK[])pks, true);
        if (strIdLists != null) {
            this.genPickingSlipBill(ctx, strIdLists, true);
        }
        String[] ids = new String[]{pk.toString()};
        LotFacadeFactory.getLocalInstance((Context)ctx).productionOrderdisTaskDispatchInsertLot(ids);
    }

    @Override
    protected boolean _auditForTaskDispBill(Context ctx, IObjectPK[] pks) throws BOSException, TaskDispBillUnAuditException, EASBizException {
        StringBuffer error = new StringBuffer();
        String strIdLists = StringUtils.arrayToString((Object[])pks, (String)"','");
        this.checkAudit(ctx, error, strIdLists, true);
        String updateSql = "update t_mm_TaskDispbill set FBaseStatus= 4, fauditorId = '" + ctx.getCaller().toString() + "', fauditTime = GETDATE()   where fid in ('" + strIdLists + "')";
        DbUtil.execute((Context)ctx, (String)updateSql);
        strIdLists = this.getGenPickingBillIds(ctx, pks, true);
        if (strIdLists != null) {
            this.genPickingSlipBill(ctx, strIdLists, true);
        }
        String[] ids = new String[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            ids[i] = pks[i].toString();
        }
        LotFacadeFactory.getLocalInstance((Context)ctx).productionOrderdisTaskDispatchInsertLot(ids);
        return true;
    }

    private void checkAudit(Context ctx, StringBuffer error, String strIdLists, boolean isList) throws BOSException, TaskDispBillUnAuditException, EASBizException {
        String sql_statusCheck = "select fbasestatus ,fnumber, FProductionOrderID from t_mm_TaskDispbill where fid in ('" + strIdLists + "')";
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck);
        ArrayList<String> orderIds = new ArrayList<String>();
        try {
            while (rowStatus.next()) {
                if (rowStatus.getString("FProductionOrderID") != null) {
                    orderIds.add(rowStatus.getString("FProductionOrderID"));
                }
                if (rowStatus.getInt("fbasestatus") == 2) continue;
                error.append("," + rowStatus.getString("fnumber"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (error.length() > 0) {
            throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.AUDITEXCEPTION, new Object[]{error.substring(1)});
        }
        ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        error = new StringBuffer();
        String sql_LotCheck = "select fnumber, FStorageOrgUnitID, fmaterialID, flotNo from t_mm_TaskDispbill where fid in ('" + strIdLists + "')";
        IRowSet rowLot = DbUtil.executeQuery((Context)ctx, (String)sql_LotCheck);
        try {
            while (rowLot.next()) {
                String lotNo = rowLot.getString("flotNo");
                String materialID = rowLot.getString("fmaterialID");
                String storageOrgUnitID = rowLot.getString("FStorageOrgUnitID");
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                MaterialInfo material = new MaterialInfo();
                sou.setId(BOSUuid.read((String)storageOrgUnitID));
                material.setId(BOSUuid.read((String)materialID));
                int type = TaskDispLotServerUtils.dealLotNoSituation(sou, material, ctx);
                if (type != 1 || null != lotNo && !"".equals(lotNo.trim())) continue;
                error.append("," + rowLot.getString("fnumber"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (error.length() > 0) {
            if (isList) {
                throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.LOTEXCEPTION, new Object[]{error.substring(1)});
            }
            throw new TaskDispBillUnAuditException(TaskDispBillUnAuditException.LOTFOREDITEXCEPTION);
        }
    }

    @Override
    protected String _getTskDisParam(Context ctx, String storageOrgUnitID, String paramKey) throws BOSException, EASBizException {
        String strRtnValue = "";
        if (!StringUtils.isEmpty((String)storageOrgUnitID) && !StringUtils.isEmpty((String)paramKey)) {
            ParamItemInfo pValue = ParameterUtil.getParamItemByCodeAndOrg((Context)ctx, (String)paramKey, (String)storageOrgUnitID);
            strRtnValue = pValue.getValue();
        }
        return strRtnValue;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String strTskDispId = pk.toString();
        String strPrdOrdId = "";
        StringBuffer sql_selPrdOrd = new StringBuffer();
        sql_selPrdOrd.append(" select FProductionOrderId from T_MM_TaskDispBill where fid = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_selPrdOrd.toString(), (Object[])new Object[]{strTskDispId});
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    strPrdOrdId = rowSet.getString("FProductionOrderId");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        super._delete(ctx, pk);
    }

    protected Map _getPrdOrdParam(Context ctx, String storageOrgUnitID, String[] paramKey) throws BOSException, EASBizException {
        HashMap<String, String> retVal = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)storageOrgUnitID) && paramKey != null && paramKey.length > 0) {
            if (this.iParamControl == null) {
                this.iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            }
            for (int i = 0; i < paramKey.length; ++i) {
                try {
                    ParamItemInfo paramItemInfo = this.iParamControl.getParamItemByNumberAndOrg(paramKey[i], storageOrgUnitID);
                    retVal.put(paramKey[i], paramItemInfo.getValue());
                    continue;
                }
                catch (Exception ex) {
                    logger.warn((Object)ex);
                }
            }
        }
        return retVal;
    }

    protected boolean _checkOtherWhenDel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TaskDispBillInfo info = (TaskDispBillInfo)model;
        BillBaseStatusEnum status = info.getBaseStatus();
        if (status.getValue() != 1 && status.getValue() != 2) {
            ActionCommonException bizExp = new ActionCommonException(null);
            StringBuffer errorStr = new StringBuffer();
            if (8 == status.getValue()) {
                errorStr.append(ResourceUtils.getMessageForServer((String)RES_TASKDISP, (String)"hasFinished"));
            } else {
                errorStr.append(this.getResource("bill"));
                errorStr.append(status.getAlias());
            }
            bizExp.setMessage(errorStr.toString());
            throw bizExp;
        }
        return true;
    }

    private String getResource(String strKey) {
        return ResourceUtils.getMessageForServer((String)RES_TASKDISP, (String)strKey);
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchUnFreeze(ctx, entrys);
        result.throwExceptions();
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchFreeze(ctx, entrys);
        result.throwExceptions();
    }

    @Override
    protected void _generatePickingSlipBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchGeneratePickingSlipBill(ctx, entrys);
        result.throwExceptions();
    }

    public BatchActionResults batchFreeze(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("FREEZE"));
    }

    public BatchActionResults batchUnFreeze(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("UNFREEZE"));
    }

    public BatchActionResults batchGeneratePickingSlipBill(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("GENERATE"));
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.getBizAction().equalsIgnoreCase("FREEZE")) {
            this.freezeCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("UNFREEZE")) {
            this.unFreezeCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("GENERATE")) {
            this.generateCheck(ctx, batchResults);
        }
    }

    private void freezeCheck(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] allIDs = batchResults.getAllIDs();
        String strIdLists = StringUtils.arrayToString((Object[])allIDs, (String)"','");
        StringBuffer sql_statusCheck = new StringBuffer();
        sql_statusCheck.append(" SELECT t1.FBASESTATUS as FBASESTATUS,\t\t\t\t\t\t\t\n");
        sql_statusCheck.append(" \t\tt1.FID,\t\t\t\t\t\t\t\t\n");
        sql_statusCheck.append(" \t\tt1.FPRODUCTIONORDERID,\t\t\t\t\t\n");
        sql_statusCheck.append(" \t\tt2.FBASESTATUS as UPBASESTATUS\t\t\t\n");
        sql_statusCheck.append("   FROM T_MM_TASKDISPBILL\tt1\t\t\t\t\t\n");
        sql_statusCheck.append("   INNER JOIN T_MM_PRODUCTIONORDER t2 ON t1.FPRODUCTIONORDERID =t2.FID    \n");
        sql_statusCheck.append("  WHERE t1.FID IN ('" + strIdLists + "')\t\t\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck.toString());
        try {
            while (rowSet.next()) {
                if (rowSet.getInt("FBASESTATUS") != 4) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("TASK_CANNOT_GREEZE1", ctx));
                }
                if (rowSet.getInt("UPBASESTATUS") != 7) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("TASK_CANNOT_GREEZE2", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void unFreezeCheck(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] allIDs = batchResults.getAllIDs();
        StringBuffer sql_statusCheck = new StringBuffer();
        String strIdLists = StringUtils.arrayToString((Object[])allIDs, (String)"','");
        sql_statusCheck.append(" SELECT t1.FBASESTATUS as FBASESTATUS,\t\t\t\t\t\t\t\n");
        sql_statusCheck.append(" \t\tt1.FID,\t\t\t\t\t\t\t\t\n");
        sql_statusCheck.append(" \t\tt1.FPRODUCTIONORDERID,\t\t\t\t\t\n");
        sql_statusCheck.append(" \t\tt2.FBASESTATUS as UPBASESTATUS\t\t\t\n");
        sql_statusCheck.append("   FROM T_MM_TASKDISPBILL\tt1\t\t\t\t\t\n");
        sql_statusCheck.append("   INNER JOIN T_MM_PRODUCTIONORDER t2 ON t1.FPRODUCTIONORDERID =t2.FID    \n");
        sql_statusCheck.append("  WHERE t1.FID IN ('" + strIdLists + "')\t\t\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck.toString());
        try {
            while (rowSet.next()) {
                if (rowSet.getInt("FBASESTATUS") != 6) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("TASK_CANNOT_UNGREEZE1", ctx));
                }
                if (rowSet.getInt("UPBASESTATUS") != 7) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("TASK_CANNOT_UNGREEZE2", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void generateCheck(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] allIDs = batchResults.getAllIDs();
        StringBuffer sql_statusCheck = new StringBuffer();
        String strIdLists = StringUtils.arrayToString((Object[])allIDs, (String)"','");
        sql_statusCheck.append("select t.fid, t.fStorageOrgUnitID, t.fbasestatus,t.fIsManualFinish,t.FIsGeneratePick,");
        sql_statusCheck.append(" p.FBASESTATUS as UPBASESTATUS, sum(case when s.Fqty = 0 or s.FIsBackFlush = 1 or s.FIssMode != 11010  then 0 else 1 end) sum ");
        sql_statusCheck.append(" from t_mm_taskdispbill t inner join  t_mm_productionorder p on t.fproductionorderid = p.fid");
        sql_statusCheck.append("  inner join  t_mm_productionorderSEntry s on s.fParentID = p.fid");
        sql_statusCheck.append(" where t.fid in ('" + strIdLists + "')");
        sql_statusCheck.append(" group by t.fid, t.fStorageOrgUnitID, t.fbasestatus,t.fIsManualFinish,t.FIsGeneratePick,p.FBASESTATUS");
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck.toString());
        ParamUtil paramUtil = new ParamUtil(ctx);
        String enabledPick = null;
        try {
            while (rowStatus.next()) {
                int status = rowStatus.getInt("fbasestatus");
                int isManualFinish = rowStatus.getInt("fIsManualFinish");
                String id = rowStatus.getString("fid");
                int sum = rowStatus.getInt("sum");
                String fStorageOrgUnitID = rowStatus.getString("fStorageOrgUnitID");
                boolean isGenerate = rowStatus.getBoolean("FIsGeneratePick");
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                enabledPick = paramUtil.getEnabledPickBillParam("true");
                if (!"true".equals(enabledPick)) {
                    batchResults.addError(id, new TaskDispBillGenerateException(TaskDispBillGenerateException.PARAMCHECK).getMessage());
                    continue;
                }
                if (status != 4 && (status != 8 || isManualFinish != 0)) {
                    batchResults.addError(id, new TaskDispBillGenerateException(TaskDispBillGenerateException.NOAUDIT).getMessage());
                    continue;
                }
                if (isGenerate) {
                    batchResults.addError(id, new TaskDispBillGenerateException(TaskDispBillGenerateException.YETGENERATEPICK).getMessage());
                    continue;
                }
                if (sum <= 0) {
                    batchResults.addError(id, new TaskDispBillGenerateException(TaskDispBillGenerateException.CANNOT_GENERATEPICK).getMessage());
                    continue;
                }
                if (rowStatus.getInt("UPBASESTATUS") != 7) continue;
                batchResults.addError(id, new TaskDispBillGenerateException(TaskDispBillGenerateException.ORDERSTATUS).getMessage());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsArray().length > 0) {
            if (batchAction.getBizAction().equalsIgnoreCase("FREEZE")) {
                this.doFreeze(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("UNFREEZE")) {
                this.doUnFreeze(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("GENERATE")) {
                this.doGenerate(ctx, batchResults);
            }
        }
    }

    private void doFreeze(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] prdPks = batchResults.getToDoPkArray();
        String strIdLists = StringUtils.arrayToString((Object[])prdPks, (String)"','");
        StringBuffer sql_updatePrdOrder = new StringBuffer();
        sql_updatePrdOrder.append(" UPDATE T_MM_PickingSlipBill\t\t\t\t\t\t\t\t\t\n");
        sql_updatePrdOrder.append("    SET FBASESTATUS = 6\t\n");
        sql_updatePrdOrder.append("  WHERE FTASKDISPID IN ('" + strIdLists + "')\t\t\t\t\t\n");
        sql_updatePrdOrder.append("    AND FBASESTATUS = 4\t\n");
        sql_updatePrdOrder.append("\n");
        DbUtil.execute((Context)ctx, (String)sql_updatePrdOrder.toString());
        StringBuffer sql_updateTask = new StringBuffer();
        sql_updateTask.append(" UPDATE T_MM_TASKDISPBILL\t\t\t\t\t\t\t\t\t\n");
        sql_updateTask.append("    SET FBASESTATUS = 6\t\n");
        sql_updateTask.append("  WHERE FID IN ('" + strIdLists + "')\t\t\t\t\t\t\t\n");
        sql_updateTask.append("\n");
        DbUtil.execute((Context)ctx, (String)sql_updateTask.toString());
    }

    private void doUnFreeze(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] prdPks = batchResults.getToDoPkArray();
        String strIdLists = StringUtils.arrayToString((Object[])prdPks, (String)"','");
        StringBuffer sql_updatePrdOrder = new StringBuffer();
        sql_updatePrdOrder.append(" UPDATE T_MM_PickingSlipBill\t\t\t\t\t\t\t\t\t\t\n");
        sql_updatePrdOrder.append("    SET FBASESTATUS = 4\t\n");
        sql_updatePrdOrder.append("  WHERE FTASKDISPID IN ('" + strIdLists + "')\t\t\t\t\t\t\n");
        sql_updatePrdOrder.append("    AND FBASESTATUS = 6\t\n");
        sql_updatePrdOrder.append("\n");
        DbUtil.execute((Context)ctx, (String)sql_updatePrdOrder.toString());
        StringBuffer sql_updateTask = new StringBuffer();
        sql_updateTask.append(" UPDATE T_MM_TASKDISPBILL\t\t\t\t\t\t\t\t\t\n");
        sql_updateTask.append("    SET FBASESTATUS = 4\t\n");
        sql_updateTask.append("  WHERE FID IN ('" + strIdLists + "')\t\t\t\t\t\t\t\n");
        sql_updateTask.append("\n");
        DbUtil.execute((Context)ctx, (String)sql_updateTask.toString());
    }

    private void doGenerate(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        Object[] prdPks = batchResults.getToDoPkArray();
        String strIdLists = StringUtils.arrayToString((Object[])prdPks, (String)"','");
        this.genPickingSlipBill(ctx, strIdLists, false);
    }

    private String getResourceMsg(String key, Context ctx) {
        return ResourceManage.getResource((String)RES_TASKDISP, (String)key, (Locale)ctx.getLocale());
    }
}

