/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StockAllocationUpdater {
    private Map tempDataTableMap = new HashMap();
    private static StockAllocationUpdater instance = null;

    private void setSourceDataTable(String primaryTable, Set minorTableSet) {
        this.tempDataTableMap.put(primaryTable, minorTableSet);
    }

    private StockAllocationUpdater() {
    }

    public static synchronized StockAllocationUpdater getInstance() {
        if (instance == null) {
            instance = new StockAllocationUpdater();
        }
        return instance;
    }

    public List GetWarehouseStockOrderCollection(Context ctx, String strBaseStatus, String strOrgUnitID) throws EASBizException, BOSException, SQLException {
        ArrayList<ProductionOrderCollection> resultList = new ArrayList<ProductionOrderCollection>();
        this.insertTempTableData_WarehouseStock(ctx, strBaseStatus, strOrgUnitID);
        ProductionOrderCollection poCollection = this.swichDataToOrderCollection_WarehouseStock(ctx);
        resultList.add(poCollection);
        return resultList;
    }

    public void beforeExecute(Context ctx, String tempTableBizType) throws BOSException, EASBizException {
        this.createTempTable_WarehouseStock(ctx, tempTableBizType);
    }

    public void afterExecute(Context ctx) throws BOSException, EASBizException {
        this.releaseTemptable(ctx);
    }

    private void releaseTemptable(Context ctx) throws BOSException, EASBizException {
        for (String key : this.tempDataTableMap.keySet()) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(key);
            Set values = (Set)this.tempDataTableMap.get(key);
            Iterator it_values = values.iterator();
            while (it_values.hasNext()) {
                pool.releaseTable((String)it_values.next());
            }
        }
    }

    private void createTempTable_WarehouseStock(Context ctx, String tempTableBizType) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf_primary = new StringBuffer();
            String strPrimaryTable = "";
            StringBuffer sqlBuf_Minor = new StringBuffer();
            String strMinorTable = "";
            if ("TempTable_WarehouseStock".equals(tempTableBizType)) {
                sqlBuf_primary.append("CREATE TABLE zhao (").append("fBillID varchar(44) null,").append("fNumber nvarchar(80) null,").append("fStorageOrgUnitID varchar(44) null,").append("fMaterialID varchar(44) null,").append("fProductLineID varchar(44) null,").append("fUnitID varchar(44) null,").append("fWarehouseID varchar(44) null,").append("fBaseUnitID varchar(44) null,").append("fWorkShopID varchar(44) null,").append("fClassTeamID varchar(44) null,").append("fClassGroupID varchar(44) null,").append("fFormulaID varchar(44) null,").append("fBomID varchar(44) null,").append("fTrackNumberID varchar(44) null,").append("fMmBizType int not null default 0, ").append("fBaseQty numeric(21,8) not null default 0, ").append("fQty numeric(21,8) not null default 0, ").append("fBaseStatus int not null default 0 ").append(")");
                strPrimaryTable = pool.createTempTable(sqlBuf_primary.toString());
                sqlBuf_Minor.append("CREATE TABLE js (").append("fStockEntryID varchar(44) null,").append("fParentid varchar(44) null,").append("fBaseUnitID varchar(44) null,").append("fUnitID varchar(44) null,").append("fMaterialID varchar(44) null,").append("fMoveOutWarehouseID varchar(44) null,").append("fMoveOutStorageOrgUnitID varchar(44) null,").append("fDefaultWarehouseID varchar(44) null,").append("fProductLineWPID varchar(44) null,").append("fSupplyOrgUnitID varchar(44) null,").append("fBaseQty numeric(21,8) not null default 0, ").append("fQty numeric(21,8) not null default 0, ").append("fTransactionType int not null default 0 ").append(")");
                strMinorTable = pool.createTempTable(sqlBuf_Minor.toString());
            }
            HashSet<String> minorTableSet = new HashSet<String>();
            minorTableSet.add(strMinorTable);
            this.setSourceDataTable(strPrimaryTable, minorTableSet);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private void insertTempTableData_WarehouseStock(Context ctx, String strBaseStatus, String strOrgUnitID) throws BOSException {
        for (String key : this.tempDataTableMap.keySet()) {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT INTO ").append(key).append(" (fBillID, fNumber, fStorageOrgUnitID, fMaterialID, fProductLineID, fUnitID, ").append(" fWarehouseID, fBaseUnitID, fWorkShopID, fClassTeamID, fClassGroupID, fFormulaID, ").append(" fBomID, fTrackNumberID, fMmBizType, fBaseQty, fQty, fBaseStatus) ").append("  SELECT DISTINCT a.fid, a.fnumber, a.fstorageorgunitid, a.FMaterialID, a.FProductLineID, a.FUnitID, ").append("\t\ta.FWarehouseID, a.FBaseUnitID, a.FWorkShopID, a.FClassTeamID, a.FClassGroupID, a.FFormulaID, ").append("\t\ta.FBomID, a.FTrackNumberID, a.FMmBizType, a.FBaseQty, a.FQty, a.FBaseStatus ").append("\t\tfrom t_mm_productionordersentry b ").append("\t\tinner join t_mm_productionorder a on b.fparentid=a.fid ");
            if (strOrgUnitID != null) {
                insertSql.append("\t\t\tand a.fstorageorgunitid='" + strOrgUnitID + "'");
            }
            insertSql.append("\t\t\tand a.FBaseStatus in " + strBaseStatus).append("\t\twhere b.fisstock=1 and b.fissmode=11010 and b.fprovidetype in (10910,10920) ");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            Set values = (Set)this.tempDataTableMap.get(key);
            for (String value : values) {
                insertSql.setLength(0);
                insertSql.append("INSERT INTO ").append(value).append(" (fStockEntryID, fParentid, fBaseUnitID, fUnitID, fMaterialID, fMoveOutWarehouseID, ").append(" fMoveOutStorageOrgUnitID, fDefaultWarehouseID, fProductLineWPID, fSupplyOrgUnitID, ").append(" fBaseQty, fQty, fTransactionType) ").append("  SELECT DISTINCT b.fid, b.FParentID, b.FBaseUnitID, b.FUnitID, b.FMaterialID, b.FMoveOutWarehouseID, ").append("\t\tb.FMoveOutStorageOrgUnitID, b.FDefaultWarehouseID, b.FProductLineWPID, b.FSupplyStorageOrgUnitID, ").append("\t\tb.FBaseQty, b.FQty, b.FTransactionType ").append("\t\tfrom t_mm_productionordersentry b ").append("\t\tinner join t_mm_productionorder a on b.fparentid=a.fid ");
                if (strOrgUnitID != null) {
                    insertSql.append("\t\t\tand a.fstorageorgunitid='" + strOrgUnitID + "'");
                }
                insertSql.append("\t\t\tand a.FBaseStatus in " + strBaseStatus).append("\t\twhere b.fisstock=1 and b.fissmode=11010 and b.fprovidetype in (10910,10920) ");
                DbUtil.execute((Context)ctx, (String)insertSql.toString());
            }
        }
    }

    private ProductionOrderCollection swichDataToOrderCollection_WarehouseStock(Context ctx) throws BOSException, SQLException, EASBizException {
        ProductionOrderCollection poCollection = new ProductionOrderCollection();
        for (String key : this.tempDataTableMap.keySet()) {
            String talbleSQL = "SELECT * FROM " + key;
            IRowSet poRs = DbUtil.executeQuery((Context)ctx, (String)talbleSQL);
            while (poRs.next()) {
                ObjectUuidPK pk = new ObjectUuidPK(poRs.getString("fBillID"));
                ProductionOrderInfo poInfo = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderInfo((IObjectPK)pk);
                poCollection.add(poInfo);
            }
        }
        return poCollection;
    }

    static {
        instance = new StockAllocationUpdater();
    }
}

