/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.util;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.mm.basedata.BomSubstituteCollection;
import com.kingdee.eas.mm.basedata.BomSubstituteFactory;
import com.kingdee.eas.mm.basedata.BomSubstituteInfo;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryFactory;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryInfo;
import com.kingdee.eas.mm.common.loadmass.MaterialSustituteVO;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class MaterialSustituteHelper {
    public static Collection loadSustitute(String bomId, String bomEntryId, String materialId, Date startDate, Date endDate) throws Exception {
        FilterInfo sustituteFilterInfo = new FilterInfo();
        if (bomEntryId != null) {
            sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("parentEntry.id", (Object)bomEntryId, CompareType.EQUALS));
        } else if (bomId != null && materialId != null) {
            sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("parentEntry.material.id", (Object)materialId, CompareType.EQUALS));
            sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("parentEntry.parent.id", (Object)bomId, CompareType.EQUALS));
        } else {
            return null;
        }
        sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("parentEntry.parent.baseStatus", (Object)String.valueOf(4), CompareType.EQUALS));
        if (startDate != null) {
            sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)startDate, CompareType.LESS_EQUALS));
        }
        if (endDate != null) {
            sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("invalidDate", (Object)endDate, CompareType.GREATER_EQUALS));
        }
        EntityViewInfo sustituteInfo = new EntityViewInfo();
        SorterItemInfo sorter = new SorterItemInfo("substituteSeq");
        sorter.setSortType(SortType.ASCEND);
        sustituteInfo.getSorter().add(sorter);
        sustituteInfo.setFilter(sustituteFilterInfo);
        sustituteInfo.getSelector().add(new SelectorItemInfo("parentEntry.unit.id"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("parentEntry.baseRate"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteSeq"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteProportion"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteQty"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("invalidDate"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("effectiveDate"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("isSubstituteQty"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("toBaseUnitRate"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("toBaseUnitQty"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("toParentBaseUnitRate"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteUnit.id"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteUnit.qtyPrecision"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteUnit.number"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteUnit.name"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteMaterial.id"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteMaterial.number"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteMaterial.name"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteMaterial.model"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteMaterial.status"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("substituteMaterial.baseUnit"));
        BomSubstituteCollection coll = BomSubstituteFactory.getRemoteInstance().getBomSubstituteCollection(sustituteInfo);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        ArrayList<MaterialSustituteVO> sustituteVOCollection = new ArrayList<MaterialSustituteVO>();
        for (BomSubstituteInfo bomSubstituteInfo : coll) {
            MaterialSustituteVO sustituteVO = new MaterialSustituteVO(bomSubstituteInfo);
            sustituteVOCollection.add(sustituteVO);
        }
        return sustituteVOCollection;
    }

    public static Collection loadMaterialSustitute(String materialId, String storageOrgUnitId) throws Exception {
        FilterInfo sustituteFilterInfo = new FilterInfo();
        sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("parent.material.id", (Object)materialId, CompareType.EQUALS));
        sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        sustituteFilterInfo.getFilterItems().add(new FilterItemInfo("parent.status", (Object)String.valueOf(20), CompareType.EQUALS));
        EntityViewInfo sustituteInfo = new EntityViewInfo();
        SorterItemInfo sorter = new SorterItemInfo("replaceSeq");
        sorter.setSortType(SortType.ASCEND);
        sustituteInfo.getSorter().add(sorter);
        sustituteInfo.setFilter(sustituteFilterInfo);
        sustituteInfo.getSelector().add(new SelectorItemInfo("replaceSeq"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("replacePercent"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("replaceQty"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("invalidDate"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("validDate"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("measureUnit.qtyPrecision"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("measureUnit.number"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("measureUnit.name"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("material.id"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("material.number"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("material.name"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("material.model"));
        sustituteInfo.getSelector().add(new SelectorItemInfo("material.baseUnit"));
        MaterialReplaceEntryCollection coll = MaterialReplaceEntryFactory.getRemoteInstance().getMaterialReplaceEntryCollection(sustituteInfo);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        ArrayList<MaterialSustituteVO> sustituteVOCollection = new ArrayList<MaterialSustituteVO>();
        for (MaterialReplaceEntryInfo materialReplaceEntryInfo : coll) {
            MaterialSustituteVO sustituteVO = new MaterialSustituteVO(materialReplaceEntryInfo);
            sustituteVOCollection.add(sustituteVO);
        }
        return sustituteVOCollection;
    }

    public static Collection loadMaterialSustitute(String materialId, String storageOrgUnitId, Date startDate, Date endDate) throws Exception {
        Collection sustituteVOCollection = ProductionOrderFactory.getRemoteInstance().loadMaterialSustitute(materialId, storageOrgUnitId, startDate, endDate);
        return sustituteVOCollection;
    }

    public static BigDecimal getInventorySurplusQty(String StorageOrgUnitId, String materialId, BigDecimal baseConvsRate, int qtyPrecision, Date endDate) throws Exception {
        BigDecimal canBeUseBaseQty = new BigDecimal(0);
        BigDecimal canBeUseQty = new BigDecimal(0);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo orgUnitFilter = new FilterItemInfo("STORAGEORGUNIT.ID", (Object)StorageOrgUnitId, CompareType.EQUALS);
        FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", (Object)materialId, CompareType.EQUALS);
        FilterItemInfo storeTypeFilter = new FilterItemInfo("STORETYPE.ID", (Object)"181875d5-0105-1000-e000-0111c0a812fd97D461A6", CompareType.EQUALS);
        FilterItemInfo storeStatusFilter = new FilterItemInfo("STORESTATUS.ID", (Object)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter1 = new FilterItemInfo("WAREHOUSE.transState", (Object)"1", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter2 = new FilterItemInfo("WAREHOUSE.transState", (Object)"2", CompareType.EQUALS);
        filter.getFilterItems().add(orgUnitFilter);
        filter.getFilterItems().add(materialFilter);
        filter.getFilterItems().add(storeTypeFilter);
        filter.getFilterItems().add(storeStatusFilter);
        filter.getFilterItems().add(warehouseStateFilter1);
        filter.getFilterItems().add(warehouseStateFilter2);
        filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5)");
        ev.setFilter(filter);
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setTableNether(true);
        vo.setViewInfo(ev);
        vo.setType("bottom");
        SCMLockInvDataVO tblInventoryVO = ProductionOrderFactory.getRemoteInstance().getMaterialInventory(vo, endDate, true);
        IObjectPK[] invIdList = tblInventoryVO.getInvIdList();
        Map inventoryMap = tblInventoryVO.getInventoryMap();
        String invID = null;
        int n = invIdList.length;
        for (int i = 0; i < n; ++i) {
            invID = invIdList[i].toString();
            InventoryInfo aInventoryInfo = (InventoryInfo)inventoryMap.get(invID);
            canBeUseBaseQty = canBeUseBaseQty.add(aInventoryInfo.getBaseQty());
        }
        canBeUseQty = canBeUseBaseQty.divide(baseConvsRate, qtyPrecision, 4);
        return canBeUseQty;
    }

    public static Map getInventorySurplusQty(String storageOrgUnitId, List materialIdList, Date endDate) throws Exception {
        BigDecimal canBeUseBaseQty = new BigDecimal(0);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet materialIds = new HashSet(materialIdList);
        HashMap<String, BigDecimal> InventorySurplusQtyMap = new HashMap<String, BigDecimal>();
        FilterItemInfo orgUnitFilter = new FilterItemInfo("STORAGEORGUNIT.ID", (Object)storageOrgUnitId, CompareType.EQUALS);
        FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", materialIds, CompareType.INCLUDE);
        FilterItemInfo storeTypeFilter = new FilterItemInfo("STORETYPE.ID", (Object)"181875d5-0105-1000-e000-0111c0a812fd97D461A6", CompareType.EQUALS);
        FilterItemInfo storeStatusFilter = new FilterItemInfo("STORESTATUS.ID", (Object)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter1 = new FilterItemInfo("WAREHOUSE.transState", (Object)"1", CompareType.EQUALS);
        FilterItemInfo warehouseStateFilter2 = new FilterItemInfo("WAREHOUSE.transState", (Object)"2", CompareType.EQUALS);
        filter.getFilterItems().add(orgUnitFilter);
        filter.getFilterItems().add(materialFilter);
        filter.getFilterItems().add(storeTypeFilter);
        filter.getFilterItems().add(storeStatusFilter);
        filter.getFilterItems().add(warehouseStateFilter1);
        filter.getFilterItems().add(warehouseStateFilter2);
        filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5)");
        ev.setFilter(filter);
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setTableNether(true);
        vo.setViewInfo(ev);
        vo.setType("bottom");
        SCMLockInvDataVO tblInventoryVO = ProductionOrderFactory.getRemoteInstance().getMaterialInventory(vo, endDate, true);
        IObjectPK[] invIdList = tblInventoryVO.getInvIdList();
        Map inventoryMap = tblInventoryVO.getInventoryMap();
        String invID = null;
        String materialId = null;
        String previousMaterialId = null;
        InventoryInfo aInventoryInfo = null;
        int n = invIdList.length;
        for (int i = 0; i < n; ++i) {
            invID = invIdList[i].toString();
            aInventoryInfo = (InventoryInfo)inventoryMap.get(invID);
            materialId = aInventoryInfo.getMaterial().getId().toString();
            if (previousMaterialId != null) {
                if (previousMaterialId.equals(materialId)) {
                    canBeUseBaseQty = canBeUseBaseQty.add(aInventoryInfo.getBaseQty());
                } else {
                    InventorySurplusQtyMap.put(previousMaterialId, canBeUseBaseQty);
                    canBeUseBaseQty = aInventoryInfo.getBaseQty();
                }
            } else {
                canBeUseBaseQty = aInventoryInfo.getBaseQty();
            }
            previousMaterialId = materialId;
        }
        InventorySurplusQtyMap.put(previousMaterialId, canBeUseBaseQty);
        return InventorySurplusQtyMap;
    }
}

