/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.app.LotRuleServerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.lot.BatchFileCollection;
import com.kingdee.eas.mm.lot.BatchFileEntryCollection;
import com.kingdee.eas.mm.lot.BatchFileEntryInfo;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.LotSourceEnum;
import com.kingdee.eas.mm.lot.LotTraceFacadeException;
import com.kingdee.eas.mm.lot.MMBatchIFileInfo;
import com.kingdee.eas.mm.lot.QueryTypeEnum;
import com.kingdee.eas.mm.lot.app.AbstractBatchFileControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BatchFileControllerBean
extends AbstractBatchFileControllerBean {
    private static final long serialVersionUID = 1L;
    private String RESOURCE_PATH = "com.kingdee.eas.mm.lot.BatchFileResource";
    private Map mapping = null;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.eraseBlank(model);
        this.checkEmpty(ctx, model);
        this.checkExist(ctx, model);
        return super._submit(ctx, model);
    }

    private void eraseBlank(IObjectValue model) {
        if (model == null) {
            return;
        }
        BatchFileInfo info = (BatchFileInfo)model;
        if (!MMUtils.isEmptyString((String)info.getLotNo())) {
            info.setLotNo(info.getLotNo().trim());
        }
        info.setBizDate(new Date());
        BatchFileEntryCollection entryColl = info.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            BatchFileEntryInfo entryInfo = entryColl.get(i);
            if (!MMUtils.isEmptyString((String)entryInfo.getLotNo())) {
                entryInfo.setLotNo(entryInfo.getLotNo().trim());
            }
            if (entryInfo.getTimes() < 1) {
                entryInfo.setTimes(1);
            }
            entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        }
    }

    public boolean isAutoNum() {
        return false;
    }

    public void checkExist(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BatchFileInfo info = (BatchFileInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)info.getStorageOrgUnit().getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("lotNo", (Object)info.getLotNo(), CompareType.EQUALS));
        boolean isNew = this.isAddNew(ctx, model);
        if (!isNew) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        boolean isExist = super._exists(ctx, filterInfo);
        StringBuffer errors = new StringBuffer();
        if (isExist) {
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"storageOrgUnit", (Locale)ctx.getLocale()));
            errors.append("[" + info.getStorageOrgUnit().getNumber() + "]").append("\n");
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"material", (Locale)ctx.getLocale()));
            errors.append("[" + info.getMaterial().getNumber() + "]").append("\n");
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"lotNo", (Locale)ctx.getLocale()));
            errors.append("[" + info.getLotNo() + "]").append("\n");
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"recordExist", (Locale)ctx.getLocale()));
        } else {
            BatchFileEntryCollection entrys = info.getEntries();
            MaterialInfo material = null;
            String lotNo = null;
            ArrayList totalDupList = new ArrayList();
            ArrayList<String> dupList = null;
            for (int i = 0; i < entrys.size(); ++i) {
                int j;
                dupList = new ArrayList<String>();
                lotNo = entrys.get(i).getLotNo();
                material = entrys.get(i).getMaterial();
                boolean flag = false;
                if (totalDupList.contains(String.valueOf(i))) continue;
                for (j = entrys.size() - 1; j >= 0; --j) {
                    if (j == i || !material.getNumber().equals(entrys.get(j).getMaterial().getNumber()) || !lotNo.equals(entrys.get(j).getLotNo())) continue;
                    flag = true;
                    dupList.add(String.valueOf(j));
                }
                if (!flag) continue;
                dupList.add(String.valueOf(i));
                totalDupList.addAll(dupList);
                errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"entryLine", (Locale)ctx.getLocale()));
                for (j = dupList.size() - 1; j >= 0; --j) {
                    if (j != 0) {
                        errors.append(Integer.parseInt(dupList.get(j).toString()) + 1 + "\uff0c");
                        continue;
                    }
                    errors.append(Integer.parseInt(dupList.get(j).toString()) + 1 + "");
                }
                errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"sameMaterialAndLotNo", (Locale)ctx.getLocale()));
                errors.append(" ");
            }
        }
        if (errors.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errors.toString());
            throw bizExp;
        }
    }

    public void checkEmpty(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BatchFileInfo info = (BatchFileInfo)model;
        BatchFileEntryCollection entryColl = info.getEntries();
        StringBuffer errors = new StringBuffer();
        if (null == info.getStorageOrgUnit()) {
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"storageOrgUnitIsNull", (Locale)ctx.getLocale())).append("\n");
        }
        if (null == info.getMaterial()) {
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"materialIsNull", (Locale)ctx.getLocale())).append("\n");
        }
        if (MMUtils.isEmptyString((String)info.getLotNo())) {
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"lotNoIsNull", (Locale)ctx.getLocale())).append("\n");
        }
        if (entryColl == null || entryColl.isEmpty()) {
            errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"entryIsNull", (Locale)ctx.getLocale())).append("\n");
        } else {
            String entryLine = ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"entryLine", (Locale)ctx.getLocale());
            String isNotNull = ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"IsNotNull", (Locale)ctx.getLocale());
            for (int i = 0; i < entryColl.size(); ++i) {
                if (entryColl.get(i).getMaterial() == null) {
                    errors.append(entryLine).append(i + 1).append("\uff1a");
                    errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"entryMaterial", (Locale)ctx.getLocale())).append("\u3001");
                }
                if (MMUtils.isEmptyString((String)entryColl.get(i).getLotNo())) {
                    if (errors.length() == 0 || errors.length() - 1 != errors.lastIndexOf("\u3001")) {
                        errors.append(entryLine).append(i + 1).append("\uff1a");
                    }
                    errors.append(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"entryLotNo", (Locale)ctx.getLocale())).append("\u3001");
                }
                if (errors.length() <= 0 || errors.length() - 1 != errors.lastIndexOf("\u3001")) continue;
                errors.deleteCharAt(errors.length() - 1);
                errors.append(isNotNull).append("\n");
            }
        }
        if (errors.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errors.toString());
            throw bizExp;
        }
    }

    protected boolean scmCheckNumberBlank(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return true;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return true;
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        return super.getMainBizOrgUnit(null, model);
    }

    @Override
    protected Map _getMaterialByProductBatch(Context ctx, List productIds, FilterInfo queryInfo) throws BOSException, EASBizException {
        HashMap<String, IRowSet> retVal = new HashMap<String, IRowSet>();
        if (productIds != null && !productIds.isEmpty()) {
            for (int i = 0; i < productIds.size(); ++i) {
                String productID = productIds.get(i).toString();
                if (StringUtils.isEmpty((String)productID)) continue;
                FilterInfo info = new FilterInfo();
                if (queryInfo != null) {
                    info.getFilterItems().addObjectCollection((IObjectCollection)queryInfo.getFilterItems());
                }
                info.getFilterItems().add(new FilterItemInfo("parentid", (Object)productID, CompareType.EQUALS));
                IRowSet rowSet = this._getMaterialByProduct(ctx, info);
                retVal.put(productID, rowSet);
            }
        }
        return retVal;
    }

    @Override
    protected List _getProductLotNo(Context ctx, FilterInfo queryInfo, FilterInfo commonFilterInfo, SorterItemCollection sorterItemCollection) throws BOSException, EASBizException {
        ArrayList<IRowSet> list = new ArrayList<IRowSet>();
        FilterItemInfo itemInfo = this.find(queryInfo.getFilterItems(), "treeLevel");
        IRowSet productSet = this.getProductOnlyLotNo(queryInfo, ctx, commonFilterInfo, sorterItemCollection);
        if (productSet == null || productSet.size() <= 0) {
            return null;
        }
        list.add(productSet);
        if (itemInfo != null && "treeLevel".equals(itemInfo.getPropertyName())) {
            IRowSet materialRowSet = this._getMaterialByProduct(ctx, queryInfo);
            list.add(materialRowSet);
        }
        return list;
    }

    private IRowSet getLotNoforTree(FilterInfo queryInfo, Context ctx) throws EASBizException {
        IRowSet iRowSet;
        Iterator it = queryInfo.getFilterItems().iterator();
        String storageOrgUnitID = null;
        String materialnumber = null;
        HashSet lotSet = new HashSet();
        Connection con = null;
        PreparedStatement statement = null;
        String name = this.getlocaleName();
        while (it.hasNext()) {
            FilterItemInfo filterItem = (FilterItemInfo)it.next();
            if (filterItem.getPropertyName() == null && filterItem.getPropertyName().length() == 0) continue;
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                storageOrgUnitID = filterItem.getCompareValue().toString();
                continue;
            }
            if ("materialNumber".equals(filterItem.getPropertyName())) {
                materialnumber = filterItem.getCompareValue().toString();
                continue;
            }
            if (!"lotNoStart".equals(filterItem.getPropertyName())) continue;
            if (filterItem.getCompareValue() instanceof String) {
                lotSet.add(filterItem.getCompareValue());
                continue;
            }
            lotSet = (HashSet)filterItem.getCompareValue();
        }
        try {
            IRowSet rowSet;
            String tableName = this.createLotTempTable(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into ").append(tableName);
            sql.append(" (fmaterialnumber,Fstorageorgunitid,flotNo)");
            sql.append(" values ( ?,?,? )");
            sql.append(" ");
            sql.append(" ");
            con = this.getConnection(ctx);
            statement = con.prepareStatement(sql.toString());
            for (int i = 0; i < lotSet.size(); ++i) {
                statement.setString(1, materialnumber);
                statement.setString(2, storageOrgUnitID);
                statement.setString(3, lotSet.toArray()[i].toString());
                statement.addBatch();
            }
            statement.executeBatch();
            sql.setLength(0);
            sql.append("Select  ");
            sql.append("  distinct '' as fid ,");
            sql.append("  a.Fstorageorgunitid as storageorgunitid, ");
            sql.append("  b.fid as materialid, ");
            sql.append("  b.fnumber as materialNumber, ");
            sql.append("  b." + name + "  as materialName, ");
            sql.append("  b.fmodel as modal, ");
            sql.append("  a.flotNo as lotno ");
            sql.append("  From  ").append(tableName).append(" as a ");
            sql.append("  inner join T_BD_material b  on a.fmaterialnumber = b.fnumber");
            iRowSet = rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            try {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONFETCHPRODUCT", e.getMessage()), e.getCause(), null);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        return iRowSet;
    }

    private String getlocaleName() {
        String name = "FName_L2";
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("US".equalsIgnoreCase(locale.getCountry())) {
            name = "FName_L1 ";
        } else if ("TW".equalsIgnoreCase(locale.getCountry())) {
            name = "FName_L3 ";
        } else if ("CN".equalsIgnoreCase(locale.getCountry())) {
            name = "FName_L2 ";
        }
        return name;
    }

    private String createLotTempTable(Context ctx) throws Exception {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table tmpLot(");
        createSql.append("  fmaterialnumber Nvarchar(80),");
        createSql.append("  Fstorageorgunitid  varchar(44),");
        createSql.append("  flotNo varchar(255)");
        createSql.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createSql.toString());
    }

    private FilterItemInfo find(FilterItemCollection filteritems, String key) {
        if (filteritems == null || key == null) {
            return null;
        }
        for (FilterItemInfo itemInfo : filteritems) {
            if (!key.equals(itemInfo.getPropertyName())) continue;
            return itemInfo;
        }
        return null;
    }

    private IRowSet getProductOnlyLotNo(FilterInfo queryInfo, Context ctx, FilterInfo commonFilterInfo, SorterItemCollection sorterItemCollection) throws EASBizException {
        try {
            String name = this.getlocaleName();
            StringBuffer sql = new StringBuffer();
            ArrayList<Date> params = new ArrayList<Date>();
            sql.append("Select    a.fid,   a.fstorageorgunitid as storageorgunitid,   b.fid as materialid,   b.fnumber as materialNumber,   b." + name + "  as materialName,   b.fmodel as modal,   a.flotNo as lotno,   to_char(a.fcreateTime,'YYYY-MM-DD') as lotDate  From   t_mm_batchFile a left join T_BD_material b on a.fmaterialid = b.fid Where  ");
            Iterator it = queryInfo.getFilterItems().iterator();
            boolean flag = false;
            while (it.hasNext()) {
                FilterItemInfo filterItem = (FilterItemInfo)it.next();
                if (filterItem.getPropertyName() == null && filterItem.getPropertyName().length() == 0) continue;
                if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                    flag = this.appendAndSQLByflag(sql, flag);
                    sql.append("   a.FstorageOrgUnitID = '" + filterItem.getCompareValue() + "' ");
                    continue;
                }
                if ("materialid".equals(filterItem.getPropertyName())) {
                    flag = this.appendAndSQLByflag(sql, flag);
                    sql.append("   a.Fmaterialid = '" + filterItem.getCompareValue() + "' ");
                    continue;
                }
                if ("lotNoStart".equals(filterItem.getPropertyName())) {
                    if (filterItem.getCompareValue() instanceof String) {
                        flag = this.appendAndSQLByflag(sql, flag);
                        sql.append("  a.FlotNo in ('" + filterItem.getCompareValue() + "')");
                        continue;
                    }
                    flag = this.appendAndSQLByflag(sql, flag);
                    sql.append("  a.FlotNo in " + MMUtils.setToString((Set)((Set)filterItem.getCompareValue())));
                    continue;
                }
                if ("startQueryDate".equals(filterItem.getPropertyName())) {
                    flag = this.appendAndSQLByflag(sql, flag);
                    sql.append("  a.fcreateTime>=?");
                    params.add((Date)filterItem.getCompareValue());
                    continue;
                }
                if ("endQueryDate".equals(filterItem.getPropertyName())) {
                    flag = this.appendAndSQLByflag(sql, flag);
                    sql.append("  a.fcreateTime<=?");
                    params.add((Date)filterItem.getCompareValue());
                    continue;
                }
                if (!"fid".equals(filterItem.getPropertyName())) continue;
                flag = this.appendAndSQLByflag(sql, flag);
                sql.append("  a.fid='" + ((String)filterItem.getCompareValue()).trim() + "'");
            }
            this.initMapping(name);
            if (commonFilterInfo != null) {
                this.replacePropertyName(commonFilterInfo);
                if (commonFilterInfo.toString() != null && !commonFilterInfo.toString().trim().equals("")) {
                    flag = this.appendAndSQLByflag(sql, flag);
                    sql.append(commonFilterInfo.toString());
                }
            }
            if (sorterItemCollection != null) {
                this.replaceSorterItemProperty(sorterItemCollection);
                if (sorterItemCollection.toString() != null && !sorterItemCollection.toString().trim().equals("")) {
                    sql.append(" order by " + sorterItemCollection.toString());
                }
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONFETCHPRODUCT", e.getMessage()), e.getCause(), null);
        }
    }

    private IRowSet updateRowSet(IRowSet rowSet) throws BOSException {
        try {
            IRowSetMetaData metaData = rowSet.getRowSetMetaData();
            DynamicRowSet dynamicRowSet = new DynamicRowSet(metaData.getColumnCount());
            String columnKey = null;
            int k = 0;
            while (rowSet.next()) {
                dynamicRowSet.moveToInsertRow();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    columnKey = metaData.getColumnName(i);
                    dynamicRowSet.setColInfo(i, new ColInfo(columnKey, columnKey, 12, null));
                    dynamicRowSet.updateString(columnKey, rowSet.getString(columnKey));
                }
                dynamicRowSet.insertRow();
                ++k;
            }
            if (k > 0) {
                dynamicRowSet.beforeFirst();
                return dynamicRowSet;
            }
            return rowSet;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void initMapping(String name) {
        this.mapping = new HashMap();
        this.mapping.put("material.number", "b.fnumber");
        this.mapping.put("material.name", "b." + name);
        this.mapping.put("material.model", "b.fmodel");
        this.mapping.put("lotNo", "a.flotNo");
        this.mapping.put("batchTime", "a.fcreatetime");
        this.mapping.put("storageOrgUnit.number", "a.fstorageOrgUnitId");
    }

    private void replacePropertyName(FilterInfo commonFilterInfo) {
        for (FilterItemInfo filterItem : commonFilterInfo.getFilterItems()) {
            if (filterItem.getPropertyName() == null && filterItem.getPropertyName().length() == 0) continue;
            if (this.mapping.containsKey(filterItem.getPropertyName()) && this.mapping.get(filterItem.getPropertyName()) != null) {
                filterItem.setPropertyName(this.mapping.get(filterItem.getPropertyName()).toString());
            }
            if (!this.mapping.containsKey(filterItem.getCompareValue()) || this.mapping.get(filterItem.getCompareValue()) == null) continue;
            filterItem.setCompareValue((Object)this.mapping.get(filterItem.getCompareValue()).toString());
        }
    }

    private void replaceSorterItemProperty(SorterItemCollection sorterItems) {
        for (int i = 0; i < sorterItems.size(); ++i) {
            SorterItemInfo sorter = sorterItems.get(i);
            if (sorter.getPropertyName() == null && sorter.getPropertyName().length() == 0 || !this.mapping.containsKey(sorter.getPropertyName()) || this.mapping.get(sorter.getPropertyName()) == null) continue;
            sorter.setPropertyName(this.mapping.get(sorter.getPropertyName()).toString());
        }
    }

    private boolean appendAndSQLByflag(StringBuffer sql, boolean flag) {
        if (flag) {
            sql.append(" and ");
        } else {
            flag = true;
        }
        return flag;
    }

    @Override
    protected IRowSet _getMaterialByProduct(Context ctx, FilterInfo queryInfo) throws EASBizException {
        Iterator it = queryInfo.getFilterItems().iterator();
        String stoargeOrgUnit = "";
        String lotNo = null;
        String material = null;
        String productLotNoId = null;
        QueryTypeEnum queryType = null;
        Object tblQueryType = null;
        while (it != null && it.hasNext()) {
            FilterItemInfo filterItem = (FilterItemInfo)it.next();
            if (filterItem.getPropertyName() == null && filterItem.getPropertyName().length() == 0) continue;
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                stoargeOrgUnit = (String)filterItem.getCompareValue();
                continue;
            }
            if ("materialid".equals(filterItem.getPropertyName())) {
                material = (String)filterItem.getCompareValue();
                continue;
            }
            if ("lotNo".equals(filterItem.getPropertyName())) {
                lotNo = (String)filterItem.getCompareValue();
                continue;
            }
            if ("parentid".equals(filterItem.getPropertyName())) {
                productLotNoId = (String)filterItem.getCompareValue();
                continue;
            }
            if ("queryType".equals(filterItem.getPropertyName())) {
                queryType = (QueryTypeEnum)((Object)filterItem.getCompareValue());
                continue;
            }
            if (!"tblQueryType".equals(filterItem.getPropertyName())) continue;
            tblQueryType = filterItem.getCompareValue();
        }
        switch (queryType.getValue()) {
            case 10: {
                return this.getFirstTierMaterialByProduct(ctx, productLotNoId);
            }
            case 20: {
                if (tblQueryType == null) {
                    return this.getMultTierMaterialByProduct(ctx, stoargeOrgUnit, lotNo, material);
                }
                return this.getFirstTierMaterialByProduct(ctx, productLotNoId);
            }
            case 30: {
                return this.getLastTierMaterialByProduct(ctx, productLotNoId);
            }
            case 40: {
                return this.getSumMaterialByProduct(ctx, productLotNoId);
            }
        }
        return null;
    }

    private IRowSet getSumMaterialByProduct(Context ctx, String productLotNoId) throws EASBizException {
        String result = this.createResultTempTable(ctx);
        int level = 1;
        String[] arrProductLotids = new String[]{productLotNoId};
        HashMap childrens = new HashMap();
        this.cycleTree(ctx, arrProductLotids, result, level, childrens);
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)("select FStorageOrgUnitID as StorageOrgUnitID , fbatchfileid as fid, fnumber as materialNumber, fname as materialName, fmodal as modal, flotno as lotNo, to_char(fbatchcreatetime,'YYYY-MM-DD') as lotDate  from " + result));
            this.dropTempTable(ctx, result);
            return rowset;
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONQRYSUMTIER", e.getMessage()), e.getCause(), null);
        }
    }

    private void cycleTree(Context ctx, String[] productLotNoIds, String result, int level, HashMap childrens) throws EASBizException {
        if (productLotNoIds == null || productLotNoIds.length <= 0) {
            return;
        }
        try {
            for (int i = 0; i < productLotNoIds.length; ++i) {
                StringBuffer sql = new StringBuffer();
                sql.append(" select  a.FStorageOrgUnitID as FStorageOrgUnitID, ");
                sql.append(" a.fid as fid,d.fid as materialid,d.fnumber as materialNumber,");
                sql.append(" d." + this.getFieldByLanague("fname") + "  as materialName,");
                sql.append(" d.fmodel as modal,b.flotNo as lotNo,a.fcreateTime as lotDate ");
                sql.append(" from t_mm_batchfileentry b left join t_bd_material d on b.fmaterialid = d.fid");
                sql.append(" left join t_mm_batchfile a on b.fmaterialid = a.fmaterialid and b.flotno = a.flotno");
                sql.append(" where  b.fparentid in ('" + productLotNoIds[i] + "')");
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String modal = null;
                Timestamp lotDate = null;
                while (rows != null && rows.next()) {
                    IRowSet rowids;
                    String materialid = rows.getString("materialid");
                    String lotNo = rows.getString("lotNo");
                    String materialNumber = rows.getString("materialNumber");
                    lotDate = rows.getTimestamp("lotDate");
                    String batchfileid = rows.getString("fid");
                    String materialName = rows.getString("materialName");
                    modal = rows.getString("modal");
                    String storageOrgUnitID = rows.getString("FStorageOrgUnitID");
                    if (materialid == null) continue;
                    if (childrens.get(materialid + lotNo) == null) {
                        childrens.put(materialid + lotNo, materialid + lotNo);
                        String insertSql = "insert into " + result + " values(" + (storageOrgUnitID != null ? "'" + storageOrgUnitID + "'" : null) + "," + (batchfileid != null ? "'" + batchfileid + "'" : null) + "," + (materialNumber != null ? "'" + materialNumber + "'" : null) + "," + (materialName != null ? "'" + materialName + "'" : null) + "," + (modal != null ? "'" + modal + "'" : null) + "," + (lotNo != null ? "'" + lotNo + "'" : null) + "," + (lotDate == null ? null : "?") + ")";
                        if (lotDate == null) {
                            DbUtil.execute((Context)ctx, (String)insertSql);
                        } else {
                            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Timestamp[]{lotDate});
                        }
                    }
                    StringBuffer querySql = new StringBuffer();
                    querySql.append("select a.fid from t_mm_batchfile a where a.fmaterialid='" + materialid + "'");
                    if (lotNo != null) {
                        querySql.append(" and a.flotno='" + lotNo + "'");
                    }
                    if ((rowids = DbUtil.executeQuery((Context)ctx, (String)querySql.toString())) == null) continue;
                    String[] ids = new String[rowids.size()];
                    int k = 0;
                    while (rowids.next()) {
                        ids[k] = rowids.getString("fid");
                        ++k;
                    }
                    if (++level > 30) {
                        throw new EASBizException(new NumericExceptionSubItem("TOODEEPLEVER", materialName + ";" + lotNo), null, null);
                    }
                    this.cycleTree(ctx, ids, result, level, childrens);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new EASBizException(new NumericExceptionSubItem("ERRORONQRYSUMTIER", e.getMessage()), e.getCause(), null);
        }
    }

    private IRowSet getLastTierMaterialByProduct(Context ctx, String productLotNoId) throws EASBizException {
        String result = this.createResultTempTable(ctx);
        String[] productids = new String[]{productLotNoId};
        int level = 1;
        this.cycleTree(ctx, productids, result, level);
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)("select  FStorageOrgUnitID as StorageOrgUnitID, fbatchfileid as fid, fnumber as materialNumber, fname as materialName, fmodal as modal, flotno as lotNo, to_char(fbatchcreatetime,'YYYY-MM-DD') as lotDate  from " + result));
            this.dropTempTable(ctx, result);
            return rowset;
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONQRYLASTTIER", e.getMessage()), e.getCause(), null);
        }
    }

    private void cycleTree(Context ctx, String[] productLotNoId, String result, int level) throws EASBizException {
        if (productLotNoId == null || productLotNoId.length <= 0) {
            return;
        }
        try {
            for (int i = 0; i < productLotNoId.length; ++i) {
                StringBuffer sql = new StringBuffer();
                sql.append(" select  a.FStorageOrgUnitID as FStorageOrgUnitID, a.fid as fid,d.fid as materialid,d.fnumber as materialNumber,d." + this.getFieldByLanague("fname") + "  as materialName,          d.fmodel as modal,b.flotNo as lotNo,a.fCreateTime as lotDate  from     t_mm_batchfileentry b left join t_bd_material d on b.fmaterialid = d.fid                                left join t_mm_batchfile a on b.fmaterialid = a.fmaterialid and b.flotno = a.flotno  where  b.fparentid in ('" + productLotNoId[i] + "')");
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rows != null && rows.next()) {
                    IRowSet rowids;
                    String modal = null;
                    Timestamp lotDate = null;
                    String lotNo = rows.getString("lotNo");
                    String materialid = rows.getString("materialid");
                    String materialNumber = rows.getString("materialNumber");
                    lotDate = rows.getTimestamp("lotDate");
                    String batchfileid = rows.getString("fid");
                    String materialName = rows.getString("materialName");
                    modal = rows.getString("modal");
                    String storageOrgUnitID = rows.getString("FStorageOrgUnitID");
                    if (materialid == null || materialid.length() <= 0) continue;
                    StringBuffer querySql = new StringBuffer();
                    querySql.append("select a.fid from t_mm_batchfile a where a.fmaterialid='" + materialid + "'");
                    if (lotNo != null) {
                        querySql.append(" and a.flotno='" + lotNo + "'");
                    }
                    if ((rowids = DbUtil.executeQuery((Context)ctx, (String)querySql.toString())) == null || rowids.size() <= 0) {
                        String insertSql = "insert into " + result + " values(" + (storageOrgUnitID != null ? "'" + storageOrgUnitID + "'" : null) + "," + (batchfileid != null ? "'" + batchfileid + "'" : null) + "," + (materialNumber != null ? "'" + materialNumber + "'" : null) + "," + (materialName != null ? "'" + materialName + "'" : null) + "," + (modal != null ? "'" + modal + "'" : null) + "," + (lotNo != null ? "'" + lotNo + "'" : null) + "," + (lotDate == null ? null : "?") + ")";
                        if (lotDate == null) {
                            DbUtil.execute((Context)ctx, (String)insertSql);
                            continue;
                        }
                        DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Timestamp[]{lotDate});
                        continue;
                    }
                    String[] ids = new String[rowids.size()];
                    int k = 0;
                    while (rowids.next()) {
                        ids[k] = rowids.getString("fid");
                        ++k;
                    }
                    if (++level > 30) {
                        throw new EASBizException(new NumericExceptionSubItem("TOODEEPLEVER", materialName + ";" + lotNo), null, null);
                    }
                    this.cycleTree(ctx, ids, result, level);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new EASBizException(new NumericExceptionSubItem("ERRORONQRYLASTTIER", e.getMessage()), e.getCause(), null);
        }
    }

    private IRowSet getMultTierMaterialByProduct(Context ctx, String stoargeOrgUnit, String lotNo, String material) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        String tmpTableName = this.createBatchFileTempTable(ctx);
        sql.append("select   u.fbatchfileid as fid,         c.fid as materialid,         c." + this.getFieldByLanague("fname") + " as materialName,         c.fnumber as materialNumber,   c.fmodel as modal,                  b.flotNo  as lotNo,  to_char(u.fbatchCreateTime,'YYYY-MM-DD') as lotDate  from             t_mm_batchfileentry b inner join t_mm_batchfile a on b.fparentid = a.fid and a.fmaterialid='" + material + "' and a.flotNo='" + lotNo + "' and a.FSTORAGEORGUNITID ='" + stoargeOrgUnit + "'                        left join t_bd_materialplan h on b.fmaterialid = h.fmaterialid and h.fmaterialattr=10030                                        left join t_bd_material c on b.fmaterialid = c.fid                        left join " + tmpTableName + " u on b.fmaterialid = u.fmaterialid and b.flotno = u.flotno");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            this.dropTempTable(ctx, tmpTableName);
            return rows;
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONQRYMULTTIER", e.getMessage()), e.getCause(), null);
        }
    }

    private IRowSet getFirstTierMaterialByProduct(Context ctx, String currentProductID) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        String tmpTableName = this.createBatchFileTempTable(ctx);
        sql.append("select  distinct a.FStorageOrgUnitID as StorageOrgUnitID,u.fid as fid,c.fid as materialid,c.fnumber as materialNumber,c." + this.getFieldByLanague("fname") + "  as materialName,            c.fmodel as modal,b.flotNo  as lotNo,to_char(u.fCreateTime,'YYYY-MM-DD') as lotDate    from     t_mm_batchfileentry b inner join t_mm_batchfile a on b.fparentid = a.fid and a.fid='" + currentProductID + "'                                  left join t_bd_materialplan h on b.fmaterialid = h.fmaterialid and h.fmaterialattr=10030                                  left join t_bd_material c on b.fmaterialid = c.fid                                  left join t_mm_batchfile u on b.fmaterialid = u.fmaterialid and b.flotno = u.flotno ");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            this.dropTempTable(ctx, tmpTableName);
            return rows;
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONQRYFIRSTTIER", e.getMessage()), e.getCause(), null);
        }
    }

    private String createResultTempTable(Context ctx) throws EASBizException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("create table tmpRet(   FStorageOrgUnitID varchar(44),   fbatchfileid varchar(44),   fnumber varchar(80),     fname varchar(80),   fmodal varchar(80),   flotNo varchar(255),   fbatchCreateTime timestamp )");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            return pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONCREATETEMPTABLE", e.getMessage()), e.getCause(), null);
        }
    }

    private String createBatchFileTempTable(Context ctx) throws EASBizException {
        StringBuffer createSql = new StringBuffer();
        StringBuffer insertSql = new StringBuffer();
        createSql.append("create table tmpBatchFile(  fbatchfileid varchar(44),  fmaterialid varchar(44),  fbatchCreateTime timestamp,  flotNo varchar(255))");
        String tableName = this.createTempTable(ctx, createSql.toString());
        insertSql.append("insert into " + tableName + " select aa.fid,aa.fmaterialid,aa.fcreateTime, aa.flotno from t_mm_batchfile aa ");
        try {
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            return tableName;
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONCREATETEMPTABLE", e.getMessage()), e.getCause(), null);
        }
    }

    private String createBatchFileEntryTempTable(Context ctx) throws EASBizException {
        StringBuffer createSql = new StringBuffer();
        StringBuffer insertSql = new StringBuffer();
        createSql.append("Create table tmpLastTier(  fbatchfileChildren varchar(44),  fmaterialid varchar(44),  fmaterialNumber varchar(80),  fmaterialName varchar(80),  fstorageOrgUnit varchar(44),  flotNo varchar(255))");
        String tmpName = this.createTempTable(ctx, createSql.toString());
        insertSql.append("insert into  " + tmpName + " select a.fid,b.fid,b.fnumber,b." + this.getFieldByLanague("fname") + ",a.fstorageorgunitid,a.flotNo from t_mm_batchfileentry a left join t_bd_material b on a.fmaterialid = b.fid where a.fid not in (select a.fid from t_mm_batchfileentry a,t_mm_batchfile b where a.fmaterialid =b.fmaterialid and a.flotno=b.flotno)");
        try {
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            return tmpName;
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONINSERTTMPTABLE", e.getMessage()), e.getCause(), null);
        }
    }

    private String createTempTable(Context ctx, String createSql) throws EASBizException {
        try {
            if (createSql == null || createSql.length() <= 0) {
                return null;
            }
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("ERRORONCREATETEMPTABLE", e.getMessage()), e.getCause(), null);
        }
    }

    private void dropTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    private String getFieldByLanague(String field) {
        String name = null;
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L1 ";
        } else if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L3 ";
        } else if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L2 ";
        }
        return name;
    }

    private void getNextBatchInfo(Context ctx, String batchFileId, MMBatchIFileInfo parent, List list, int level, Map bom) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("material.*");
        sic.add("entries.*");
        sic.add("entries.material.*");
        BatchFileInfo parentBatch = (BatchFileInfo)BatchFileFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(batchFileId), sic);
        if (bom.get(parentBatch.getMaterial().getId().toString()) == null) {
            return;
        }
        for (int i = 0; i < parentBatch.getEntries().size(); ++i) {
            BatchFileEntryInfo entryInfo = parentBatch.getEntries().get(i);
            String childIds = (String)bom.get(parentBatch.getMaterial().getId().toString());
            String[] childId = childIds.split("','");
            boolean isExist = false;
            for (int j = 0; j < childId.length; ++j) {
                if (childId[j] == null || !childId[j].trim().equals(entryInfo.getMaterial().getId().toString())) continue;
                isExist = true;
            }
            if (!isExist) continue;
            if (++level > 30) {
                ActionCommonException bizExp = new ActionCommonException(null);
                bizExp.setMessage(ResourceManage.getResource((String)this.RESOURCE_PATH, (String)"batchCircleLarge", (Locale)ctx.getLocale()));
                throw bizExp;
            }
            String sql = "select t1.fid from t_mm_batchfile t1,t_mm_batchfileEntry t2 where t1.fmaterialid = ? and t1.flotno = ? and (t2.fLotSource=10 or t2.ftimes>1)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{entryInfo.getMaterial().getId().toString(), entryInfo.getLotNo()});
            try {
                if (rs.next()) {
                    String batchID = rs.getString("fid");
                    MMBatchIFileInfo info = new MMBatchIFileInfo();
                    info.setId(BOSUuid.read((String)batchID));
                    info.setLevel(level);
                    info.setMaterial(entryInfo.getMaterial());
                    info.setLotNo(entryInfo.getLotNo());
                    info.setParentId(BOSUuid.read((String)batchFileId));
                    info.setParentMaterialId(BOSUuid.read((String)batchFileId));
                    list.add(info);
                    this.getNextBatchInfo(ctx, batchID, info, list, level, bom);
                    continue;
                }
                MMBatchIFileInfo info = new MMBatchIFileInfo();
                info.setId(null);
                info.setLevel(level);
                info.setMaterial(entryInfo.getMaterial());
                info.setLotNo(entryInfo.getLotNo());
                info.setParentId(BOSUuid.read((String)batchFileId));
                info.setParentMaterialId(BOSUuid.read((String)batchFileId));
                list.add(info);
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected List _getAllBatch(Context ctx, String storage, String material, String lotNo, Map bom) throws BOSException, EASBizException {
        ArrayList<MMBatchIFileInfo> list = new ArrayList<MMBatchIFileInfo>();
        EntityViewInfo env = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("material.*");
        sic.add("entries.*");
        sic.add("entries.material.*");
        env.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storage, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("lotNo", (Object)lotNo, CompareType.EQUALS));
        env.setFilter(filter);
        BatchFileCollection colls = BatchFileFactory.getLocalInstance(ctx).getBatchFileCollection(env);
        if (colls.size() > 0) {
            BatchFileInfo info = colls.get(0);
            BatchFileEntryCollection entryColls = info.getEntries();
            for (int i = 0; i < entryColls.size(); ++i) {
                if (!LotSourceEnum.manual.equals((Object)entryColls.get(i).getLotSource()) || entryColls.get(i).getTimes() > 1) continue;
                return list;
            }
            MMBatchIFileInfo topInfo = new MMBatchIFileInfo();
            topInfo.setId(info.getId());
            topInfo.setParentId(null);
            topInfo.setMaterial(info.getMaterial());
            topInfo.setLotNo(lotNo);
            topInfo.setLevel(1);
            topInfo.setParentMaterialId(null);
            if (bom == null || bom.get(material) == null) {
                return list;
            }
            list.add(topInfo);
            this.getNextBatchInfo(ctx, info.getId().toString(), topInfo, list, 1, bom);
        }
        return list;
    }

    protected boolean _checkOtherWhenDel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(model.get("id").toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.lotSource"));
        BatchFileInfo info = this.getBatchFileInfo(ctx, (IObjectPK)pk, selector);
        boolean canDelete = true;
        BatchFileEntryCollection coll = info.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            LotSourceEnum lotSource = coll.get(i).getLotSource();
            int times = coll.get(i).getTimes();
            if (times <= 1 && !LotSourceEnum.system.equals((Object)lotSource)) continue;
            canDelete = false;
            break;
        }
        if (!canDelete) {
            throw new LotTraceFacadeException(LotTraceFacadeException.CAN_BE_REMOVE2);
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet lotSourceTrace(Context ctx, FilterInfo queryInfo) throws BOSException {
        String storageOrgUnitID = null;
        String materialID = null;
        String lot = null;
        String tempTableNamelot = null;
        for (FilterItemInfo item : queryInfo.getFilterItems()) {
            if ("storageOrgUnitID".equals(item.getPropertyName())) {
                storageOrgUnitID = (String)item.getCompareValue();
                continue;
            }
            if ("materialid".equals(item.getPropertyName())) {
                materialID = (String)item.getCompareValue();
                continue;
            }
            if (!"lotNo".equals(item.getPropertyName())) continue;
            lot = (String)item.getCompareValue();
        }
        try {
            IRowSet rows;
            tempTableNamelot = this.LotTrace(ctx, storageOrgUnitID, materialID, lot);
            StringBuffer sql = new StringBuffer();
            sql.append(" select distinct ' ' as fid, t.fmaterialID as materialid ,material.fname_l2 as materialName,");
            sql.append(" material.fmodel as modal, t.flot as lotNo ,material.fnumber as materialNumber ");
            sql.append(" from ").append(tempTableNamelot).append(" as t ");
            sql.append(" inner join T_IM_ManufactureRecBill as m on m.fstorageorgunitID = t.FStorageOrgUnitID");
            sql.append(" inner join T_IM_ManufactureRecBillEntry as me on m.fid = me.fparentid and me.fmaterialid = t.fmaterialID");
            sql.append(" and me.flot = t.flot ");
            sql.append(" inner join T_BD_Material as material on material.fid = t.fmaterialID");
            IRowSet iRowSet = rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            this.dropTempTable(ctx, tempTableNamelot);
            return iRowSet;
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.dropTempTable(ctx, tempTableNamelot);
                throw throwable;
            }
        }
    }

    private String LotTrace(Context ctx, String storageOrgUnitID, String materialID, String lot) throws BOSException, SQLException {
        String tempTableNamelot = null;
        try {
            tempTableNamelot = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempTableLotTrace().toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTableNamelot);
        sql.append(" (FLevel,FStorageOrgUnitID,fmaterialID,Flotbefore,Flot)");
        sql.append(" values ( 1,'").append(storageOrgUnitID).append("','").append(materialID);
        sql.append("','").append(lot).append("','").append(lot).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        int i = 1;
        IRowSet rs = this.isExitNextLevellot(ctx, tempTableNamelot, storageOrgUnitID, i);
        while (rs.next() && rs.getInt(1) > 0 && i < 5) {
            sql.setLength(0);
            sql.append(" insert into ").append(tempTableNamelot);
            sql.append(" (FLevel,FStorageOrgUnitID,fmaterialID,Flotbefore,Flot )");
            sql.append(" (select ").append(i + 1).append(" as FLevel,mb.FStorageOrgUnitID as FStorageOrgUnitID,mb.fmaterialID as fmaterialID,");
            sql.append(" t.Flotbefore as Flot, mb.flot as Flotbefore ");
            sql.append(" from T_IM_MatAttrChangeAfterEntry  as ma ");
            sql.append(" inner join T_IM_MatAttrChangeBeforeEntry as mb on  mb.fid = ma.FParentID ");
            sql.append(" inner join T_IM_MatAttrChangeBill as m on m.fid = mb.FParentID");
            sql.append(" inner join ").append(tempTableNamelot).append(" as t on t.Flot = ma.flot ");
            sql.append(" where ma.fstorageOrgUnitID = '").append(storageOrgUnitID);
            sql.append("' and  ma.fmaterialID = '").append(materialID);
            sql.append("' and t.FLevel = ").append(i);
            sql.append(" and m.fbasestatus = ").append(4);
            sql.append(" ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            rs = this.isExitNextLevellot(ctx, tempTableNamelot, storageOrgUnitID, ++i);
        }
        return tempTableNamelot;
    }

    private IRowSet isExitNextLevellot(Context ctx, String tableName, String storageOrgUnitID, int level) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" SELECT count(b.flevel) ");
        sqlBuf.append(" from T_IM_MatAttrChangeAfterEntry a inner join ");
        sqlBuf.append(tableName);
        sqlBuf.append(" b on b.Flotbefore = a.flot  and b.FSTORAGEORGUNITID = a.FSTORAGEORGUNITID ");
        sqlBuf.append(" where b.FLevel = ?  and a.FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])new Object[]{new Integer(level)});
        return rs;
    }

    protected StringBuffer createTempTableLotTrace() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getLotTrace(");
        createTable.append("FLevel  int ");
        createTable.append(",FStorageOrgUnitID  varchar(44)");
        createTable.append(",fmaterialID varchar(44)");
        createTable.append(",fmaterialname nvarchar(255)");
        createTable.append(",fmodel nvarchar(255)");
        createTable.append(",Flotbefore nvarchar(80)");
        createTable.append(",Flot nvarchar(80)");
        createTable.append(")");
        return createTable;
    }

    @Override
    protected long _updateLotRuleAssign(Context ctx, String materialID, String storageOrgUnitID) throws BOSException, EASBizException {
        LotRuleInfo lotRule = MMUtils.getProperLotRule((Context)ctx, (String)materialID, (String)storageOrgUnitID);
        long currentSerial = LotRuleServerUtils.updateLotRuleAssign((Context)ctx, (String)materialID, (LotRuleInfo)lotRule);
        return currentSerial;
    }
}

