/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.lot.BatchFileCollection;
import com.kingdee.eas.mm.lot.BatchFileEntryCollection;
import com.kingdee.eas.mm.lot.BatchFileEntryInfo;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.IBatchFile;
import com.kingdee.eas.mm.lot.LotSourceEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class BatchFileDataTransmission
extends AbstractDataTransmission {
    public static String getResource(String strKey, Context ctx) {
        return ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.BatchFileResource", (String)strKey, (Locale)ctx.getLocale());
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BatchFileFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null || hsData.isEmpty()) {
            return null;
        }
        BatchFileInfo uiBatchInfo = new BatchFileInfo();
        Hashtable headData = (Hashtable)hsData.get(new Integer(0));
        String storageOrgUnitNumber = this.getDataString(headData, "storageOrgUnit.number");
        if (MMUtils.isEmptyString((String)storageOrgUnitNumber)) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("storageOrgUnitIsNull", ctx));
        }
        storageOrgUnitNumber = storageOrgUnitNumber.trim();
        String materialNumber = this.getDataString(headData, "material.number");
        if (MMUtils.isEmptyString((String)materialNumber)) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("materialIsNull", ctx));
        }
        materialNumber = materialNumber.trim();
        String lotNo = this.getDataString(headData, "lotNo");
        if (MMUtils.isEmptyString((String)lotNo)) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("lotNoIsNull", ctx));
        }
        if (lotNo.length() > 80) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("lotNoToLong", ctx));
        }
        lotNo = lotNo.trim();
        try {
            IBatchFile ibf = BatchFileFactory.getLocalInstance(ctx);
            EntityViewInfo env = new EntityViewInfo();
            env.getSelector().add("1");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)storageOrgUnitNumber));
            filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialNumber));
            filter.getFilterItems().add(new FilterItemInfo("lotNo", (Object)lotNo));
            env.setFilter(filter);
            BatchFileCollection bfc = ibf.getBatchFileCollection(env);
            if (bfc != null && bfc.size() > 0) {
                throw new TaskExternalException(BatchFileDataTransmission.getResource("batchFileExist", ctx));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        uiBatchInfo.setStorageOrgUnit(this.getStorageOrgUnitInfo(ctx, storageOrgUnitNumber));
        uiBatchInfo.setMaterial(this.getMaterialInfo(ctx, materialNumber, uiBatchInfo.getStorageOrgUnit(), true));
        uiBatchInfo.setLotNo(lotNo);
        uiBatchInfo.setCreateTime(new Timestamp(new Date().getTime()));
        uiBatchInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        this.checkMaterial(ctx, uiBatchInfo);
        return this.getInsertImportInfo(uiBatchInfo, hsData, ctx);
    }

    private void checkMaterial(Context ctx, BatchFileInfo info) throws TaskExternalException {
        MaterialPlanInfo plan;
        MaterialInventoryInfo inventory;
        boolean flag = false;
        if (info.getMaterial().getStatus().getValue() != 1) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("materialNotApproved", ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getStorageOrgUnit().getId().toString()));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        MaterialInventoryCollection inventoryColls = null;
        try {
            inventoryColls = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(env);
        }
        catch (BOSException e) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("getMaterialInventoryError", ctx));
        }
        if (inventoryColls != null && inventoryColls.size() > 0 && (inventory = inventoryColls.get(0)).getStatus().getValue() == 1 && inventory.isIsLotNumber()) {
            flag = true;
        }
        if (!flag) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("materialInventoryNotApproved", ctx));
        }
        MaterialPlanCollection planColls = null;
        try {
            planColls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(env);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        flag = false;
        if (planColls != null && planColls.size() > 0 && (plan = planColls.get(0)).getStatus().getValue() == 1 && (plan.getMaterialAttr().getValue() == 10030 || plan.getMaterialAttr().getValue() == 10050)) {
            flag = true;
        }
        if (!flag) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("materialPlanNotApproved", ctx));
        }
    }

    private void checkEntryMaterial(Context ctx, BatchFileInfo info, BatchFileEntryInfo entryInfo) throws TaskExternalException {
        MaterialPlanInfo plan;
        MaterialInventoryInfo inventory;
        boolean flag = false;
        if (entryInfo.getMaterial().getStatus().getValue() != 1) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("entryMaterialNotApproved", ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)entryInfo.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getStorageOrgUnit().getId().toString()));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        MaterialInventoryCollection inventoryColls = null;
        try {
            inventoryColls = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(env);
        }
        catch (BOSException e) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("getEntryMaterialInventoryError", ctx));
        }
        if (inventoryColls != null && inventoryColls.size() > 0 && (inventory = inventoryColls.get(0)).getStatus().getValue() == 1 && inventory.isIsLotNumber()) {
            flag = true;
        }
        if (!flag) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("entryMaterialInventoryNotApproved", ctx));
        }
        MaterialPlanCollection planColls = null;
        try {
            planColls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(env);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        flag = false;
        if (planColls != null && planColls.size() > 0 && (plan = planColls.get(0)).getStatus().getValue() == 1 && (plan.getMaterialAttr().getValue() == 10030 || plan.getMaterialAttr().getValue() == 10040 || plan.getMaterialAttr().getValue() == 10050)) {
            flag = true;
        }
        if (!flag) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("entryMaterialPlanNotApproved", ctx));
        }
    }

    private void checkImportData(BatchFileInfo info, Context ctx) throws TaskExternalException {
        OrgUnitInfo[] mainOrgs = null;
        boolean flag = false;
        try {
            mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), OrgType.Storage, "mm_batchfile_import");
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!mainOrgs[i].getId().toString().equals(info.getStorageOrgUnit().getId().toString())) continue;
                flag = true;
            }
            if (!flag) {
                throw new TaskExternalException(BatchFileDataTransmission.getResource("storageOrgUnit", ctx) + info.getStorageOrgUnit().getName() + BatchFileDataTransmission.getResource("storageOrgNotPermission", ctx));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private CoreBaseInfo getInsertImportInfo(BatchFileInfo info, Hashtable hsData, Context ctx) throws TaskExternalException {
        BatchFileEntryCollection entryColl = new BatchFileEntryCollection();
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable entryData = (Hashtable)hsData.get(new Integer(i));
            String entryMaterialNumber = this.getDataString(entryData, "entries.material.number");
            if (MMUtils.isEmptyString((String)entryMaterialNumber)) {
                throw new TaskExternalException(BatchFileDataTransmission.getResource("entryMaterialNumberIsNull", ctx));
            }
            entryMaterialNumber = entryMaterialNumber.trim();
            String entryLotNo = this.getDataString(entryData, "entries.lotNo");
            if (MMUtils.isEmptyString((String)entryLotNo)) {
                throw new TaskExternalException(BatchFileDataTransmission.getResource("entryLotNoIsNull", ctx));
            }
            if (entryLotNo.length() > 80) {
                throw new TaskExternalException(BatchFileDataTransmission.getResource("entryLotNoToLong", ctx));
            }
            entryLotNo = entryLotNo.trim();
            BatchFileEntryInfo entryInfo = new BatchFileEntryInfo();
            entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
            entryInfo.setParent(info);
            entryInfo.setMaterial(this.getMaterialInfo(ctx, entryMaterialNumber, info.getStorageOrgUnit(), false));
            entryInfo.setLotNo(entryLotNo);
            entryInfo.setLotSource(LotSourceEnum.manual);
            info.getEntries().add(entryInfo);
            entryColl.add(entryInfo);
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            BatchFileEntryInfo tempentryInfo = entryColl.get(i);
            this.checkEntryMaterial(ctx, info, tempentryInfo);
            for (int j = i + 1; j < entryColl.size(); ++j) {
                BatchFileEntryInfo tempentryInfo2 = entryColl.get(j);
                if (tempentryInfo.getMaterial() == null || !tempentryInfo.getMaterial().getNumber().trim().equals(tempentryInfo2.getMaterial().getNumber().trim()) || tempentryInfo.getLotNo() == null || !tempentryInfo.getLotNo().trim().equals(tempentryInfo2.getLotNo().trim())) continue;
                throw new TaskExternalException(BatchFileDataTransmission.getResource("EntryExistSameMaterialAndLotNo", ctx));
            }
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            BatchFileDataTransmission.putTable(result, "storageOrgUnit.number", rs.getString("storageOrgUnit.number"));
            BatchFileDataTransmission.putTable(result, "material.number", rs.getString("material.number"));
            BatchFileDataTransmission.putTable(result, "material.name", rs.getString("material.name"));
            BatchFileDataTransmission.putTable(result, "material.model", rs.getString("material.model"));
            BatchFileDataTransmission.putTable(result, "lotNo", rs.getString("lotNo"));
            BatchFileDataTransmission.putTable(result, "baseStatus", BillBaseStatusEnum.getEnum((int)rs.getInt("baseStatus")).getAlias());
            String createTime = rs.getString("createTime");
            if (!MMUtils.isEmptyString((String)createTime)) {
                createTime = createTime.substring(0, createTime.lastIndexOf("."));
                BatchFileDataTransmission.putTable(result, "createTime", createTime.substring(0, 10));
            }
            BatchFileDataTransmission.putTable(result, "entries.material.number", rs.getString("material1.number"));
            BatchFileDataTransmission.putTable(result, "entries.material.name", rs.getString("material1.name"));
            BatchFileDataTransmission.putTable(result, "entries.material.model", rs.getString("material1.model"));
            BatchFileDataTransmission.putTable(result, "entries.lotNo", rs.getString("entries.lotNo"));
            BatchFileDataTransmission.putTable(result, "entries.lotSource", LotSourceEnum.getEnum(rs.getInt("entries.lotSource")).getAlias());
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public int getSubmitType() {
        return 1;
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.ORMAPPING;
    }

    protected CoreBaseInfo toCoreBaseInfo(Context ctx, IRecord rec) {
        return null;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return firstData != null && currentData != null && firstData.get("storageOrgUnit.number").equals(currentData.get("storageOrgUnit.number")) && firstData.get("material.number").equals(currentData.get("material.number")) && firstData.get("lotNo").equals(currentData.get("lotNo"));
    }

    public static void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public StorageOrgUnitInfo getStorageOrgUnitInfo(Context ctx, String number) throws TaskExternalException {
        if (MMUtils.isEmptyString((String)number)) {
            return null;
        }
        OrgUnitInfo[] mainOrgs = null;
        boolean flag = false;
        try {
            mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), OrgType.Storage, "mm_batchfile_import");
        }
        catch (Exception e1) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("getStorageOrgError", ctx));
        }
        for (int i = 0; i < mainOrgs.length; ++i) {
            if (!mainOrgs[i].getNumber().toString().equals(number)) continue;
            flag = true;
            return (StorageOrgUnitInfo)mainOrgs[i];
        }
        if (!flag) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("storageOrgNotFound", ctx));
        }
        return null;
    }

    public MaterialInfo getMaterialInfo(Context ctx, String number, StorageOrgUnitInfo storageInfo, boolean isHead) throws TaskExternalException {
        MaterialCollection matCollection;
        if (MMUtils.isEmptyString((String)number)) {
            return null;
        }
        MaterialInfo materialInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        try {
            matCollection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(this.getViewInfo(filter));
        }
        catch (BOSException e1) {
            throw new TaskExternalException(BatchFileDataTransmission.getResource("getMaterialError", ctx));
        }
        if (null == matCollection || matCollection.size() <= 0) {
            if (isHead) {
                throw new TaskExternalException(BatchFileDataTransmission.getResource("productNotFound", ctx));
            }
            throw new TaskExternalException(BatchFileDataTransmission.getResource("materialNotFound", ctx));
        }
        materialInfo = matCollection.get(0);
        return materialInfo;
    }

    public EntityViewInfo getViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    protected String getDataString(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken == null) {
            Logger.info((String)(key + "not exist"));
            return null;
        }
        String number = (String)dataToken.data;
        return number;
    }
}

