/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.BatchFileEntryInfo;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.BillTypeEnum;
import com.kingdee.eas.mm.lot.LotParamValueFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.lot.LotSourceBillEntryInfo;
import com.kingdee.eas.mm.lot.LotSourceBillFactory;
import com.kingdee.eas.mm.lot.LotSourceBillInfo;
import com.kingdee.eas.mm.lot.LotTraceFacadeException;
import com.kingdee.eas.mm.lot.app.AbstractLotFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LotFacadeControllerBean
extends AbstractLotFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.lot.app.LotFacadeControllerBean");
    private static final String ISBATCHNO = "isBatchNo";
    private static final String LOTRULE = "lotRule";
    private static final String PRODUCTORDER_PLANNEDORDER = "productionOrderPlan";
    private static final String PRODUCTORDER_PRODUCEORDER = "productionOrderProduction";
    private static final String PRODUCTORDER_TASKDISPBILL = "productionOrderTaskDisp";
    private static final String PRODUCTORDER_FINISHREPORT = "productionOrderFinishedRpt";
    private static final String PRODUCTORDER_PROSEE = "productionOrderProsee";
    private static final String PRODUCTORDER_REC = "productionOrderRec";
    private static final String MANUFACURE_PLANNEDORDER = "manufactureOrderPlan";
    private static final String MANUFACURE_MANUFACTUREORDER = "manufactureOrder";
    private static final String MANUFACURE_REPORT = "manufactureReport";
    private static final String MANUFACURE_PROSEEE = "manufactureProseee";
    private static final String MANUFACURE_REC = "manufactureRec";
    private static final String LOT_IS_NOT = "isLotNULL";

    @Override
    protected Map _byBillTyperForLotParamValue(Context ctx, BillTypeEnum lotEnum, String orgId, String materialId, boolean isLotNumber) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        MaterialInventoryInfo materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialId, orgId);
        if (materialInventory != null && materialInventory.isIsLotNumber() && materialInventory.getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            LotParamValueInfo lotParamValueByOrg = (LotParamValueInfo)this._getLotParamValueByOrg(ctx, orgId);
            map.put(ISBATCHNO, Boolean.TRUE);
            if (lotParamValueByOrg != null) {
                switch (lotEnum.getValue()) {
                    case 1: {
                        map.put(MANUFACURE_PLANNEDORDER, new Boolean(lotParamValueByOrg.isManufacturePlan()));
                        this.commonParamValue(ctx, map, lotParamValueByOrg.isManufacturePlan(), isLotNumber, orgId, materialId);
                        break;
                    }
                    case 2: {
                        map.put(MANUFACURE_MANUFACTUREORDER, new Boolean(lotParamValueByOrg.isManufactureOrder()));
                        map.put(MANUFACURE_PROSEEE, new Boolean(lotParamValueByOrg.isManufactureProseee()));
                        map.put(MANUFACURE_REC, new Boolean(lotParamValueByOrg.isManufactureRec()));
                        this.commonParamValue(ctx, map, lotParamValueByOrg.isManufactureOrder(), isLotNumber, orgId, materialId);
                        break;
                    }
                    case 5: {
                        map.put(MANUFACURE_PROSEEE, new Boolean(lotParamValueByOrg.isManufactureProseee()));
                        map.put(MANUFACURE_REC, new Boolean(lotParamValueByOrg.isManufactureRec()));
                        map.put(MANUFACURE_REPORT, new Boolean(lotParamValueByOrg.isManufactureReport()));
                        this.commonParamValue(ctx, map, lotParamValueByOrg.isManufactureReport(), isLotNumber, orgId, materialId);
                        break;
                    }
                    case 3: {
                        map.put(PRODUCTORDER_PRODUCEORDER, new Boolean(lotParamValueByOrg.isProductionOrderProduction()));
                        map.put(PRODUCTORDER_PROSEE, new Boolean(lotParamValueByOrg.isProductionOrderProsee()));
                        map.put(PRODUCTORDER_REC, new Boolean(lotParamValueByOrg.isProductionOrderRec()));
                        this.commonParamValue(ctx, map, lotParamValueByOrg.isProductionOrderProduction(), isLotNumber, orgId, materialId);
                        break;
                    }
                    case 4: {
                        map.put(PRODUCTORDER_TASKDISPBILL, new Boolean(lotParamValueByOrg.isProductionOrderTaskDisp()));
                        map.put(PRODUCTORDER_PROSEE, new Boolean(lotParamValueByOrg.isProductionOrderProsee()));
                        map.put(PRODUCTORDER_REC, new Boolean(lotParamValueByOrg.isProductionOrderRec()));
                        this.commonParamValue(ctx, map, lotParamValueByOrg.isProductionOrderTaskDisp(), isLotNumber, orgId, materialId);
                        break;
                    }
                    case 6: {
                        map.put(PRODUCTORDER_FINISHREPORT, new Boolean(lotParamValueByOrg.isProductionOrderFinishedRpt()));
                        map.put(PRODUCTORDER_PROSEE, new Boolean(lotParamValueByOrg.isProductionOrderProsee()));
                        map.put(PRODUCTORDER_REC, new Boolean(lotParamValueByOrg.isProductionOrderRec()));
                        this.commonParamValue(ctx, map, lotParamValueByOrg.isProductionOrderFinishedRpt(), isLotNumber, orgId, materialId);
                    }
                }
            }
        } else {
            return null;
        }
        return map;
    }

    private void commonParamValue(Context ctx, Map map, boolean isCreate, boolean isLotNumber, String orgId, String materialId) throws EASBizException, BOSException {
        if (isCreate) {
            this.getLotFramRuleByUser(ctx, orgId, materialId, map, isLotNumber);
        }
        if (isCreate) {
            map.put(LOT_IS_NOT, Boolean.TRUE);
        } else {
            map.put(LOT_IS_NOT, Boolean.FALSE);
        }
    }

    @Override
    protected void _completionReportDeleteLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.COMPLETIONREPORT);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.COMPLETIONREPORT);
    }

    @Override
    protected Map _completionReportGetLot(Context ctx, String orgId, String materialId, boolean isLot) throws BOSException, EASBizException {
        return this._byBillTyperForLotParamValue(ctx, BillTypeEnum.COMPLETIONREPORT, orgId, materialId, isLot);
    }

    @Override
    protected void _completionReportInsertLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this._insertLot(ctx, ids, BillTypeEnum.COMPLETIONREPORT);
    }

    @Override
    protected void _finishedRptDeleteLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.FINISHREPORT);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.FINISHREPORT);
    }

    @Override
    protected Map _finishedRptGetLot(Context ctx, String orgId, String materailID, boolean isLotNumber) throws BOSException, EASBizException {
        return this._byBillTyperForLotParamValue(ctx, BillTypeEnum.FINISHREPORT, orgId, materailID, isLotNumber);
    }

    @Override
    protected void _finishedRptInsertLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this._insertLot(ctx, ids, BillTypeEnum.FINISHREPORT);
    }

    @Override
    protected void _manuDirectSendingDeleteLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.DDMRECEIVABILL_MANU);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.DDMRECEIVABILL_MANU);
    }

    @Override
    protected void _manuDirectSendingInsertLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.insertIntoLotSouceHead(ctx, ids, BillTypeEnum.DDMRECEIVABILL_MANU);
        this.insertLotSouceEntry(ctx, ids, BillTypeEnum.DDMRECEIVABILL_MANU);
    }

    @Override
    protected void _manufactuerOrderInsertLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.insertIntoLotSouceHead(ctx, ids, BillTypeEnum.MANUFACTUREORDER);
        this.insertLotSouceEntry(ctx, ids, BillTypeEnum.MANUFACTUREORDER);
    }

    @Override
    protected void _manufactureOrderDeleteLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.MANUFACTUREORDER);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.MANUFACTUREORDER);
    }

    @Override
    protected Map _manufactureOrderGetLot(Context ctx, String orgId, String materialID, boolean isLotNumber) throws BOSException, EASBizException {
        return this._byBillTyperForLotParamValue(ctx, BillTypeEnum.MANUFACTUREORDER, orgId, materialID, isLotNumber);
    }

    @Override
    protected String _generateLotNo(Context ctx, String matId, String orgUnitId, LotFrame lotFrame) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)matId) || StringUtils.isEmpty((String)orgUnitId)) {
            return "";
        }
        if (lotFrame == null || lotFrame.getLotRule() == null) {
            return "";
        }
        LotFrameManu lotFrameManu = new LotFrameManu();
        lotFrameManu.setSeq(lotFrame.getSeq());
        lotFrameManu.setSysDate(lotFrame.getSysDate());
        lotFrameManu.setBizDate(new Date());
        lotFrameManu.setCurrentSerial(lotFrame.getCurrentSerial());
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)StorageOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(orgUnitId));
        lotFrameManu.setMainBizOrg(storage.getNumber());
        MaterialInfo material = (MaterialInfo)MaterialFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(matId));
        lotFrameManu.setMaterial(material.getNumber());
        lotFrameManu.setLotRule(lotFrame.getLotRule());
        return lotFrameManu.getLotNumber();
    }

    @Override
    protected void _plannedorderDeleteLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.PLANNEDORDER);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.PLANNEDORDER);
    }

    @Override
    protected Map _plannedorderGetLot(Context ctx, String orgId, String materialId, boolean isLotNumber) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        MaterialInventoryInfo materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialId, orgId);
        if (materialInventory != null && materialInventory.isIsLotNumber() && materialInventory.getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            map.put(ISBATCHNO, Boolean.TRUE);
            LotParamValueInfo lotParamValueByOrg = (LotParamValueInfo)this._getLotParamValueByOrg(ctx, orgId);
            if (lotParamValueByOrg != null) {
                map.put(MANUFACURE_PLANNEDORDER, new Boolean(lotParamValueByOrg.isManufacturePlan()));
                if (lotParamValueByOrg.isManufacturePlan()) {
                    this.getLotFramRuleByUser(ctx, orgId, materialId, map, isLotNumber);
                }
            } else {
                map.put(MANUFACURE_PLANNEDORDER, Boolean.FALSE);
            }
        } else {
            return null;
        }
        return map;
    }

    private void getLotFramRuleByUser(Context ctx, String orgId, String materialId, Map map, boolean isLotNumber) throws EASBizException, BOSException {
        ArrayList<LotFrame> lotFrameList = new ArrayList<LotFrame>();
        LotFrame lotFrame = new LotFrame();
        lotFrame.setMaterial(materialId);
        lotFrame.setMainBizOrg(orgId);
        lotFrameList.add(lotFrame);
        List list = null;
        list = isLotNumber ? LotRuleFactory.getLocalInstance((Context)ctx).fillLotFrames(lotFrameList) : LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotFrameList);
        if (list != null && list.size() > 0) {
            lotFrame = (LotFrame)list.get(0);
            map.put(LOTRULE, lotFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _plannedorderInsertLotSource(Context ctx, String[] ids) throws BOSException {
        String tmpTable = this.insertdata(ctx, ids);
        try {
            this.insertplanIntoLotSouceHead(ctx, tmpTable, BillTypeEnum.PLANNEDORDER);
            this.insertPlanLotSouceEntry(ctx, tmpTable, BillTypeEnum.PLANNEDORDER);
        }
        finally {
            if (tmpTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
            }
        }
    }

    private String insertdata(Context ctx, String[] ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table purorder (fid varchar(44) ");
        sql.append(",CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" insert into ").append(table);
        sql.append(" (fid) values (?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                stmt.setString(1, ids[i]);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return table;
    }

    @Override
    protected void _proDirectSendingDeleteLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.DDMRECEIVALBILL_PRO);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.DDMRECEIVALBILL_PRO);
    }

    @Override
    protected void _proDirectSendingInsertLotSource(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.insertIntoLotSouceHead(ctx, ids, BillTypeEnum.DDMRECEIVALBILL_PRO);
        this.insertLotSouceEntry(ctx, ids, BillTypeEnum.DDMRECEIVALBILL_PRO);
    }

    @Override
    protected void _productionOrderDeleteLotSouce(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.PRODUCTIONORDER);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.PRODUCTIONORDER);
    }

    @Override
    protected Map _productionOrderGetLot(Context ctx, String orgId, String materialID, boolean isLotNumber) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        MaterialInventoryInfo materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialID, orgId);
        if (materialInventory != null && materialInventory.isIsBatchNo() && materialInventory.getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            map.put(ISBATCHNO, Boolean.TRUE);
            LotParamValueInfo lotParamValueByOrg = (LotParamValueInfo)this._getLotParamValueByOrg(ctx, orgId);
            if (lotParamValueByOrg != null) {
                map.put(PRODUCTORDER_PLANNEDORDER, new Boolean(lotParamValueByOrg.isProductionOrderPlan()));
                map.put(PRODUCTORDER_PRODUCEORDER, new Boolean(lotParamValueByOrg.isProductionOrderProduction()));
                map.put(PRODUCTORDER_PROSEE, new Boolean(lotParamValueByOrg.isProductionOrderProsee()));
                if (lotParamValueByOrg.isProductionOrderProduction() && isLotNumber) {
                    LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrame(materialID, orgId);
                    map.put(LOTRULE, (Boolean)lotFrame);
                }
            } else {
                map.put(PRODUCTORDER_PLANNEDORDER, Boolean.FALSE);
                map.put(PRODUCTORDER_PRODUCEORDER, Boolean.FALSE);
                map.put(PRODUCTORDER_PROSEE, Boolean.FALSE);
            }
        } else {
            return null;
        }
        return map;
    }

    @Override
    protected void _productionOrderInsertLotSouce(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.insertIntoLotSouceHead(ctx, ids, BillTypeEnum.PRODUCTIONORDER);
        this.insertLotSouceEntry(ctx, ids, BillTypeEnum.PRODUCTIONORDER);
    }

    private void deleteLotSourceEntry(Context ctx, String[] ids, BillTypeEnum lotEnum) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("delete from T_MM_LotSourceBillEntry where  FBillId in(");
        insertSql.append(id).append(")");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void deleteLotSourceHead(Context ctx, String[] ids, BillTypeEnum lotEnum) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("delete from T_MM_LotSourceBill where  fid  in(");
        insertSql.append("select lotsource.fid from ");
        switch (lotEnum.getValue()) {
            case 1: {
                insertSql.append(" t_mm_plannedorder as billTable ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
            case 2: {
                insertSql.append(" T_MM_ManufactureOrder as billTable ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
            case 3: {
                insertSql.append(" T_MM_ProductionOrder as billTable ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLotNo =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
            case 4: {
                insertSql.append(" t_mm_TaskDispBill as billTable ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLotNo =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
            case 5: {
                insertSql.append(" T_MM_CompletionReport as billTable ");
                insertSql.append(" left outer join T_MM_CompletionRES  as  CompletionRESENTRY ");
                insertSql.append(" \ton billTable.fid = CompletionRESENTRY.FParentID ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and CompletionRESENTRY.FMaterialID = lotsource. FMaterialID ");
                insertSql.append(" and CompletionRESENTRY.FBatchSeq =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
            case 6: {
                insertSql.append(" T_MM_FinishedRpt as billTable ");
                insertSql.append(" left outer join T_MM_FinishedRptEntry  as  FinishedRptEntry ");
                insertSql.append(" \ton billTable.fid = FinishedRptEntry.FParentID ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and FinishedRptEntry.FMaterialID = lotsource. FMaterialID ");
                insertSql.append(" and FinishedRptEntry.FLotNo =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
            case 7: {
                insertSql.append(" T_MM_DirectDeliveryBill as billTable ");
                insertSql.append(" left outer join T_MM_DirectSource  as  DirectSourceEntry ");
                insertSql.append(" \ton billTable.fid = DirectSourceEntry.FParentID ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and DirectSourceEntry.FMaterialID = lotsource. FMaterialID ");
                insertSql.append(" and DirectSourceEntry.FLotNo =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
            case 8: {
                insertSql.append(" T_MM_DDMReceivalBill as billTable ");
                insertSql.append(" left outer join T_MM_DDMReceivalBillEntry  as  DDMReceivalBillEntry  ");
                insertSql.append(" \ton billTable.fid = DDMReceivalBillEntry .FParentID ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource ");
                insertSql.append("  on billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and DDMReceivalBillEntry .FMaterialID = lotsource. FMaterialID ");
                insertSql.append(" and DDMReceivalBillEntry .FLotNumber =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotSourceBillEntry as entry on lotsource.fid  = entry. FParentID ");
                insertSql.append("where  lotsource.fid  is not null and entry.fid is null  and billtable.fid in (");
                insertSql.append(id);
                insertSql.append("))");
                break;
            }
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void insertPlanLotSouceEntry(Context ctx, String tmpTable, BillTypeEnum lotEnum) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_MM_LotSourceBillEntry  ");
        insertSql.append("(fid,FParentID,FNumber,FBillType,FBillId,FBaseUnitID,FBaseQty,");
        insertSql.append("FUnitID,FQty,FManfauctuerNumber,FManufacureOrderID,FDisTaskDispatchID,FOperationID,");
        insertSql.append("FOperationNo,FProduceBillNumber,FProductionOrderID,FTaskDispBillID,FProductLineWPID,");
        insertSql.append("FProductLineID,FClassGroupID,FWorkShopID,FBizTypeID,FBizDate,FCreaterID,");
        insertSql.append("FCreateTime,fmmbiztype) ");
        insertSql.append("select newbosid('").append(new LotSourceBillEntryInfo().getBOSType()).append("') as fid,");
        insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
        insertSql.append(1);
        insertSql.append(" as FBillType, billTable.fid as FBillId, billTable.FUnitID as FBaseUnitID,");
        insertSql.append(" billTable.FBaseQty as FBaseQty,billTable.FProductUnitID as  FUnitID,");
        insertSql.append("billTable.FQty as FQty, null as FManfauctuerNumber,");
        insertSql.append("null as FManufacureOrderID, null as FDisTaskDispatchID ,null as FOperationID, ");
        insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
        insertSql.append("null as FProductionOrderID,null as FTaskDispBillID, null as FProductLineWPID,");
        insertSql.append("null as FProductLineID,null as FClassGroupID,");
        insertSql.append("billTable.FAdminOrgUnitID as FWorkShopID,null as FBizTypeID,");
        insertSql.append("  to_date(to_char(billTable.FStartDate,'yyyy-mm-dd')||' 00:00:00')  as FBizDate,'");
        insertSql.append(ctx.getCaller().toString());
        insertSql.append("' AS FCreaterID, NOW() AS FCreateTime, 0 as fmmbiztype ");
        insertSql.append(" from ");
        insertSql.append(" t_mm_plannedorder as billTable  ");
        insertSql.append(" inner join ").append(tmpTable);
        insertSql.append(" as tmp on tmp.fid = billTable.fid ");
        insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on ");
        insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
        insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
        insertSql.append(" where lotsource.FMaterialID is not null ");
        logger.info((Object)("-------------" + insertSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void insertLotSouceEntry(Context ctx, String[] ids, BillTypeEnum lotEnum) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_MM_LotSourceBillEntry  ");
        insertSql.append("(fid,FParentID,FNumber,FBillType,FBillId,FBaseUnitID,FBaseQty,");
        insertSql.append("FUnitID,FQty,FManfauctuerNumber,FManufacureOrderID,FDisTaskDispatchID,FOperationID,");
        insertSql.append("FOperationNo,FProduceBillNumber,FProductionOrderID,FTaskDispBillID,FProductLineWPID,");
        insertSql.append("FProductLineID,FClassGroupID,FWorkShopID,FBizTypeID,FBizDate,FCreaterID,");
        insertSql.append("FCreateTime,fmmbiztype) ");
        insertSql.append("select newbosid('").append(new LotSourceBillEntryInfo().getBOSType()).append("') as fid,");
        this.buildInsertEntrySql(ctx, insertSql, lotEnum);
        insertSql.append("where lotsource.FMaterialID is not null and billTable.fid in(");
        insertSql.append(id);
        insertSql.append(") ");
        this.buildfilterSql(insertSql, lotEnum);
        logger.info((Object)("-------------" + insertSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private StringBuffer buildfilterSql(StringBuffer insertSql, BillTypeEnum lotEnum) {
        if (lotEnum.equals((Object)BillTypeEnum.MANUFACTUREORDER)) {
            insertSql.append(" and billtable.flot <> isnull(t2.flot,'0')  ");
        } else if (lotEnum.equals((Object)BillTypeEnum.PRODUCTIONORDER)) {
            insertSql.append(" and billtable.FLotNo <> isnull(t2.flot,'0')  ");
        } else if (lotEnum.equals((Object)BillTypeEnum.TASKDISPBILL)) {
            insertSql.append(" and billtable.FLotNo <> isnull(t2.FLotNo,'0')  ");
        } else if (lotEnum.equals((Object)BillTypeEnum.COMPLETIONREPORT)) {
            insertSql.append(" and LotParam.FManufactureReport=1  and ENTRY.FBatchSeq  <> isnull(t2.FLot,'0') ");
        } else if (lotEnum.equals((Object)BillTypeEnum.FINISHREPORT)) {
            insertSql.append(" and ENTRY.FLotNo <> isnull( t4.FLotNo,'0') ");
        }
        return insertSql;
    }

    private String[] isDesideCreate(Context ctx, String[] id, BillTypeEnum lotEnum) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        HashSet<String> idSet = new HashSet<String>();
        if (!lotEnum.equals((Object)BillTypeEnum.COMPLETIONREPORT) && lotEnum.equals((Object)BillTypeEnum.FINISHREPORT)) {
            insertSql.setLength(0);
            insertSql.append("select billtable.fid  ");
            insertSql.append(" from ");
            insertSql.append(" T_MM_FinishedRpt as billTable  ");
            insertSql.append(" left outer join T_MM_ProductionOrder as t4 on billTable.FProductionOrderID=t4.fid ");
            insertSql.append(" left outer join T_MM_FinishedRptEntry  as  ENTRY ");
            insertSql.append(" on billTable.fid = ENTRY.FParentID ");
            insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
            insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and  ENTRY.FMaterialID =MI.FMaterialID  ");
            insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on");
            insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
            insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID  and ENTRY.FLotNo =lotsource.FLOT ");
            insertSql.append(" where MI.FIsLotNumber=1 and  ENTRY.FLotNo  is not null ");
            insertSql.append(" and  billTable.fid  in (");
            insertSql.append(SQLUtil.arrayToString((Object[])id));
            insertSql.append(")  ");
            insertSql.append(" and ENTRY.FLotNo  <> isnull(t4.FLotNo,'0') ");
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"0_LotFacadeControllerBean", (Locale)ctx.getLocale()) + insertSql.toString() + "-----------------"));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)insertSql.toString());
            String fid = null;
            try {
                while (rs.next()) {
                    fid = rs.getString("fid");
                    if (idSet.contains(fid)) continue;
                    idSet.add(fid);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            insertSql.setLength(0);
            insertSql.append("select billtable.fid  ");
            insertSql.append(" from ");
            insertSql.append(" T_MM_FinishedRpt as billTable  ");
            insertSql.append(" left outer join t_mm_TaskDispBill as t4 on billTable.FProductionOrderID=t4.fid ");
            insertSql.append(" left outer join T_MM_FinishedRptEntry  as  ENTRY ");
            insertSql.append(" on billTable.fid = ENTRY.FParentID ");
            insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
            insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and  ENTRY.FMaterialID =MI.FMaterialID  ");
            insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on");
            insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
            insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID  and ENTRY.FLotNo =lotsource.FLOT ");
            insertSql.append(" where MI.FIsLotNumber=1 and  ENTRY.FLotNo  is not null ");
            insertSql.append(" and  billTable.fid  in (");
            insertSql.append(SQLUtil.arrayToString((Object[])id));
            insertSql.append(")  ");
            insertSql.append(" and ENTRY.FLotNo  <> isnull(t4.FLotNo,'0') ");
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"1_LotFacadeControllerBean", (Locale)ctx.getLocale()) + insertSql.toString() + "-----------------"));
            rs = DbUtil.executeQuery((Context)ctx, (String)insertSql.toString());
            fid = null;
            try {
                while (rs.next()) {
                    fid = rs.getString("fid");
                    if (idSet.contains(fid)) continue;
                    idSet.add(fid);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            String[] ids = new String[idSet.size()];
            idSet.toArray(ids);
            id = ids;
        }
        return id;
    }

    private StringBuffer buildInsertEntrySql(Context ctx, StringBuffer insertSql, BillTypeEnum lotEnum) {
        switch (lotEnum.getValue()) {
            case 1: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(1);
                insertSql.append(" as FBillType, billTable.fid as FBillId, billTable.FUnitID as FBaseUnitID,");
                insertSql.append(" billTable.FBaseQty as FBaseQty,billTable.FProductUnitID as  FUnitID,");
                insertSql.append("billTable.FQty as FQty, null as FManfauctuerNumber,");
                insertSql.append("null as FManufacureOrderID, null as FDisTaskDispatchID ,null as FOperationID, ");
                insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("null as FProductionOrderID,null as FTaskDispBillID, null as FProductLineWPID,");
                insertSql.append("null as FProductLineID,null as FClassGroupID,");
                insertSql.append("billTable.FAdminOrgUnitID as FWorkShopID,null as FBizTypeID,");
                insertSql.append("  to_date(to_char(billTable.FStartDate,'yyyy-mm-dd')||' 00:00:00')  as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime, 0 as fmmbiztype ");
                insertSql.append(" from ");
                insertSql.append(" t_mm_plannedorder as billTable   left  outer join  T_MM_LotSourceBill as lotsource  on ");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
                break;
            }
            case 2: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(2);
                insertSql.append(" as FBillType, billTable.fid as FBillId, billTable.FBaseUnitID as FBaseUnitID,");
                insertSql.append(" billTable.FBaseQty as FBaseQty,billTable.FUnitID as  FUnitID,");
                insertSql.append("billTable.FQty as FQty, null as FManfauctuerNumber,");
                insertSql.append("null as FManufacureOrderID,null as FDisTaskDispatchID,null as FOperationID, ");
                insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("null as FProductionOrderID,null as FTaskDispBillID, null as FProductLineWPID,");
                insertSql.append("null as FProductLineID,null as FClassGroupID,");
                insertSql.append("billTable.FAdminOrgUnitID as FWorkShopID,billTable.FBizTypeID as FBizTypeID,");
                insertSql.append("  billTable.FBizDate as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime , 0 as fmmbiztype ");
                insertSql.append(" from ");
                insertSql.append(" T_MM_ManufactureOrder as billTable    ");
                insertSql.append(" left outer join t_mm_plannedorder  as t2 on billTable.FSourceBillID = t2.fid ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
                break;
            }
            case 3: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(3);
                insertSql.append(" as FBillType, billTable.fid as FBillId, billTable.FBaseUnitID as FBaseUnitID,");
                insertSql.append(" billTable.FBaseQty as FBaseQty,billTable.FUnitID as  FUnitID,");
                insertSql.append("billTable.FQty as FQty, null as FManfauctuerNumber,");
                insertSql.append("null as FManufacureOrderID,null as FDisTaskDispatchID,null as FOperationID, ");
                insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("null as FProductionOrderID,null as FTaskDispBillID, null as FProductLineWPID,");
                insertSql.append("billTable.FProductLineID  as FProductLineID,billTable.FClassGroupID as FClassGroupID,");
                insertSql.append("billTable.FWorkShopID as FWorkShopID,null as FBizTypeID,");
                insertSql.append("  billTable.FBizDate as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime , billTable.FMmBizType as fmmbiztype");
                insertSql.append(" from ");
                insertSql.append(" T_MM_ProductionOrder as billTable  ");
                insertSql.append(" left outer join t_mm_plannedorder  as t2 on billTable.FSourceBillID = t2.fid ");
                insertSql.append("  left  outer join  T_MM_LotSourceBill as lotsource  on  ");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLotNo =lotsource.FLOT ");
                break;
            }
            case 4: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(4);
                insertSql.append(" as FBillType, billTable.fid as FBillId, billTable.FBaseUnitID as FBaseUnitID,");
                insertSql.append(" billTable.FBaseProductQty as FBaseQty,billTable.FUnitID as  FUnitID,");
                insertSql.append("billTable.FProductQty as FQty, null as FManfauctuerNumber,");
                insertSql.append("null as FManufacureOrderID,null as FDisTaskDispatchID,null as FOperationID, ");
                insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("null as FProductionOrderID,null as FTaskDispBillID, null as FProductLineWPID,");
                insertSql.append("billTable.FProductLineID  as FProductLineID,billTable.FClassGroupID as FClassGroupID,");
                insertSql.append("billTable.FWorkShopID as FWorkShopID,null as FBizTypeID,");
                insertSql.append("  billTable.FCreateTime as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime , billTable.FBusinessType as fmmbiztype ");
                insertSql.append(" from ");
                insertSql.append(" t_mm_TaskDispBill as billTable    ");
                insertSql.append(" left outer join T_MM_ProductionOrder  as t2 on billTable.FSourceBillID = t2.fid ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on ");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource.FMaterialID  and billTable.FLotNo =lotsource.FLOT ");
                break;
            }
            case 5: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(5);
                insertSql.append(" as FBillType, billTable.fid as FBillId, ENTRY.FbaseUnitID as FBaseUnitID,");
                insertSql.append("ENTRY.FCompleteBaseAmount as FBaseQty,ENTRY.FUnitID as  FUnitID,");
                insertSql.append("ENTRY.fcompleteAmount as FQty, billTable.FDmesorderNumber as FManfauctuerNumber,");
                insertSql.append("billTable.FDmesOrderID as FManufacureOrderID,billTable.FDispatchWorkID as FDisTaskDispatchID,");
                insertSql.append("billTable.FProcessID as FOperationID, ");
                insertSql.append("billTable.FopNo as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("null as FProductionOrderID, null as FTaskDispBillID,null as FProductLineWPID,");
                insertSql.append("null as FProductLineID,null as FClassGroupID,");
                insertSql.append("billTable.FDepartMentID as FWorkShopID,null as FBizTypeID,");
                insertSql.append(" to_date(to_char(billTable.FReportTime,'yyyy-mm-dd')||' 00:00:00') as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime , 0 as fmmbiztype ");
                insertSql.append(" from ");
                insertSql.append(" T_MM_CompletionReport as billTable  ");
                insertSql.append("left outer join T_MM_ManufactureOrder  as t2 ");
                insertSql.append(" on billTable.FDmesOrderID = t2.fid  ");
                insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
                insertSql.append(" left outer join T_MM_CompletionRES  as  ENTRY ");
                insertSql.append(" on billTable.fid = ENTRY.FParentID ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID  and ENTRY.FBatchSeq =lotsource.FLOT ");
                break;
            }
            case 6: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(6);
                insertSql.append(" as FBillType, billTable.fid as FBillId, ENTRY.FbaseUnitID as FBaseUnitID,");
                insertSql.append("ENTRY.FBaseCommtQty as FBaseQty,ENTRY.FUnitID as  FUnitID,");
                insertSql.append("ENTRY.FCommitQty as FQty, null as FManfauctuerNumber,");
                insertSql.append("null as FManufacureOrderID,null as FDisTaskDispatchID,");
                insertSql.append("null as FOperationID, ");
                insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("billTable.FProductionOrderID as FProductionOrderID, billTable.FTaskDispBillID as FTaskDispBillID,");
                insertSql.append("ENTRY.FProductLineWPID as FProductLineWPID,");
                insertSql.append("billTable.FProductLineID  as FProductLineID,billTable.FClassGroupID as FClassGroupID,");
                insertSql.append("billTable.FWorkshopID as FWorkShopID,null as FBizTypeID,");
                insertSql.append("  billTable.FBizDate as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime ,0 as fmmbiztype");
                insertSql.append(" from ");
                insertSql.append(" T_MM_FinishedRpt as billTable  ");
                insertSql.append(" left outer join T_MM_ProductionOrder as t4 on billTable.FProductionOrderID=t4.fid ");
                insertSql.append(" left outer join T_MM_FinishedRptEntry  as  ENTRY ");
                insertSql.append(" on billTable.fid = ENTRY.FParentID ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID  and ENTRY.FLotNo =lotsource.FLOT ");
                break;
            }
            case 7: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(7);
                insertSql.append(" as FBillType, billTable.fid as FBillId, ENTRY.FbaseUnitID as FBaseUnitID,");
                insertSql.append("ENTRY.FBaseAffDirQty as FBaseQty,ENTRY.FUnitID as  FUnitID,");
                insertSql.append("ENTRY.FAffrimDirectQty as FQty, null as FManfauctuerNumber,");
                insertSql.append("ENTRY.FMoId as FManufacureOrderID,null as FDisTaskDispatchID,");
                insertSql.append("null as FOperationID, ");
                insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("null as FProductionOrderID, null as FTaskDispBillID,");
                insertSql.append("null as FProductLineWPID,");
                insertSql.append("null  as FProductLineID,null as FClassGroupID,");
                insertSql.append("null as FWorkShopID,null as FBizTypeID,");
                insertSql.append("  billTable.FBizDate as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime, 0 as fmmbiztype");
                insertSql.append(" from ");
                insertSql.append(" T_MM_DirectDeliveryBill as billTable ");
                insertSql.append(" left outer join T_MM_DirectSource  as  ENTRY ");
                insertSql.append(" on billTable.fid = ENTRY.FParentID ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID  and ENTRY.FLotNo =lotsource.FLOT ");
                break;
            }
            case 8: {
                insertSql.append("lotsource.fid as FParentID,billTable.fnumber as fnumber,");
                insertSql.append(8);
                insertSql.append(" as FBillType, billTable.fid as FBillId, ENTRY.FbaseUnitID as FBaseUnitID,");
                insertSql.append("ENTRY.FBsReceivableQty as FBaseQty,ENTRY.FUnitID as  FUnitID,");
                insertSql.append("ENTRY.FReceivableQty as FQty, null as FManfauctuerNumber,");
                insertSql.append("null as FManufacureOrderID,null as FDisTaskDispatchID,");
                insertSql.append("null as FOperationID, ");
                insertSql.append("0 as FOperationNo,null as FProduceBillNumber,");
                insertSql.append("null as FProductionOrderID, null as FTaskDispBillID,");
                insertSql.append("null as FProductLineWPID,");
                insertSql.append("billTable.FProductLineID  as FProductLineID,billTable.FClassGroupID as FClassGroupID,");
                insertSql.append("billTable.FWorkshopID as FWorkShopID,null as FBizTypeID,");
                insertSql.append("  billTable.FBizDate as FBizDate,'");
                insertSql.append(ctx.getCaller().toString());
                insertSql.append("' AS FCreaterID, NOW() AS FCreateTime , 0 as fmmbiztype ");
                insertSql.append(" from ");
                insertSql.append(" T_MM_DDMReceivalBill as billTable ");
                insertSql.append(" left outer join T_MM_DDMReceivalBillEntry  as  ENTRY ");
                insertSql.append(" on billTable.fid = ENTRY.FParentID ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID  and ENTRY.FLotNumber =lotsource.FLOT ");
                break;
            }
        }
        return insertSql;
    }

    private void insertplanIntoLotSouceHead(Context ctx, String tmpTable, BillTypeEnum lotEnum) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_MM_LotSourceBill (FID,FStorageOrgUnitID,FMaterialID,FLot) ");
        insertSql.append("select newbosid('").append(new LotSourceBillInfo().getBOSType()).append("') as fid,");
        insertSql.append("billTable.FStorageOrgUnitID,billTable.FMaterialID,billTable.FLot from ");
        insertSql.append(" t_mm_plannedorder as billTable ");
        insertSql.append(" inner join ").append(tmpTable);
        insertSql.append(" as tmp on tmp.fid = billTable.fid ");
        insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
        insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
        insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
        insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and billTable.FmaterialID=MI.FMaterialID  ");
        insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on  ");
        insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
        insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
        insertSql.append(" where lotsource.FStorageOrgUnitID is null ");
        insertSql.append(" and lotsource.FMaterialID is null ");
        insertSql.append(" and lotsource.FLot is null ");
        insertSql.append(" and billTable.FLot is not null and LotParam.FManufacturePlan=1 and MI.FIsLotNumber=1 ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"2_LotFacadeControllerBean", (Locale)ctx.getLocale()) + insertSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void insertIntoLotSouceHead(Context ctx, String[] ids, BillTypeEnum lotEnum) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_MM_LotSourceBill (FID,FStorageOrgUnitID,FMaterialID,FLot) ");
        insertSql.append("select newbosid('").append(new LotSourceBillInfo().getBOSType()).append("') as fid,");
        this.buildInsertHeadSql(insertSql, lotEnum, id);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"2_LotFacadeControllerBean", (Locale)ctx.getLocale()) + insertSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private StringBuffer buildInsertHeadSql(StringBuffer insertSql, BillTypeEnum lotEnum, String id) {
        StringBuffer filerSql = new StringBuffer();
        filerSql.append(" where lotsource.FStorageOrgUnitID is null ");
        filerSql.append(" and lotsource.FMaterialID is null ");
        filerSql.append(" and lotsource.FLot is null ");
        filerSql.append(" and  billTable.fid  in (");
        filerSql.append(id);
        filerSql.append(")");
        switch (lotEnum.getValue()) {
            case 1: {
                insertSql.append("billTable.FStorageOrgUnitID,billTable.FMaterialID,billTable.FLot from ");
                insertSql.append(" t_mm_plannedorder as billTable ");
                insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
                insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and billTable.FmaterialID=MI.FMaterialID  ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource  on  ");
                insertSql.append("  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
                insertSql.append(filerSql);
                insertSql.append(" and billTable.FLot is not null and LotParam.FManufacturePlan=1 and MI.FIsLotNumber=1 ");
                break;
            }
            case 2: {
                insertSql.append(" billTable.FStorageOrgUnitID,billTable.FMaterialID,billTable.FLot from ");
                insertSql.append(" T_MM_ManufactureOrder as billTable ");
                insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
                insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and billTable.FmaterialID=MI.FMaterialID  ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource");
                insertSql.append("  on  billTable.FStorageOrgUnitID =   lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID  and billTable.FLot =lotsource.FLOT ");
                insertSql.append(filerSql);
                insertSql.append(" and billTable.FLot is not null and LotParam.FMANUFACTUREORDER=1 and MI.FIsLotNumber=1 ");
                break;
            }
            case 3: {
                insertSql.append(" billTable.FStorageOrgUnitID,billTable.FMaterialID,billTable.FLotNo from ");
                insertSql.append(" T_MM_ProductionOrder as billTable ");
                insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
                insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and billTable.FmaterialID=MI.FMaterialID  ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource on ");
                insertSql.append("  billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID and billTable.FLotNo =lotsource.FLOT ");
                insertSql.append(filerSql);
                insertSql.append(" and billTable.FLotNo is not null and LotParam.FProductionOrderProduction=1 and MI.FIsLotNumber=1 ");
                break;
            }
            case 4: {
                insertSql.append(" billTable.FStorageOrgUnitID,billTable.FMaterialID,billTable.FLotNo from ");
                insertSql.append(" T_MM_TaskDispBill as billTable ");
                insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
                insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and billTable.FmaterialID=MI.FMaterialID  ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource on ");
                insertSql.append("  billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and billTable.FMaterialID = lotsource. FMaterialID and billTable.FLotNo =lotsource.FLOT ");
                insertSql.append(filerSql);
                insertSql.append(" and billTable.FLotNo is not null  and LotParam.FProductionOrderTaskDisp=1 and MI.FIsLotNumber=1  ");
                break;
            }
            case 5: {
                insertSql.append(" t.FStorageOrgUnitID,t.FMaterialID,t.FBatchSeq from ( ");
                insertSql.append("select distinct billTable.FStorageOrgUnitID,ENTRY.FMaterialID,ENTRY.FBatchSeq from ");
                insertSql.append(" T_MM_CompletionReport as billTable ");
                insertSql.append("left outer join T_MM_ManufactureOrder  as t2 ");
                insertSql.append(" on billTable.FDmesOrderID = t2.fid  ");
                insertSql.append(" left outer join T_mm_CompletionRES  as  ENTRY ");
                insertSql.append(" on billTable.fid = ENTRY.FParentID ");
                insertSql.append("left  outer join  T_MM_LotSourceBill as lotsource on");
                insertSql.append("  billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID and ENTRY.FBatchSeq =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
                insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and ENTRY.FMaterialID=MI.FMaterialID  ");
                insertSql.append(filerSql);
                insertSql.append(" and ENTRY.FBatchSeq is not null and  LotParam.FManufactureReport=1 and MI.FIsLotNumber=1  ");
                insertSql.append(" and ENTRY.FBatchSeq  <> isnull(t2.FLot,'0')  ) as t ");
                break;
            }
            case 6: {
                insertSql.append(" t.FStorageOrgUnitID,t.FMaterialID,t.FLotNo from (  select distinct  ");
                insertSql.append(" billTable.FStorageOrgUnitID,ENTRY.FMaterialID,ENTRY.FLotNo from ");
                insertSql.append(" T_MM_FinishedRpt as billTable  ");
                insertSql.append("  left outer join T_MM_FinishedRptEntry  as  ENTRY ");
                insertSql.append(" on billTable.fid = ENTRY.FParentID ");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource on");
                insertSql.append(" billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID and ENTRY.FLotNo =lotsource.FLOT ");
                insertSql.append(" left outer join T_MM_LotParamValue LotParam  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=LotParam.FOrgUnitID ");
                insertSql.append(" left outer join T_BD_MaterialInventory MI  ");
                insertSql.append(" on billTable.FStorageOrgUnitID=MI.FOrgUnit and ENTRY.FMaterialID=MI.FMaterialID  ");
                insertSql.append(filerSql);
                insertSql.append(" and ENTRY.FLotNo is not null and  LotParam.FProductionOrderFinishedRpt=1 and MI.FIsLotNumber=1 ");
                insertSql.append(" ) as t ");
                break;
            }
            case 7: {
                insertSql.append(" t.FStorageOrgUnitID,t.FMaterialID,t.FLotNo from ( select distinct  ");
                insertSql.append(" billTable.FStorageOrgUnitID,ENTRY.FMaterialID,ENTRY.FLotNo from ");
                insertSql.append(" T_MM_DirectDeliveryBill as billTable  ");
                insertSql.append(" LEFT OUTER JOIN T_MM_DirectSource AS ENTRY ");
                insertSql.append(" ON billTable.FID = ENTRY.fparentid");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource on");
                insertSql.append(" billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID and ENTRY.FLotNo =lotsource.FLOT ");
                insertSql.append(filerSql);
                insertSql.append(" and ENTRY.FLotNo is not null");
                insertSql.append(" ) as t ");
                break;
            }
            case 8: {
                insertSql.append(" t.FStorageOrgUnitID,t.FMaterialID,t.FLotNumber from ( select distinct  ");
                insertSql.append(" billTable.FStorageOrgUnitID,ENTRY.FMaterialID,ENTRY.FLotNumber from ");
                insertSql.append(" T_MM_DDMReceivalBill as billTable  ");
                insertSql.append(" LEFT OUTER JOIN T_MM_DDMReceivalBillEntry AS ENTRY ");
                insertSql.append(" ON billTable.FID = ENTRY.fparentid");
                insertSql.append(" left  outer join  T_MM_LotSourceBill as lotsource on");
                insertSql.append(" billTable.FStorageOrgUnitID = lotsource.FStorageOrgUnitID ");
                insertSql.append(" and ENTRY.FMaterialID = lotsource. FMaterialID and ENTRY.FLotNumber =lotsource.FLOT ");
                insertSql.append(filerSql);
                insertSql.append(" and ENTRY.FLotNumber is not null");
                insertSql.append(" ) as t ");
                break;
            }
        }
        return insertSql;
    }

    @Override
    protected void _productionOrderdisTaskDispatchDeleteLot(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, BillTypeEnum.TASKDISPBILL);
        this.deleteLotSourceHead(ctx, ids, BillTypeEnum.TASKDISPBILL);
    }

    @Override
    protected Map _productionOrderdisTaskDispatchGetLot(Context ctx, String orgId, String materialId, boolean isLotNumber) throws BOSException, EASBizException {
        return this._byBillTyperForLotParamValue(ctx, BillTypeEnum.TASKDISPBILL, orgId, materialId, isLotNumber);
    }

    @Override
    protected void _productionOrderdisTaskDispatchInsertLot(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.insertIntoLotSouceHead(ctx, ids, BillTypeEnum.TASKDISPBILL);
        this.insertLotSouceEntry(ctx, ids, BillTypeEnum.TASKDISPBILL);
    }

    @Override
    protected IObjectValue _getLotParamValueByOrg(Context ctx, String orgId) throws BOSException, EASBizException {
        return LotParamValueFactory.getLocalInstance(ctx).getLotParamValueByStorg(orgId);
    }

    @Override
    protected Map _productionOrderGetLot(Context ctx, String orgId, List materiallist, boolean isLotNumber) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _productionOrderCloseLot(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        String enabledPick = "";
        StringBuffer storageOrgUnitIDSql = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            storageOrgUnitIDSql.append("select FStorageOrgUnitID from t_mm_productionorder where fid = '" + ids[i] + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)storageOrgUnitIDSql.toString());
            storageOrgUnitIDSql.setLength(0);
            ParamUtil paramUtil = null;
            if (rowSet != null && rowSet.size() > 0) {
                try {
                    while (rowSet.next()) {
                        paramUtil = new ParamUtil(ctx, rowSet.getString("FStorageOrgUnitID"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                paramUtil = new ParamUtil(ctx);
            }
            enabledPick = paramUtil.getEnabledPickBillParam("true");
            this.insertBathLotByProductureOrder(ctx, new String[]{ids[i]}, enabledPick);
        }
    }

    private void insertBathLotByProductureOrder(Context ctx, String[] ids, String enabledPick) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer inSql = new StringBuffer();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"3_LotFacadeControllerBean", (Locale)ctx.getLocale()));
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(FStorageOrgUnitID,FTimes)  = ");
        inSql.append(" (select t1.FStorageOrgUnitID as FStorageOrgUnitID ,t1.Times+t0.ftimes  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flot,count(*) as times  from T_MM_ProductionOrder as billTable  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as entry ");
        inSql.append("on entry.FManuBillNumber = billTable.FNumber  ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on entry.FParentID = t2.fid ");
        inSql.append(" where  entry.flot is not null and t2.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flot) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID and t1.flot =t0.flotno) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"4_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFile(fid,fcreatorid,fcreatetime,fstorageorgunitid,");
        inSql.append("FLotNo,FMaterialID, FBatchTime,FLotSource,FTimes ,FBaseStatus)  ");
        inSql.append(" select newbosid('").append(new BatchFileInfo().getBOSType()).append("')").append(" as fid,'");
        inSql.append(ctx.getCaller().toString()).append("' as fcreatorid, now() as fcreatetime, ");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,t.flot as FLotNo,t.fmaterialid as FMaterialID ,");
        inSql.append("now() as FBatchTime,").append(10).append(" as FLotSource,1 as FTimes ,2 as FBaseStatus ");
        inSql.append(" from ( select distinct t1.fstorageorgunitid ,entry.flot ,entry.fmaterialid ");
        inSql.append(" from T_MM_ProductionOrder as t1");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as entry ");
        inSql.append("on entry.FManuBillNumber = t1.FNumber ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on entry.FParentID = t2.fid ");
        inSql.append(" where  t2.fbasestatus=4 ");
        inSql.append(" and  t1.fid in(").append(id).append(") ");
        inSql.append(" ) as t");
        inSql.append(" left outer join T_MM_BatchFile as t2 ");
        inSql.append(" on t.fstorageorgunitid = t2.fstorageorgunitid and t.fmaterialid =t2.fmaterialid ");
        inSql.append("and t.flot= t2.flotno where t2.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"5_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(FStorageOrgUnitID,FTimes)  = ");
        inSql.append(" (select t1.FStorageOrgUnitID as FStorageOrgUnitID ,t1.Times+t0.ftimes  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.FLotNumber,count(*) as times  from T_MM_ProductionOrder as billTable  ");
        inSql.append(" inner join T_MM_FinishedRpt as t5 on billTable.fid = t5.FProductionOrderID ");
        inSql.append(" left outer join T_BD_MaterialPlan as p  ");
        inSql.append("  on billTable.FStorageOrgUnitID=p.FOrgUnit and billTable.FMaterialID=p.FMaterialID  ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as entry  ");
        inSql.append(" on  t5.fid = entry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" where  entry.FLotNumber is not null and t4.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  group by   billtable.fid,  ");
        inSql.append("  billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.FLotNumber ) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID and t1.FLotNumber =t0.flotno) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"6_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFile(fid,fcreatorid,fcreatetime,fstorageorgunitid,");
        inSql.append("FLotNo,FMaterialID, FBatchTime,FLotSource,FTimes,FBaseStatus )  ");
        inSql.append(" select newbosid('").append(new BatchFileInfo().getBOSType()).append("')").append(" as fid,'");
        inSql.append(ctx.getCaller().toString()).append("' as fcreatorid, now() as fcreatetime, ");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,t.FLotNumber as FLotNo,t.fmaterialid as FMaterialID ,");
        inSql.append("now() as FBatchTime,").append(10).append(" as FLotSource,1 as FTimes ,2 as FBaseStatus ");
        inSql.append(" from ( select distinct t1.fstorageorgunitid ,entry.FLotNumber ,entry.fmaterialid ");
        inSql.append(" from T_MM_ProductionOrder as t1");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" left outer join T_BD_MaterialPlan as p  ");
        inSql.append("  on t1.FStorageOrgUnitID=p.FOrgUnit and t1.FMaterialID=p.FMaterialID  ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as entry  ");
        inSql.append(" on  finshedrpt.fid = entry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as t2  on entry.fparentid = t2.fid ");
        inSql.append(" where  t2.fbasestatus=4 ");
        inSql.append(" and  t1.fid in(").append(id).append(") ");
        inSql.append(" ) as t");
        inSql.append(" left outer join T_MM_BatchFile as t2 ");
        inSql.append(" on t.fstorageorgunitid = t2.fstorageorgunitid and t.fmaterialid =t2.fmaterialid ");
        inSql.append("and t.FLotNumber= t2.flotno where t2.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"7_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot ,batchfile.fid as fparentid from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as RecBillentry ");
        inSql.append("on RecBillentry.FManuBillNumber = t1.FNumber ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as RecBill ");
        inSql.append(" on RecBillentry.FParentID = RecBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid ");
        inSql.append(" and RecBillentry.fmaterialid =batchfile.fmaterialid and RecBillentry.flot=batchfile.flotno  ");
        if ("true".equals(enabledPick)) {
            inSql.append(" inner join t_mm_pickingSlipBill as pickingSlipBill  on t1.fid = pickingSlipBill.FProductionOrderID  ");
            inSql.append(" inner join t_mm_pickingSlipBillEntry as t10  on t10.fparentid = pickingSlipBill.fid  ");
            inSql.append(" inner join T_MM_PSMRRelation as psm on psm.FSrcEntryID =t10.fid  ");
            inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t3.fsourcebillEntryID  =psm.ftempEntryId  ");
        } else {
            inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fnumber =t3.FOrderNumber ");
        }
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on t3.fParentID = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  ");
        inSql.append("   and t4.fbasestatus=4  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and a.fparentid=t0.fparentid ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"8_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot ,batchfile.fid as fparentid from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" left outer join T_BD_MaterialPlan as p  ");
        inSql.append("  on t1.FStorageOrgUnitID=p.FOrgUnit and t1.FMaterialID=p.FMaterialID  ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as DDMReceivalBillEntry  ");
        inSql.append(" on  finshedrpt.fid = DDMReceivalBillEntry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as DDMReceivalBill  ");
        inSql.append(" on DDMReceivalBillEntry.fparentid = DDMReceivalBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DDMReceivalBillEntry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DDMReceivalBillEntry.FLotNumber= batchfile.flotno ");
        inSql.append(" inner join t_mm_pickingSlipBill as t5  on t1.fid = t5.FProductionOrderID  ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on t5.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t4.fid =t3.fparentid  ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(") ");
        inSql.append(" and t2.FMaterialID=t3.FMaterialID ");
        inSql.append("   and t4.fbasestatus=4  and DDMReceivalBill.fbasestatus=4 ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and a.fparentid=t0.fparentid ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"9_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.FLotNumber, count(*) as times ,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill on recbill.FSourceBillID= finshedrpt.fid  ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as recbillentry  ");
        inSql.append(" on  recbill.fid = recbillentry.fparentid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot= batchfile.flotno ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as t3 on ddmrbte.FParentID =t3.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBill on t3.FParentID = DDMReceivalBill.fid ");
        inSql.append("where  t3.FLotNumber is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and t2.FMaterialID=t3.FMaterialID  ");
        inSql.append(" and DDMReceivalBill.fbasestatus=4   and recbill.fbasestatus=4 ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid ) as  t  group by t.FMaterialID, t.FLotNumber,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.FLotNumber = t0.flotno and a.fparentid=t0.fparentid ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"10_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.FLotNumber, count(t.FLotNumber) as times ,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as OrderSEntry  on t1.fid = OrderSEntry.fparentid ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as DDMReceivalBillEntry  ");
        inSql.append(" on  finshedrpt.fid = DDMReceivalBillEntry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as DDMReceivalBill  ");
        inSql.append(" on DDMReceivalBillEntry.fparentid = DDMReceivalBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DDMReceivalBillEntry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DDMReceivalBillEntry.FLotNumber= batchfile.flotno ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as t3 on ddmrbte.FParentID =t3.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBillSON on t3.FParentID = DDMReceivalBillSON.fid ");
        inSql.append("where  t3.FLotNumber is not null and t1.fid in(").append(id).append(")  and OrderSEntry.FMaterialID=t3.FMaterialID ");
        inSql.append("  and DDMReceivalBill.fbasestatus=4 and DDMReceivalBillSON.fbasestatus=4");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid ) as  t  group by t.FMaterialID, t.FLotNumber,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.FLotNumber = t0.flotno and a.fparentid=t0.fparentid ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"11_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLot   as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID,10 as  FLotSource ");
        inSql.append(" from  (");
        inSql.append(" select distinct t2.fid as fid, entry.FLot,t1.fstorageorgunitid ,entry.fmaterialid   ");
        inSql.append(" from T_MM_ProductionOrder as t1  ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as recBillentry ");
        inSql.append("on recBillentry.FManuBillNumber = t1.FNumber ");
        inSql.append(" inner join T_IM_ManufactureRecBill  \tas recBill ");
        inSql.append(" on recBillentry.FParentID = recBill.fid ");
        if ("true".equals(enabledPick)) {
            inSql.append(" inner join t_mm_pickingSlipBill as t5  on t1.fid = t5.FProductionOrderID  ");
            inSql.append(" inner join t_mm_pickingSlipBillEntry as t10  on t10.fparentid = t5.fid  ");
            inSql.append(" inner join T_MM_PSMRRelation as psm on psm.FSrcEntryID =t10.fid  ");
            inSql.append(" inner join T_IM_MaterialReqBillEntry as entry on entry.fsourcebillEntryID  =psm.ftempEntryId  ");
        } else {
            inSql.append(" inner join T_IM_MaterialReqBillEntry as entry on t1.fnumber =entry.FOrderNumber ");
        }
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on entry.fParentID = t4.fid ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and recbillentry.fmaterialid =t2.fmaterialid ");
        inSql.append("and recbillentry.flot= t2.flotno where t2.fstorageorgunitid is not null  ");
        inSql.append(" and  t1.fid in(").append(id).append(")  and entry.FLot is not null");
        inSql.append("  and t4.fbasestatus=4  ) as t ");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.flot = t5.flotno  and t.fid =t5.fparentid  where t5.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"12_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLot   as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID,10 as FLotSource ");
        inSql.append(" from  (");
        inSql.append(" select distinct t2.fid as fid, entry.FLot,t1.fstorageorgunitid ,entry.fmaterialid   ");
        inSql.append(" from T_MM_ProductionOrder as t1  ");
        inSql.append(" inner join  T_MM_ProductionOrderSEntry as t3 on t1.fid = t3.FParentID ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as DDMReceivalBillEntry  ");
        inSql.append(" on  finshedrpt.fid = DDMReceivalBillEntry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as DDMReceivalBill  ");
        inSql.append(" on DDMReceivalBillEntry.fparentid = DDMReceivalBill.fid ");
        inSql.append(" inner join t_mm_pickingSlipBill as t5  on t1.fid = t5.FProductionOrderID  ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on t5.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as entry on t4.fid =entry.fparentid  ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and DDMReceivalBillEntry.fmaterialid =t2.fmaterialid ");
        inSql.append("and DDMReceivalBillEntry.FLotNumber= t2.flotno where t2.fstorageorgunitid is not null  ");
        inSql.append(" and  t1.fid in(").append(id).append(")  and entry.FLot is not null");
        inSql.append(" and entry.FMaterialID=t3.FMaterialID  ");
        inSql.append("  and t4.fbasestatus=4 and DDMReceivalBill.fbasestatus=4 ) as t ");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.flot = t5.flotno  and t.fid =t5.fparentid  where t5.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"13_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLotNumber as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID ,10 as FLotSource ");
        inSql.append(" from  (");
        inSql.append(" select distinct t2.fid as fid, DDMReceivalBillEntry.FLotNumber,t1.fstorageorgunitid ,DDMReceivalBillEntry.fmaterialid   ");
        inSql.append(" from T_MM_ProductionOrder as t1  ");
        inSql.append(" inner join  T_MM_ProductionOrderSEntry as t3 on t1.fid = t3.FParentID ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill on recbill.FSourceBillID= finshedrpt.fid  ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as recbillentry  ");
        inSql.append(" on  recbill.fid = recbillentry.fparentid ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as DDMReceivalBillEntry on ddmrbte.FParentID =DDMReceivalBillEntry.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBillSON on DDMReceivalBillEntry.FParentID = DDMReceivalBillSON.fid ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and recbillentry.fmaterialid =t2.fmaterialid ");
        inSql.append("and recbillentry.FLot= t2.flotno where t2.fstorageorgunitid is not null  ");
        inSql.append(" and  t1.fid in(").append(id).append(") and DDMReceivalBillEntry.FLotNumber is not null");
        inSql.append(" and DDMReceivalBillEntry.FMaterialID=t3.FMaterialID   ");
        inSql.append("   and DDMReceivalBillSON.fbasestatus=4 and recbill.fbasestatus=4  ) as t");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.FLotNumber= t5.flotno and t.fid =t5.fparentid   where t5.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"14_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLotNumber as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID , 10 as FLotSource ");
        inSql.append(" from  (");
        inSql.append(" select distinct t2.fid as fid, DDMReceivalBillEntry.FLotNumber,t1.fstorageorgunitid ,DDMReceivalBillEntry.fmaterialid   ");
        inSql.append(" from T_MM_ProductionOrder as t1  ");
        inSql.append(" inner join T_MM_FinishedRpt as finishedrpt on t1.fid = finishedrpt.FProductionOrderID ");
        inSql.append(" inner join  T_MM_ProductionOrderSEntry as t3 on t1.fid = t3.FParentID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as entry  ");
        inSql.append(" on  finishedrpt.fid = entry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as DDMReceivalBillEntry on ddmrbte.FParentID =DDMReceivalBillEntry.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBillSON on DDMReceivalBillEntry.FParentID = DDMReceivalBillSON.fid ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and entry.fmaterialid =t2.fmaterialid ");
        inSql.append("and entry.FLotNumber= t2.flotno where t2.fstorageorgunitid is not null and t4.fbasestatus = 4 ");
        inSql.append(" and  t1.fid in(").append(id).append(") and entry.FLotNumber is not null");
        inSql.append(" and DDMReceivalBillEntry.FMaterialID=t3.FMaterialID    ");
        inSql.append("   and DDMReceivalBillSON.fbasestatus=4   ) as t");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.FLotNumber= t5.flotno and t.fid =t5.fparentid   where t5.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"15_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot ,batchfile.fid as fparentid from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_FinishedRpt as t5 on t1.fid = t5.FProductionOrderID ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as recBillentry ");
        inSql.append("on recBillentry.FManuBillNumber = t1.FNumber ");
        inSql.append(" inner join T_IM_ManufactureRecBill  \tas recBill ");
        inSql.append(" on recBillentry.FParentID = recBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid ");
        inSql.append(" and RecBillentry.fmaterialid =batchfile.fmaterialid and RecBillentry.flot=batchfile.flotno  ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on t5.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t4.fid =t3.fparentid  ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  ");
        inSql.append("   and t4.fbasestatus=4  and t2.FMaterialID=t3.FMaterialID ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and a.fparentid=t0.fparentid ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"16_LotFacadeControllerBean", (Locale)ctx.getLocale()) + "   SQL-------" + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLot   as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID,10 as  FLotSource ");
        inSql.append(" from  (");
        inSql.append(" select distinct t2.fid as fid, entry.FLot,t1.fstorageorgunitid ,entry.fmaterialid   ");
        inSql.append(" from T_MM_ProductionOrder as t1  ");
        inSql.append(" inner join  T_MM_ProductionOrderSEntry as t3 on t1.fid = t3.FParentID ");
        inSql.append(" inner join T_MM_FinishedRpt as finishedrpt on t1.fid = finishedrpt.FProductionOrderID ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as recBillentry ");
        inSql.append("on recBillentry.FManuBillNumber = t1.FNumber ");
        inSql.append(" inner join T_IM_ManufactureRecBill  \tas recBill ");
        inSql.append(" on recBillentry.FParentID = recBill.fid ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on finishedrpt.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as entry on t4.fid =entry.fparentid  ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and recbillentry.fmaterialid =t2.fmaterialid ");
        inSql.append("and recbillentry.flot= t2.flotno where t2.fstorageorgunitid is not null  ");
        inSql.append(" and  t1.fid in(").append(id).append(")  and entry.FLot is not null");
        inSql.append(" and entry.FMaterialID=t3.FMaterialID  ");
        inSql.append("  and t4.fbasestatus=4  ) as t ");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.flot = t5.flotno  and t.fid =t5.fparentid  where t5.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"17_LotFacadeControllerBean", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"18_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
    }

    @Override
    protected void _productionOrderUnCloseLot(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        ParamUtil paramUtil = new ParamUtil(ctx);
        String enabledPick = paramUtil.getEnabledPickBillParam("true");
        for (int i = 0; i < ids.length; ++i) {
            this.deleteBatchLotByProductionOrder(ctx, new String[]{ids[i]}, enabledPick);
        }
    }

    @Override
    protected void _manufactureOrderUnCloseLot(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            this.deleteBatchLotByManufacureOrder(ctx, new String[]{ids[i]});
        }
    }

    @Override
    protected void _manufactureOrderCloseLot(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            this.insertDataToBatchLotByManufactureOrder(ctx, new String[]{ids[i]});
        }
    }

    private HashSet[] manufactByReportOrRec(Context ctx, String[] ids) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer sql = new StringBuffer();
        sql.append(" select fsourcebillid , 2 type from T_MM_CompletionReport  ");
        sql.append(" where fsourcebillid in( ").append(id).append(")");
        sql.append(" union all ");
        sql.append("  select fsourcebillid , 1 type from T_IM_ManufactureRecBill  ");
        sql.append(" where fsourcebillid in( ").append(id).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Object fid = null;
        HashSet<String> recSet = new HashSet<String>();
        HashSet<String> comSet = new HashSet<String>();
        String sourcebillid = null;
        try {
            while (rs.next()) {
                sourcebillid = rs.getString("fsourcebillid");
                if (rs.getInt("type") == 2 && !comSet.contains(sourcebillid)) {
                    comSet.add(sourcebillid);
                    continue;
                }
                if (rs.getInt("type") != 1 || recSet.contains(sourcebillid)) continue;
                recSet.add(sourcebillid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        HashSet[] object = new HashSet[]{comSet, recSet};
        return object;
    }

    private void deleteBatchLotByManufacureOrder(Context ctx, String[] ids) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer inSql = new StringBuffer();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"19_LotFacadeControllerBean", (Locale)ctx.getLocale()));
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid as fparentid from  T_MM_ManufactureOrder t1  ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DirectSource.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DirectSource.FLotNo=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fid =t3.fsourcebillid  ");
        inSql.append(" inner join T_IM_MaterialReqBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("   ");
        inSql.append("   and t4.fbasestatus=4  and  t2.FMaterialID=t3.FMaterialID  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid  ) as  t  group by t.FMaterialID, t.flot ,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and t0.FTimes >= isnull(a.times,0)  and a.fparentid=t0.fparentid)");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"20_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid as fparentid from  T_MM_ManufactureOrder t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry  on t1.fid =recbillentry.FManuBillID ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.fparentid = recbill.fid  ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fid =t3.fsourcebillid  ");
        inSql.append(" inner join T_IM_MaterialReqBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  ");
        inSql.append("   and t4.fbasestatus=4  and  t3.FMaterialID=t2.FMaterialID  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid  ) as  t  group by t.FMaterialID, t.flot ,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and t0.FTimes >= isnull(a.times,0)  and a.fparentid=t0.fparentid)");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"21_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry  where fid in  ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot , batchfile.fid as fparentid from  T_MM_ManufactureOrder t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry  on t1.fid =recbillentry.FManuBillID ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.fparentid = recbill.fid  ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fid =t3.fsourcebillid  ");
        inSql.append(" left outer join T_IM_MaterialReqBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  ");
        inSql.append("    and t4.fbasestatus=4  and  t2.FMaterialID=t3.FMaterialID  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and a.fparentid=t0.fparentid ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid  ");
        inSql.append("where  t0.FTimes = 0  and t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"22_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry  where fid in  ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot ,batchfile.fid as fparentid from  T_MM_ManufactureOrder t1  ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DirectSource.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DirectSource.FLotNo=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fid =t3.fsourcebillid  ");
        inSql.append(" left outer join T_IM_MaterialReqBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("   ");
        inSql.append("    and t4.fbasestatus=4  and  t2.FMaterialID=t3.FMaterialID  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and a.fparentid=t0.fparentid ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid  ");
        inSql.append("where  (t0.FTimes = 0 or b.fid is null) and t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"23_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) =  ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flotno, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid as fparentid  from  T_MM_ManufactureOrder t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry  on t1.fid =recbillentry.FManuBillID ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.fparentid = recbill.fid  ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append("  inner join T_MM_DirectDest as t3 on t2.fid =t3.FStockId   ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and t3.FPickmaterialId=t7.fmaterialid ");
        inSql.append("where  t7.flotno is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and t4.FDestOrgUnitID=t1.fstorageorgunitid ");
        inSql.append("   and t4.fbasestatus=4   and  t3.FPickMaterialId=t2.FMaterialID  ");
        inSql.append(" group by t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid ) as  t  group by t.FMaterialID, t.flotno,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID and a.fparentid=t0.fparentid and a.flotno = t0.flotno and t0.FTimes >= isnull(a.times,0) )");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"24_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) =  ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flotno, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid as fparentid  from  T_MM_ManufactureOrder t1  ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DirectSource.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append("  inner join T_MM_DirectDest as t3 on t2.fid =t3.FStockId  ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and t3.FPickmaterialId=t7.fmaterialid ");
        inSql.append("where  t7.flotno is not null and t1.fid in(").append(id).append(")");
        inSql.append(" and t4.FDestOrgUnitID=t1.fstorageorgunitid  and  t3.FPickMaterialId=t2.FMaterialID  ");
        inSql.append("   and t4.fbasestatus=4 and DirectDeliveryBill.fbasestatus=4 ");
        inSql.append(" group by t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid ) as  t  group by t.FMaterialID, t.flotno,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID and a.fparentid=t0.fparentid and a.flotno = t0.flotno and t0.FTimes >= isnull(a.times,0) )");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"25_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry where fid in ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.flotno, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid as fparentid  from  T_MM_ManufactureOrder t1  ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DirectSource.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_DirectDest as t3 on t2.fid =t3.FStockId   ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and t3.FPickmaterialId=t7.fmaterialid ");
        inSql.append("where  t7.flotno is not null and t1.fid in(").append(id).append(")");
        inSql.append(" and t4.FDestOrgUnitID=t1.fstorageorgunitid ");
        inSql.append("   and t4.fbasestatus=4 and DirectDeliveryBill.fbasestatus=4  and  t3.FPickMaterialId=t2.FMaterialID  ");
        inSql.append(" group by t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid ) as  t  group by t.FMaterialID, t.flotno,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.flotno = t0.flotno and t0.fparentid=a.fparentid ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid  ");
        inSql.append("where  (t0.FTimes = 0 or b.fid is null) and t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"26_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry where fid in ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.flotno, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid as fparentid  from  T_MM_ManufactureOrder t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry  on t1.fid =recbillentry.FManuBillID ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.fparentid = recbill.fid  ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append("  inner join T_MM_DirectDest as t3 on t2.fid =t3.FStockId  ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and t3.FPickmaterialId=t7.fmaterialid ");
        inSql.append("where  t7.flotno is not null and t1.fid in(").append(id).append(")");
        inSql.append("   and t4.FDestOrgUnitID=t1.fstorageorgunitid  and  t3.FPickMaterialId=t2.FMaterialID  ");
        inSql.append("   and t4.fbasestatus=4  ");
        inSql.append(" group by t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid ) as  t  group by t.FMaterialID, t.flotno,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.flotno = t0.flotno and t0.fparentid=a.fparentid ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid  ");
        inSql.append("where  (t0.FTimes = 0 or b.fid is null) and t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"27_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(FStorageOrgUnitID,FTimes)  = ");
        inSql.append(" (select t1.FStorageOrgUnitID as FStorageOrgUnitID ,t0.ftimes-t1.Times  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flot,count(*) as times  from T_MM_ManufactureOrder as billTable  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as entry ");
        inSql.append("on  billTable.fid = entry.FManuBillID  ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on t2.fid = entry.fparentid  ");
        inSql.append(" where  entry.flot is not null and t2.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flot) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID  ");
        inSql.append(" and t1.flot =t0.flotno and t0.FTimes > t1.Times )");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"28_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" delete T_MM_BatchFile where fid in ");
        inSql.append(" (select t0.fid  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flot,count(*) as times  from T_MM_ManufactureOrder as billTable  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as entry ");
        inSql.append("on  billTable.fid = entry.FManuBillID  ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on t2.fid = entry.fparentid  ");
        inSql.append(" where  entry.flot is not null and t2.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flot) as t1, T_MM_BatchFile as t0  ");
        inSql.append(" left outer join T_MM_BatchFileEntry t8 on t0.fid=t8.fparentid ");
        inSql.append("  where t1.FStorageOrgUnitID=t0.fstorageorgunitid  ");
        inSql.append(" and t1.FMaterialID=t0.FMaterialID   and t1.flot =t0.flotno and t0.FTimes <= 2 and t8.fid is null)");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"28_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(FStorageOrgUnitID,FTimes)  = ");
        inSql.append(" (select t1.FStorageOrgUnitID as FStorageOrgUnitID ,t0.ftimes-t1.Times  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flotno,count(*) as times  from T_MM_ManufactureOrder as billTable  ");
        inSql.append(" inner  join  T_MM_DirectSource  as entry  ");
        inSql.append(" on  billTable.fid = entry.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" where  entry.flotno is not null and t4.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("   and t4.FDestOrgUnitID=billTable.fstorageorgunitid and billTable.FIsDirectSend=1 ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flotno ) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID  ");
        inSql.append(" and t1.flotno =t0.flotno  and t0.FTimes > t1.Times ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"29_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" delete T_MM_BatchFile where fid in");
        inSql.append(" (select t0.fid  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flotno,count(*) as times  from T_MM_ManufactureOrder as billTable  ");
        inSql.append(" inner  join  T_MM_DirectSource  as entry  ");
        inSql.append(" on  billTable.fid = entry.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" where  entry.flotno is not null and t4.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  and t4.FDestOrgUnitID=billTable.fstorageorgunitid and billTable.FIsDirectSend=1 ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flotno ) as t1 ");
        inSql.append(" ,T_MM_BatchFile as t0 ");
        inSql.append(" left outer join T_MM_BatchFileEntry t8 on t0.fid=t8.fparentid ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID  ");
        inSql.append(" and t1.flotno =t0.flotno and t0.FTimes <= 2 and t8.fid is null ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"30_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
    }

    private void deleteBatchLotByProductionOrder(Context ctx, String[] ids, String enabledPick) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer inSql = new StringBuffer();
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"31_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "----------- ------"));
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid  as fparentid from  T_MM_ProductionOrder t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry ");
        inSql.append("on recbillentry.FManuBillNumber = t1.FNumber  ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.FParentID = recbill.fid ");
        inSql.append(" inner join T_MM_BatchFile as batchfile  on recbillentry.flot=batchfile.flotno and ");
        inSql.append(" t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        if ("true".equals(enabledPick)) {
            inSql.append(" inner join t_mm_pickingSlipBill as t5  on t1.fid = t5.FProductionOrderID  ");
            inSql.append(" inner join t_mm_pickingSlipBillEntry as t10  on t10.fparentid = t5.fid  ");
            inSql.append(" inner join T_MM_PSMRRelation as psm on psm.FSrcEntryID =t10.fid  ");
            inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t3.fsourcebillEntryID  =psm.ftempEntryId  ");
        } else {
            inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fnumber =t3.FOrderNumber ");
        }
        inSql.append(" inner join T_IM_MaterialReqBill as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("   and t4.fbasestatus=4  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and t0.FTimes >= isnull(a.times,0) ");
        inSql.append(" and a.fparentid=t0.fparentid  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"32_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid  as fparentid from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as OrderSEntry  on t1.fid = OrderSEntry.fparentid ");
        inSql.append(" inner join T_MM_FinishedRpt as finishedrpt on t1.fid = finishedrpt.FProductionOrderID ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry ");
        inSql.append("on recbillentry.FManuBillNumber = t1.FNumber  ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.FParentID = recbill.fid ");
        inSql.append(" inner join T_MM_BatchFile as batchfile  on recbillentry.flot=batchfile.flotno and ");
        inSql.append(" t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on finishedrpt.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t4.fid =t3.fparentid  ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append(" and OrderSEntry.FMaterialID=t3.FMaterialID ");
        inSql.append("   and t4.fbasestatus=4  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and t0.FTimes >= isnull(a.times,0) ");
        inSql.append(" and a.fparentid=t0.fparentid  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"33_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot ,batchfile.fid as fparentid from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as DDMReceivalBillEntry  ");
        inSql.append(" on  finshedrpt.fid = DDMReceivalBillEntry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as DDMReceivalBill  ");
        inSql.append(" on DDMReceivalBillEntry.fparentid = DDMReceivalBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DDMReceivalBillEntry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DDMReceivalBillEntry.FLotNumber= batchfile.flotno ");
        inSql.append(" inner join t_mm_pickingSlipBill as t5  on t1.fid = t5.FProductionOrderID  ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on t5.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t4.fid =t3.fparentid  ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(") ");
        inSql.append(" and t2.FMaterialID=t3.FMaterialID ");
        inSql.append("   and t4.fbasestatus=4  and DDMReceivalBill.fbasestatus=4 ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and a.fparentid=t0.fparentid and t0.FTimes >= isnull(a.times,0) ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"9_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry  where fid in ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner join T_MM_FinishedRpt as finishedrpt on t1.fid = finishedrpt.FProductionOrderID ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry ");
        inSql.append("on recbillentry.FManuBillNumber = t1.FNumber  ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.FParentID = recbill.fid ");
        inSql.append(" inner join T_MM_BatchFile as batchfile  on recbillentry.flot=batchfile.flotno and ");
        inSql.append(" t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        if ("true".equals(enabledPick)) {
            inSql.append(" inner join t_mm_pickingSlipBill as t5  on t1.fid = t5.FProductionOrderID  ");
            inSql.append(" inner join t_mm_pickingSlipBillEntry as t10  on t10.fparentid = t5.fid  ");
            inSql.append(" inner join T_MM_PSMRRelation as psm on psm.FSrcEntryID =t10.fid  ");
            inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t3.fsourcebillEntryID  =psm.ftempEntryId  ");
        } else {
            inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fnumber =t3.FOrderNumber ");
        }
        inSql.append(" inner join T_IM_MaterialReqBill as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and t4.fbasestatus=4  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and t0.fparentid=a.fparentid ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid ");
        inSql.append("where  (t0.FTimes =0  or b.fid is null)   and  t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"34_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry  where fid in ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner join T_MM_FinishedRpt as finishedrpt on t1.fid = finishedrpt.FProductionOrderID ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry ");
        inSql.append("on recbillentry.FManuBillNumber = t1.FNumber  ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.FParentID = recbill.fid ");
        inSql.append(" inner join T_MM_BatchFile as batchfile  on recbillentry.flot=batchfile.flotno and ");
        inSql.append(" t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on finishedrpt.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t4.fid =t3.fparentid  ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and t2.FMaterialID=t3.FMaterialID ");
        inSql.append("  and t4.fbasestatus=4  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and t0.fparentid=a.fparentid ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid ");
        inSql.append("where  (t0.FTimes =0  or b.fid is null)   and  t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"34_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry  where fid in ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as DDMReceivalBillEntry  ");
        inSql.append(" on  finshedrpt.fid = DDMReceivalBillEntry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as DDMReceivalBill  ");
        inSql.append(" on DDMReceivalBillEntry.fparentid = DDMReceivalBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DDMReceivalBillEntry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DDMReceivalBillEntry.FLotNumber= batchfile.flotno ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join t_mm_pickingSlipBill as t5  on t1.fid = t5.FProductionOrderID  ");
        inSql.append(" inner  join T_IM_MaterialReqBill  as t4  on t5.fid = t4.fsourcebillid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t4.fid =t3.fparentid  ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and t4.fbasestatus=4  and t2.FMaterialID=t3.FMaterialID ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid ) as  t  group by t.FMaterialID, t.flot,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno and t0.fparentid=a.fparentid ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid ");
        inSql.append("where  (t0.FTimes = 0 or b.fid is null)   and  t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"34_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.FLotNumber, count(*) as times ,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill on recbill.FSourceBillID= finshedrpt.fid  ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as recbillentry  ");
        inSql.append(" on  recbill.fid = recbillentry.fparentid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot= batchfile.flotno ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as t3 on ddmrbte.FParentID =t3.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBill on t3.FParentID = DDMReceivalBill.fid ");
        inSql.append("where  t3.FLotNumber is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and t2.FMaterialID=t3.FMaterialID  ");
        inSql.append(" and DDMReceivalBill.fbasestatus=4   and recbill.fbasestatus=4 ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid ) as  t  group by t.FMaterialID, t.FLotNumber,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.FLotNumber = t0.flotno and a.fparentid=t0.fparentid and t0.FTimes >= isnull(a.times,0) ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"10_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes-isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.FLotNumber, count(t.FLotNumber) as times ,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as OrderSEntry  on t1.fid = OrderSEntry.fparentid ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as DDMReceivalBillEntry  ");
        inSql.append(" on  finshedrpt.fid = DDMReceivalBillEntry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as DDMReceivalBill  ");
        inSql.append(" on DDMReceivalBillEntry.fparentid = DDMReceivalBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DDMReceivalBillEntry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DDMReceivalBillEntry.FLotNumber= batchfile.flotno ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as t3 on ddmrbte.FParentID =t3.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBillSON on t3.FParentID = DDMReceivalBillSON.fid ");
        inSql.append("where  t3.FLotNumber is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and DDMReceivalBill.fbasestatus=4 and DDMReceivalBillSON.fbasestatus=4  and OrderSEntry.FMaterialID=t3.FMaterialID ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid ) as  t  group by t.FMaterialID, t.FLotNumber,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.FLotNumber = t0.flotno and a.fparentid=t0.fparentid  and t0.FTimes >= isnull(a.times,0) ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"11_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry where fid in ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.FLotNumber, count(t.FLotNumber) as times ,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as OrderSEntry  on t1.fid = OrderSEntry.fparentid ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as DDMReceivalBillEntry  ");
        inSql.append(" on  finshedrpt.fid = DDMReceivalBillEntry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as DDMReceivalBill  ");
        inSql.append(" on DDMReceivalBillEntry.fparentid = DDMReceivalBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DDMReceivalBillEntry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DDMReceivalBillEntry.FLotNumber= batchfile.flotno ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as t3 on ddmrbte.FParentID =t3.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBillSON on t3.FParentID = DDMReceivalBillSON.fid ");
        inSql.append("where  t3.FLotNumber is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and DDMReceivalBill.fbasestatus=4 and DDMReceivalBillSON.fbasestatus=4 and OrderSEntry.FMaterialID=t3.FMaterialID ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid ) as  t  group by t.FMaterialID, t.FLotNumber,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.FLotNumber = t0.flotno ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid  ");
        inSql.append("where  (t0.FTimes =0 or b.fid is null)and t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"35_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("delete T_MM_BatchFileEntry where fid in ");
        inSql.append("(select t0.fid from (  ");
        inSql.append(" select t.FMaterialID, t.FLotNumber, count(*) as times ,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid as fparentid  from  T_MM_ProductionOrder t1  ");
        inSql.append(" inner join T_MM_FinishedRpt as finshedrpt on t1.fid = finshedrpt.FProductionOrderID ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as recbill on recbill.FSourceBillID= finshedrpt.fid  ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as recbillentry  ");
        inSql.append(" on  recbill.fid = recbillentry.fparentid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile  ");
        inSql.append("  on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot= batchfile.flotno ");
        inSql.append(" inner  join T_MM_ProductionOrderSEntry as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_DDMRBTE as ddmrbte on t1.fid =ddmrbte.FProductionOrderID   ");
        inSql.append("  inner join T_MM_DDMReceivalBillEntry as t3 on ddmrbte.FParentID =t3.fid ");
        inSql.append("  inner join T_MM_DDMReceivalBill  as  DDMReceivalBill on t3.FParentID = DDMReceivalBill.fid ");
        inSql.append("where  t3.FLotNumber is not null and t1.fid in(").append(id).append(")");
        inSql.append(" and t2.FMaterialID=t3.FMaterialID     ");
        inSql.append(" and DDMReceivalBill.fbasestatus=4   and recbill.fbasestatus=4 ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.FLotNumber,batchfile.fid ) as  t  group by t.FMaterialID, t.FLotNumber,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append(" left outer join T_MM_BatchFileEntry as t0 ");
        inSql.append("  on  a.FMaterialID = t0.FMaterialID  and a.FLotNumber = t0.flotno ");
        inSql.append(" left outer join T_MM_BatchFile as b on t0.fparentid = b.fid  ");
        inSql.append("where  (t0.FTimes = 0 or b.fid is null)and t0.FLotSource=10  ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"36_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(FStorageOrgUnitID,FTimes)  = ");
        inSql.append(" (select t1.FStorageOrgUnitID as FStorageOrgUnitID ,t0.ftimes-t1.Times  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flot,count(*) as times  from T_MM_ProductionOrder as billTable  ");
        inSql.append(" left outer join T_MM_FinishedRpt as t5 on billTable.fid = t5.FProductionOrderID ");
        inSql.append(" inner join T_IM_ManufactureRecBillEntry  as entry ");
        inSql.append("on  billTable.fid = entry.FManuBillID  ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on t2.fid = entry.fparentid ");
        inSql.append(" where  entry.flot is not null and t2.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flot) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID  ");
        inSql.append(" and t1.flot =t0.flotno and t0.FTimes > t1.Times+1 )");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"28_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" delete T_MM_BatchFile where fid in ");
        inSql.append(" (select t0.fid  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flot,count(*) as times  from T_MM_ProductionOrder as billTable  ");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as entry ");
        inSql.append("on  billTable.fid = entry.FManuBillID  ");
        inSql.append(" inner join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on t2.fid = entry.fparentid  ");
        inSql.append(" where  entry.flot is not null and t2.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flot) as t1, ");
        inSql.append("  T_MM_BatchFile as t0 ");
        inSql.append(" left outer join T_MM_BatchFileEntry t8 on t0.fid=t8.fparentid ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid   and t1.FMaterialID=t0.FMaterialID  ");
        inSql.append("   and t1.flot =t0.flotno and t0.FTimes <=2 and t8.fid is null)");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"28_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(FStorageOrgUnitID,FTimes)  = ");
        inSql.append(" (select t1.FStorageOrgUnitID as FStorageOrgUnitID ,t0.ftimes-t1.Times  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.FLotNumber,count(*) as times  from T_MM_ProductionOrder as billTable  ");
        inSql.append(" left outer join T_MM_FinishedRpt as finishedrpt on billTable.fid = finishedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as entry  ");
        inSql.append(" on  finishedrpt.fid = entry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" where  entry.FLotNumber is not null and t4.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  and billtable.flotno is not null ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.FLotNumber ) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID  ");
        inSql.append(" and t1.FLotNumber =t0.flotno  and t0.FTimes > t1.Times+1 ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"29_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" delete T_MM_BatchFile where fid in");
        inSql.append(" (select t0.fid  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.FLotNumber,count(*) as times  from T_MM_ProductionOrder as billTable  ");
        inSql.append(" left outer join T_MM_FinishedRpt as finishedrpt on billTable.fid = finishedrpt.FProductionOrderID ");
        inSql.append(" inner  join  T_MM_DDMReceivalBillEntry  as entry  ");
        inSql.append(" on  finishedrpt.fid = entry.fsourcebillid ");
        inSql.append(" left outer join T_MM_DDMReceivalBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" where  entry.FLotNumber is not null and t4.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.FLotNumber ) as t1 ");
        inSql.append(" ,T_MM_BatchFile as t0 ");
        inSql.append(" left outer join T_MM_BatchFileEntry t8 on t0.fid=t8.fparentid ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID  ");
        inSql.append(" and t1.FLotNumber =t0.flotno and t0.FTimes <=2 and t8.Fid is null) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"29_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
    }

    private void insertDataToBatchLotByManufactureOrder(Context ctx, String[] ids) throws BOSException {
        String id = SQLUtil.arrayToString((Object[])ids);
        StringBuffer inSql = new StringBuffer();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"37_LotFacadeControllerBean", (Locale)ctx.getLocale()));
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(fstorageorgunitid,FTimes)  = ");
        inSql.append(" (select t1.fstorageorgunitid as fstorageorgunitid ,t1.Times+t0.ftimes  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flot,count(*) as times  from T_MM_ManufactureOrder as billTable  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as entry ");
        inSql.append("on  billTable.fid = entry.FManuBillID  ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on entry.fparentid = t2.fid  ");
        inSql.append(" where  entry.flot is not null and t2.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flot) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID and t1.flot =t0.flotno) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"28_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFile(fid,fcreatorid,fcreatetime,fstorageorgunitid,");
        inSql.append("FLotNo,FMaterialID, FBatchTime,FLotSource,FTimes,FBaseStatus )  ");
        inSql.append(" select newbosid('").append(new BatchFileInfo().getBOSType()).append("')").append(" as fid,'");
        inSql.append(ctx.getCaller().toString()).append("' as fcreatorid, now() as fcreatetime, ");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,t.flot as FLotNo,t.fmaterialid as FMaterialID ,");
        inSql.append("now() as FBatchTime,").append(10).append(" as FLotSource,1 as FTimes ,2 as FBaseStatus");
        inSql.append(" from ( select distinct t1.fstorageorgunitid ,entry.flot ,entry.fmaterialid ");
        inSql.append(" from T_MM_ManufactureOrder as t1");
        inSql.append(" inner  join T_IM_ManufactureRecBillEntry  as entry  ");
        inSql.append(" on  t1.fid = entry.FManuBillID ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as t2 ");
        inSql.append(" on entry.fparentid = t2.fid");
        inSql.append(" where  t2.fbasestatus=4 ");
        inSql.append(" and  t1.fid in(").append(id).append(") ");
        inSql.append(" and entry.fSourceBillID is not null ");
        inSql.append(" and entry.fSourceBillTypeID <> 'WB3X6gEqEADgAAB5fwAAAUY+1VI=' ");
        inSql.append(" ) as t");
        inSql.append(" left outer join T_MM_BatchFile as t2 ");
        inSql.append(" on t.fstorageorgunitid = t2.fstorageorgunitid and t.fmaterialid =t2.fmaterialid ");
        inSql.append("and t.flot= t2.flotno where t2.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"38_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append(" update T_MM_BatchFile as t0 set(fstorageorgunitid,FTimes)  = ");
        inSql.append(" (select t1.fstorageorgunitid as fstorageorgunitid ,t1.Times+t0.ftimes  from ");
        inSql.append("(select billtable.fid, billTable.FStorageOrgUnitID , ");
        inSql.append(" entry.FMaterialID ,entry.flotno,count(*) as times  from T_MM_ManufactureOrder as billTable  ");
        inSql.append(" inner  join  T_MM_DirectSource  as entry  ");
        inSql.append(" on  billTable.fid = entry.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" where  entry.flotno is not null and t4.fbasestatus=4 and billtable.fid in (").append(id).append(") ");
        inSql.append(" and t4.FDestOrgUnitID=billTable.fstorageorgunitid and billTable.FIsDirectSend=1 ");
        inSql.append("  group by   billtable.fid, billTable.FStorageOrgUnitID , entry.FMaterialID ,entry.flotno ) as t1 ");
        inSql.append(" where t1.FStorageOrgUnitID=t0.fstorageorgunitid and t1.FMaterialID=t0.FMaterialID and t1.flotno =t0.flotno) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"29_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFile(fid,fcreatorid,fcreatetime,fstorageorgunitid,");
        inSql.append("FLotNo,FMaterialID, FBatchTime,FLotSource,FTimes,FBaseStatus )  ");
        inSql.append(" select newbosid('").append(new BatchFileInfo().getBOSType()).append("')").append(" as fid,'");
        inSql.append(ctx.getCaller().toString()).append("' as fcreatorid, now() as fcreatetime, ");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,t.flotno as FLotNo,t.fmaterialid as FMaterialID ,");
        inSql.append("now() as FBatchTime,").append(10).append(" as FLotSource,1 as FTimes ,2 as FBaseStatus");
        inSql.append(" from ( select distinct t1.fstorageorgunitid ,entry.flotno ,entry.fmaterialid ");
        inSql.append(" from T_MM_ManufactureOrder as t1");
        inSql.append(" inner  join  T_MM_DirectSource  as entry  ");
        inSql.append(" on  t1.fid = entry.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t2  on entry.fparentid = t2.fid ");
        inSql.append(" where  t2.fbasestatus=4 ");
        inSql.append(" and  t1.fid in(").append(id).append(") ");
        inSql.append(" ) as t");
        inSql.append(" left outer join T_MM_BatchFile as t2 ");
        inSql.append(" on t.fstorageorgunitid = t2.fstorageorgunitid and t.fmaterialid =t2.fmaterialid ");
        inSql.append("and t.flotno= t2.flotno where t2.fstorageorgunitid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"39_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid as fparentid from  T_MM_ManufactureOrder t1  ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DirectSource.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and DirectSource.FLotNo=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fid =t3.fsourcebillid  ");
        inSql.append(" inner join T_IM_MaterialReqBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("   ");
        inSql.append("   and t4.fbasestatus=4  and t2.FMaterialID=t3.FMaterialID  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid  ) as  t  group by t.FMaterialID, t.flot ,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno  and a.fparentid= t0.fparentid) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"40_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flot, count(t.flot) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t3.FMaterialID,t3.flot,batchfile.fid as fparentid from  T_MM_ManufactureOrder t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry  on t1.fid =recbillentry.FManuBillID ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.fparentid = recbill.fid  ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_IM_MaterialReqBillEntry as t3 on t1.fid =t3.fsourcebillid  ");
        inSql.append(" inner join T_IM_MaterialReqBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append("where  t3.flot is not null and t1.fid in(").append(id).append(")");
        inSql.append("  ");
        inSql.append("   and t4.fbasestatus=4   and t2.FMaterialID=t3.FMaterialID  ");
        inSql.append(" group by t1.fid,t3.FMaterialID,t3.flot,batchfile.fid  ) as  t  group by t.FMaterialID, t.flot ,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flot = t0.flotno  and a.fparentid= t0.fparentid) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"41_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flotno, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid as fparentid  from  T_MM_ManufactureOrder t1  ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and DirectSource.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_DirectDest as t3 on t2.fid =t3.FStockId   ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and t3.FPickmaterialId=t7.fmaterialid ");
        inSql.append("where  t7.flotno is not null and t1.fid in(").append(id).append(")");
        inSql.append(" and t4.FDestOrgUnitID=t1.fstorageorgunitid ");
        inSql.append("   and t4.fbasestatus=4 and DirectDeliveryBill.fbasestatus=4  and t2.FMaterialID=t3.FPickMaterialId ");
        inSql.append(" group by t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid ) as  t  group by t.FMaterialID, t.flotno,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flotno = t0.flotno and a.fparentid=t0.fparentid ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"42_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("update T_MM_BatchFileEntry as t0 set (FTimes,FStorageOrgUnitID) = ");
        inSql.append("(select t0.FTimes+ isnull(a.times,0),t0.FStorageOrgUnitID from (  ");
        inSql.append(" select t.FMaterialID, t.flotno, count(*) as times,t.fparentid from ( ");
        inSql.append(" select t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid as fparentid  from  T_MM_ManufactureOrder t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry  on t1.fid =recbillentry.FManuBillID ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.fparentid = recbill.fid  ");
        inSql.append(" inner  join T_MM_BatchFile as batchfile    ");
        inSql.append(" on t1.fstorageorgunitid = batchfile.fstorageorgunitid and recbillentry.fmaterialid =batchfile.fmaterialid ");
        inSql.append(" and recbillentry.flot=batchfile.flotno ");
        inSql.append(" inner  join T_MM_MFTOrderStock as t2  on t1.fid = t2.fparentid ");
        inSql.append(" inner join T_MM_DirectDest as t3 on t2.fid =t3.FStockId   ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on t3.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and t3.FPickmaterialId=t7.fmaterialid ");
        inSql.append("where  t7.flotno is not null and t1.fid in(").append(id).append(")");
        inSql.append("  and t4.FDestOrgUnitID=t1.fstorageorgunitid ");
        inSql.append("   and t4.fbasestatus=4 and t2.FMaterialID=t3.FPickMaterialId ");
        inSql.append(" group by t1.fid,t7.FMaterialID,t7.flotno,batchfile.fid ) as  t  group by t.FMaterialID, t.flotno,t.fparentid ");
        inSql.append(" )  as a ");
        inSql.append("where a.FMaterialID = t0.FMaterialID  and a.flotno = t0.flotno and a.fparentid=t0.fparentid ) ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"42_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLot   as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID,10 as FLotSource ");
        inSql.append(" from  (");
        inSql.append(" \tselect distinct t2.fid as fid, entry.FLot,t1.fstorageorgunitid ,entry.fmaterialid    ");
        inSql.append(" from T_MM_ManufactureOrder as t1   ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner join  T_MM_MFTOrderStock as t3 on t1.fid = t3.FParentID   ");
        inSql.append(" inner  join T_IM_MaterialReqBillEntry  as entry  on t1.fid = entry.FSourceBillID     ");
        inSql.append(" inner join T_IM_MaterialReqBill  as t4  on entry.fparentid = t4.fid  ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and DirectSource.fmaterialid =t2.fmaterialid ");
        inSql.append("and DirectSource.flotno= t2.flotno where  ");
        inSql.append(" t1.fid in(").append(id).append(")  and entry.FLot is not null");
        inSql.append(" and  entry.FMaterialID=t3.FMaterialID ");
        inSql.append("    and t4.fbasestatus=4  and t2.fstorageorgunitid is not null  ) as t ");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.flot= t5.flotno  and t.fid =t5.fparentid where t5.fid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"43_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLot   as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID , 10 as FLotSource ");
        inSql.append(" from  (");
        inSql.append(" \tselect distinct t2.fid as fid, entry.FLot,t1.fstorageorgunitid ,entry.fmaterialid    ");
        inSql.append(" from T_MM_ManufactureOrder as t1   ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry ");
        inSql.append("on  t1.fid = recbillentry.FManuBillID");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.fparentid = recbill.fid  ");
        inSql.append(" inner join  T_MM_MFTOrderStock as t3 on t1.fid = t3.FParentID   ");
        inSql.append(" inner  join T_IM_MaterialReqBillEntry  as entry  on t1.fid = entry.FSourceBillID     ");
        inSql.append(" inner join T_IM_MaterialReqBill  as t4  on entry.fparentid = t4.fid  ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and recbillentry.fmaterialid =t2.fmaterialid ");
        inSql.append("and recbillentry.flot= t2.flotno where  ");
        inSql.append(" t1.fid in(").append(id).append(")  and entry.FLot is not null");
        inSql.append(" and  entry.FMaterialID=t3.FMaterialID ");
        inSql.append("    and t4.fbasestatus=4  and t2.fstorageorgunitid is not null ");
        inSql.append(" and recbillentry.fsourceBillID is not null ");
        inSql.append(" and recbillentry.fSourceBillTypeID <> 'WB3X6gEqEADgAAB5fwAAAUY+1VI=' ");
        inSql.append(") as t ");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.flot= t5.flotno  and t.fid =t5.fparentid where t5.fid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"44_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLotno   as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID ,10 as FLotSource");
        inSql.append(" from  (");
        inSql.append(" select distinct t2.fid as fid, t7.FLotno,t1.fstorageorgunitid ,t3.fmaterialid   ");
        inSql.append(" from T_MM_ManufactureOrder as t1  ");
        inSql.append("inner  join T_IM_ManufactureRecBillEntry  as recbillentry ");
        inSql.append("on  t1.fid = recbillentry.FManuBillID  ");
        inSql.append(" left outer join T_IM_ManufactureRecBill  as recbill ");
        inSql.append(" on recbillentry.FParentID = recbill.fid  ");
        inSql.append(" inner join  T_MM_MFTOrderStock as t3 on t1.fid = t3.FParentID ");
        inSql.append(" inner  join  T_MM_DirectDest  as entry  ");
        inSql.append(" on  t3.fid = entry.FStockId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and entry.FPickmaterialId=t7.fmaterialid ");
        inSql.append(" inner join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and recbillentry.fmaterialid =t2.fmaterialid ");
        inSql.append("and recbillentry.FLot= t2.flotno where t2.fstorageorgunitid is not null  ");
        inSql.append(" and  t1.fid in(").append(id).append(")  and t7.FLotno is not null");
        inSql.append("   and t4.FDestOrgUnitID=t1.fstorageorgunitid ");
        inSql.append("   and t4.fbasestatus=4  and  t3.FMaterialID=entry.FPickMaterialId   ) as t");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.flotno= t5.flotno and t.fid =t5.fparentid  where t5.fid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"45_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
        inSql.setLength(0);
        inSql.append("insert into T_MM_BatchFileEntry(fid,FParentID,FLotNo,FStorageOrgUnitID,FTimes,FMaterialID,FLotSource)");
        inSql.append(" select newbosid('").append(new BatchFileEntryInfo().getBOSType()).append("')").append(" as fid,");
        inSql.append("t.fid as FParentID,   ");
        inSql.append("t.FLotno   as FLotNo,");
        inSql.append("t.fstorageorgunitid as  fstorageorgunitid,1 as FTimes, ");
        inSql.append(" t.fmaterialid  ");
        inSql.append(" as FMaterialID,10 as FLotSource ");
        inSql.append(" from  (");
        inSql.append(" select distinct t2.fid as fid, t7.FLotno,t1.fstorageorgunitid ,t3.fmaterialid   ");
        inSql.append(" from T_MM_ManufactureOrder as t1  ");
        inSql.append(" inner  join  T_MM_DirectSource  as DirectSource  ");
        inSql.append(" on  t1.fid = DirectSource.FMoId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as DirectDeliveryBill  on DirectSource.fparentid = DirectDeliveryBill.fid ");
        inSql.append(" inner join  T_MM_MFTOrderStock as t3 on t1.fid = t3.FParentID ");
        inSql.append(" inner  join  T_MM_DirectDest  as entry  ");
        inSql.append(" on  t3.fid = entry.FStockId ");
        inSql.append(" left outer join T_MM_DirectDeliveryBill  as t4  on entry.fparentid = t4.fid ");
        inSql.append(" left outer join T_MM_DirectSource  as t7  on t7.fparentid = t4.fid and entry.FPickmaterialId=t7.fmaterialid ");
        inSql.append(" left outer join T_MM_BatchFile as t2");
        inSql.append("  on t1.fstorageorgunitid = t2.fstorageorgunitid and DirectSource.fmaterialid =t2.fmaterialid ");
        inSql.append("and DirectSource.FLotno= t2.flotno where t2.fstorageorgunitid is not null and DirectDeliveryBill.fbasestatus = 4 ");
        inSql.append(" and  t1.fid in(").append(id).append(")  and t7.FLotno is not null");
        inSql.append("   and t4.FDestOrgUnitID=t1.fstorageorgunitid ");
        inSql.append("   and t4.fbasestatus=4   and  t3.FMaterialID=entry.FPickMaterialId  ) as t");
        inSql.append(" left outer join T_MM_BatchFileEntry  as t5   ");
        inSql.append("  on t.fstorageorgunitid = t5.fstorageorgunitid and t.fmaterialid =t5.fmaterialid ");
        inSql.append(" and t.flotno= t5.flotno and t.fid =t5.fparentid  where t5.fid is null ");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"45_LotFacadeControllerBean", (Locale)ctx.getLocale()) + inSql.toString() + "-----------------"));
        DbUtil.execute((Context)ctx, (String)inSql.toString());
    }

    @Override
    protected void _deleteLot(Context ctx, String[] ids, BillTypeEnum typeEnum) throws BOSException, EASBizException {
        this.deleteLotSourceEntry(ctx, ids, typeEnum);
        this.deleteLotSourceHead(ctx, ids, typeEnum);
    }

    @Override
    protected void _insertLot(Context ctx, String[] id, BillTypeEnum typeEnum) throws BOSException, EASBizException {
        this.insertIntoLotSouceHead(ctx, id, typeEnum);
        this.insertLotSouceEntry(ctx, id, typeEnum);
    }

    private void insertLotParam(Context ctx, LotSourceBillInfo info) throws BOSException, EASBizException {
        String materialID = info.getMaterial().getId().toString();
        String orgUnitID = info.getStorageOrgUnit().getId().toString();
        String lot = info.getLot();
        if (materialID == null) {
            throw new LotTraceFacadeException(LotTraceFacadeException.LOT_IS_NOT_NULL);
        }
        if (orgUnitID == null) {
            throw new LotTraceFacadeException(LotTraceFacadeException.LOT_IS_NOT_NULL);
        }
        if (lot == null) {
            throw new LotTraceFacadeException(LotTraceFacadeException.LOT_IS_NOT_NULL);
        }
        if (info.getEntrys().size() < 1) {
            throw new LotTraceFacadeException(LotTraceFacadeException.LOT_IS_NOT_NULL);
        }
        StringBuffer selecSQL = new StringBuffer();
        selecSQL.append("select t.fid from T_MM_LotSourceBill t where  ");
        selecSQL.append("  t.FMaterialID ='").append(materialID).append("'");
        selecSQL.append(" and t.FStorageOrgUnitID ='").append(orgUnitID).append("'");
        selecSQL.append(" and t.flot ='").append(lot).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selecSQL.toString());
        String fid = null;
        try {
            while (rs.next()) {
                fid = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (fid == null) {
            LotSourceBillFactory.getLocalInstance(ctx).save(info);
        } else {
            LotSourceBillInfo infoother = (LotSourceBillInfo)LotSourceBillFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(fid));
            LotSourceBillEntryInfo lotSourceBillEntryInfo = null;
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                lotSourceBillEntryInfo = info.getEntrys().get(i);
                infoother.getEntrys().add(lotSourceBillEntryInfo);
            }
            LotSourceBillFactory.getLocalInstance(ctx).save(infoother);
        }
    }

    @Override
    protected void _insertLotSourceBillValue(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        LotSourceBillInfo info = (LotSourceBillInfo)objectValue;
        this.insertLotParam(ctx, info);
    }

    private void deleteLotSourceBillValue(Context ctx, LotSourceBillInfo info) throws BOSException, EASBizException {
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            String id = info.getEntrys().get(i).getBillId();
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("delete from T_MM_LotSourceBillEntry where  FBillId in('");
            insertSql.append(id).append("')");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_MM_LotSourceBill where  fid  in(  ");
        sql.append("select t.fid  from t_mm_lotsourcebill t ");
        sql.append(" left outer join  t_mm_lotsourcebillentry entry ");
        sql.append(" on t.fid = entry.fparentid where t.fid in('").append(info.getId().toString()).append("')and entry.fid is null ");
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _deleteLotSourceBillValue(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        LotSourceBillInfo info = (LotSourceBillInfo)objectValue;
        this.deleteLotSourceBillValue(ctx, info);
    }

    @Override
    protected String _isTaskToProductRec(Context ctx, String orgId, String lotNo, String srcBillTypeID) throws BOSException, EASBizException {
        logger.debug((Object)"---------------------begin taskToProductRec---------------------");
        if (orgId != null) {
            LotParamValueInfo lotParamValueByOrg = (LotParamValueInfo)this._getLotParamValueByOrg(ctx, orgId);
            if ("B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(srcBillTypeID)) {
                logger.debug((Object)"---------------------DMPRODUCTORDER_BILLTYPEID---------------------");
                return this.getManLotNo(lotParamValueByOrg, lotNo);
            }
            if ("HxPKDRdzRpaqr31LD+3SBEY+1VI=".equals(srcBillTypeID)) {
                return this.getManLotNo(lotParamValueByOrg, lotNo);
            }
            if ("e3soUQaBR8un8D2R7UpNwkY+1VI=".equals(srcBillTypeID)) {
                return this.getProductLotNo(lotParamValueByOrg, lotNo);
            }
            if ("ejIZHXXTQliYCQJg9t4Re0Y+1VI=".equals(srcBillTypeID)) {
                return this.getProductLotNo(lotParamValueByOrg, lotNo);
            }
        }
        return null;
    }

    private String getManLotNo(LotParamValueInfo lotParamValueByOrg, String lotNo) {
        if (lotParamValueByOrg != null && lotParamValueByOrg.isManufactureRec()) {
            return lotNo;
        }
        return null;
    }

    private String getProductLotNo(LotParamValueInfo lotParamValueByOrg, String lotNo) {
        if (lotParamValueByOrg != null && lotParamValueByOrg.isProductionOrderRec()) {
            return lotNo;
        }
        return null;
    }
}

