/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMBaseException;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.lot.BatchFileCollection;
import com.kingdee.eas.mm.lot.BatchFileEntryCollection;
import com.kingdee.eas.mm.lot.BatchFileEntryFactory;
import com.kingdee.eas.mm.lot.BatchFileEntryInfo;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.IBatchFileEntry;
import com.kingdee.eas.mm.lot.LotTraceFacadeException;
import com.kingdee.eas.mm.lot.QueryTypeEnum;
import com.kingdee.eas.mm.lot.app.AbstractLotTraceFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;

public class LotTraceFacadeControllerBean
extends AbstractLotTraceFacadeControllerBean {
    private static final long serialVersionUID = -3776429925299833314L;
    private static Logger logger = Logger.getLogger((String)LotTraceFacadeControllerBean.class.getName());
    private Map srcMaterialMap = null;

    public Map getSrcMaterialMap() {
        if (null == this.srcMaterialMap) {
            this.srcMaterialMap = new HashMap();
        }
        return this.srcMaterialMap;
    }

    @Override
    protected List _materialTrace(Context ctx, String batchFileEntryId, String storageOrgUnitId, QueryTypeEnum queryType) throws BOSException, EASBizException {
        LinkedList<BatchFileInfo> traceData = null;
        BatchFileEntryInfo root = this.getBatchFileEntryInfoById(ctx, batchFileEntryId);
        int degree = 1;
        IBatchFileEntry iBatchFileEntry = BatchFileEntryFactory.getLocalInstance(ctx);
        BatchFileCollection roots = this.getChildrenNode(iBatchFileEntry, degree, storageOrgUnitId, root.getMaterial().getId().toString(), root.getLotNo(), root.getMaterial().getName());
        if (10 == queryType.getValue()) {
            return this.toList(roots);
        }
        boolean isMultitier = 20 == queryType.getValue();
        Stack stack = new Stack();
        if (null != roots && roots.size() > 0) {
            this.push(stack, roots);
        }
        traceData = new LinkedList<BatchFileInfo>();
        BatchFileCollection children = null;
        while (!stack.isEmpty()) {
            BatchFileInfo top = (BatchFileInfo)stack.pop();
            while (null != top) {
                degree = top.getInt("ep_degree_20080923") + 1;
                if (degree > 50) {
                    String errorMsg = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"LotTraceCycleError", (String[])new String[]{top.getString("ep_OfMaterial_20080923"), top.getString("ep_OfMaterialLot_20080923")});
                    String errorMsg2 = ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"LotTraceCycleError", (Locale)ctx.getLocale());
                    throw new LotTraceFacadeException(LotTraceFacadeException.BLANK, new String[]{errorMsg});
                }
                children = this.getChildrenNode(iBatchFileEntry, degree, storageOrgUnitId, top.getMaterial().getId().toString(), top.getLotNo(), top.getMaterial().getName());
                if (null != children && children.size() > 0) {
                    this.push(stack, children);
                    if (isMultitier) {
                        traceData.addLast(top);
                    }
                    top = (BatchFileInfo)stack.pop();
                    continue;
                }
                traceData.addLast(top);
                top = null;
            }
        }
        return traceData;
    }

    private BatchFileCollection getChildrenNode(IBatchFileEntry iBatchFileEntry, int degree, String storageOrgUnitId, String materialId, String lotNo, String materialName) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("lotNo", (Object)lotNo, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.material.id"));
        sic.add(new SelectorItemInfo("parent.material.number"));
        sic.add(new SelectorItemInfo("parent.material.name"));
        sic.add(new SelectorItemInfo("parent.material.model"));
        sic.add(new SelectorItemInfo("parent.lotNo"));
        sic.add(new SelectorItemInfo("parent.createTime"));
        view.setSelector(sic);
        BatchFileEntryCollection entrys = iBatchFileEntry.getBatchFileEntryCollection(view);
        BatchFileCollection bills = new BatchFileCollection();
        Iterator iter = entrys.iterator();
        while (iter.hasNext()) {
            BatchFileEntryInfo element = (BatchFileEntryInfo)iter.next();
            if (bills.contains(element.getParent())) continue;
            bills.add(element.getParent());
        }
        String structCode = this.createStructCode(degree);
        if (null != bills && bills.size() > 0) {
            Iterator iter2 = bills.iterator();
            while (iter2.hasNext()) {
                BatchFileInfo element = (BatchFileInfo)iter2.next();
                element.put("ep_degree_20080923", new Integer(degree));
                element.put("ep_structCode_20080923", structCode);
                element.put("ep_OfMaterial_20080923", materialName);
                element.put("ep_OfMaterialLot_20080923", lotNo);
            }
        }
        return bills;
    }

    private BatchFileEntryInfo getBatchFileEntryInfoById(Context ctx, String batchFileEntryId) throws BOSException, EASBizException {
        BatchFileEntryInfo batchFileEntryInfo = null;
        batchFileEntryInfo = (BatchFileEntryInfo)this.getSrcMaterialMap().get(batchFileEntryId);
        if (null == batchFileEntryInfo) {
            ObjectSingleKey pk = new ObjectSingleKey((Object)batchFileEntryId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.model"));
            this.isExistCheck(ctx, batchFileEntryId);
            batchFileEntryInfo = BatchFileEntryFactory.getLocalInstance(ctx).getBatchFileEntryInfo((IObjectPK)pk, sic);
            this.getSrcMaterialMap().put(batchFileEntryId, batchFileEntryInfo);
        }
        return batchFileEntryInfo;
    }

    private void isExistCheck(Context ctx, String batchFileEntryId) throws EASBizException, BOSException {
        try {
            boolean isExist = false;
            String sql = "select FID from T_MM_batchFileEntry where FID ='" + batchFileEntryId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                isExist = true;
            }
            if (!isExist) {
                throw new MMBaseException(MMBaseException.RECORD_NOT_EXIST);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String createStructCode(int degree) {
        StringBuffer code = new StringBuffer();
        int starLength = degree;
        if (degree > 8) {
            starLength = 8;
        }
        for (int i = 0; i < starLength; ++i) {
            code.append("*");
        }
        return code.append(degree).toString();
    }

    private void push(Stack stack, BatchFileCollection cols) {
        for (int i = cols.size(); i > 0; --i) {
            stack.push(cols.get(i - 1));
        }
    }

    private List toList(BatchFileCollection cols) {
        if (null == cols || cols.size() < 1) {
            return null;
        }
        LinkedList list = new LinkedList();
        Iterator iter = cols.iterator();
        while (iter.hasNext()) {
            list.addLast(iter.next());
        }
        return list;
    }

    private HashMap getLotCreateTime(Context ctx, String storageOrgUnitId, String materialId, Set lotNo) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (lotNo != null && lotNo.size() > 0) {
            String lotNos = MMUtils.setToString((Set)lotNo);
            StringBuffer str = new StringBuffer();
            str.append(" select distinct '").append(materialId).append("' as materialId ,flotNo,");
            str.append(" to_char(fcreatetime,'YYYY-MM-DD')as fcreatetime ");
            str.append(" from T_MM_BatchFile where FMaterialID = '").append(materialId);
            str.append("' and FStorageOrgUnitID =  '").append(storageOrgUnitId);
            str.append("' and flotNo in ").append(lotNos);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            try {
                while (rs.next()) {
                    String key = rs.getString("materialId") + "_" + rs.getString("flotNo");
                    String date = rs.getString("fcreatetime");
                    map.put(key, date);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return map;
    }

    @Override
    protected List _querySrcMaterial(Context ctx, String storageOrgUnitId, String materialId, Set lotNo, QueryTypeEnum queryType, SorterItemCollection sorterItemCollection, FilterInfo commonFilterInfo) throws BOSException, EASBizException {
        LinkedList<List> rs = new LinkedList<List>();
        IBatchFileEntry iBatchFileEntry = BatchFileEntryFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("lotNo"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("lotNo", (Object)lotNo, CompareType.INCLUDE));
        String maskString = "#0 and #1 and #2 ";
        filterInfo.setMaskString("#0 and #1 and #2 ");
        if (commonFilterInfo != null) {
            filterInfo.mergeFilter(commonFilterInfo, "AND");
        }
        FilterItemCollection filters = filterInfo.getFilterItems();
        for (int i = 0; i < filters.size(); ++i) {
            FilterItemInfo filter = filters.get(i);
            if (!filter.getCompareValue().toString().equalsIgnoreCase("empty")) continue;
            if (filter.getCompareType().equals((Object)CompareType.IS)) {
                filter.setCompareType(CompareType.EQUALS);
            } else if (filter.getCompareType().equals((Object)CompareType.ISNOT)) {
                filter.setCompareType(CompareType.NOTEQUALS);
            }
            filter.getCompareValue().toString().equalsIgnoreCase("empty");
            filter.setCompareValue(null);
        }
        view.setFilter(filterInfo);
        view.setSorter(sorterItemCollection);
        BatchFileEntryCollection batchFileEntryCollection = iBatchFileEntry.getBatchFileEntryCollection(view);
        LinkedList<String[]> list = new LinkedList<String[]>();
        HashSet<String> materialLotNo = new HashSet<String>();
        String key = null;
        HashMap map = this.getLotCreateTime(ctx, storageOrgUnitId, materialId, lotNo);
        if (null != batchFileEntryCollection && batchFileEntryCollection.size() > 0) {
            Iterator iter = batchFileEntryCollection.iterator();
            while (iter.hasNext()) {
                BatchFileEntryInfo element = (BatchFileEntryInfo)iter.next();
                key = element.getMaterial().getId().toString() + "_" + element.getLotNo();
                if (materialLotNo.contains(key)) continue;
                list.add(new String[]{element.getId().toString(), element.getMaterial().getNumber(), element.getMaterial().getName(), element.getMaterial().getModel(), element.getLotNo(), (String)map.get(key)});
                materialLotNo.add(key);
            }
        }
        rs.add(list);
        if (null != list && list.size() > 0) {
            String firstSrcMaterialId = ((String[])list.get(0))[0];
            List productList = this.materialTrace(ctx, firstSrcMaterialId, storageOrgUnitId, queryType);
            rs.addLast(productList);
        }
        return rs;
    }

    @Override
    protected String _getMaterialSaleOrgIds(Context ctx, String materialId) throws BOSException, EASBizException {
        String kSQL = "select s.FOrgUnit from T_BD_MaterialSales s where s.FMaterialID = ? ";
        StringBuffer rs = new StringBuffer();
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)kSQL, (Object[])new Object[]{materialId});
        if (null != rows) {
            try {
                while (rows.next()) {
                    rs.append("," + rows.getString(1));
                }
                if (rs.length() > 0) {
                    rs.deleteCharAt(0);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rs.toString();
    }
}

