/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.maf.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.IJZLogger;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;

public abstract class AbstractDeleteTask
extends CodeJZTask {
    public static final int VERSION_VALUE = -3;
    public static final int ALTERING_VALUE = -2;
    public static final int NULL_VALUE = -1;
    public static final int ADD_VALUE = 0;
    public static final int TEMPORARILYSAVED_VALUE = 1;
    public static final int SUBMITED_VALUE = 2;
    public static final int DELETED_VALUE = 3;
    public static final int AUDITED_VALUE = 4;
    public static final int RELEASED_VALUE = 5;
    public static final int BLOCKED_VALUE = 6;
    public static final int CLOSED_VALUE = 7;
    public static final int COMPLETE_VALUE = 8;
    public static final int FINISH_VALUE = 90;
    public static final int PUBLISHED_VALUE = 10;
    protected IJZLogger logger = null;

    private void log(String msg) throws JZTaskException {
        if (this.logger == null) {
            throw new JZTaskException("\u65e5\u5fd7\u8f93\u51fa\u8bbe\u7f6e\u5f02\u5e38", 5);
        }
        this.logger.println(msg);
    }

    protected void execute(KDConnection dbConn, String SQLScript, String description) throws JZTaskException {
        this.log("\u6267\u884c\u3010" + description + "\u3011\u5f00\u59cb...");
        PreparedStatement pst = null;
        try {
            pst = dbConn.prepareStatement(SQLScript);
            pst.execute();
        }
        catch (SQLException e) {
            this.log(" SQLException \uff1a " + e.getMessage());
            throw new JZTaskException(e.getMessage(), 5);
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                    pst = null;
                }
                catch (SQLException e) {
                    throw new JZTaskException(e.toString(), 1);
                }
            }
        }
        this.log("  \u3010" + description + "\u3011\u7ed3\u675f");
    }

    protected String getStorageOrgUnitIDAry(String toOrgUnitID, JZContext context) throws SQLException, JZTaskException {
        String SCtypeRelationFId = "00000000-0000-0000-0000-0000000000070FE9F8B5";
        List fromOrgUnit = super.getFromOrgUnit(toOrgUnitID, SCtypeRelationFId, context);
        String idStr = "";
        for (int i = 0; i < fromOrgUnit.size(); ++i) {
            if (i > 0) {
                idStr = idStr + ",";
            }
            idStr = idStr + "'" + fromOrgUnit.get(i) + "'";
        }
        if (idStr.length() < 3) {
            this.log("\u6ca1\u6709\u59d4\u6258\u8d22\u52a1\u7ec4\u7ec7(" + toOrgUnitID + ")\u7684\u5e93\u5b58\u7ec4\u7ec7");
            return "'null'";
        }
        return idStr;
    }

    protected String getSqlStrConvert(Timestamp timestamp) {
        return " {ts'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(timestamp) + "'} ";
    }

    protected String getSqlProductionOrderFilter(String storageIDs, Timestamp endDt) {
        StringBuffer ksqlBuf = new StringBuffer();
        ksqlBuf.append(" SELECT  FID  ");
        ksqlBuf.append(" FROM  T_MM_ProductionOrder  ");
        ksqlBuf.append(" WHERE  FStorageOrgUnitID  IN (" + storageIDs + ")  ");
        ksqlBuf.append(" \tAND  FEndDate    < ").append(this.getSqlStrConvert(endDt));
        ksqlBuf.append("    AND (FBaseStatus = 7 OR FBaseStatus = 3)");
        ksqlBuf.append("    AND FID NOT IN (select FProductionOrderID from T_MM_TaskDispBill where FBaseStatus <> 7  and FProductionOrderID is not null)");
        ksqlBuf.append("    AND FID NOT IN (select FProductionOrderID from T_MM_FinishedRpt where FBaseStatus <> 7  and FProductionOrderID is not null)");
        ksqlBuf.append("    AND FID NOT IN (select FProductionOrderID from T_MM_PickingSlipBill where FBaseStatus <> 7 and FBaseStatus <> 3  and FProductionOrderID is not null)");
        return ksqlBuf.toString();
    }

    protected String getSqlManufactureOrderFilter(String storageIDs, Timestamp endDt) {
        StringBuffer ksqlBuf = new StringBuffer();
        ksqlBuf.append(" SELECT  FID  ");
        ksqlBuf.append(" FROM  T_MM_ManufactureOrder  ");
        ksqlBuf.append(" WHERE  FStorageOrgUnitID  IN (" + storageIDs + ")  ");
        ksqlBuf.append("        AND  FPlanEndDate   < ").append(this.getSqlStrConvert(endDt));
        ksqlBuf.append("        AND  (FBaseStatus = 7 OR FBaseStatus = 3)");
        return ksqlBuf.toString();
    }
}

