/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.mo.GroupTypeEnum;
import com.kingdee.eas.mm.mo.MaterialRelationCollection;
import com.kingdee.eas.mm.mo.MaterialRelationFactory;
import com.kingdee.eas.mm.mo.MaterialRelationInfo;
import com.kingdee.eas.mm.mo.MaterialTransactionPlatformFacadeFactory;
import com.kingdee.eas.mm.mo.MaterialTypeEnum;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMaterialTransactionBOT {
    protected static MaterialRelationCollection relations;
    protected GroupTypeEnum groupType;
    protected MaterialTypeEnum materialType;
    protected IObjectCollection sourceColls;
    protected Map reqID;
    protected String type;
    protected BTPTransformResult btpResult;

    protected abstract void beforeTransform(Context var1) throws EASBizException, BOSException;

    protected abstract void afterTransform(Context var1) throws EASBizException, BOSException;

    protected BTPTransformResult innerTransform(Context ctx) throws EASBizException, BOSException {
        String botpID = "";
        if (relations == null) {
            relations = MaterialRelationFactory.getLocalInstance(ctx).getMaterialRelationCollection();
        }
        int size = relations.size();
        for (int i = 0; i < size; ++i) {
            MaterialRelationInfo materialRelationInfo = relations.get(i);
            if (this.groupType != materialRelationInfo.getGroupType() || this.materialType != materialRelationInfo.getMaterialType()) continue;
            botpID = materialRelationInfo.getBotpID();
            break;
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpID)));
        }
        catch (Exception e) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new PlanOrderException(PlanOrderException.RELEASE_BOTP_NOT_EFFECTED);
        }
        BTPTransformResult result = iBTPManager.transformForBotp((CoreBillBaseCollection)this.sourceColls, "500AB75E", (IObjectPK)new ObjectUuidPK(botpID));
        IObjectCollection materialReqBills = result.getBills();
        HashMap<String, String> map = new HashMap<String, String>();
        if (materialReqBills != null) {
            for (int i = 0; i < materialReqBills.size(); ++i) {
                MaterialReqBillInfo materialReqBill = (MaterialReqBillInfo)materialReqBills.getObject(i);
                String number = materialReqBill.getNumber().toString();
                String id = materialReqBill.getId().toString();
                map.put(id, number);
            }
        }
        if (map != null) {
            MaterialTransactionPlatformFacadeFactory.getLocalInstance(ctx).delReqBills(map, (MaterialReqBillInfo)result.getBills().getObject(0));
        }
        return result;
    }

    public BTPTransformResult transform(Context ctx) throws EASBizException, BOSException {
        this.beforeTransform(ctx);
        this.btpResult = this.innerTransform(ctx);
        this.afterTransform(ctx);
        return this.btpResult;
    }
}

