/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.MOBackFlush;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BackFlushHandler {
    protected Context ctx;
    private boolean isAudit = true;

    public BackFlushHandler() {
    }

    public BackFlushHandler(Context context, boolean isAuditAction) {
        this.ctx = context;
        this.isAudit = isAuditAction;
    }

    public void toStoreBackFlush(String sourceDataTable) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select FSourceBillID,sum(FBaseQty) FBaseQty ");
        sqlBuffer.append(" from ").append(sourceDataTable).append(" group by FSourceBillID ");
        try {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
            while (rs.next()) {
                BigDecimal baseQty = rs.getBigDecimal("FBaseQty");
                String moId = rs.getString("FSourceBillID");
                map.put(moId, baseQty);
            }
            this.writeToStoreBaseQty(this.calcBackFlushQty(map));
            this.writeToStoreQty(sourceDataTable);
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    protected Map calcBackFlushQty(Map params) throws BOSException, EASBizException {
        HashMap backFlushMap = new HashMap();
        ManufactureOrderCollection moCol = ManufactureOrderFactory.getLocalInstance(this.ctx).getManufactureOrderCollection(this.getMOEntityView(params.keySet()));
        for (int i = 0; i < moCol.size(); ++i) {
            ManufactureOrderInfo moInfo = moCol.get(i);
            BigDecimal productBaseQty = (BigDecimal)params.get(moInfo.getId().toString());
            MOBackFlush moBackFlush = new MOBackFlush();
            moBackFlush.setMoInfo(moInfo);
            moBackFlush.setProductBaseQty(productBaseQty);
            moBackFlush.setIsAudit(this.isAudit);
            backFlushMap.putAll(moBackFlush.calcBackFlushQty());
        }
        return backFlushMap;
    }

    protected void writeToStoreBaseQty(Map backFlushMap) throws BOSException {
        String sign;
        String string = sign = this.isAudit ? "+" : "-";
        if (backFlushMap != null && backFlushMap.size() > 0) {
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                String updateSql = "update T_MM_MFTOrderStock set FToStoreBaseQty = FToStoreBaseQty " + sign + " ? where FID = ? ";
                conn = EJBFactory.getConnection((Context)this.ctx);
                ps = conn.prepareStatement(updateSql);
                for (String entryID : backFlushMap.keySet()) {
                    BigDecimal qty = (BigDecimal)backFlushMap.get(entryID);
                    ps.setBigDecimal(1, qty);
                    ps.setString(2, entryID);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    protected void writeToStoreQty(String tempTableName) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_MM_MFTOrderStock as a ").append("set (FToStoreQty) = ").append("(select round(decimal(a.FToStoreBaseQty / b.FBaseConvsRate,21,8),b.FQtyPrecision) ").append("from (SELECT DISTINCT FSOURCEBILLID AS FSOURCEBILLID FROM ").append(tempTableName).append(") t,").append("t_bd_multimeasureunit  b ").append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ").append("and a.FParentId  = t.FSourceBillId ").append(")");
        DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString());
    }

    protected EntityViewInfo getMOEntityView(Set todIds) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getMOSelector());
        viewInfo.setFilter(this.getMOFilter(todIds));
        return viewInfo;
    }

    protected SelectorItemCollection getMOSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        this.addHeadSelectorItems(sic);
        this.addStockEntrySelectorItems(sic);
        return sic;
    }

    protected FilterInfo getMOFilter(Set todIds) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)todIds, CompareType.INCLUDE));
        return filter;
    }

    protected void addHeadSelectorItems(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("totalSplitBaseQty"));
        sic.add(new SelectorItemInfo("transactionType.backFlushQtyBase"));
    }

    protected void addStockEntrySelectorItems(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("stocks.id"));
        sic.add(new SelectorItemInfo("stocks.baseQty"));
        sic.add(new SelectorItemInfo("stocks.plannedBaseQty"));
        sic.add(new SelectorItemInfo("stocks.unitBaseQty"));
        sic.add(new SelectorItemInfo("stocks.toStoreBaseQty"));
        sic.add(new SelectorItemInfo("stocks.replaceGroupFlag"));
    }

    public void setIsAudit(boolean arg) {
        this.isAudit = arg;
    }

    public boolean isAudit() {
        return this.isAudit;
    }
}

