/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;

public class CalculateWipUtil {
    public static void updateWipByTemTable(Context ctx, String tempTable) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(CalculateWipUtil.buildUpdateStoreQtySql()).append(" where exists(select 1 from ").append(tempTable).append(" as tt WHERE stock.FID =tt.FSourceBillEntryId)").append(" and exists(select 1 from T_MM_ManufactureOrder as MOORDER where stock.fparentid = moorder.fid AND (moorder.fqty - moorder.ftotalSplitQty) > 0) ").append(" AND (stock.FIssueMode != ").append(11040).append(")");
        CalculateWipUtil.execute(ctx, sqlBuf.toString());
        sqlBuf.setLength(0);
        sqlBuf.append(CalculateWipUtil.buildUpdateWipQtySql());
        sqlBuf.append(" FROM T_MM_ManufactureOrder moorder  WHERE stock.fparentid=moorder.fid) ");
        sqlBuf.append(" where stock.FIssueMode != 11040");
        sqlBuf.append(" and stock.fid in (select FSourceBillEntryId from ").append(tempTable).append(") ");
        CalculateWipUtil.execute(ctx, sqlBuf.toString());
    }

    public static void updateWipByTemTableEMM(Context ctx, String tempTable) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Update T_MM_MFTOrderStock UT\r\n");
        sql.append("Set\r\n");
        sql.append("FToStoreQty=FActIssueQty,\r\n");
        sql.append("FToStoreBaseQty=FActIssueBaseQty\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FSourceBillEntryID\r\n");
        sql.append("From ").append(tempTable).append(" T\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=T.FSourceBillID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FToStroreQty>=MO.FQty\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("Update T_MM_MFTOrderStock UT\r\n");
        sql.append("Set\r\n");
        sql.append("FToStoreQty=0,\r\n");
        sql.append("FToStoreBaseQty=0\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FSourceBillEntryID\r\n");
        sql.append("From ").append(tempTable).append(" T\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=T.FSourceBillID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FToStroreQty<MO.FQty\r\n");
        sql.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_MM_MFTOrderStock ").append(" SET FWipQty = FActIssueQty + FTotalDirectReceiveQty + FFeedingQty + FMaterialFeedingQty").append(" - FScrapQty - FMaterialScrapQty - FRejectedQty - FToStoreQty - FTotalDSTransferQty, ").append(" FWipBaseQty = FActIssueBaseQty + FTotalDirectReceiveBaseQty + FFeedingBaseQty + FMaterialFeedingBaseQty").append(" - FScrapBaseQty - FMaterialScrapBaseQty - FRejectedBaseQty - FToStoreBaseQty - FTotalDSTransferBaseQty").append(" WHERE FID in (select FSourceBillEntryId from ").append(tempTable).append(") ");
        DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
    }

    public static void updateWipForMoOrders(Context ctx, String[] moIDS) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        String idStr = SQLUtil.arrayToString((Object[])moIDS);
        sqlBuf.append(CalculateWipUtil.buildUpdateStoreQtySql()).append(" where exists(select 1 from T_MM_ManufactureOrder as MOORDER where stock.fparentid = moorder.fid AND (moorder.fqty - moorder.ftotalSplitQty) > 0 ").append(" and  moorder.FID in (").append(idStr).append("))").append(" AND (stock.FIssueMode != ").append(11040).append(")");
        CalculateWipUtil.execute(ctx, sqlBuf.toString());
        sqlBuf.setLength(0);
        sqlBuf.append(CalculateWipUtil.buildUpdateWipQtySql());
        sqlBuf.append(" FROM T_MM_ManufactureOrder moorder  WHERE stock.fparentid=moorder.fid ");
        sqlBuf.append(" and moorder.FID in (").append(idStr).append("))");
        sqlBuf.append(" where stock.FIssueMode != 11040");
        sqlBuf.append("and exists (select 1 from T_MM_ManufactureOrder moorder  WHERE stock.fparentid=moorder.fid ");
        sqlBuf.append(" and moorder.FID in (").append(idStr).append("))");
        CalculateWipUtil.execute(ctx, sqlBuf.toString());
    }

    public static void updateWipForByStock(Context ctx, String[] stockId) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        String idStr = SQLUtil.arrayToString((Object[])stockId);
        sqlBuf.append(CalculateWipUtil.buildUpdateStoreQtySql()).append(" where stock.fid in (").append(idStr).append(")").append(" and exists(select 1 from T_MM_ManufactureOrder as MOORDER where stock.fparentid = moorder.fid AND (moorder.fqty - moorder.ftotalSplitQty) > 0) ").append(" AND (stock.FIssueMode != ").append(11040).append(")");
        CalculateWipUtil.execute(ctx, sqlBuf.toString());
        sqlBuf.setLength(0);
        sqlBuf.append(CalculateWipUtil.buildUpdateWipQtySql());
        sqlBuf.append(" FROM T_MM_ManufactureOrder moorder  WHERE stock.fparentid=moorder.fid) ");
        sqlBuf.append(" where stock.FIssueMode != 11040");
        sqlBuf.append(" and stock.Fid in (").append(idStr).append(")");
        CalculateWipUtil.execute(ctx, sqlBuf.toString());
    }

    private static void execute(Context ctx, String sql) throws BOSException {
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private static String buildUpdateStoreQtySql() {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update T_MM_MFTOrderStock as stock set (FToStoreQty,FToStoreBaseQty) = (select round(to_decimal(to_decimal(stock.fplannedQty / (moorder.fqty - moorder.ftotalSplitQty),21,8) *  moorder.ftoStroreQty,21,8),t2.FQtyPrecision), round(to_decimal(to_decimal(stock.fplannedBaseQty / (moorder.fbaseqty - moorder.ftotalSplitbaseQty),21,8) *  moorder.FToStoreBaseQty,21,8),t3.FQtyPrecision)").append(" FROM T_MM_ManufactureOrder moorder , t_bd_multimeasureunit t2,t_bd_multimeasureunit t3").append(" where stock.fparentid=moorder.fid and stock.FMaterialID = t2.FMaterialID and stock.FUnitID = t2.fmeasureunitid and  stock.fmaterialid=t3.FMaterialID and stock.FbaseUnitID = t3.fmeasureunitid) ");
        return updateSql.toString();
    }

    private static String buildUpdateWipQtySql() {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_MFTOrderStock as stock set (FWipQty,FWipBaseQty ) = ( select case  when ((moorder.fqty - moorder.ftotalSplitQty) > 0 and (stock.FActIssueQty + stock.FFeedingQty + stock.FMaterialFeedingQty- stock.FScrapQty - stock.FMaterialScrapQty - stock.FRejectedQty - stock.FToStoreQty > 0)) then stock.FActIssueQty + stock.FFeedingQty + stock.FMaterialFeedingQty- stock.FScrapQty - stock.FMaterialScrapQty - stock.FRejectedQty - stock.FToStoreQty else 0 end , case  when ((moorder.fbaseqty - moorder.ftotalSplitbaseQty) > 0 and (stock.FActIssueBaseQty  + stock.FFeedingBaseQty + stock.FMaterialFeedingBaseQty - stock.FScrapBaseQty - stock.FMaterialScrapBaseQty - stock.FRejectedBaseQty - stock.FToStoreBaseQty > 0)) then stock.FActIssueBaseQty  + stock.FFeedingBaseQty + stock.FMaterialFeedingBaseQty - stock.FScrapBaseQty - stock.FMaterialScrapBaseQty - stock.FRejectedBaseQty - stock.FToStoreBaseQty  else 0 end ");
        return updateSql.toString();
    }
}

