/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CheckPickingHandler {
    protected Context ctx;

    public CheckPickingHandler() {
    }

    public CheckPickingHandler(Context context) {
        this.ctx = context;
    }

    public void checkManufactureRec(String sourceDataTable) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select FSourceBillID,sum(FBaseQty) FBaseQty ");
        sqlBuffer.append(" from ").append(sourceDataTable).append(" group by FSourceBillID ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
            while (rs.next()) {
                BigDecimal baseQty = rs.getBigDecimal("FBaseQty");
                String moId = rs.getString("FSourceBillID");
                map.put(moId, baseQty);
            }
            map.put("materialReq", Boolean.FALSE);
            this.checkPicking(map);
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    public void checkMaterialReq(String sourceDataTable) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select distinct FSourceBillID ");
        sqlBuffer.append(" from ").append(sourceDataTable);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
            while (rs.next()) {
                String moId = rs.getString("FSourceBillID");
                map.put(moId, SysConstant.BIGZERO);
            }
            map.put("materialReq", Boolean.TRUE);
            try {
                this.checkPicking(map);
            }
            catch (MMCommonException e) {
                if (e.getSubCode().equals(MMCommonException.TOSTORAGE_QTY_NOT_MINUS.getCode())) {
                    throw new MMCommonException(MMCommonException.TOSTORAGE_QTY_NOT_MINUS);
                }
                if (e.getSubCode().equals(MMCommonException.TOSTORAGE_QTY_MUST_LOWER.getCode())) {
                    throw new MMCommonException(MMCommonException.ISPICKING_TOSTORAGE_QTY_MUST_LOWER);
                }
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    private void checkPicking(Map params) throws BOSException, EASBizException {
        StringBuffer err = new StringBuffer();
        String strIds = StringUtils.arrayToString((Object[])params.keySet().toArray(), (String)"','");
        StringBuffer sqlBufferU = new StringBuffer();
        sqlBufferU.append("update t_mm_mftorderStock t set funitBaseQty=(");
        sqlBufferU.append(" select to_decimal(t.funitQty*fbaseconvsrate,21,8) from T_BD_Multimeasureunit where fmaterialid=t.fmaterialid and fmeasureunitid=t.funitid ");
        sqlBufferU.append(")");
        sqlBufferU.append(" where FParentID in ('" + strIds + "') and funitBaseQty<=0");
        DbUtil.execute((Context)this.ctx, (String)sqlBufferU.toString());
        BigDecimal hundred = new BigDecimal("100.00000000");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select mo.fid moId,transType.FBackFlushQtyBase qtyType,mo.FToStoreBaseQty,mo.FTotalDirectSendBaseQty,multiunit.FQtyPrecision as qtyScale, ");
        sqlBuffer.append(" min((stock.factIssueBaseQty - stock.frejectedBaseQty + stock.ffeedingBaseQty + stock.fmaterialFeedingBaseQty - stock.fscrapBaseQty - stock.fmaterialScrapBaseQty)/");
        sqlBuffer.append("to_decimal(stock.funitBaseQty * (1-stock.FlackRatio/" + hundred + "),21,8))  unitMaxQty, ");
        sqlBuffer.append(" min((stock.factIssueBaseQty - stock.frejectedBaseQty + stock.ffeedingBaseQty + stock.fmaterialFeedingBaseQty - stock.fscrapBaseQty - stock.fmaterialScrapBaseQty)/");
        sqlBuffer.append("(to_decimal(stock.fplannedBaseQty * (1-stock.FlackRatio/" + hundred + "),21,8)/(mo.fbaseQty-mo.ftotalSplitBaseQty))) planMaxQty ");
        sqlBuffer.append(" from t_mm_manufactureOrder mo ");
        sqlBuffer.append(" inner join t_mm_ProductTransactionType transType on mo.fTransactionTypeId = transType.FId ");
        sqlBuffer.append(" inner join t_bd_multimeasureunit multiunit on mo.FMaterialID = multiunit.FMaterialID and mo.FbaseUnitID = multiunit.fmeasureunitid ");
        sqlBuffer.append(" inner join t_mm_mftorderStock stock on mo.fid = stock.fparentId ");
        sqlBuffer.append(" inner join t_bd_materialPlan mp on stock.fmaterialId = mp.fmaterialId and mp.forgUnit = mo.fstorageOrgUnitId ");
        sqlBuffer.append(" where mo.fid in ('" + strIds + "') and transType.FIsPicking = 1 and stock.fisBackflush = 0 and stock.fissueMode <> 11040 and (( transType.fPicking = 20 and mp.fisKeyPart = 1) or transType.fPicking = 10) ");
        sqlBuffer.append(" and stock.FPlannedQty!=0 and stock.FPlannedBaseQty!=0 and stock.FIsReplaced = 0 ");
        sqlBuffer.append(" and mo.fbaseQty-mo.ftotalSplitBaseQty <>0 and (stock.FlackRatio <>100 or stock.fplannedBaseQty <>0 or stock.funitBaseQty <>0) ");
        sqlBuffer.append(" group by mo.fid,transType.FBackFlushQtyBase,mo.FToStoreBaseQty,mo.FTotalDirectSendBaseQty,multiunit.FQtyPrecision ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        boolean materialReq = (Boolean)params.get("materialReq");
        try {
            while (rs.next()) {
                String moId = rs.getString("moId");
                BigDecimal baseQty = (BigDecimal)params.get(moId);
                BigDecimal toStorageBaseQty = rs.getBigDecimal("FToStoreBaseQty");
                BigDecimal totalDirectSendBaseQty = rs.getBigDecimal("FTotalDirectSendBaseQty");
                int qtyScale = rs.getInt("qtyScale");
                int qtyType = rs.getInt("qtyType");
                BigDecimal unitMaxQty = rs.getBigDecimal("unitMaxQty");
                BigDecimal planMaxQty = rs.getBigDecimal("planMaxQty");
                BigDecimal maxStockBaseQty = SysConstant.BIGZERO;
                maxStockBaseQty = qtyType == 10 ? unitMaxQty.setScale(qtyScale, 4) : planMaxQty.setScale(qtyScale, 4);
                if (maxStockBaseQty.compareTo(SysConstant.BIGZERO) < 0 && materialReq) {
                    throw new MMCommonException(MMCommonException.TOSTORAGE_QTY_NOT_MINUS);
                }
                if (baseQty.add(toStorageBaseQty).compareTo(maxStockBaseQty) <= 0) continue;
                err.append("\u751f\u4ea7\u8ba2\u5355\u7684\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff08\u5305\u542b\u7d2f\u8ba1\u76f4\u9001\u6570\u91cf\uff09\uff0c\u4e0d\u80fd\u5927\u4e8e\u751f\u4ea7\u8ba2\u5355\u5907\u6599\u5206\u5f55\u4e2d\u5df2\u9886\u6599\u6570\u91cf\u4ea7\u751f\u7684\u53ef\u5165\u5e93\u6570\u91cf\u3002\r\n");
                StringBuffer sqlBufferm = new StringBuffer();
                sqlBufferm.append("select m.fnumber fnumber,stock.funitqty funitqty, (stock.factIssueBaseQty - stock.frejectedBaseQty + stock.ffeedingBaseQty + stock.fmaterialFeedingBaseQty - stock.fscrapBaseQty - stock.fmaterialScrapBaseQty) qty from t_mm_mftorderStock stock ");
                sqlBufferm.append(" inner join t_bd_material m on stock.fmaterialid = m.fid where stock.fparentId = '" + moId + "'");
                sqlBufferm.append(" and fisbackflush = '0'");
                sqlBufferm.append(" and stock.fissueMode <> 11040");
                IRowSet rsm = DbUtil.executeQuery((Context)this.ctx, (String)sqlBufferm.toString());
                while (rsm.next()) {
                    String fnumber = rsm.getString("fnumber");
                    BigDecimal qty = rsm.getBigDecimal("qty");
                    BigDecimal funitqty = rsm.getBigDecimal("funitqty");
                    if (baseQty.add(toStorageBaseQty).multiply(funitqty).compareTo(qty) <= 0) continue;
                    err.append("\u7269\u6599" + fnumber + "\u9886\u6599\u6570\u91cf\u7f3a\u5c11" + baseQty.add(toStorageBaseQty).multiply(funitqty).subtract(qty) + "\r\n");
                }
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        if (err.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", err.toString()));
        }
    }
}

