/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.IFactoryCalendar;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.ScheduleTypeEnum;
import com.kingdee.eas.mm.basedata.StandardRootingCollection;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.util.NumericUtil;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DataImportManufacturerOrder
extends AbstractDataTransmission {
    private static String resources = "com.kingdee.eas.mm.mo.ManufactureOrderExImResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.DataImportManufacturerOrder");
    private static final String DATEREGEX = "^(?:(?!0000)[0-9]{4}([-/.]?)(?:(?:0?[1-9]|1[0-2])([-/.]?)(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])([-/.]?)(?:29|30)|(?:0?[13578]|1[02])([-/.]?)31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/.]?)0?2([-/.]?)29)$";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ManufactureOrderFactory.getLocalInstance(ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        block17: {
            IObjectPK pk = null;
            ManufactureOrderInfo mo = (ManufactureOrderInfo)coreBaseInfo;
            try {
                IManufactureOrder mobiz = ManufactureOrderFactory.getLocalInstance(ctx);
                BillBaseStatusEnum targetBillStatus = mo.getBaseStatus();
                if (targetBillStatus.equals((Object)BillBaseStatusEnum.SUBMITED) || targetBillStatus.equals((Object)BillBaseStatusEnum.AUDITED) || targetBillStatus.equals((Object)BillBaseStatusEnum.RELEASED)) {
                    if (mo.getStocks().size() <= 0) {
                        throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Stocks_Not_Null", resources));
                    }
                    if (mo.getTechnics().size() <= 0) {
                        throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Technics_Not_Null", resources));
                    }
                }
                if (targetBillStatus.equals((Object)BillBaseStatusEnum.SUBMITED)) {
                    pk = mobiz.submit((CoreBaseInfo)mo);
                } else if (targetBillStatus.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
                    pk = mobiz.save((CoreBaseInfo)mo);
                } else if (targetBillStatus.equals((Object)BillBaseStatusEnum.AUDITED) || targetBillStatus.equals((Object)BillBaseStatusEnum.RELEASED)) {
                    this.checkPermission(ctx, mo, "mm_mo_audit");
                    mo.setBaseStatus(BillBaseStatusEnum.ADD);
                    pk = mobiz.submit((CoreBaseInfo)mo);
                    mo = mobiz.getManufactureOrderInfo(pk);
                    if (mo != null && mo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && pk != null) {
                        mobiz.audit(pk);
                    }
                    if (targetBillStatus.equals((Object)BillBaseStatusEnum.RELEASED) && (mo = mobiz.getManufactureOrderInfo(pk)) != null && mo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && pk != null) {
                        this.checkPermission(ctx, mo, "mm_mo_released");
                        mobiz.released(pk);
                    }
                }
            }
            catch (Exception exc0) {
                StringBuffer msg;
                block16: {
                    msg = new StringBuffer();
                    msg.append(exc0.getMessage());
                    if (exc0.getClass().getName().indexOf("com.kingdee.bos.workflow.exception") > -1 || exc0 instanceof AlreadyBindProcessInstanceException || exc0.getMessage().indexOf("already bind process instance") > -1) {
                        msg.setLength(0);
                    }
                    try {
                        if (pk != null && msg.length() > 0) {
                            ManufactureOrderFactory.getLocalInstance(ctx).delete(pk);
                        }
                    }
                    catch (Exception exc1) {
                        msg.append(exc1.getMessage());
                        if (exc1.getClass().getName().indexOf("com.kingdee.bos.workflow.exception") <= -1 && !(exc1 instanceof AlreadyBindProcessInstanceException) && exc1.getMessage().indexOf("already bind process instance") <= -1) break block16;
                        msg.setLength(0);
                    }
                }
                if (msg.length() <= 0) break block17;
                throw new TaskExternalException(msg.toString());
            }
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null || hsData.isEmpty()) {
            return null;
        }
        ManufactureOrderInfo headInfo = new ManufactureOrderInfo();
        try {
            this.setHeadValue(ctx, headInfo, hsData);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return headInfo;
    }

    private void checkPermission(Context ctx, ManufactureOrderInfo info, String permission) throws BOSException, TaskExternalException {
        StorageOrgUnitInfo orgInfo = info.getStorageOrgUnit();
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(orgInfo.getId());
        try {
            ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permission);
        }
        catch (EASBizException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
    }

    protected void setHeadValue(Context ctx, ManufactureOrderInfo headInfo, Hashtable hsData) throws TaskExternalException, BOSException {
        String isEmm;
        StorageOrgUnitInfo orgInfo = this.getStorageOrgUnit(ctx, this.getDataString(hsData, "FStorageOrgUnit_number"));
        headInfo.setStorageOrgUnit(orgInfo);
        CtrlUnitInfo cu = orgInfo.getCU();
        headInfo.setCU(cu);
        try {
            this.checkPermission(ctx, headInfo, "mm_mo_import");
        }
        catch (Exception e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        String number = this.getNumber(ctx, headInfo, this.getDataString(hsData, "FNumber"));
        headInfo.setNumber(number);
        String status = this.getDataString(hsData, "FBaseStatus");
        if (status == null || "".equals(status)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_status_Not_null", resources));
        }
        this.checkStatusTypeEnum(ctx, status, headInfo);
        String bizDateStr = this.getDataString(hsData, "FBizDate");
        this.setBizDate(ctx, headInfo, bizDateStr);
        ProductTransactionTypeInfo pInfo = this.getProductTransactionTypeInfo(ctx, orgInfo, this.getDataString(hsData, "FTransactionType_number"));
        headInfo.setTransactionType(pInfo);
        headInfo.setBizType(pInfo.getBizType());
        MaterialInfo materialInfo = this.getMaterialInfo(ctx, orgInfo, this.getDataString(hsData, "FMaterial_number"));
        headInfo.setMaterial(materialInfo);
        MaterialPlanInfo mPlanInfo = this.getPlanInfo(ctx, materialInfo, orgInfo);
        String project = this.getDataString(hsData, "FProject_number");
        String trackNumber = this.getDataString(hsData, "FTrackNumber_number");
        this.setProjectTrackNumber(ctx, headInfo, mPlanInfo, project, trackNumber);
        try {
            String projectID = headInfo.getProject() == null ? null : headInfo.getProject().getId().toString();
            String trackID = headInfo.getTrackNumber() == null ? null : headInfo.getTrackNumber().getId().toString();
            BomInfo bom = BOMExtend2FacadeFactory.getLocalInstance((Context)ctx).getBomByTrcAndPrjID(materialInfo.getId().toString(), projectID, trackID, orgInfo.getId().toString());
            if (bom == null) {
                if (!headInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
                    throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Bom_Error", resources));
                }
            } else {
                headInfo.setBomID(bom.getId().toString());
                headInfo.setYield(bom.getYield());
            }
        }
        catch (EASBizException exc) {
            logger.log(Priority.ERROR, (Object)"Cannot find a default bom according to specified material, storage, project and tack", (Throwable)exc);
        }
        String unit = this.getDataString(hsData, "FUnit_number");
        String qty = this.getDataString(hsData, "FQty");
        String deliveryQty = this.getDataString(hsData, "FDeliveryQty");
        this.setUnitAndQty(ctx, unit, headInfo, qty, deliveryQty);
        String scheduleType = this.getDataString(hsData, "FScheduleType");
        if (scheduleType == null || "".equals(scheduleType)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_scheduleType_Not_null", resources));
        }
        this.checkScheduleTypeEnum(ctx, scheduleType, headInfo);
        if (!pInfo.isIsWPManagement()) {
            headInfo.setScheduleType(ScheduleTypeEnum.NOTSCHEDULE);
        }
        String startDateStr = this.getDataString(hsData, "FPlanBeginDate");
        String endDateStr = this.getDataString(hsData, "FPlanEndDate");
        this.setPlanDate(ctx, headInfo, startDateStr, endDateStr);
        String routingNumber = this.getDataString(hsData, "FRouting_number");
        StandardRootingInfo routing = this.getDefaultRouting(ctx, routingNumber, headInfo.getMaterial().getId().toString(), headInfo.getStorageOrgUnit().getId().toString(), pInfo);
        headInfo.setRouting(routing);
        String adminOrgUnit = this.getDataString(hsData, "FAdminOrgUnit_number");
        if (adminOrgUnit == null || "".equals(adminOrgUnit)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_AdminOrgUnit_Not_Null", resources));
        }
        this.setAdminOrgUnit(ctx, headInfo, adminOrgUnit);
        String planOrgUnit = this.getDataString(hsData, "FPlanOrgUnit_number");
        this.setPlanOrgUnit(ctx, headInfo, planOrgUnit);
        String dispatcher = this.getDataString(hsData, "FDispatcher_number");
        this.setDispatcher(ctx, headInfo, dispatcher);
        MaterialInventoryInfo inventoryInfo = this.getInventorynfo(ctx, materialInfo, headInfo.getStorageOrgUnit());
        String defaultWarehouse = this.getDataString(hsData, "FDefaultWarehous_number");
        this.setDefaultWarehouse(ctx, headInfo, defaultWarehouse, inventoryInfo);
        String isDirectSend = this.getDataString(hsData, "FIsDirectSend");
        if (!StringUtils.isEmpty((String)isDirectSend)) {
            if (DataImportManufacturerOrder.getResource(ctx, "I18N_CHAR_YES", resources).equalsIgnoreCase(isDirectSend)) {
                headInfo.setIsDirectSend(true);
            } else {
                headInfo.setIsDirectSend(false);
            }
        }
        if (!StringUtils.isEmpty((String)(isEmm = this.getDataString(hsData, "FIsEmm")))) {
            if ("true".equalsIgnoreCase(isEmm)) {
                headInfo.setIsEmm(true);
            } else {
                headInfo.setIsEmm(false);
            }
        }
        try {
            this.updateLot(ctx, headInfo, hsData, inventoryInfo);
            ManufactureOrderFactory.getLocalInstance(ctx).importData((IObjectValue)headInfo);
            this.schedule(ctx, headInfo);
        }
        catch (EASBizException exc) {
            throw new TaskExternalException(exc.getMessage(), (Throwable)exc);
        }
    }

    private void setBizDate(Context ctx, ManufactureOrderInfo headInfo, String bizDateStr) throws TaskExternalException, BOSException {
        java.sql.Date bizDate;
        if (bizDateStr == null || "".equals(bizDateStr)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_BizDate_Not_Null", resources));
        }
        try {
            bizDate = TypeConversionUtils.objToDate((Object)bizDateStr);
        }
        catch (Exception e) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_BizDate_Error", resources));
        }
        if (DataImportManufacturerOrder.isRegularRptCode(bizDateStr)) {
            try {
                headInfo.setBizDate(this.setWorkDate(bizDate));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_BizDate_Wrong", resources));
        }
    }

    private void schedule(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException, TaskExternalException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("scheduleType", mo.getScheduleType());
        param.put("orderInfo", mo);
        param.put("result", Integer.valueOf("1"));
        Map map = ManufactureOrderFactory.getLocalInstance(ctx).operationpSchedul(param);
        switch ((Integer)map.get("result")) {
            case -1: {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "MSG_NO_CLASS_TERM_ERROR", resources));
            }
            case -2: {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "MSG_NO_FACTORY_CALENDAR_ERROR", resources));
            }
        }
    }

    private void updateLot(Context ctx, ManufactureOrderInfo order, Hashtable table, MaterialInventoryInfo inventoryInfo) throws TaskExternalException, EASBizException, BOSException {
        BillBaseStatusEnum status = order.getBaseStatus();
        StorageOrgUnitInfo storageOrgUnit = order.getStorageOrgUnit();
        MaterialInfo material = order.getMaterial();
        String lot = this.getDataString(table, "FLot");
        if (inventoryInfo != null && inventoryInfo.isIsLotNumber()) {
            LotParamValueInfo lpv = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(storageOrgUnit.getId().toString());
            if (lpv != null) {
                if (!lpv.isManufactureOrder() && !lpv.isManufacturePlan()) {
                    order.setLot(null);
                } else if (!StringUtils.isEmpty((String)lot)) {
                    if (lot.length() >= 80) {
                        throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_lot_Too_long", resources));
                    }
                    order.setLot(lot);
                } else {
                    LotRuleInfo lotRule = (LotRuleInfo)ManufactureOrderFactory.getLocalInstance(ctx).invoke("getProperLotRule", new Object[]{material.getId().toString(), storageOrgUnit.getId().toString()});
                    if (lotRule != null) {
                        LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrameExtend(material.getId().toString(), storageOrgUnit.getId().toString());
                        if (lotFrame != null && lotFrame.getLotRule() != null) {
                            LotFrameManu lotFrameManu = new LotFrameManu();
                            lotFrameManu.setSeq(lotFrame.getSeq());
                            lotFrameManu.setSysDate(lotFrame.getSysDate());
                            lotFrameManu.setCurrentSerial(lotFrame.getCurrentSerial());
                            lotFrameManu.setMainBizOrg(storageOrgUnit.getNumber());
                            lotFrameManu.setMaterial(material.getNumber());
                            lotFrameManu.setBillNumber(order.getNumber());
                            lotFrameManu.setBizDate(order.getBizDate());
                            lotFrameManu.setLotRule(lotFrame.getLotRule());
                            lotFrameManu.setMfg((Date)order.getPlanEndDate());
                            order.setLot(lotFrameManu.getLotNumber());
                        }
                    } else {
                        String value = this.getDataString(table, "FBaseStatus");
                        if (!value.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.getAlias()) && !value.equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.getAlias())) {
                            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Lot_Into", resources));
                        }
                    }
                }
            }
        } else {
            order.setLot(null);
        }
    }

    protected void checkScheduleTypeEnum(Context ctx, String value, ManufactureOrderInfo headInfo) throws TaskExternalException {
        if (value.equalsIgnoreCase(ScheduleTypeEnum.INVERTED.getAlias())) {
            headInfo.setScheduleType(ScheduleTypeEnum.INVERTED);
        } else if (value.equalsIgnoreCase(ScheduleTypeEnum.NOTSCHEDULE.getAlias())) {
            headInfo.setScheduleType(ScheduleTypeEnum.NOTSCHEDULE);
        } else if (value.equalsIgnoreCase(ScheduleTypeEnum.PLATOON.getAlias())) {
            headInfo.setScheduleType(ScheduleTypeEnum.PLATOON);
        } else {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_scheduleType_Error", resources));
        }
    }

    protected void checkStatusTypeEnum(Context ctx, String value, ManufactureOrderInfo headInfo) throws TaskExternalException {
        if (value.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.getAlias())) {
            headInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        } else if (value.equalsIgnoreCase(BillBaseStatusEnum.AUDITED.getAlias())) {
            headInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        } else if (value.equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.getAlias())) {
            headInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        } else if (value.equalsIgnoreCase(BillBaseStatusEnum.RELEASED.getAlias())) {
            headInfo.setBaseStatus(BillBaseStatusEnum.RELEASED);
        } else {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_status_Error", resources));
        }
    }

    private void setDefaultWarehouse(Context ctx, ManufactureOrderInfo headInfo, String number, MaterialInventoryInfo inventoryInfo) throws BOSException, TaskExternalException {
        if (number != null && !"".equals(number)) {
            WarehouseInfo warehouseInfo = null;
            WarehouseCollection colls = null;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)headInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("whState", (Object)WHStateEnum.ACTIVE, CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            colls = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(viewInfo);
            if (colls == null || colls.size() <= 0) {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Warehouse_Error", resources));
            }
            warehouseInfo = colls.get(0);
            headInfo.setDefaultWarehous(warehouseInfo);
        } else if (inventoryInfo != null) {
            headInfo.setDefaultWarehous(inventoryInfo.getDefaultWarehouse());
        }
    }

    private void setDispatcher(Context ctx, ManufactureOrderInfo headInfo, String number) throws BOSException, TaskExternalException {
        if (number != null && !"".equals(number)) {
            String planOrgId = headInfo.getPlanOrgUnit().getId().toString();
            HashSet<String> idSet = new HashSet<String>();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.id", (Object)planOrgId, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            PositionMemberCollection col0 = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(evi);
            if (col0 != null && col0.size() > 0) {
                int size = col0.size();
                for (int i = 0; i < size; ++i) {
                    idSet.add(col0.get(i).getPerson().getId().toString());
                }
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            evi = new EntityViewInfo();
            evi.setFilter(filter);
            PersonCollection col1 = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
            if (col1 == null || col1.size() <= 0) {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Dispatcher_Error", resources));
            }
            headInfo.setDispatcher(col1.get(0));
        }
    }

    private void setAdminOrgUnit(Context ctx, ManufactureOrderInfo headInfo, String number) throws BOSException, TaskExternalException {
        if (number != null && !"".equals(number)) {
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            AdminOrgUnitCollection colls = null;
            FilterInfo filter = new FilterInfo();
            HashSet idset = this.getAdminOrgByStorageOrg(ctx, headInfo.getStorageOrgUnit().getId().toString());
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            colls = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(viewInfo);
            if (colls == null || colls.size() <= 0) {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_AdminOrgUnit_Error", resources));
            }
            adminOrgUnitInfo = colls.get(0);
            headInfo.setAdminOrgUnit(adminOrgUnitInfo);
        }
    }

    private void setPlanOrgUnit(Context ctx, ManufactureOrderInfo headInfo, String number) throws BOSException, TaskExternalException {
        if (number != null && !"".equals(number)) {
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            AdminOrgUnitCollection colls = null;
            FilterInfo filter = new FilterInfo();
            HashSet idset = this.getAdminOrgByStorageOrg(ctx, headInfo.getStorageOrgUnit().getId().toString());
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            colls = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(viewInfo);
            if (colls == null || colls.size() <= 0) {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_PlanOrgUnit_Error", resources));
            }
            adminOrgUnitInfo = colls.get(0);
            headInfo.setPlanOrgUnit(adminOrgUnitInfo);
        }
    }

    public HashSet getAdminOrgByStorageOrg(Context ctx, String storageOrgId) throws TaskExternalException {
        if (storageOrgId == null) {
            return null;
        }
        try {
            IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            HashSet<String> set = new HashSet<String>();
            OrgUnitCollection orgIds = iOrgUnitRel.getToUnit(storageOrgId, 4, 0);
            for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
                set.add(orgIds.get(i).getId().toString());
            }
            return set;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private StandardRootingInfo getDefaultRouting(Context ctx, String routingNumber, String materialID, String storageOrgUnitID, ProductTransactionTypeInfo transTypeInfo) throws BOSException, TaskExternalException {
        StandardRootingInfo customizedRouting = null;
        if (!StringUtils.isEmpty((String)routingNumber)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)routingNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            StandardRootingCollection col = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingCollection(viewInfo);
            if (col == null || col.size() <= 0) {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Rooting_Error", resources));
            }
            customizedRouting = col.get(0);
            return customizedRouting;
        }
        StandardRootingInfo mainRouting = null;
        if (transTypeInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60)));
            filterInfo.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)Boolean.TRUE));
            viewInfo.setFilter(filterInfo);
            StandardRootingCollection col = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingCollection(viewInfo);
            if (col != null && col.size() > 0) {
                mainRouting = col.get(0);
            }
            if (transTypeInfo.isIsWPManagement()) {
                return mainRouting;
            }
            if (mainRouting != null) {
                return mainRouting;
            }
            viewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"-"));
            viewInfo.setFilter(filterInfo);
            col = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingCollection(viewInfo);
            if (col != null && col.size() > 0) {
                return col.get(0);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProjectTrackNumber(Context ctx, ManufactureOrderInfo headInfo, MaterialPlanInfo mPlanInfo, String project, String trackNumber) throws TaskExternalException, BOSException {
        ProjectInfo projectInfo = null;
        TrackNumberInfo trackNumberInfo = null;
        String projectid = null;
        ManufactureStrategyInfo strategyInfo = mPlanInfo.getManufactureStrategy();
        if (headInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            if (project != null && !"".equals(project)) {
                projectInfo = this.getProjectInfo(ctx, headInfo, projectInfo, project);
                headInfo.setProject(projectInfo);
            }
            if (trackNumber == null || "".equals(trackNumber)) return;
            if (projectInfo != null) {
                projectid = projectInfo.getId().toString();
                trackNumberInfo = this.getTrackNumberInfo(ctx, headInfo, trackNumberInfo, trackNumber, projectid);
                headInfo.setTrackNumber(trackNumberInfo);
                return;
            } else {
                trackNumberInfo = this.getTrackNumberInfo(ctx, headInfo, trackNumberInfo, trackNumber, null);
                headInfo.setTrackNumber(trackNumberInfo);
            }
            return;
        } else if (strategyInfo.getId().toString().equalsIgnoreCase("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategyInfo.getId().toString().equalsIgnoreCase("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            if (mPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM) {
                if (project == null || "".equals(project)) {
                    throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "ETO_Project_not_null", resources));
                }
                projectInfo = this.getProjectInfo(ctx, headInfo, projectInfo, project);
                headInfo.setProject(projectInfo);
                if (trackNumber == null || "".equals(trackNumber) || projectInfo == null) return;
                projectid = projectInfo.getId().toString();
                trackNumberInfo = this.getTrackNumberInfo(ctx, headInfo, trackNumberInfo, trackNumber, projectid);
                headInfo.setTrackNumber(trackNumberInfo);
                return;
            } else {
                if (mPlanInfo.getIsolatedRule() != IsolatedRuleEnum.ITEM_TRACKNO) return;
                if (project == null || "".equals(project)) {
                    throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "ETO_Project_not_null", resources));
                }
                projectInfo = this.getProjectInfo(ctx, headInfo, projectInfo, project);
                headInfo.setProject(projectInfo);
                if (trackNumber == null || "".equals(trackNumber)) {
                    throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "ETO_Tracknumber_not_null", resources));
                }
                if (projectInfo == null) return;
                projectid = projectInfo.getId().toString();
                trackNumberInfo = this.getTrackNumberInfo(ctx, headInfo, trackNumberInfo, trackNumber, projectid);
                headInfo.setTrackNumber(trackNumberInfo);
            }
            return;
        } else if (strategyInfo.getId().toString().equalsIgnoreCase("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyInfo.getId().toString().equalsIgnoreCase("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyInfo.getId().toString().equalsIgnoreCase("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyInfo.getId().toString().equalsIgnoreCase("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
            if (project != null && !"".equals(project)) {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "MTO_Project_not_null", resources));
            }
            if (trackNumber == null || "".equals(trackNumber)) throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "MTO_Tracknumber_not_null", resources));
            trackNumberInfo = this.getTrackNumberInfo(ctx, headInfo, trackNumberInfo, trackNumber, null);
            headInfo.setTrackNumber(trackNumberInfo);
            return;
        } else {
            if (project != null && !"".equals(project)) {
                projectInfo = this.getProjectInfo(ctx, headInfo, projectInfo, project);
                headInfo.setProject(projectInfo);
            }
            if (trackNumber == null || "".equals(trackNumber)) return;
            if (projectInfo != null) {
                projectid = projectInfo.getId().toString();
                trackNumberInfo = this.getTrackNumberInfo(ctx, headInfo, trackNumberInfo, trackNumber, projectid);
                headInfo.setTrackNumber(trackNumberInfo);
                return;
            } else {
                trackNumberInfo = this.getTrackNumberInfo(ctx, headInfo, trackNumberInfo, trackNumber, null);
                headInfo.setTrackNumber(trackNumberInfo);
            }
        }
    }

    private TrackNumberInfo getTrackNumberInfo(Context ctx, ManufactureOrderInfo headInfo, TrackNumberInfo trackNumberInfo, String trackNumber, String projectid) throws TaskExternalException, BOSException {
        StringBuffer str = new StringBuffer();
        if (projectid == null) {
            str.append(" select fid from T_MM_TRACKNUMBER where fnumber = '").append(trackNumber).append("' and ( fid in ( ").append(" SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '086E983D' AND FAssignCUID = '").append(headInfo.getStorageOrgUnit().getCU().getId().toString()).append("' )").append(" or fadminCUid = '").append(headInfo.getStorageOrgUnit().getCU().getId().toString()).append("')");
        } else {
            str.append(" select t.fid from T_MM_TRACKNUMBER as t ").append("inner join T_MM_ProjectCar as p on p.FTrackNumberID = t.fid ").append(" where t.fstatus =10 and t.fnumber = '").append(trackNumber).append("' and p.FProjectID = '").append(projectid).append("' and ( t.fid in ( ").append(" SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '086E983D' AND FAssignCUID = '").append(headInfo.getStorageOrgUnit().getCU().getId().toString()).append("' )").append(" or t.fadminCUid = '").append(headInfo.getStorageOrgUnit().getCU().getId().toString()).append("')");
        }
        TrackNumberCollection colls = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)MMBasedataStatusEnum.SAVED, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        colls = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection(viewInfo);
        if (colls == null || colls.size() <= 0) {
            if (projectid == null) {
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_TrackNumber_Error", resources));
            }
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_TrackNumber_project_Error", resources));
        }
        trackNumberInfo = colls.get(0);
        return trackNumberInfo;
    }

    private ProjectInfo getProjectInfo(Context ctx, ManufactureOrderInfo headInfo, ProjectInfo projectInfo, String project) throws TaskExternalException, BOSException {
        ProjectCollection colls = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)project, CompareType.EQUALS));
        ObjectUuidPK cuPK = new ObjectUuidPK(headInfo.getStorageOrgUnit().getCU().getId());
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)MMBaseStatusEnum.AUDIT, CompareType.EQUALS));
        FilterInfo filter2 = null;
        try {
            filter2 = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (filter2 != null) {
            try {
                filter.mergeFilter(filter2, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        colls = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(viewInfo);
        if (colls == null || colls.size() <= 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Project_Error", resources));
        }
        projectInfo = colls.get(0);
        return projectInfo;
    }

    private void setPlanDate(Context ctx, ManufactureOrderInfo headInfo, String startDateStr, String endDateStr) throws TaskExternalException, BOSException {
        java.sql.Date endDate;
        java.sql.Date startDate;
        if (startDateStr == null || "".equals(startDateStr)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_startDate_Not_Null", resources));
        }
        if (endDateStr == null || "".equals(endDateStr)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_endDate_Not_Null", resources));
        }
        try {
            startDate = TypeConversionUtils.objToDate((Object)startDateStr);
        }
        catch (Exception e) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_StartDate_error", resources));
        }
        try {
            endDate = TypeConversionUtils.objToDate((Object)endDateStr);
        }
        catch (Exception e) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_EndDate_error", resources));
        }
        if (this.dateCompare(startDate, endDate)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_EndDate_before_StartDate", resources));
        }
        boolean isWorkDate = true;
        IFactoryCalendar mmCalendarFactory = FactoryCalendarFactory.getLocalInstance((Context)ctx);
        try {
            isWorkDate = mmCalendarFactory.isWorkDay(headInfo.getStorageOrgUnit().getId().toString(), (Date)startDate);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (isWorkDate && DataImportManufacturerOrder.isRegularRptCode(startDateStr)) {
            try {
                headInfo.setPlanBeginDate(this.setWorkDate(startDate));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_StartDate_Not_WorkDate", resources));
        }
        try {
            isWorkDate = mmCalendarFactory.isWorkDay(headInfo.getStorageOrgUnit().getId().toString(), (Date)endDate);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (isWorkDate && DataImportManufacturerOrder.isRegularRptCode(endDateStr)) {
            try {
                headInfo.setPlanEndDate(this.setWorkDate(endDate));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_EndDate_Not_WorkDate", resources));
        }
    }

    public static boolean isRegularRptCode(String rptCode) {
        Pattern p = Pattern.compile(DATEREGEX);
        Matcher m = p.matcher(rptCode);
        boolean rs = m.matches();
        return rs;
    }

    private boolean dateCompare(Date date1, Date date2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(date1).toString());
        int endDay = Integer.parseInt(dateFormat.format(date2).toString());
        boolean result = false;
        if (endDay - startDay < 0) {
            result = true;
        }
        return result;
    }

    private Timestamp getWorkDay(Context ctx, Date date, IFactoryCalendar mmCalendarFactory, String orgID, ScheduleTypeEnum scheduleTypeEnum, boolean isbeginDate) throws EASBizException, BOSException, TaskExternalException {
        return this.setWorkDate(date);
    }

    private Timestamp setWorkDate(Date date) throws BOSException, EASBizException {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.set(10, calendar1.get(10));
        calendar2.set(12, calendar1.get(12));
        calendar2.set(13, calendar1.get(13));
        return new Timestamp(calendar2.getTimeInMillis());
    }

    private MaterialPlanInfo getPlanInfo(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo orgInfo) throws BOSException, TaskExternalException {
        MaterialPlanInfo comInfo = null;
        MaterialPlanCollection colls = null;
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(10030));
        set.add(new Integer(10050));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("materialAttr", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        colls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
        if (colls == null || colls.size() <= 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Material_Error", resources));
        }
        comInfo = colls.get(0);
        return comInfo;
    }

    private MaterialInventoryInfo getInventorynfo(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo orgInfo) throws BOSException, TaskExternalException {
        MaterialInventoryInfo inventoryInfo = null;
        MaterialInventoryCollection colls = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        colls = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
        if (colls == null || colls.size() <= 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Material_Error", resources));
        }
        inventoryInfo = colls.get(0);
        return inventoryInfo;
    }

    private MaterialInfo getMaterialInfo(Context ctx, StorageOrgUnitInfo orgInfo, String number) throws BOSException, TaskExternalException {
        if (number == null || number.trim().length() == 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Material_Number_Null", resources));
        }
        MaterialInfo materialInfo = new MaterialInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCollection matCollection = iMat.getMaterialCollection(viewInfo);
        if (matCollection == null || matCollection.size() <= 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Material_Error", resources));
        }
        materialInfo = matCollection.get(0);
        return materialInfo;
    }

    private ProductTransactionTypeInfo getProductTransactionTypeInfo(Context ctx, StorageOrgUnitInfo orgInfo, String TransactionType_number) throws TaskExternalException, BOSException {
        if (TransactionType_number == null || "".equals(TransactionType_number)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_TransactionType_Not_Null", resources));
        }
        ProductTransactionTypeInfo pInfo = new ProductTransactionTypeInfo();
        IProductTransactionType iProductTransactionType = ProductTransactionTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)TransactionType_number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)MMBasedataStatusEnum.OPEN, CompareType.EQUALS));
        ev.setFilter(filter);
        ProductTransactionTypeCollection cols = iProductTransactionType.getProductTransactionTypeCollection(ev);
        if (cols.size() <= 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_TransactionType_Error", resources));
        }
        pInfo = cols.get(0);
        return pInfo;
    }

    public void setUnitAndQty(Context ctx, String number, ManufactureOrderInfo headInfo, String qtystr, String deliveryqtystr) throws TaskExternalException, BOSException {
        if (number == null || "".equals(number)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_unit_Not_Null", resources));
        }
        if (qtystr == null || "".equals(qtystr)) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Qty_Not_Null", resources));
        }
        BigDecimal ZERO = new BigDecimal("0.0");
        BigDecimal qty = new BigDecimal("0.0");
        try {
            qty = new BigDecimal(qtystr);
        }
        catch (Exception e) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Qty_Error", resources));
        }
        if (ZERO.compareTo(qty) >= 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Qty_Error", resources));
        }
        BigDecimal baseQty = SysConstant.BIGZERO;
        MaterialInfo materialInfo = headInfo.getMaterial();
        MeasureUnitInfo unitInfo = new MeasureUnitInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select mea.fid  from T_BD_MeasureUnit as mea ");
        sb.append(" INNER JOIN T_BD_MultiMeasureUnit AS mul on  mea.FID = mul.FMeasureUnitID ");
        sb.append(" where mea.fnumber = '").append(number).append("' ");
        sb.append(" and mul.FMaterialID = '").append(materialInfo.getId().toString()).append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        view.setFilter(filter);
        IMeasureUnit iUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        MeasureUnitCollection unitCollection = iUnit.getMeasureUnitCollection(view);
        if (unitCollection == null || unitCollection.size() <= 0) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_unit_Error", resources));
        }
        unitInfo = unitCollection.get(0);
        BigDecimal deliveryQty = SysConstant.BIGZERO;
        BigDecimal deliveryBaseQty = SysConstant.BIGZERO;
        try {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialInfo.getId().toString(), unitInfo.getId().toString());
            qty = qty.setScale(multiUnifInfo.getQtyPrecision(), 4);
            baseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)materialInfo.getBaseUnit(), (BigDecimal)qty);
            if (deliveryqtystr != null && !"".equals(deliveryqtystr)) {
                deliveryQty = new BigDecimal(deliveryqtystr);
                deliveryQty = deliveryQty.setScale(multiUnifInfo.getQtyPrecision(), 4);
            }
            deliveryBaseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)materialInfo.getBaseUnit(), (BigDecimal)deliveryQty);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        headInfo.setQty(qty);
        headInfo.setUnit(unitInfo);
        headInfo.setBaseUnit(materialInfo.getBaseUnit());
        headInfo.setBaseQty(baseQty);
        headInfo.setAssistUnit(materialInfo.getAssistUnit());
        headInfo.setTotalSplitQty(SysConstant.BIGZERO);
        headInfo.setTotalSplitBaseQty(SysConstant.BIGZERO);
        headInfo.setDeliveryQty(deliveryQty);
        headInfo.setDeliveryBaseQty(deliveryBaseQty);
    }

    private String getNumber(Context ctx, ManufactureOrderInfo headInfo, String number) throws TaskExternalException, BOSException {
        block5: {
            boolean isImportDataByRule = this.getImportParam(ctx);
            if (isImportDataByRule) {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                try {
                    String newNum;
                    number = newNum = iCodingRuleManager.getNumber((IObjectValue)headInfo, headInfo.getStorageOrgUnit().getId().toString());
                }
                catch (EASBizException e) {
                    if (number != null && !number.equals("")) break block5;
                    throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Number_Not_Null", resources));
                }
            }
        }
        if (number == null || number.equals("")) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Number_Not_Null", resources));
        }
        if (number.length() >= 80) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "Msg_Number_Too_long", resources));
        }
        return number;
    }

    private boolean getImportParam(Context ctx) {
        boolean isByRule = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("Value"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.subSysID", (Object)"0000", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"importDataByRule", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemCollection collection = iParamItem.getParamItemCollection(entityViewInfo);
            if (collection == null || collection.size() == 0) {
                return isByRule;
            }
            ParamItemInfo info = collection.get(0);
            String value = info.getValue();
            if (value != null && value.equals("true")) {
                isByRule = true;
            }
        }
        catch (Exception e) {
            isByRule = false;
        }
        return isByRule;
    }

    protected StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String orgNumber) throws TaskExternalException {
        if (orgNumber == null || orgNumber.equals("")) {
            throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "StorageOrgUnit_Not_null", resources));
        }
        try {
            IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (orgNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                ev.setFilter(filter);
                ev.getSelector().add(new SelectorItemInfo("*"));
                ev.getSelector().add(new SelectorItemInfo("CU.*"));
                StorageOrgUnitCollection cols = isou.getStorageOrgUnitCollection(ev);
                if (cols.size() > 0) {
                    StorageOrgUnitInfo orgInfo = cols.get(0);
                    if (orgInfo.isIsBizUnit()) {
                        return orgInfo;
                    }
                    throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "StorageOrgUnit_IsNotBizUnit", resources));
                }
                throw new TaskExternalException(DataImportManufacturerOrder.getResource(ctx, "StorageOrgUnit_Not_Exist", resources));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected String getDataString(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken == null) {
            return null;
        }
        String number = (String)dataToken.data;
        return number;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private String formatDate(Date date) {
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        String formatDate = "";
        if (date != null) {
            formatDate = dtformat.format(date);
        }
        return formatDate;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            if (rs.getString("number") != null) {
                this.putTable(result, "FNumber", rs.getString("number"));
            }
            if (rs.getString("storageOrgUnit.number") != null) {
                this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            }
            if (rs.getString("transactionType.number") != null) {
                this.putTable(result, "FTransactionType_number", rs.getString("transactionType.number"));
            }
            if (rs.getString("bizType.name") != null) {
                this.putTable(result, "FBizType_name_l2", rs.getString("bizType.name"));
            }
            if (rs.getString("bizDate") != null) {
                this.putTable(result, "FBizDate", this.formatDate(rs.getDate("bizDate")));
            }
            if (rs.getString("material1.number") != null) {
                this.putTable(result, "FMaterial_number", rs.getString("material1.number"));
            }
            if (rs.getString("material1.name") != null) {
                this.putTable(result, "FMaterial_name_l2", rs.getString("material1.name"));
            }
            if (rs.getString("material1.model") != null) {
                this.putTable(result, "FMaterial_model", rs.getString("material1.model"));
            }
            if (rs.getString("baseStatus") != null) {
                this.putTable(result, "FBaseStatus", BillBaseStatusEnum.getEnum((int)rs.getInt("baseStatus")).getAlias(ctx.getLocale()));
            }
            BigDecimal qty = NumericUtil.emptyToZero(rs.getBigDecimal("qty"));
            BigDecimal totalSplitQty = NumericUtil.emptyToZero(rs.getBigDecimal("totalSplitQty"));
            this.putTable(result, "FQty", qty);
            this.putTable(result, "FTotalSplitQty", totalSplitQty);
            this.putTable(result, "FOrderQty", qty.subtract(totalSplitQty));
            if (rs.getString("unit.number") != null) {
                this.putTable(result, "FUnit_number", rs.getString("unit.number"));
            }
            if (rs.getString("yield") != null) {
                this.putTable(result, "FYield", rs.getBigDecimal("yield"));
            }
            if (rs.getString("deliveryQty") != null) {
                this.putTable(result, "FDeliveryQty", rs.getBigDecimal("deliveryQty"));
            }
            if (rs.getString("planBeginDate") != null) {
                this.putTable(result, "FPlanBeginDate", this.formatDate(rs.getDate("planBeginDate")));
            }
            if (rs.getString("planEndDate") != null) {
                this.putTable(result, "FPlanEndDate", this.formatDate(rs.getDate("planEndDate")));
            }
            if (rs.getString("actureBeginDate") != null) {
                this.putTable(result, "FActureBeginDate", this.formatDate(rs.getDate("actureBeginDate")));
            }
            if (rs.getString("actureEndDate") != null) {
                this.putTable(result, "FActureEndDate", this.formatDate(rs.getDate("actureEndDate")));
            }
            if (rs.getString("bomNum") != null) {
                this.putTable(result, "FBomNum", rs.getString("bomNum"));
            }
            if (rs.getString("project.number") != null) {
                this.putTable(result, "FProject_number", rs.getString("project.number"));
            }
            if (rs.getString("trackNumber.number") != null) {
                this.putTable(result, "FTrackNumber_number", rs.getString("trackNumber.number"));
            }
            if (rs.getString("routing.number") != null) {
                this.putTable(result, "FRouting_number", rs.getString("routing.number"));
            }
            if (rs.getString("scheduleType") != null && rs.getInt("scheduleType") != 0) {
                this.putTable(result, "FScheduleType", ScheduleTypeEnum.getEnum((int)rs.getInt("scheduleType")).getAlias(ctx.getLocale()));
            }
            if (rs.getString("adminOrgUnit.number") != null) {
                this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            }
            if (rs.getString("lot") != null) {
                this.putTable(result, "FLot", rs.getString("lot"));
            }
            if (rs.getString("costObject.name") != null) {
                this.putTable(result, "FCostObject_name_l2", rs.getString("costObject.name"));
            }
            if (rs.getString("sourceBillType.name") != null) {
                this.putTable(result, "FSourceBillType_name_l2", rs.getString("sourceBillType.name"));
            }
            if (rs.getString("srcBillNum") != null) {
                this.putTable(result, "FSrcBillNum", rs.getString("srcBillNum"));
            }
            if (rs.getString("relatingOrderNum") != null) {
                this.putTable(result, "FRelatingOrderNum", rs.getString("relatingOrderNum"));
            }
            if (rs.getString("defaultWarehous.number") != null) {
                this.putTable(result, "FDefaultWarehous_number", rs.getString("defaultWarehous.number"));
            }
            if (rs.getString("dispatcher.number") != null) {
                this.putTable(result, "FDispatcher_number", rs.getString("dispatcher.number"));
            }
            if (rs.getString("isDirectSend") != null && rs.getBoolean("isDirectSend")) {
                this.putTable(result, "FIsDirectSend", DataImportManufacturerOrder.getResource(ctx, "I18N_CHAR_YES", resources));
            } else {
                this.putTable(result, "FIsDirectSend", DataImportManufacturerOrder.getResource(ctx, "I18N_CHAR_NO", resources));
            }
            if (rs.getString("planOrgUnit.number") != null) {
                this.putTable(result, "FPlanOrgUnit_number", rs.getString("planOrgUnit.number"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected static String getResource(Context ctx, String strKey, String resource) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }
}

