/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.sfc.DisTaskDispatchCollection;
import com.kingdee.eas.mm.sfc.DisTaskDispatchEntryCollection;
import com.kingdee.eas.mm.sfc.DisTaskDispatchEntryInfo;
import com.kingdee.eas.mm.sfc.DisTaskDispatchFactory;
import com.kingdee.eas.mm.sfc.DisTaskDispatchInfo;
import com.kingdee.eas.mm.sfc.RowStatusEnum;
import com.kingdee.eas.mm.sfc.TechnicslayerEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GetMoData {
    public List getMODataForTaskDispBill(Context ctx, String orgId, FilterInfo filter, DisTaskDispatchCollection dtdColl) throws BOSException, EASBizException {
        Boolean isNeedStock;
        DisTaskDispatchCollection disColls = null;
        Boolean bl = isNeedStock = ctx.get((Object)"isNeedStock") == null ? Boolean.FALSE : (Boolean)ctx.get((Object)"isNeedStock");
        if (filter != null && dtdColl == null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.setSelector(this.getSelectors(isNeedStock));
            disColls = DisTaskDispatchFactory.getLocalInstance((Context)ctx).getDisTaskDispatchCollection(viewInfo);
        } else if (filter == null && dtdColl != null) {
            disColls = dtdColl;
        }
        ArrayList<ManufactureOrderInfo> mos = new ArrayList<ManufactureOrderInfo>();
        if (disColls != null) {
            for (int i = 0; i < disColls.size(); ++i) {
                DisTaskDispatchInfo info = disColls.get(i);
                DisTaskDispatchEntryCollection entrys = info.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    Set stockOpretionNoSet;
                    DisTaskDispatchEntryInfo disTaskDispatchEntryInfo = entrys.get(j);
                    BigDecimal qty = disTaskDispatchEntryInfo.getQty();
                    BigDecimal baseQty = disTaskDispatchEntryInfo.getBaseQty();
                    ManufactureOrderInfo moInfo = disTaskDispatchEntryInfo.getManufactureOrder();
                    if (moInfo == null) continue;
                    if (!isNeedStock.booleanValue()) {
                        moInfo.put("dispatchID", info.getId().toString());
                        mos.add(moInfo);
                        continue;
                    }
                    if (disTaskDispatchEntryInfo.getTechnicsLayer() == null || disTaskDispatchEntryInfo.getRowStatus() == null || !disTaskDispatchEntryInfo.getTechnicsLayer().equals((Object)TechnicslayerEnum.FIRST) || !disTaskDispatchEntryInfo.getRowStatus().equals((Object)RowStatusEnum.FINISHED) && !disTaskDispatchEntryInfo.getRowStatus().equals((Object)RowStatusEnum.NATURAL) || !(stockOpretionNoSet = this.getStockOpretionNoSet(moInfo)).contains(new Integer(disTaskDispatchEntryInfo.getOperationNumber().intValue()))) continue;
                    ManufactureOrderInfo cloneInfo = (ManufactureOrderInfo)moInfo.clone();
                    cloneInfo.put("dispatchID", info.getId().toString());
                    ManufactureOrderStockCollection sc = cloneInfo.getStocks();
                    for (int s = 0; s < sc.size(); ++s) {
                        if (sc.get(s).getOperationNo() == disTaskDispatchEntryInfo.getOperationNumber().intValue()) continue;
                        sc.removeObject(s);
                        --s;
                    }
                    mos.add(cloneInfo);
                    this.setMoDispatchQty(ctx, qty, baseQty, cloneInfo);
                }
            }
        }
        return mos;
    }

    private void setMoDispatchQty(Context ctx, BigDecimal qty, BigDecimal baseQty, ManufactureOrderInfo moInfo) throws EASBizException, BOSException {
        ManufactureOrderStockCollection stockCollection = moInfo.getStocks();
        if (stockCollection != null && stockCollection.size() > 0) {
            for (int m = 0; m < stockCollection.size(); ++m) {
                ManufactureOrderStockInfo stockInfo = stockCollection.get(m);
                stockInfo.setTotalDSTransferQty(qty);
                stockInfo.setTotalDSTransferBaseQty(baseQty);
                if (stockInfo.getUnitQty().compareTo(new BigDecimal("0")) < 0 || stockInfo.getUnitBaseQty() != null && stockInfo.getUnitBaseQty().compareTo(new BigDecimal("0")) > 0) continue;
                stockInfo.setUnitBaseQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)stockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)stockInfo.getUnit(), (MeasureUnitInfo)(stockInfo.getBaseUnit() == null ? stockInfo.getMaterial().getBaseUnit() : stockInfo.getBaseUnit()), (BigDecimal)stockInfo.getUnitQty()));
            }
        }
    }

    private Set getStockOpretionNoSet(ManufactureOrderInfo moInfo) {
        ManufactureOrderStockCollection stockCollection = moInfo.getStocks();
        HashSet<Integer> stockOperationNoSet = new HashSet<Integer>();
        if (stockCollection != null && stockCollection.size() > 0) {
            for (int m = 0; m < stockCollection.size(); ++m) {
                ManufactureOrderStockInfo stockInfo = stockCollection.get(m);
                stockOperationNoSet.add(new Integer(stockInfo.getOperationNo()));
            }
        }
        return stockOperationNoSet;
    }

    private SelectorItemCollection getSelectors(boolean isNeedStock) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("entrys.rowStatus"));
        sic.add(new SelectorItemInfo("entrys.operation.*"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.number"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.material.*"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.bomNum"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.qty"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.baseStatus"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.baseQty"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.technics.id"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.totalSplitQty"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.planBeginDate"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.planEndDate"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.routing.number"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.dispatcher.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.material.number"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.material.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.bizType.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.billType.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.unit.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.baseUnit.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.project.number"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.trackNumber.number"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.warehouse.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.assistUnit.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.replaceMaterial.name"));
        sic.add(new SelectorItemInfo("entrys.manufactureOrder.operation.name"));
        if (isNeedStock) {
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.*"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.storageOrgUnit.id"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.storageOrgUnit.number"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.material.number"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.material.id"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.material.name"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.material.model"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.unit.*"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.baseUnit.*"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.workcenter.number"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.workcenter.id"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.workcenter.*"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.workcenter.name"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.operation.number"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.operation.name"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.operation.id"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.operation.*"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.location.*"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.location.name"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.location.number"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.location.id"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.warehouse.*"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.warehouse.name"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.warehouse.hasLocation"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.warehouse.number"));
            sic.add(new SelectorItemInfo("entrys.manufactureOrder.stocks.warehouse.id"));
        }
        return sic;
    }
}

