/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MOBackFlush {
    protected ManufactureOrderInfo moInfo;
    protected BigDecimal productBaseQty;
    protected boolean isAudit = true;
    protected Integer ZERO = new Integer(0);
    protected int DEFAULT_PRECISION = 8;

    public Map calcBackFlushQty() {
        HashMap<String, BigDecimal> backFlushMap = new HashMap<String, BigDecimal>();
        this.filterStockEntry();
        Map replaceGroupMap = this.getReplaceGroup();
        if (replaceGroupMap != null && replaceGroupMap.size() > 0) {
            for (Integer key : replaceGroupMap.keySet()) {
                List list = (List)replaceGroupMap.get(key);
                if (key == 0) {
                    for (int j = 0; j < list.size(); ++j) {
                        ManufactureOrderStockInfo stockInfo = (ManufactureOrderStockInfo)list.get(j);
                        backFlushMap.put(stockInfo.getId().toString(), this.withoutReplaceCalc(stockInfo));
                    }
                    continue;
                }
                Map map = this.replaceCalc(list, this.productBaseQty);
                backFlushMap.putAll(map);
            }
        }
        return backFlushMap;
    }

    protected Map replaceCalc(List list, BigDecimal currProBaseQty) {
        HashMap<String, BigDecimal> backFlushMap = new HashMap<String, BigDecimal>();
        int backFlushQtyBase = this.moInfo.getTransactionType().getBackFlushQtyBase().getValue();
        BigDecimal orderBaseQty = this.moInfo.getBaseQty().subtract(this.moInfo.getTotalSplitBaseQty());
        for (int i = 0; i < list.size(); ++i) {
            ManufactureOrderStockInfo stockInfo = (ManufactureOrderStockInfo)list.get(i);
            BigDecimal maxBaseQty = backFlushQtyBase == 10 ? (stockInfo.getBaseQty().compareTo(SysConstant.BIGZERO) == 0 ? stockInfo.getPlannedBaseQty() : stockInfo.getBaseQty()) : stockInfo.getPlannedBaseQty();
            BigDecimal unitBaseQty = backFlushQtyBase == 10 ? stockInfo.getUnitBaseQty() : stockInfo.getPlannedBaseQty().divide(orderBaseQty, this.DEFAULT_PRECISION, 4);
            BigDecimal currentBaseQty = currProBaseQty.multiply(unitBaseQty).setScale(this.DEFAULT_PRECISION, 4);
            if (this.isAudit) {
                if (currentBaseQty.add(stockInfo.getToStoreBaseQty()).compareTo(maxBaseQty) <= 0) {
                    backFlushMap.put(stockInfo.getId().toString(), currentBaseQty);
                    break;
                }
                BigDecimal tempQty = maxBaseQty.subtract(stockInfo.getToStoreBaseQty());
                currProBaseQty = currProBaseQty.subtract(tempQty.divide(unitBaseQty, this.DEFAULT_PRECISION, 4));
                backFlushMap.put(stockInfo.getId().toString(), tempQty);
                continue;
            }
            if (currentBaseQty.compareTo(stockInfo.getToStoreBaseQty()) <= 0) {
                backFlushMap.put(stockInfo.getId().toString(), currentBaseQty);
                break;
            }
            backFlushMap.put(stockInfo.getId().toString(), stockInfo.getToStoreBaseQty());
            currProBaseQty = currProBaseQty.subtract(stockInfo.getToStoreBaseQty().divide(unitBaseQty, this.DEFAULT_PRECISION, 4));
        }
        return backFlushMap;
    }

    protected BigDecimal withoutReplaceCalc(ManufactureOrderStockInfo stockInfo) {
        int backFlushQtyBase = this.moInfo.getTransactionType().getBackFlushQtyBase().getValue();
        BigDecimal orderBaseQty = this.moInfo.getBaseQty().subtract(this.moInfo.getTotalSplitBaseQty());
        BigDecimal maxBaseQty = backFlushQtyBase == 10 ? (stockInfo.getBaseQty().compareTo(SysConstant.BIGZERO) == 0 ? stockInfo.getPlannedBaseQty() : stockInfo.getBaseQty()) : stockInfo.getPlannedBaseQty();
        BigDecimal unitBaseQty = backFlushQtyBase == 10 ? stockInfo.getUnitBaseQty() : stockInfo.getPlannedBaseQty().divide(orderBaseQty, this.DEFAULT_PRECISION, 4);
        BigDecimal currentBaseQty = this.productBaseQty.multiply(unitBaseQty).setScale(this.DEFAULT_PRECISION, 4);
        if (this.isAudit) {
            if (currentBaseQty.add(stockInfo.getToStoreBaseQty()).compareTo(maxBaseQty) <= 0) {
                return currentBaseQty;
            }
            return maxBaseQty.subtract(stockInfo.getToStoreBaseQty());
        }
        if (currentBaseQty.compareTo(stockInfo.getToStoreBaseQty()) <= 0) {
            return currentBaseQty;
        }
        return stockInfo.getToStoreBaseQty();
    }

    protected Map getReplaceGroup() {
        HashMap map = new HashMap();
        for (int i = 0; i < this.moInfo.getStocks().size(); ++i) {
            List<ManufactureOrderStockInfo> list;
            ManufactureOrderStockInfo stockInfo = this.moInfo.getStocks().get(i);
            if (stockInfo.getReplaceGroupFlag() == 0) {
                ArrayList<ManufactureOrderStockInfo> list2 = (ArrayList<ManufactureOrderStockInfo>)map.get(this.ZERO);
                if (list2 == null) {
                    list2 = new ArrayList<ManufactureOrderStockInfo>();
                }
                list2.add(stockInfo);
                map.put(this.ZERO, list2);
                continue;
            }
            Integer key = new Integer(stockInfo.getReplaceGroupFlag());
            if (map.containsKey(key)) {
                list = (List)map.get(key);
                list.add(stockInfo);
                Collections.sort(list, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        ManufactureOrderStockInfo stockInfo0 = (ManufactureOrderStockInfo)arg0;
                        ManufactureOrderStockInfo stockInfo1 = (ManufactureOrderStockInfo)arg1;
                        return stockInfo0.getReplacePriority() - stockInfo1.getReplacePriority();
                    }
                });
                map.put(key, list);
                continue;
            }
            list = new ArrayList();
            list.add(stockInfo);
            map.put(key, list);
        }
        return map;
    }

    protected void filterStockEntry() {
        int backFlushQtyBase = this.moInfo.getTransactionType().getBackFlushQtyBase().getValue();
        Iterator stockIte = this.moInfo.getStocks().iterator();
        while (stockIte.hasNext()) {
            BigDecimal maxBaseQty;
            ManufactureOrderStockInfo stockInfo = (ManufactureOrderStockInfo)stockIte.next();
            BigDecimal toStoreBaseQty = stockInfo.getToStoreBaseQty();
            if (toStoreBaseQty.compareTo(maxBaseQty = backFlushQtyBase == 10 ? stockInfo.getBaseQty() : stockInfo.getPlannedBaseQty()) < 0) continue;
            stockIte.remove();
        }
    }

    public ManufactureOrderInfo getMoInfo() {
        return this.moInfo;
    }

    public void setMoInfo(ManufactureOrderInfo arg) {
        this.moInfo = arg;
    }

    public BigDecimal getProductBaseQty() {
        return this.productBaseQty;
    }

    public void setProductBaseQty(BigDecimal arg) {
        this.productBaseQty = arg;
    }

    public void setIsAudit(boolean arg) {
        this.isAudit = arg;
    }

    public boolean isAudit() {
        return this.isAudit;
    }
}

