/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.IMMVerifyManager;
import com.kingdee.eas.mm.common.app.verify.MMVerifyManager;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.util.MOAutoFinishUtil;
import com.kingdee.eas.mm.mo.app.util.MOMaterialInfoUtil;
import com.kingdee.eas.mm.mo.app.util.MOMultiMeasureUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MOFinish {
    public static void manualFinished(Context ctx, String[] moIDS) throws EASBizException, BOSException {
        String idStr = SQLUtil.arrayToString((Object[])moIDS);
        MOFinish.finished(ctx, idStr, 0);
    }

    public static void manualUnFinished(Context ctx, String[] moIDS) throws EASBizException, BOSException {
        String idStr = SQLUtil.arrayToString((Object[])moIDS);
        String[] sqls = new String[1];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ManufactureOrder ").append("set FBaseStatus = ").append(5).append(", ").append("FIsAutoFinished = 0,FActureEndDate=null ").append("where FID in (").append(idStr).append(") and FIsAutoFinished = 0").append("and FBaseStatus = ").append(8).append(" ");
        sqls[0] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    private static void finished(Context ctx, String idStr, int autoFlag) throws EASBizException, BOSException {
        String[] sqls = new String[1];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ManufactureOrder as mo ").append("set FBaseStatus = ").append(8).append(",").append("FIsAutoFinished = ").append(autoFlag).append(",FActureEndDate= (select freporttime from ").append("(select m.fid,max(c.freporttime) as freporttime ").append("from t_mm_manufactureorder as m left outer join t_mm_completionreport as c ").append("on m.fid = c.FDMESORDERID group by  m.fid ) as t ").append("where mo.fid = t.fid )").append("where mo.FID in (").append(idStr).append(") ");
        sqls[0] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    private static String createTempTable(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("CREATE TABLE ls (").append("FBillID varchar(44) null, ").append("FVersion int null ").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    public static void dealWithMOFinish(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "CREATE TABLE FORMOFINISH(FSourceBillID VARCHAR(44))";
        String tableName = null;
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = "INSERT INTO " + tableName + "(FSourceBillID) values (?)";
        DBUtil.executeUpdate((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        ManufactureOrderInfo mo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo(pk, sic);
        if (mo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE)) {
            MOFinish.moDefaultUnAutoFinish(ctx, tableName);
        } else {
            MOFinish.autoFinish(ctx, tableName, true);
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    public static void autoFinish(Context ctx, String tempTableName, boolean isIgnoreBackflush) throws EASBizException, BOSException {
        String tempTable = "";
        try {
            Object[] result = MOAutoFinishUtil.getMOForAutoFinish(ctx, tempTableName);
            ManufactureOrderCollection moCol = (ManufactureOrderCollection)((Object)result[0]);
            tempTable = (String)result[1];
            if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
                return;
            }
            Map paramMap = MOFinish.prepareParamMap(ctx, tempTable, moCol, isIgnoreBackflush);
            BatchActionResults batchResults = BatchActionResults.populateActionResults((IObjectCollection)moCol);
            IMMVerifyManager moVerify = MOFinish.getVerifyManager(ctx, "MOAutoFinishManager", paramMap, batchResults);
            moVerify.verify();
            if (batchResults.getToDoIdsSet().size() == 0) {
                return;
            }
            MOFinish.finished(ctx, SQLUtil.setToString((Set)batchResults.getToDoIdsSet()), 1);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    private static final Map prepareParamMap(Context ctx, String tempTable, ManufactureOrderCollection moCol, boolean isIgnoreBackflush) throws BOSException {
        Map<String, Integer> multiMeasureUnitMap = MOMultiMeasureUnitUtil.getMultiMeasureUnit(ctx, moCol, tempTable);
        Map<String, Boolean> isKeyPartMap = MOMaterialInfoUtil.getMaterialPlanInfo(ctx, moCol, tempTable);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("manufactureOrderColection", (Object)moCol);
        paramMap.put("multiMeasureUnitMap", multiMeasureUnitMap);
        paramMap.put("isKeyPartMap", isKeyPartMap);
        paramMap.put("isIgnoreBackflush", isIgnoreBackflush);
        return paramMap;
    }

    public static void productReceiptUnAutoFinish(Context ctx, String tempTableName) throws EASBizException, BOSException {
        String[] sqls = new String[2];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_MFTOrderStock   ").append("set FActureLossRatio = 0, ").append("FActLossQty = 0,").append("FActLossBaseQty = 0 ").append("where FParentID in (").append("Select t0.FID ").append("From T_MM_ManufactureOrder t0,T_MM_ProductTransactionType t1, ").append(tempTableName).append(" t2 ,").append(" t_bd_multimeasureunit b1   ").append("Where t2.FSourceBillID = t0.FID ").append("and t0.FIsAutoFinished = 1 and t0.FUnitID = b1.fmeasureunitid  ").append(" and t0.FToStroreQty +t0.FScrapQty < round(to_decimal((t0.FQty-t0.FTotalSplitQty)*(1-t0.FLackRatio/100),21,8), b1.FQtyPrecision) ").append("and t0.FBaseStatus = ").append(8).append(" ").append("And t0.FisLimitedQty= 1 ").append(")");
        sqls[0] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_ManufactureOrder as t0 ").append("set FBaseStatus = ").append(5).append(", ").append("FIsAutoFinished = 0,FActureEndDate= null ").append("where exists(").append("Select 1 from ").append(tempTableName).append(" t2 ").append("Where t2.FSourceBillID = t0.FID) ").append(" and t0.FIsAutoFinished = 1").append(" and t0.FBaseStatus = ").append(8).append(" ").append(" and t0.FisLimitedQty= 1 ").append(" and ").append(" exists(").append("Select 1 ").append("from t_bd_multimeasureunit b1 ").append("where b1.fMeasureunitid = t0.FUnitID  ").append("and b1.fMaterialID = t0.FMaterialID ").append("and t0.FToStroreQty + t0.FScrapQty < round(to_decimal((t0.FQty-t0.FTotalSplitQty)*(1-t0.FLackRatio/100),21,8), b1.FQtyPrecision)) ");
        sqls[1] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    public static void completReportFinishOrUnFinish(Context ctx, String tempTableName) throws EASBizException, BOSException {
        String tempTable = "";
        try {
            Object[] result = MOAutoFinishUtil.getMOForAutoFinish(ctx, tempTableName);
            ManufactureOrderCollection moCol = (ManufactureOrderCollection)((Object)result[0]);
            tempTable = (String)result[1];
            if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
                return;
            }
            Map paramMap = MOFinish.prepareParamMap(ctx, tempTable, moCol, true);
            BatchActionResults batchResults = BatchActionResults.populateActionResults((IObjectCollection)moCol);
            HashSet allIdsSet = (HashSet)((HashSet)batchResults.getToDoIdsSet()).clone();
            IMMVerifyManager moVerify = MOFinish.getVerifyManager(ctx, "MOAutoFinishManager", paramMap, batchResults);
            moVerify.verify();
            if (batchResults.getToDoIdsSet().size() != 0) {
                MOFinish.finished(ctx, SQLUtil.setToString((Set)batchResults.getToDoIdsSet()), 1);
            }
            allIdsSet.removeAll(batchResults.getToDoIdsSet());
            if (allIdsSet.size() != 0) {
                MOFinish.moDefaultUnFinishUpdate(ctx, allIdsSet);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    private static void moDefaultUnFinishUpdate(Context ctx, Set allIdsSet) throws BOSException {
        String[] sqls = new String[2];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_MFTOrderStock set FActureLossRatio = 0,  FActLossQty = 0, FActLossBaseQty = 0 ").append(" where FParentID in ( ").append(" Select t0.FID From T_MM_ManufactureOrder t0 Where ").append(" t0.FID in ( ").append(SQLUtil.setToString((Set)allIdsSet)).append(" ) ").append(" and t0.FIsAutoFinished = 1 and t0.FBaseStatus = ").append(8).append(" ) ");
        sqls[0] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_ManufactureOrder ").append(" set FBaseStatus = ").append(5).append(", ").append(" FIsAutoFinished = 0, FActureEndDate = null").append(" where FID in ( ").append(SQLUtil.setToString((Set)allIdsSet)).append(" ) ").append(" and FBaseStatus = ").append(8);
        sqls[1] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    protected static IMMVerifyManager getVerifyManager(Context ctx, String verifyManagerName, Map paramMap, BatchActionResults batchResults) throws BOSException, EASBizException {
        return new MMVerifyManager(ctx, MOFinish.getVerifyXmlFile(), verifyManagerName, paramMap, batchResults);
    }

    protected static String getVerifyXmlFile() {
        return "com.kingdee.eas.mm.mo.app.verify.ManufactureOrderVerify";
    }

    public static void moDefaultUnAutoFinish(Context ctx, String tempTableName) throws EASBizException, BOSException {
        String tempTable = "";
        try {
            Object[] result = MOAutoFinishUtil.getMOForAutoFinish(ctx, tempTableName);
            ManufactureOrderCollection moCol = (ManufactureOrderCollection)((Object)result[0]);
            tempTable = (String)result[1];
            if (MOMaterialInfoUtil.isNullCol((IObjectCollection)moCol)) {
                return;
            }
            Map paramMap = MOFinish.prepareParamMap(ctx, tempTable, moCol, true);
            BatchActionResults batchResults = BatchActionResults.populateActionResults((IObjectCollection)moCol);
            HashSet allIdsSet = (HashSet)((HashSet)batchResults.getToDoIdsSet()).clone();
            IMMVerifyManager moVerify = MOFinish.getVerifyManager(ctx, "MOAutoUnFinishManager", paramMap, batchResults);
            moVerify.verify();
            allIdsSet.removeAll(batchResults.getToDoIdsSet());
            if (allIdsSet.size() == 0) {
                return;
            }
            MOFinish.moDefaultUnFinishUpdate(ctx, allIdsSet);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }
}

