/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.app.CheckPickingHandler;
import com.kingdee.eas.mm.mo.app.MOFinish;
import com.kingdee.eas.mm.mo.app.util.MOAutoCloseUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class MOMaterialWithdrawal
extends BillUpdater {
    TransactionTypeInfo transTypeInfo;

    public MOMaterialWithdrawal(Context ctx) {
        super(ctx);
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        if (!this.isAuditAction) {
            StringBuffer sb = new StringBuffer();
            sb.append("select top 1 FID from T_IM_MaterialReqBill ").append("where FIsBackflush = 1 and FID in (select FBillID from ").append(this.sourceDataTable).append(") ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            try {
                if (rs != null && rs.next()) {
                    throw new ManufactureOrderException(ManufactureOrderException.NO_UNAUDIT_BACKFLUSHBILL);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        this.checkMOClose();
        boolean ret = false;
        int bizDirection = this.transTypeInfo.getRiType().getBizDirection().getValue();
        this.setTargetTable("T_MM_MFTOrderStock");
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        if (bizDirection == 1) {
            this.setBaseQtyFields(new String[]{"FActIssueBaseQty", "FUnIssueBaseQty", "FAssociateQty"});
            this.setQtyFields(new String[]{"FActIssueQty", "FUnIssueQty"});
            this.setUnBaseQtyExpression("FAssociateQty");
            if (this.isAuditAction) {
                this.setBaseQtyOperation(new String[]{"+", "-", "-"});
                this.setQtyOperation(new String[]{"+", "-"});
            } else {
                this.setBaseQtyOperation(new String[]{"-", "+", "+"});
                this.setQtyOperation(new String[]{"-", "+"});
            }
            ret = true;
        } else {
            this.setBaseQtyFields(new String[]{"FRejectedBaseQty", "FUnIssueBaseQty", "FAssociateQty"});
            this.setQtyFields(new String[]{"FRejectedQty", "FUnIssueQty"});
            this.setUnBaseQtyExpression("FwipBaseQty");
            if (this.isAuditAction) {
                this.setBaseQtyOperation(new String[]{"+", "+", "+"});
                this.setQtyOperation(new String[]{"+", "+"});
            } else {
                this.setBaseQtyOperation(new String[]{"-", "-", "-"});
                this.setQtyOperation(new String[]{"-", "-"});
            }
            ret = true;
        }
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        return ret;
    }

    protected void afterExecute() throws BOSException, EASBizException {
        int bizDirection = this.transTypeInfo.getRiType().getBizDirection().getValue();
        if (!this.isAuditAction() && bizDirection == 1) {
            CheckPickingHandler handler = new CheckPickingHandler(this.ctx);
            handler.checkMaterialReq(this.sourceDataTable);
        }
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        moBiz.calculateWIP(this.sourceDataTable);
        String[] sqls = new String[2];
        if (this.isAuditAction) {
            sqls[0] = "update T_MM_MFTOrderStock mostockentry set FActueIssueTime = ( select min(mareq.FBizDate) from T_IM_MaterialReqBillEntry mareqentry    inner join T_IM_MaterialReqBill mareq on mareqentry.fparentid=mareq.fid   where mareq.fbasestatus=4 and mareqentry.FSourceBillEntryID = mostockentry.fid )  where fid in (select FSourceBillEntryID from " + this.sourceDataTable + ") ";
            sqls[1] = "update t_mm_manufactureorder mo  set FActureBeginDate = (select case when m.FBizDate < mo.facturebegindate then m.FBizDate else ISNULL(mo.facturebegindate,m.FBizDate) end  from (select fsourcebillid,min(fbizdate) fbizdate from " + this.sourceDataTable + " group by fsourcebillid) m  where mo.fid = m.fsourcebillid) where exists  (select 1  from  " + this.sourceDataTable + " tmp where mo.fid = tmp.fsourcebillid  )";
        } else {
            sqls[0] = "update T_MM_MFTOrderStock mostockentry set FActueIssueTime = ( select min(mareq.FBizDate) from T_IM_MaterialReqBillEntry mareqentry    inner join T_IM_MaterialReqBill mareq on mareqentry.fparentid=mareq.fid   where mareq.fbasestatus=4 and mareqentry.FSourceBillEntryID = mostockentry.fid )  where fid in (select FSourceBillEntryID from " + this.sourceDataTable + ") ";
            sqls[1] = null;
        }
        SQLUtil.batchExecuteSql((Context)this.ctx, (String[])sqls);
        if (this.isAuditAction) {
            if (bizDirection == 1) {
                MOFinish.autoFinish(this.ctx, this.sourceDataTable, true);
            } else if (bizDirection == -1) {
                MOFinish.moDefaultUnAutoFinish(this.ctx, this.sourceDataTable);
            }
        } else if (bizDirection == 1) {
            MOFinish.moDefaultUnAutoFinish(this.ctx, this.sourceDataTable);
        } else if (bizDirection == -1) {
            MOFinish.autoFinish(this.ctx, this.sourceDataTable, true);
        }
        if (this.isAuditAction()) {
            MOAutoCloseUtil.autoCloseFromMRBByMO(this.ctx, this.sourceDataTable, false);
        }
        super.afterExecute();
    }

    public TransactionTypeInfo getTransTypeInfo() {
        return this.transTypeInfo;
    }

    public void setTransTypeInfo(TransactionTypeInfo transTypeInfo) {
        this.transTypeInfo = transTypeInfo;
    }

    public boolean checkMOClose() throws BOSException, EASBizException {
        boolean isMOclose = false;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(this.sourceDataTable).append(" s,  ").append(" T_IM_MaterialReqBill t ").append(" where s.fSourceBillID = mo.fid  and  mo.fBaseStatus in (6,7,11)  and t.fid = s.fbillid ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                isMOclose = true;
                String billID = rs.getString("fnumber");
                errMap.put(billID, "1");
                ++i;
            }
            if (isMOclose) {
                throw new ManufactureOrderException(ManufactureOrderException.MO_CLOSED, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isMOclose;
    }

    private boolean checkPicking(Map params) throws BOSException, EASBizException {
        String strIds = StringUtils.arrayToString((Object[])params.keySet().toArray(), (String)"','");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select stock.fid stockId,stock.FwipBaseQty wipBaseQty,transType.FIsPicking isPicking,transType.fPicking picking,mp.fisKeyPart isKeyPart, ");
        sqlBuffer.append(" (stock.factIssueBaseQty - stock.frejectedBaseQty + stock.FTotalDirectReceiveBaseQty + stock.ffeedingBaseQty + stock.fmaterialFeedingBaseQty - stock.fscrapBaseQty - stock.fmaterialScrapBaseQty) maxRejectQty");
        sqlBuffer.append(" from t_mm_mftorderStock stock ");
        sqlBuffer.append(" inner join t_mm_manufactureOrder mo on mo.fid = stock.fparentId ");
        sqlBuffer.append(" inner join t_mm_ProductTransactionType transType on mo.fTransactionTypeId = transType.FId ");
        sqlBuffer.append(" inner join t_bd_materialPlan mp on stock.fmaterialId = mp.fmaterialId and mp.forgUnit = mo.fstorageOrgUnitId ");
        sqlBuffer.append(" where stock.fid in ('" + strIds + "')");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            while (rs.next()) {
                String stockId = rs.getString("stockId");
                BigDecimal baseQty = (BigDecimal)params.get(stockId);
                BigDecimal wipBaseQty = rs.getBigDecimal("wipBaseQty");
                int isPicking = rs.getInt("isPicking");
                int picking = rs.getInt("picking");
                int isKeyPart = rs.getInt("isKeyPart");
                BigDecimal maxRejectQty = rs.getBigDecimal("maxRejectQty");
                if (isPicking == 1 && (picking == 20 && isKeyPart == 1 || picking == 10) && baseQty.compareTo(wipBaseQty) > 0) {
                    this.setThrowExcpetion((EASBizException)((Object)new MMCommonException(MMCommonException.REJQTY)));
                    return false;
                }
                if (baseQty.compareTo(maxRejectQty) <= 0) continue;
                this.setThrowExcpetion((EASBizException)((Object)new MMCommonException(MMCommonException.OUTREJQTY)));
                return false;
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        return true;
    }

    private boolean checkRejectQty() throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select FSourceBillEntryId,sum(FBaseQty) FBaseQty ");
        sqlBuffer.append(" from ").append(this.sourceDataTable).append(" group by FSourceBillEntryId ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                BigDecimal baseQty = rs.getBigDecimal("FBaseQty");
                String stockId = rs.getString("FSourceBillEntryId");
                map.put(stockId, baseQty);
            }
            return this.checkPicking(map);
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        if (this.transTypeInfo != null && -1 == this.transTypeInfo.getRiType().getBizDirection().getValue()) {
            return this.checkRejectQty();
        }
        boolean ret = true;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select t1.FID ").append("from ").append(this.targetTable).append(" t1  ").append("inner join (select tt.").append(this.getFID()).append(" FSRCID,sum(tt.FBaseQty) sum_baseqty ").append("from ").append(this.sourceDataTable).append(" tt ").append("group by ").append(this.getFID()).append(") t2 ").append("on t1.FID = t2.FSRCID ").append("and  ").append("t1.fisqtylimit = 1 ").append("and  ").append("t1.fassociateqty").append(" < t2.sum_baseqty ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            if (rs != null && rs.next()) {
                ret = false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }
}

