/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.app.MOFinish;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class MOMaterialrequestProcessor
extends BillUpdater
implements MMExternalProcessor {
    protected String[] billIds = null;

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        if (!"50957179-0105-1000-e000-0163c0a812fd463ED552".equalsIgnoreCase(billTypeId)) {
            return;
        }
        this.ctx = ctx;
        this.billIds = billIds;
        this.isAuditAction = bizAction == 103;
        this.execute();
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        this.sourceDataTable = this.createTempTable();
        this.insertTempTableData();
        if (!this.checkTempTableData()) {
            return false;
        }
        this.checkMOStatus();
        this.setTargetTable("T_MM_MFTOrderStock");
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        this.setBaseQtyFields(new String[]{"FActIssueBaseQty", "FUnIssueBaseQty", "FAssociateQty"});
        this.setQtyFields(new String[]{"FActIssueQty", "FUnIssueQty"});
        this.setUnBaseQtyExpression("FAssociateQty");
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+", "-", "-"});
            this.setQtyOperation(new String[]{"+", "-"});
        } else {
            this.setBaseQtyOperation(new String[]{"-", "+", "+"});
            this.setQtyOperation(new String[]{"-", "+"});
        }
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        return true;
    }

    protected void afterExecute() throws BOSException, EASBizException {
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        moBiz.calculateWIP(this.sourceDataTable);
        String[] sqls = new String[2];
        if (this.isAuditAction) {
            sqls[0] = "update T_MM_MFTOrderStock set FActueIssueTime = getdate() where FID in (select FSourceBillEntryID from " + this.sourceDataTable + ") and FActueIssueTime is null ";
            sqls[1] = "update t_mm_manufactureorder mo set FActureBeginDate = ( select min(FBizDate) from t_im_materialreqbill m    inner join t_bot_relation r on r.FDestObjectID = m.fid    where  m.fbasestatus=4 and (r.FSrcObjectID = mo.fid or r.FSrcObjectID in (select d.FParentID from T_MM_DirectDest d where d.fsourcebillid=mo.fid)))  where fid in (select FSourceBillID from " + this.sourceDataTable + ") ";
        } else {
            sqls[0] = "update T_MM_MFTOrderStock set FActueIssueTime = null where FID in (select FSourceBillEntryID from " + this.sourceDataTable + ") and FActIssueBaseQty = 0 ";
            sqls[1] = "update t_mm_manufactureorder mo set FActureBeginDate = ( select min(FBizDate) from t_im_materialreqbill m    inner join t_bot_relation r on r.FDestObjectID = m.fid    where  m.fbasestatus=4 and (r.FSrcObjectID = mo.fid or r.FSrcObjectID in (select d.FParentID from T_MM_DirectDest d where d.fsourcebillid=mo.fid)))  where fid in (select FSourceBillID from " + this.sourceDataTable + ") ";
        }
        SQLUtil.batchExecuteSql((Context)this.ctx, (String[])sqls);
        if (this.isAuditAction) {
            MOFinish.autoFinish(this.ctx, this.sourceDataTable, true);
        } else {
            MOFinish.moDefaultUnAutoFinish(this.ctx, this.sourceDataTable);
        }
        super.afterExecute();
    }

    private String createTempTable() throws EASBizException, BOSException {
        return BillUpdaterFactory.createTempTable((Context)this.ctx);
    }

    private void insertTempTableData() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(this.sourceDataTable);
        sb.append(" (FBillID, FBillEntryID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ");
        sb.append("SELECT T.FParentID, T.FID, T.FCoreBillID, T.FCoreBillEntryID, T.FBaseQty, T.FQty ");
        sb.append("FROM T_IM_MaterialReqBillEntry T ");
        sb.append("WHERE T.FParentID IN (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append("XlazxwEREADgAAAEwKgSxUY+1VI=").append("' AND ");
        sb.append(" T.FCoreBillTypeID = '").append("B2aZSVXaSx6qxdfekgCmrEY+1VI=").append("'");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    private boolean checkTempTableData() throws BOSException {
        boolean flag = true;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(FBillID) AS totalCount FROM ");
        sb.append(this.sourceDataTable);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            int closedCount;
            if (rs != null && rs.next() && (closedCount = rs.getInt("totalCount")) <= 0) {
                flag = false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return flag;
    }

    private void checkMOStatus() throws BOSException, EASBizException {
        boolean isMOclose = false;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(mo.fid) AS closedCount ");
        sb.append("FROM T_MM_ManufactureOrder mo, ");
        sb.append(this.sourceDataTable).append(" s ");
        sb.append(" WHERE s.fSourceBillID = mo.fid AND mo.fBaseStatus IN (6,7,11)");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            int closedCount;
            if (rs != null && rs.next() && (closedCount = rs.getInt("closedCount")) > 0) {
                isMOclose = true;
            }
            if (isMOclose) {
                String msg = null;
                msg = this.isAuditAction ? ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Audit_Order_Is_Closed") : ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Unaudit_Order_Is_Closed");
                throw new ManufactureOrderException(ManufactureOrderException.COMMONEXCEPTION, new Object[]{msg});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        boolean ret = true;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select t1.FID ").append("from ").append(this.targetTable).append(" t1  ").append("inner join (select tt.").append(this.getFID()).append(" FSRCID,sum(tt.FBaseQty) sum_baseqty ").append("from ").append(this.sourceDataTable).append(" tt ").append("group by ").append(this.getFID()).append(") t2 ").append("on t1.FID = t2.FSRCID ").append("and  ").append("t1.fisqtylimit = 1 ").append("and  ").append("t1.fassociateqty").append(" < t2.sum_baseqty ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            if (rs != null && rs.next()) {
                ret = false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }
}

