/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;

public class MOOutputReceiptUpdater
extends BillUpdater
implements MMExternalProcessor {
    private static final String currBillTypeID = "B2aZSVXaSx6qxdfekgCmrEY+1VI=";
    protected String billTypeID = null;
    protected String[] billIds = null;

    protected boolean beforeExecute() throws BOSException, EASBizException {
        if (!this.checkDataCount()) {
            return false;
        }
        this.insertTempTableData();
        this.checkMOClose();
        this.setTargetTable("T_MM_MFTOrderExpectOutput");
        this.setUpdateHead(false);
        this.setTransfUnit(false);
        this.setBaseQtyFields(new String[]{"FToStoreBaseQty"});
        this.setQtyFields(new String[]{"FToStoreQty"});
        this.setUnBaseQtyExpression("ISNULL(FBaseQty,0)-ISNULL(FToStoreBaseQty,0)");
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+"});
            this.setQtyOperation(new String[]{"+"});
        } else {
            this.setBaseQtyOperation(new String[]{"-"});
            this.setQtyOperation(new String[]{"-"});
        }
        this.setReleaseTempTable(false);
        this.setThrowException(true);
        this.setThrowExcpetion((EASBizException)((Object)new MMCommonException(MMCommonException.REWRITEQTY_GT_UNRECEIPTQTY)));
        return true;
    }

    private boolean checkDataCount() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(T.FID) iCount ");
        sb.append("from T_IM_ManufactureRecBill T ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                if (rows.getInt("iCount") <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void insertTempTableData() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ");
        sb.append(this.sourceDataTable);
        sb.append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ");
        sb.append("select T.FID, entry.FSourceBillID, entry.FSourceBillEntryId, Entry.FBaseQty, Entry.FQty ");
        sb.append("from T_IM_ManufactureRecBill T ");
        sb.append("inner join T_IM_ManufactureRecBillEntry entry on T.FID = entry.FParentId ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        sb.append(" and entry.fsourcebillentryid != entry.fsourcebillid ");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        return true;
    }

    public boolean checkMOClose() throws BOSException, EASBizException {
        boolean isMOclose = false;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(this.sourceDataTable).append(" s,  ").append(" T_IM_ManufactureRecBill t ").append(" where s.fSourceBillID = mo.fid  and  mo.fBaseStatus in (6,7,11)  and t.fid = s.fbillid ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                isMOclose = true;
                String billID = rs.getString("fnumber");
                errMap.put(billID, "1");
                ++i;
            }
            if (isMOclose) {
                throw new ManufactureOrderException(ManufactureOrderException.MO_CLOSED, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isMOclose;
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.billIds = billIds;
        this.billTypeID = billTypeId;
        String tableName = BillUpdaterFactory.createTempTable((Context)ctx);
        this.setReleaseTempTable(true);
        this.setSourceDataTable(tableName);
        this.setAuditAction(bizAction == 103);
        super.execute();
    }
}

