/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.app.BackFlushHandler;
import com.kingdee.eas.mm.mo.app.CheckPickingHandler;
import com.kingdee.eas.mm.mo.app.MOMaterialBackFlush;
import com.kingdee.eas.mm.mo.app.ManufactureRecBillAuditUtil;
import com.kingdee.eas.mm.mo.app.util.MOAutoCloseUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class MOProductReceiptUpdater
extends BillUpdater
implements MMExternalProcessor {
    private static final String currBillTypeID = "B2aZSVXaSx6qxdfekgCmrEY+1VI=";
    protected String billTypeID = null;
    protected String[] billIds = null;

    protected boolean beforeExecute() throws BOSException, EASBizException {
        if (!this.checkDataCount()) {
            return false;
        }
        this.insertTempTableData();
        this.checkMOClose();
        MOAutoCloseUtil.checkProductTransactionTypeForMO(this.ctx, this.sourceDataTable);
        this.setTargetTable("T_MM_ManufactureOrder");
        this.setUpdateHead(true);
        this.setTransfUnit(true);
        this.setBaseQtyFields(new String[]{"FToStoreBaseQty", "FUnToStoreBaseQty"});
        this.setQtyFields(new String[]{"FToStroreQty", "FUnToStoreQty"});
        this.setUnBaseQtyExpression("FUnToStoreBaseQty");
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+", "-"});
            this.setQtyOperation(new String[]{"+", "-"});
            this.setAuditAction(true);
        } else {
            this.setBaseQtyOperation(new String[]{"-", "+"});
            this.setQtyOperation(new String[]{"-", "+"});
            this.setAuditAction(false);
        }
        this.setThrowException(true);
        this.setThrowExcpetion(new ManufactureOrderException(ManufactureOrderException.EXCEEDTOPLIMIT));
        return true;
    }

    private boolean checkDataCount() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(T.FID) iCount ");
        sb.append("from T_IM_ManufactureRecBill T ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                if (rows.getInt("iCount") <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void insertTempTableData() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ");
        sb.append(this.sourceDataTable);
        sb.append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ");
        sb.append("select T.FID, Entry.FSourceBillID, Entry.FSourceBillEntryId, Entry.FBaseQty, Entry.FQty ");
        sb.append("from T_IM_ManufactureRecBill T ");
        sb.append("inner join T_IM_ManufactureRecBillEntry entry on T.FID = entry.FParentId ");
        sb.append("where T.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" T.FSourceBillTypeID = '").append(currBillTypeID).append("'");
        sb.append(" and (entry.fsourcebillentryid = entry.fsourcebillid or entry.fsourcebillentryid is null)");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        String tempTable = this.sourceDataTable;
        this.sourceDataTable = "(select t0.* from " + tempTable + " t0,T_MM_ManufactureOrder t1 where t0.FSourceBillID = t1.FID and t1.FisLimitedQty= 1)";
        boolean ret = super.qtyCheck();
        this.sourceDataTable = tempTable;
        if (ret) {
            CheckPickingHandler handler = new CheckPickingHandler(this.ctx);
            handler.checkManufactureRec(this.sourceDataTable);
        }
        return ret;
    }

    protected void afterExecute() throws BOSException, EASBizException {
        String selectSql;
        IRowSet rs;
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        StringBuffer updateSql = new StringBuffer();
        String entryDataTable = BillUpdaterFactory.createTempTable((Context)this.ctx);
        updateSql.append("insert into ").append(entryDataTable).append(" (FBillID,FSourceBillID,FSourceBillEntryId,FBaseQty)").append("select t2.FBillID,t1.FParentID,t1.FID,t2.FBaseQty ").append("from T_MM_MFTOrderStock t1, ").append(this.sourceDataTable).append(" t2 ").append("where  t1.FParentID = t2.FSourceBillID ");
        int rowcount = MRPUtil.executeUpdate((Context)this.ctx, (String)updateSql.toString());
        if (rowcount > 0) {
            moBiz.calculateWIP(entryDataTable);
        }
        if ((rs = DbUtil.executeQuery((Context)this.ctx, (String)(selectSql = "select FBillID from " + this.sourceDataTable))) != null && rs.size() > 0) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0167c0a812fd463ED552"));
            String[] billIDs = new String[rs.size()];
            try {
                int i = 0;
                while (rs != null && rs.next()) {
                    billIDs[i++] = rs.getString("FBillID");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (this.isAuditAction) {
                try {
                    ManufactureRecBillAuditUtil.setManufactureRecBillBackFlushStatus(this.ctx, billIDs);
                }
                catch (SQLException e1) {
                    throw new SQLDataException(e1);
                }
                StringBuffer sql1 = new StringBuffer();
                sql1.append("select tt.fid fid,").append("tt.fnumber num from ( ").append("select t.FID,count(t.fid) fcount , ").append(" t.FNumber,").append(" sum(fflag) fflag from ( ").append("select t0.FID,t1.FSourceBillID FOrderID,t0.FNumber,t3.FIsAutoBackFlush fflag ").append("from T_IM_ManufactureRecBill t0  ").append("inner join T_IM_ManufactureRecBillEntry t1 on t0.FID = t1.FParentID  ").append("inner join T_MM_ManufactureOrder t2 on t1.FMANUBILLID = t2.FID  ").append("inner join T_MM_ProductTransactionType t3 on t2.FTransactionTypeID = t3.FID  ").append("where t0.fid in ( select FBillID from ").append(this.sourceDataTable).append(" )").append(") as t  group by t.fid, ").append(" t.FNumber ").append(") as tt where fcount = fflag ");
                IRowSet rs1 = DbUtil.executeQuery((Context)this.ctx, (String)sql1.toString());
                if (null != rs1 && rs1.size() > 0) {
                    String[] bills = new String[rs1.size()];
                    String[] numbers = new String[rs1.size()];
                    int k = 0;
                    try {
                        while (rs1.next()) {
                            bills[k] = rs1.getString("fid");
                            numbers[k] = rs1.getString("num");
                            ++k;
                        }
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                    this.ctx.put((Object)"isAutoFlushFromMRB", (Object)Boolean.TRUE);
                    Map returnMap = new HashMap();
                    IObjectPK[] logPks = new IObjectPK[bills.length];
                    for (int i = 0; i < bills.length; ++i) {
                        IObjectPK pk;
                        logPks[i] = pk = LogUtil.beginLog((Context)this.ctx, (String)"_inStockBackFlush", (BOSObjectType)new BOSObjectType("FA1292B4"), (IObjectPK)new ObjectUuidPK(bills[i]), (String)numbers[i], (String)"mm_sfc_backflushmanufacturerecbill");
                    }
                    returnMap = MOMaterialBackFlush.backFlush(this.ctx, bills, billType, false);
                    if (returnMap != null && returnMap.size() > 0) {
                        StringBuffer sb = new StringBuffer();
                        try {
                            sb.append("" + returnMap.get("12345678"));
                            throw new ManufactureOrderException(ManufactureOrderException.BACKFLUSH_INSTOCK_ERROR_CHECK, new String[]{sb.toString()});
                        }
                        catch (Exception e) {
                            throw new ManufactureOrderException(ManufactureOrderException.BACKFLUSH_INSTOCK_ERROR_CHECK, new String[]{sb.toString()});
                        }
                    }
                    for (IObjectPK pk : logPks) {
                        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pk);
                    }
                }
            } else {
                this.ctx.put((Object)"isAutoFlushFromMRB", (Object)Boolean.TRUE);
                moBiz.materialUnBackFlush(billIDs);
            }
        }
        if (this.isAuditAction()) {
            MOAutoCloseUtil.autoCloseFromMRBByMO(this.ctx, this.sourceDataTable, false);
        }
        super.afterExecute();
    }

    private void calcStockQty(Context ctx, String tempTableName) throws BOSException, EASBizException {
        BackFlushHandler backFlushHandler = new BackFlushHandler(ctx, this.isAuditAction);
        backFlushHandler.toStoreBackFlush(tempTableName);
    }

    public boolean checkMOClose() throws BOSException, EASBizException {
        boolean isMOclose = false;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(this.sourceDataTable).append(" s,  ").append(" T_IM_ManufactureRecBill t ").append(" where s.fSourceBillID = mo.fid  and  mo.fBaseStatus in (6,7,11)  and t.fid = s.fbillid ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                isMOclose = true;
                String billID = rs.getString("fnumber");
                errMap.put(billID, "1");
                ++i;
            }
            if (isMOclose) {
                throw new ManufactureOrderException(ManufactureOrderException.MO_CLOSED, errMap.keySet().toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isMOclose;
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.billIds = billIds;
        this.billTypeID = billTypeId;
        String tableName = BillUpdaterFactory.createTempTable((Context)ctx);
        this.setReleaseTempTable(true);
        this.setSourceDataTable(tableName);
        this.setAuditAction(bizAction == 103);
        super.execute();
    }
}

