/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class MOSubsition {
    public static Map allocateReplaceMaterialQty(Context ctx, String tempTableName, boolean isAudit) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.setLength(0);
        sqlBuf.append("select a.FParentId,a.FID,a.FReplaceGroupFlag,t.FProductQty,").append("a.FUnitQty,a.FPlannedQty,a.FToStoreQty,b.FQtyPrecision ").append("from T_MM_MFTOrderStock a,").append("(select sum(round(decimal(t11.FBaseQty/b1.FBaseConvsRate,21,8),b1.FQtyPrecision)) as FProductQty,t11.FSourceBillId ").append("from ").append(tempTableName).append(" t11,").append("T_MM_ManufactureOrder t12, ").append("t_bd_multimeasureunit  b1 ").append("where t12.FMaterialID = b1.FMaterialID and t12.FUnitID = b1.fmeasureunitid ").append("and t12.fid = t11.FSourceBillId ").append("group by t11.FSourceBillId").append(") t,").append("t_bd_multimeasureunit  b ").append("where a.FMaterialID = b.FMaterialID and a.FUnitID = b.fmeasureunitid ").append("and a.FParentId = t.FSourceBillId ").append("and a.FReplaceGroupFlag > 0 ").append("order by t.FSourceBillId,a.FReplacePriority ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        if (rs != null && rs.size() > 0) {
            try {
                String billID = null;
                String entryID = null;
                BigDecimal productQty = null;
                BigDecimal unitQty = null;
                BigDecimal plannedQty = null;
                BigDecimal toStoredQTy = null;
                int groupFlag = 0;
                while (rs != null && rs.next()) {
                    BigDecimal willToStoreQty;
                    if (billID == null || rs.getString("FParentId").equals(billID) || rs.getInt("FReplaceGroupFlag") != groupFlag) {
                        billID = rs.getString("FParentId");
                        productQty = rs.getBigDecimal("FProductQty");
                        groupFlag = rs.getInt("FReplaceGroupFlag");
                    }
                    plannedQty = rs.getBigDecimal("FPlannedQty");
                    toStoredQTy = rs.getBigDecimal("FToStoreQty");
                    if (null == productQty || productQty.compareTo(SysConstant.BIGZERO) <= 0 || plannedQty.compareTo(SysConstant.BIGZERO) <= 0 || plannedQty.compareTo(toStoredQTy) <= 0) continue;
                    entryID = rs.getString("FID");
                    unitQty = rs.getBigDecimal("FUnitQty");
                    int prec = rs.getInt("FQtyPrecision");
                    BigDecimal actAllocateQty = willToStoreQty = productQty.multiply(unitQty).setScale(prec, 4);
                    if (isAudit) {
                        BigDecimal leaveToStoreQty = plannedQty.subtract(toStoredQTy);
                        if (leaveToStoreQty.compareTo(willToStoreQty) < 0) {
                            actAllocateQty = leaveToStoreQty;
                        }
                        if (actAllocateQty.compareTo(SysConstant.BIGZERO) < 0) {
                            actAllocateQty = SysConstant.BIGZERO;
                        }
                    } else {
                        if (actAllocateQty.compareTo(toStoredQTy) > 0) {
                            actAllocateQty = toStoredQTy;
                        }
                        if (actAllocateQty.compareTo(SysConstant.BIGZERO) < 0) {
                            actAllocateQty = SysConstant.BIGZERO;
                        }
                    }
                    map.put(entryID, actAllocateQty);
                    BigDecimal repQty = actAllocateQty.divide(unitQty, 8, 4);
                    productQty = productQty.subtract(repQty);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return map;
    }
}

