/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.mo.MOWriteBackInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MOWriteBackByTransferOrder
extends BillUpdater
implements MMExternalProcessor {
    private String billTypeID = null;
    private String[] billIds = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String TRANSFER_ORDER_BILL_BOSTYPE = "5C2A1F0C";
    private static final String SALES_ISSUE_BILL = "CC3E933B";
    private static final String MANUFACTURE_ORDER_BOSTYPE = "1D0D80DD";

    public MOWriteBackByTransferOrder() {
    }

    public MOWriteBackByTransferOrder(Context ctx) {
        super(ctx);
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        this.insertTempTableData();
        boolean ret = false;
        this.setTargetTable("T_MM_MFTOrderStock");
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        this.setBaseQtyFields(new String[]{"FTotalReceiptBaseQty", "FunReceiptBaseQty"});
        this.setQtyFields(new String[]{"FTotalReceiptQty", "FUnReceiptQty"});
        this.setUnBaseQtyExpression("FunReceiptBaseQty");
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+", "-"});
            this.setQtyOperation(new String[]{"+", "-"});
        } else {
            this.setBaseQtyOperation(new String[]{"-", "+"});
            this.setQtyOperation(new String[]{"-", "+"});
        }
        ret = true;
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        this.setThrowExcpetion((EASBizException)((Object)new MMCommonException(MMCommonException.REWRITEQTY_GT_UNRECEIPTQTY)));
        return ret;
    }

    private void insertTempTableData() throws BOSException {
        StringBuffer idStrs = new StringBuffer();
        for (int i = 0; i < this.billIds.length; ++i) {
            idStrs.append("'" + this.billIds[i] + "', ");
        }
        String idStr = idStrs.toString().trim().substring(0, idStrs.toString().trim().length() - 1);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(this.sourceDataTable).append(" (FBillID,FBillEntryID,FSourceBillID,FSourceBillEntryId,FBaseQty,FQty) ").append("   SELECT DISTINCT s.fid, e.fid,s.fsourcebillid,e.fsourcebillentryid,mbe.fbaseqty,mbe.fqty ").append("  FROM t_im_transferorderbill  S  ").append("  INNER JOIN t_im_transferorderbillentry e ON e.fparentid =s.fid ").append("  INNER JOIN t_im_purinwarehsentry mbe ON mbe.fsourcebillentryid = e.fid ").append("  INNER JOIN T_IM_PurInWarehsBill r ON mbe.fparentid = r.fid ").append("  WHERE s.FSOURCEBILLTYPEID='B2aZSVXaSx6qxdfekgCmrEY+1VI='").append("  and r.fid IN (" + idStr + ") ").append("  UNION ALL ").append("   SELECT DISTINCT s.fid, e.fid,s.fsourcebillid,e.fsourcebillentryid,mbe.fbaseqty,mbe.fqty ").append("  FROM t_im_transferorderbill  S  ").append("  INNER JOIN t_im_transferorderbillentry e ON e.fparentid =s.fid ").append("  INNER JOIN T_IM_SaleIssueEntry k ON k.fsourcebillentryid =e.fid ").append("  INNER JOIN t_im_purinwarehsentry mbe ON mbe.fsourcebillentryid = k.fid ").append("  INNER JOIN T_IM_PurInWarehsBill r ON mbe.fparentid = r.fid ").append("  WHERE s.FSOURCEBILLTYPEID='B2aZSVXaSx6qxdfekgCmrEY+1VI='").append("  and r.fid IN (" + idStr + ") ");
        DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
    }

    protected void afterExecute() throws BOSException, EASBizException {
        super.afterExecute();
    }

    public void execute1() throws BOSException, EASBizException {
        boolean isContinue = this.beforeExecute();
        String countSQL = "SELECT COUNT(*) as num FROM " + this.sourceDataTable;
        IRowSet countRs = DbUtil.executeQuery((Context)this.ctx, (String)countSQL);
        try {
            while (countRs.next()) {
                int num = countRs.getInt("num");
                if (num > 0) continue;
                this.afterExecute();
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean flag = true;
        String sql = "SELECT COUNT(*) as num FROM " + this.sourceDataTable + " WHERE fsourcebillid IS NULL";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            while (rs.next()) {
                int num = rs.getInt("num");
                if (num <= 0) continue;
                flag = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (flag && isContinue) {
            if (this.isAuditAction && !this.qtyCheck()) {
                throw this.throwExcpetion != null ? this.throwExcpetion : new MMCommonException(MMCommonException.REWRITEQTY_GT_UNQTY);
            }
            super.writeBack();
            this.afterExecute();
        } else {
            String idSQL = "SELECT * FROM " + this.sourceDataTable + " WHERE fsourcebillid IS NULL";
            String delSQL = "DELETE FROM " + this.sourceDataTable + " WHERE fsourcebillid IS NULL";
            IRowSet idRs = DbUtil.executeQuery((Context)this.ctx, (String)idSQL);
            HashMap<String, Set<MOWriteBackInfo>> destBillMap = new HashMap<String, Set<MOWriteBackInfo>>();
            try {
                while (idRs.next()) {
                    Set<MOWriteBackInfo> entryIdSet;
                    MOWriteBackInfo writeBakckInfo = new MOWriteBackInfo();
                    String billId = idRs.getString("FBillId");
                    writeBakckInfo.setBillId(billId);
                    writeBakckInfo.setBillEntryId(idRs.getString("FBillEntryId"));
                    writeBakckInfo.setBaseQty(idRs.getBigDecimal("FBaseQty"));
                    writeBakckInfo.setQty(idRs.getBigDecimal("FQty"));
                    if (destBillMap.containsKey(billId)) {
                        entryIdSet = (Set)destBillMap.get(billId);
                        entryIdSet.add(writeBakckInfo);
                        continue;
                    }
                    entryIdSet = new HashSet();
                    destBillMap.put(billId, entryIdSet);
                    entryIdSet.add(writeBakckInfo);
                }
                DbUtil.execute((Context)this.ctx, (String)delSQL);
                if (isContinue) {
                    IRowSet numRs = DbUtil.executeQuery((Context)this.ctx, (String)countSQL);
                    while (numRs.next()) {
                        int num = numRs.getInt("num");
                        if (num <= 0) continue;
                        flag = true;
                    }
                    if (flag) {
                        if (this.isAuditAction && !this.qtyCheck()) {
                            throw this.throwExcpetion != null ? this.throwExcpetion : new MMCommonException(MMCommonException.REWRITEQTY_GT_UNQTY);
                        }
                        super.writeBack();
                    }
                }
                this.collectWriteBack(destBillMap);
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            this.afterExecute();
        }
    }

    private void collectWriteBack(Map destBillMap) throws BOSException, SQLException, EASBizException {
        IMeasureUnit measureUnit = MeasureUnitFactory.getLocalInstance((Context)this.ctx);
        if (destBillMap == null) {
            return;
        }
        Set entrySet = destBillMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Set moWriteBackInfoSet = (Set)entry.getValue();
            for (MOWriteBackInfo moWriteBackInfo : moWriteBackInfoSet) {
                String billEntryId = moWriteBackInfo.getBillEntryId();
                BigDecimal baseQty = moWriteBackInfo.getBaseQty();
                BigDecimal qty = moWriteBackInfo.getQty();
                if (billEntryId == null) {
                    return;
                }
                String orderFlag = "";
                if (!this.isAuditAction) {
                    orderFlag = orderFlag + " DESC";
                }
                StringBuffer selectSQLBuffer = new StringBuffer();
                selectSQLBuffer.append("SELECT distinct s.fid as stockId,s.fplannedqty as stockQty,s.fplannedbaseqty stockBaseQty,");
                selectSQLBuffer.append("       s.ftotalreceiptqty, ");
                selectSQLBuffer.append("       s.ftotalreceiptbaseqty, ");
                selectSQLBuffer.append("       s.funreceiptqty, ");
                selectSQLBuffer.append("       s.funreceiptbaseqty, ");
                selectSQLBuffer.append("       s.fqty,");
                selectSQLBuffer.append("       s.funitid, ");
                selectSQLBuffer.append("       s.fbaseunitid,");
                selectSQLBuffer.append("       s.fmaterialid,");
                selectSQLBuffer.append("       o.fnumber ");
                selectSQLBuffer.append("  FROM t_bot_relationentry entry ");
                selectSQLBuffer.append(" INNER JOIN t_bot_relation r ON r.fsrcobjectid = entry.fsrcobjectid ");
                selectSQLBuffer.append(" INNER JOIN t_mm_manufactureorder o ON o.fid = entry.fsrcobjectid ");
                selectSQLBuffer.append(" INNER JOIN t_mm_mftorderstock s ON s.fid = entry.fsrcentryid WHERE ");
                selectSQLBuffer.append(" 1 = 1  AND entry.fdestentryid = '" + billEntryId + "' ");
                selectSQLBuffer.append("  AND r.fsrcentityid = '1D0D80DD' ");
                selectSQLBuffer.append("  AND r.fdestentityid = '5C2A1F0C' ");
                selectSQLBuffer.append(" ORDER BY o.fnumber " + orderFlag);
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)selectSQLBuffer.toString());
                int i = rowSet.size();
                int j = 0;
                BigDecimal baseSubstract = baseQty;
                while (rowSet.next()) {
                    BigDecimal tempSubBasQty;
                    BigDecimal tempSubQty;
                    String stockId = rowSet.getString("stockId");
                    String materialId = rowSet.getString("fmaterialid");
                    String unitId = rowSet.getString("funitid");
                    MeasureUnitInfo unitInfo = measureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitId)));
                    String baseUnitId = rowSet.getString("fbaseunitid");
                    MeasureUnitInfo baseUnitInfo = measureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)baseUnitId)));
                    BigDecimal totalreceiptqty = rowSet.getBigDecimal("ftotalreceiptqty");
                    BigDecimal totalreceiptbaseqty = rowSet.getBigDecimal("ftotalreceiptbaseqty");
                    BigDecimal unreceiptqty = rowSet.getBigDecimal("funreceiptqty");
                    BigDecimal unreceiptbaseqty = rowSet.getBigDecimal("funreceiptbaseqty");
                    BigDecimal stockQty = rowSet.getBigDecimal("stockQty");
                    BigDecimal stockBaseQty = rowSet.getBigDecimal("stockBaseQty");
                    BigDecimal resultUnreceiptqty = ZERO;
                    BigDecimal resultUnreceiptbaseqty = ZERO;
                    if (this.isAuditAction) {
                        if (j == i - 1) {
                            totalreceiptqty = totalreceiptqty.add(SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract));
                            totalreceiptbaseqty = totalreceiptbaseqty.add(baseSubstract);
                        } else {
                            tempSubQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract).subtract(unreceiptqty);
                            tempSubBasQty = baseSubstract.subtract(unreceiptbaseqty);
                            if (tempSubQty.compareTo(ZERO) >= 0) {
                                totalreceiptqty = totalreceiptqty.add(unreceiptqty);
                                totalreceiptbaseqty = totalreceiptbaseqty.add(unreceiptbaseqty);
                            } else {
                                totalreceiptqty = totalreceiptqty.add(SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract));
                                totalreceiptbaseqty = totalreceiptbaseqty.add(baseSubstract);
                            }
                            baseSubstract = tempSubBasQty.compareTo(ZERO) >= 0 ? tempSubBasQty : ZERO;
                        }
                        resultUnreceiptqty = stockQty.subtract(totalreceiptqty);
                        resultUnreceiptbaseqty = stockBaseQty.subtract(totalreceiptbaseqty);
                    } else {
                        tempSubQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract).subtract(totalreceiptqty);
                        tempSubBasQty = baseSubstract.subtract(totalreceiptbaseqty);
                        if (tempSubQty.compareTo(ZERO) >= 0) {
                            totalreceiptqty = ZERO;
                            totalreceiptbaseqty = ZERO;
                        } else {
                            totalreceiptqty = totalreceiptqty.subtract(SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract));
                            totalreceiptbaseqty = totalreceiptbaseqty.subtract(baseSubstract);
                        }
                        baseSubstract = tempSubBasQty.compareTo(ZERO) >= 0 ? tempSubBasQty : ZERO;
                        resultUnreceiptqty = stockQty.subtract(totalreceiptqty);
                        resultUnreceiptbaseqty = stockBaseQty.subtract(totalreceiptbaseqty);
                    }
                    StringBuffer updateSQLBuffer = new StringBuffer();
                    updateSQLBuffer.append("update t_mm_mftorderstock set ftotalreceiptqty=" + totalreceiptqty + ", ");
                    updateSQLBuffer.append("       ftotalreceiptbaseqty=" + totalreceiptbaseqty + ", ");
                    updateSQLBuffer.append("       funreceiptqty=" + (resultUnreceiptqty.compareTo(ZERO) > 0 ? resultUnreceiptqty : ZERO) + ", ");
                    updateSQLBuffer.append("       funreceiptbaseqty=" + (resultUnreceiptbaseqty.compareTo(ZERO) > 0 ? resultUnreceiptbaseqty : ZERO));
                    updateSQLBuffer.append(" \t\twhere fid='" + stockId + "'");
                    DbUtil.execute((Context)this.ctx, (String)updateSQLBuffer.toString());
                    ++j;
                }
            }
        }
        this.afterExecute();
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        if (!"50957179-0105-1000-e000-015fc0a812fd463ED552".equalsIgnoreCase(billTypeId)) {
            return;
        }
        this.ctx = ctx;
        this.setBillTypeID(billTypeId);
        this.setSourceDataTable(BillUpdaterFactory.createTempTable((Context)ctx));
        this.setBillIds(billIds);
        this.setAuditAction(bizAction == 103);
        this.execute1();
    }

    public String getBillTypeID() {
        return this.billTypeID;
    }

    public void setBillTypeID(String billTypeID) {
        this.billTypeID = billTypeID;
    }

    public String[] getBillIds() {
        return this.billIds;
    }

    public void setBillIds(String[] billIds) {
        this.billIds = billIds;
    }
}

