/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.IFactoryCalendar;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.common.app.CodingRulerSrvHelper;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.lot.LotParamValueFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.IManufactureOrderChildGenerateFacade;
import com.kingdee.eas.mm.mo.MOBirthTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderChildGenerateFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.AbstractManufactureOrderChildGenerateFacadeControllerBean;
import com.kingdee.eas.mm.mo.app.ManufactureOrderControllerBean;
import com.kingdee.eas.mm.mo.util.MOProductTransactionTypeUtil;
import com.kingdee.eas.mm.mo.util.MORootingUtil;
import com.kingdee.eas.mm.mo.util.MOUntil;
import com.kingdee.eas.mm.mo.util.calculateDateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ManufactureOrderChildGenerateFacadeControllerBean
extends AbstractManufactureOrderChildGenerateFacadeControllerBean {
    private static final long serialVersionUID = 3922016853887585005L;
    private static final String BOSTYPE_ORDER = "1D0D80DD";
    private static final int MaxExtendLevel = 50;

    @Override
    protected String _childGenerate(Context ctx, IObjectPK parentMOPK, Integer expandLevel, StorageOrgUnitInfo storageOrgUnitInfo, boolean isOnlyCurrDepart) throws BOSException, EASBizException {
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        Timestamp serverDate = iSCMBillCommonFacade.getServerDate();
        CodingRulerSrvHelper codeHelper = new CodingRulerSrvHelper();
        codeHelper.setBizOrgPropertyName("storageOrgUnit");
        codeHelper.setNumberException((EASBizException)new ManufactureOrderException(ManufactureOrderException.MO_NO_CODING));
        if (storageOrgUnitInfo == null) {
            return ManufactureOrderChildGenerateFacadeControllerBean.getResource(ctx, "no_addnew_permission");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("transactionType.*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("trackNumber.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("scheduleType.*"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("dispatcher.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("expectOutputs.*"));
        ManufactureOrderInfo topInfo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo(parentMOPK, sic);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"childGenerate", (BOSObjectType)this.getBOSType(), (IObjectPK)parentMOPK, (String)topInfo.getNumber(), (String)"mm_manufactureOrder_childGenerate");
        boolean isReturnedProduct = ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(topInfo.getBizType()) ? false : topInfo.getBizType().getId().toString().equals("yRPu9BAfSRuIIEu9QnyxviQHQ1w=");
        boolean isRefurbishProduct = ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(topInfo.getBizType()) ? false : topInfo.getBizType().getId().toString().equals("PF40lAXWJXTgU6hCqMCewyQHQ1w=");
        boolean isReturnOrRefurbish = false;
        isReturnOrRefurbish = isReturnedProduct || isRefurbishProduct;
        ArrayList subs = new ArrayList();
        this.moRecursiveExtend(subs, ctx, topInfo, codeHelper, serverDate, isReturnOrRefurbish, isOnlyCurrDepart);
        if (subs.size() > 0) {
            this._checkAndRemoveChildMO(ctx, parentMOPK, true);
            IManufactureOrder moInstance = ManufactureOrderFactory.getLocalInstance(ctx);
            Iterator it = subs.iterator();
            BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[subs.size()];
            BatchExecuteParamsEntry entry = null;
            int i = 0;
            while (it.hasNext()) {
                ManufactureOrderInfo order = (ManufactureOrderInfo)it.next();
                order.setDeliveryQty(this.getDeliveryQty(order.getQty(), order.getYield()));
                moInstance.addnew((IObjectPK)new ObjectUuidPK(order.getId()), (CoreBaseInfo)order);
                entries[i] = entry = new BatchExecuteParamsEntry(new Class[]{ManufactureOrderInfo.class}, new Object[]{order});
                ++i;
            }
            IManufactureOrderChildGenerateFacade moChildGenFacade = ManufactureOrderChildGenerateFacadeFactory.getLocalInstance(ctx);
            if (moChildGenFacade.isChildOrderMustSubmit()) {
                ManufactureOrderControllerBean moBean = new ManufactureOrderControllerBean();
                moBean.batchSubmit(ctx, entries);
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            return "";
        }
        return ManufactureOrderChildGenerateFacadeControllerBean.getResource(ctx, "MO_bottom_noChildGenerate");
    }

    private void moRecursiveExtend(ArrayList subs, Context ctx, ManufactureOrderInfo parentMoInfo, CodingRulerSrvHelper codeHelper, Date serverDate, boolean isReturnOrRefurbish, boolean isOnlyCurrDepart) throws EASBizException, BOSException {
        String longNumber = parentMoInfo.getLongNumber();
        if (longNumber == null) {
            return;
        }
        if (longNumber.split("!").length > 50) {
            throw new BomException(BomException.CYCLE);
        }
        ManufactureOrderInfo[] tempMoAry = this.getDirectChildrenMOs(ctx, parentMoInfo, codeHelper, serverDate, isReturnOrRefurbish, isOnlyCurrDepart);
        for (int i = 0; i < tempMoAry.length; ++i) {
            subs.add(tempMoAry[i]);
            this.moRecursiveExtend(subs, ctx, tempMoAry[i], codeHelper, serverDate, isReturnOrRefurbish, isOnlyCurrDepart);
        }
    }

    private ManufactureOrderInfo[] getDirectChildrenMOs(Context ctx, ManufactureOrderInfo parentMoInfo, CodingRulerSrvHelper codeHelper, Date serverDate, boolean isReturnOrRefurbish, boolean isOnlyCurrDepart) throws EASBizException, BOSException {
        ArrayList<ManufactureOrderInfo> subs = new ArrayList<ManufactureOrderInfo>();
        ManufactureOrderStockCollection parentStocks = parentMoInfo.getStocks();
        for (int i = 0; i < parentStocks.size(); ++i) {
            AdminOrgUnitInfo paou;
            BigDecimal plannedQty;
            ManufactureOrderStockInfo parentStockInfo = parentStocks.get(i);
            MaterialInfo material = parentStockInfo.getMaterial();
            BigDecimal bigDecimal = plannedQty = parentStockInfo.getPlannedQty() == null ? SysConstant.BIGZERO : parentStockInfo.getPlannedQty();
            if (ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(material) || plannedQty.compareTo(SysConstant.BIGZERO) <= 0) continue;
            StorageOrgUnitInfo storageOrgUnitInfo = parentMoInfo.getStorageOrgUnit();
            MaterialPlanInfo materialPlan = ManufactureOrderChildGenerateFacadeControllerBean.getMaterialPlanInfo(ctx, material, storageOrgUnitInfo);
            material = materialPlan.getMaterial();
            BomInfo bom = BOMExtend2FacadeFactory.getLocalInstance((Context)ctx).getBomByTrcAndPrjID(material.getId().toString(), parentMoInfo.getProject() == null ? null : parentMoInfo.getProject().getId().toString(), parentMoInfo.getTrackNumber() == null ? null : parentMoInfo.getTrackNumber().getId().toString(), storageOrgUnitInfo.getId().toString());
            if (bom == null || !materialPlan.getMaterialAttr().equals((Object)MaterialAttributeEnum.FABRICATEDPART) || isReturnOrRefurbish && material.getId().equals((Object)parentMoInfo.getMaterial().getId())) continue;
            AdminOrgUnitInfo childAdminOrg = null;
            if (parentMoInfo.getBomID() != null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add(new SelectorItemInfo("material.id"));
                coll.add(new SelectorItemInfo("parent.id"));
                coll.add(new SelectorItemInfo("usedUnit.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentMoInfo.getBomID().toString(), CompareType.EQUALS));
                view.setFilter(filter);
                view.setSelector(coll);
                BomEntryCollection bomEntry = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryCollection(view);
                if (bomEntry != null && bomEntry.size() > 0) {
                    childAdminOrg = bomEntry.get(0).getUsedUnit();
                }
            }
            if (childAdminOrg == null) {
                childAdminOrg = materialPlan.getDutyDepartment();
            }
            if (isOnlyCurrDepart && (ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(paou = parentMoInfo.getAdminOrgUnit()) || ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(childAdminOrg) || !paou.getId().equals((Object)childAdminOrg.getId()))) continue;
            ManufactureOrderInfo childData = ManufactureOrderFactory.getLocalInstance(ctx).createNewMO(false, storageOrgUnitInfo);
            childData.setCU(parentMoInfo.getCU());
            childData.setId(BOSUuid.create((String)BOSTYPE_ORDER));
            childData.setBirthType(MOBirthTypeEnum.EXPAND);
            childData.setLongNumber(parentMoInfo.getLongNumber() + "!" + childData.getId().toString());
            childData.setStorageOrgUnit(storageOrgUnitInfo);
            childData.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            childData.setBizDate(serverDate);
            childData.setRelatingOrderNum(parentMoInfo.getRelatingOrderNum());
            ProductTransactionTypeInfo transType = null;
            if (parentMoInfo == null || parentMoInfo.getBizType() == null) {
                throw new ManufactureOrderException(ManufactureOrderException.NO_TRANINFO);
            }
            transType = MOProductTransactionTypeUtil.getDefaultTransType(ctx, material, materialPlan, storageOrgUnitInfo, childAdminOrg, "vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=");
            if (ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(transType)) continue;
            childData.setTransactionType(transType);
            childData.setBizType(transType.getBizType());
            childData.setMaterial(material);
            codeHelper.checkNumber(ctx, (ICoreBase)ManufactureOrderFactory.getLocalInstance(ctx), (IObjectValue)childData, (OrgUnitInfo)childData.getStorageOrgUnit());
            childData.setQty(parentStockInfo.getPlannedQty());
            childData.setBaseQty(parentStockInfo.getPlannedBaseQty());
            childData.setTotalSplitQty(SysConstant.BIGZERO);
            childData.setTotalSplitBaseQty(SysConstant.BIGZERO);
            childData.setUnRepairQty(childData.getQty());
            childData.setUnRepairBaseQty(childData.getBaseQty());
            childData.setUnit(materialPlan.getProductUnit());
            childData.setBaseUnit(material.getBaseUnit());
            IFactoryCalendar calendarFactory = FactoryCalendarFactory.getLocalInstance((Context)ctx);
            childData.setPlanEndDate(this.getEarlistWoktime(parentMoInfo, material, materialPlan, calendarFactory));
            calculateDateUtil util = new calculateDateUtil();
            Calendar calDate = Calendar.getInstance();
            calDate.set(11, 0);
            calDate.set(12, 0);
            calDate.set(13, 0);
            calDate.set(14, 0);
            Date nowDate = new Date(calDate.getTimeInMillis());
            if (childData.getPlanEndDate().before(nowDate)) {
                childData.setPlanBeginDate(this.setWorkDate(calendarFactory, childData.getStorageOrgUnit().getId().toString(), nowDate, false));
                childData.setPlanEndDate(this.setWorkDate(calendarFactory, childData.getStorageOrgUnit().getId().toString(), nowDate, false));
            } else {
                Date startDate = util.getDate(ctx, storageOrgUnitInfo.getId().toString(), material.getId().toString(), null, childData.getPlanEndDate(), false, childData.getQty().subtract(childData.getTotalSplitQty()));
                childData.setPlanBeginDate(new Timestamp(startDate.getTime()));
            }
            childData.setActureBeginDate(null);
            childData.setActureEndDate(null);
            childData.setProject(parentMoInfo.getProject());
            childData.setTrackNumber(parentMoInfo.getTrackNumber());
            childData.setBomID(bom.getId().toString());
            childData.setBomNum(bom.getNumber());
            this.getDefaultRouting(ctx, childData);
            childData.setScheduleType(parentMoInfo.getScheduleType());
            childData.setAdminOrgUnit(childAdminOrg);
            childData.setPlanOrgUnit(materialPlan.getPlanOrg());
            childData.setDispatcher(materialPlan.getPlanner());
            childData.setSourceBillType(parentMoInfo.getBillType());
            childData.setSourceBillId(parentMoInfo.getId().toString());
            childData.setSrcBillNum(parentMoInfo.getNumber());
            childData.setSourceBillType(parentMoInfo.getBillType());
            childData.setYield(bom.getYield());
            childData.setExtraRatio(materialPlan.getRcvInHightLimit() != null ? materialPlan.getRcvInHightLimit() : SysConstant.BIGZERO);
            childData.setLackRatio(materialPlan.getRcvInLowLimit() != null ? materialPlan.getRcvInLowLimit() : SysConstant.BIGZERO);
            if (transType != null && transType.isIsWPManagement() || !materialPlan.isIsStorageLimit()) {
                childData.setIsLimitedQty(false);
            } else {
                childData.setIsLimitedQty(true);
            }
            if (childData.getExtraRatio() != null) {
                childData.setExtraUpperLimit(this.calcLimitUpperQty(childData.getExtraRatio(), childData.getQty(), 8));
            }
            if (childData.getLackRatio() != null) {
                childData.setLackLowerLimit(this.calcLimitLowerQty(childData.getLackRatio(), childData.getQty(), 8));
            }
            childData.setConcessionQty(SysConstant.BIGZERO);
            childData.setConcessionBaseQty(SysConstant.BIGZERO);
            if (materialPlan.getIssMode() != null && materialPlan.getIssMode().getValue() == 11050) {
                childData.setIsDirectSend(true);
            } else {
                childData.setIsDirectSend(false);
            }
            this.updateLotNumberAndWarehous(ctx, childData);
            childData.setCostObject(null);
            HashMap<String, Object> inParam = new HashMap<String, Object>();
            inParam.put("ROUTINGID", ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(childData.getRouting()) ? null : childData.getRouting().getId().toString());
            inParam.put("STORAGEORG", childData.getStorageOrgUnit());
            inParam.put("BEGINTIME", childData.getPlanBeginDate());
            inParam.put("ENDTIME", childData.getPlanEndDate());
            inParam.put("BASEUNIT", childData.getBaseUnit());
            inParam.put("BILL_UNIT", childData.getUnit());
            inParam.put("BILL_QTY", childData.getQty());
            inParam.put("SPLIT_QTY", childData.getTotalSplitQty());
            inParam.put("TRANSTYPE", childData.getTransactionType());
            inParam.put("MATERIAL", childData.getMaterial());
            BomInfo childBom = null;
            if (childData.getBomID() != null) {
                childBom = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectStringPK(childData.getBomID()));
            }
            inParam.put("BOM", childBom);
            inParam.put("projectID", ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(childData.getProject()) ? null : childData.getProject());
            inParam.put("trackID", ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(childData.getTrackNumber()) ? null : childData.getTrackNumber());
            inParam.put("adminOrgUnit", childData.getAdminOrgUnit());
            inParam.put("LOTNUMBER", childData.getLot());
            this.buildRouting(ctx, inParam, childData);
            this.buildStocks(ctx, inParam, childData);
            this.buildExpectOutput(ctx, inParam, childData);
            subs.add(childData);
        }
        return subs.toArray(new ManufactureOrderInfo[subs.size()]);
    }

    private Timestamp setWorkDate(IFactoryCalendar workCalendarFactory, String orgID, Date date, boolean isForward) throws BOSException, EASBizException {
        int direct = 1;
        int daycount = 1;
        if (!isForward) {
            direct = 2;
            daycount = 0;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        Date workDate = workCalendarFactory.findDateFromFCalendar(orgID, date, direct, daycount, 2);
        if (workDate != null) {
            calendar2.setTime(workDate);
        } else {
            calendar2.setTime(date);
        }
        calendar2.set(10, calendar1.get(10));
        calendar2.set(12, calendar1.get(12));
        calendar2.set(13, calendar1.get(13));
        return new Timestamp(calendar2.getTimeInMillis());
    }

    private static MaterialPlanInfo getMaterialPlanInfo(Context ctx, MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.*"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.id"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.number"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.name"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.id"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.number"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.name"));
        selectorItemCollection.add(new SelectorItemInfo("planner.id"));
        selectorItemCollection.add(new SelectorItemInfo("planner.number"));
        selectorItemCollection.add(new SelectorItemInfo("planner.name"));
        selectorItemCollection.add(new SelectorItemInfo("material.*"));
        selectorItemCollection.add(new SelectorItemInfo("material.baseUnit.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(0);
            return materialPlanInfo;
        }
        return null;
    }

    private Timestamp getEarlistWoktime(ManufactureOrderInfo parentmo, MaterialInfo material, MaterialPlanInfo materialPlan, IFactoryCalendar calendarFactory) throws EASBizException, BOSException {
        Timestamp earlistWoktime = parentmo.getPlanBeginDate();
        ManufactureOrderStockCollection stocks = parentmo.getStocks();
        String strMaterialId = material.getId().toString();
        int operationNo = -1;
        for (int i = 0; i < stocks.size(); ++i) {
            ManufactureOrderStockInfo stockInfo = stocks.get(i);
            operationNo = stockInfo.getOperationNo();
            if (strMaterialId.equals(stockInfo.getMaterial().getId().toString())) break;
        }
        ManufactureOrderTechnicsCollection technics = parentmo.getTechnics();
        MMCommonUtils.objectValueSort((IObjectCollection)technics, (boolean)true, (String)"earlistWoktime");
        for (int i = 0; i < technics.size(); ++i) {
            ManufactureOrderTechnicsInfo technicsInfo = technics.get(i);
            earlistWoktime = technicsInfo.getEarlistWoktime();
            if (operationNo == technicsInfo.getOperationNo()) break;
        }
        return this.setWorkDate(calendarFactory, parentmo.getStorageOrgUnit().getId().toString(), (Date)earlistWoktime, materialPlan.getRecevingLeadTime());
    }

    private Timestamp setWorkDate(IFactoryCalendar workCalendarFactory, String orgID, Date date, int daycount) throws BOSException, EASBizException {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        Date workDate = workCalendarFactory.findDateFromFCalendar(orgID, date, 2, daycount, 2);
        if (workDate != null) {
            calendar2.setTime(workDate);
        } else {
            calendar2.setTime(date);
        }
        calendar2.set(10, calendar1.get(10));
        calendar2.set(12, calendar1.get(12));
        calendar2.set(13, calendar1.get(13));
        return new Timestamp(calendar2.getTimeInMillis());
    }

    private void buildRouting(Context ctx, Map inParam, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        ManufactureOrderTechnicsCollection technicsCol = null;
        MOUntil.getDefaultRouting(ctx, mo.getMaterial().getId().toString(), mo.getStorageOrgUnit().getId().toString(), mo.getTransactionType(), inParam, null);
        Object routingId = inParam.get("ROUTINGID");
        if (routingId != null) {
            StandardRootingInfo rooting = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectStringPK((String)routingId));
            mo.setRouting(rooting);
        }
        if ((technicsCol = ManufactureOrderFactory.getLocalInstance(ctx).routingExpand(inParam)) != null && technicsCol.size() > 0) {
            int[] operaNoAry = new int[technicsCol.size()];
            for (int i = 0; i < technicsCol.size(); ++i) {
                ManufactureOrderTechnicsInfo technicsInfo = technicsCol.get(i);
                operaNoAry[i] = technicsInfo.getOperationNo();
                technicsInfo.setUnDispatchQty(technicsInfo.getQty().subtract(technicsInfo.getTotalDispatchQty()).subtract(technicsInfo.getTotalSplitQty()));
            }
            Arrays.sort(operaNoAry);
            mo.setLastOperNo(operaNoAry[operaNoAry.length - 1]);
            mo.setFirstOperNo(operaNoAry[0]);
        }
        mo.put("technics", (Object)(technicsCol == null ? new ManufactureOrderTechnicsCollection() : technicsCol));
        mo.put("PBOMID", inParam.get("PBOMID"));
    }

    private void buildStocks(Context ctx, Map inParam, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        ManufactureOrderStockCollection stocksCol = null;
        if (inParam.get("BOM") != null) {
            stocksCol = ManufactureOrderFactory.getLocalInstance(ctx).bomExpand(inParam);
        }
        mo.put("stocks", (Object)(stocksCol == null ? new ManufactureOrderStockCollection() : stocksCol));
    }

    private void buildExpectOutput(Context ctx, Map inParam, ManufactureOrderInfo mo) throws EASBizException, BOSException {
        Map retData = ManufactureOrderFactory.getLocalInstance(ctx).getMaterialRelationData(inParam, false);
        ManufactureOrderExpectOutputCollection expectOutputs = (ManufactureOrderExpectOutputCollection)((Object)retData.get("EXPECTOUTPUTS"));
        mo.put("EXPECTOUTPUTS", (Object)(expectOutputs == null ? new ManufactureOrderExpectOutputCollection() : expectOutputs));
    }

    private void getDefaultRouting(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        ProductTransactionTypeInfo transInfo = mo.getTransactionType();
        StorageOrgUnitInfo storageOrgUnit = mo.getStorageOrgUnit();
        if (ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(mo.getMaterial())) {
            return;
        }
        String materialID = mo.getMaterial().getId().toString();
        String storageOrgUnitID = storageOrgUnit.getId().toString();
        CoreBaseCollection col = null;
        if (transInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60)));
            filterInfo.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)Boolean.TRUE));
            viewInfo.setFilter(filterInfo);
            IStandardRooting routing = StandardRootingFactory.getLocalInstance((Context)ctx);
            col = routing.getCollection(viewInfo);
            if (col == null || col.size() == 0) {
                mo.setRouting(MORootingUtil.getDefaultRooting(ctx, transInfo, storageOrgUnitID));
            } else {
                StandardRootingInfo rootingInfo = (StandardRootingInfo)col.get(0);
                mo.setRouting(rootingInfo);
            }
        }
    }

    private BigDecimal calcLimitUpperQty(BigDecimal extraRatio, BigDecimal qty, int unitPrec) {
        extraRatio = extraRatio.divide(new BigDecimal("100.00"), 4, 4).add(new BigDecimal("1.0"));
        BigDecimal extraQty = qty.multiply(extraRatio).setScale(unitPrec, 4);
        return extraQty;
    }

    private BigDecimal calcLimitLowerQty(BigDecimal lackRatio, BigDecimal qty, int unitPrec) {
        lackRatio = new BigDecimal("1.0").subtract(lackRatio.divide(new BigDecimal("100.00"), 4, 4));
        BigDecimal lackQty = qty.multiply(lackRatio).setScale(unitPrec, 4);
        return lackQty;
    }

    private Timestamp getPlanBeginDate(Timestamp planEndDate, MaterialPlanInfo materialPlanInfo) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(planEndDate);
        if (materialPlanInfo != null) {
            cal.add(5, -1 * materialPlanInfo.getProduceLeadTime());
        }
        return new Timestamp(cal.getTimeInMillis());
    }

    private BigDecimal getDeliveryQty(BigDecimal qty, BigDecimal yield) throws EASBizException, BOSException {
        if (yield == null) {
            return SysConstant.BIGZERO;
        }
        int unitPrec = 4;
        BigDecimal fYield = yield.divide(new BigDecimal("100.00"), unitPrec, 4);
        BigDecimal deliveryQty = qty.multiply(fYield).setScale(unitPrec, 4);
        return deliveryQty;
    }

    private static String getResource(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.mo.ManufactureOrderResource";
        return ResourceUtils.getMessageForServer((String)path, (String)resourceName);
    }

    private static String getResource(Context ctx, String resourceName, String[] parameters) {
        String message = ManufactureOrderChildGenerateFacadeControllerBean.getResource(ctx, resourceName);
        StringBuffer sb = new StringBuffer();
        String REGEX_L = "\\{";
        String REGEX_R = "\\}";
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    private void updateLotNumberAndWarehous(Context ctx, ManufactureOrderInfo order) throws BOSException, EASBizException {
        LotParamValueInfo lpv;
        MaterialInfo material = order.getMaterial();
        StorageOrgUnitInfo storageOrgUnit = order.getStorageOrgUnit();
        if (ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(material) || ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(storageOrgUnit)) {
            return;
        }
        MaterialInventoryInfo inventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(material.getId().toString(), storageOrgUnit.getId().toString());
        if (ManufactureOrderChildGenerateFacadeControllerBean.isNullOrIdIsNull(inventoryInfo)) {
            return;
        }
        if (inventoryInfo.isIsLotNumber() && (lpv = LotParamValueFactory.getLocalInstance((Context)ctx).getLotParamValueByStorg(storageOrgUnit.getId().toString())) != null && lpv.isManufactureOrder()) {
            LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrameExtend(material.getId().toString(), storageOrgUnit.getId().toString());
            if (lotFrame == null || lotFrame.getLotRule() == null) {
                return;
            }
            LotFrameManu lotFrameManu = new LotFrameManu();
            lotFrameManu.setSeq(lotFrame.getSeq());
            lotFrameManu.setSysDate(lotFrame.getSysDate());
            lotFrameManu.setCurrentSerial(lotFrame.getCurrentSerial());
            lotFrameManu.setMainBizOrg(storageOrgUnit.getNumber());
            lotFrameManu.setMaterial(material.getNumber());
            lotFrameManu.setLotRule(lotFrame.getLotRule());
            lotFrameManu.setMfg((Date)order.getPlanEndDate());
            lotFrameManu.setBizDate(order.getBizDate());
            order.setLot(lotFrameManu.getLotNumber());
        }
        if (inventoryInfo.getDefaultWarehouse() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            WarehouseInfo defaultWarehouse = (WarehouseInfo)WarehouseFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(inventoryInfo.getDefaultWarehouse().getId().toString()), sic);
            order.setDefaultWarehous(defaultWarehouse);
        }
    }

    private static void updateCostObject(Context ctx, ManufactureOrderInfo mo) throws EASBizException, BOSException {
        StorageOrgUnitInfo storageOrgUnit = mo.getStorageOrgUnit();
        MaterialInfo materialInfo = mo.getMaterial();
        if (storageOrgUnit == null) {
            return;
        }
        OrgUnitCollection companys = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(storageOrgUnit.getId().toString(), 4, 1);
        CompanyOrgUnitInfo company = null;
        if (companys != null && companys.size() > 0) {
            company = (CompanyOrgUnitInfo)companys.get(0);
        }
        if (company == null) {
            return;
        }
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnit.getId().toString())), (String)"AutoGenLotCost");
        ICostObject icostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        IMaterialCompanyInfo iMaterialCompanyInfo = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        CostObjectInfo costObjectInfo = null;
        if (paramValue.equals("false")) {
            costObjectInfo = icostObject.getCostObjectByMaterial(materialInfo.getId().toString(), company.getId().toString());
            mo.setCostObject(costObjectInfo);
        } else {
            MaterialInventoryInfo materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), storageOrgUnit.getId().toString());
            if (!materialInventoryInfo.isIsLotNumber() || materialInventoryInfo.getStatus().getValue() != 1) {
                return;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT mateial.Id, mateial.number, mateial.name, mateial.status, status, accountType,calculateType ").append(" WHERE mateial.Id = '").append(materialInfo.getId().toString()).append("' ").append(" AND mateial.status = '1' AND status = '1' ").append(" AND company.Id = '").append(company.getId().toString()).append("'");
            MaterialCompanyInfoCollection mciColl = iMaterialCompanyInfo.getMaterialCompanyInfoCollection(sql.toString());
            if (mciColl.size() == 0) {
                return;
            }
            MaterialCompanyInfoInfo companyInfo = mciColl.get(0);
            if (companyInfo.getCalculateType().getValue() != 2 || companyInfo.getAccountType().getValue() != 5) {
                return;
            }
            CostObjectCollection cols = new CostObjectCollection();
            CostObjectInfo item = new CostObjectInfo();
            item.setCompany(company);
            item.setRelatedId(materialInfo.getId());
            item.setBatchNumber(mo.getLot());
            item.setStdProductID(materialInfo);
            cols.add(item);
            icostObject.addnewBybatch((IObjectCollection)cols);
            costObjectInfo = ManufactureOrderChildGenerateFacadeControllerBean.findCostObject(ctx, company.getId().toString(), materialInfo.getId().toString(), mo.getLot());
            mo.setCostObject(costObjectInfo);
        }
    }

    private static CostObjectInfo findCostObject(Context ctx, String companyID, String materialID, String lot) throws BOSException, EASBizException, UuidException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select mateial.Id, mateial.number, mateial.name, mateial.status, status, accountType ");
        sql.append(" where mateial.Id = '").append(materialID).append("' ");
        sql.append(" and mateial.status = '1' and status = '1' and accountType = '5' and company.Id = '").append(companyID).append("'");
        IMaterialCompanyInfo imc = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoCollection mciColl = imc.getMaterialCompanyInfoCollection(sql.toString());
        if (mciColl.size() == 0) {
            return null;
        }
        String number = mciColl.get(0).getMateial().getNumber();
        if (!StringUtils.isEmpty((String)lot)) {
            lot = "-" + lot;
            number = number.concat(lot);
        }
        sql.setLength(0);
        sql.append(" select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale());
        sql.append(" from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid ");
        sql.append(" where coe.FRelatedID = ? ").append("   and co.FNumber = ? ").append("   and co.FCompanyID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, number, companyID});
        try {
            if (rs.next()) {
                CostObjectInfo co = new CostObjectInfo();
                co.setId(BOSUuid.read((String)rs.getString(1)));
                co.setNumber(rs.getString(2));
                co.setName(rs.getString(3));
                return co;
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return null;
    }

    @Override
    protected String[] _checkAndRemoveChildMO(Context ctx, IObjectPK parentMOPK, boolean isDelOtherMO) throws BOSException, EASBizException {
        ManufactureOrderInfo parentInfo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo(parentMOPK);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT mo.flongnumber as FLONGNUMBER ");
        sql.append("FROM  T_mm_manufactureorder  mo  ");
        sql.append("WHERE\tmo.FSourceBillID='").append(parentMOPK.toString() + "'");
        sql.append("   \tAND\tmo.FBirthType=30");
        IRowSet lnrs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (lnrs == null || lnrs.size() <= 0) {
            return null;
        }
        try {
            String parentMONumber = parentInfo.getNumber();
            ArrayList<String> subLongNumAry = new ArrayList<String>();
            while (lnrs != null && lnrs.next()) {
                subLongNumAry.add(lnrs.getString("FLONGNUMBER"));
            }
            StringBuffer ksqlBuf = new StringBuffer();
            ksqlBuf.append("SELECT  mo.FID as FID, ");
            ksqlBuf.append("   mo.FBaseStatus as FBaseStatus, ");
            ksqlBuf.append("   mo.FBirthType as FBirthType, ");
            ksqlBuf.append("   bt.FDestObjectID  as FDestObjectID ");
            ksqlBuf.append("FROM  T_mm_manufactureorder  mo  ");
            ksqlBuf.append("   LEFT  JOIN  T_bot_Relation  bt  ");
            ksqlBuf.append("     ON  mo.fid = bt.FSrcObjectID  ");
            for (int i = 0; i < subLongNumAry.size(); ++i) {
                ksqlBuf.append(i == 0 ? " WHERE  " : " OR ");
                ksqlBuf.append("    mo.flongnumber  LIKE  '").append((String)subLongNumAry.get(i)).append("%'");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksqlBuf.toString());
            ArrayList<String> ids = new ArrayList<String>();
            while (rs != null && rs.next()) {
                String id = rs.getString("FID");
                int status = rs.getInt("FBaseStatus");
                int birthtype = rs.getInt("FBirthType");
                String destObjectID = rs.getString("FDestObjectID");
                if (!isDelOtherMO) {
                    if (status != 1 && status != 2) {
                        return new String[]{ManufactureOrderChildGenerateFacadeControllerBean.getResource(ctx, "Exists_Modified_bill_noChildGenerate", new String[]{parentMONumber})};
                    }
                    if (!isDelOtherMO && birthtype != 30) {
                        return new String[]{ManufactureOrderChildGenerateFacadeControllerBean.getResource(ctx, "Exists_other_bill_noChildGenerate", new String[]{parentMONumber}), ""};
                    }
                    if (!StringUtils.isEmpty((String)destObjectID)) {
                        return new String[]{ManufactureOrderChildGenerateFacadeControllerBean.getResource(ctx, "Exists_BOTP_bill_noChildGenerate", new String[]{parentMONumber})};
                    }
                }
                ids.add(id);
            }
            if (isDelOtherMO) {
                CodingRulerSrvHelper codeHelper = new CodingRulerSrvHelper();
                IManufactureOrder iManufactureOrder = ManufactureOrderFactory.getLocalInstance(ctx);
                for (int i = 0; i < ids.size(); ++i) {
                    ObjectStringPK moPK = new ObjectStringPK((String)ids.get(i));
                    ManufactureOrderInfo model = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo((IObjectPK)moPK);
                    codeHelper.rollBackNumber(ctx, (IObjectValue)model, (OrgUnitInfo)model.getStorageOrgUnit());
                    iManufactureOrder.deleteNoCheck((IObjectPK)moPK);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return new String[0];
    }

    private static boolean isNullOrIdIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj).getId() == null;
        }
        return false;
    }

    @Override
    protected boolean _isChildOrderMustSubmit(Context ctx) throws BOSException {
        return true;
    }
}

