/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.mo.app.MOMaterialWithdrawal;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ManufactureOrderExternal
implements MMExternalProcessor {
    private String billTypeID = null;
    private String[] billIds = null;

    protected String createTempTable(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("CREATE TABLE ls (").append("FBillID varchar(44) null,").append("FBillEntryID varchar(44) null,").append("FSourceBillID varchar(44) null,").append("FSourceBillEntryId varchar(44) null,").append("FBaseQty numeric(21,8) not null default 0,").append("FQty numeric(21,8) not null default 0 ").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    protected String fillData2TempTable(Context ctx, String billId) throws BOSException, EASBizException {
        String expandTablName = this.createTempTable(ctx);
        StringBuffer processTempTableSql = new StringBuffer();
        processTempTableSql.append("insert into ").append(expandTablName).append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBaseQty, FQty) ").append("select T.FID, T.FSourceBillID, Entry.FSourceBillEntryId, Entry.FBaseQty, Entry.FQty ").append("from T_IM_MaterialReqBill T ").append("inner join T_IM_MaterialReqBillEntry entry on T.FID = entry.FParentId ").append("where T.FID ='").append(billId).append("' ");
        DbUtil.execute((Context)ctx, (String)processTempTableSql.toString());
        return expandTablName;
    }

    private Map getTransTypeInfoMap(Context ctx, String[] billIds) throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("select FID,FTransactionTypeID from T_IM_MaterialReqBill where FID in (").append(SQLUtil.arrayToString((Object[])billIds)).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)tempSql.toString());
        HashMap<String, String> transTypeInfoMap = null;
        try {
            if (rs != null && rs.size() > 0) {
                transTypeInfoMap = new HashMap<String, String>();
                while (rs.next()) {
                    transTypeInfoMap.put(rs.getString("FID"), rs.getString("FTransactionTypeID"));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return transTypeInfoMap;
    }

    private Map getSourceBillTypeInfoMap(Context ctx, String[] billIds) throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("select FID,FSourceBillTypeID from T_IM_MaterialReqBill where FID in (").append(SQLUtil.arrayToString((Object[])billIds)).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)tempSql.toString());
        HashMap<String, String> srcBillTypeInfoMap = null;
        try {
            if (rs != null && rs.size() > 0) {
                srcBillTypeInfoMap = new HashMap<String, String>();
                while (rs.next()) {
                    srcBillTypeInfoMap.put(rs.getString("FID"), rs.getString("FSourceBillTypeID"));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return srcBillTypeInfoMap;
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        Map transTypeInfoMap = this.getTransTypeInfoMap(ctx, billIds);
        Map srcBillTypeInfoMap = this.getSourceBillTypeInfoMap(ctx, billIds);
        MOMaterialWithdrawal billUpdater = null;
        TransactionTypeInfo transactionTypeInfo = null;
        BillTypeInfo billTypeInfo = null;
        MaterialReqBillInfo materialReqBillInfo = null;
        String sourceBillTypeID = null;
        String transactionTypeID = null;
        for (int i = 0; i < billIds.length; ++i) {
            transactionTypeID = (String)transTypeInfoMap.get(billIds[i]);
            sourceBillTypeID = (String)srcBillTypeInfoMap.get(billIds[i]);
            if (transactionTypeID == null || sourceBillTypeID == null) continue;
            transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeID));
            billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(sourceBillTypeID));
            if (!transactionTypeInfo.getNumber().equals("L460") && !transactionTypeInfo.getNumber().equals("L461") && !transactionTypeInfo.getNumber().equals("L462")) continue;
            if ("3fY8szOQTQmfaNi+Tm5SJUY+1VI=".equals(billTypeInfo.getId().toString())) {
                materialReqBillInfo = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(billIds[i]));
                materialReqBillInfo.setTransactionType(transactionTypeInfo);
                if (bizAction == 103) {
                    PickingSlipBillFactory.getLocalInstance((Context)ctx).handleWriteBack((IObjectValue)materialReqBillInfo);
                    continue;
                }
                if (bizAction != 109) continue;
                PickingSlipBillFactory.getLocalInstance((Context)ctx).handleWriteBack_UnAudit((IObjectValue)materialReqBillInfo);
                continue;
            }
            if (!"B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(billTypeInfo.getId().toString())) continue;
            billUpdater = new MOMaterialWithdrawal(ctx);
            billUpdater.setSourceDataTable(this.fillData2TempTable(ctx, billIds[i]));
            billUpdater.setAuditAction(bizAction == 103);
            billUpdater.setTransTypeInfo(transactionTypeInfo);
            billUpdater.execute();
        }
    }

    public String getBillTypeID() {
        return this.billTypeID;
    }

    public void setBillTypeID(String billTypeID) {
        this.billTypeID = billTypeID;
    }

    public String[] getBillIds() {
        return this.billIds;
    }

    public void setBillIds(String[] billIds) {
        this.billIds = billIds;
    }
}

