/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.AbstractManufactureOrderScheduleFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManufactureOrderScheduleFacadeControllerBean
extends AbstractManufactureOrderScheduleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.ManufactureOrderScheduleFacadeControllerBean");

    @Override
    protected Map _getMOCollection4Shechule(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        HashMap<String, Object> sheduleDataMap = new HashMap<String, Object>();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("qty"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("relatingOrderNum"));
        view.getSelector().add(new SelectorItemInfo("scheduleType"));
        view.getSelector().add(new SelectorItemInfo("project.number"));
        view.getSelector().add(new SelectorItemInfo("trackNumber.number"));
        view.getSelector().add(new SelectorItemInfo("technics.*"));
        view.getSelector().add(new SelectorItemInfo("technics.unit.name"));
        view.getSelector().add(new SelectorItemInfo("technics.adminOrgUnit.name"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        view.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
        view.getSelector().add(new SelectorItemInfo("planBeginDate"));
        view.getSelector().add(new SelectorItemInfo("planEndDate"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("material.model"));
        view.getSelector().add(new SelectorItemInfo("material.name"));
        view.getSelector().add(new SelectorItemInfo("material.number"));
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("number");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        view.setSorter(sorters);
        IManufactureOrder moInterface = ManufactureOrderFactory.getLocalInstance(ctx);
        CoreBaseCollection collection = moInterface.getCollection(view);
        sheduleDataMap.put("moCollection", collection);
        sheduleDataMap.put("moPeriod", this.getWordPeriodMap(ctx, collection));
        return sheduleDataMap;
    }

    private Map getWordPeriodMap(Context ctx, CoreBaseCollection collection) throws BOSException {
        HashMap<String, Integer> entryPeriodMap = new HashMap<String, Integer>();
        String storageUnitId = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderInfo manufactureOrderInfo = (ManufactureOrderInfo)collection.get(i);
            storageUnitId = manufactureOrderInfo.getStorageOrgUnit().getId().toString();
            Timestamp planBeginDate = manufactureOrderInfo.getPlanBeginDate();
            Timestamp planEndDate = manufactureOrderInfo.getPlanEndDate();
            entryPeriodMap.put(manufactureOrderInfo.getId().toString(), new Integer(this.getPeriod(ctx, planBeginDate, planEndDate, storageUnitId)));
            ManufactureOrderTechnicsCollection techCollection = manufactureOrderInfo.getTechnics();
            int techSize = techCollection.size();
            for (int j = 0; j < techSize; ++j) {
                ManufactureOrderTechnicsInfo techInfo = techCollection.get(j);
                Timestamp earlestWorkDate = techInfo.getEarlistWoktime();
                Timestamp earlestCmpDate = techInfo.getEarlistCmpTime();
                int earlestPeriod = this.getPeriod(ctx, earlestWorkDate, earlestCmpDate, storageUnitId);
                Timestamp latestWorkDate = techInfo.getLastWorktime();
                Timestamp latestCmpDate = techInfo.getLastCmpTime();
                int latestPeriod = this.getPeriod(ctx, latestWorkDate, latestCmpDate, storageUnitId);
                entryPeriodMap.put(techInfo.getId().toString() + "_1", new Integer(earlestPeriod));
                entryPeriodMap.put(techInfo.getId().toString() + "_2", new Integer(latestPeriod));
            }
        }
        return entryPeriodMap;
    }

    private int getPeriod(Context ctx, Date beginDate, Date endDate, String storageUnitId) throws BOSException {
        String endDateStr;
        int period = 1;
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd");
        if (beginDate == null || endDate == null) {
            return 0;
        }
        String beginDateStr = dateFormate.format(beginDate);
        if (beginDateStr.equals(endDateStr = dateFormate.format(endDate))) {
            return period;
        }
        sql.append(" select ");
        sql.append(" case when facCAEntry.fworkdateseq=0 then facCAEntry.fnextworkdayseq else facCAEntry.fworkdateseq end  as fworkdateseq, ");
        sql.append(" case when facCAEntry.fworkdateseq=0 then 0 else 1 end  as fIsWorkdate ");
        sql.append(" from T_MM_FactoryCalendar facCa ");
        sql.append(" inner join T_MM_FactoryCalendarEntry facCAEntry on facCA.fid = facCAEntry.FParentID  ");
        sql.append(" and to_char(facCAEntry.FWorkDate,'YYYY-MM-DD') in ('").append(beginDateStr).append("','").append(endDateStr).append("') ");
        sql.append(" where facCa.FStorageOrgUnitID = '").append(storageUnitId).append("' and  facCa.FIsDefault=1 ");
        sql.append(" order by facCa.FStorageOrgUnitID,facCAEntry.fworkdateseq desc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (beginDateStr.equals(endDateStr) && rs.size() == 1) {
                period = 1;
            } else if (rs.size() == 2) {
                int begin = 0;
                int end = 0;
                if (rs.next()) {
                    end = rs.getInt("fworkdateseq");
                }
                if (rs.next()) {
                    begin = rs.getInt("fworkdateseq");
                }
                period = Math.abs(end - begin + 1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return period;
    }

    protected String _getMaterialIdByEntryId(Context ctx, String entryId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select bill.fMaterialId as fMaterialId from t_mm_manufactureOrder bill ").append(" inner join T_MM_MFTOrderTechnics entry ");
        sql.append(" on bill.fid = entry.fparentId and entry.fid = '").append(entryId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String materialId = null;
        try {
            if (rs.next()) {
                materialId = rs.getString("fMaterialId");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialId;
    }

    @Override
    protected Map _getBillInfoByEntryId(Context ctx, String entryId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select bill.fMaterialId as fMaterialId, bill.FStorageOrgUnitID as FStorageOrgUnitID from t_mm_manufactureOrder bill ").append(" inner join T_MM_MFTOrderTechnics entry ");
        sql.append(" on bill.fid = entry.fparentId and entry.fid = '").append(entryId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> billInfoMap = new HashMap<String, String>();
        try {
            if (rs.next()) {
                billInfoMap.put("materialId", rs.getString("fMaterialId"));
                billInfoMap.put("storageUnitId", rs.getString("FStorageOrgUnitID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return billInfoMap;
    }
}

