/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.IFactoryCalendar;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.IManufactureOrderSplitRecord;
import com.kingdee.eas.mm.mo.MOBirthTypeEnum;
import com.kingdee.eas.mm.mo.MOSplitLotModeEnum;
import com.kingdee.eas.mm.mo.MOSplitTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderSplitException;
import com.kingdee.eas.mm.mo.ManufactureOrderSplitRecordCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderSplitRecordFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderSplitRecordInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.MaterialTransactionPlatformFacadeFactory;
import com.kingdee.eas.mm.mo.app.AbstractManufactureOrderSplitFacadeControllerBean;
import com.kingdee.eas.mm.mo.app.MOFinish;
import com.kingdee.eas.mm.mo.app.util.MOCostObjectUtil;
import com.kingdee.eas.mm.mo.util.MORootingUtil;
import com.kingdee.eas.mm.mo.util.MOUntil;
import com.kingdee.eas.mm.mo.util.NumericUtil;
import com.kingdee.eas.mm.planning.IReqPlanReceiveReqDataFacade;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.ReqPlanReceiveReqDataFacadeFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.IMaterialReqBillEntry;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ManufactureOrderSplitFacadeControllerBean
extends AbstractManufactureOrderSplitFacadeControllerBean {
    private static final long serialVersionUID = -8605559753809317019L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.ManufactureOrderSplitFacadeControllerBean");
    private static final BigDecimal DECIMAL_ZERO = new BigDecimal("0.0000");
    private static final BigDecimal DECIMAL_ONE = new BigDecimal("1.0000");
    private static final BigDecimal DECIMAL_ONE_HANDRED = new BigDecimal("100.0");
    private static final BigDecimal DECIMAL_ONE_PERCENT = new BigDecimal("0.01");
    private static final int PRECISION_MAX = 8;
    private int SPLIT_SCALE = 8;
    private Map unitConvRateLut = new HashMap();
    private Map unitScaleLut = new HashMap();
    private static final String RATIO = "ratio";
    private static final String RETURNED_MATERIAL_GROUP_BY_STOCK = "returned.material.group.by.stock";
    private static final String RETURNED_MATERIAL_GROUP_BY_MATERIAL = "returned.material.group.by.material";
    private static final String STOCK_PLAN_QTY = "stock.plan.qty";
    private static final String STOCK_ORIGINAL_PLAN_QTY = "stock.original.plan.qty";
    private static final String STOCK_QTY = "stock.qty";
    private static final String SOURCE_ORDER = "source.order";
    private static final String SUB_ORDER_AVG = "sub.order.avg";
    private static final String SUB_ORDER_LAST = "sub.order.last";

    @Override
    public ManufactureOrderCollection _split(Context ctx, Map splitParams) throws BOSException, EASBizException {
        try {
            ObjectUuidPK user = new ObjectUuidPK(ctx.getCaller().toString());
            StorageOrgUnitInfo orgUnit = (StorageOrgUnitInfo)splitParams.get("currentStorageOrgUnitInfo");
            ObjectUuidPK org = new ObjectUuidPK(orgUnit.getId());
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)user, (IObjectPK)org, "mm_mo_split");
        }
        catch (Exception exc) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.PERMISSION_WAS_NOT_ASSIGNED);
        }
        return this.doSplit(ctx, splitParams);
    }

    private ManufactureOrderCollection doSplit(Context ctx, Map splitParams) throws BOSException, EASBizException {
        ManufactureOrderCollection splittedOrders = new ManufactureOrderCollection();
        String moid = (String)splitParams.get("srcOrderID");
        ManufactureOrderInfo mo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo((IObjectPK)new ObjectStringPK(moid), ManufactureOrderSplitFacadeControllerBean.getSelectors());
        MaterialInfo materialInfo = mo.getMaterial();
        BomInfo bom = null;
        if (mo.getBomID() != null && mo.getBomID().length() > 0) {
            bom = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(mo.getBomID()));
        }
        int oprtNo = (Integer)splitParams.get("oprtNO");
        BigDecimal splitQty = (BigDecimal)splitParams.get("splitQty");
        int blocks = (Integer)splitParams.get("splitBlocks");
        this.SPLIT_SCALE = (Integer)splitParams.get("splitScale");
        BigDecimal avgOrderQty = (BigDecimal)splitParams.get("splitAverage");
        BigDecimal lastOrderQty = blocks == 1 ? avgOrderQty : splitQty.subtract(avgOrderQty.multiply(new BigDecimal(String.valueOf(blocks - 1))));
        boolean isUniform = blocks == 1 || avgOrderQty.compareTo(lastOrderQty) == 0;
        MOSplitLotModeEnum mode = (MOSplitLotModeEnum)((Object)splitParams.get("lot_generate_mode"));
        Date planStartDate = (Date)splitParams.get("planStartDate");
        Date planFinishDate = (Date)splitParams.get("planFinishDate");
        int stepLength = (Integer)splitParams.get("dateStepLength");
        BizTypeInfo bizType = (BizTypeInfo)splitParams.get("bizType");
        ProductTransactionTypeInfo transType = (ProductTransactionTypeInfo)splitParams.get("transactionType");
        ProjectInfo project = (ProjectInfo)splitParams.get("reform_project");
        TrackNumberInfo track = (TrackNumberInfo)splitParams.get("reform_track");
        String customizedLot = (String)splitParams.get("reform_customized_lot");
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)splitParams.get("adminOrgUnit");
        int workDays = ManufactureOrderSplitFacadeControllerBean.getWorkDays(ctx, mo.getStorageOrgUnit(), planStartDate, planFinishDate) - 1;
        Object[] subOrderWorkDateArray = new Date[blocks * 2];
        for (int idx = 1; idx <= blocks; ++idx) {
            if (idx == 1) {
                subOrderWorkDateArray[0] = planStartDate;
                subOrderWorkDateArray[1] = planFinishDate;
                continue;
            }
            subOrderWorkDateArray[idx * 2 - 2] = ManufactureOrderSplitFacadeControllerBean.getDateAfterDays(ctx, mo.getStorageOrgUnit(), planStartDate, stepLength * (idx - 1));
            subOrderWorkDateArray[idx * 2 - 1] = ManufactureOrderSplitFacadeControllerBean.getDateAfterDays(ctx, mo.getStorageOrgUnit(), planStartDate, stepLength * (idx - 1) + workDays);
        }
        if (!ManufactureOrderSplitFacadeControllerBean.isAllWorkDatesValid(ctx, mo.getStorageOrgUnit(), (Date[])subOrderWorkDateArray)) {
            logger.log(Priority.ERROR, (Object)("sub order work date array elements: " + StringUtils.arrayToString((Object[])subOrderWorkDateArray, (String)", ")));
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.WORK_DATE_OUT_OF_BOUNDS);
        }
        Calendar calendar = Calendar.getInstance();
        Date bizDate = calendar.getTime();
        IObjectPK logPk = null;
        logPk = bizType.getNumber().equals("401") ? LogUtil.beginLog((Context)ctx, (String)"split", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(mo.getId()), (String)mo.getNumber(), (String)"mm_manufactureOrder_split") : LogUtil.beginLog((Context)ctx, (String)"reform", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(mo.getId()), (String)mo.getNumber(), (String)"mm_manufactureOrder_reform");
        Map stockingRuleCache = this.cacheStockingRule(ctx, MOSplitTypeEnum.STANDARD, mo, oprtNo, blocks, splitQty, avgOrderQty, lastOrderQty);
        Map returnQtyGroupByStock = (Map)stockingRuleCache.get(RETURNED_MATERIAL_GROUP_BY_STOCK);
        Map returnQtyGroupByMaterial = (Map)stockingRuleCache.get(RETURNED_MATERIAL_GROUP_BY_MATERIAL);
        MaterialPlanInfo materialPlan = ManufactureOrderSplitFacadeControllerBean.getMaterialPlanInfo(ctx, mo.getMaterial(), mo.getStorageOrgUnit());
        int maxOffset = 0;
        try {
            maxOffset = this.getMaxSubIndex(ctx, mo.getNumber());
        }
        catch (SQLException e) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.NUMBER_CALCULATION_EXCEPTION);
        }
        ArrayList<MaterialReqBillInfo> pickingBillList = new ArrayList<MaterialReqBillInfo>();
        ArrayList<String> idList = new ArrayList<String>();
        BTPTransformResult botpResult = null;
        for (int idx = 1; idx <= blocks; ++idx) {
            ManufactureOrderInfo order = this.cloneSourceOrder(mo, true, true, true);
            MOSplitTypeEnum typeEum = MOSplitTypeEnum.STANDARD;
            order.setNumber(mo.getNumber() + "_" + (maxOffset + idx));
            order.setLongNumber(mo.getLongNumber() + "!" + order.getId().toString());
            order.setBaseStatus(BillBaseStatusEnum.AUDITED);
            order.setBizDate(bizDate);
            calendar.setTime((Date)subOrderWorkDateArray[idx * 2 - 2]);
            order.setPlanBeginDate(new Timestamp(calendar.getTimeInMillis()));
            calendar.setTime((Date)subOrderWorkDateArray[idx * 2 - 1]);
            order.setPlanEndDate(new Timestamp(calendar.getTimeInMillis()));
            order.setAdminOrgUnit(adminOrgUnit);
            if (bizType.getNumber().equals("401")) {
                order.setTransactionType(mo.getTransactionType());
                order.setBizType(mo.getBizType());
                order.setBirthType(MOBirthTypeEnum.SPLIT);
            } else {
                order.setTransactionType(transType);
                order.setBizType(bizType);
                order.setBirthType(MOBirthTypeEnum.REFORM);
                typeEum = MOSplitTypeEnum.REFORM;
            }
            order.setSrcBillNum(mo.getNumber());
            order.setSourceBillId(mo.getId().toString());
            order.setSourceBillType(mo.getBillType());
            this.updateLot(ctx, order, typeEum, mode, customizedLot, mo.getLot());
            if (bizType.getNumber().equals("403")) {
                order.setProject(project);
                order.setTrackNumber(track);
            }
            order.setCostObject(null);
            this.updateSubOrderHeader(ctx, MOSplitTypeEnum.STANDARD, materialPlan, order, oprtNo, bom, idx, blocks, avgOrderQty, lastOrderQty, mo);
            Map pickingQtyGroupByStock = this.updateSubOrderStockEntry(ctx, MOSplitTypeEnum.STANDARD, order.getQty(), order.getStocks(), oprtNo, idx, blocks, isUniform, returnQtyGroupByMaterial, stockingRuleCache);
            this.updateSubOrderTechnicsEntry(ctx, MOSplitTypeEnum.STANDARD, materialPlan, mo, order, oprtNo, materialInfo);
            if (typeEum.equals((Object)MOSplitTypeEnum.REFORM)) {
                this.updateSubOrderExpectOutputEntry(ctx, MOSplitTypeEnum.STANDARD, mo, order, splitQty, oprtNo, true);
            } else {
                this.updateSubOrderExpectOutputEntry(ctx, MOSplitTypeEnum.STANDARD, mo, order, splitQty, oprtNo, false);
            }
            ManufactureOrderFactory.getLocalInstance(ctx).addnew((IObjectPK)new ObjectUuidPK(order.getId()), (CoreBaseInfo)order);
            splittedOrders.add(order);
            this.saveMOSplitRecord(ctx, mo.getId(), order.getId(), null, null, oprtNo, splitQty, blocks, this.SPLIT_SCALE, avgOrderQty);
            ManufactureOrderFactory.getLocalInstance(ctx).invoke("doAfterSubmitAndAudit", new Object[]{order.getId().toString()});
            LotFacadeFactory.getLocalInstance((Context)ctx).manufactuerOrderInsertLotSource(new String[]{order.getId().toString()});
            idList.add(order.getId().toString());
            if (pickingQtyGroupByStock.isEmpty()) continue;
            BTPTransformResult tempBotpResult = this.pickingMaterialByMOSplit(ctx, null, order, pickingQtyGroupByStock, mo);
            if (botpResult == null) {
                botpResult = tempBotpResult;
            }
            if (botpResult == null || tempBotpResult == null) continue;
            MaterialReqBillCollection bills = (MaterialReqBillCollection)tempBotpResult.getBills();
            BOTRelationCollection botCol = tempBotpResult.getBOTRelationCollection();
            botpResult.addBills((IObjectCollection)bills);
            botpResult.addBOTRelationCollection(botCol);
            MaterialReqBillInfo bill = null;
            int count = bills.size();
            for (int i = 0; i < count; ++i) {
                bill = (MaterialReqBillInfo)bills.getObject(i);
                pickingBillList.add(bill);
            }
        }
        this.updateSourceOrderHeader(ctx, MOSplitTypeEnum.STANDARD, mo, splitQty);
        this.updateSourceOrderStockEntry(ctx, MOSplitTypeEnum.STANDARD, mo, oprtNo, blocks, avgOrderQty, lastOrderQty, stockingRuleCache);
        this.updateSourceOrderTechnicsEntry(ctx, MOSplitTypeEnum.STANDARD, mo, oprtNo, splitQty);
        this.updateSourceOrderExpectOutputEntry(ctx, MOSplitTypeEnum.STANDARD, mo, oprtNo, splitQty);
        ManufactureOrderFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(mo.getId()), (CoreBaseInfo)mo);
        if (!returnQtyGroupByStock.isEmpty()) {
            this.returnMaterialBasedOnPickingBills(ctx, pickingBillList, returnQtyGroupByStock, mo, oprtNo, splitQty, blocks, this.SPLIT_SCALE, avgOrderQty, null);
        }
        if (botpResult != null) {
            IMaterialReqBill materialReqBiz = MaterialReqBillFactory.getLocalInstance((Context)ctx);
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            IObjectCollection col = botpResult.getBills();
            BOTRelationCollection botRelationCols = botpResult.getBOTRelationCollection();
            try {
                if (WfEventListenerStateManager.getInstance().isEnable()) {
                    WfEventListenerStateManager.getInstance().disableEventListener();
                }
                for (MaterialReqBillInfo destBillInfo : col) {
                    StorageOrgUnitInfo storageOrgUnit = destBillInfo.getStorageOrgUnit();
                    materialReqBiz.submit((CoreBaseInfo)destBillInfo);
                    boolean isAutoAudit = ManufactureOrderSplitFacadeControllerBean.isAuditAfterSubmit(ctx, (SCMBillBaseInfo)destBillInfo, storageOrgUnit.getId().toString(), 4);
                    if (isAutoAudit) continue;
                    materialReqBiz.audit((IObjectPK)new ObjectUuidPK(destBillInfo.getId()));
                }
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
            finally {
                if (!WfEventListenerStateManager.getInstance().isEnable()) {
                    WfEventListenerStateManager.getInstance().enableEventListener();
                }
            }
        }
        this.dealWithMOFinish(ctx, mo.getId().toString(), true);
        try {
            this.updateReqPlanData(ctx, idList, 99031);
            idList.clear();
            idList.add(mo.getId().toString());
            this.updateReqPlanData(ctx, idList, 99032);
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return splittedOrders;
    }

    @Override
    public ManufactureOrderCollection _reform(Context ctx, Map reformParams) throws BOSException, EASBizException {
        ManufactureOrderTechnicsInfo info;
        int i;
        int count;
        try {
            ObjectUuidPK user = new ObjectUuidPK(ctx.getCaller().toString());
            StorageOrgUnitInfo orgUnit = (StorageOrgUnitInfo)reformParams.get("currentStorageOrgUnitInfo");
            ObjectUuidPK org = new ObjectUuidPK(orgUnit.getId());
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)user, (IObjectPK)org, "mm_mo_split");
        }
        catch (Exception exc) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.PERMISSION_WAS_NOT_ASSIGNED);
        }
        String moid = (String)reformParams.get("srcOrderID");
        ManufactureOrderInfo mo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo((IObjectPK)new ObjectStringPK(moid), ManufactureOrderSplitFacadeControllerBean.getSelectors());
        MaterialInfo material = (MaterialInfo)reformParams.get("reform_material");
        MeasureUnitInfo unit = (MeasureUnitInfo)reformParams.get("unit");
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)reformParams.get("baseUnit");
        BomInfo bom = (BomInfo)reformParams.get("reform_bom");
        StandardRootingInfo routing = (StandardRootingInfo)reformParams.get("reform_routing");
        ProductTransactionTypeInfo transactionType = (ProductTransactionTypeInfo)reformParams.get("transactionType");
        ProjectInfo project = (ProjectInfo)reformParams.get("reform_project");
        TrackNumberInfo track = (TrackNumberInfo)reformParams.get("reform_track");
        if (routing == null && transactionType != null && (!transactionType.isIsWPManagement() || transactionType.isIsWPManagement() && transactionType.isIsAutoGenerateWP())) {
            routing = MORootingUtil.getDefaultRooting(ctx, mo, false);
        }
        if (routing == null) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.ILLEGAL_REFORM_OPERATION);
        }
        if (EqualsUtil.equals((Object)material, (Object)mo.getMaterial()) && EqualsUtil.equals((String)bom.getId().toString(), (String)mo.getBomID()) && EqualsUtil.equals((Object)routing, (Object)mo.getRouting()) && EqualsUtil.equals((Object)track, (Object)mo.getTrackNumber()) && EqualsUtil.equals((Object)project, (Object)mo.getProject())) {
            return this.doSplit(ctx, reformParams);
        }
        int oprtNo = (Integer)reformParams.get("oprtNO");
        BigDecimal splitQty = (BigDecimal)reformParams.get("splitQty");
        MOSplitLotModeEnum mode = (MOSplitLotModeEnum)((Object)reformParams.get("lot_generate_mode"));
        String customizedLot = (String)reformParams.get("reform_customized_lot");
        BizTypeInfo bizType = (BizTypeInfo)reformParams.get("bizType");
        Date planStartDate = (Date)reformParams.get("planStartDate");
        Date planFinishDate = (Date)reformParams.get("planFinishDate");
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)reformParams.get("adminOrgUnit");
        if (!ManufactureOrderSplitFacadeControllerBean.isAllWorkDatesValid(ctx, mo.getStorageOrgUnit(), new Date[]{planStartDate, planFinishDate})) {
            logger.log(Priority.ERROR, (Object)("sub order work date array elements: " + planStartDate.toString() + ", " + planFinishDate.toString()));
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.WORK_DATE_OUT_OF_BOUNDS);
        }
        Calendar calendar = Calendar.getInstance();
        Date bizDate = calendar.getTime();
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"reform", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(mo.getId()), (String)mo.getNumber(), (String)"mm_manufactureOrder_reform");
        Map stockingRuleCache = this.cacheStockingRule(ctx, MOSplitTypeEnum.REFORM, mo, oprtNo, 1, splitQty, splitQty, splitQty);
        Map returnQtyGroupByStock = (Map)stockingRuleCache.get(RETURNED_MATERIAL_GROUP_BY_STOCK);
        Map returnQtyGroupByMaterial = (Map)stockingRuleCache.get(RETURNED_MATERIAL_GROUP_BY_MATERIAL);
        MaterialPlanInfo materialPlan = ManufactureOrderSplitFacadeControllerBean.getMaterialPlanInfo(ctx, material, mo.getStorageOrgUnit());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ROUTINGID", routing.getId().toString());
        param.put("STORAGEORG", mo.getStorageOrgUnit());
        calendar.setTime(planStartDate);
        param.put("BEGINTIME", new Timestamp(calendar.getTimeInMillis()));
        calendar.setTime(planFinishDate);
        param.put("ENDTIME", new Timestamp(calendar.getTimeInMillis()));
        param.put("BASEUNIT", baseUnit);
        param.put("BILL_UNIT", unit);
        param.put("BILL_QTY", splitQty);
        param.put("SPLIT_QTY", DECIMAL_ZERO);
        param.put("BOM", bom);
        param.put("projectID", project);
        param.put("trackID", track);
        param.put("MATERIAL", material);
        param.put("TRANSTYPE", transactionType);
        param.put("RECALC", Boolean.TRUE);
        param.put("adminOrgUnit", adminOrgUnit);
        ManufactureOrderInfo order = this.cloneSourceOrder(mo, false, false, false);
        this.updateLot(ctx, order, MOSplitTypeEnum.REFORM, mode, customizedLot, mo.getLot());
        param.put("LOTNUMBER", order.getLot());
        Map entries = this.buildEntries(ctx, param, order);
        order.getStocks().addCollection((ManufactureOrderStockCollection)((Object)entries.get("STOCK")));
        order.getTechnics().addCollection((ManufactureOrderTechnicsCollection)((Object)entries.get("TECHNICS")));
        order.getExpectOutputs().addCollection((ManufactureOrderExpectOutputCollection)((Object)entries.get("EXPECTOUTPUTS")));
        boolean legal = false;
        if (order.getTechnics() != null) {
            count = order.getTechnics().size();
            for (i = 0; i < count; ++i) {
                info = order.getTechnics().get(i);
                int oprt = info.getOperationNo();
                if (oprt < oprtNo) continue;
                legal = true;
                break;
            }
        }
        if (!legal) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.ILLEGAL_REFORM_OPERATION);
        }
        legal = false;
        if (order.getTechnics() != null && transactionType != null && transactionType.isIsWPManagement()) {
            count = order.getTechnics().size();
            for (i = 0; i < count; ++i) {
                info = order.getTechnics().get(i);
                if (info.getWorkcenter() != null) continue;
                legal = true;
                break;
            }
        }
        if (legal) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.TECHICS_NO_WORKCENTER);
        }
        legal = false;
        if (order.getStocks() != null) {
            ManufactureOrderStockInfo stock = null;
            int count2 = order.getStocks().size();
            for (int i2 = 0; i2 < count2; ++i2) {
                stock = order.getStocks().get(i2);
                if (stock.getWarehouse() == null || stock.getLocation() != null || !stock.getWarehouse().isHasLocation()) continue;
                legal = true;
                break;
            }
        }
        if (legal) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.STOCKS_NO_LOCATION);
        }
        order.setMaterial(material);
        order.setUnit(unit);
        order.setBaseUnit(baseUnit);
        MaterialInventoryInfo materilInvInfo = ManufactureOrderSplitFacadeControllerBean.getMaterialInventoryInfo(ctx, material, mo.getStorageOrgUnit());
        order.setDefaultWarehous(materilInvInfo == null ? null : materilInvInfo.getDefaultWarehouse());
        order.setTotalSplitQty(DECIMAL_ZERO);
        order.setTotalSplitBaseQty(DECIMAL_ZERO);
        order.setProject(project);
        order.setTrackNumber(track);
        order.setBomID(bom.getId().toString());
        order.setBomNum(bom.getNumber());
        order.setRouting(routing);
        int maxOffset = 0;
        try {
            maxOffset = this.getMaxSubIndex(ctx, mo.getNumber());
            order.setNumber(mo.getNumber() + "_" + (maxOffset + 1));
        }
        catch (SQLException e) {
            throw new ManufactureOrderSplitException(ManufactureOrderSplitException.NUMBER_CALCULATION_EXCEPTION);
        }
        order.setLongNumber(mo.getLongNumber() + "!" + order.getId().toString());
        order.setBaseStatus(BillBaseStatusEnum.AUDITED);
        order.setBizDate(bizDate);
        calendar.setTime(planStartDate);
        order.setPlanBeginDate(new Timestamp(calendar.getTimeInMillis()));
        calendar.setTime(planFinishDate);
        order.setPlanEndDate(new Timestamp(calendar.getTimeInMillis()));
        order.setAdminOrgUnit(adminOrgUnit);
        if (materialPlan != null && materialPlan.getPlanOrg() != null) {
            order.setPlanOrgUnit(materialPlan.getPlanOrg());
        }
        if (materialPlan != null && materialPlan.getPlanner() != null) {
            order.setDispatcher(materialPlan.getPlanner());
        }
        order.setBizType(bizType);
        order.setTransactionType(transactionType);
        order.setScheduleType(transactionType.getScheduleType());
        order.setBirthType(MOBirthTypeEnum.REFORM);
        order.setSrcBillNum(mo.getNumber());
        order.setSourceBillId(mo.getId().toString());
        order.setSourceBillType(mo.getBillType());
        order.setCostObject(null);
        this.updateSubOrderHeader(ctx, MOSplitTypeEnum.REFORM, materialPlan, order, oprtNo, bom, 1, 1, splitQty, splitQty, mo);
        Map pickingQtyGroupByStock = this.updateSubOrderStockEntry(ctx, MOSplitTypeEnum.REFORM, order.getQty(), order.getStocks(), oprtNo, 1, 1, true, returnQtyGroupByMaterial, stockingRuleCache);
        this.updateSubOrderTechnicsEntry(ctx, MOSplitTypeEnum.REFORM, materialPlan, mo, order, oprtNo, order.getMaterial());
        this.updateSubOrderExpectOutputEntry(ctx, MOSplitTypeEnum.REFORM, mo, order, splitQty, oprtNo, false);
        ManufactureOrderFactory.getLocalInstance(ctx).addnew((IObjectPK)new ObjectUuidPK(order.getId()), (CoreBaseInfo)order);
        this.saveMOSplitRecord(ctx, mo.getId(), order.getId(), null, null, oprtNo, splitQty, 1, splitQty.scale(), splitQty);
        ManufactureOrderFactory.getLocalInstance(ctx).invoke("doAfterSubmitAndAudit", new Object[]{order.getId().toString()});
        LotFacadeFactory.getLocalInstance((Context)ctx).manufactuerOrderInsertLotSource(new String[]{order.getId().toString()});
        ArrayList<MaterialReqBillInfo> pickingBillList = new ArrayList<MaterialReqBillInfo>();
        BTPTransformResult botpResult = null;
        if (!pickingQtyGroupByStock.isEmpty() && (botpResult = this.pickingMaterialByMOSplit(ctx, null, order, pickingQtyGroupByStock, mo)) != null) {
            MaterialReqBillInfo bill = (MaterialReqBillInfo)botpResult.getBills().getObject(0);
            pickingBillList.add(bill);
        }
        this.updateSourceOrderHeader(ctx, MOSplitTypeEnum.REFORM, mo, splitQty);
        this.updateSourceOrderStockEntry(ctx, MOSplitTypeEnum.REFORM, mo, oprtNo, 1, splitQty, splitQty, stockingRuleCache);
        this.updateSourceOrderTechnicsEntry(ctx, MOSplitTypeEnum.REFORM, mo, oprtNo, splitQty);
        this.updateSourceOrderExpectOutputEntry(ctx, MOSplitTypeEnum.REFORM, mo, oprtNo, splitQty);
        ManufactureOrderFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(mo.getId()), (CoreBaseInfo)mo);
        if (!returnQtyGroupByStock.isEmpty()) {
            this.returnMaterialBasedOnPickingBills(ctx, pickingBillList, returnQtyGroupByStock, mo, oprtNo, splitQty, 1, splitQty.scale(), splitQty, order.getId());
        }
        this.dealWithMOFinish(ctx, mo.getId().toString(), true);
        ArrayList<String> idList = new ArrayList<String>();
        try {
            idList.clear();
            idList.add(order.getId().toString());
            this.updateReqPlanData(ctx, idList, 99031);
            idList.clear();
            idList.add(mo.getId().toString());
            this.updateReqPlanData(ctx, idList, 99032);
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        ManufactureOrderCollection reformedOrders = new ManufactureOrderCollection();
        return reformedOrders;
    }

    @Override
    protected String _undoSplit(Context ctx, IObjectPK moPK) throws BOSException, EASBizException {
        IManufactureOrder iManufactureOrder = ManufactureOrderFactory.getLocalInstance(ctx);
        ManufactureOrderInfo childInfo = iManufactureOrder.getManufactureOrderInfo(moPK);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"undoSplit", (BOSObjectType)this.getBOSType(), (IObjectPK)moPK, (String)childInfo.getNumber(), (String)"mm_manufactureOrder_unSplit");
        if (childInfo.getBirthType() == null || childInfo.getBirthType().getValue() != 10 && childInfo.getBirthType().getValue() != 20) {
            return this.getResource(ctx, "MO_noUndoSplit_noSplit");
        }
        String checkMsg = this.checkForUndoSplit(ctx, moPK.toString());
        if (!StringUtils.isEmpty((String)checkMsg)) {
            return checkMsg;
        }
        ManufactureOrderInfo parentInfo = iManufactureOrder.getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(childInfo.getSourceBillId()));
        if (BillBaseStatusEnum.CLOSED.equals((Object)parentInfo.getBaseStatus())) {
            return this.getResource(ctx, "MO_parentClosed_noUndoSplit");
        }
        if (BillBaseStatusEnum.FINCLOSED.equals((Object)parentInfo.getBaseStatus())) {
            return this.getResource(ctx, "MO_parentFinclosed_noUndoSplit");
        }
        if (BillBaseStatusEnum.BLOCKED.equals((Object)parentInfo.getBaseStatus())) {
            return this.getResource(ctx, "MO_parentFreezing_noUndoSplit");
        }
        ManufactureOrderSplitRecordCollection recordCollection = this.getMOSplitRecord(ctx, parentInfo.getId().toString(), moPK.toString());
        if (recordCollection == null || recordCollection.size() == 0) {
            return this.getResource(ctx, "MO_noUndoSplit_noSplit");
        }
        int splitOperationNo = childInfo.getFirstOperNo();
        Iterator itor = recordCollection.iterator();
        while (itor.hasNext()) {
            HashMap<String, String> reqIDs;
            ManufactureOrderSplitRecordInfo moSplitRecord = (ManufactureOrderSplitRecordInfo)itor.next();
            splitOperationNo = moSplitRecord.getSplitOperationNo();
            MaterialReqBillInfo mrbiPicking = null;
            if (moSplitRecord.getPickId() != null) {
                try {
                    mrbiPicking = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(moSplitRecord.getPickId()));
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
            MaterialReqBillInfo mrbiReturnInfo = null;
            if (moSplitRecord.getReturnId() != null) {
                try {
                    mrbiReturnInfo = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(moSplitRecord.getReturnId()));
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
            if (mrbiPicking != null) {
                if (mrbiPicking.getBaseStatus().getValue() == 4) {
                    MaterialReqBillFactory.getLocalInstance((Context)ctx).unAudit((IObjectPK)new ObjectUuidPK(mrbiPicking.getId()));
                }
                reqIDs = new HashMap<String, String>();
                reqIDs.put(mrbiPicking.getId().toString(), mrbiPicking.getNumber());
                MaterialTransactionPlatformFacadeFactory.getLocalInstance(ctx).delReqBills(reqIDs, mrbiPicking);
            }
            if (mrbiReturnInfo != null) {
                if (mrbiReturnInfo.getBaseStatus().getValue() == 4) {
                    MaterialReqBillFactory.getLocalInstance((Context)ctx).unAudit((IObjectPK)new ObjectUuidPK(mrbiReturnInfo.getId()));
                }
                reqIDs = new HashMap();
                reqIDs.put(mrbiReturnInfo.getId().toString(), mrbiReturnInfo.getNumber());
                MaterialTransactionPlatformFacadeFactory.getLocalInstance(ctx).delReqBills(reqIDs, mrbiReturnInfo);
            }
            ManufactureOrderSplitRecordFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(moSplitRecord.getId()));
        }
        parentInfo = iManufactureOrder.getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId()), ManufactureOrderSplitFacadeControllerBean.getSelectors());
        parentInfo.setTotalSplitQty(parentInfo.getTotalSplitQty().subtract(childInfo.getQty()));
        BigDecimal extraQty = this.calcLimitUpperQty(NumericUtil.emptyToZero(parentInfo.getExtraRatio()), parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()), this.findScale(ctx, parentInfo.getMaterial().getId().toString(), parentInfo.getUnit().getId().toString()));
        parentInfo.setExtraUpperLimit(extraQty);
        BigDecimal lackQty = this.calcLimitLowerQty(NumericUtil.emptyToZero(parentInfo.getLackRatio()), parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()), this.findScale(ctx, parentInfo.getMaterial().getId().toString(), parentInfo.getUnit().getId().toString()));
        parentInfo.setLackLowerLimit(lackQty);
        if (!parentInfo.isIsLimitedQty()) {
            parentInfo.setUnToStoreQty(parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()).subtract(parentInfo.getToStroreQty()).subtract(parentInfo.getTotalDirectSendQty()));
        } else {
            parentInfo.setUnToStoreQty(parentInfo.getExtraUpperLimit().subtract(parentInfo.getToStroreQty()).subtract(parentInfo.getTotalDirectSendQty()));
        }
        parentInfo.setUnRepairQty(parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()).subtract(parentInfo.getRepairQty()));
        parentInfo.setDeliveryQty(parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()).multiply(parentInfo.getYield()).multiply(DECIMAL_ONE_PERCENT).setScale(this.findScale(ctx, parentInfo.getMaterial().getId().toString(), parentInfo.getUnit().getId().toString()), 4));
        ManufactureOrderTechnicsCollection parentTechnics = parentInfo.getTechnics();
        Iterator iterator = parentTechnics.iterator();
        while (iterator.hasNext()) {
            ManufactureOrderTechnicsInfo parentTechnicsInfo = (ManufactureOrderTechnicsInfo)iterator.next();
            if (parentTechnicsInfo.getOperationNo() >= splitOperationNo) {
                parentTechnicsInfo.setTotalSplitQty(parentTechnicsInfo.getTotalSplitQty().subtract(childInfo.getQty()));
                parentTechnicsInfo.setTotalSplitBaseQty(this.convertQty(ctx, parentInfo.getMaterial().getId().toString(), parentTechnicsInfo.getUnit().getId().toString(), parentTechnicsInfo.getBaseUnit().getId().toString(), parentTechnicsInfo.getTotalSplitQty()));
                parentTechnicsInfo.setOperQty(parentTechnicsInfo.getQty().subtract(parentTechnicsInfo.getTotalSplitQty()));
            }
            parentTechnicsInfo.setUnDispatchQty(parentTechnicsInfo.getQty().subtract(parentTechnicsInfo.getTotalDispatchQty()).subtract(parentTechnicsInfo.getTotalSplitQty()));
            parentTechnicsInfo.setUnDispatchBaseQty(this.convertQty(ctx, parentInfo.getMaterial().getId().toString(), parentTechnicsInfo.getUnit().getId().toString(), parentTechnicsInfo.getBaseUnit().getId().toString(), parentTechnicsInfo.getUnDispatchQty()));
            parentTechnicsInfo.setTotalUpperQty(parentTechnicsInfo.getQty().subtract(parentTechnicsInfo.getTotalSplitQty()).multiply(DECIMAL_ONE.add(parentTechnicsInfo.getTotalQtyUpper().divide(DECIMAL_ONE_HANDRED, 8, 4))));
            parentTechnicsInfo.setTotalUpperBaseQty(this.convertQty(ctx, parentInfo.getMaterial().getId().toString(), parentTechnicsInfo.getUnit().getId().toString(), parentTechnicsInfo.getBaseUnit().getId().toString(), parentTechnicsInfo.getTotalUpperQty()));
            if (parentTechnicsInfo.getOperationNo() != parentInfo.getFirstOperNo() || splitOperationNo != parentInfo.getFirstOperNo()) continue;
            parentTechnicsInfo.setIntoQty(NumericUtil.emptyToZero(parentTechnicsInfo.getQty()).subtract(NumericUtil.emptyToZero(parentTechnicsInfo.getTotalSplitQty())));
            parentTechnicsInfo.setIntoBaseQty(this.convertQty(ctx, parentInfo.getMaterial().getId().toString(), parentTechnicsInfo.getUnit().getId().toString(), parentTechnicsInfo.getBaseUnit().getId().toString(), parentTechnicsInfo.getIntoQty()));
        }
        ManufactureOrderExpectOutputCollection parentExpectOutputs = parentInfo.getExpectOutputs();
        Iterator itr = parentExpectOutputs.iterator();
        block10: while (itr.hasNext()) {
            ManufactureOrderExpectOutputInfo childOutputInfo;
            Iterator iterator2;
            ManufactureOrderExpectOutputCollection expectOutputs;
            ManufactureOrderExpectOutputInfo expectoutputInfo = (ManufactureOrderExpectOutputInfo)itr.next();
            if (expectoutputInfo.getOperationNo() < splitOperationNo) continue;
            if (childInfo.getBirthType().equals((Object)MOBirthTypeEnum.SPLIT)) {
                expectOutputs = childInfo.getExpectOutputs();
                iterator2 = expectOutputs.iterator();
                while (iterator2.hasNext()) {
                    childOutputInfo = (ManufactureOrderExpectOutputInfo)iterator2.next();
                    if (!expectoutputInfo.getId().toString().equals(childOutputInfo.getSourceBillEntryId())) continue;
                    expectoutputInfo.setQty(expectoutputInfo.getQty().add(childOutputInfo.getQty()));
                    continue block10;
                }
                continue;
            }
            if (parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()).subtract(childInfo.getQty()).compareTo(DECIMAL_ZERO) == 0) {
                expectOutputs = childInfo.getExpectOutputs();
                if (parentInfo.getMaterial().equals((Object)childInfo.getMaterial())) {
                    iterator2 = expectOutputs.iterator();
                    while (iterator2.hasNext()) {
                        childOutputInfo = (ManufactureOrderExpectOutputInfo)iterator2.next();
                        if (!childOutputInfo.getMaterial().equals((Object)expectoutputInfo.getMaterial())) continue;
                        expectoutputInfo.setQty(expectoutputInfo.getQty().add(childOutputInfo.getQty()));
                        continue block10;
                    }
                    continue;
                }
                expectoutputInfo.setQty(expectoutputInfo.getQty());
                continue;
            }
            expectoutputInfo.setQty(expectoutputInfo.getQty().multiply(parentInfo.getQty().subtract(parentInfo.getTotalSplitQty())).divide(parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()).subtract(childInfo.getQty()), expectoutputInfo.getUnit().getQtyPrecision(), 4));
        }
        ManufactureOrderStockCollection parentStocks = parentInfo.getStocks();
        Iterator itStoc = parentStocks.iterator();
        while (itStoc.hasNext()) {
            ManufactureOrderStockInfo parentStockInfo = (ManufactureOrderStockInfo)itStoc.next();
            if (parentStockInfo.getOperationNo() < splitOperationNo) continue;
            this.calcStockRowQty(ctx, parentInfo.getQty().subtract(parentInfo.getTotalSplitQty()), parentInfo.getTransactionType(), parentStockInfo, childInfo);
        }
        ArrayList<String> idList = new ArrayList<String>();
        try {
            idList.clear();
            idList.add(moPK.toString());
            this.updateReqPlanData(ctx, idList, 99041);
            LotFacadeFactory.getLocalInstance((Context)ctx).manufactureOrderDeleteLotSource(new String[]{moPK.toString()});
            MOCostObjectUtil.removeCostObject(ctx, "'" + moPK.toString() + "'");
            IObjectPK logPk_del = LogUtil.beginLog((Context)ctx, (String)"delete", (BOSObjectType)this.getBOSType(), (IObjectPK)moPK, (String)childInfo.getNumber(), (String)"mm_manufactureOrder_delete");
            iManufactureOrder.deleteNoCheck(moPK);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk_del);
            iManufactureOrder.update((IObjectPK)new ObjectUuidPK(parentInfo.getId()), (CoreBaseInfo)parentInfo);
            this.updateMOBaseColumns(ctx, new String[]{parentInfo.getId().toString()});
            this.dealWithMOFinish(ctx, parentInfo.getId().toString(), false);
            idList.clear();
            idList.add(parentInfo.getId().toString());
            this.updateReqPlanData(ctx, idList, 99042);
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return "";
    }

    private void updateSourceOrderHeader(Context ctx, MOSplitTypeEnum splitType, ManufactureOrderInfo mo, BigDecimal splitQty) throws EASBizException, BOSException {
        mo.setTotalSplitQty(NumericUtil.emptyToZero(mo.getTotalSplitQty()).add(splitQty));
        mo.setTotalSplitBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), mo.getTotalSplitQty()));
        mo.setUnRepairQty(mo.getQty().subtract(mo.getTotalSplitQty()).subtract(mo.getRepairQty()));
        mo.setUnRepairBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), mo.getUnRepairQty()));
        BigDecimal extraRatio = NumericUtil.emptyToZero(mo.getExtraRatio());
        BigDecimal extraQty = this.calcLimitUpperQty(extraRatio, mo.getQty().subtract(mo.getTotalSplitQty()), this.findScale(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString()));
        mo.setExtraUpperLimit(extraQty);
        mo.setExtraUpperLimitBase(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), mo.getExtraUpperLimit()));
        BigDecimal lackRatio = NumericUtil.emptyToZero(mo.getLackRatio());
        BigDecimal lackQty = this.calcLimitLowerQty(lackRatio, mo.getQty().subtract(mo.getTotalSplitQty()), this.findScale(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString()));
        mo.setLackLowerLimit(lackQty);
        mo.setLackLowerLimitBase(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), mo.getLackLowerLimit()));
        if (!mo.isIsLimitedQty()) {
            mo.setUnToStoreQty(mo.getQty().subtract(mo.getTotalSplitQty()).subtract(mo.getToStroreQty()).subtract(mo.getTotalDirectSendQty()));
            mo.setUnToStoreBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), mo.getUnToStoreQty()));
        } else {
            mo.setUnToStoreQty(mo.getExtraUpperLimit().subtract(mo.getToStroreQty()).subtract(mo.getTotalDirectSendQty()));
            mo.setUnToStoreBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), mo.getUnToStoreQty()));
        }
        mo.setDeliveryQty(mo.getQty().subtract(mo.getTotalSplitQty()).multiply(mo.getYield()).multiply(DECIMAL_ONE_PERCENT).setScale(this.findScale(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString()), 4));
        mo.setDeliveryBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), mo.getDeliveryQty()));
    }

    private void updateSourceOrderStockEntry(Context ctx, MOSplitTypeEnum splitType, ManufactureOrderInfo mo, int oprtNo, int blocks, BigDecimal avgOrderQty, BigDecimal lastOrderQty, Map stockingRule) throws EASBizException, BOSException {
        ManufactureOrderStockCollection stocks = mo.getStocks();
        if (MOSplitTypeEnum.STANDARD.equals((Object)splitType) || MOSplitTypeEnum.REFORM.equals((Object)splitType)) {
            BigDecimal remainQty = mo.getQty().subtract(mo.getTotalSplitQty());
            int count = stocks.size();
            for (int i = 0; i < count; ++i) {
                ManufactureOrderStockInfo info = stocks.get(i);
                if (info.getPlannedQty().compareTo(DECIMAL_ZERO) == 0 || info.getPlannedBaseQty().compareTo(DECIMAL_ZERO) == 0 || info.getOperationNo() < oprtNo) continue;
                String key = info.getMaterial().getId().toString() + info.getLineSeq();
                BigDecimal oldPlanQty = info.getPlannedQty();
                info.setPlannedQty(((BigDecimal)stockingRule.get(key + SOURCE_ORDER + STOCK_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                info.setPlannedBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPlannedQty()));
                info.setOriginalPlanQty(((BigDecimal)stockingRule.get(key + SOURCE_ORDER + STOCK_ORIGINAL_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                info.setOriginalPlanBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getOriginalPlanQty()));
                info.setUnIssueQty(info.getPlannedQty().subtract(info.getActIssueQty()).add(info.getRejectedQty()));
                info.setUnIssueBaseQty(info.getPlannedBaseQty().subtract(info.getActIssueBaseQty()));
                if (info.getLineSeq() != null) {
                    info.setQty(((BigDecimal)stockingRule.get(key + SOURCE_ORDER + STOCK_QTY)).setScale(8, 4));
                    info.setBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getQty()));
                } else {
                    info.setQty(remainQty.multiply(info.getUnitQty()));
                    info.setBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getQty()));
                }
                BigDecimal lossQty = info.getPlannedQty().subtract(info.getQty());
                info.setLossQty(lossQty.signum() == -1 ? DECIMAL_ZERO : lossQty);
                info.setLossBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getLossQty()));
                BigDecimal unReceiptQty = info.getPlannedQty().subtract(info.getTotalReceiptQty());
                info.setUnReceiptQty(unReceiptQty);
                info.setUnReceiptBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getUnReceiptQty()));
                BigDecimal associateQty = info.getAssociateQty().add(info.getPlannedQty().subtract(oldPlanQty));
                info.setAssociateQty(associateQty);
                info.setPickLackQty(info.getPlannedQty().multiply(DECIMAL_ONE.subtract(info.getLackRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
                info.setPickLackBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPickLackQty()));
                info.setPickExtraQty(info.getPlannedQty().multiply(DECIMAL_ONE.add(info.getExtraRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
                info.setPickExtraBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPickExtraQty()));
            }
        }
    }

    private void updateSourceOrderTechnicsEntry(Context ctx, MOSplitTypeEnum splitType, ManufactureOrderInfo mo, int oprtNo, BigDecimal splitQty) throws EASBizException, BOSException {
        ManufactureOrderTechnicsCollection technics = mo.getTechnics();
        if (MOSplitTypeEnum.STANDARD.equals((Object)splitType) || MOSplitTypeEnum.REFORM.equals((Object)splitType)) {
            int count = technics.size();
            for (int i = 0; i < count; ++i) {
                ManufactureOrderTechnicsInfo info = technics.get(i);
                if (info.getOperationNo() >= oprtNo) {
                    info.setTotalSplitQty(NumericUtil.emptyToZero(info.getTotalSplitQty()).add(splitQty));
                    info.setTotalSplitBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), mo.getUnit().getId().toString(), mo.getBaseUnit().getId().toString(), info.getTotalSplitQty()));
                }
                BigDecimal qty = NumericUtil.emptyToZero(info.getQty());
                BigDecimal totalSplitQty = NumericUtil.emptyToZero(info.getTotalSplitQty());
                BigDecimal orderQty = qty.subtract(totalSplitQty);
                info.setOperQty(orderQty);
                BigDecimal totalDispatchQty = NumericUtil.emptyToZero(info.getTotalDispatchQty());
                info.setUnDispatchQty(orderQty.subtract(totalDispatchQty));
                info.setUnDispatchBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getUnDispatchQty()));
                if (info.getOperationNo() == mo.getFirstOperNo() && oprtNo == mo.getFirstOperNo()) {
                    info.setIntoQty(orderQty);
                    info.setIntoBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getIntoQty()));
                }
                info.setTotalUpperQty(info.getQty().subtract(info.getTotalSplitQty()).multiply(DECIMAL_ONE.add(info.getTotalQtyUpper().divide(DECIMAL_ONE_HANDRED, 8, 4))));
                info.setTotalUpperBaseQty(this.convertQty(ctx, mo.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getTotalUpperQty()));
            }
        }
    }

    private void updateSourceOrderExpectOutputEntry(Context ctx, MOSplitTypeEnum splitType, ManufactureOrderInfo mo, int oprtNo, BigDecimal splitQty) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputCollection expectOutputs = mo.getExpectOutputs();
        if (MOSplitTypeEnum.STANDARD.equals((Object)splitType) || MOSplitTypeEnum.REFORM.equals((Object)splitType)) {
            BigDecimal parentOrderQty = mo.getQty().subtract(mo.getTotalSplitQty());
            Iterator iter = expectOutputs.iterator();
            while (iter.hasNext()) {
                ManufactureOrderExpectOutputInfo outputInfo = (ManufactureOrderExpectOutputInfo)iter.next();
                if (outputInfo.getOperationNo() < oprtNo) continue;
                BigDecimal oldQty = outputInfo.getQty();
                BigDecimal oldfinishedQty = outputInfo.getFinishedQty() == null ? DECIMAL_ZERO : outputInfo.getFinishedQty();
                BigDecimal oldtoStoreQty = outputInfo.getToStoreQty() == null ? DECIMAL_ZERO : outputInfo.getToStoreQty();
                BigDecimal afterSplitExpQty = oldQty.subtract(oldQty.multiply(splitQty).divide(parentOrderQty.add(splitQty), 8, 4));
                int scale = this.findScale(ctx, outputInfo.getMaterial().getId().toString(), outputInfo.getUnit().getId().toString());
                afterSplitExpQty = afterSplitExpQty.setScale(scale, 4);
                outputInfo.setQty(afterSplitExpQty);
            }
        }
    }

    private void updateSubOrderHeader(Context ctx, MOSplitTypeEnum splitType, MaterialPlanInfo materialPlan, ManufactureOrderInfo order, int oprtNo, BomInfo bom, int idx, int blocks, BigDecimal avgOrderQty, BigDecimal lastOrderQty, ManufactureOrderInfo sourceOrder) throws EASBizException, BOSException {
        String[] keys = new String[]{"finishedQty", "finishedBaseQty", "passQty", "passBaseQty", "scrapQty", "scrapBaseQty", "repairQty", "repairBaseQty", "toStroreQty", "toStoreBaseQty", "testedQty", "testedBaseQty", "concessionQty", "concessionBaseQty", "totalSplitQty", "totalSplitBaseQty", "totalDirectSendQty", "totalDirectSendBaseQty", "actureQty", "actureBaseQty"};
        ManufactureOrderSplitFacadeControllerBean.clearUpBigDecimalFields((IObjectValue)order, keys);
        if (MOSplitTypeEnum.STANDARD.equals((Object)splitType)) {
            if (idx == blocks) {
                order.setQty(lastOrderQty);
                order.setBaseQty(this.convertQty(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString(), order.getBaseUnit().getId().toString(), order.getQty()));
            } else {
                order.setQty(avgOrderQty);
                order.setBaseQty(this.convertQty(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString(), order.getBaseUnit().getId().toString(), order.getQty()));
            }
        } else if (MOSplitTypeEnum.REFORM.equals((Object)splitType)) {
            order.setQty(avgOrderQty);
            order.setBaseQty(this.convertQty(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString(), order.getBaseUnit().getId().toString(), avgOrderQty));
            if (materialPlan != null) {
                order.setExtraRatio(NumericUtil.emptyToZero(materialPlan.getRcvInHightLimit()));
                order.setLackRatio(NumericUtil.emptyToZero(materialPlan.getRcvInLowLimit()));
            } else {
                order.setExtraRatio(DECIMAL_ONE);
                order.setLackRatio(DECIMAL_ONE);
            }
            if (order.getTransactionType() != null && order.getTransactionType().isIsWPManagement() || materialPlan != null && !materialPlan.isIsStorageLimit()) {
                order.setIsLimitedQty(false);
            } else {
                order.setIsLimitedQty(true);
            }
        }
        if (MOSplitTypeEnum.REFORM.equals((Object)splitType)) {
            BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bom.getId()));
            order.setYield(NumericUtil.emptyToZero(bomInfo.getYield()));
        } else {
            order.setYield(NumericUtil.emptyToZero(sourceOrder.getYield()));
        }
        order.setDeliveryQty(order.getQty().multiply(order.getYield()).multiply(DECIMAL_ONE_PERCENT).setScale(this.findScale(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString()), 4));
        order.setDeliveryBaseQty(this.convertQty(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString(), order.getBaseUnit().getId().toString(), order.getDeliveryQty()));
        BigDecimal extraRatio = NumericUtil.emptyToZero(order.getExtraRatio());
        BigDecimal extraQty = this.calcLimitUpperQty(extraRatio, order.getQty(), this.findScale(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString()));
        order.setExtraUpperLimit(extraQty);
        order.setExtraUpperLimitBase(this.convertQty(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString(), order.getBaseUnit().getId().toString(), order.getExtraUpperLimit()));
        BigDecimal lackRatio = NumericUtil.emptyToZero(order.getLackRatio());
        BigDecimal lackQty = this.calcLimitLowerQty(lackRatio, order.getQty(), this.findScale(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString()));
        order.setLackLowerLimit(lackQty);
        order.setLackLowerLimitBase(this.convertQty(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString(), order.getBaseUnit().getId().toString(), order.getLackLowerLimit()));
        order.setUnRepairQty(order.getQty().subtract(order.getTotalSplitQty()).subtract(order.getRepairQty()));
        order.setUnRepairBaseQty(this.convertQty(ctx, order.getMaterial().getId().toString(), order.getUnit().getId().toString(), order.getBaseUnit().getId().toString(), order.getUnRepairQty()));
        ManufactureOrderTechnicsCollection technics = order.getTechnics();
        if (technics != null && technics.size() > 0) {
            MMCommonUtils.objectValueSort((IObjectCollection)technics, (boolean)true, (String)"operationNo");
            order.setFirstOperNo(oprtNo);
            order.setLastOperNo(technics.get(technics.size() - 1).getOperationNo());
        } else {
            order.setFirstOperNo(-1);
            order.setLastOperNo(-1);
        }
    }

    private Map updateSubOrderStockEntry(Context ctx, MOSplitTypeEnum splitType, BigDecimal orderQty, ManufactureOrderStockCollection stocks, int oprtNo, int idx, int blocks, boolean isUniform, Map returnQtyGroupByMaterial, Map stockingRuleCache) throws BTPException, EASBizException, BOSException {
        HashMap<String, Object[]> pickingQtyGroupByStock = new HashMap<String, Object[]>();
        this.removeItems((IObjectCollection)stocks, oprtNo);
        MMCommonUtils.objectValueSort((IObjectCollection)stocks, (boolean)true, (String)"operationNo");
        for (int i = 0; i < stocks.size(); ++i) {
            BigDecimal available;
            ManufactureOrderStockInfo info = stocks.get(i);
            if (info == null) {
                // empty if block
            }
            if (info == null || info.getMaterial() == null) continue;
            String materialID = info.getMaterial().getId().toString();
            String key = materialID + info.getLineSeq();
            if (MOSplitTypeEnum.STANDARD.equals((Object)splitType)) {
                if (isUniform) {
                    info.setPlannedQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_AVG + STOCK_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                    info.setPlannedBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPlannedQty()));
                    info.setOriginalPlanQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_AVG + STOCK_ORIGINAL_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                    info.setOriginalPlanBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getOriginalPlanQty()));
                } else if (!isUniform) {
                    if (idx != blocks) {
                        info.setPlannedQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_AVG + STOCK_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                        info.setPlannedBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPlannedQty()));
                        info.setOriginalPlanQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_AVG + STOCK_ORIGINAL_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                        info.setOriginalPlanBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getOriginalPlanQty()));
                    } else {
                        info.setPlannedQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_LAST + STOCK_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                        info.setPlannedBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPlannedQty()));
                        info.setOriginalPlanQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_LAST + STOCK_ORIGINAL_PLAN_QTY)).setScale(this.findScale(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString()), 4));
                        info.setOriginalPlanBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getOriginalPlanQty()));
                    }
                }
            }
            if ((available = (BigDecimal)returnQtyGroupByMaterial.get(materialID)) != null && available.compareTo(DECIMAL_ZERO) > 0) {
                if (available.subtract(info.getPlannedQty()).compareTo(DECIMAL_ZERO) > 0) {
                    info.setActIssueQty(info.getPlannedQty());
                    info.setActIssueBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getActIssueQty()));
                    returnQtyGroupByMaterial.put(materialID, available.subtract(info.getPlannedQty()));
                } else {
                    info.setActIssueQty(available);
                    info.setActIssueBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getActIssueQty()));
                    returnQtyGroupByMaterial.put(materialID, DECIMAL_ZERO);
                }
                pickingQtyGroupByStock.put(info.getId().toString(), new Object[]{info.getActIssueQty(), info.getActIssueBaseQty(), materialID});
            } else {
                info.setActIssueQty(DECIMAL_ZERO);
                info.setActIssueBaseQty(DECIMAL_ZERO);
            }
            String[] keys = new String[]{"actIssueQty", "actIssueBaseQty", "rejectedQty", "rejectedBaseQty", "feedingQty", "feedingBaseQty", "materialFeedingQty", "materialFeedingBaseQty", "scrapQty", "scrapBaseQty", "materialScrapQty", "materialScrapBaseQty", "totalDirectReceiveQty", "totalDirectReceiveBaseQty", "toStoreQty", "toStoreBaseQty", "wipQty", "wipBaseQty", "totalReceiptQty", "totalReceiptBaseQty"};
            ManufactureOrderSplitFacadeControllerBean.clearUpBigDecimalFields((IObjectValue)info, keys);
            if (info.isIsReplaced()) {
                if (!isUniform && idx == blocks) {
                    info.setQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_LAST + STOCK_QTY)).setScale(8, 4));
                } else {
                    info.setQty(((BigDecimal)stockingRuleCache.get(key + SUB_ORDER_AVG + STOCK_QTY)).setScale(8, 4));
                }
                info.setBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getQty()));
            } else {
                info.setQty(orderQty.multiply(info.getUnitQty()));
                info.setBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getQty()));
            }
            BigDecimal lossQty = info.getPlannedQty().subtract(info.getQty());
            info.setLossQty(lossQty.signum() == -1 ? DECIMAL_ZERO : lossQty);
            info.setLossBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getLossQty()));
            BigDecimal unReceiptQty = info.getPlannedQty().subtract(info.getTotalReceiptQty());
            info.setUnReceiptQty(unReceiptQty);
            info.setUnReceiptBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getUnReceiptQty()));
            info.setPickLackQty(info.getPlannedQty().multiply(DECIMAL_ONE.subtract(info.getLackRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
            info.setPickLackBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPickLackQty()));
            info.setPickExtraQty(info.getPlannedQty().multiply(DECIMAL_ONE.add(info.getExtraRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
            info.setPickExtraBaseQty(this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getPickExtraQty()));
        }
        return pickingQtyGroupByStock;
    }

    private void updateSubOrderTechnicsEntry(Context ctx, MOSplitTypeEnum splitType, MaterialPlanInfo materialPlan, ManufactureOrderInfo mo, ManufactureOrderInfo order, int oprtNo, MaterialInfo materialInfo) throws EASBizException, BOSException {
        block5: {
            ManufactureOrderTechnicsCollection oldtechnics;
            ManufactureOrderTechnicsCollection technics;
            block4: {
                technics = order.getTechnics();
                oldtechnics = mo.getTechnics();
                this.removeItems((IObjectCollection)technics, oprtNo);
                if (!MOSplitTypeEnum.STANDARD.equals((Object)splitType)) break block4;
                String[] keys = new String[]{"totalSplitQty", "totalSplitBaseQty", "totalDispatchQty", "totalDispatchBaseQty", "finishedQty", "finishedBaseQty", "repReportQty", "repReportBaseQty", "intoQty", "intoBaseQty", "repMoveInQty", "repMoveInBaseQty", "outQty", "outBaseQty", "repMoveOutQty", "repMoveOutBaseQty", "testQty", "testBaseQty", "passQty", "passBaseQty", "scrapQty", "scrapBaseQty", "totalManufactureScrapQty", "totalManufactureScrapBaseQty", "totalMaterialScrapQty", "totalMaterialScrapBaseQty", "repairQty", "repairBaseQty", "concessionQty", "concessionBaseQty"};
                int count = technics.size();
                for (int i = 0; i < count; ++i) {
                    ManufactureOrderTechnicsInfo info = technics.get(i);
                    ManufactureOrderTechnicsInfo oinfo = oldtechnics.get(i);
                    ManufactureOrderSplitFacadeControllerBean.clearUpBigDecimalFields((IObjectValue)info, keys);
                    info.setQty(order.getQty());
                    info.setBaseQty(order.getBaseQty());
                    info.setOperQty(order.getQty());
                    info.setUnDispatchQty(info.getQty());
                    info.setUnDispatchBaseQty(info.getBaseQty());
                    info.setTotalUpperQty(info.getQty().multiply(DECIMAL_ONE.add(info.getTotalQtyUpper().divide(DECIMAL_ONE_HANDRED, 8, 4))));
                    info.setTotalUpperBaseQty(this.convertQty(ctx, materialInfo.getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getTotalUpperQty()));
                }
                break block5;
            }
            if (!MOSplitTypeEnum.REFORM.equals((Object)splitType)) break block5;
            int count = technics.size();
            for (int i = 0; i < count; ++i) {
                ManufactureOrderTechnicsInfo info = technics.get(i);
                ManufactureOrderTechnicsInfo oinfo = oldtechnics.get(i);
                info.setTotalSplitQty(DECIMAL_ZERO);
                info.setTotalSplitBaseQty(DECIMAL_ZERO);
                info.setQty(order.getQty());
                info.setBaseQty(order.getBaseQty());
                info.setOperQty(order.getQty());
                info.setUnDispatchQty(info.getQty());
                info.setUnDispatchBaseQty(info.getBaseQty());
                if (info.getAdminOrgUnit() == null) {
                    info.setAdminOrgUnit(order.getAdminOrgUnit());
                }
                if (info.getAdminOrgUnit() == null) {
                    info.setAdminOrgUnit(materialPlan.getDutyDepartment());
                }
                info.setTotalUpperQty(info.getQty().multiply(DECIMAL_ONE.add(info.getTotalQtyUpper().divide(DECIMAL_ONE_HANDRED, 8, 4))));
                info.setTotalUpperBaseQty(this.convertQty(ctx, materialInfo.getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), info.getTotalUpperQty()));
            }
        }
    }

    private void updateSubOrderExpectOutputEntry(Context ctx, MOSplitTypeEnum splitType, ManufactureOrderInfo beforeSplitParentMo, ManufactureOrderInfo subMo, BigDecimal splitQty, int oprtNo, boolean updateLot) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputCollection expectOutputs = subMo.getExpectOutputs();
        this.removeItems((IObjectCollection)expectOutputs, oprtNo);
        BigDecimal parentOrderQty = beforeSplitParentMo.getQty().subtract(beforeSplitParentMo.getTotalSplitQty());
        BigDecimal subQty = subMo.getQty();
        ManufactureOrderExpectOutputCollection parentExpectOutputs = beforeSplitParentMo.getExpectOutputs();
        if (MOSplitTypeEnum.STANDARD.equals((Object)splitType)) {
            int count = expectOutputs.size();
            for (int i = 0; i < count; ++i) {
                ManufactureOrderExpectOutputInfo outputInfo = expectOutputs.get(i);
                BigDecimal oldQty = outputInfo.getQty() == null ? DECIMAL_ZERO : outputInfo.getQty();
                BigDecimal oldfinishedQty = outputInfo.getFinishedQty() == null ? DECIMAL_ZERO : outputInfo.getFinishedQty();
                BigDecimal oldtoStoreQty = outputInfo.getToStoreQty() == null ? DECIMAL_ZERO : outputInfo.getToStoreQty();
                BigDecimal afterSplitExpQty = oldQty.subtract(oldQty.multiply(splitQty).divide(parentOrderQty, 8, 4));
                int scale = this.findScale(ctx, outputInfo.getMaterial().getId().toString(), outputInfo.getUnit().getId().toString());
                afterSplitExpQty = afterSplitExpQty.setScale(scale, 4);
                BigDecimal canSplitExpQty = oldQty.subtract(afterSplitExpQty);
                BigDecimal qty = canSplitExpQty.multiply(subQty.divide(splitQty, 8, 4));
                outputInfo.setQty(qty);
                outputInfo.setFinishedQty(DECIMAL_ZERO);
                outputInfo.setToStoreQty(DECIMAL_ZERO);
                outputInfo.setPassQty(DECIMAL_ZERO);
                outputInfo.setScrapQty(DECIMAL_ZERO);
                outputInfo.setRemark("");
                if (!updateLot || outputInfo.getMaterial() == null) continue;
                MaterialInventoryInfo inventoryInfo = null;
                try {
                    inventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(outputInfo.getMaterial().getId().toString(), subMo.getStorageOrgUnit().getId().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inventoryInfo != null && inventoryInfo.isIsLotNumber()) {
                    outputInfo.setLot(subMo.getLot());
                    continue;
                }
                outputInfo.setLot(null);
            }
        } else if (MOSplitTypeEnum.REFORM.equals((Object)splitType)) {
            // empty if block
        }
    }

    private static void clearUpBigDecimalFields(IObjectValue entity, String[] keys) {
        if (entity != null && keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                entity.setBigDecimal(keys[i], DECIMAL_ZERO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxSubIndex(Context ctx, String number) throws EASBizException, BOSException, SQLException {
        int n;
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber from t_mm_manufactureorder where fnumber like ");
        sql.append("'" + number + "_%'");
        IRowSet rs = null;
        int maxSubIndex = 0;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String num = rs.getString(1);
                int idx = (num = num.substring(number.length() + 1)).indexOf(95);
                if (idx >= 0) {
                    num = num.substring(0, idx);
                }
                try {
                    maxSubIndex = Math.max(maxSubIndex, Integer.parseInt(num));
                }
                catch (NumberFormatException exc) {}
            }
            n = maxSubIndex;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return n;
    }

    private void returnMaterialBasedOnPickingBills(Context ctx, List pickingBillList, Map botpReturnedMaterial, ManufactureOrderInfo mo, int oprtNo, BigDecimal splitQty, int blocks, int scale, BigDecimal avgOrderQty, BOSUuid reformChildMoID) throws EASBizException, BOSException {
        HashMap<String, Object[]> botpRt = new HashMap<String, Object[]>();
        BOSUuid childId = reformChildMoID;
        ManufactureOrderStockCollection stocks = mo.getStocks();
        MMCommonUtils.objectValueSort((IObjectCollection)stocks, (boolean)true, (String)"lineSeq");
        Set stockIdSet = botpReturnedMaterial.keySet();
        for (MaterialReqBillInfo billInfo : pickingBillList) {
            BOSUuid pickId = billInfo.getId();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entry.*"));
            sic.add(new SelectorItemInfo("entry.material.*"));
            billInfo = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(pickId), sic);
            childId = BOSUuid.read((String)billInfo.getSourceBillId());
            MaterialReqBillEntryCollection entrys = billInfo.getEntry();
            botpRt.clear();
            block1: for (MaterialReqBillEntryInfo entry : entrys) {
                MaterialInfo material = entry.getMaterial();
                BigDecimal qty = NumericUtil.emptyToZero(entry.getQty());
                Iterator itStock = stocks.iterator();
                while (itStock.hasNext()) {
                    ManufactureOrderStockInfo stock = (ManufactureOrderStockInfo)itStock.next();
                    String stockId = stock.getId().toString();
                    if (!stock.getMaterial().getId().toString().equalsIgnoreCase(material.getId().toString()) || stock.getOperationNo() != entry.getOperationNo() || !stockIdSet.contains(stockId)) continue;
                    Object[] array = (Object[])botpReturnedMaterial.get(stockId);
                    BigDecimal availableQty = (BigDecimal)array[0];
                    BigDecimal availableBaseQty = (BigDecimal)array[1];
                    String strMaterialID = (String)array[2];
                    if (DECIMAL_ZERO.compareTo(availableQty) >= 0) continue;
                    if (qty.compareTo(availableQty) <= 0) {
                        botpRt.put(stock.getId().toString(), new Object[]{qty, this.convertQty(ctx, stock.getMaterial().getId().toString(), stock.getUnit().getId().toString(), stock.getBaseUnit().getId().toString(), qty), strMaterialID});
                        botpReturnedMaterial.put(stock.getId().toString(), new Object[]{availableQty.subtract(qty), this.convertQty(ctx, stock.getMaterial().getId().toString(), stock.getUnit().getId().toString(), stock.getBaseUnit().getId().toString(), availableQty.subtract(qty)), strMaterialID});
                        continue block1;
                    }
                    botpRt.put(stock.getId().toString(), new Object[]{availableQty, availableBaseQty, strMaterialID});
                    botpReturnedMaterial.put(stock.getId().toString(), new Object[]{DECIMAL_ZERO, DECIMAL_ZERO, strMaterialID});
                    qty = qty.subtract(availableQty);
                }
            }
            BTPTransformResult botpResult = null;
            botpResult = reformChildMoID == null ? ManufactureOrderSplitFacadeControllerBean.returnMaterialByMOSplit(ctx, null, mo, botpRt, true) : ManufactureOrderSplitFacadeControllerBean.returnMaterialByMOSplit(ctx, null, mo, botpRt, false);
            if (botpResult == null) continue;
            MaterialReqBillInfo bill = (MaterialReqBillInfo)botpResult.getBills().getObject(0);
            this.saveMOSplitRecord(ctx, mo.getId(), childId, pickId, bill.getId(), oprtNo, splitQty, blocks, scale, avgOrderQty);
        }
        HashMap<String, Object[]> botpRt2 = new HashMap<String, Object[]>();
        Iterator itStock = stocks.iterator();
        while (itStock.hasNext()) {
            ManufactureOrderStockInfo stock = (ManufactureOrderStockInfo)itStock.next();
            String stockId = stock.getId().toString();
            if (!stockIdSet.contains(stockId)) continue;
            Object[] array = (Object[])botpReturnedMaterial.get(stockId);
            BigDecimal availableQty = (BigDecimal)array[0];
            BigDecimal availableBaseQty = (BigDecimal)array[1];
            String strMaterialID = (String)array[2];
            if (DECIMAL_ZERO.compareTo(availableQty) >= 0) continue;
            botpRt2.put(stock.getId().toString(), new Object[]{availableQty, availableBaseQty, strMaterialID});
        }
        BTPTransformResult botpResult2 = ManufactureOrderSplitFacadeControllerBean.returnMaterialByMOSplit(ctx, null, mo, botpRt2, false);
        if (botpResult2 != null) {
            MaterialReqBillInfo bill2 = (MaterialReqBillInfo)botpResult2.getBills().getObject(0);
            if (childId != null) {
                this.saveMOSplitRecord(ctx, mo.getId(), childId, null, bill2.getId(), oprtNo, splitQty, blocks, scale, avgOrderQty);
            }
        }
    }

    private Map cacheStockingRule(Context ctx, MOSplitTypeEnum splitType, ManufactureOrderInfo mo, int oprtNo, int blocks, BigDecimal splitQty, BigDecimal avgOrderQty, BigDecimal lastOrderQty) throws EASBizException, BOSException {
        HashMap<String, Serializable> STOCKING_RULE_CACHE = new HashMap<String, Serializable>();
        HashMap MAP_GROUP_BY_STOCK = new HashMap();
        HashMap MAP_GROUP_BY_MATERIAL = new HashMap();
        BigDecimal billQty = NumericUtil.emptyToZero(mo.getQty());
        BigDecimal totalSplitQty = NumericUtil.emptyToZero(mo.getTotalSplitQty());
        BigDecimal qty = billQty.subtract(totalSplitQty);
        boolean isUniform = blocks == 1 || avgOrderQty.compareTo(lastOrderQty) == 0;
        ManufactureOrderStockCollection stocks = mo.getStocks();
        MMCommonUtils.objectValueSort((IObjectCollection)stocks, (boolean)true, (String)"operationNo");
        if (MOSplitTypeEnum.REFORM.equals((Object)splitType) || MOSplitTypeEnum.STANDARD.equals((Object)splitType) && isUniform) {
            for (int i = 0; i < stocks.size(); ++i) {
                ManufactureOrderStockInfo info = stocks.get(i);
                if (info.getPlannedQty().compareTo(DECIMAL_ZERO) == 0 || info.getPlannedBaseQty().compareTo(DECIMAL_ZERO) == 0) continue;
                String key = info.getMaterial().getId().toString() + info.getLineSeq();
                BigDecimal planQty = NumericUtil.emptyToZero(info.getPlannedQty());
                BigDecimal planQtyStockingRatio = planQty.divide(qty, 8, 4);
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_PLAN_QTY + RATIO, planQtyStockingRatio);
                BigDecimal originalPlanQty = NumericUtil.emptyToZero(info.getOriginalPlanQty());
                BigDecimal originalPlanQtyStockingRatio = originalPlanQty.divide(qty, 8, 4);
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_ORIGINAL_PLAN_QTY + RATIO, originalPlanQtyStockingRatio);
                BigDecimal subPlanQty = avgOrderQty.multiply(planQtyStockingRatio).setScale(8, 4);
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_AVG + STOCK_PLAN_QTY, subPlanQty);
                BigDecimal subOriginalPlanQty = avgOrderQty.multiply(originalPlanQtyStockingRatio).setScale(8, 4);
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_AVG + STOCK_ORIGINAL_PLAN_QTY, subOriginalPlanQty);
                BigDecimal remainPlanQty = info.getPlannedQty().subtract(subPlanQty.multiply(new BigDecimal(String.valueOf(blocks))));
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_PLAN_QTY, remainPlanQty);
                BigDecimal remainOriginalPlanQty = info.getOriginalPlanQty().subtract(subOriginalPlanQty.multiply(new BigDecimal(String.valueOf(blocks))));
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_ORIGINAL_PLAN_QTY, remainOriginalPlanQty);
                BigDecimal remainQty = info.getQty().multiply(remainPlanQty).setScale(8, 4).divide(planQty, 8, 4);
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_QTY, remainQty);
                BigDecimal subQty = info.getQty().multiply(subPlanQty).setScale(8, 4).divide(planQty, 8, 4);
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_AVG + STOCK_QTY, subQty);
                if (info.getOperationNo() < oprtNo) continue;
                this.cacheReturnedMaterialByOneStock(ctx, info, remainPlanQty, MAP_GROUP_BY_STOCK, MAP_GROUP_BY_MATERIAL);
            }
        } else if (MOSplitTypeEnum.STANDARD.equals((Object)splitType) && !isUniform) {
            for (int i = 0; i < stocks.size(); ++i) {
                ManufactureOrderStockInfo info = stocks.get(i);
                if (info.getPlannedQty().compareTo(DECIMAL_ZERO) == 0 || info.getPlannedBaseQty().compareTo(DECIMAL_ZERO) == 0) continue;
                String key = info.getMaterial().getId().toString() + info.getLineSeq();
                BigDecimal planQty = NumericUtil.emptyToZero(info.getPlannedQty());
                BigDecimal planQtyStockingRatio = planQty.divide(qty, 8, 1);
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_PLAN_QTY + RATIO, planQtyStockingRatio);
                BigDecimal originalPlanQty = NumericUtil.emptyToZero(info.getOriginalPlanQty());
                BigDecimal originalPlanQtyStockingRatio = originalPlanQty.divide(qty, 8, 1);
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_ORIGINAL_PLAN_QTY + RATIO, originalPlanQtyStockingRatio);
                BigDecimal subAvgPlanQty = avgOrderQty.multiply(planQtyStockingRatio).setScale(this.SPLIT_SCALE, 1);
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_AVG + STOCK_PLAN_QTY, subAvgPlanQty);
                BigDecimal subAvgOriginalPlanQty = avgOrderQty.multiply(originalPlanQtyStockingRatio).setScale(this.SPLIT_SCALE, 1);
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_AVG + STOCK_ORIGINAL_PLAN_QTY, subAvgOriginalPlanQty);
                BigDecimal subLastPlanQty = NumericUtil.emptyToZero(splitQty.multiply(planQtyStockingRatio)).subtract(subAvgPlanQty.multiply(new BigDecimal(String.valueOf(blocks - 1))).setScale(this.SPLIT_SCALE, 4));
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_LAST + STOCK_PLAN_QTY, subLastPlanQty);
                BigDecimal subLastOriginalPlanQty = NumericUtil.emptyToZero(splitQty.multiply(originalPlanQtyStockingRatio)).subtract(subAvgOriginalPlanQty.multiply(new BigDecimal(String.valueOf(blocks - 1))).setScale(this.SPLIT_SCALE, 4));
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_LAST + STOCK_ORIGINAL_PLAN_QTY, subLastOriginalPlanQty);
                BigDecimal remainPlanQty = NumericUtil.emptyToZero(info.getPlannedQty()).subtract(subLastPlanQty).subtract(subAvgPlanQty.multiply(new BigDecimal(String.valueOf(blocks - 1))));
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_PLAN_QTY, remainPlanQty);
                BigDecimal remainOriginalPlanQty = NumericUtil.emptyToZero(info.getOriginalPlanQty()).subtract(subLastOriginalPlanQty).subtract(subAvgOriginalPlanQty.multiply(new BigDecimal(String.valueOf(blocks - 1))));
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_ORIGINAL_PLAN_QTY, remainOriginalPlanQty);
                BigDecimal remainQty = info.getQty().multiply(remainPlanQty).setScale(8, 4).divide(planQty, 8, 4);
                STOCKING_RULE_CACHE.put(key + SOURCE_ORDER + STOCK_QTY, remainQty);
                BigDecimal subQty = info.getQty().multiply(subAvgPlanQty).setScale(8, 4).divide(planQty, 8, 4);
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_AVG + STOCK_QTY, subQty);
                BigDecimal subLastQty = NumericUtil.emptyToZero(info.getQty().subtract(remainQty).subtract(subQty.multiply(new BigDecimal(String.valueOf(blocks - 1)))));
                STOCKING_RULE_CACHE.put(key + SUB_ORDER_LAST + STOCK_QTY, subLastQty);
                if (info.getOperationNo() < oprtNo) continue;
                this.cacheReturnedMaterialByOneStock(ctx, info, remainPlanQty, MAP_GROUP_BY_STOCK, MAP_GROUP_BY_MATERIAL);
            }
        }
        STOCKING_RULE_CACHE.put(RETURNED_MATERIAL_GROUP_BY_STOCK, MAP_GROUP_BY_STOCK);
        STOCKING_RULE_CACHE.put(RETURNED_MATERIAL_GROUP_BY_MATERIAL, MAP_GROUP_BY_MATERIAL);
        return STOCKING_RULE_CACHE;
    }

    private void cacheReturnedMaterialByOneStock(Context ctx, ManufactureOrderStockInfo info, BigDecimal remainPlanQty, Map returnQtyGroupByStock, Map returnQtyGroupByMaterial) throws EASBizException, BOSException {
        String materialID = info.getMaterial().getId().toString();
        BigDecimal actIssueQty = NumericUtil.emptyToZero(info.getActIssueQty()).subtract(remainPlanQty);
        BigDecimal rejectedQty = NumericUtil.emptyToZero(info.getRejectedQty());
        BigDecimal scrapQty = NumericUtil.emptyToZero(info.getScrapQty());
        BigDecimal materialScrapQty = NumericUtil.emptyToZero(info.getMaterialScrapQty());
        BigDecimal feedingQty = NumericUtil.emptyToZero(info.getFeedingQty());
        BigDecimal materialFeedingQty = NumericUtil.emptyToZero(info.getMaterialFeedingQty());
        BigDecimal retQty = actIssueQty.subtract(rejectedQty).subtract(scrapQty).subtract(materialScrapQty).add(feedingQty).add(materialFeedingQty);
        if (retQty.compareTo(DECIMAL_ZERO) > 0) {
            BigDecimal retBaseQty = this.convertQty(ctx, info.getMaterial().getId().toString(), info.getUnit().getId().toString(), info.getBaseUnit().getId().toString(), retQty);
            returnQtyGroupByStock.put(info.getId().toString(), new Object[]{retQty, retBaseQty, materialID});
            if (returnQtyGroupByMaterial.get(materialID) == null) {
                returnQtyGroupByMaterial.put(materialID, retQty);
            } else {
                BigDecimal current = (BigDecimal)returnQtyGroupByMaterial.get(materialID);
                returnQtyGroupByMaterial.put(materialID, current.add(retQty));
            }
        }
    }

    private ManufactureOrderInfo cloneSourceOrder(ManufactureOrderInfo mo, boolean createStcoks, boolean createTechnics, boolean createExpectOutput) {
        int count;
        ManufactureOrderInfo order = (ManufactureOrderInfo)mo.clone();
        order.setId(BOSUuid.create((BOSObjectType)order.getBOSType()));
        if (createStcoks) {
            ManufactureOrderStockCollection stocks = order.getStocks();
            LinkedList<ManufactureOrderStockInfo> unCloneMoStocks = new LinkedList<ManufactureOrderStockInfo>();
            if (stocks != null && stocks.size() > 0) {
                int count2 = stocks.size();
                for (int i = 0; i < count2; ++i) {
                    ManufactureOrderStockInfo moStock = stocks.get(i);
                    if (moStock.getPlannedQty().compareTo(DECIMAL_ZERO) == 0 || moStock.getPlannedBaseQty().compareTo(DECIMAL_ZERO) == 0) {
                        unCloneMoStocks.add(moStock);
                        continue;
                    }
                    BOSUuid oldEntryId = stocks.get(i).getId();
                    stocks.get(i).setId(BOSUuid.create((BOSObjectType)stocks.get(0).getBOSType()));
                    stocks.get(i).setParent(order);
                    stocks.get(i).setSourceBillEntryId(oldEntryId == null ? "" : oldEntryId.toString());
                }
                if (unCloneMoStocks != null && unCloneMoStocks.size() > 0) {
                    for (int j = 0; j < unCloneMoStocks.size(); ++j) {
                        stocks.remove((ManufactureOrderStockInfo)unCloneMoStocks.get(j));
                    }
                }
            }
        } else {
            order.getStocks().clear();
        }
        if (createTechnics) {
            ManufactureOrderTechnicsCollection technics = order.getTechnics();
            if (technics != null && technics.size() > 0) {
                count = technics.size();
                for (int i = 0; i < count; ++i) {
                    technics.get(i).setId(BOSUuid.create((BOSObjectType)technics.get(0).getBOSType()));
                    technics.get(i).setParent(order);
                }
            }
        } else {
            order.getTechnics().clear();
        }
        if (createExpectOutput) {
            ManufactureOrderExpectOutputCollection outputs = order.getExpectOutputs();
            if (outputs != null && outputs.size() > 0) {
                count = outputs.size();
                for (int i = 0; i < count; ++i) {
                    BOSUuid oldEntryId = outputs.get(i).getId();
                    outputs.get(i).setId(BOSUuid.create((BOSObjectType)outputs.get(0).getBOSType()));
                    outputs.get(i).setParent(order);
                    outputs.get(i).setSourceBillEntryId(oldEntryId == null ? "" : oldEntryId.toString());
                }
            }
        } else {
            order.getExpectOutputs().clear();
        }
        return order;
    }

    private void removeItems(IObjectCollection cols, int oprtNo) {
        Iterator iter = cols.iterator();
        while (iter.hasNext()) {
            IObjectValue obj = (IObjectValue)iter.next();
            Integer oprt = (Integer)obj.get("operationNo");
            if (oprt == null || oprt >= oprtNo) continue;
            iter.remove();
        }
    }

    private int findScale(Context ctx, String material, String unit) throws EASBizException, BOSException {
        if (material == null || unit == null) {
            throw new UnsupportedOperationException();
        }
        String key = material + unit;
        if (this.unitScaleLut.get(key) != null) {
            Integer scale = (Integer)this.unitScaleLut.get(key);
            return scale;
        }
        int scale = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getQtyPrecision(material, unit);
        this.unitScaleLut.put(key, new Integer(scale));
        return scale;
    }

    private BigDecimal convertQty(Context ctx, String material, String currentUnit, String targetUnit, BigDecimal qty) throws BOSException, EASBizException {
        if (material == null || currentUnit == null || targetUnit == null || qty == null) {
            throw new UnsupportedOperationException();
        }
        if (currentUnit.equals(targetUnit)) {
            return qty;
        }
        BigDecimal targetQty = null;
        String mct = material + currentUnit + targetUnit;
        String mc = material + currentUnit;
        String mt = material + targetUnit;
        BigDecimal rate = (BigDecimal)this.unitConvRateLut.get(mct);
        Integer scale = (Integer)this.unitScaleLut.get(mt);
        if (rate == null) {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitInfo currentMultiUnitInfo = multiUnit.getMultiUnit(material, currentUnit);
            MultiMeasureUnitInfo targetMultiUnitInfo = multiUnit.getMultiUnit(material, targetUnit);
            if (currentMultiUnitInfo != null && targetMultiUnitInfo != null) {
                BigDecimal currentBaseExchangeRate = currentMultiUnitInfo.getBaseConvsRate();
                BigDecimal targetBaseExchangeRate = targetMultiUnitInfo.getBaseConvsRate();
                if (currentBaseExchangeRate == null) {
                    currentBaseExchangeRate = DECIMAL_ONE;
                }
                if (targetBaseExchangeRate == null) {
                    targetBaseExchangeRate = DECIMAL_ONE;
                }
                int currentMultiUnitScale = currentMultiUnitInfo.getQtyPrecision();
                this.unitScaleLut.put(mc, new Integer(currentMultiUnitScale));
                int targetMultiUnitScale = targetMultiUnitInfo.getQtyPrecision();
                this.unitScaleLut.put(mt, new Integer(targetMultiUnitScale));
                rate = currentBaseExchangeRate.divide(targetBaseExchangeRate, 8, 4);
                this.unitConvRateLut.put(mct, rate);
                targetQty = qty.multiply(rate).setScale(targetMultiUnitScale, 4);
            }
        } else if (scale != null) {
            targetQty = qty.multiply(rate).setScale((int)scale, 4);
        }
        return targetQty;
    }

    private Map buildEntries(Context ctx, Map param, ManufactureOrderInfo order) throws BOSException, EASBizException {
        int i;
        int count;
        HashMap<String, AbstractObjectCollection> retval = new HashMap<String, AbstractObjectCollection>();
        param.put("IsRoutingChange", new Boolean(true));
        param.put("IsBOMChange", new Boolean(true));
        MOUntil.getDefaultRouting(ctx, order.getMaterial().getId().toString(), order.getStorageOrgUnit().getId().toString(), order.getTransactionType(), param, null);
        ManufactureOrderTechnicsCollection technics = ManufactureOrderFactory.getLocalInstance(ctx).routingExpand(param);
        ManufactureOrderStockCollection stocks = ManufactureOrderFactory.getLocalInstance(ctx).bomExpand(param);
        ManufactureOrderExpectOutputCollection expectOutputs = (ManufactureOrderExpectOutputCollection)((Object)ManufactureOrderFactory.getLocalInstance(ctx).getMaterialRelationData(param, false).get("EXPECTOUTPUTS"));
        if (stocks != null && stocks.size() > 0) {
            count = stocks.size();
            for (i = 0; i < count; ++i) {
                stocks.get(i).setId(BOSUuid.create((BOSObjectType)stocks.get(0).getBOSType()));
                stocks.get(i).setParent(order);
            }
        }
        if (technics != null && technics.size() > 0) {
            count = technics.size();
            for (i = 0; i < count; ++i) {
                technics.get(i).setId(BOSUuid.create((BOSObjectType)technics.get(0).getBOSType()));
                technics.get(i).setParent(order);
            }
        }
        if (expectOutputs != null && expectOutputs.size() > 0) {
            count = expectOutputs.size();
            for (i = 0; i < count; ++i) {
                expectOutputs.get(i).setId(BOSUuid.create((BOSObjectType)expectOutputs.get(0).getBOSType()));
                expectOutputs.get(i).setParent(order);
            }
        }
        retval.put("TECHNICS", technics);
        retval.put("EXPECTOUTPUTS", expectOutputs);
        if (stocks != null) {
            stocks = this.getDistinctStocks(stocks);
        }
        retval.put("STOCK", stocks);
        return retval;
    }

    private ManufactureOrderStockCollection getDistinctStocks(ManufactureOrderStockCollection stocks) {
        ManufactureOrderStockCollection newStocks = new ManufactureOrderStockCollection();
        HashMap<String, ManufactureOrderStockInfo> stocksMap = new HashMap<String, ManufactureOrderStockInfo>();
        ManufactureOrderStockInfo stockInfo = null;
        String key2 = null;
        Iterator iter = stocks.iterator();
        while (iter.hasNext()) {
            stockInfo = (ManufactureOrderStockInfo)iter.next();
            key2 = this.getRecKeyString((IObjectValue)stockInfo);
            if (stocksMap.containsKey(key2)) {
                ManufactureOrderStockInfo existStockInfo = (ManufactureOrderStockInfo)stocksMap.get(key2);
                existStockInfo.setUnitBaseQty(existStockInfo.getUnitBaseQty().add(stockInfo.getUnitBaseQty()));
                existStockInfo.setUnitQty(existStockInfo.getUnitQty().add(stockInfo.getUnitQty()));
                existStockInfo.setBaseQty(existStockInfo.getBaseQty().add(stockInfo.getBaseQty()));
                existStockInfo.setQty(existStockInfo.getQty().add(stockInfo.getQty()));
                existStockInfo.setPlannedBaseQty(existStockInfo.getPlannedBaseQty().add(stockInfo.getPlannedBaseQty()));
                existStockInfo.setPlannedQty(existStockInfo.getPlannedQty().add(stockInfo.getPlannedQty()));
                existStockInfo.setLossBaseQty(existStockInfo.getLossBaseQty().add(stockInfo.getLossBaseQty()));
                existStockInfo.setLossQty(existStockInfo.getLossQty().add(stockInfo.getLossQty()));
                existStockInfo.setPickExtraBaseQty(existStockInfo.getPickExtraBaseQty().add(stockInfo.getPickExtraBaseQty()));
                existStockInfo.setPickExtraQty(existStockInfo.getPickExtraQty().add(stockInfo.getPickExtraQty()));
                existStockInfo.setPickLackBaseQty(existStockInfo.getPickLackBaseQty().add(stockInfo.getPickLackBaseQty()));
                existStockInfo.setPickLackQty(existStockInfo.getPickLackQty().add(stockInfo.getPickLackQty()));
                continue;
            }
            stocksMap.put(key2, stockInfo);
        }
        for (String key2 : stocksMap.keySet()) {
            newStocks.add((ManufactureOrderStockInfo)stocksMap.get(key2));
        }
        return newStocks;
    }

    public String getRecKeyString(IObjectValue model) {
        String recKey = "";
        MaterialInfo materialInfo = (MaterialInfo)model.get("material");
        int operationNo = model.getInt("operationNo");
        recKey = materialInfo != null ? materialInfo.getId().toString() : "MATERIAL_NULL";
        recKey = recKey + "!";
        recKey = recKey + operationNo;
        return recKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateLot(Context ctx, ManufactureOrderInfo order, MOSplitTypeEnum type, MOSplitLotModeEnum mode, String customizedLot, String originalLot) throws BOSException, EASBizException {
        MaterialInfo material = order.getMaterial();
        StorageOrgUnitInfo storageOrgUnit = order.getStorageOrgUnit();
        MaterialInventoryInfo inventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(material.getId().toString(), storageOrgUnit.getId().toString());
        if (inventoryInfo != null && inventoryInfo.isIsLotNumber()) {
            if (MOSplitLotModeEnum.GENERATE_BY_RULE.equals((Object)mode)) {
                if (MOSplitTypeEnum.STANDARD.equals((Object)type)) {
                    LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrameExtend(material.getId().toString(), storageOrgUnit.getId().toString());
                    if (lotFrame == null || lotFrame.getLotRule() == null) throw new ManufactureOrderSplitException(ManufactureOrderSplitException.UNSUPPORTED_LOT_OPERATION);
                    LotFrameManu lotFrameManu = new LotFrameManu();
                    lotFrameManu.setSeq(lotFrame.getSeq());
                    lotFrameManu.setSysDate(lotFrame.getSysDate());
                    lotFrameManu.setCurrentSerial(lotFrame.getCurrentSerial());
                    lotFrameManu.setMainBizOrg(storageOrgUnit.getNumber());
                    lotFrameManu.setMaterial(material.getNumber());
                    lotFrameManu.setBillNumber(order.getNumber());
                    lotFrameManu.setBizDate(order.getBizDate());
                    lotFrameManu.setMfg((Date)order.getPlanEndDate());
                    lotFrameManu.setLotRule(lotFrame.getLotRule());
                    order.setLot(lotFrameManu.getLotNumber());
                    return;
                } else {
                    if (!MOSplitTypeEnum.REFORM.equals((Object)type)) return;
                    if (StringUtils.isEmpty((String)customizedLot)) {
                        throw new ManufactureOrderSplitException(ManufactureOrderSplitException.UNSUPPORTED_LOT_OPERATION);
                    }
                    order.setLot(customizedLot);
                }
                return;
            } else if (MOSplitLotModeEnum.GENERATE_BY_SOURCE.equals((Object)mode)) {
                order.setLot(originalLot);
                return;
            } else {
                if (mode != null) return;
                order.setLot(null);
            }
            return;
        } else {
            order.setLot(null);
        }
    }

    private static boolean isAllWorkDatesValid(Context ctx, StorageOrgUnitInfo storage, Date[] dateArray) throws EASBizException, BOSException {
        if (dateArray == null) {
            throw new IllegalArgumentException("date array must not be null");
        }
        IFactoryCalendar biz = FactoryCalendarFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < dateArray.length; ++i) {
            Date date = dateArray[i];
            if (date != null && biz.isWorkDay(storage.getId().toString(), date)) continue;
            return false;
        }
        return true;
    }

    private static Date getDateAfterDays(Context ctx, StorageOrgUnitInfo storage, Date base, int days) throws BOSException, EASBizException {
        return FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storage.getId().toString(), base, 1, days, 2);
    }

    private static int getWorkDays(Context ctx, StorageOrgUnitInfo storage, Date start, Date end) throws EASBizException, BOSException {
        int workDays = 0;
        Map map = FactoryCalendarFactory.getLocalInstance((Context)ctx).isWorkDay(storage.getId().toString(), start, end);
        Collection values = map.values();
        for (Boolean flag : values) {
            if (flag == null || !flag.booleanValue()) continue;
            ++workDays;
        }
        return workDays;
    }

    private BigDecimal calcLimitUpperQty(BigDecimal extraRatio, BigDecimal qty, int scale) {
        extraRatio = DECIMAL_ONE.add(extraRatio.divide(DECIMAL_ONE_HANDRED, 8, 4));
        BigDecimal extraQty = qty.multiply(extraRatio).setScale(scale, 4);
        return extraQty;
    }

    private BigDecimal calcLimitLowerQty(BigDecimal lackRatio, BigDecimal qty, int scale) {
        lackRatio = DECIMAL_ONE.subtract(lackRatio.divide(DECIMAL_ONE_HANDRED, 8, 4));
        BigDecimal lackQty = qty.multiply(lackRatio).setScale(scale, 4);
        return lackQty;
    }

    private BTPTransformResult pickingMaterialByMOSplit(Context ctx, String botpID, ManufactureOrderInfo moInfo, Map valuesMap, ManufactureOrderInfo parentMoInfo) throws BTPException, EASBizException, BOSException {
        String transBotpID = StringUtils.isEmpty((String)botpID) ? "CVPhWcPgSICOFg4HR3y/9gRRIsQ=" : botpID;
        HashMap changeValMap = new HashMap();
        Map hisMap = ManufactureOrderSplitFacadeControllerBean.getBtpHisMaterialReqBill(ctx, parentMoInfo);
        for (String stockID : valuesMap.keySet()) {
            Object[] values = (Object[])valuesMap.get(stockID);
            if (values == null || values.length <= 0) continue;
            HashMap<String, Object> tmpmap = new HashMap<String, Object>();
            tmpmap.put("UnIssueQty", values[0]);
            tmpmap.put("UnBaseIssueQty", values[1]);
            String strMaterialID = (String)values[2];
            ArrayList materialAry = (ArrayList)hisMap.get(strMaterialID);
            if (materialAry != null && materialAry.size() > 0) {
                Object[] mm = (Object[])materialAry.get(0);
                tmpmap.put("lot", (String)mm[1]);
                tmpmap.put("warehs", (WarehouseInfo)mm[2]);
                tmpmap.put("location", (LocationInfo)mm[3]);
                tmpmap.put("mfg", (Date)mm[4]);
                tmpmap.put("exp", (Date)mm[5]);
            }
            changeValMap.put(stockID, tmpmap);
        }
        BTPTransformResult btpTransFormResult = ManufactureOrderSplitFacadeControllerBean.mapppingBillByBOTP(ctx, transBotpID, (IObjectPK)new ObjectUuidPK(moInfo.getId()), changeValMap, false);
        return btpTransFormResult;
    }

    private static BTPTransformResult returnMaterialByMOSplit(Context ctx, String botpID, ManufactureOrderInfo moInfo, Map valuesMap, boolean isNeedAudit) throws BTPException, EASBizException, BOSException {
        String transBotpID = StringUtils.isEmpty((String)botpID) ? "0EU0FgugSrmA0vSxBJ7IJARRIsQ=" : botpID;
        HashMap changeValMap = new HashMap();
        Map hisMap = ManufactureOrderSplitFacadeControllerBean.getBtpHisMaterialReqBill(ctx, moInfo);
        for (String stockID : valuesMap.keySet()) {
            Object[] values = (Object[])valuesMap.get(stockID);
            if (values == null || values.length <= 0) continue;
            HashMap<String, Object> tmpmap = new HashMap<String, Object>();
            tmpmap.put("UnIssueQty", ((BigDecimal)values[0]).negate());
            tmpmap.put("UnBaseIssueQty", ((BigDecimal)values[1]).negate());
            String strMaterialID = (String)values[2];
            ArrayList materialAry = (ArrayList)hisMap.get(strMaterialID);
            if (materialAry != null && materialAry.size() > 0) {
                Object[] mm = (Object[])materialAry.get(0);
                tmpmap.put("lot", (String)mm[1]);
                tmpmap.put("warehs", (WarehouseInfo)mm[2]);
                tmpmap.put("location", (LocationInfo)mm[3]);
                tmpmap.put("mfg", (Date)mm[4]);
                tmpmap.put("exp", (Date)mm[5]);
            }
            changeValMap.put(stockID, tmpmap);
        }
        BTPTransformResult btpTransFormResult = ManufactureOrderSplitFacadeControllerBean.mapppingBillByBOTP(ctx, transBotpID, (IObjectPK)new ObjectUuidPK(moInfo.getId()), changeValMap, isNeedAudit);
        return btpTransFormResult;
    }

    private static Map getBtpHisMaterialReqBill(Context ctx, ManufactureOrderInfo moInfo) throws BOSException, BTPException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.transactionType.riType.bizDirection", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)moInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("coreBillID", (Object)moInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orderNumber", (Object)moInfo.getNumber(), CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1 and (#2 or #3) and #4");
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("parent.auditTime"));
        viewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("parent.auditTime"));
        viewInfo.setSorter(sorter);
        IMaterialReqBillEntry materialReqEntryBiz = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx);
        MaterialReqBillEntryCollection materialReqBillEntryCollection = materialReqEntryBiz.getMaterialReqBillEntryCollection(viewInfo);
        HashMap<String, ArrayList<Object[]>> mmap = new HashMap<String, ArrayList<Object[]>>();
        for (MaterialReqBillEntryInfo entryInfo : materialReqBillEntryCollection) {
            MaterialReqBillInfo billInfo = entryInfo.getParent();
            MaterialInfo material = entryInfo.getMaterial();
            if (entryInfo.getQty() != null && entryInfo.getQty().compareTo(DECIMAL_ZERO) == 0) continue;
            Object[] mm = new Object[]{entryInfo.getQty(), entryInfo.getLot(), entryInfo.getWarehouse() == null ? entryInfo.getSupplyWarehouse() : entryInfo.getWarehouse(), entryInfo.getLocation() == null ? entryInfo.getSupplyLocation() : entryInfo.getLocation(), entryInfo.getMfg(), entryInfo.getExp(), billInfo.getAuditTime()};
            ArrayList<Object[]> materialAry = (ArrayList<Object[]>)mmap.get(material.getId().toString());
            if (materialAry == null) {
                materialAry = new ArrayList<Object[]>();
            }
            materialAry.add(mm);
            mmap.put(material.getId().toString(), materialAry);
        }
        return mmap;
    }

    private static BTPTransformResult mapppingBillByBOTP(Context ctx, String botpID, IObjectPK moPK, Map valuesMap, boolean isNeedAudit) throws BOSException, BTPException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        ManufactureOrderInfo moInfo = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderInfo(moPK, sic);
        String MATERIALREQ_BOSTYPE = "500AB75E";
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
        IMaterialReqBill materialReqBiz = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpID)));
        }
        catch (Exception e) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new PlanOrderException(PlanOrderException.RELEASE_BOTP_NOT_EFFECTED);
        }
        CoreBillBaseCollection sourceCBC = new CoreBillBaseCollection();
        ManufactureOrderStockCollection stocks = moInfo.getStocks();
        for (int j = 0; j < stocks.size(); ++j) {
            boolean flag = false;
            ManufactureOrderStockInfo stock = stocks.get(j);
            HashMap entrymap = (HashMap)valuesMap.get(stock.getId().toString());
            if (entrymap != null && entrymap.size() > 0) {
                Date mfg;
                if (entrymap.get("lot") != null) {
                    String lot = (String)entrymap.get("lot");
                    stock.put("lot", lot);
                } else {
                    stock.put("lot", null);
                }
                if (entrymap.get("mfg") != null) {
                    mfg = (Date)entrymap.get("mfg");
                    stock.put("mfg", mfg);
                } else {
                    stock.put("mfg", null);
                }
                if (entrymap.get("exp") != null) {
                    mfg = (Date)entrymap.get("exp");
                    stock.put("exp", mfg);
                } else {
                    stock.put("exp", null);
                }
                if (entrymap.get("warehs") != null) {
                    WarehouseInfo ware = (WarehouseInfo)entrymap.get("warehs");
                    stock.setWarehouse(ware);
                } else {
                    stock.setWarehouse(null);
                }
                if (entrymap.get("location") != null) {
                    LocationInfo locateion = (LocationInfo)entrymap.get("location");
                    stock.setLocation(locateion);
                } else {
                    stock.setLocation(null);
                }
                if (entrymap.get("UnIssueQty") != null) {
                    BigDecimal temp = (BigDecimal)entrymap.get("UnIssueQty");
                    BigDecimal baseTemp = (BigDecimal)entrymap.get("UnBaseIssueQty");
                    flag = false;
                    if (temp.compareTo(DECIMAL_ZERO) != 0) {
                        stock.setUnIssueQty(temp);
                        stock.setUnIssueBaseQty(baseTemp);
                        flag = true;
                    }
                }
            }
            if (flag) continue;
            stocks.remove(stock);
            --j;
        }
        if (moInfo.getStocks().size() == 0) {
            return null;
        }
        sourceCBC.add((CoreBillBaseInfo)moInfo);
        BTPTransformResult btpResult = iBTPManager.transformForBotp(sourceCBC, MATERIALREQ_BOSTYPE, (IObjectPK)new ObjectUuidPK(botpID));
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo mappingInfo = iBOTMapping.getMappingInfoByPK((IObjectPK)new ObjectUuidPK(botpID));
        boolean isNotSave = mappingInfo.getIsTempSave() == 2;
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        IObjectCollection destBillCols = btpResult.getBills();
        try {
            if (WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().disableEventListener();
            }
            for (MaterialReqBillInfo destBillInfo : destBillCols) {
                StorageOrgUnitInfo storageOrgUnit;
                boolean isExistCodingRule = CommonUtils.existCodingRule((Context)ctx, (IObjectValue)destBillInfo, (String)(storageOrgUnit = destBillInfo.getStorageOrgUnit()).getId().toString());
                if (!isExistCodingRule) {
                    throw new ManufactureOrderException(ManufactureOrderException.REQBILL_NO_CODING);
                }
                MaterialReqBillEntryCollection mrbeCollection = destBillInfo.getEntry();
                for (MaterialReqBillEntryInfo mrbeInfo : mrbeCollection) {
                    String sourceBillEntryId = mrbeInfo.getSourceBillEntryId();
                    for (int j = 0; j < stocks.size(); ++j) {
                        ManufactureOrderStockInfo stock = stocks.get(j);
                        if (!stock.getId().toString().equals(sourceBillEntryId)) continue;
                        mrbeInfo.setLot((String)stock.get("lot"));
                        mrbeInfo.setMfg((Date)stock.get("mfg"));
                        mrbeInfo.setExp((Date)stock.get("exp"));
                    }
                }
                if (isNotSave) {
                    iBTPManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
                } else {
                    iBTPManager.saveTemp(botRelationCols);
                }
                if (!isNeedAudit) continue;
                materialReqBiz.submit((CoreBaseInfo)destBillInfo);
                boolean isAutoAudit = ManufactureOrderSplitFacadeControllerBean.isAuditAfterSubmit(ctx, (SCMBillBaseInfo)destBillInfo, storageOrgUnit.getId().toString(), 4);
                if (isAutoAudit) continue;
                materialReqBiz.audit((IObjectPK)new ObjectUuidPK(destBillInfo.getId()));
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        finally {
            if (!WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
        return btpResult;
    }

    private static boolean isAuditAfterSubmit(Context ctx, SCMBillBaseInfo info, String orgUnitID, int orgType) throws BOSException, EASBizException {
        boolean isAutoAudit = false;
        if (info.getBillType() != null) {
            String billTypeId = info.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", orgType, orgUnitID, billTypeId);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
        }
        return isAutoAudit;
    }

    private void calcStockRowQty(Context ctx, BigDecimal prodQty, ProductTransactionTypeInfo transTypeInfo, ManufactureOrderStockInfo stockInfo, ManufactureOrderInfo childInfo) throws BOSException, EASBizException {
        if (childInfo.getBirthType().equals((Object)MOBirthTypeEnum.SPLIT)) {
            ManufactureOrderStockCollection childStocks = childInfo.getStocks();
            Iterator iterator = childStocks.iterator();
            while (iterator.hasNext()) {
                ManufactureOrderStockInfo childStockInfo = (ManufactureOrderStockInfo)iterator.next();
                if (!stockInfo.getId().toString().equals(childStockInfo.getSourceBillEntryId())) continue;
                stockInfo.setQty(stockInfo.getQty().add(childStockInfo.getQty()));
                stockInfo.setPlannedQty(stockInfo.getPlannedQty().add(childStockInfo.getPlannedQty()));
                stockInfo.setOriginalPlanQty(stockInfo.getOriginalPlanQty().add(childStockInfo.getOriginalPlanQty()));
                stockInfo.setUnReceiptQty(stockInfo.getUnReceiptQty().add(childStockInfo.getUnReceiptQty()));
                stockInfo.setLossQty(stockInfo.getLossQty().add(childStockInfo.getLossQty()));
                stockInfo.setUnIssueQty(stockInfo.getPlannedQty().subtract(stockInfo.getActIssueQty()).add(stockInfo.getRejectedQty()));
                stockInfo.setAssociateQty(stockInfo.getAssociateQty().add(childStockInfo.getPlannedQty()));
                stockInfo.setPickLackQty(stockInfo.getPlannedQty().multiply(DECIMAL_ONE.subtract(stockInfo.getLackRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
                stockInfo.setPickExtraQty(stockInfo.getPlannedQty().multiply(DECIMAL_ONE.add(stockInfo.getExtraRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
                break;
            }
            return;
        }
        int scale = 8;
        if (stockInfo.getUnit() != null) {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitInfo currentMultiUnitInfo = multiUnit.getMultiUnit(stockInfo.getMaterial().getId().toString(), stockInfo.getUnit().getId().toString());
            scale = currentMultiUnitInfo.getQtyPrecision();
        }
        if (stockInfo.isIsReplaced()) {
            BigDecimal qty = stockInfo.getQty();
            BigDecimal plannedQty = stockInfo.getPlannedQty();
            BigDecimal originalPlanQty = stockInfo.getOriginalPlanQty();
            BigDecimal beforeReturnQty = prodQty.subtract(childInfo.getQty());
            BigDecimal returnRate = SysConstant.BIGZERO;
            if (beforeReturnQty.intValue() != 0) {
                returnRate = prodQty.divide(beforeReturnQty, 9, 4);
            }
            stockInfo.setQty(qty.multiply(returnRate).setScale(scale, 4));
            BigDecimal oldPlannedQty = stockInfo.getPlannedQty();
            stockInfo.setPlannedQty(plannedQty.multiply(returnRate).setScale(scale, 4));
            stockInfo.setOriginalPlanQty(originalPlanQty.multiply(returnRate).setScale(scale, 4));
            stockInfo.setUnReceiptQty(plannedQty.multiply(returnRate).setScale(scale, 4));
            stockInfo.setLossQty(plannedQty.multiply(returnRate).subtract(qty).setScale(scale, 4));
            stockInfo.setUnIssueQty(stockInfo.getPlannedQty().subtract(stockInfo.getActIssueQty()).add(stockInfo.getRejectedQty()));
            stockInfo.setAssociateQty(stockInfo.getAssociateQty().add(stockInfo.getPlannedQty().subtract(oldPlannedQty)));
            stockInfo.setWipQty(stockInfo.getActIssueQty().add(stockInfo.getFeedingQty()).add(stockInfo.getMaterialFeedingQty()).subtract(stockInfo.getScrapQty()).subtract(stockInfo.getMaterialScrapQty()).subtract(stockInfo.getRejectedQty()).subtract(stockInfo.getToStoreQty()).setScale(scale, 4));
            stockInfo.setPickLackQty(stockInfo.getPlannedQty().multiply(DECIMAL_ONE.subtract(stockInfo.getLackRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
            stockInfo.setPickExtraQty(stockInfo.getPlannedQty().multiply(DECIMAL_ONE.add(stockInfo.getExtraRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
            return;
        }
        BigDecimal unitQty = stockInfo.getUnitQty();
        if (unitQty == null) {
            unitQty = DECIMAL_ONE;
        }
        BigDecimal qty = prodQty.multiply(unitQty).setScale(scale, 0);
        stockInfo.setQty(qty);
        BigDecimal lossRatio = stockInfo.getLossRatio();
        BigDecimal planedQty = qty;
        if (lossRatio != null) {
            boolean isLoss = true;
            if (transTypeInfo != null && !transTypeInfo.isIsConsiderLossRatio()) {
                isLoss = false;
            }
            if (isLoss) {
                int scrapExp = stockInfo.getScrapExpr();
                lossRatio = lossRatio.divide(DECIMAL_ONE_HANDRED, 8, 4);
                if (scrapExp == 10610) {
                    planedQty = qty.divide(DECIMAL_ONE.subtract(lossRatio), scale, 0);
                } else if (scrapExp == 10610) {
                    if (lossRatio.compareTo(DECIMAL_ONE) < 0) {
                        planedQty = qty.divide(DECIMAL_ONE.subtract(lossRatio), scale, 0);
                    }
                } else {
                    planedQty = qty.multiply(DECIMAL_ONE.add(lossRatio)).setScale(scale, 0);
                }
            }
            BigDecimal oldPlannedQty = stockInfo.getPlannedQty();
            stockInfo.setPlannedQty(planedQty);
            stockInfo.setOriginalPlanQty(planedQty);
            stockInfo.setUnReceiptQty(planedQty);
            stockInfo.setLossQty(planedQty.subtract(qty).setScale(scale, 4));
            stockInfo.setUnIssueQty(stockInfo.getPlannedQty().subtract(stockInfo.getActIssueQty()).add(stockInfo.getRejectedQty()));
            stockInfo.setAssociateQty(stockInfo.getAssociateQty().add(planedQty.subtract(oldPlannedQty)));
            stockInfo.setWipQty(stockInfo.getActIssueQty().add(stockInfo.getFeedingQty()).add(stockInfo.getMaterialFeedingQty()).subtract(stockInfo.getScrapQty()).subtract(stockInfo.getMaterialScrapQty()).subtract(stockInfo.getRejectedQty()).subtract(stockInfo.getToStoreQty()).setScale(scale, 4));
            stockInfo.setPickLackQty(stockInfo.getPlannedQty().multiply(DECIMAL_ONE.subtract(stockInfo.getLackRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
            stockInfo.setPickExtraQty(stockInfo.getPlannedQty().multiply(DECIMAL_ONE.add(stockInfo.getExtraRatio().divide(DECIMAL_ONE_HANDRED, 8, 4))));
        }
    }

    private void updateMOBaseColumns(Context ctx, String[] idStrArray) throws BOSException, EASBizException {
        if (idStrArray == null || idStrArray.length == 0) {
            return;
        }
        String idStr = SQLUtil.arrayToString((Object[])idStrArray);
        String[] sqls = new String[4];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE T_MM_ManufactureOrder as t0  ").append("SET (").append("\tFTotalSplitBaseQty ,").append("\tFLackLowerLimitBase,").append("\tFExtraUpperLimitBase,").append("\tFDeliveryBaseQty ,").append("\tFunToStoreBaseQty ,").append("\tFunRepairBaseQty").append(") = (SELECT ").append("\t\tround(decimal(t0.FTotalSplitQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision),").append("\t\tround(decimal(t0.FLackLowerLimit * t1.FBaseConvsRate,21,8),t2.FQtyPrecision),").append("\t\tround(decimal(t0.FExtraUpperLimit * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append("\t\tround(decimal(t0.FDeliveryQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append("\t\tround(decimal(t0.FunToStoreQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append("\t\tround(decimal(t0.FunRepairQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision)").append("\tFROM ").append("\t\tt_bd_multimeasureunit t1,t_bd_multimeasureunit t2 ").append("\tWHERE ").append("\t\tt0.FMaterialID = t1.FMaterialID ").append("\t\tAND t0.FUnitID = t1.fmeasureunitid ").append("\t\tAND t0.FMaterialID = t2.FMaterialID ").append("\t\tAND t0.FBaseUnitID = t2.fmeasureunitid ").append("\t\tAND t0.FID in (").append(idStr).append(")").append(")");
        sqls[0] = updateSql.toString();
        updateSql.delete(0, updateSql.length());
        updateSql.append("UPDATE T_MM_MFTOrderTechnics as t0  ").append("SET (").append("\tFBaseQty,FTotalUpperBaseQty").append(") = (SELECT ").append("\t\tt1.FBaseQty, ").append("   round(decimal(t0.FTotalUpperQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision)").append("\tFROM ").append("\t\tT_MM_ManufactureOrder t1 ,t_bd_multimeasureunit t2,t_bd_multimeasureunit t3 ").append("\tWHERE ").append("\t\tt0.FParentID = t1.FID ").append("\t\tAND t0.FMaterialID = t2.FMaterialID ").append("\t\tAND t0.FUnitID = t2.fmeasureunitid ").append("\t\tAND t0.FMaterialID = t3.FMaterialID ").append("\t\tAND t0.FBaseUnitID = t3.fmeasureunitid ").append("\t\tAND t1.FID in (").append(idStr).append(") ").append(")");
        sqls[1] = updateSql.toString();
        updateSql.delete(0, updateSql.length());
        updateSql.append("UPDATE T_MM_MFTOrderStock as t0  ").append("SET (").append("\tFBaseQty,").append("\tFActIssueBaseQty,").append("\tFRejectedBaseQty,").append("\tFUnIssueBaseQty,").append("\tFWipBaseQty,").append("\tFLossBaseQty,").append("\tFPlannedBaseQty,").append("\tFOriginalPlanBaseQty,").append("\tFUnReceiptBaseQty,").append("\tFTotalReceiptBaseQty,").append("\tFActLossBaseQty,").append("\tFPickExtraBaseQty,").append("\tFPickLackBaseQty").append(") = (SELECT ").append("\t\tround(decimal(t0.FQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("\t\tround(decimal(t0.FActIssueQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("\t\tround(decimal(t0.FRejectedQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("\t\tround(decimal(t0.FUnIssueQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("\t\tround(decimal(t0.FWipQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("\t\tround(decimal(t0.FLossQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FPlannedQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FOriginalPlanQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FUnReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FTotalReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FActLossQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ,").append("\t\tround(decimal(t0.FPickExtraQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ,").append("\t\tround(decimal(t0.FPickLackQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ").append("\tFROM ").append("\t\tt_bd_multimeasureunit t2 , T_MM_ManufactureOrder t1 ,t_bd_multimeasureunit t3 ").append("\tWHERE ").append("\t\tt0.FParentID = t1.FID ").append("\t\tand t0.FMaterialID = t2.FMaterialID ").append("\t\tand t0.FUnitID = t2.fmeasureunitid ").append(" \t\tand t0.FMaterialID = t3.FMaterialID ").append("\t\tand t0.FBaseUnitID = t3.fmeasureunitid ").append("\t\tand t1.FID in (").append(idStr).append(") ").append(")");
        sqls[2] = updateSql.toString();
        updateSql.delete(0, updateSql.length());
        updateSql.append("UPDATE T_MM_MFTOrderExpectOutput as t0  ").append("SET (").append("\tFBaseQty,").append("\tFAssistBaseQty ,").append("\tFFinishedBaseQty,").append("\tFPassBaseQty ,").append("\tFScrapBaseQty ,").append("\tFToStoreBaseQty ").append(") = (SELECT ").append("\t\tround(decimal(t0.FQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("\t\tround(decimal(t0.FAssistQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FFinishedQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FPassQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FScrapQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("\t\tround(decimal(t0.FToStoreQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ").append("\tFROM ").append("\t\tt_bd_multimeasureunit t2 , T_MM_ManufactureOrder t1 ,t_bd_multimeasureunit t3 ").append("\tWHERE ").append("\t\tt0.FParentID = t1.FID ").append("\t\tand t0.FMaterialID = t2.FMaterialID ").append("\t\tand t0.FUnitID = t2.fmeasureunitid ").append(" \t\tand t0.FMaterialID = t3.FMaterialID ").append("\t\tand t0.FBaseUnitID = t3.fmeasureunitid ").append("\t\tand t1.FID in (").append(idStr).append(") ").append(")");
        sqls[3] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    private String checkForUndoSplit(Context ctx, String moID) throws BOSException {
        IRowSet rs;
        block8: {
            String string;
            StringBuffer buf;
            block7: {
                block6: {
                    rs = null;
                    buf = new StringBuffer();
                    buf.append("SELECT mo.fnumber\n");
                    buf.append("FROM   t_mm_manufactureorder mo\n");
                    buf.append("WHERE  mo.flongnumber LIKE '%" + moID + "!%'\n");
                    rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
                    if (!rs.next()) break block6;
                    String string2 = this.getResource(ctx, "MO_noUndoSplit_existsSubs");
                    SQLUtils.cleanup((ResultSet)rs);
                    return string2;
                }
                buf = new StringBuffer();
                buf.append("SELECT bt.fdestobjectid\n");
                buf.append("FROM   t_bot_relation bt\n");
                buf.append("WHERE  bt.fsrcobjectid IN ('" + moID + "')\n");
                buf.append("       AND bt.fdestobjectid NOT IN (SELECT fpickid\n");
                buf.append("                                    FROM   t_mm_mosplitrecord\n");
                buf.append("                                    WHERE  fpickid IS NOT NULL \n");
                buf.append("                                           AND fchildid IN ('" + moID + "'))\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
                if (!rs.next()) break block7;
                String string3 = this.getResource(ctx, "MO_noUndoSplit_existsSubs");
                SQLUtils.cleanup((ResultSet)rs);
                return string3;
            }
            try {
                buf = new StringBuffer();
                buf.append("SELECT mr.fnumber\n");
                buf.append("FROM   t_im_materialreqbill mr\n");
                buf.append("WHERE  mr.fbasestatus NOT IN (1,2)\n");
                buf.append("       AND mr.fid IN (SELECT freturnid\n");
                buf.append("                      FROM   t_mm_mosplitrecord\n");
                buf.append("                      WHERE  freturnid IS NOT NULL \n");
                buf.append("                             AND fpickid IS NULL\n");
                buf.append("                             AND fchildid IN ('" + moID + "'))\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
                if (!rs.next()) break block8;
                string = this.getResource(ctx, "MO_noUndoSplit_reformOnlyRetrunBill_isModified");
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return "";
    }

    private void saveMOSplitRecord(Context ctx, BOSUuid parentId, BOSUuid childId, BOSUuid pickId, BOSUuid returnId, int splitOperationNo, BigDecimal splitQty, int splitBlocks, int splitScale, BigDecimal splitEachQty) throws EASBizException, BOSException {
        ManufactureOrderSplitRecordInfo recordInfo = new ManufactureOrderSplitRecordInfo();
        recordInfo.setId(BOSUuid.create((BOSObjectType)recordInfo.getBOSType()));
        recordInfo.setParentId(parentId);
        recordInfo.setChildId(childId);
        recordInfo.setPickId(pickId);
        recordInfo.setReturnId(returnId);
        recordInfo.setSplitOperationNo(splitOperationNo);
        recordInfo.setSplitQty(splitQty);
        recordInfo.setSplitBlocks(splitBlocks);
        recordInfo.setSplitScale(splitScale);
        recordInfo.setSplitEachQty(splitEachQty);
        ManufactureOrderSplitRecordFactory.getLocalInstance(ctx).save(recordInfo);
    }

    private ManufactureOrderSplitRecordCollection getMOSplitRecord(Context ctx, String parentId, String childId) throws EASBizException, BOSException {
        IManufactureOrderSplitRecord iManufactureOrderSplitRecord = ManufactureOrderSplitRecordFactory.getLocalInstance(ctx);
        ManufactureOrderSplitRecordCollection mosrCol = iManufactureOrderSplitRecord.getManufactureOrderSplitRecordCollection(" WHERE parentId='" + parentId + "' AND childId='" + childId + "' ");
        return mosrCol == null ? new ManufactureOrderSplitRecordCollection() : mosrCol;
    }

    private String getResource(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.mo.ManufactureOrderResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    private static MaterialPlanInfo getMaterialPlanInfo(Context ctx, MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("yield"));
        selectorItemCollection.add(new SelectorItemInfo("rcvInHightLimit"));
        selectorItemCollection.add(new SelectorItemInfo("rcvInLowLimit"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.id"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.number"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.name"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.id"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.number"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.name"));
        selectorItemCollection.add(new SelectorItemInfo("planner.id"));
        selectorItemCollection.add(new SelectorItemInfo("planner.number"));
        selectorItemCollection.add(new SelectorItemInfo("planner.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(0);
            return materialPlanInfo;
        }
        return null;
    }

    private static MaterialInventoryInfo getMaterialInventoryInfo(Context ctx, MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("defaultWarehouse.id"));
        selectorItemCollection.add(new SelectorItemInfo("defaultWarehouse.number"));
        selectorItemCollection.add(new SelectorItemInfo("defaultWarehouse.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialInventoryCollection materialInventoryCollection = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(entityViewInfo);
        if (materialInventoryCollection != null && materialInventoryCollection.size() > 0) {
            MaterialInventoryInfo materialInventoryInfo = materialInventoryCollection.get(0);
            return materialInventoryInfo;
        }
        return null;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("transactionType.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("expectOutputs.*"));
        return sic;
    }

    private void dealWithMOFinish(Context ctx, String moid, boolean flag) throws BOSException, EASBizException {
        String tmpSql = "CREATE TABLE NEEDFINISH(FSourceBillID VARCHAR(44))";
        String tableName = null;
        try {
            tableName = this.createTempTable(ctx, tmpSql);
        }
        catch (Exception e) {
            logger.error((Object)"an error occurred in manufacture order split auto finish routine.");
        }
        if (null != tableName) {
            tmpSql = "INSERT INTO " + tableName + "(FSourceBillID) VALUES ( '" + moid + "')";
            SQLUtil.batchExecuteSql((Context)ctx, (String[])new String[]{tmpSql});
            if (flag) {
                MOFinish.autoFinish(ctx, tableName, true);
            } else {
                MOFinish.moDefaultUnAutoFinish(ctx, tableName);
            }
            this.releaseTempTable(ctx, tableName);
        }
    }

    private void updateReqPlanData(Context ctx, List idList, int bizAction) throws Exception {
        if (idList != null && idList.size() > 0) {
            IReqPlanReceiveReqDataFacade reqPlanReceiveReqDataFacade = ReqPlanReceiveReqDataFacadeFactory.getLocalInstance((Context)ctx);
            reqPlanReceiveReqDataFacade.receiveReqPlanDate("B2aZSVXaSx6qxdfekgCmrEY+1VI=", MMUtils.listToString((List)idList), bizAction);
        }
    }

    private String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    private void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }
}

