/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.sfc.BackFrushStatusEnum;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ManufactureRecBillAuditUtil {
    private ManufactureRecBillAuditUtil() {
    }

    public static void setManufactureRecBillBackFlushStatus(Context ctx, String[] ids) throws BOSException, EASBizException, SQLException {
        if (ids.length == 0) {
            return;
        }
        CoreBillBaseCollection cbc = ManufactureRecBillAuditUtil.getManufactureOrders(ctx, ids);
        Map map = ManufactureRecBillAuditUtil.getManufactureRecBillBackFlushStatus(ctx, cbc, ids);
        if (null != map) {
            ArrayList<String> unNeededBackFlushList = new ArrayList<String>();
            ArrayList<String> notNeededBackFlushList = new ArrayList<String>();
            for (String id : map.keySet()) {
                if ((BackFrushStatusEnum)map.get(id) == BackFrushStatusEnum.NO_BACKFRUSH) {
                    unNeededBackFlushList.add(id);
                    continue;
                }
                if ((BackFrushStatusEnum)map.get(id) != BackFrushStatusEnum.NOT_BACKFRUSH) continue;
                notNeededBackFlushList.add(id);
            }
            ArrayList<String> todoList = new ArrayList<String>();
            if (!unNeededBackFlushList.isEmpty()) {
                String sql1 = "UPDATE T_IM_MANUFACTURERECBILL SET FISBACKFLUSHSUCCEED = 5 WHERE FID IN (" + SQLUtil.arrayToString((Object[])unNeededBackFlushList.toArray(new String[0])) + ")";
                todoList.add(sql1);
            }
            if (!notNeededBackFlushList.isEmpty()) {
                String sql2 = "UPDATE T_IM_MANUFACTURERECBILL SET FISBACKFLUSHSUCCEED = 4 WHERE FID IN (" + SQLUtil.arrayToString((Object[])notNeededBackFlushList.toArray(new String[0])) + ")";
                todoList.add(sql2);
            }
            if (!todoList.isEmpty()) {
                SQLUtil.batchExecuteSql((Context)ctx, (String[])todoList.toArray(new String[0]));
            }
        }
    }

    public static Map getManufactureRecBillBackFlushStatus(Context ctx, CoreBillBaseCollection cbc, String[] ids) throws BOSException, EASBizException, SQLException {
        HashMap<String, BackFrushStatusEnum> map = new HashMap<String, BackFrushStatusEnum>();
        if (null == ids) {
            return map;
        }
        SCMEntryDataVO dataVO = ManufactureRecBillAuditUtil.getMaterialMmu(ctx, cbc);
        ManufactureOrderInfo moInfo = null;
        String orderID = null;
        BigDecimal prodQty = null;
        String idStr = SQLUtil.arrayToString((Object[])ids);
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append("select t0.FID,t1.FMANUBILLID FOrderID,t0.FNumber,t3.FIsAutoBackFlush,t3.FBackFlushQtyBase,t3.FIsBackFlushQtyMore, ").append("round(decimal(t1.FQty*(b1.FBaseConvsRate/b2.FBaseConvsRate),21,8),b1.FQtyPrecision) FProdQty,1 FOpNo ").append("from T_IM_ManufactureRecBill t0  ").append("inner join T_IM_ManufactureRecBillEntry t1 on t0.FID = t1.FParentID  ").append("inner join T_MM_ManufactureOrder t2 on t1.FMANUBILLID = t2.FID  ").append("inner join T_MM_ProductTransactionType t3 on t2.FTransactionTypeID = t3.FID  ").append("inner join t_bd_multimeasureunit  b1 ").append("on t1.FMaterialID = b1.FMaterialID and t1.FUnitID = b1.fmeasureunitid ").append("inner join t_bd_multimeasureunit  b2 ").append("on t2.FMaterialID = b2.FMaterialID and t2.FUnitID = b2.fmeasureunitid ").append("where t0.FID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
        HashMap materialRecMap = new HashMap();
        String materialRecId = null;
        int backFlushQtyBase = 10;
        boolean isBackFlushQtyMore = false;
        while (rs != null && rs.next()) {
            orderID = rs.getString("FOrderID");
            materialRecId = rs.getString("FID");
            backFlushQtyBase = rs.getInt("FBackFlushQtyBase");
            isBackFlushQtyMore = rs.getBoolean("FIsBackFlushQtyMore");
            if (materialRecMap.containsKey(materialRecId)) {
                ((List)materialRecMap.get(materialRecId)).add(orderID);
            } else {
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(orderID);
                materialRecMap.put(materialRecId, tmp);
                tmp = null;
            }
            moInfo = ManufactureRecBillAuditUtil.getManufactureOrder(cbc, orderID);
            if (moInfo == null) continue;
            moInfo.setSourceBillId(rs.getString("FID"));
            moInfo.setSrcBillNum(rs.getString("FNumber"));
            prodQty = rs.getBigDecimal("FProdQty");
            ManufactureOrderStockInfo stockInfo = null;
            int num = 0;
            Iterator stockIter = moInfo.getStocks().iterator();
            while (stockIter.hasNext()) {
                BigDecimal maxQty;
                stockInfo = (ManufactureOrderStockInfo)stockIter.next();
                int prec = ManufactureRecBillAuditUtil.getPrec(dataVO, stockInfo.getMaterial(), stockInfo.getUnit());
                BigDecimal backflushQty = new BigDecimal("0.0");
                BigDecimal bigDecimal = backFlushQtyBase == 10 ? (stockInfo.getQty().compareTo(SysConstant.BIGZERO) == 0 ? stockInfo.getPlannedQty() : stockInfo.getQty()) : (maxQty = stockInfo.getPlannedQty());
                if (maxQty.compareTo(SysConstant.BIGZERO) > 0 && maxQty.compareTo(stockInfo.getActIssueQty()) > 0) {
                    BigDecimal orderQty = moInfo.getQty().subtract(moInfo.getTotalSplitQty());
                    if (backFlushQtyBase == 10) {
                        backflushQty = prodQty.multiply(stockInfo.getUnitQty()).setScale(prec, 0);
                    } else if (backFlushQtyBase == 20) {
                        backflushQty = prodQty.multiply(stockInfo.getPlannedQty()).divide(orderQty, prec, 0);
                    }
                    BigDecimal leaveIssueQty = maxQty.subtract(stockInfo.getActIssueQty());
                    if (leaveIssueQty.compareTo(backflushQty) < 0) {
                        backflushQty = leaveIssueQty;
                    }
                }
                if (backflushQty.compareTo(SysConstant.BIGZERO) > 0) {
                    int baseUnitprec = ManufactureRecBillAuditUtil.getPrec(dataVO, stockInfo.getMaterial(), stockInfo.getBaseUnit());
                    BigDecimal convertRate = ManufactureRecBillAuditUtil.getConvertRate(dataVO, stockInfo.getMaterial(), stockInfo.getUnit());
                    BigDecimal backBaseQty = backflushQty.multiply(convertRate).setScale(baseUnitprec, 4);
                    stockInfo.setUnIssueQty(backflushQty);
                    stockInfo.setUnIssueBaseQty(backBaseQty);
                } else if (!isBackFlushQtyMore) {
                    stockIter.remove();
                    --num;
                }
                ++num;
            }
            if (0 >= moInfo.getStocks().size()) continue;
            map.put(moInfo.getSourceBillId(), BackFrushStatusEnum.NOT_BACKFRUSH);
        }
        int count = ids.length;
        for (int i = 0; i < count; ++i) {
            if (map.containsKey(ids[i])) continue;
            map.put(ids[i], BackFrushStatusEnum.NO_BACKFRUSH);
        }
        return map;
    }

    public static CoreBillBaseCollection getManufactureOrders(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(ctx);
        String idStr = SQLUtil.arrayToString((Object[])billIDs);
        String idSql = null;
        idSql = "select t1.FMANUBILLID from T_IM_ManufactureRecBill t0 inner join T_IM_ManufactureRecBillEntry t1 on t0.FID = t1.FParentID  where t0.FID in (" + idStr + ") ";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSql, CompareType.INNER));
        Integer backFlushMode = new Integer(20);
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.deductionBFPoint", (Object)backFlushMode));
        viewInfo.setFilter(filterInfo);
        FilterInfo entryFilterInfo = new FilterInfo();
        entryFilterInfo.setEntryName("stocks");
        entryFilterInfo.getFilterItems().add(new FilterItemInfo("isBackFlush", (Object)Boolean.TRUE));
        entryFilterInfo.getFilterItems().add(new FilterItemInfo("issueMode", (Object)new Integer(11040), CompareType.NOTEQUALS));
        viewInfo.getEntryFilters().add(entryFilterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("firstOperNo"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("sourceBillTypeId"));
        sic.add(new SelectorItemInfo("srcBillNum"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("transactionType.isAutoBackFlush"));
        sic.add(new SelectorItemInfo("totalSplitQty"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("technics.operationNo"));
        sic.add(new SelectorItemInfo("technics.isReportPoint"));
        viewInfo.setSelector(sic);
        SorterItemCollection sortIC = new SorterItemCollection();
        sortIC.add(new SorterItemInfo("technics.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.operationNo"));
        sortIC.add(new SorterItemInfo("stocks.replaceGroupFlag"));
        sortIC.add(new SorterItemInfo("stocks.replacePriority"));
        viewInfo.setSorter(sortIC);
        CoreBillBaseCollection cbc = moBiz.getCoreBillBaseCollection(viewInfo);
        Iterator orderIter = cbc.iterator();
        while (orderIter.hasNext()) {
            ManufactureOrderInfo mo = (ManufactureOrderInfo)orderIter.next();
            if (mo.getStocks().size() > 0) continue;
            orderIter.remove();
        }
        return cbc;
    }

    private static int getPrec(SCMEntryDataVO vo, MaterialInfo material, MeasureUnitInfo unitInfo) {
        int prec = 4;
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (vo != null && vo.getMmuPrecisions() != null && vo.getMmuPrecisions().get(key) != null) {
                prec = (Integer)vo.getMmuPrecisions().get(key);
            }
        }
        return prec;
    }

    private static BigDecimal getConvertRate(SCMEntryDataVO vo, MaterialInfo material, MeasureUnitInfo unitInfo) {
        BigDecimal convRate = new BigDecimal("1.0");
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (vo != null && vo.getMmuConvsRate() != null && vo.getMmuConvsRate().get(key) != null) {
                convRate = (BigDecimal)vo.getMmuConvsRate().get(key);
            }
        }
        return convRate;
    }

    private static SCMEntryDataVO getMaterialMmu(Context ctx, CoreBillBaseCollection cbc) throws EASBizException, BOSException {
        ArrayList<MaterialInfo> materialLst = new ArrayList<MaterialInfo>();
        ArrayList<MeasureUnitInfo> unitLst = new ArrayList<MeasureUnitInfo>();
        ArrayList<MeasureUnitInfo> baseunitLst = new ArrayList<MeasureUnitInfo>();
        ManufactureOrderInfo moInfo = null;
        for (int i = 0; i < cbc.size(); ++i) {
            moInfo = (ManufactureOrderInfo)cbc.get(i);
            for (int j = 0; j < moInfo.getStocks().size(); ++j) {
                materialLst.add(moInfo.getStocks().get(j).getMaterial());
                unitLst.add(moInfo.getStocks().get(j).getUnit());
                baseunitLst.add(moInfo.getStocks().get(j).getBaseUnit());
            }
        }
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materialLst.toArray(new MaterialInfo[materialLst.size()]));
        vo.setBaseMeasureUnitInfos(baseunitLst.toArray(new MeasureUnitInfo[baseunitLst.size()]));
        vo.setMeasureUnitInfos(unitLst.toArray(new MeasureUnitInfo[unitLst.size()]));
        return SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(vo);
    }

    private static ManufactureOrderInfo getManufactureOrder(CoreBillBaseCollection cbc, String orderId) {
        if (cbc == null || orderId == null) {
            return null;
        }
        ManufactureOrderInfo moInfo = null;
        for (int i = 0; i < cbc.size(); ++i) {
            moInfo = (ManufactureOrderInfo)cbc.get(i);
            if (moInfo.getId().toString().equals(orderId)) {
                if (moInfo instanceof IObjectValueAgent) {
                    moInfo = (ManufactureOrderInfo)AgentUtility.deepCopyAgentValue((IObjectValueAgent)((IObjectValueAgent)moInfo));
                    break;
                }
                moInfo = (ManufactureOrderInfo)moInfo.clone();
                break;
            }
            moInfo = null;
        }
        return moInfo;
    }
}

