/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.mo.GetStockCanToDoConditionInfo;
import com.kingdee.eas.mm.mo.GroupTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.MaterialTransactionPlatformFacadeFactory;
import com.kingdee.eas.mm.mo.MaterialTypeEnum;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.mm.mo.app.AbstractMaterialTransactionPlatformFacadeControllerBean;
import com.kingdee.eas.mm.mo.app.AllWarehouse;
import com.kingdee.eas.mm.mo.app.CrossFundPickBOT;
import com.kingdee.eas.mm.mo.app.CrossStoragePickBOT;
import com.kingdee.eas.mm.mo.app.GetMoData;
import com.kingdee.eas.mm.mo.app.PickingWarehouse;
import com.kingdee.eas.mm.mo.app.SelfDefineWarehouse;
import com.kingdee.eas.mm.mo.app.util.AllWarehouseCalculateInv;
import com.kingdee.eas.mm.mo.app.util.AllWarehouseCalculateOccupy;
import com.kingdee.eas.mm.mo.app.util.CustomeWarehouseCalculateInv;
import com.kingdee.eas.mm.mo.app.util.CustomeWarehouseCalculateOccupy;
import com.kingdee.eas.mm.mo.app.util.OnlyPickWarehouseCalculateInv;
import com.kingdee.eas.mm.mo.app.util.OnlyPickWarehouseCalculateOccupy;
import com.kingdee.eas.mm.mo.util.OrgnizeMoSql;
import com.kingdee.eas.mm.mo.util.OrgnizeMoStockSql;
import com.kingdee.eas.mm.mo.util.StockAndOccupyCondition;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.sfc.DisTaskDispatchCollection;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialTransactionPlatformFacadeControllerBean
extends AbstractMaterialTransactionPlatformFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.MaterialTransactionPlatformFacadeControllerBean");
    private static final String TB_PROJECT = "project";
    private static final String TB_TRACKNUM = "trackNum";
    private static final String TB_MATERIAL = "material";
    private static final String planVersionNumber = "901";
    private static final String allWarehouse = "10";
    private static final String onlyWarehouse = "20";

    @Override
    protected Map _getBotpRule(Context ctx, boolean isGet) throws BOSException, EASBizException {
        HashMap<String, String> pickMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql = sql.append(" select a.fid,a.falias_l2,c.frefobjectid,e.fritype ").append(" from t_bot_mapping a ").append(" left join T_BOT_Rule b on a.fid = b.fmappingid ").append(" left join T_BOT_RuleSegment c on b.fid = c.fruleid ").append(" left join T_BOT_EXTMAPPING d on a.fextMappingId = d.fid ").append(" left join t_scm_transactionType e on c.frefobjectid = e.fid ").append(" left join T_IM_RecIssueType f on e.fritypeid = f.fid ").append(" where a.fuidisable=0 ").append(" and a.fsrcentityname='1D0D80DD' ").append(" and a.fdestentityName='500AB75E' ").append(" and c.fdestpropertyname='transactionType' ").append(" and d.fiseffected = 1 ");
        if (isGet) {
            sql.append(" and (c.frefobjectid is null or f.fbizdirection = ").append(1).append(" ) ");
        } else {
            sql.append(" and f.fbizdirection = ").append(-1);
        }
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                pickMap.put(rs.getString("fid"), "");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"materialtransaction get botp'data error ,please check the db table!");
            throw new BOSException((Throwable)e);
        }
        return pickMap;
    }

    @Override
    protected BTPTransformResult _mapppingBillByBotpID(Context ctx, String botpID, Set ids, Map valuesMap, Map reqID) throws BOSException, BTPException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getMoSelectors());
        ManufactureOrderCollection mocon = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(view);
        CoreBillBaseCollection cbc = new CoreBillBaseCollection();
        for (int i = 0; i < mocon.size(); ++i) {
            ManufactureOrderInfo moinfo = mocon.get(i);
            ManufactureOrderStockCollection stocks = moinfo.getStocks();
            for (int j = 0; j < stocks.size(); ++j) {
                boolean flag = false;
                ManufactureOrderStockInfo stock = stocks.get(j);
                HashMap entrymap = (HashMap)valuesMap.get(stock.getId().toString());
                if (entrymap != null) {
                    Iterator iterator = entrymap.keySet().iterator();
                    while (iterator.hasNext()) {
                        if (entrymap.get("warehs") != null) {
                            WarehouseInfo ware = (WarehouseInfo)entrymap.get("warehs");
                            stock.setWarehouse(ware);
                        } else {
                            stock.setWarehouse(null);
                        }
                        if (entrymap.get("location") != null) {
                            LocationInfo locateion = (LocationInfo)entrymap.get("location");
                            stock.setLocation(locateion);
                        } else {
                            stock.setLocation(null);
                        }
                        if (entrymap.get("UnIssueQty") == null) continue;
                        BigDecimal ZERO = new BigDecimal("0.0");
                        BigDecimal temp = new BigDecimal(entrymap.get("UnIssueQty").toString());
                        BigDecimal baseTemp = new BigDecimal(entrymap.get("UnBaseIssueQty").toString());
                        flag = false;
                        if (temp.compareTo(ZERO) == 0) break;
                        stock.setUnIssueQty(temp);
                        stock.setUnIssueBaseQty(baseTemp);
                        flag = true;
                        break;
                    }
                }
                if (flag) continue;
                stocks.remove(stock);
                --j;
            }
            if (moinfo.getStocks().size() <= 0) continue;
            cbc.add((CoreBillBaseInfo)moinfo);
        }
        if (cbc.size() == 0) {
            return null;
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpID)));
        }
        catch (Exception e) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new PlanOrderException(PlanOrderException.RELEASE_BOTP_NOT_EFFECTED);
        }
        BTPTransformResult btpResult = iBTPManager.transformForBotp(cbc, "500AB75E", (IObjectPK)new ObjectUuidPK(botpID));
        boolean isCheckNum = false;
        if (!isCheckNum) {
            StorageOrgUnitInfo storageOrgUnit = ((MaterialReqBillInfo)btpResult.getBills().getObject(0)).getStorageOrgUnit();
            MaterialReqBillInfo reqbill = new MaterialReqBillInfo();
            reqbill.setStorageOrgUnit(storageOrgUnit);
            boolean isExistNumber = CommonUtils.existCodingRule((Context)ctx, (IObjectValue)reqbill, (String)reqbill.getStorageOrgUnit().getId().toString());
            if (!isExistNumber) {
                throw new ManufactureOrderException(ManufactureOrderException.REQBILL_NO_CODING);
            }
            isCheckNum = true;
        }
        if (reqID != null) {
            this.delReqBill(ctx, reqID, (MaterialReqBillInfo)btpResult.getBills().getObject(0));
        }
        return btpResult;
    }

    @Override
    protected boolean _saveRelations(Context ctx, BTPTransformResult bopResult, Map ids) throws BOSException, EASBizException {
        if (ids != null) {
            this.delReqBill(ctx, ids, (MaterialReqBillInfo)bopResult.getBills().getObject(0));
        }
        return true;
    }

    @Override
    protected Map _getStockCanToDoQty(Context ctx, List conditionInfo) throws BOSException {
        BigDecimal ZERO = new BigDecimal("0.00");
        StringBuffer sql = new StringBuffer();
        String inTempTableName = null;
        String[] sqls = new String[conditionInfo.size()];
        sql.append("create table ttt (").append("Fstockid varchar(44) not null,").append("FMaterialID varchar(44) not null,").append("FBaseQty NUMERIC(21,8) not null default 0 ,").append("FconvsRate NUMERIC(21,8) not null default 0,").append("FqtyPrecision NUMERIC(21,8) not null default 0").append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            inTempTableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        for (int i = 0; i < conditionInfo.size(); ++i) {
            sql.setLength(0);
            GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
            sql.append("insert into ").append(inTempTableName).append("(Fstockid,FMaterialID,FBaseQty,FconvsRate,FqtyPrecision)").append("\r\n").append(" select  '" + info.getStorckID() + "' as stockid ,\tinv.FMaterialID , ").append(" sum(inv.FBaseQty) as  baseqty ,t0.FBaseConvsRate,t0.fqtyprecision").append(" from  T_IM_Inventory inv ").append(" inner join T_IM_STORETYPE type on inv.FStoreTypeID=type.FID ").append(" inner join T_IM_STORESTATE state on inv.FStoreStatusID=state.FID ").append(" inner join t_bd_multimeasureunit as t0 on t0.FMaterialID = inv.FMaterialID").append("  and  t0.fmeasureunitid ='" + info.getUnitID() + "'").append(" where inv.FStorageorgunitid = '" + info.getStrorageOrgUnitID() + "' ").append(" and inv.FMaterialid = '" + info.getMaterialID() + "' ").append(" and inv.FWarehouseID = '" + info.getWarehsID() + "' ");
            if (info.getLocationID() != null) {
                sql.append(" and inv.FLocationID = '" + info.getLocationID() + "' ");
            }
            sql.append(" and (type.FNumber='S' or type.FNumber='G' or type.FNumber='R') ").append(" and (state.Fnumber='1' or state.Fnumber='203' or state.Fnumber='301'  ) ").append(" group by  inv.FMaterialID ,t0.FBaseConvsRate,t0.fqtyprecision");
            sqls[i] = sql.toString();
        }
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        String findAll = "select * from " + inTempTableName;
        HashMap<String, GetStockCanToDoConditionInfo> map = new HashMap<String, GetStockCanToDoConditionInfo>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)findAll);
        try {
            while (rs.next()) {
                GetStockCanToDoConditionInfo info = new GetStockCanToDoConditionInfo();
                info.setStorckID(rs.getString("Fstockid"));
                info.setConvsRate(rs.getBigDecimal("FconvsRate"));
                if (rs.getBigDecimal("FBaseQty").compareTo(ZERO) <= 0) {
                    info.setBaseQty(ZERO);
                } else {
                    info.setBaseQty(rs.getBigDecimal("FBaseQty"));
                }
                info.setPrecision(rs.getInt("fqtyprecision"));
                map.put(rs.getString("Fstockid"), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private void delReqBill(Context ctx, Map reqID, MaterialReqBillInfo info) throws BOSException, EASBizException {
        if (reqID == null || reqID.size() == 0) {
            return;
        }
        Iterator iterator = reqID.keySet().iterator();
        String[] number = new String[]{};
        ArrayList<String> numberList = new ArrayList<String>();
        StringBuffer strWhere = new StringBuffer("'");
        int i = 0;
        while (iterator.hasNext()) {
            String id = iterator.next().toString();
            if (reqID.get(id) != null && reqID.get(id).toString().trim().length() > 0) {
                String mrbNum = reqID.get(id).toString();
                numberList.add(mrbNum);
            }
            ++i;
            strWhere.append(id).append("','");
        }
        if (numberList.size() > 0) {
            number = numberList.toArray(number);
        }
        String str = strWhere.toString();
        String[] sqls = new String[5];
        str = str.substring(0, str.lastIndexOf(","));
        StringBuffer botpsql = new StringBuffer();
        botpsql.setLength(0);
        botpsql.append("delete from T_BOT_RelationEntry  where FDestObjectID in(");
        botpsql.append(" select t.fid from T_IM_MaterialReqBill t where t.fid in (" + str + ") and t.FBaseStatus <> " + 4);
        botpsql.append(")");
        sqls[0] = botpsql.toString();
        botpsql.setLength(0);
        botpsql.append("delete from T_BOT_Relation  where FDestObjectID in(");
        botpsql.append(" select t.fid from T_IM_MaterialReqBill t where t.fid in (" + str + ") and t.FBaseStatus <> " + 4);
        botpsql.append(")");
        sqls[1] = botpsql.toString();
        botpsql.setLength(0);
        botpsql.append("delete from T_IM_MaterialReqBillPriceInfo  where fparentid in(");
        botpsql.append(" select t.fid from T_IM_MaterialReqBill t where t.fid in (" + str + ") and t.FBaseStatus <> " + 4);
        botpsql.append(")");
        sqls[2] = botpsql.toString();
        botpsql.setLength(0);
        botpsql.append("delete from T_IM_MaterialReqBillEntry where fparentid in (");
        botpsql.append(" select t.fid from T_IM_MaterialReqBill t where t.fid in (" + str + ") and t.FBaseStatus <> " + 4);
        botpsql.append(" )");
        sqls[3] = botpsql.toString();
        botpsql.setLength(0);
        botpsql.append("delete from T_IM_MaterialReqBill where fid in (" + str + ") and FBaseStatus <> " + 4);
        sqls[4] = botpsql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        boolean isExistNumber = CommonUtils.existCodingRule((Context)ctx, (IObjectValue)info, info.getStorageOrgUnit() != null ? info.getStorageOrgUnit().getId().toString() : null);
        if (isExistNumber && number.length > 0) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            iCodingRuleManager.recycleBatchNumber((IObjectValue)info, info.getStorageOrgUnit().getId().toString(), number);
        }
    }

    private void delOnlyReqBill(Context ctx, Map reqID, MaterialReqBillInfo info) throws BOSException, EASBizException {
        String delEntry;
        if (reqID.size() == 0) {
            return;
        }
        Iterator iterator = reqID.keySet().iterator();
        String[] number = new String[reqID.size()];
        StringBuffer strWhere = new StringBuffer("'");
        int i = 0;
        while (iterator.hasNext()) {
            String id = iterator.next().toString();
            number[i] = reqID.get(id).toString();
            ++i;
            strWhere.append(id).append("','");
        }
        String str = strWhere.toString();
        String[] sqls = new String[2];
        str = str.substring(0, str.lastIndexOf(","));
        String delHead = "delete from T_IM_MaterialReqBill where fid in (" + str + ") and FBaseStatus <> " + 4;
        sqls[0] = delEntry = "delete from T_IM_MaterialReqBillEntry where fparentid in ( select t.fid from T_IM_MaterialReqBill t where t.fid in (" + str + ") and t.FBaseStatus <> " + 4 + " )";
        sqls[1] = delHead;
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        iCodingRuleManager.recycleBatchNumber((IObjectValue)info, info.getStorageOrgUnit().getId().toString(), number);
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    @Override
    protected Map _batchGetPrecision(Context ctx, List conditionInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String inTempTableName = null;
        String[] sqls = new String[conditionInfo.size()];
        sql.append("create table ttt (").append("FBillId varchar(44) not null,").append("FPrecision NUMERIC(21,8) not null default 0").append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            inTempTableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        for (int i = 0; i < conditionInfo.size(); ++i) {
            sql.setLength(0);
            GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
            sql.append("insert into ").append(inTempTableName).append("( FBillId,FPrecision)").append("\r\n").append(" select '" + info.getStorckID() + "', ").append(" t0.fqtyPrecision ").append(" from t_bd_multimeasureunit as t0 ").append(" where t0.FMaterialID ='" + info.getMaterialID() + "'").append("  and  t0.fmeasureunitid ='" + info.getUnitID() + "'");
            sqls[i] = sql.toString();
        }
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        String findAll = "select * from " + inTempTableName;
        HashMap<String, GetStockCanToDoConditionInfo> map = new HashMap<String, GetStockCanToDoConditionInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)findAll);
        try {
            while (rs.next()) {
                GetStockCanToDoConditionInfo info = new GetStockCanToDoConditionInfo();
                info.setStorckID(rs.getString("FBillId"));
                info.setPrecision(rs.getInt("FPrecision"));
                map.put(rs.getString("FBillId"), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public SelectorItemCollection getMoSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("technics.id"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("routing.number"));
        sic.add(new SelectorItemInfo("dispatcher.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("warehouse.id"));
        sic.add(new SelectorItemInfo("warehouse.number"));
        sic.add(new SelectorItemInfo("warehouse.name"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.number"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("replaceMaterial.name"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit1.*"));
        sic.add(new SelectorItemInfo("stocks.material.*"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.id"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.number"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.name"));
        sic.add(new SelectorItemInfo("stocks.unit.id"));
        sic.add(new SelectorItemInfo("stocks.unit.number"));
        sic.add(new SelectorItemInfo("stocks.unit.name"));
        sic.add(new SelectorItemInfo("stocks.warehouse.id"));
        sic.add(new SelectorItemInfo("stocks.warehouse.number"));
        sic.add(new SelectorItemInfo("stocks.warehouse.name"));
        sic.add(new SelectorItemInfo("stocks.location.id"));
        sic.add(new SelectorItemInfo("stocks.location.number"));
        sic.add(new SelectorItemInfo("stocks.location.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.workcenter.id"));
        sic.add(new SelectorItemInfo("stocks.workcenter.number"));
        sic.add(new SelectorItemInfo("stocks.workcenter.name"));
        sic.add(new SelectorItemInfo("stocks.operation.id"));
        sic.add(new SelectorItemInfo("stocks.operation.number"));
        sic.add(new SelectorItemInfo("stocks.operation.name"));
        sic.add(new SelectorItemInfo("defaultWarehous.id"));
        sic.add(new SelectorItemInfo("defaultWarehous.number"));
        sic.add(new SelectorItemInfo("defaultWarehous.name"));
        return sic;
    }

    @Override
    protected boolean _delReqBills(Context ctx, Map reqID, MaterialReqBillInfo info) throws BOSException, EASBizException {
        this.delReqBill(ctx, reqID, info);
        return true;
    }

    @Override
    protected FilterInfo _getCalSolution(Context ctx, String orgId, String UIName) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        String queryName = "com.kingdee.eas.mm.mo.app.MsgQuery";
        IQuerySolutionFacade query = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
        QuerySolutionInfo info = query.getDefaultSolution(UIName, queryName);
        if (info != null && info.getEntityViewInfo() != null && !info.getEntityViewInfo().trim().equals("")) {
            EntityViewInfo view = null;
            try {
                view = new EntityViewInfo(info.getEntityViewInfo());
            }
            catch (Exception e) {
                throw new BOSException();
            }
            filter = view.getFilter();
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("isOccupy", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("priorityRule", (Object)new Integer(10), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("warehouseRange", (Object)new Integer(10), CompareType.EQUALS));
        return filter;
    }

    @Override
    protected boolean _isDeleteReqBill(Context ctx, Map reqID) throws BOSException, EASBizException {
        if (reqID.size() == 0) {
            return false;
        }
        Iterator iterator = reqID.keySet().iterator();
        String[] number = new String[reqID.size()];
        StringBuffer strWhere = new StringBuffer("'");
        int i = 0;
        while (iterator.hasNext()) {
            String id = iterator.next().toString();
            number[i] = reqID.get(id).toString();
            ++i;
            strWhere.append(id).append("','");
        }
        String str = strWhere.toString();
        str = str.substring(0, str.lastIndexOf(","));
        String sql = "select top 1  fid from T_IM_MaterialReqBill where fid in (" + str + ") ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected Map _getProductionOccupy(Context ctx, List conditionInfo, FilterInfo filter, String orgId, List orderList) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        FilterItemCollection items = filter.getFilterItems();
        Object intWarehouseRange = null;
        for (int index = 0; index < items.size(); ++index) {
            FilterItemInfo filterInfo = items.get(index);
            if (!filterInfo.getPropertyName().equals("warehouseRange")) continue;
            intWarehouseRange = filterInfo.getCompareValue();
        }
        if (null != intWarehouseRange && intWarehouseRange.toString().equals(allWarehouse)) {
            AllWarehouse awh = new AllWarehouse();
            map = (HashMap)awh.getProductionOccupyQty(ctx, conditionInfo, filter, orgId, orderList);
        } else if (null != intWarehouseRange && intWarehouseRange.toString().equals(onlyWarehouse)) {
            PickingWarehouse pwh = new PickingWarehouse();
            map = (HashMap)pwh.getProductionOccupyQty(ctx, conditionInfo, filter, orgId, orderList);
        } else {
            SelfDefineWarehouse sdw = new SelfDefineWarehouse();
            map = (HashMap)sdw.getProductionOccupyQty(ctx, conditionInfo, filter, orgId, orderList);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map _getStockCanToDoQty(Context ctx, List conditionInfo, FilterInfo filter, String orgId) throws BOSException, EASBizException {
        BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;
        Map<String, GetStockCanToDoConditionInfo> map = new HashMap();
        ResultSet stResult = null;
        try {
            stResult = StoreCommonUtil.getPlanVersionSetStoretypeAndStorestate((Context)ctx, (String)planVersionNumber, (String)orgId);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        Object[] st = this.StoretypeAndStorestate(stResult);
        Set stoType = (Set)st[0];
        String storageType = this.exchangeSetToString(stoType);
        Set stoStatus = (Set)st[1];
        String storageStatus = this.exchangeSetToString(stoStatus);
        String tempTableName = this.genBillTemp(ctx, conditionInfo);
        FilterItemCollection items = filter.getFilterItems();
        Object intWarehouseRange = null;
        Object warehouseObjects = null;
        for (int index = 0; index < items.size(); ++index) {
            FilterItemInfo filterInfo = items.get(index);
            if (filterInfo.getPropertyName().equals("warehouseRange")) {
                intWarehouseRange = filterInfo.getCompareValue();
            }
            if (!filterInfo.getPropertyName().equals("warehouseID")) continue;
            warehouseObjects = filterInfo.getCompareValue();
        }
        IRowSet rs = null;
        String allWarehouse = allWarehouse;
        String onlyWarehouse = onlyWarehouse;
        if (null != intWarehouseRange && intWarehouseRange.toString().equals(allWarehouse)) {
            String warehouseIds = this.parseAllWarehouseIds(ctx, orgId);
            StringBuffer oql = this.getOql(storageStatus, storageType, warehouseIds, orgId, tempTableName);
            oql.append(" GROUP BY TIN.FStorageOrgUnitID,TIN.FMaterialID,TIN.FProjectID,TIN.FTrackNumberID,tma.fbaseunit");
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                pool.releaseTable(tempTableName);
                HashMap<String, GetStockCanToDoConditionInfo> materialOrgMap = new HashMap<String, GetStockCanToDoConditionInfo>();
                while (rs.next()) {
                    GetStockCanToDoConditionInfo info = new GetStockCanToDoConditionInfo();
                    if (rs.getBigDecimal("SUM_BASEQTY").compareTo(ZERO) <= 0) {
                        info.setBaseQty(ZERO);
                    } else {
                        info.setBaseQty(rs.getBigDecimal("SUM_BASEQTY"));
                    }
                    info.setBaseUnitID(rs.getString("fbaseunit"));
                    StringBuffer keyStr = new StringBuffer();
                    keyStr.append(rs.getString("MATERIALID") + rs.getString("ORGID"));
                    if (rs.getString("PROJECTID") != null && rs.getString("PROJECTID").length() > 0 && !rs.getString("PROJECTID").equalsIgnoreCase("EgkAAABc3Xza3gXu")) {
                        keyStr.append(rs.getString("PROJECTID"));
                    }
                    if (rs.getString("TRACKNUMID") != null && rs.getString("TRACKNUMID").length() > 0 && !rs.getString("TRACKNUMID").equalsIgnoreCase("EgkAAABc3X0Ibpg9")) {
                        keyStr.append(rs.getString("TRACKNUMID"));
                    }
                    materialOrgMap.put(keyStr.toString(), info);
                }
                if (conditionInfo == null) return map;
                if (conditionInfo.size() <= 0) return map;
                int i = 0;
                while (i < conditionInfo.size()) {
                    GetStockCanToDoConditionInfo otherInfo;
                    GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
                    StringBuffer key = new StringBuffer();
                    key.append(info.getMaterialID() + info.getMainStorageOrgUnitID());
                    if (info.getProjectID() != null && info.getProjectID().length() > 0) {
                        key.append(info.getProjectID());
                    }
                    if (info.getTrackNumID() != null && info.getTrackNumID().length() > 0) {
                        key.append(info.getTrackNumID());
                    }
                    if ((otherInfo = (GetStockCanToDoConditionInfo)materialOrgMap.get(key.toString())) != null) {
                        GetStockCanToDoConditionInfo newOtherInfo = new GetStockCanToDoConditionInfo();
                        newOtherInfo.setBaseQty(otherInfo.getBaseQty());
                        newOtherInfo.setBaseUnitID(otherInfo.getBaseUnitID());
                        map.put(info.getStorckID(), newOtherInfo);
                    }
                    ++i;
                }
                return map;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (intWarehouseRange.toString().equals(onlyWarehouse)) {
            return this.onlyWarehouseCanToDoQty(conditionInfo, ctx, storageType, storageStatus, orgId);
        }
        if (warehouseObjects == null) return map;
        return this.customeWarehouseCanToDoQty(warehouseObjects, conditionInfo, ctx, storageType, storageStatus, orgId);
    }

    private Object[] StoretypeAndStorestate(ResultSet rs) throws BOSException {
        Object[] st = new Object[2];
        HashSet<String> type = new HashSet<String>();
        HashSet<String> status = new HashSet<String>();
        try {
            while (rs.next()) {
                if (rs.getString("fstoretype") != null) {
                    type.add(rs.getString("fstoretype"));
                }
                if (rs.getString("fstorestate") == null) continue;
                status.add(rs.getString("fstorestate"));
            }
            st[0] = type;
            st[1] = status;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return st;
    }

    private Map customeWarehouseCanToDoQty(Object warehouseObjects, List conditionInfo, Context ctx, String storageType, String storageStatus, String orgId) throws BOSException {
        BigDecimal ZERO = new BigDecimal("0.00");
        StringBuffer sql = new StringBuffer();
        String[] sqls = new String[conditionInfo.size()];
        HashMap map = new HashMap();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String inTempTableName = this.createTempleTable(ctx, pool);
        String onlyWarehouseIDs = this.parseOnlyWarehouseIds(warehouseObjects);
        for (int i = 0; i < conditionInfo.size(); ++i) {
            sql.setLength(0);
            GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
            if (info.getWarehsID() == null) {
                map.put(info.getStorckID(), ZERO);
                continue;
            }
            if (onlyWarehouseIDs.indexOf(info.getWarehsID()) == -1) {
                map.put(info.getStorckID(), ZERO);
                continue;
            }
            sql.append("insert into ").append(inTempTableName).append("(Fstockid,FMaterialID,FBaseQty,FWarehouseID,fbaseunit,FProjectID,FTrackNumID)").append("\r\n").append(" SELECT '" + info.getStorckID() + "' as stockid ,inv.FMaterialID AS MATERIALID,SUM(inv.FBaseQty) AS SUM_BASEQTY ,inv.FWarehouseID AS WAREHOUSEID,tma.fbaseunit , ");
            sql.append(info.getProjectID() != null && info.getProjectID().length() > 0 ? "'" + info.getProjectID() + "'" : null).append(" as PROJECTID,");
            sql.append(info.getTrackNumID() != null && info.getTrackNumID().length() > 0 ? "'" + info.getTrackNumID() + "'" : null).append(" as TRACKNUMID");
            sql.append(" FROM T_IM_Inventory inv LEFT JOIN T_BD_Material TMA ON (inv.FMaterialID = TMA.FID)  WHERE inv.FWarehouseID = '" + info.getWarehsID() + "'  AND inv.FStorageOrgUnitID = '" + orgId + "'  AND inv.FMaterialID = '" + info.getMaterialID() + "'  AND inv.FStoreStatusID IN (" + storageStatus + ") AND inv.FStoreTypeID IN (" + storageType + ")");
            if (info.getProjectID() != null && info.getProjectID().length() > 0) {
                sql.append(" AND inv.FProjectID = '" + info.getProjectID() + "'");
            } else {
                sql.append(" AND inv.FProjectID = 'EgkAAABc3Xza3gXu'");
            }
            if (info.getTrackNumID() != null && info.getTrackNumID().length() > 0) {
                sql.append(" AND inv.FTrackNumberID = '" + info.getTrackNumID() + "'");
            } else {
                sql.append(" AND inv.FTrackNumberID = 'EgkAAABc3X0Ibpg9'");
            }
            sql.append(" group by inv.FMaterialID,inv.FWarehouseID,tma.fbaseunit");
            sqls[i] = sql.toString();
        }
        map = this.getMapValue(ctx, sqls, pool, inTempTableName);
        pool.releaseTable(inTempTableName);
        return map;
    }

    private Map onlyWarehouseCanToDoQty(List conditionInfo, Context ctx, String storageType, String storageStatus, String orgId) throws BOSException {
        BigDecimal ZERO = new BigDecimal("0.00");
        StringBuffer sql = new StringBuffer();
        String[] sqls = new String[conditionInfo.size()];
        HashMap map = new HashMap();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String inTempTableName = this.createTempleTable(ctx, pool);
        for (int i = 0; i < conditionInfo.size(); ++i) {
            sql.setLength(0);
            GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
            if (info.getWarehsID() == null) {
                map.put(info.getStorckID(), ZERO);
                continue;
            }
            sql.append("insert into ").append(inTempTableName).append("(Fstockid,FMaterialID,FBaseQty,FWarehouseID,fbaseunit,FProjectID,FTrackNumID)").append("\r\n").append(" SELECT '" + info.getStorckID() + "' as stockid ,inv.FMaterialID AS MATERIALID,SUM(inv.FBaseQty) AS SUM_BASEQTY ,inv.FWarehouseID AS WAREHOUSEID,tma.fbaseunit ,");
            sql.append(info.getProjectID() != null && info.getProjectID().length() > 0 ? "'" + info.getProjectID() + "'" : null).append(" as PROJECTID,");
            sql.append(info.getTrackNumID() != null && info.getTrackNumID().length() > 0 ? "'" + info.getTrackNumID() + "'" : null).append(" as TRACKNUMID");
            sql.append(" FROM T_IM_Inventory inv LEFT JOIN T_BD_Material TMA ON (inv.FMaterialID = TMA.FID)  WHERE inv.FWarehouseID = '" + info.getWarehsID() + "'  AND inv.FStorageOrgUnitID = '" + orgId + "'  AND inv.FMaterialID = '" + info.getMaterialID() + "'  AND inv.FStoreStatusID IN (" + storageStatus + ") AND inv.FStoreTypeID IN (" + storageType + ")");
            if (info.getProjectID() != null && info.getProjectID().length() > 0) {
                sql.append(" AND inv.FProjectID = '" + info.getProjectID() + "'");
            } else {
                sql.append(" AND inv.FProjectID = 'EgkAAABc3Xza3gXu'");
            }
            if (info.getTrackNumID() != null && info.getTrackNumID().length() > 0) {
                sql.append(" AND inv.FTrackNumberID = '" + info.getTrackNumID() + "'");
            } else {
                sql.append(" AND inv.FTrackNumberID = 'EgkAAABc3X0Ibpg9'");
            }
            sql.append(" group by inv.FMaterialID,inv.FWarehouseID,tma.fbaseunit");
            sqls[i] = sql.toString();
        }
        map = this.getMapValue(ctx, sqls, pool, inTempTableName);
        pool.releaseTable(inTempTableName);
        return map;
    }

    private HashMap getMapValue(Context ctx, String[] sqls, TempTablePool pool, String inTempTableName) throws BOSException {
        HashMap<String, GetStockCanToDoConditionInfo> map = new HashMap<String, GetStockCanToDoConditionInfo>();
        BigDecimal ZERO = new BigDecimal("0.00");
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        String findAll = "select Fstockid,FBaseQty,fbaseunit from " + inTempTableName;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)findAll);
            while (rs.next()) {
                GetStockCanToDoConditionInfo info = new GetStockCanToDoConditionInfo();
                info.setStorckID(rs.getString("Fstockid"));
                if (rs.getBigDecimal("FBaseQty").compareTo(ZERO) <= 0) {
                    info.setBaseQty(ZERO);
                } else {
                    info.setBaseQty(rs.getBigDecimal("FBaseQty"));
                }
                info.setBaseUnitID(rs.getString("fbaseunit"));
                map.put(rs.getString("Fstockid"), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String createTempleTable(Context ctx, TempTablePool pool) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String inTempTableName = null;
        sql.append("create table tempCantodoQty (").append("Fstockid varchar(44) not null,").append("FBaseQty NUMERIC(21,8) not null default 0 ,").append("FWarehouseID varchar(44) not null, ").append("FMaterialID varchar(44) not null, ").append("fbaseunit varchar(44),").append("FProjectID varchar(44),").append("FTrackNumID varchar(44)").append(")");
        try {
            inTempTableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return inTempTableName;
    }

    private StringBuffer getOql(String storageStatus, String storageType, String materialIds, String warehouseIds, String orgId, String projectIds, String trackNumIds) {
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT TIN.FStorageOrgUnitID AS ORGID,TIN.FMaterialID AS MATERIALID,TIN.FProjectID AS PROJECTID,TIN.FTrackNumberID AS TRACKNUMID,tma.fbaseunit,SUM(TIN.FBaseQty) AS SUM_BASEQTY  FROM T_IM_Inventory TIN LEFT JOIN T_BD_Material TMA ON (TIN.FMaterialID = TMA.FID)  WHERE TIN.FWarehouseID IN('" + warehouseIds + "') AND TIN.FStorageOrgUnitID = '" + orgId + "'  AND TMA.FID IN ('" + materialIds + "')  AND TIN.FStoreStatusID IN (" + storageStatus + ") AND TIN.FStoreTypeID IN (" + storageType + ") AND (TIN.FProjectID = '" + "EgkAAABc3Xza3gXu" + "'");
        if (projectIds != null && projectIds.length() > 0) {
            oql.append(" OR TIN.FProjectID IN ('" + projectIds + "')");
        }
        oql.append(")");
        oql.append("AND (TIN.FTrackNumberID = 'EgkAAABc3X0Ibpg9'");
        if (trackNumIds != null && trackNumIds.length() > 0) {
            oql.append(" OR TIN.FTrackNumberID IN ('" + trackNumIds + "')");
        }
        oql.append(")");
        return oql;
    }

    private StringBuffer getOql(String storageStatus, String storageType, String warehouseIds, String orgId, String tempTableName) {
        StringBuffer oql = new StringBuffer();
        tempTableName = oql.append(" ( ").append(" select distinct * from ").append(tempTableName).append(" ) ").toString();
        oql.setLength(0);
        oql.append("SELECT TIN.FStorageOrgUnitID AS ORGID,TIN.FMaterialID AS MATERIALID,TIN.FProjectID AS PROJECTID,TIN.FTrackNumberID AS TRACKNUMID,tma.fbaseunit,SUM(TIN.FBaseQty) AS SUM_BASEQTY  FROM T_IM_Inventory TIN LEFT JOIN T_BD_Material TMA ON (TIN.FMaterialID = TMA.FID)  INNER JOIN " + tempTableName + " TMP ON (TIN.FMaterialID || (case when TIN.FProjectId = '" + "EgkAAABc3Xza3gXu" + "' then '' else TIN.FProjectId end) || (case when TIN.FTrackNumberId = '" + "EgkAAABc3X0Ibpg9" + "' then '' else TIN.FTrackNumberId end))=( TMP.FMaterialID || ISNULL( TMP.FProjectId,'') || ISNULL( TMP.FTrackNumberId,'')) WHERE TIN.FWarehouseID IN('" + warehouseIds + "') AND TIN.FStorageOrgUnitID = '" + orgId + "'  AND TIN.FStoreStatusID IN (" + storageStatus + ") AND TIN.FStoreTypeID IN (" + storageType + ")");
        return oql;
    }

    private String parseOnlyWarehouseIds(Object warehouseObjects) {
        HashSet set = (HashSet)warehouseObjects;
        Iterator it = set.iterator();
        StringBuffer sb = new StringBuffer("");
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString().replaceAll(",", "','");
    }

    private String parseAllWarehouseIds(Context ctx, String orgId) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo finfo = new FilterInfo();
        finfo.getFilterItems().add(new FilterItemInfo("transState", (Object)"1"));
        finfo.getFilterItems().add(new FilterItemInfo("transState", (Object)"2"));
        finfo.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)orgId, CompareType.EQUALS));
        finfo.getFilterItems().add(new FilterItemInfo("whState", (Object)"1"));
        finfo.setMaskString("(#0 OR #1) AND #2 AND #3");
        entityViewInfo.setFilter(finfo);
        IWarehouse wh = WarehouseFactory.getLocalInstance((Context)ctx);
        WarehouseCollection warehouses = wh.getWarehouseCollection(entityViewInfo);
        StringBuffer whids = new StringBuffer();
        for (int m = 0; m < warehouses.size(); ++m) {
            WarehouseInfo info = warehouses.get(m);
            whids.append(info.getId().toString());
            if (m >= warehouses.size() - 1) continue;
            whids.append(",");
        }
        return whids.toString().replaceAll(",", "','");
    }

    private String parseIds(List conditionInfo, String colNamePK) {
        StringBuffer idset;
        block4: {
            block5: {
                block3: {
                    idset = new StringBuffer();
                    if (!colNamePK.equals(TB_MATERIAL)) break block3;
                    for (int i = 0; i < conditionInfo.size(); ++i) {
                        GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
                        idset.append(info.getMaterialID());
                        if (i >= conditionInfo.size() - 1) continue;
                        idset.append(",");
                    }
                    break block4;
                }
                if (!colNamePK.equals(TB_PROJECT)) break block5;
                for (int i = 0; i < conditionInfo.size(); ++i) {
                    GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
                    if (info.getProjectID() == null || info.getProjectID().length() <= 0) continue;
                    idset.append(info.getProjectID());
                    if (i >= conditionInfo.size() - 1) continue;
                    idset.append(",");
                }
                break block4;
            }
            if (!colNamePK.equals(TB_TRACKNUM)) break block4;
            for (int i = 0; i < conditionInfo.size(); ++i) {
                GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
                if (info.getTrackNumID() == null || info.getTrackNumID().length() <= 0) continue;
                idset.append(info.getTrackNumID());
                if (i >= conditionInfo.size() - 1) continue;
                idset.append(",");
            }
        }
        return idset.toString().replaceAll(",", "','");
    }

    private String exchangeSetToString(Set ts) {
        StringBuffer tsStringbuffer = new StringBuffer();
        tsStringbuffer.append("'");
        if (!ts.isEmpty()) {
            Object[] tsArr = ts.toArray();
            String tsString = StringUtils.arrayToString((Object[])tsArr, (String)"','");
            tsStringbuffer.append(tsString);
        } else {
            String tsString = "";
        }
        tsStringbuffer.append("'");
        return tsStringbuffer.toString();
    }

    private SelectorItemCollection getMoAdditionalSelectors(boolean isNeedStock) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        if (isNeedStock) {
            sic.add(new SelectorItemInfo("stocks.*"));
            sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
            sic.add(new SelectorItemInfo("stocks.storageOrgUnit.number"));
            sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("stocks.warehouse.id"));
            sic.add(new SelectorItemInfo("stocks.warehouse.name"));
            sic.add(new SelectorItemInfo("stocks.warehouse.hasLocation"));
            sic.add(new SelectorItemInfo("stocks.warehouse.number"));
            sic.add(new SelectorItemInfo("stocks.location.id"));
            sic.add(new SelectorItemInfo("stocks.location.number"));
            sic.add(new SelectorItemInfo("stocks.location.name"));
            sic.add(new SelectorItemInfo("stocks.material.id"));
            sic.add(new SelectorItemInfo("stocks.material.number"));
            sic.add(new SelectorItemInfo("stocks.material.name"));
            sic.add(new SelectorItemInfo("stocks.unit.id"));
            sic.add(new SelectorItemInfo("stocks.unit.number"));
            sic.add(new SelectorItemInfo("stocks.unit.name"));
            sic.add(new SelectorItemInfo("stocks.baseUnit.id"));
            sic.add(new SelectorItemInfo("stocks.baseUnit.number"));
            sic.add(new SelectorItemInfo("stocks.baseUnit.name"));
            sic.add(new SelectorItemInfo("stocks.operation.number"));
            sic.add(new SelectorItemInfo("stocks.operation.name"));
            sic.add(new SelectorItemInfo("stocks.operation.id"));
            sic.add(new SelectorItemInfo("stocks.workcenter.id"));
            sic.add(new SelectorItemInfo("stocks.workcenter.name"));
            sic.add(new SelectorItemInfo("stocks.workcenter.number"));
        }
        return sic;
    }

    @Override
    protected List _queryMOByFilter(Context ctx, FilterInfo filter, String orgId, boolean isGetMaterial) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        Boolean isNeedStock = ctx.get((Object)"isNeedStock") == null ? Boolean.FALSE : (Boolean)ctx.get((Object)"isNeedStock");
        entityViewInfo.setSelector(this.getMoAdditionalSelectors(isNeedStock));
        entityViewInfo.getSorter().add(new SorterItemInfo("planBeginDate"));
        entityViewInfo.getSorter().add(new SorterItemInfo("number"));
        ManufactureOrderCollection mococn = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(entityViewInfo);
        ArrayList<ManufactureOrderInfo> list = new ArrayList<ManufactureOrderInfo>();
        String materialID = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < mococn.size(); ++i) {
            ManufactureOrderInfo orderInfo = mococn.get(i);
            if (!isNeedStock.booleanValue()) {
                list.add(orderInfo);
                continue;
            }
            ManufactureOrderStockCollection stockCollection = orderInfo.getStocks();
            for (int j = 0; j < stockCollection.size(); ++j) {
                ManufactureOrderStockInfo stockInfo = stockCollection.get(j);
                if (MaterialIssueModeEnum.NOTISSMODE.equals((Object)stockInfo.getIssueMode()) || MaterialIssueModeEnum.STRAIGHT.equals((Object)stockInfo.getIssueMode())) {
                    stockCollection.remove(stockInfo);
                    --j;
                    continue;
                }
                if (isGetMaterial && (MaterialIssueModeEnum.KANBANISSMODE.equals((Object)stockInfo.getIssueMode()) || stockInfo.isIsBackflush() || MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE.equals((Object)stockInfo.getProvideType()))) {
                    stockCollection.remove(stockInfo);
                    --j;
                    continue;
                }
                if (stockInfo.getUnitBaseQty() != null && stockInfo.getUnitBaseQty().compareTo(new BigDecimal("0")) > 0 || stockInfo.getUnitQty().compareTo(new BigDecimal("0")) < 0) continue;
                materialID = stockInfo.getMaterial().getId().toString();
                if (materialID == null) {
                    throw new IllegalArgumentException();
                }
                BigDecimal targetQty = null;
                MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, stockInfo.getUnit().getId().toString());
                MeasureUnitInfo otherUnitInfo = stockInfo.getBaseUnit() == null ? stockInfo.getMaterial().getBaseUnit() : stockInfo.getBaseUnit();
                MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
                if (multiUnifInfo != null && othermultiUnifInfo != null) {
                    BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
                    BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
                    if (baseExchangeRate1 == null) {
                        baseExchangeRate1 = new BigDecimal("1.00");
                    }
                    if (baseExchangeRate2 == null) {
                        baseExchangeRate2 = new BigDecimal("1.00");
                    }
                    BigDecimal baseQty = stockInfo.getUnitQty().multiply(baseExchangeRate1);
                    targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
                }
                stockInfo.setUnitBaseQty(targetQty);
            }
            if (stockCollection.size() <= 0) continue;
            list.add(orderInfo);
        }
        return list;
    }

    private List mappingBillCrossFund(Context ctx, GroupTypeEnum groupType, List crossFunColls, Map reqID, String type) throws BOSException, BTPException, EASBizException {
        ManufactureOrderInfo info;
        int i;
        ArrayList<ManufactureOrderInfo> tempList = new ArrayList<ManufactureOrderInfo>();
        for (i = 0; i < crossFunColls.size(); ++i) {
            info = (ManufactureOrderInfo)crossFunColls.get(i);
            ManufactureOrderInfo otherInfo = (ManufactureOrderInfo)info.clone();
            tempList.add(otherInfo);
        }
        for (i = tempList.size() - 1; i >= 0; --i) {
            info = (ManufactureOrderInfo)tempList.get(i);
            ManufactureOrderStockCollection stocks = info.getStocks();
            for (int j = stocks.size() - 1; j >= 0; --j) {
                ManufactureOrderStockInfo stockinfo = stocks.get(j);
                if (stockinfo.getPickType() != null && stockinfo.getPickType() == PickTypeEnum.OTHERCOMPANY) continue;
                stocks.remove(stockinfo);
            }
            if (stocks.size() != 0) continue;
            tempList.remove(info);
        }
        if (tempList == null || tempList.size() == 0) {
            return null;
        }
        ArrayList<BTPTransformResult> btpList = new ArrayList<BTPTransformResult>();
        BTPTransformResult botpResult = null;
        CoreBillBaseCollection colls = this.getCollByList(tempList);
        if (colls.size() > 0) {
            CrossFundPickBOT crofp = new CrossFundPickBOT(groupType, MaterialTypeEnum.crossFundPick, (IObjectCollection)colls, reqID, type);
            botpResult = crofp.transform(ctx);
            btpList.add(botpResult);
        }
        return btpList;
    }

    private List mappingBillCrossStorage(Context ctx, GroupTypeEnum groupType, List crossOrgColls, Map reqID, String type) throws BOSException, BTPException, EASBizException {
        ManufactureOrderInfo info;
        int i;
        ArrayList<ManufactureOrderInfo> tempList = new ArrayList<ManufactureOrderInfo>();
        for (i = 0; i < crossOrgColls.size(); ++i) {
            info = (ManufactureOrderInfo)crossOrgColls.get(i);
            ManufactureOrderInfo otherInfo = (ManufactureOrderInfo)info.clone();
            tempList.add(otherInfo);
        }
        for (i = tempList.size() - 1; i >= 0; --i) {
            info = (ManufactureOrderInfo)tempList.get(i);
            ManufactureOrderStockCollection stocks = info.getStocks();
            for (int j = stocks.size() - 1; j >= 0; --j) {
                ManufactureOrderStockInfo stockinfo = stocks.get(j);
                if (stockinfo.getPickType() != null && stockinfo.getPickType() == PickTypeEnum.OTHERSTORAGE) continue;
                stocks.remove(stockinfo);
            }
            if (stocks.size() != 0) continue;
            tempList.remove(info);
        }
        if (tempList == null || tempList.size() == 0) {
            return null;
        }
        ArrayList<BTPTransformResult> btpList = new ArrayList<BTPTransformResult>();
        BTPTransformResult botpResult = null;
        CoreBillBaseCollection colls = this.getCollByList(tempList);
        if (colls.size() > 0) {
            CrossStoragePickBOT crosp = new CrossStoragePickBOT(groupType, MaterialTypeEnum.crossStoragePick, (IObjectCollection)colls, reqID, type);
            botpResult = crosp.transform(ctx);
            btpList.add(botpResult);
        }
        return btpList;
    }

    private List mappingBillInner(Context ctx, String botpId, List innerColls, Map reqID, boolean isGetMaterial, String type) throws BOSException, BTPException, EASBizException {
        CoreBillBaseCollection colls = this.getCollByList(innerColls);
        ArrayList<BTPTransformResult> btpList = new ArrayList<BTPTransformResult>();
        BTPTransformResult botpResult = null;
        if (colls.size() > 0) {
            botpResult = this.innerTransform(ctx, botpId, colls, type);
            btpList.add(botpResult);
        }
        return btpList;
    }

    protected BTPTransformResult innerTransform(Context ctx, String botpId, CoreBillBaseCollection sourceColls, String type) throws EASBizException, BOSException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpId)));
        }
        catch (Exception e) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new PlanOrderException(PlanOrderException.RELEASE_BOTP_NOT_EFFECTED);
        }
        LogControllManager.getInstance().disableLog();
        ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        BTPTransformResult result = iBTPManager.transformForBotp(sourceColls, "500AB75E", (IObjectPK)new ObjectUuidPK(botpId));
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        if (!"build".equals(type)) {
            IObjectCollection materialReqBills = result.getBills();
            HashMap<String, String> map = new HashMap<String, String>();
            if (materialReqBills != null) {
                for (int i = 0; i < materialReqBills.size(); ++i) {
                    MaterialReqBillInfo materialReqBill = (MaterialReqBillInfo)materialReqBills.getObject(i);
                    String id = materialReqBill.getId().toString();
                    if (materialReqBill.getNumber() != null) {
                        String number = materialReqBill.getNumber().toString();
                        map.put(id, number);
                        continue;
                    }
                    map.put(id, "");
                }
            }
            if (map.size() > 0) {
                MaterialTransactionPlatformFacadeFactory.getLocalInstance(ctx).delReqBills(map, (MaterialReqBillInfo)result.getBills().getObject(0));
            }
        }
        return result;
    }

    private CoreBillBaseCollection getCollByList(List sourceList) {
        CoreBillBaseCollection colls = new CoreBillBaseCollection();
        if (sourceList != null && sourceList.size() > 0) {
            for (int i = 0; i < sourceList.size(); ++i) {
                ManufactureOrderInfo moinfo = (ManufactureOrderInfo)sourceList.get(i);
                BOSUuid id = moinfo.getId();
                moinfo.setId(BOSUuid.create((String)"1D0D80DD"));
                colls.add((CoreBillBaseInfo)moinfo);
                moinfo.setId(id);
            }
        }
        return colls;
    }

    public CompanyOrgUnitInfo getCompanyOrgByStorageOrg(Context ctx, String storageOrgId) throws EASBizException, BOSException {
        if (storageOrgId == null) {
            return null;
        }
        CompanyOrgUnitInfo ret = null;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 1);
        if (orgCol != null && orgCol.size() > 0) {
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    @Override
    protected List _queryTaskDispBillByFilter(Context ctx, FilterInfo filter, String orgId, DisTaskDispatchCollection dtdColl) throws BOSException, EASBizException {
        GetMoData mo = new GetMoData();
        List mocon = mo.getMODataForTaskDispBill(ctx, orgId, filter, dtdColl);
        return mocon;
    }

    @Override
    protected Map[] _getStockToDoQtyAndOccupy(Context ctx, StockAndOccupyCondition stockAndOccupyCondition, String tempMoTable, String tempStockTable) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)tempMoTable)) {
            return MaterialTransactionPlatformFacadeFactory.getLocalInstance(ctx).getStockAndOccupyByTempTable(stockAndOccupyCondition, tempMoTable, tempStockTable);
        }
        FilterInfo filter = stockAndOccupyCondition.getFilter();
        List conditionInfo = stockAndOccupyCondition.getConditionInfo();
        boolean isUseInvQty = stockAndOccupyCondition.isUseInvQty();
        int formula = stockAndOccupyCondition.getFormula();
        String orgId = stockAndOccupyCondition.getOrgId();
        List ordIdList = stockAndOccupyCondition.getOrdIdList();
        Map[] returnValue = new Map[2];
        if (isUseInvQty) {
            Map stockToDoQtyMap = this._getStockCanToDoQty(ctx, conditionInfo, filter, orgId);
            for (int i = 0; i < conditionInfo.size(); ++i) {
                GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
                GetStockCanToDoConditionInfo returnInfo = (GetStockCanToDoConditionInfo)stockToDoQtyMap.get(info.getStorckID());
                if (returnInfo == null) continue;
                MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
                baseUnitInfo.setId(BOSUuid.read((String)returnInfo.getBaseUnitID()));
                MeasureUnitInfo unitInfo = new MeasureUnitInfo();
                unitInfo.setId(BOSUuid.read((String)info.getUnitID()));
                returnInfo.setQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)info.getMaterialID(), (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)returnInfo.getBaseQty()));
            }
            returnValue[0] = stockToDoQtyMap;
        }
        if (formula != 0) {
            Map occupy;
            returnValue[1] = occupy = this._getProductionOccupy(ctx, conditionInfo, filter, orgId, ordIdList);
        }
        return returnValue;
    }

    @Override
    protected boolean _saveMaterialReqBills(Context ctx, List btpResults) throws BOSException, EASBizException {
        ArrayList<String> auditedBillIdList = new ArrayList<String>();
        BTPTransformResult btpResult = null;
        IMaterialReqBill req = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        if (btpResults != null && btpResults.size() > 0) {
            for (int li = 0; li < btpResults.size(); ++li) {
                btpResult = (BTPTransformResult)btpResults.get(li);
                IObjectCollection materialReqBills = btpResult.getBills();
                IBOTRelation ibot = BOTRelationFactory.getLocalInstance((Context)ctx);
                if (materialReqBills == null) continue;
                for (int i = 0; i < materialReqBills.size(); ++i) {
                    MaterialReqBillInfo materialReqBill = (MaterialReqBillInfo)materialReqBills.getObject(i);
                    HashMap<String, String> reqID = new HashMap<String, String>();
                    reqID.put(materialReqBill.getId().toString(), materialReqBill.getNumber());
                    this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(materialReqBill.getId()), (IObjectValue)materialReqBill, new BOSObjectType("500AB75E"));
                    materialReqBill.setPurchaseType(PurchaseTypeEnum.PURCHASE);
                    if (materialReqBill.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                        req.save((CoreBaseInfo)materialReqBill);
                        continue;
                    }
                    auditedBillIdList.add(materialReqBill.getId().toString());
                }
                for (int jj = 0; jj < btpResult.getBOTRelationCollection().size(); ++jj) {
                    BOTRelationInfo info = btpResult.getBOTRelationCollection().get(jj);
                    if (auditedBillIdList.contains(info.getDestObjectID())) continue;
                    ibot.addnew(info);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean _delOnlyReqBills(Context ctx, Map reqID, MaterialReqBillInfo info) throws BOSException, EASBizException {
        this.delOnlyReqBill(ctx, reqID, info);
        return false;
    }

    protected boolean checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model, BOSObjectType bosType) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (this.isSameNumber(ctx, pk, model, bosType)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{aSCMBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model, BOSObjectType bosType) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this.exists(ctx, filter, bosType);
    }

    private boolean exists(Context ctx, FilterInfo filter, BOSObjectType bosType) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            boolean bl = this.getDAO(ctx, cn, bosType).exists(filter);
            return bl;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            com.kingdee.util.db.SQLUtils.cleanup((Connection)cn);
        }
    }

    private IORMappingDAO getDAO(Context ctx, Connection cn, BOSObjectType bosType) {
        return ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
    }

    protected String genBillTemp(Context ctx, List conditionInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String[] sqls = new String[conditionInfo.size()];
        String inTempTableName = null;
        sql.append("create table ttt (").append("FMaterialID varchar(44) not null,").append("FProjectID varchar(44)  ,").append("FTrackNumberID varchar(44) ").append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            inTempTableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        for (int i = 0; i < conditionInfo.size(); ++i) {
            sql.setLength(0);
            GetStockCanToDoConditionInfo info = (GetStockCanToDoConditionInfo)conditionInfo.get(i);
            String projectId = "";
            String trackNumberId = "";
            if (info.getProjectID() != null && info.getProjectID().length() > 0) {
                projectId = info.getProjectID();
            }
            if (info.getTrackNumID() != null && info.getTrackNumID().length() > 0) {
                trackNumberId = info.getTrackNumID();
            }
            sql.append("insert into ").append(inTempTableName).append("(FMaterialID,FProjectID,FTrackNumberID)").append("\r\n").append(" VALUES ('" + info.getMaterialID() + "','" + projectId + "','" + trackNumberId + "')");
            sqls[i] = sql.toString();
        }
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        return inTempTableName;
    }

    @Override
    protected List _mapppingBillByBotpID(Context ctx, String botpId, List orderIDs, List valuesList, Map reqID, boolean isGetMaterial, String type) throws BOSException, BTPException, EASBizException {
        ArrayList<ManufactureOrderInfo> cbc = new ArrayList<ManufactureOrderInfo>();
        HashMap<String, String> lotInfoMap = new HashMap<String, String>();
        HashMap<String, Timestamp> mfgInfoMap = new HashMap<String, Timestamp>();
        HashMap<String, Timestamp> expInfoMap = new HashMap<String, Timestamp>();
        for (int idIndex = 0; idIndex < orderIDs.size(); ++idIndex) {
            Map idsPriority = (Map)orderIDs.get(idIndex);
            Set entrySet = idsPriority.entrySet();
            for (Map.Entry entry : entrySet) {
                String id = (String)entry.getKey();
                String priority = (String)entry.getValue();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
                view.setFilter(filter);
                view.setSelector(this.getMoSelectors());
                ManufactureOrderCollection mocon = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(view);
                for (int i = 0; i < mocon.size(); ++i) {
                    ManufactureOrderInfo moinfo = mocon.get(i);
                    ManufactureOrderStockCollection stocks = moinfo.getStocks();
                    for (int j = 0; j < stocks.size(); ++j) {
                        boolean flag = false;
                        ManufactureOrderStockInfo stock = stocks.get(j);
                        block4: for (int li = 0; li < valuesList.size(); ++li) {
                            Map valuesMap = (Map)valuesList.get(li);
                            HashMap entrymap = (HashMap)valuesMap.get(stock.getId().toString() + priority);
                            if (entrymap == null) continue;
                            Iterator iterator = entrymap.keySet().iterator();
                            while (iterator.hasNext()) {
                                if (entrymap.get("warehs") != null) {
                                    WarehouseInfo ware = (WarehouseInfo)entrymap.get("warehs");
                                    stock.setWarehouse(ware);
                                } else {
                                    stock.setWarehouse(null);
                                }
                                if (entrymap.get("location") != null) {
                                    LocationInfo locateion = (LocationInfo)entrymap.get("location");
                                    stock.setLocation(locateion);
                                } else {
                                    stock.setLocation(null);
                                }
                                if (entrymap.get("lot") != null) {
                                    String lot = (String)entrymap.get("lot");
                                    stock.setLot(lot);
                                } else {
                                    stock.setLot(null);
                                }
                                if (entrymap.get("exp") != null) {
                                    Date exp = (Date)entrymap.get("exp");
                                    Timestamp expTS = new Timestamp(exp.getTime());
                                    stock.setExg(expTS);
                                } else {
                                    stock.setExg(null);
                                }
                                if (entrymap.get("mfg") != null) {
                                    Date mfg = (Date)entrymap.get("mfg");
                                    Timestamp mfgTS = new Timestamp(mfg.getTime());
                                    stock.setMfg(mfgTS);
                                } else {
                                    stock.setMfg(null);
                                }
                                lotInfoMap.put(stock.getId().toString(), stock.getLot());
                                mfgInfoMap.put(stock.getId().toString(), stock.getMfg());
                                expInfoMap.put(stock.getId().toString(), stock.getExg());
                                if (entrymap.get("UnIssueQty") == null) continue;
                                BigDecimal ZERO = new BigDecimal("0.0");
                                BigDecimal temp = new BigDecimal(entrymap.get("UnIssueQty").toString());
                                BigDecimal baseTemp = new BigDecimal(entrymap.get("UnBaseIssueQty").toString());
                                flag = false;
                                if (temp.compareTo(ZERO) == 0) continue block4;
                                if (isGetMaterial) {
                                    stock.setUnIssueQty(temp);
                                    stock.setUnIssueBaseQty(baseTemp);
                                } else {
                                    stock.setWipQty(temp);
                                    stock.setWipBaseQty(baseTemp);
                                }
                                flag = true;
                                continue block4;
                            }
                        }
                        if (flag) continue;
                        stocks.remove(stock);
                        --j;
                    }
                    if (moinfo.getStocks().size() <= 0) continue;
                    cbc.add(moinfo);
                }
            }
        }
        if (cbc.size() == 0) {
            return null;
        }
        List botpInner = this.mappingBillInner(ctx, botpId, cbc, reqID, isGetMaterial, type);
        for (int j = 0; j < botpInner.size(); ++j) {
            MaterialReqBillCollection mCollection;
            BTPTransformResult result = (BTPTransformResult)botpInner.get(j);
            if (result == null || (mCollection = (MaterialReqBillCollection)result.getBills()) == null || mCollection.size() <= 0) continue;
            for (int m = 0; m < mCollection.size(); ++m) {
                MaterialReqBillEntryCollection mEntryCollection;
                MaterialReqBillInfo mInfo = mCollection.get(m);
                if (mInfo == null || mInfo.size() <= 0 || (mEntryCollection = mInfo.getEntry()) == null || mEntryCollection.size() <= 0) continue;
                for (int n = 0; n < mEntryCollection.size(); ++n) {
                    MaterialReqBillEntryInfo mEntryInfo = mEntryCollection.get(n);
                    if (mEntryInfo == null || mEntryInfo.getSourceBillEntryId() == null) continue;
                    String sourceBillEntryId = mEntryInfo.getSourceBillEntryId().toString();
                    mEntryInfo.setLot((String)lotInfoMap.get(sourceBillEntryId));
                    mEntryInfo.setMfg((Date)mfgInfoMap.get(sourceBillEntryId));
                    mEntryInfo.setExp((Date)expInfoMap.get(sourceBillEntryId));
                }
            }
        }
        return botpInner;
    }

    @Override
    protected Map _queryMoStockByFilter(Context ctx, FilterInfo filter, String orgId, boolean isGetMaterial, String tempMoTableName) throws BOSException, EASBizException {
        String moStockTempTable;
        TempTablePool pool;
        block12: {
            HashMap<String, Object> result = new HashMap<String, Object>();
            pool = TempTablePool.getInstance((Context)ctx);
            StringBuffer moStockTempStr = new StringBuffer();
            moStockTempStr.append("create table t_temp_moStock (");
            moStockTempStr.append("KSQL_SEQ INT default 0 NOT NULL,");
            moStockTempStr.append("FID VARCHAR(44),");
            moStockTempStr.append("FMoId VARCHAR(44),");
            moStockTempStr.append("FUnitQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FUnitBaseQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FPlannedQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FPlannedBaseQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FActIssueQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FActIssueBaseQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FWipQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FBasewipqty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FRejectedQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FRejectedBaseQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FOperationNO INT,");
            moStockTempStr.append("FDemandTime DateTime,");
            moStockTempStr.append("FIssueMode INT,");
            moStockTempStr.append("FProvideType INT,");
            moStockTempStr.append("FTotalDSTransferQty NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FNumber NVARCHAR(80),");
            moStockTempStr.append("FOrgUnitId VARCHAR(44),");
            moStockTempStr.append("FOrgUnitNumber NVARCHAR(80),");
            moStockTempStr.append("FOrgUnitName NVARCHAR(255),");
            moStockTempStr.append("FWareHouseId VARCHAR(44),");
            moStockTempStr.append("FWareHouseNumber NVARCHAR(80),");
            moStockTempStr.append("FWareHouseName NVARCHAR(255),");
            moStockTempStr.append("FHasLocation INT,");
            moStockTempStr.append("FLocationId VARCHAR(44),");
            moStockTempStr.append("FLocationNumber NVARCHAR(80),");
            moStockTempStr.append("FLocationName NVARCHAR(255),");
            moStockTempStr.append("FParentMaterialID VARCHAR(44),");
            moStockTempStr.append("FParentMaterialNumber NVARCHAR(80),");
            moStockTempStr.append("FParentMaterialName NVARCHAR(255),");
            moStockTempStr.append("FMaterialID VARCHAR(44),");
            moStockTempStr.append("FMaterialNumber NVARCHAR(80),");
            moStockTempStr.append("FMaterialName NVARCHAR(255),");
            moStockTempStr.append("FMaterialModel NVARCHAR(255),");
            moStockTempStr.append("FUnitId VARCHAR(44),");
            moStockTempStr.append("FUnitNumber NVARCHAR(80),");
            moStockTempStr.append("FUnitName NVARCHAR(255),");
            moStockTempStr.append("FBaseUnitId VARCHAR(44),");
            moStockTempStr.append("FBaseUnitNumber NVARCHAR(80),");
            moStockTempStr.append("FBaseUnitName NVARCHAR(255),");
            moStockTempStr.append("FOperationId VARCHAR(44),");
            moStockTempStr.append("FOperationNumber NVARCHAR(80),");
            moStockTempStr.append("FOperationName NVARCHAR(255),");
            moStockTempStr.append("FWorkcenterId VARCHAR(44),");
            moStockTempStr.append("FWorkcenterNumber NVARCHAR(80),");
            moStockTempStr.append("FWorkcenterName NVARCHAR(255),");
            moStockTempStr.append("FProjectId VARCHAR(44),");
            moStockTempStr.append("FProjectNumber NVARCHAR(80),");
            moStockTempStr.append("FProjectName NVARCHAR(255),");
            moStockTempStr.append("FTrackId VARCHAR(44),");
            moStockTempStr.append("FTrackNumber NVARCHAR(80),");
            moStockTempStr.append("FTrackName NVARCHAR(255),");
            moStockTempStr.append("FMaterialPlanId VARCHAR(44),");
            moStockTempStr.append("FManufactureStrategyId VARCHAR(44),");
            moStockTempStr.append("FIsolatedRule VARCHAR(20),");
            moStockTempStr.append("FBaseQtyPrecision INT DEFAULT 0,");
            moStockTempStr.append("FQtyPrecision INT DEFAULT 0,");
            moStockTempStr.append("FBaseConvsRate NUMERIC(21,8) DEFAULT 0,");
            moStockTempStr.append("FInvQty NUMERIC(21,8) DEFAULT 0 not null,");
            moStockTempStr.append("FInvBaseQty NUMERIC(21,8) DEFAULT 0 not null,");
            moStockTempStr.append("FOccupyQty NUMERIC(21,8) DEFAULT 0 not null,");
            moStockTempStr.append("FOccupyBaseQty NUMERIC(21,8) DEFAULT 0 not null,");
            moStockTempStr.append("FIsBackFlush INT)");
            moStockTempTable = null;
            moStockTempTable = pool.createTempTable(moStockTempStr.toString());
            String insertSql = MaterialTransactionPlatformFacadeFactory.getLocalInstance(ctx).organizeStockSql(filter, orgId, isGetMaterial, tempMoTableName, moStockTempTable);
            int insertNum = SQLUtils.execute((Context)ctx, (String)insertSql.toString());
            if (insertNum <= 0) break block12;
            int deleteNum = 0;
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append("delete from ");
            deleteSql.append(moStockTempTable);
            deleteSql.append(" where FIssueMode=11040 or FIssueMode=11050");
            deleteNum = SQLUtils.execute((Context)ctx, (String)deleteSql.toString());
            DBUtil.execute((Context)ctx, (String)deleteSql.toString());
            if (isGetMaterial) {
                deleteSql.setLength(0);
                deleteSql.append("delete from ");
                deleteSql.append(moStockTempTable);
                deleteSql.append(" where FIsBackFlush=1");
                deleteNum += SQLUtils.execute((Context)ctx, (String)deleteSql.toString());
                deleteSql.setLength(0);
                deleteSql.append("delete from ");
                deleteSql.append(moStockTempTable);
                deleteSql.append(" where FProvideType=10940");
                deleteNum += SQLUtils.execute((Context)ctx, (String)deleteSql.toString());
            }
            StringBuffer countErrorQty = new StringBuffer();
            countErrorQty.append("select count(*) nums from ");
            countErrorQty.append(moStockTempTable);
            countErrorQty.append(" where FUnitBaseQty<=0 and FUnitQty>0");
            IRowSet countError = DBUtil.executeQuery((Context)ctx, (String)countErrorQty.toString());
            int countErrorNum = 0;
            while (countError != null && countError.next()) {
                countErrorNum = countError.getInt("nums");
            }
            if (countErrorNum > 0) {
                StringBuffer updateSql = new StringBuffer();
                updateSql.append("update ");
                updateSql.append(moStockTempTable);
                updateSql.append(" set FUnitBaseQty =ROUND(Decimal(FUnitQty*FBaseConvsRate,21,8),FBaseQtyPrecision)");
                updateSql.append(" where FUnitBaseQty<=0 and FUnitQty>0");
                DBUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            StringBuffer updateStrategySql = new StringBuffer();
            updateStrategySql.append("update ");
            updateStrategySql.append(moStockTempTable);
            updateStrategySql.append(" set FProjectId = null, FProjectNumber = null,FProjectName = null ");
            updateStrategySql.append(" where FProjectId is not null and FManufactureStrategyId != '");
            updateStrategySql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("'");
            DBUtil.execute((Context)ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(moStockTempTable);
            updateStrategySql.append(" set FTrackId = null, FTrackNumber = null,FTrackName = null ");
            updateStrategySql.append(" where FTrackId is not null and FManufactureStrategyId != '");
            updateStrategySql.append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
            updateStrategySql.append("' and FManufactureStrategyId != '");
            updateStrategySql.append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("' and FManufactureStrategyId != '");
            updateStrategySql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("'");
            DBUtil.execute((Context)ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(moStockTempTable);
            updateStrategySql.append(" set FTrackId = null, FTrackNumber = null,FTrackName = null ");
            updateStrategySql.append(" where FTrackId is not null and FManufactureStrategyId = '");
            updateStrategySql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
            updateStrategySql.append("' and FIsolatedRule = 'ITEM'");
            DBUtil.execute((Context)ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(moStockTempTable);
            updateStrategySql.append(" set FTrackId = '");
            updateStrategySql.append("EgkAAABc3X0Ibpg9");
            updateStrategySql.append("'");
            updateStrategySql.append(" where FTrackId is  null");
            DBUtil.execute((Context)ctx, (String)updateStrategySql.toString());
            updateStrategySql.setLength(0);
            updateStrategySql.append("update ");
            updateStrategySql.append(moStockTempTable);
            updateStrategySql.append(" set FProjectId = '");
            updateStrategySql.append("EgkAAABc3Xza3gXu");
            updateStrategySql.append("'");
            updateStrategySql.append(" where FProjectId is null");
            DBUtil.execute((Context)ctx, (String)updateStrategySql.toString());
            boolean isSelect = false;
            for (FilterItemInfo filterItem : filter.getFilterItems()) {
                String key = filterItem.getPropertyName();
                if (!"id".equals(key)) continue;
                isSelect = true;
            }
            pool.createIndex(moStockTempTable, "FID", true, false);
            pool.createIndex(moStockTempTable, "FMoId", false, false);
            if (isSelect || deleteNum > 0) {
                StringBuffer deleteMoSql = new StringBuffer();
                deleteMoSql.append("delete from ");
                deleteMoSql.append(tempMoTableName);
                deleteMoSql.append(" tempOrder where not exists (select 1 from ");
                deleteMoSql.append(moStockTempTable);
                deleteMoSql.append(" where FMoId=tempOrder.fid)");
                DBUtil.execute((Context)ctx, (String)deleteMoSql.toString());
            }
            StringBuffer sycnPrioritySql = new StringBuffer();
            sycnPrioritySql.append("update ");
            sycnPrioritySql.append(moStockTempTable);
            sycnPrioritySql.append(" t set KSQL_SEQ = ");
            sycnPrioritySql.append("(select KSQL_SEQ from ");
            sycnPrioritySql.append(tempMoTableName);
            sycnPrioritySql.append(" where FID=t.FMoId)");
            DBUtil.execute((Context)ctx, (String)sycnPrioritySql.toString());
            pool.createIndex(moStockTempTable, "FMaterialID,FProjectId,FTrackId", false, false);
            pool.createIndex(moStockTempTable, "KSQL_SEQ", false, false);
            StringBuffer querySql = new StringBuffer();
            querySql.append("select * from ");
            querySql.append(tempMoTableName);
            querySql.append(" tempOrder ");
            querySql.append(" order by KSQL_SEQ");
            IRowSet moRs = DBUtil.executeQuery((Context)ctx, (String)querySql.toString());
            querySql.setLength(0);
            querySql.append("select * from ");
            querySql.append(moStockTempTable);
            querySql.append(" order by KSQL_SEQ");
            IRowSet moStockRs = DBUtil.executeQuery((Context)ctx, (String)querySql.toString());
            result.put("moResult", moRs);
            result.put("moStockResult", moStockRs);
            result.put("moTable", tempMoTableName);
            result.put("moStockTable", moStockTempTable);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        try {
            if (!StringUtils.isEmpty((String)moStockTempTable)) {
                pool.releaseTable(moStockTempTable);
            }
            Map map = null;
            return map;
        }
        catch (Exception e) {
            if (!StringUtils.isEmpty((String)moStockTempTable)) {
                pool.releaseTable(moStockTempTable);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    @Override
    protected String _organizeSQl(Context ctx, FilterInfo filter, String orgId, boolean isGetMaterial, String tempTableName, FilterInfo paramFilter) throws BOSException, EASBizException {
        OrgnizeMoSql orgnizer = new OrgnizeMoSql(ctx, tempTableName, null, filter, paramFilter);
        return orgnizer.orgnize();
    }

    @Override
    protected String _organizeStockSql(Context ctx, FilterInfo filter, String orgId, boolean isGetMaterial, String tempMoTableName, String tempStockTableName) throws BOSException, EASBizException {
        OrgnizeMoStockSql orgnizer = new OrgnizeMoStockSql(ctx, tempMoTableName, tempStockTableName, filter);
        return orgnizer.orgnize();
    }

    @Override
    protected Map _queryMoSqlByFilter(Context ctx, FilterInfo filter, String orgId, boolean isGetMaterial, FilterInfo paremFilter) throws BOSException, EASBizException {
        String moTempTable;
        TempTablePool pool;
        block7: {
            HashMap<String, Object> result = new HashMap<String, Object>();
            pool = TempTablePool.getInstance((Context)ctx);
            StringBuffer moTempStr = new StringBuffer();
            moTempStr.append("create table t_temp_moorder (");
            moTempStr.append("KSQL_SEQ INT IDENTITY (10, 10) NOT NULL,");
            moTempStr.append("FID VARCHAR(44),");
            moTempStr.append("FNumber NVARCHAR(80),");
            moTempStr.append("FBomId VARCHAR(44),");
            moTempStr.append("FBomNumber NVARCHAR(80),");
            moTempStr.append("FBomName NVARCHAR(255),");
            moTempStr.append("FOrgUnitId VARCHAR(44),");
            moTempStr.append("FOrgUnitNumber NVARCHAR(80),");
            moTempStr.append("FOrgUnitName NVARCHAR(255),");
            moTempStr.append("FMaterialID VARCHAR(44),");
            moTempStr.append("FMaterialNumber NVARCHAR(80),");
            moTempStr.append("FMaterialName NVARCHAR(255),");
            moTempStr.append("FMaterialModel NVARCHAR(255),");
            moTempStr.append("FBizTypeId VARCHAR(44),");
            moTempStr.append("FBizTypeNumber NVARCHAR(80),");
            moTempStr.append("FBizTypeName NVARCHAR(255),");
            moTempStr.append("FUnitId VARCHAR(44),");
            moTempStr.append("FUnitNumber NVARCHAR(80),");
            moTempStr.append("FUnitName NVARCHAR(255),");
            moTempStr.append("FProjectId VARCHAR(44),");
            moTempStr.append("FProjectNumber NVARCHAR(80),");
            moTempStr.append("FProjectName NVARCHAR(255),");
            moTempStr.append("FTrackId VARCHAR(44),");
            moTempStr.append("FTrackNumber NVARCHAR(80),");
            moTempStr.append("FTrackName NVARCHAR(255),");
            moTempStr.append("FAdminOrgId VARCHAR(44),");
            moTempStr.append("FAdminOrgNumber NVARCHAR(80),");
            moTempStr.append("FAdminOrgName NVARCHAR(255),");
            moTempStr.append("FPlanBeginDate DateTime,");
            moTempStr.append("FPlanEndDate DateTime,");
            moTempStr.append("FQty NUMERIC(21,8) DEFAULT 0,");
            moTempStr.append("FTotalSplitQty NUMERIC(21,8) DEFAULT 0,");
            moTempStr.append("FQtyPrecision INT DEFAULT 0,");
            moTempStr.append("FBaseConvsRate NUMERIC(21,8) DEFAULT 0,");
            moTempStr.append("FBasestatus INT)");
            moTempTable = null;
            moTempTable = pool.createTempTable(moTempStr.toString());
            String insertSql = MaterialTransactionPlatformFacadeFactory.getLocalInstance(ctx).organizeSQl(filter, orgId, isGetMaterial, moTempTable, paremFilter);
            int insertNum = SQLUtils.execute((Context)ctx, (String)insertSql.toString());
            if (insertNum <= 0) break block7;
            pool.createIndex(moTempTable, "FID", false, false);
            StringBuffer querySql = new StringBuffer();
            querySql.append("select * from ");
            querySql.append(moTempTable);
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)querySql.toString());
            result.put("moResult", rs);
            result.put("moTable", moTempTable);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        try {
            if (!StringUtils.isEmpty((String)moTempTable)) {
                pool.releaseTable(moTempTable);
            }
            Map map = null;
            return map;
        }
        catch (Exception e) {
            if (!StringUtils.isEmpty((String)moTempTable)) {
                pool.releaseTable(moTempTable);
            }
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    @Override
    protected Map[] _getStockAndOccupyByTempTable(Context ctx, StockAndOccupyCondition stockAndOccupyCondition, String tempMoTable, String tempStockTable) throws BOSException, EASBizException {
        boolean isUseInvQty = stockAndOccupyCondition.isUseInvQty();
        int formula = stockAndOccupyCondition.getFormula();
        Map[] returnValue = new Map[2];
        if (isUseInvQty) {
            Map stockToDoQtyMap;
            returnValue[0] = stockToDoQtyMap = this._getStockCanToDoQtyByTempTable(ctx, stockAndOccupyCondition, tempMoTable, tempStockTable);
        }
        if (formula != 0) {
            Map occupy;
            returnValue[1] = occupy = this._getProductionOccupyByTempTable(ctx, stockAndOccupyCondition, tempMoTable, tempStockTable);
        }
        return returnValue;
    }

    @Override
    protected Map _getProductionOccupyByTempTable(Context ctx, StockAndOccupyCondition stockAndOccupyCondition, String tempMoTable, String tempStockTable) throws BOSException, EASBizException {
        FilterInfo filter = stockAndOccupyCondition.getFilter();
        String orgId = stockAndOccupyCondition.getOrgId();
        Map map = new HashMap();
        FilterItemCollection items = filter.getFilterItems();
        Object intWarehouseRange = null;
        Object warehouseObjects = null;
        for (int index = 0; index < items.size(); ++index) {
            FilterItemInfo filterInfo = items.get(index);
            if (filterInfo.getPropertyName().equals("warehouseRange")) {
                intWarehouseRange = filterInfo.getCompareValue();
            }
            if (!filterInfo.getPropertyName().equals("warehouseID")) continue;
            warehouseObjects = filterInfo.getCompareValue();
        }
        if (null != intWarehouseRange && intWarehouseRange.toString().equals(allWarehouse)) {
            AllWarehouseCalculateOccupy awh = new AllWarehouseCalculateOccupy(ctx, tempStockTable, orgId);
            map = (HashMap)awh.get();
        } else if (null != intWarehouseRange && intWarehouseRange.toString().equals(onlyWarehouse)) {
            OnlyPickWarehouseCalculateOccupy calculateInv = new OnlyPickWarehouseCalculateOccupy(ctx, tempStockTable, orgId);
            map = calculateInv.get();
        } else {
            String wareHouseIds = "";
            if (warehouseObjects != null) {
                wareHouseIds = this.exchangeSetToString((Set)warehouseObjects);
            }
            CustomeWarehouseCalculateOccupy calculateInv = new CustomeWarehouseCalculateOccupy(ctx, tempStockTable, orgId, wareHouseIds);
            map = calculateInv.get();
        }
        return map;
    }

    @Override
    protected Map _getStockCanToDoQtyByTempTable(Context ctx, StockAndOccupyCondition stockAndOccupyCondition, String tempMoTable, String tempStockTable) throws BOSException, EASBizException {
        FilterInfo filter = stockAndOccupyCondition.getFilter();
        boolean isUseInvQty = stockAndOccupyCondition.isUseInvQty();
        String orgId = stockAndOccupyCondition.getOrgId();
        BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;
        Map map = new HashMap();
        FilterItemCollection items = filter.getFilterItems();
        Object intWarehouseRange = null;
        Object warehouseObjects = null;
        for (int index = 0; index < items.size(); ++index) {
            FilterItemInfo filterInfo = items.get(index);
            if (filterInfo.getPropertyName().equals("warehouseRange")) {
                intWarehouseRange = filterInfo.getCompareValue();
            }
            if (!filterInfo.getPropertyName().equals("warehouseID")) continue;
            warehouseObjects = filterInfo.getCompareValue();
        }
        if (isUseInvQty) {
            if (allWarehouse.equals(intWarehouseRange.toString())) {
                AllWarehouseCalculateInv calculateInv = new AllWarehouseCalculateInv(ctx, tempStockTable, orgId);
                map = calculateInv.get();
            } else if (onlyWarehouse.equals(intWarehouseRange.toString())) {
                OnlyPickWarehouseCalculateInv calculateInv = new OnlyPickWarehouseCalculateInv(ctx, tempStockTable, orgId);
                map = calculateInv.get();
            } else {
                String wareHouseIds = null;
                if (warehouseObjects != null) {
                    wareHouseIds = this.exchangeSetToString((Set)warehouseObjects);
                }
                CustomeWarehouseCalculateInv calculateInv = new CustomeWarehouseCalculateInv(ctx, tempStockTable, orgId, wareHouseIds);
                map = calculateInv.get();
            }
        }
        return map;
    }

    @Override
    protected void _updateWarehouseID(Context ctx, String tempStockTable, WarehouseInfo info) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)tempStockTable) && info != null) {
            String id = info.getId().toString();
            String number = info.getNumber();
            String name = info.getName();
            StringBuffer updateWarehouse = new StringBuffer();
            updateWarehouse.append("update ");
            updateWarehouse.append(tempStockTable);
            updateWarehouse.append(" set FWareHouseId='");
            updateWarehouse.append(id);
            updateWarehouse.append("', FWareHouseNumber='");
            updateWarehouse.append(number);
            updateWarehouse.append("', FWareHouseName='");
            updateWarehouse.append(name);
            updateWarehouse.append("'");
            DbUtil.execute((Context)ctx, (String)updateWarehouse.toString());
        }
    }
}

