/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ScrapOrderException;
import com.kingdee.eas.mm.mo.app.MOFinish;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;

public class MaterialWriteBackSO
extends BillUpdater {
    private TransactionTypeInfo transTypeInfo;

    public TransactionTypeInfo getTransTypeInfo() {
        return this.transTypeInfo;
    }

    public void setTransTypeInfo(TransactionTypeInfo transTypeInfo) {
        this.transTypeInfo = transTypeInfo;
    }

    public MaterialWriteBackSO(Context ctx) {
        super(ctx);
    }

    public void execute() throws BOSException, EASBizException {
        this.checkMOClose();
        String bizTypeId = this.getBizTypeId();
        if (bizTypeId == null) {
            return;
        }
        if (bizTypeId.equals("RTokg1bVTnu96tSSkSoTzCQHQ1w=") || bizTypeId.equals("3dSAA/m1QcG5RJOez90cEyQHQ1w=")) {
            this.dealScrap();
        } else if (bizTypeId.equals("Nz878AEgEADgAABDwKg/GiQHQ1w=") || bizTypeId.equals("N5d2igEgEADgAABwwKg/GiQHQ1w=")) {
            this.dealFeeding(bizTypeId);
        } else if (bizTypeId.equals("VWlgn1HdReW/rgJ0icgVGSQHQ1w=")) {
            this.dealRedundancy();
        } else if (bizTypeId.equals("mu6sevVMS9+JhGPjGuP7siQHQ1w=") || bizTypeId.equals("HCZs8ltBSBiBTR5keu33YCQHQ1w=")) {
            this.dealSpanOrgFeeding(bizTypeId);
        }
    }

    private String getBizTypeId() throws BOSException {
        String tansTypeId = null;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fbiztypeid ");
        selectSql.append(" from ").append(this.sourceDataTable).append(" s,  ").append(" T_IM_MaterialReqBill t  where t.fid = s.fbillid ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            while (rs != null && rs.next()) {
                tansTypeId = rs.getString("fbiztypeid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return tansTypeId;
    }

    private void dealScrap() throws EASBizException, BOSException {
        if (this.isAuditAction) {
            this.scrapQtyCheck();
        }
        this.writeBackForSo(true);
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        moBiz.calculateWIP(this.sourceDataTable);
        this.updateFields(this.sourceDataTable);
        this.setReleaseTempTable(false);
    }

    private void dealFeeding(String tansTypeId) throws EASBizException, BOSException {
        if (this.isAuditAction) {
            this.supplyQtyCheck();
        }
        this.writeBackForSo(false);
        boolean isWorkScrap = true;
        if (tansTypeId.equals("Nz878AEgEADgAABDwKg/GiQHQ1w=")) {
            isWorkScrap = false;
        }
        this.writeBackForMo(isWorkScrap);
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        moBiz.calculateWIP(this.sourceDataTable);
        this.updateFields(this.sourceDataTable);
    }

    private void dealRedundancy() throws EASBizException, BOSException {
        if (this.isAuditAction) {
            this.supplyQtyCheck();
        }
        this.writeBackForSo(false);
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        moBiz.calculateWIP(this.sourceDataTable);
        this.updateFields(this.sourceDataTable);
    }

    private void dealSpanOrgFeeding(String tansTypeId) throws EASBizException, BOSException {
        if (this.isAuditAction) {
            this.supplyQtyCheck();
        }
        StringBuffer querySQL = new StringBuffer();
        querySQL.append("select ").append("sum(case when t1.FScrapType=10 then 1 else 0 end),").append("sum(case when t1.FScrapType=20 then 1 else 0 end),").append("sum(case when t1.FScrapType=30 then 1 else 0 end) ").append("from t_mm_scraporderentry t1,").append(this.sourceDataTable).append(" t2 where t1.fid = t2.FSourceBillEntryId ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)querySQL.toString());
        boolean isRedundancy = false;
        boolean isRawMaterial = false;
        boolean isRawWork = false;
        try {
            if (rs != null && rs.next()) {
                if (rs.getInt(3) > 0) {
                    isRedundancy = true;
                }
                if (rs.getInt(2) > 0) {
                    isRawMaterial = true;
                }
                if (rs.getInt(1) > 0) {
                    isRawWork = true;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (isRedundancy) {
            this.writeBackForSo(false);
        } else if (isRawMaterial || isRawWork) {
            this.writeBackForSo(false);
            if (isRawMaterial) {
                this.writeBackForMo(false);
            }
            if (isRawWork) {
                this.writeBackForMo(true);
            }
        }
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        moBiz.calculateWIP(this.sourceDataTable);
        this.updateFields(this.sourceDataTable);
    }

    private void writeBackForMo(boolean isWorkScrap) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String tempTableName = BillUpdaterFactory.createTempTable((Context)this.ctx);
        int scrapType = 0;
        if (isWorkScrap) {
            this.setBaseQtyFields(new String[]{"FFeedingBaseQty"});
            this.setQtyFields(new String[]{"FFeedingQty"});
            scrapType = 10;
        } else {
            this.setBaseQtyFields(new String[]{"FMaterialFeedingBaseQty"});
            this.setQtyFields(new String[]{"FMaterialFeedingQty"});
            scrapType = 20;
        }
        sql.setLength(0);
        sql.append("insert into ").append(tempTableName).append(" (FBillID,FSourceBillID,FSourceBillEntryId ,FBaseQty,FQty)").append("select m.FID, s.FSourceBillID,se.FSourceBillEntryID ,me.FBaseQty,me.FQty ").append("from T_IM_MaterialReqBillEntry me,T_MM_ScrapOrderEntry se,T_IM_MaterialReqBill m,T_MM_ScrapOrder s ").append("where me.FSourceBillEntryID = se.FID ").append("and me.FParentID = m.FID ").append("and se.FParentID = s.FID ").append("and m.FID in(").append("select FBillID from ").append(this.sourceDataTable).append(") and se.FScrapType=").append(scrapType);
        MRPUtil.executeUpdate((Context)this.ctx, (String)sql.toString());
        this.setSourceDataTable(tempTableName);
        this.setTargetTable("T_MM_MFTOrderStock");
        this.setTransfUnit(true);
        this.writeBack();
        if (this.isAuditAction) {
            MOFinish.autoFinish(this.ctx, tempTableName, true);
        } else {
            MOFinish.moDefaultUnAutoFinish(this.ctx, tempTableName);
        }
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        pool.releaseTable(tempTableName);
        pool.releaseTable(this.sourceDataTable);
    }

    private void writeBackForSo(boolean isBack) throws EASBizException, BOSException {
        this.setTargetTable("T_MM_ScrapOrderEntry");
        this.setTransfUnit(true);
        this.setThrowException(true);
        if (isBack) {
            this.setBaseQtyFields(new String[]{"FBaseBackQty"});
            this.setQtyFields(new String[]{"FBackQty"});
        } else {
            this.setBaseQtyFields(new String[]{"FBaseSuppliedQty"});
            this.setQtyFields(new String[]{"FSuppliedQty"});
        }
        String sign = this.isAuditAction ? "+" : "-";
        this.setBaseQtyOperation(new String[]{sign});
        this.setQtyOperation(new String[]{sign});
        this.writeBack();
    }

    private boolean scrapQtyCheck() throws BOSException, EASBizException {
        this.setTargetTable("T_MM_ScrapOrderEntry");
        this.setUnBaseQtyExpression("FBaseScrapQty-FBaseBackQty");
        boolean ret = true;
        String expr = this.compileExpr(this.unBaseQtyExpression);
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select distinct FBillID from ");
        sqlBuf.append(this.sourceDataTable).append(" t0 ").append("left outer join (").append("select t1.FID ").append("from ").append(this.targetTable).append(" t1  ").append("inner join (select ").append(this.getFID()).append(" FSRCID,sum(FBaseQty) sum_baseqty ").append("from ").append(this.sourceDataTable).append(" ").append("group by ").append(this.getFID()).append(") t2 ").append("on t1.FID = t2.FSRCID and ").append(expr).append(" - t2.sum_baseqty >= 0 ").append(") t20 on t0.").append(this.getFID()).append(" = t20.FID ").append("where t20.FID is null ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            if (rs != null && rs.next()) {
                ret = false;
                throw new ScrapOrderException(ScrapOrderException.SUMQTY_LESS_ZERO);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private boolean supplyQtyCheck() throws BOSException, EASBizException {
        this.setTargetTable("T_MM_ScrapOrderEntry");
        this.setUnBaseQtyExpression("FBaseSupplyRequiredQty-FBaseSuppliedQty");
        boolean ret = true;
        String expr = this.compileExpr(this.unBaseQtyExpression);
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select distinct FBillID from ");
        sqlBuf.append(this.sourceDataTable).append(" t0 ").append("left outer join (").append("select t1.FID ").append("from ").append(this.targetTable).append(" t1  ").append("inner join (select ").append(this.getFID()).append(" FSRCID,sum(FBaseQty) sum_baseqty ").append("from ").append(this.sourceDataTable).append(" ").append("group by ").append(this.getFID()).append(") t2 ").append("on t1.FID = t2.FSRCID and ").append(expr).append(" >= t2.sum_baseqty ").append(") t20 on t0.").append(this.getFID()).append(" = t20.FID ").append("where t20.FID is null ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            if (rs != null && rs.next()) {
                ret = false;
                throw new ScrapOrderException(ScrapOrderException.SUPPLIEDQTY_MORE_ALLOWEDQTY);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private String compileExpr(String expr) {
        char[] expChars = expr.toCharArray();
        StringBuffer expBuf = new StringBuffer();
        for (int i = 0; i < expChars.length; ++i) {
            if ((expChars[i] >= 'a' && expChars[i] <= 'z' || expChars[i] >= 'A' && expChars[i] <= 'Z') && (i == 0 || i > 0 && (expChars[i - 1] == '+' || expChars[i - 1] == '-' || expChars[i - 1] == ' ' || expChars[i - 1] == '('))) {
                expBuf.append("t1.");
            }
            expBuf.append(expChars[i]);
        }
        return expBuf.toString();
    }

    public boolean checkMOClose() throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fnumber ");
        selectSql.append(" from T_MM_ManufactureOrder mo, ").append(this.sourceDataTable).append(" s,  ").append(" T_IM_MaterialReqBill t , T_MM_ScrapOrderEntry ts").append(" where t.fid = s.fbillid and s.FSourceBillEntryId = ts.fid and  ts.FSourceBillid = mo.fid and  mo.fBaseStatus in (6,7,11) ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            HashSet<String> errSet = new HashSet<String>();
            while (rs != null && rs.next()) {
                String billNumber = rs.getString("fnumber");
                errSet.add(billNumber);
            }
            if (errSet.size() > 0) {
                throw new ManufactureOrderException(ManufactureOrderException.MO_CLOSED, errSet.toArray());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return true;
    }

    private void updateFields(String sourceDataTable) throws BOSException {
        String sqlwhere = " select FSourceBillID from " + sourceDataTable;
        String sql1 = "update T_MM_ScrapOrderEntry set FUnBaseBackQty = (FBaseScrapQty - FBaseBackQty)  where fparentid in (" + sqlwhere + ")";
        String sql2 = "update T_MM_ScrapOrderEntry set FUnBaseSuppliedQty = (FBaseSupplyRequiredQty-FBaseSuppliedQty) where FIsSupplyMaterial = 1 and fparentid in (" + sqlwhere + ")";
        DbUtil.execute((Context)this.ctx, (String)sql1);
        DbUtil.execute((Context)this.ctx, (String)sql2);
    }
}

