/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBomEntry;
import com.kingdee.eas.mm.basedata.IProductionFormulaEntry;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaCollection;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryCollection;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryFactory;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaFactory;
import com.kingdee.eas.mm.basedata.ProductionFormulaInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.mo.IManufactureOrderStock;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.MaterialScopeEnum;
import com.kingdee.eas.mm.mo.OSCaculateParamInfo;
import com.kingdee.eas.mm.mo.OSInvDetailInfo;
import com.kingdee.eas.mm.mo.OSResultInfo;
import com.kingdee.eas.mm.mo.OSSourceInfo;
import com.kingdee.eas.mm.mo.OSStockReserveInfo;
import com.kingdee.eas.mm.mo.OSSubItemInfo;
import com.kingdee.eas.mm.mo.SimPatternEnum;
import com.kingdee.eas.mm.mo.WareHouseScopeEnum;
import com.kingdee.eas.mm.planning.IPlannedOrderEntry;
import com.kingdee.eas.mm.planning.PlannedOrderEntryFactory;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OSCalculation {
    public static final int PRECISION_MAX = 8;
    private static final BigDecimal BIGDECIMAL_MAX = new BigDecimal("1.0E13");
    private SimPatternEnum osSimPattern;
    private StorageOrgUnitInfo osOrgUnitInfo;
    private OSCaculateParamInfo osCalcParam;
    private List osSourceList;
    private List osResultList;
    private List osSubItemList;
    private List osSubItem4WHList;
    private Map subItemMap;
    private List osInvDetailList;
    private List osStockReserveList;
    private Set srcPrdOrderSet;
    private Set srcMnfOrderSet;
    private Set subMaterialSet;
    private Set subMPTSet;
    private Map invMap;
    private Map stockReserveMap;
    private Map simReserveMap;
    private Map stockReserve4WHMap;
    private Map subItem4WHMap;
    private Map osmmuMap;
    private Map keyPartMap;
    private Map productUnitMap;
    private Map materialPlanMap;

    protected Map _oSCalculate(Context ctx, List sourceList, OSCaculateParamInfo calcParam, Map mmuMap, StorageOrgUnitInfo orgUnitInfo, SimPatternEnum simPattern) throws BOSException, EASBizException {
        this.osOrgUnitInfo = orgUnitInfo;
        this.osSimPattern = simPattern;
        this.osSourceList = sourceList;
        this.osCalcParam = calcParam;
        this.osmmuMap = mmuMap;
        this.genOSResult(ctx);
        this.genOSSubItem(ctx);
        this.genSubItem();
        this.genOSInvDetail(ctx);
        this.genOSStockReserve(ctx);
        this.genInvMap();
        this.genStockReserveMap(ctx);
        this.updateOSSubItem(ctx);
        this.calculation(ctx);
        this.genOSSubItem4WH(ctx);
        this.genMMUMap(ctx);
        if (this.osSimPattern.getValue() == 0) {
            this.osSubItemList.clear();
        } else {
            Collections.sort((List)this.osSubItemList, (Comparator)this.getOsSubItemComparator());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("oSResultCollection", this.osResultList);
        result.put("oSSubItemCollection", this.osSubItemList);
        result.put("oSInvDetailCollection", this.osInvDetailList);
        result.put("oSStockReserveCollection", this.osStockReserveList);
        result.put("mmuMap", this.osmmuMap);
        result.put("subItem4WHMap", this.subItem4WHMap);
        return result;
    }

    protected Comparator getOsSubItemComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                OSSubItemInfo osSubItemInfo1 = (OSSubItemInfo)arg0;
                OSSubItemInfo osSubItemInfo2 = (OSSubItemInfo)arg1;
                if (osSubItemInfo1.getPriority().compareTo(osSubItemInfo2.getPriority()) != 0) {
                    return osSubItemInfo1.getPriority().compareTo(osSubItemInfo2.getPriority());
                }
                return osSubItemInfo1.getMaterial().getNumber().compareTo(osSubItemInfo2.getMaterial().getNumber());
            }
        };
    }

    protected void genOSResult(Context ctx) throws BOSException, EASBizException {
        this.osResultList = new ArrayList();
        this.srcPrdOrderSet = new HashSet();
        this.srcMnfOrderSet = new HashSet();
        OSResultInfo osResultInfo = null;
        for (int i = 0; i < this.osSourceList.size(); ++i) {
            OSSourceInfo osSourceInfo = (OSSourceInfo)this.osSourceList.get(i);
            if (osSourceInfo.getSourceType().getValue() != 10 && (osSourceInfo.getBsOrderQty() == null || osSourceInfo.getBsOrderQty().compareTo(SysConstant.BIGZERO) == 0)) continue;
            if (osSourceInfo.getSourceType().getValue() == 30) {
                this.srcPrdOrderSet.add(osSourceInfo.getSourceBillId());
            } else if (osSourceInfo.getSourceType().getValue() == 20) {
                this.srcMnfOrderSet.add(osSourceInfo.getSourceBillId());
            }
            if (this.osSimPattern.getValue() == 1) {
                BigDecimal bsReqOSQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osSourceInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osSourceInfo.getUnit(), (MeasureUnitInfo)osSourceInfo.getBsUnit(), (BigDecimal)osSourceInfo.getReqOSQty());
                osSourceInfo.setBsReqOSQty(bsReqOSQty);
            }
            osResultInfo = this.getOsResultInfo(osSourceInfo);
            this.osResultList.add(osResultInfo);
        }
        Collections.sort((List)this.osResultList, (Comparator)this.getOsResultComparator());
        if (this.osCalcParam.getWarehousescope().getValue() == 20 && this.osCalcParam.getWarehouseSet().size() == 0) {
            this.osCalcParam.setWarehousescope(WareHouseScopeEnum.allScope);
        }
        if (this.osCalcParam.getMaterialscope().getValue() == 20 && this.osCalcParam.getMaterialSet().size() == 0) {
            this.osCalcParam.setMaterialscope(MaterialScopeEnum.allScope);
        }
    }

    protected OSResultInfo getOsResultInfo(OSSourceInfo osSourceInfo) {
        OSResultInfo osResultInfo = new OSResultInfo();
        osResultInfo.setPriority(osSourceInfo.getPriority());
        osResultInfo.setSourceType(osSourceInfo.getSourceType());
        osResultInfo.setSourceBillNumber(osSourceInfo.getSourceBillNumber());
        osResultInfo.setBaseStatus(osSourceInfo.getBaseStatus());
        osResultInfo.setProject(osSourceInfo.getProject());
        osResultInfo.setTrackNumber(osSourceInfo.getTrackNumber());
        osResultInfo.setMaterial(osSourceInfo.getMaterial());
        osResultInfo.setUnit(osSourceInfo.getUnit());
        osResultInfo.setBsUnit(osSourceInfo.getBsUnit());
        osResultInfo.setReqOSQty(osSourceInfo.getReqOSQty());
        osResultInfo.setBsReqOSQty(osSourceInfo.getBsReqOSQty());
        osResultInfo.setIsGenerated(false);
        osResultInfo.setIsReleased(false);
        osResultInfo.setOSSourceId(osSourceInfo.getId().toString());
        osResultInfo.setSourceBillId(osSourceInfo.getSourceBillId());
        osResultInfo.setThrowMode(osSourceInfo.getThrowMode());
        return osResultInfo;
    }

    protected Comparator getOsResultComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                OSResultInfo osResultInfo1 = (OSResultInfo)arg0;
                OSResultInfo osResultInfo2 = (OSResultInfo)arg1;
                return osResultInfo1.getPriority().compareTo(osResultInfo2.getPriority());
            }
        };
    }

    protected void genOSSubItem(Context ctx) throws BOSException, EASBizException {
        int i;
        this.osSubItemList = new ArrayList();
        this.subMaterialSet = new HashSet();
        this.subMPTSet = new HashSet();
        this.keyPartMap = new HashMap();
        boolean isKeyPartOnly = this.osCalcParam.isOnlycalKeyMat();
        int materialscope = this.osCalcParam.getMaterialscope().getValue();
        Set materialScopeSet = this.osCalcParam.getMaterialSet();
        String orgUnitId = this.osOrgUnitInfo.getId().toString();
        for (i = 0; i < this.osSourceList.size(); ++i) {
            String key;
            String trackNumberId;
            String projectId;
            String[] temp;
            String materialId;
            OSSubItemInfo osSubItemInfo;
            int j;
            HashSet<Integer> provideTypeSet;
            HashSet<Integer> issModeSet;
            SelectorItemCollection coll;
            FilterInfo filter;
            EntityViewInfo view;
            OSSourceInfo osSourceInfo = (OSSourceInfo)this.osSourceList.get(i);
            if (osSourceInfo.getSourceType().getValue() != 10 && (osSourceInfo.getBsOrderQty() == null || osSourceInfo.getBsOrderQty().compareTo(SysConstant.BIGZERO) == 0)) continue;
            int sourceType = osSourceInfo.getSourceType().getValue();
            if (sourceType == 30) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                coll = new SelectorItemCollection();
                view.setFilter(filter);
                view.setSelector(coll);
                coll.add(new SelectorItemInfo("*"));
                coll.add(new SelectorItemInfo("material.id"));
                coll.add(new SelectorItemInfo("material.name"));
                coll.add(new SelectorItemInfo("material.number"));
                coll.add(new SelectorItemInfo("material.model"));
                coll.add(new SelectorItemInfo("unit.id"));
                coll.add(new SelectorItemInfo("unit.name"));
                coll.add(new SelectorItemInfo("unit.number"));
                coll.add(new SelectorItemInfo("baseUnit.id"));
                coll.add(new SelectorItemInfo("baseUnit.name"));
                coll.add(new SelectorItemInfo("baseUnit.number"));
                coll.add(new SelectorItemInfo("defaultWarehouse.id"));
                coll.add(new SelectorItemInfo("defaultWarehouse.name"));
                coll.add(new SelectorItemInfo("defaultWarehouse.number"));
                coll.add(new SelectorItemInfo("materialInventory.id"));
                coll.add(new SelectorItemInfo("materialInventory.isKeyPart"));
                coll.add(new SelectorItemInfo("parent.*"));
                coll.add(new SelectorItemInfo("productLineWP.name"));
                coll.add(new SelectorItemInfo("productLineWP.number"));
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)osSourceInfo.getSourceBillId(), CompareType.EQUALS));
                issModeSet = new HashSet();
                issModeSet.add(new Integer(11010));
                filter.getFilterItems().add(new FilterItemInfo("issMode", issModeSet, CompareType.INCLUDE));
                provideTypeSet = new HashSet();
                provideTypeSet.add(new Integer(10910));
                provideTypeSet.add(new Integer(10920));
                filter.getFilterItems().add(new FilterItemInfo("provideType", provideTypeSet, CompareType.INCLUDE));
                if (isKeyPartOnly) {
                    filter.getFilterItems().add(new FilterItemInfo("materialInventory.isKeyPart", (Object)Boolean.TRUE, CompareType.EQUALS));
                }
                if (materialscope == 20) {
                    filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialScopeSet, CompareType.INCLUDE));
                }
                IProductionOrderStockEntry iprdEntry = ProductionOrderStockEntryFactory.getLocalInstance((Context)ctx);
                ProductionOrderStockEntryCollection prdEntryColl = iprdEntry.getProductionOrderStockEntryCollection(view);
                for (j = 0; j < prdEntryColl.size(); ++j) {
                    ProductionOrderStockEntryInfo prdEntryInfo = prdEntryColl.get(j);
                    osSubItemInfo = new OSSubItemInfo();
                    materialId = prdEntryInfo.getMaterial().getId().toString();
                    this.subMaterialSet.add(materialId);
                    temp = StoreCommonUtil.getProjectIdAndTrackNumberId((Context)ctx, (ProjectInfo)osSourceInfo.getProject(), (TrackNumberInfo)osSourceInfo.getTrackNumber(), (String)orgUnitId, (String)materialId, (int)2);
                    projectId = temp[0];
                    trackNumberId = temp[1];
                    if (!"".equals(projectId)) {
                        osSubItemInfo.setProject(osSourceInfo.getProject());
                    }
                    if (!"".equals(trackNumberId)) {
                        osSubItemInfo.setTrackNumber(osSourceInfo.getTrackNumber());
                    }
                    osSubItemInfo.setPriority(osSourceInfo.getPriority());
                    osSubItemInfo.setSourceType(osSourceInfo.getSourceType());
                    osSubItemInfo.setSourceBillNumber(osSourceInfo.getSourceBillNumber());
                    osSubItemInfo.setMaterial(prdEntryInfo.getMaterial());
                    osSubItemInfo.setUnit(prdEntryInfo.getUnit());
                    osSubItemInfo.setBsUnit(prdEntryInfo.getBaseUnit());
                    osSubItemInfo.setIsKeyPart(prdEntryInfo.getMaterialInventory().isIsKeyPart());
                    BigDecimal bsStandardQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)prdEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)prdEntryInfo.getUnit(), (MeasureUnitInfo)prdEntryInfo.getBaseUnit(), (BigDecimal)prdEntryInfo.getQty());
                    osSubItemInfo.setUnitBaseQty(bsStandardQty.divide(prdEntryInfo.getParent().getBaseQty(), 8, 4));
                    if (osSubItemInfo.getUnitBaseQty().compareTo(SysConstant.BIGZERO) == 0) continue;
                    if (this.osSimPattern.getValue() == 1) {
                        osSubItemInfo.setBsReqQty(osSourceInfo.getBsReqOSQty().multiply(osSubItemInfo.getUnitBaseQty()));
                    }
                    osSubItemInfo.setWareHouse(prdEntryInfo.getDefaultWarehouse());
                    osSubItemInfo.setInvQty(SysConstant.BIGZERO);
                    osSubItemInfo.setBsInvQty(SysConstant.BIGZERO);
                    osSubItemInfo.setStockReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setBsStockReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setSimReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setBsSimReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setOSSourceId(osSourceInfo.getId().toString());
                    osSubItemInfo.setOperationNo(prdEntryInfo.getProductLineWP() != null ? prdEntryInfo.getProductLineWP().getNumber() : null);
                    osSubItemInfo.setOperationName(prdEntryInfo.getProductLineWP() != null ? prdEntryInfo.getProductLineWP().getName() : null);
                    osSubItemInfo.setOperationNumber(null);
                    this.addToOsSubItemCollection(osSubItemInfo);
                    String key2 = materialId + projectId + trackNumberId;
                    this.subMPTSet.add(key2);
                    this.keyPartMap.put(prdEntryInfo.getMaterial().getId().toString(), new Boolean(prdEntryInfo.getMaterialInventory().isIsKeyPart()));
                }
                continue;
            }
            if (sourceType == 20) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                coll = new SelectorItemCollection();
                view.setFilter(filter);
                view.setSelector(coll);
                coll.add(new SelectorItemInfo("*"));
                coll.add(new SelectorItemInfo("material.id"));
                coll.add(new SelectorItemInfo("material.name"));
                coll.add(new SelectorItemInfo("material.number"));
                coll.add(new SelectorItemInfo("material.model"));
                coll.add(new SelectorItemInfo("unit.id"));
                coll.add(new SelectorItemInfo("unit.name"));
                coll.add(new SelectorItemInfo("unit.number"));
                coll.add(new SelectorItemInfo("baseUnit.id"));
                coll.add(new SelectorItemInfo("baseUnit.name"));
                coll.add(new SelectorItemInfo("baseUnit.number"));
                coll.add(new SelectorItemInfo("warehouse.id"));
                coll.add(new SelectorItemInfo("warehouse.name"));
                coll.add(new SelectorItemInfo("warehouse.number"));
                coll.add(new SelectorItemInfo("operation.number"));
                coll.add(new SelectorItemInfo("operation.name"));
                coll.add(new SelectorItemInfo("parent.*"));
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)osSourceInfo.getSourceBillId(), CompareType.EQUALS));
                issModeSet = new HashSet<Integer>();
                issModeSet.add(new Integer(11010));
                filter.getFilterItems().add(new FilterItemInfo("issueMode", issModeSet, CompareType.INCLUDE));
                provideTypeSet = new HashSet<Integer>();
                provideTypeSet.add(new Integer(10910));
                provideTypeSet.add(new Integer(10920));
                filter.getFilterItems().add(new FilterItemInfo("provideType", provideTypeSet, CompareType.INCLUDE));
                if (materialscope == 20) {
                    filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialScopeSet, CompareType.INCLUDE));
                }
                IManufactureOrderStock imnfEntry = ManufactureOrderStockFactory.getLocalInstance(ctx);
                CoreBaseCollection mnfEntryColl = imnfEntry.getCollection(view);
                for (j = 0; j < mnfEntryColl.size(); ++j) {
                    ManufactureOrderStockInfo mnfEntryInfo = (ManufactureOrderStockInfo)mnfEntryColl.get(j);
                    osSubItemInfo = new OSSubItemInfo();
                    materialId = mnfEntryInfo.getMaterial().getId().toString();
                    temp = StoreCommonUtil.getProjectIdAndTrackNumberId((Context)ctx, (ProjectInfo)osSourceInfo.getProject(), (TrackNumberInfo)osSourceInfo.getTrackNumber(), (String)orgUnitId, (String)materialId, (int)1);
                    projectId = temp[0];
                    trackNumberId = temp[1];
                    if (!"".equals(projectId)) {
                        osSubItemInfo.setProject(osSourceInfo.getProject());
                    }
                    if (!"".equals(trackNumberId)) {
                        osSubItemInfo.setTrackNumber(osSourceInfo.getTrackNumber());
                    }
                    osSubItemInfo.setPriority(osSourceInfo.getPriority());
                    osSubItemInfo.setSourceType(osSourceInfo.getSourceType());
                    osSubItemInfo.setSourceBillNumber(osSourceInfo.getSourceBillNumber());
                    osSubItemInfo.setMaterial(mnfEntryInfo.getMaterial());
                    osSubItemInfo.setUnit(mnfEntryInfo.getUnit());
                    osSubItemInfo.setBsUnit(mnfEntryInfo.getBaseUnit());
                    BigDecimal bsStandardQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)mnfEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)mnfEntryInfo.getUnit(), (MeasureUnitInfo)mnfEntryInfo.getBaseUnit(), (BigDecimal)mnfEntryInfo.getPlannedQty());
                    osSubItemInfo.setUnitBaseQty(bsStandardQty.divide(mnfEntryInfo.getParent().getBaseQty(), 8, 4));
                    if (osSubItemInfo.getUnitBaseQty().compareTo(SysConstant.BIGZERO) == 0) continue;
                    if (this.osSimPattern.getValue() == 1) {
                        osSubItemInfo.setBsReqQty(osSourceInfo.getBsReqOSQty().multiply(osSubItemInfo.getUnitBaseQty()));
                    }
                    osSubItemInfo.setWareHouse(mnfEntryInfo.getWarehouse());
                    osSubItemInfo.setInvQty(SysConstant.BIGZERO);
                    osSubItemInfo.setBsInvQty(SysConstant.BIGZERO);
                    osSubItemInfo.setStockReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setBsStockReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setSimReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setBsSimReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo.setOSSourceId(osSourceInfo.getId().toString());
                    Integer operationNo = new Integer(mnfEntryInfo.getOperationNo());
                    osSubItemInfo.setOperationNo(operationNo != null ? operationNo.toString() : null);
                    osSubItemInfo.setOperationNumber(mnfEntryInfo.getOperation() != null ? mnfEntryInfo.getOperation().getNumber() : null);
                    osSubItemInfo.setOperationName(mnfEntryInfo.getOperation() != null ? mnfEntryInfo.getOperation().getName() : null);
                    boolean isKeyPart = this.getKeyPart(materialId, ctx);
                    osSubItemInfo.setIsKeyPart(isKeyPart);
                    if ((!isKeyPartOnly || !isKeyPart) && isKeyPartOnly) continue;
                    this.addToOsSubItemCollection(osSubItemInfo);
                    this.subMaterialSet.add(materialId);
                    key = materialId + projectId + trackNumberId;
                    this.subMPTSet.add(key);
                }
                continue;
            }
            if (sourceType == 40) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                coll = new SelectorItemCollection();
                view.setFilter(filter);
                view.setSelector(coll);
                coll.add(new SelectorItemInfo("*"));
                coll.add(new SelectorItemInfo("material.id"));
                coll.add(new SelectorItemInfo("material.name"));
                coll.add(new SelectorItemInfo("material.number"));
                coll.add(new SelectorItemInfo("material.model"));
                coll.add(new SelectorItemInfo("unit.id"));
                coll.add(new SelectorItemInfo("unit.name"));
                coll.add(new SelectorItemInfo("baseUnit.number"));
                coll.add(new SelectorItemInfo("baseUnit.id"));
                coll.add(new SelectorItemInfo("baseUnit.name"));
                coll.add(new SelectorItemInfo("baseUnit.number"));
                coll.add(new SelectorItemInfo("parent.*"));
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)osSourceInfo.getSourceBillId(), CompareType.EQUALS));
                HashSet<Integer> provideTypeSet2 = new HashSet<Integer>();
                provideTypeSet2.add(new Integer(10910));
                provideTypeSet2.add(new Integer(10920));
                filter.getFilterItems().add(new FilterItemInfo("provideType", provideTypeSet2, CompareType.INCLUDE));
                if (materialscope == 20) {
                    filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialScopeSet, CompareType.INCLUDE));
                }
                IPlannedOrderEntry iplannedEntry = PlannedOrderEntryFactory.getLocalInstance((Context)ctx);
                CoreBaseCollection plannedEntryColl = iplannedEntry.getCollection(view);
                for (int j2 = 0; j2 < plannedEntryColl.size(); ++j2) {
                    boolean isKeyPart;
                    PlannedOrderEntryInfo plannedEntryInfo = (PlannedOrderEntryInfo)plannedEntryColl.get(j2);
                    OSSubItemInfo osSubItemInfo2 = new OSSubItemInfo();
                    String materialId2 = plannedEntryInfo.getMaterial().getId().toString();
                    String[] temp2 = StoreCommonUtil.getProjectIdAndTrackNumberId((Context)ctx, (ProjectInfo)osSourceInfo.getProject(), (TrackNumberInfo)osSourceInfo.getTrackNumber(), (String)orgUnitId, (String)materialId2, (int)2);
                    String projectId2 = temp2[0];
                    String trackNumberId2 = temp2[1];
                    if (!"".equals(projectId2)) {
                        osSubItemInfo2.setProject(osSourceInfo.getProject());
                    }
                    if (!"".equals(trackNumberId2)) {
                        osSubItemInfo2.setTrackNumber(osSourceInfo.getTrackNumber());
                    }
                    osSubItemInfo2.setPriority(osSourceInfo.getPriority());
                    osSubItemInfo2.setSourceType(osSourceInfo.getSourceType());
                    osSubItemInfo2.setSourceBillNumber(osSourceInfo.getSourceBillNumber());
                    osSubItemInfo2.setMaterial(plannedEntryInfo.getMaterial());
                    osSubItemInfo2.setUnit(plannedEntryInfo.getUnit());
                    osSubItemInfo2.setBsUnit(plannedEntryInfo.getBaseUnit());
                    BigDecimal bsStandardQty = plannedEntryInfo.getBaseDemandQty();
                    osSubItemInfo2.setUnitBaseQty(bsStandardQty.divide(plannedEntryInfo.getParent().getBaseQty(), 8, 4));
                    if (osSubItemInfo2.getUnitBaseQty().compareTo(SysConstant.BIGZERO) == 0) continue;
                    if (this.osSimPattern.getValue() == 1) {
                        osSubItemInfo2.setBsReqQty(osSourceInfo.getBsReqOSQty().multiply(osSubItemInfo2.getUnitBaseQty()));
                    }
                    osSubItemInfo2.setWareHouse(null);
                    osSubItemInfo2.setInvQty(SysConstant.BIGZERO);
                    osSubItemInfo2.setBsInvQty(SysConstant.BIGZERO);
                    osSubItemInfo2.setStockReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo2.setBsStockReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo2.setSimReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo2.setBsSimReserveQty(SysConstant.BIGZERO);
                    osSubItemInfo2.setOSSourceId(osSourceInfo.getId().toString());
                    if (this.keyPartMap.containsKey(materialId2)) {
                        isKeyPart = (Boolean)this.keyPartMap.get(materialId2);
                    } else {
                        isKeyPart = this.getKeyPart(materialId2, ctx);
                        this.keyPartMap.put(materialId2, new Boolean(isKeyPart));
                    }
                    osSubItemInfo2.setIsKeyPart(isKeyPart);
                    BomEntryInfo info = this.getBomIssueMode(ctx, plannedEntryInfo.getSourceBillEntryId());
                    if (info != null && info.getDefaultWarehouse() != null) {
                        osSubItemInfo2.setWareHouse(info.getDefaultWarehouse());
                    }
                    HashSet<MaterialIssueModeEnum> issModeSet2 = new HashSet<MaterialIssueModeEnum>();
                    issModeSet2.add(MaterialIssueModeEnum.PRODUCEISSMODE);
                    if ((!isKeyPartOnly || !isKeyPart) && isKeyPartOnly || info != null && info.getIssMode() != null && !issModeSet2.contains(info.getIssMode())) continue;
                    this.addToOsSubItemCollection(osSubItemInfo2);
                    this.subMaterialSet.add(materialId2);
                    key = materialId2 + projectId2 + trackNumberId2;
                    this.subMPTSet.add(key);
                }
                continue;
            }
            if (sourceType != 10) continue;
            ProductionFormulaInfo formulaInfo = osSourceInfo.getFormula();
            ProductLineInfo productLineInfo = osSourceInfo.getProductLine();
            BomInfo bomInfo = osSourceInfo.getBom();
            if (formulaInfo != null && productLineInfo != null) {
                String formulaId = formulaInfo.getId().toString();
                this.formulaExpand(ctx, formulaId, isKeyPartOnly, materialscope, materialScopeSet, osSourceInfo, 0, "", new BigDecimal(1.0));
                continue;
            }
            if (bomInfo == null) continue;
            String bomId = bomInfo.getId().toString();
            this.bomExpand(ctx, bomId, isKeyPartOnly, materialscope, materialScopeSet, osSourceInfo, 0, "", new BigDecimal(1.0));
        }
        if (this.osSimPattern.getValue() == 1) {
            for (i = 0; i < this.osSubItemList.size(); ++i) {
                OSSubItemInfo temp = (OSSubItemInfo)this.osSubItemList.get(i);
                BigDecimal reqQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)temp.getMaterial().getId().toString(), (MeasureUnitInfo)temp.getBsUnit(), (MeasureUnitInfo)temp.getUnit(), (BigDecimal)temp.getBsReqQty());
                temp.setReqQty(reqQty);
            }
        }
    }

    protected BomEntryInfo getBomIssueMode(Context ctx, String bomEntryId) throws BOSException {
        BomEntryInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(coll);
        coll.add(new SelectorItemInfo("issMode"));
        coll.add(new SelectorItemInfo("defaultWarehouse.id"));
        coll.add(new SelectorItemInfo("defaultWarehouse.name"));
        coll.add(new SelectorItemInfo("defaultWarehouse.number"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bomEntryId, CompareType.EQUALS));
        IBomEntry ibomEntry = BomEntryFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection collection = ibomEntry.getCollection(view);
        if (collection != null && collection.size() > 0) {
            info = (BomEntryInfo)collection.get(0);
        }
        return info;
    }

    protected void formulaExpand(Context ctx, String formulaId, boolean isKeyPartOnly, int materialscope, Set materialScopeSet, OSSourceInfo osSourceInfo, int level, String path, BigDecimal tempBaseQty) throws BOSException, EASBizException {
        if (level >= 9) {
            return;
        }
        if (level == 0) {
            path = osSourceInfo.getMaterial().getId().toString();
        }
        ++level;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(coll);
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("material.id"));
        coll.add(new SelectorItemInfo("material.name"));
        coll.add(new SelectorItemInfo("material.number"));
        coll.add(new SelectorItemInfo("material.model"));
        coll.add(new SelectorItemInfo("unit.id"));
        coll.add(new SelectorItemInfo("unit.name"));
        coll.add(new SelectorItemInfo("unit.number"));
        coll.add(new SelectorItemInfo("baseUnit.id"));
        coll.add(new SelectorItemInfo("baseUnit.name"));
        coll.add(new SelectorItemInfo("baseUnit.number"));
        coll.add(new SelectorItemInfo("warehouse.id"));
        coll.add(new SelectorItemInfo("warehouse.name"));
        coll.add(new SelectorItemInfo("warehouse.number"));
        coll.add(new SelectorItemInfo("materialInventory.id"));
        coll.add(new SelectorItemInfo("materialInventory.isKeyPart"));
        coll.add(new SelectorItemInfo("materialInventory.materialAttr"));
        coll.add(new SelectorItemInfo("parent.*"));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)formulaId, CompareType.EQUALS));
        HashSet<Integer> issModeSet = new HashSet<Integer>();
        issModeSet.add(new Integer(11010));
        filter.getFilterItems().add(new FilterItemInfo("pickingMode", issModeSet, CompareType.INCLUDE));
        HashSet<Integer> provideTypeSet = new HashSet<Integer>();
        provideTypeSet.add(new Integer(10910));
        provideTypeSet.add(new Integer(10920));
        filter.getFilterItems().add(new FilterItemInfo("provideType", provideTypeSet, CompareType.INCLUDE));
        if (isKeyPartOnly) {
            filter.getFilterItems().add(new FilterItemInfo("materialInventory.isKeyPart", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        if (materialscope == 20) {
            FilterInfo filterPart2 = new FilterInfo();
            filterPart2.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialScopeSet, CompareType.INCLUDE));
            filterPart2.getFilterItems().add(new FilterItemInfo("materialInventory.materialAttr", (Object)new Integer(10020), CompareType.EQUALS));
            filterPart2.setMaskString("#0 OR #1");
            filter.mergeFilter(filterPart2, "AND");
        }
        IProductionFormulaEntry iformulaEntry = ProductionFormulaEntryFactory.getLocalInstance((Context)ctx);
        ProductionFormulaEntryCollection formulaEntryColl = iformulaEntry.getProductionFormulaEntryCollection(view);
        for (int j = 0; j < formulaEntryColl.size(); ++j) {
            ProductionFormulaEntryInfo formulaEntryInfo = formulaEntryColl.get(j);
            BigDecimal unitBaseQty = null;
            if (formulaEntryInfo.getConsumeType().getValue() == 30) {
                BigDecimal bsProportion = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)formulaEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)formulaEntryInfo.getUnit(), (MeasureUnitInfo)formulaEntryInfo.getBaseUnit(), (BigDecimal)formulaEntryInfo.getProportion());
                unitBaseQty = bsProportion.divide(new BigDecimal(100), 8, 4);
            } else {
                BigDecimal bsParentQty = formulaEntryInfo.getParent().getProductBaseQty();
                unitBaseQty = formulaEntryInfo.getConsumeFixBaseQty().divide(bsParentQty, 8, 4);
            }
            if (formulaEntryInfo.getMaterialInventory().getMaterialAttr().getValue() == 10020) {
                if (path.indexOf(formulaEntryInfo.getMaterial().getId().toString()) >= 0) continue;
                String nextPath = path + formulaEntryInfo.getMaterial().getId().toString();
                BigDecimal resultQty = tempBaseQty.multiply(unitBaseQty);
                FilterInfo subformulaFilterInfo = new FilterInfo();
                EntityViewInfo subformulaViewInfo = new EntityViewInfo();
                subformulaFilterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)formulaEntryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
                subformulaFilterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE, CompareType.EQUALS));
                subformulaFilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
                subformulaFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.osOrgUnitInfo.getId().toString(), CompareType.EQUALS));
                subformulaViewInfo.getSelector().add(new SelectorItemInfo("id"));
                subformulaViewInfo.setFilter(subformulaFilterInfo);
                ProductionFormulaCollection subformulaColl = ProductionFormulaFactory.getLocalInstance((Context)ctx).getProductionFormulaCollection(subformulaViewInfo);
                if (subformulaColl == null || subformulaColl.isEmpty()) continue;
                ProductionFormulaInfo subformulaInfo = subformulaColl.get(0);
                this.formulaExpand(ctx, subformulaInfo.getId().toString(), isKeyPartOnly, materialscope, materialScopeSet, osSourceInfo, level, nextPath, resultQty);
                continue;
            }
            OSSubItemInfo osSubItemInfo = new OSSubItemInfo();
            String materialId = formulaEntryInfo.getMaterial().getId().toString();
            this.subMaterialSet.add(materialId);
            String[] temp = StoreCommonUtil.getProjectIdAndTrackNumberId((Context)ctx, (ProjectInfo)osSourceInfo.getProject(), (TrackNumberInfo)osSourceInfo.getTrackNumber(), (String)this.osOrgUnitInfo.getId().toString(), (String)materialId, (int)1);
            String projectId = temp[0];
            String trackNumberId = temp[1];
            if (!"".equals(projectId)) {
                osSubItemInfo.setProject(osSourceInfo.getProject());
            }
            if (!"".equals(trackNumberId)) {
                osSubItemInfo.setTrackNumber(osSourceInfo.getTrackNumber());
            }
            osSubItemInfo.setPriority(osSourceInfo.getPriority());
            osSubItemInfo.setSourceType(osSourceInfo.getSourceType());
            osSubItemInfo.setSourceBillNumber(osSourceInfo.getSourceBillNumber());
            osSubItemInfo.setMaterial(formulaEntryInfo.getMaterial());
            osSubItemInfo.setUnit(formulaEntryInfo.getUnit());
            osSubItemInfo.setBsUnit(formulaEntryInfo.getBaseUnit());
            osSubItemInfo.setIsKeyPart(formulaEntryInfo.getMaterialInventory().isIsKeyPart());
            osSubItemInfo.setUnitBaseQty(tempBaseQty.multiply(unitBaseQty));
            if (osSubItemInfo.getUnitBaseQty().compareTo(SysConstant.BIGZERO) == 0) continue;
            if (this.osSimPattern.getValue() == 1) {
                osSubItemInfo.setBsReqQty(osSourceInfo.getBsReqOSQty().multiply(tempBaseQty.multiply(unitBaseQty)));
            }
            osSubItemInfo.setWareHouse(formulaEntryInfo.getWarehouse());
            osSubItemInfo.setInvQty(SysConstant.BIGZERO);
            osSubItemInfo.setBsInvQty(SysConstant.BIGZERO);
            osSubItemInfo.setStockReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setBsStockReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setSimReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setBsSimReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setOSSourceId(osSourceInfo.getId().toString());
            this.addToOsSubItemCollection(osSubItemInfo);
            String key = materialId + projectId + trackNumberId;
            this.subMPTSet.add(key);
            this.keyPartMap.put(formulaEntryInfo.getMaterial().getId().toString(), new Boolean(formulaEntryInfo.getMaterialInventory().isIsKeyPart()));
        }
    }

    protected void bomExpand(Context ctx, String bomId, boolean isKeyPartOnly, int materialscope, Set materialScopeSet, OSSourceInfo osSourceInfo, int level, String path, BigDecimal tempBaseQty) throws BOSException, EASBizException {
        if (level >= 9) {
            return;
        }
        if (level == 0) {
            path = osSourceInfo.getMaterial().getId().toString();
        }
        ++level;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(coll);
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("material.id"));
        coll.add(new SelectorItemInfo("material.name"));
        coll.add(new SelectorItemInfo("material.number"));
        coll.add(new SelectorItemInfo("material.model"));
        coll.add(new SelectorItemInfo("unit.id"));
        coll.add(new SelectorItemInfo("unit.name"));
        coll.add(new SelectorItemInfo("unit.number"));
        coll.add(new SelectorItemInfo("baseUnit.id"));
        coll.add(new SelectorItemInfo("baseUnit.name"));
        coll.add(new SelectorItemInfo("baseUnit.number"));
        coll.add(new SelectorItemInfo("defaultWarehouse.id"));
        coll.add(new SelectorItemInfo("defaultWarehouse.name"));
        coll.add(new SelectorItemInfo("defaultWarehouse.number"));
        coll.add(new SelectorItemInfo("materialInventory.id"));
        coll.add(new SelectorItemInfo("materialInventory.isKeyPart"));
        coll.add(new SelectorItemInfo("materialInventory.materialAttr"));
        coll.add(new SelectorItemInfo("parent.*"));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)bomId, CompareType.EQUALS));
        HashSet<Integer> issModeSet = new HashSet<Integer>();
        issModeSet.add(new Integer(11010));
        filter.getFilterItems().add(new FilterItemInfo("issMode", issModeSet, CompareType.INCLUDE));
        HashSet<Integer> provideTypeSet = new HashSet<Integer>();
        provideTypeSet.add(new Integer(10910));
        provideTypeSet.add(new Integer(10920));
        filter.getFilterItems().add(new FilterItemInfo("provideType", provideTypeSet, CompareType.INCLUDE));
        Date startDaet = osSourceInfo.getStartDate();
        Date endDate = osSourceInfo.getEndDate();
        filter.getFilterItems().add(new FilterItemInfo("disableDate", (Object)startDaet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)endDate, CompareType.LESS_EQUALS));
        if (isKeyPartOnly) {
            filter.getFilterItems().add(new FilterItemInfo("materialInventory.isKeyPart", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        if (materialscope == 20) {
            FilterInfo filterPart2 = new FilterInfo();
            filterPart2.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialScopeSet, CompareType.INCLUDE));
            filterPart2.getFilterItems().add(new FilterItemInfo("materialInventory.materialAttr", (Object)new Integer(10020), CompareType.EQUALS));
            filterPart2.setMaskString("#0 OR #1");
            filter.mergeFilter(filterPart2, "AND");
        }
        IBomEntry ibomEntry = BomEntryFactory.getLocalInstance((Context)ctx);
        BomEntryCollection bomEntryColl = ibomEntry.getBomEntryCollection(view);
        String orgUnitId = this.osOrgUnitInfo.getId().toString();
        for (int j = 0; j < bomEntryColl.size(); ++j) {
            BomEntryInfo bomEntryInfo = bomEntryColl.get(j);
            String materialId = bomEntryInfo.getMaterial().getId().toString();
            String[] temp = StoreCommonUtil.getProjectIdAndTrackNumberId((Context)ctx, (ProjectInfo)osSourceInfo.getProject(), (TrackNumberInfo)osSourceInfo.getTrackNumber(), (String)orgUnitId, (String)materialId, (int)1);
            String projectId = temp[0];
            String trackNumberId = temp[1];
            BigDecimal unitBaseQty = null;
            if (bomEntryInfo.getConsumeType().getValue() == 30) {
                unitBaseQty = bomEntryInfo.getBaseProportion().divide(new BigDecimal(100), 8, 4);
            } else {
                BigDecimal bsParentQty = bomEntryInfo.getParent().getProductBaseQty();
                unitBaseQty = bomEntryInfo.getConsumeFixBaseQty().divide(bsParentQty, 8, 4);
            }
            if (bomEntryInfo.getMaterialInventory().getMaterialAttr().getValue() == 10020) {
                if (path.indexOf(bomEntryInfo.getMaterial().getId().toString()) >= 0) continue;
                String nextPath = path + bomEntryInfo.getMaterial().getId().toString();
                BigDecimal resultQty = tempBaseQty.multiply(unitBaseQty);
                BomInfo bomInfo = BOMExtend2FacadeFactory.getLocalInstance((Context)ctx).getBomByTrcAndPrjID(bomEntryInfo.getMaterial().getId().toString(), projectId, trackNumberId, this.osOrgUnitInfo.getId().toString());
                String bomId1 = null;
                if (bomInfo != null && bomInfo.getId() != null) {
                    bomId1 = bomInfo.getId().toString();
                }
                this.bomExpand(ctx, bomId1, isKeyPartOnly, materialscope, materialScopeSet, osSourceInfo, level, nextPath, resultQty);
                continue;
            }
            OSSubItemInfo osSubItemInfo = new OSSubItemInfo();
            if (!"".equals(projectId)) {
                osSubItemInfo.setProject(osSourceInfo.getProject());
            }
            if (!"".equals(trackNumberId)) {
                osSubItemInfo.setTrackNumber(osSourceInfo.getTrackNumber());
            }
            osSubItemInfo.setPriority(osSourceInfo.getPriority());
            osSubItemInfo.setSourceType(osSourceInfo.getSourceType());
            osSubItemInfo.setSourceBillNumber(osSourceInfo.getSourceBillNumber());
            osSubItemInfo.setMaterial(bomEntryInfo.getMaterial());
            osSubItemInfo.setUnit(bomEntryInfo.getUnit());
            osSubItemInfo.setBsUnit(bomEntryInfo.getBaseUnit());
            osSubItemInfo.setIsKeyPart(bomEntryInfo.getMaterialInventory().isIsKeyPart());
            osSubItemInfo.setUnitBaseQty(tempBaseQty.multiply(unitBaseQty));
            if (osSubItemInfo.getUnitBaseQty().compareTo(SysConstant.BIGZERO) == 0) continue;
            if (this.osSimPattern.getValue() == 1) {
                osSubItemInfo.setBsReqQty(osSourceInfo.getBsReqOSQty().multiply(tempBaseQty.multiply(unitBaseQty)));
            }
            osSubItemInfo.setWareHouse(bomEntryInfo.getDefaultWarehouse());
            osSubItemInfo.setInvQty(SysConstant.BIGZERO);
            osSubItemInfo.setBsInvQty(SysConstant.BIGZERO);
            osSubItemInfo.setStockReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setBsStockReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setSimReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setBsSimReserveQty(SysConstant.BIGZERO);
            osSubItemInfo.setOSSourceId(osSourceInfo.getId().toString());
            this.addToOsSubItemCollection(osSubItemInfo);
            this.subMaterialSet.add(materialId);
            String key = materialId + projectId + trackNumberId;
            this.subMPTSet.add(key);
            this.keyPartMap.put(bomEntryInfo.getMaterial().getId().toString(), new Boolean(bomEntryInfo.getMaterialInventory().isIsKeyPart()));
        }
    }

    private boolean getKeyPart(String materialId, Context ctx) throws BOSException {
        boolean isKeyPart = false;
        if (this.keyPartMap.containsKey(materialId)) {
            isKeyPart = (Boolean)this.keyPartMap.get(materialId);
        } else {
            MaterialPlanInfo mpInfo = this.getMaterialPlanInfo(ctx, materialId);
            if (mpInfo != null) {
                isKeyPart = mpInfo.isIsKeyPart();
            }
            this.keyPartMap.put(materialId, new Boolean(isKeyPart));
        }
        return isKeyPart;
    }

    protected void addToOsSubItemCollection(OSSubItemInfo osSubItemInfo) {
        boolean isFound = false;
        String osSourceId = osSubItemInfo.getOSSourceId();
        String materialId = osSubItemInfo.getMaterial().getId().toString();
        ProjectInfo pInfo = osSubItemInfo.getProject();
        TrackNumberInfo tInfo = osSubItemInfo.getTrackNumber();
        String warehsId = osSubItemInfo.getWareHouse() == null ? null : osSubItemInfo.getWareHouse().getId().toString();
        String operationNo = osSubItemInfo.getOperationNo();
        for (int i = 0; i < this.osSubItemList.size(); ++i) {
            OSSubItemInfo temp = (OSSubItemInfo)this.osSubItemList.get(i);
            if (!osSourceId.equals(temp.getOSSourceId()) || !materialId.equals(temp.getMaterial().getId().toString()) || !EqualsUtil.equals((Object)pInfo, (Object)temp.getProject()) || !EqualsUtil.equals((Object)tInfo, (Object)temp.getTrackNumber())) continue;
            isFound = true;
            temp.setUnitBaseQty(temp.getUnitBaseQty().add(osSubItemInfo.getUnitBaseQty()));
            if (this.osSimPattern.getValue() == 1) {
                temp.setBsReqQty(temp.getBsReqQty().add(osSubItemInfo.getBsReqQty()));
            }
            if (warehsId == null && temp.getWareHouse() != null || warehsId != null && temp.getWareHouse() == null || warehsId != null && temp.getWareHouse() != null && !warehsId.equals(temp.getWareHouse().getId().toString())) {
                temp.setWareHouse(null);
            }
            if (!(operationNo == null && temp.getOperationNo() != null || operationNo != null && temp.getOperationNo() == null) && (operationNo == null || temp.getOperationNo() == null || operationNo.equals(temp.getOperationNo()))) break;
            temp.setOperationNo(null);
            temp.setOperationName(null);
            temp.setOperationNumber(null);
            break;
        }
        if (!isFound) {
            this.osSubItemList.add(osSubItemInfo);
        }
    }

    protected void genSubItem() throws BOSException, EASBizException {
        this.subItemMap = new HashMap();
        for (int i = 0; i < this.osSubItemList.size(); ++i) {
            List<OSSubItemInfo> subItemList;
            OSSubItemInfo osSubItemInfo = (OSSubItemInfo)this.osSubItemList.get(i);
            String osSourceId = osSubItemInfo.getOSSourceId();
            if (this.subItemMap.containsKey(osSourceId)) {
                subItemList = (List)this.subItemMap.get(osSourceId);
                subItemList.add(osSubItemInfo);
                continue;
            }
            subItemList = new ArrayList<OSSubItemInfo>();
            subItemList.add(osSubItemInfo);
            this.subItemMap.put(osSourceId, subItemList);
        }
    }

    protected void genOSInvDetail(Context ctx) throws BOSException, EASBizException {
        this.osInvDetailList = new ArrayList();
        if (this.subMaterialSet.size() == 0) {
            return;
        }
        String orgId = this.osOrgUnitInfo.getId().toString();
        HashSet<String> storageStatus = new HashSet<String>();
        HashSet<String> storageType = new HashSet<String>();
        try {
            ResultSet res = StoreCommonUtil.getPlanVersionSetStoretypeAndStorestate((Context)ctx, (String)StoreCommonUtil.PLANVERSION_901, (String)orgId);
            while (res.next()) {
                storageStatus.add(res.getString("fstorestate"));
                storageType.add(res.getString("fstoretype"));
            }
            res.close();
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String warehouseIds = null;
        if (this.osCalcParam.getWarehousescope().getValue() == 10) {
            warehouseIds = this.parseAllWarehouseIds(ctx, orgId);
            if (warehouseIds == null) {
                return;
            }
        } else {
            warehouseIds = this.parseCollection2String(this.osCalcParam.getWarehouseSet());
        }
        String materialIds = this.parseCollection2String(this.subMPTSet);
        this.genProductUnitMap(ctx);
        StringBuffer oql = this.getOql(SQLUtil.setToString(storageStatus), SQLUtil.setToString(storageType), materialIds, warehouseIds, orgId);
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            while (rs.next()) {
                OSInvDetailInfo info = new OSInvDetailInfo();
                WarehouseInfo whInfo = new WarehouseInfo();
                whInfo.setId(BOSUuid.read((String)rs.getString("WH_ID")));
                whInfo.setName(rs.getString("WH_NAME"));
                whInfo.setNumber(rs.getString("WH_Number"));
                MaterialInfo maInfo = new MaterialInfo();
                maInfo.setId(BOSUuid.read((String)rs.getString("MA_ID")));
                maInfo.setName(rs.getString("MA_NAME"));
                maInfo.setName(rs.getString("MA_NAME_L1"), new Locale("L1"));
                maInfo.setName(rs.getString("MA_NAME"), new Locale("L2"));
                maInfo.setName(rs.getString("MA_NAME_L3"), new Locale("L3"));
                maInfo.setNumber(rs.getString("MA_Number"));
                maInfo.setModel(rs.getString("MA_MODEL"));
                MeasureUnitInfo muInfo = new MeasureUnitInfo();
                muInfo.setId(BOSUuid.read((String)rs.getString("BSUNIT_ID")));
                muInfo.setName(rs.getString("BSUNIT_NAME"));
                muInfo.setNumber(rs.getString("BSUNIT_Number"));
                info.setWareHouse(whInfo);
                info.setMaterial(maInfo);
                info.setBsUnit(muInfo);
                ProjectInfo projectInfo = new ProjectInfo();
                TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                if (rs.getString("TP_Number") != null && rs.getString("TP_Number").length() > 0) {
                    projectInfo.setNumber(rs.getString("TP_Number"));
                }
                if (rs.getString("TIN_ProjectId") != null && rs.getString("TIN_ProjectId").length() > 0 && !rs.getString("TIN_ProjectId").equalsIgnoreCase("EgkAAABc3Xza3gXu")) {
                    projectInfo.setId(BOSUuid.read((String)rs.getString("TIN_ProjectId")));
                }
                info.setProject(projectInfo);
                if (rs.getString("TTN_Number") != null && rs.getString("TTN_Number").length() > 0) {
                    trackNumberInfo.setNumber(rs.getString("TTN_Number"));
                }
                if (rs.getString("TIN_TrackNumberId") != null && rs.getString("TIN_TrackNumberId").length() > 0 && !rs.getString("TIN_TrackNumberId").equalsIgnoreCase("EgkAAABc3X0Ibpg9")) {
                    trackNumberInfo.setId(BOSUuid.read((String)rs.getString("TIN_TrackNumberId")));
                }
                info.setTrackNumber(trackNumberInfo);
                if (rs.getBigDecimal("SUM_BASEQTY").compareTo(SysConstant.BIGZERO) <= 0) {
                    info.setBsCurStoreQty(SysConstant.BIGZERO);
                } else {
                    info.setBsCurStoreQty(rs.getBigDecimal("SUM_BASEQTY"));
                }
                info.setWhState(WHStateEnum.ACTIVE);
                MeasureUnitInfo productUnit = muInfo;
                if (this.productUnitMap.containsKey(maInfo.getId().toString())) {
                    productUnit = (MeasureUnitInfo)this.productUnitMap.get(maInfo.getId().toString());
                }
                info.setUnit(productUnit);
                if (info.getBsCurStoreQty().compareTo(SysConstant.BIGZERO) != 1) continue;
                BigDecimal curStoreQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)info.getMaterial().getId().toString(), (MeasureUnitInfo)info.getBsUnit(), (MeasureUnitInfo)info.getUnit(), (BigDecimal)info.getBsCurStoreQty());
                info.setCurStoreQty(curStoreQty);
                this.osInvDetailList.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void genProductUnitMap(Context ctx) throws BOSException {
        this.cacheMaterialPlanInfo(ctx, this.subMaterialSet);
    }

    private StringBuffer getOql(String storageStatus, String storageType, String materialIds, String warehouseIds, String orgId) {
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT TWH.Fid AS WH_ID,TWH.FName_l2 AS WH_NAME,TWH.FNumber AS WH_Number,TWH.FWhState AS WH_WHSTATE,TMA.Fid AS MA_ID,TMA.FName_L1 AS MA_NAME_L1,TMA.FName_l2 AS MA_NAME,TMA.FName_L3 AS MA_NAME_L3,TMA.Fnumber AS MA_NUMBER,TMA.FModel AS MA_MODEL,BSUNIT.Fid AS BSUNIT_ID,BSUNIT.FName_l2 AS BSUNIT_NAME,BSUNIT.Fnumber AS BSUNIT_NUMBER,SUM(TIN.FBaseQty) AS SUM_BASEQTY,  TP.FNumber AS TP_Number, TTN.FNumber AS TTN_Number,  TIN.FProjectId AS TIN_ProjectId, TIN.FTrackNumberId AS TIN_TrackNumberId  FROM T_IM_Inventory TIN LEFT JOIN T_DB_WAREHOUSE TWH ON (TIN.FWarehouseID = TWH.FID) LEFT JOIN T_BD_Material TMA ON (TIN.FMaterialID = TMA.FID)  LEFT JOIN T_MM_TrackNumber TTN ON (TTN.FID = TIN.FTrackNumberID)  LEFT JOIN T_MM_Project TP ON (TP.FID = TIN.FProjectID)  LEFT JOIN T_BD_MeasureUnit BSUNIT ON (TIN.FBaseUnitID = BSUNIT.FID) WHERE TWH.FID IN(" + warehouseIds + ") AND TIN.FStorageOrgUnitID = '" + orgId + "'  AND (TMA.FID || case when TIN.FProjectId = '" + "EgkAAABc3Xza3gXu" + "' then '' else TIN.FProjectId end || case when TIN.FTrackNumberId = '" + "EgkAAABc3X0Ibpg9" + "' then '' else TIN.FTrackNumberId end)  IN (" + materialIds + ") ");
        if (storageStatus == null || storageStatus.length() == 0) {
            oql.append(" AND TIN.FStoreStatusID IS NULL ");
        } else {
            oql.append(" AND TIN.FStoreStatusID IN  (" + storageStatus + ") ");
        }
        if (storageType == null || storageType.length() == 0) {
            oql.append(" AND TIN.FStoreTypeID IS NULL ");
        } else {
            oql.append(" AND TIN.FStoreTypeID IN  (" + storageType + ") ");
        }
        oql.append(" GROUP BY TWH.Fid,TWH.FName_l2,TWH.FNumber,TWH.FWhState,");
        oql.append("TMA.Fid,TMA.FName_l1,TMA.FName_l2,TMA.FName_l3,TMA.Fnumber,TMA.FModel,");
        oql.append("BSUNIT.Fid,BSUNIT.FName_l2,BSUNIT.Fnumber,");
        oql.append("TP.FNumber,TTN.FNumber,");
        oql.append("TIN.FProjectId,TIN.FTrackNumberId");
        return oql;
    }

    private String parseAllWarehouseIds(Context ctx, String orgId) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        StringBuffer transState = new StringBuffer();
        HashSet<String> whIdSet = new HashSet<String>();
        transState.append("'" + "1".toString() + "','" + "2".toString() + "'");
        oql.append("SELECT FWarehouseID AS WHID FROM T_DB_SOAccreditWH TSO LEFT JOIN T_DB_WAREHOUSE TIN ON (TSO.FWarehouseID = TIN.FID)  WHERE TSO.FStorageOrgID = '" + orgId + "' AND TIN.FTransState IN (" + transState.toString() + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            while (rs.next()) {
                whIdSet.add(rs.getString("WHID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer paramString = new StringBuffer();
        paramString.append("'");
        if (!whIdSet.isEmpty()) {
            Object[] tsArr = whIdSet.toArray();
            String tsString = StringUtils.arrayToString((Object[])tsArr, (String)"','");
            paramString.append(tsString);
        } else {
            String tsString = "";
        }
        paramString.append("'");
        return paramString.toString();
    }

    private String parseCollection2String(Collection coll) {
        StringBuffer paramBuffer = new StringBuffer();
        String paramString = null;
        for (String id : coll) {
            paramBuffer.append("'").append(id).append("',");
        }
        paramString = paramBuffer.substring(0, paramBuffer.lastIndexOf(","));
        return paramString;
    }

    protected void genOSStockReserve(Context ctx) throws BOSException, EASBizException {
        this.osStockReserveList = new ArrayList();
        String orgUnitId = this.osOrgUnitInfo.getId().toString();
        if (this.subMaterialSet.size() == 0) {
            return;
        }
        if (!this.osCalcParam.isHasProductOrder()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(coll);
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("material.id"));
        coll.add(new SelectorItemInfo("material.name"));
        coll.add(new SelectorItemInfo("material.number"));
        coll.add(new SelectorItemInfo("material.model"));
        coll.add(new SelectorItemInfo("unit.id"));
        coll.add(new SelectorItemInfo("unit.name"));
        coll.add(new SelectorItemInfo("baseUnit.number"));
        coll.add(new SelectorItemInfo("baseUnit.id"));
        coll.add(new SelectorItemInfo("baseUnit.name"));
        coll.add(new SelectorItemInfo("baseUnit.number"));
        coll.add(new SelectorItemInfo("defaultWarehouse.id"));
        coll.add(new SelectorItemInfo("defaultWarehouse.name"));
        coll.add(new SelectorItemInfo("defaultWarehouse.number"));
        coll.add(new SelectorItemInfo("parent.*"));
        coll.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
        coll.add(new SelectorItemInfo("parent.storageOrgUnit.number"));
        coll.add(new SelectorItemInfo("parent.storageOrgUnit.name"));
        coll.add(new SelectorItemInfo("parent.material.id"));
        coll.add(new SelectorItemInfo("parent.material.name"));
        coll.add(new SelectorItemInfo("parent.material.number"));
        coll.add(new SelectorItemInfo("parent.material.model"));
        coll.add(new SelectorItemInfo("parent.trackNumber.id"));
        coll.add(new SelectorItemInfo("parent.trackNumber.name"));
        coll.add(new SelectorItemInfo("parent.trackNumber.number"));
        HashSet<BigDecimal> statusSet = new HashSet<BigDecimal>();
        if (this.osCalcParam.isHasCommitStatus()) {
            statusSet.add(new BigDecimal(2));
        }
        if (this.osCalcParam.isHasAuditStatus()) {
            statusSet.add(new BigDecimal(4));
        }
        if (this.osCalcParam.isHasReleaseStatus()) {
            statusSet.add(new BigDecimal(5));
        }
        if (this.osCalcParam.isHasCompleteStatus()) {
            statusSet.add(new BigDecimal(8));
        }
        HashSet<Integer> issModeSet = new HashSet<Integer>();
        issModeSet.add(new Integer(11010));
        filter.getFilterItems().add(new FilterItemInfo("issMode", issModeSet, CompareType.INCLUDE));
        HashSet<Integer> provideTypeSet = new HashSet<Integer>();
        provideTypeSet.add(new Integer(10910));
        provideTypeSet.add(new Integer(10920));
        filter.getFilterItems().add(new FilterItemInfo("provideType", provideTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit", (Object)this.osOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.subMaterialSet, CompareType.INCLUDE));
        if (this.srcPrdOrderSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.srcPrdOrderSet, CompareType.NOTINCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", null, CompareType.NOTEQUALS));
        }
        if (this.osCalcParam.isRemoveOrder()) {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.osCalcParam.getProdOrderSet(), CompareType.NOTINCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        if (statusSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", statusSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        FilterInfo filterPart2 = new FilterInfo();
        if (this.osCalcParam.getWarehousescope().getValue() == 20) {
            filterPart2.getFilterItems().add(new FilterItemInfo("defaultWarehouse.id", null, CompareType.NOTEQUALS));
            filterPart2.getFilterItems().add(new FilterItemInfo("defaultWarehouse.id", (Object)this.osCalcParam.getWarehouseSet(), CompareType.INCLUDE));
        }
        filter.mergeFilter(filterPart2, "AND");
        IProductionOrderStockEntry iprdEntry = ProductionOrderStockEntryFactory.getLocalInstance((Context)ctx);
        ProductionOrderStockEntryCollection prdEntryColl = iprdEntry.getProductionOrderStockEntryCollection(view);
        for (int j = 0; j < prdEntryColl.size(); ++j) {
            ProductionOrderStockEntryInfo prdEntryInfo = prdEntryColl.get(j);
            String materialId = prdEntryInfo.getMaterial().getId().toString();
            if (!this.subMPTSet.contains(this.getKeyByManuStrategy(ctx, materialId, null, prdEntryInfo.getParent().getTrackNumber()))) continue;
            OSStockReserveInfo osStockReserveInfo = new OSStockReserveInfo();
            osStockReserveInfo.setBaseStatus(prdEntryInfo.getParent().getBaseStatus());
            osStockReserveInfo.setSourceBillNumber(prdEntryInfo.getParent().getNumber());
            osStockReserveInfo.setTrackNumber(prdEntryInfo.getParent().getTrackNumber());
            osStockReserveInfo.setMaterial(prdEntryInfo.getMaterial());
            osStockReserveInfo.setUnit(prdEntryInfo.getUnit());
            osStockReserveInfo.setBsUnit(prdEntryInfo.getBaseUnit());
            BigDecimal stockReserveQty = prdEntryInfo.getQty().subtract(prdEntryInfo.getSendOutTotalQty()).add(prdEntryInfo.getUntreadTotalQty());
            BigDecimal bsStockReserveQty = prdEntryInfo.getBaseQty().subtract(prdEntryInfo.getBaseSendOutTotalQty()).add(prdEntryInfo.getBaseUntreadTotalQty());
            if (stockReserveQty.compareTo(SysConstant.BIGZERO) <= 0) continue;
            osStockReserveInfo.setStockReserveQty(stockReserveQty);
            osStockReserveInfo.setBsStockReserveQty(bsStockReserveQty);
            osStockReserveInfo.setStandardQty(prdEntryInfo.getStandardQty());
            BigDecimal bsStandardQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)prdEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)prdEntryInfo.getUnit(), (MeasureUnitInfo)prdEntryInfo.getBaseUnit(), (BigDecimal)prdEntryInfo.getStandardQty());
            osStockReserveInfo.setBsStandardQty(bsStandardQty);
            osStockReserveInfo.setPlannedQty(prdEntryInfo.getQty());
            osStockReserveInfo.setBsPlannedQty(prdEntryInfo.getBaseQty());
            osStockReserveInfo.setActIssueQty(prdEntryInfo.getSendOutTotalQty());
            osStockReserveInfo.setBsActIssueQty(prdEntryInfo.getBaseSendOutTotalQty());
            osStockReserveInfo.setRejectedQty(prdEntryInfo.getUntreadTotalQty());
            osStockReserveInfo.setBsRejectedQty(prdEntryInfo.getBaseUntreadTotalQty());
            osStockReserveInfo.setWareHouse(prdEntryInfo.getDefaultWarehouse());
            osStockReserveInfo.setProduct(prdEntryInfo.getParent().getMaterial());
            this.osStockReserveList.add(osStockReserveInfo);
        }
        EntityViewInfo view2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        SelectorItemCollection coll2 = new SelectorItemCollection();
        view2.setFilter(filter2);
        view2.setSelector(coll2);
        coll2.add(new SelectorItemInfo("*"));
        coll2.add(new SelectorItemInfo("material.id"));
        coll2.add(new SelectorItemInfo("material.name"));
        coll2.add(new SelectorItemInfo("material.number"));
        coll2.add(new SelectorItemInfo("material.model"));
        coll2.add(new SelectorItemInfo("unit.id"));
        coll2.add(new SelectorItemInfo("unit.name"));
        coll2.add(new SelectorItemInfo("baseUnit.number"));
        coll2.add(new SelectorItemInfo("baseUnit.id"));
        coll2.add(new SelectorItemInfo("baseUnit.name"));
        coll2.add(new SelectorItemInfo("baseUnit.number"));
        coll2.add(new SelectorItemInfo("warehouse.id"));
        coll2.add(new SelectorItemInfo("warehouse.name"));
        coll2.add(new SelectorItemInfo("warehouse.number"));
        coll2.add(new SelectorItemInfo("parent.*"));
        coll2.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
        coll2.add(new SelectorItemInfo("parent.storageOrgUnit.number"));
        coll2.add(new SelectorItemInfo("parent.storageOrgUnit.name"));
        coll2.add(new SelectorItemInfo("parent.material.id"));
        coll2.add(new SelectorItemInfo("parent.material.name"));
        coll2.add(new SelectorItemInfo("parent.material.number"));
        coll2.add(new SelectorItemInfo("parent.material.model"));
        coll2.add(new SelectorItemInfo("parent.trackNumber.id"));
        coll2.add(new SelectorItemInfo("parent.trackNumber.name"));
        coll2.add(new SelectorItemInfo("parent.trackNumber.number"));
        coll2.add(new SelectorItemInfo("parent.project.id"));
        coll2.add(new SelectorItemInfo("parent.project.name"));
        coll2.add(new SelectorItemInfo("parent.project.number"));
        coll2.add(new SelectorItemInfo("parent.transactionType.id"));
        coll2.add(new SelectorItemInfo("parent.transactionType.isTotalPicking"));
        HashSet<BigDecimal> statusSet2 = new HashSet<BigDecimal>();
        if (this.osCalcParam.isHasCommitStatus()) {
            statusSet2.add(new BigDecimal(2));
        }
        if (this.osCalcParam.isHasAuditStatus()) {
            statusSet2.add(new BigDecimal(4));
        }
        if (this.osCalcParam.isHasReleaseStatus()) {
            statusSet2.add(new BigDecimal(5));
        }
        if (this.osCalcParam.isHasCompleteStatus()) {
            statusSet2.add(new BigDecimal(8));
        }
        HashSet<Integer> issModeSet2 = new HashSet<Integer>();
        issModeSet2.add(new Integer(11010));
        filter2.getFilterItems().add(new FilterItemInfo("issueMode", issModeSet2, CompareType.INCLUDE));
        HashSet<Integer> provideTypeSet2 = new HashSet<Integer>();
        provideTypeSet2.add(new Integer(10910));
        provideTypeSet2.add(new Integer(10920));
        filter2.getFilterItems().add(new FilterItemInfo("provideType", provideTypeSet2, CompareType.INCLUDE));
        filter2.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit", (Object)this.osOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.subMaterialSet, CompareType.INCLUDE));
        if (this.srcMnfOrderSet.size() > 0) {
            filter2.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.srcMnfOrderSet, CompareType.NOTINCLUDE));
        } else {
            filter2.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        if (this.osCalcParam.isRemoveOrder()) {
            filter2.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.osCalcParam.getManufactureOrderSet(), CompareType.NOTINCLUDE));
        } else {
            filter2.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        if (statusSet2.size() > 0) {
            filter2.getFilterItems().add(new FilterItemInfo("parent.baseStatus", statusSet2, CompareType.INCLUDE));
        } else {
            filter2.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        FilterInfo filterPart22 = new FilterInfo();
        if (this.osCalcParam.getWarehousescope().getValue() == 20) {
            filterPart22.getFilterItems().add(new FilterItemInfo("warehouse.id", null, CompareType.NOTEQUALS));
            filterPart22.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)this.osCalcParam.getWarehouseSet(), CompareType.INCLUDE));
        }
        filter2.mergeFilter(filterPart22, "AND");
        IManufactureOrderStock imnfEntry = ManufactureOrderStockFactory.getLocalInstance(ctx);
        CoreBaseCollection mnfEntryColl = imnfEntry.getCollection(view2);
        for (int j = 0; j < mnfEntryColl.size(); ++j) {
            ManufactureOrderStockInfo mnfEntryInfo = (ManufactureOrderStockInfo)mnfEntryColl.get(j);
            String materialId = mnfEntryInfo.getMaterial().getId().toString();
            if (!this.subMPTSet.contains(this.getKeyByManuStrategy(ctx, materialId, mnfEntryInfo.getParent().getProject(), mnfEntryInfo.getParent().getTrackNumber()))) continue;
            OSStockReserveInfo osStockReserveInfo = new OSStockReserveInfo();
            osStockReserveInfo.setBaseStatus(mnfEntryInfo.getParent().getBaseStatus());
            osStockReserveInfo.setSourceBillNumber(mnfEntryInfo.getParent().getNumber());
            osStockReserveInfo.setProject(mnfEntryInfo.getParent().getProject());
            osStockReserveInfo.setTrackNumber(mnfEntryInfo.getParent().getTrackNumber());
            osStockReserveInfo.setMaterial(mnfEntryInfo.getMaterial());
            osStockReserveInfo.setUnit(mnfEntryInfo.getUnit());
            osStockReserveInfo.setBsUnit(mnfEntryInfo.getBaseUnit());
            BigDecimal stockReserveQty = mnfEntryInfo.getPlannedQty().subtract(mnfEntryInfo.getActIssueQty()).add(mnfEntryInfo.getRejectedQty());
            BigDecimal bsStockReserveQty = mnfEntryInfo.getPlannedBaseQty().subtract(mnfEntryInfo.getActIssueBaseQty()).add(mnfEntryInfo.getRejectedBaseQty());
            if (stockReserveQty.compareTo(SysConstant.BIGZERO) <= 0) continue;
            osStockReserveInfo.setStockReserveQty(stockReserveQty);
            osStockReserveInfo.setBsStockReserveQty(bsStockReserveQty);
            osStockReserveInfo.setStandardQty(mnfEntryInfo.getQty());
            osStockReserveInfo.setBsStandardQty(mnfEntryInfo.getBaseQty());
            osStockReserveInfo.setPlannedQty(mnfEntryInfo.getPlannedQty());
            osStockReserveInfo.setBsPlannedQty(mnfEntryInfo.getPlannedBaseQty());
            osStockReserveInfo.setActIssueQty(mnfEntryInfo.getActIssueQty());
            osStockReserveInfo.setBsActIssueQty(mnfEntryInfo.getActIssueBaseQty());
            osStockReserveInfo.setRejectedQty(mnfEntryInfo.getRejectedQty());
            osStockReserveInfo.setBsRejectedQty(mnfEntryInfo.getRejectedBaseQty());
            osStockReserveInfo.setWareHouse(mnfEntryInfo.getWarehouse());
            osStockReserveInfo.setProduct(mnfEntryInfo.getParent().getMaterial());
            this.osStockReserveList.add(osStockReserveInfo);
        }
    }

    protected void genInvMap() {
        this.invMap = new HashMap();
        for (int i = 0; i < this.osInvDetailList.size(); ++i) {
            OSInvDetailInfo osInvDetailInfo = (OSInvDetailInfo)this.osInvDetailList.get(i);
            String materialId = osInvDetailInfo.getMaterial().getId().toString();
            String projectId = "";
            String trackNumberId = "";
            if (osInvDetailInfo.getProject() != null && osInvDetailInfo.getProject().getId() != null && osInvDetailInfo.getProject().getId().toString().length() > 0) {
                projectId = osInvDetailInfo.getProject().getId().toString();
            }
            if (osInvDetailInfo.getTrackNumber() != null && osInvDetailInfo.getTrackNumber().getId() != null && osInvDetailInfo.getTrackNumber().getId().toString().length() > 0) {
                trackNumberId = osInvDetailInfo.getTrackNumber().getId().toString();
            }
            BigDecimal invQty = osInvDetailInfo.getBsCurStoreQty();
            String key = materialId + projectId + trackNumberId;
            if (this.invMap.containsKey(key)) {
                this.invMap.put(key, ((BigDecimal)this.invMap.get(key)).add(invQty));
                continue;
            }
            this.invMap.put(key, invQty);
        }
    }

    protected void genStockReserveMap(Context ctx) throws BOSException, EASBizException {
        this.stockReserveMap = new HashMap();
        this.stockReserve4WHMap = new HashMap();
        for (int i = 0; i < this.osStockReserveList.size(); ++i) {
            OSStockReserveInfo osStockReserveInfo = (OSStockReserveInfo)this.osStockReserveList.get(i);
            String materialId = osStockReserveInfo.getMaterial().getId().toString();
            String key = this.getKeyByManuStrategy(ctx, materialId, osStockReserveInfo.getProject(), osStockReserveInfo.getTrackNumber());
            String warehsId = osStockReserveInfo.getWareHouse() == null ? null : osStockReserveInfo.getWareHouse().getId().toString();
            BigDecimal stockReserveQty = osStockReserveInfo.getBsStockReserveQty();
            String key2 = key + warehsId;
            if (this.stockReserveMap.containsKey(key)) {
                this.stockReserveMap.put(key, ((BigDecimal)this.stockReserveMap.get(key)).add(stockReserveQty));
            } else {
                this.stockReserveMap.put(key, stockReserveQty);
            }
            if (this.stockReserve4WHMap.keySet().contains(key2)) {
                this.stockReserve4WHMap.put(key2, ((BigDecimal)this.stockReserve4WHMap.get(key2)).add(stockReserveQty));
                continue;
            }
            this.stockReserve4WHMap.put(key2, stockReserveQty);
        }
    }

    protected void updateOSSubItem(Context ctx) throws BOSException, EASBizException {
        for (int i = 0; i < this.osSubItemList.size(); ++i) {
            BigDecimal bsStockReserveQty;
            String key;
            BigDecimal bsInvQty;
            OSSubItemInfo osSubItemInfo = (OSSubItemInfo)this.osSubItemList.get(i);
            String materialId = osSubItemInfo.getMaterial().getId().toString();
            String projectId = "";
            String trackNumberId = "";
            if (osSubItemInfo.getProject() != null && osSubItemInfo.getProject().getId() != null && osSubItemInfo.getProject().getId().toString().length() > 0) {
                projectId = osSubItemInfo.getProject().getId().toString();
            }
            if (osSubItemInfo.getTrackNumber() != null && osSubItemInfo.getTrackNumber().getId() != null && osSubItemInfo.getTrackNumber().getId().toString().length() > 0) {
                trackNumberId = osSubItemInfo.getTrackNumber().getId().toString();
            }
            if ((bsInvQty = (BigDecimal)this.invMap.get(key = materialId + projectId + trackNumberId)) != null) {
                osSubItemInfo.setBsInvQty(bsInvQty);
                BigDecimal invQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osSubItemInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osSubItemInfo.getBsUnit(), (MeasureUnitInfo)osSubItemInfo.getUnit(), (BigDecimal)osSubItemInfo.getBsInvQty());
                osSubItemInfo.setInvQty(invQty);
            }
            if ((bsStockReserveQty = (BigDecimal)this.stockReserveMap.get(key)) == null) continue;
            osSubItemInfo.setBsStockReserveQty(bsStockReserveQty);
            BigDecimal stockReserveQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osSubItemInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osSubItemInfo.getBsUnit(), (MeasureUnitInfo)osSubItemInfo.getUnit(), (BigDecimal)osSubItemInfo.getBsStockReserveQty());
            osSubItemInfo.setStockReserveQty(stockReserveQty);
        }
    }

    protected void calculation(Context ctx) throws BOSException, EASBizException {
        this.simReserveMap = new HashMap();
        for (int i = 0; i < this.osResultList.size(); ++i) {
            BigDecimal BS_BIGDECIMAL_MAX;
            OSResultInfo osResultInfo = (OSResultInfo)this.osResultList.get(i);
            String osSourceId = osResultInfo.getOSSourceId();
            BigDecimal bsMaxOSQty = BS_BIGDECIMAL_MAX = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osResultInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osResultInfo.getUnit(), (MeasureUnitInfo)osResultInfo.getBsUnit(), (BigDecimal)BIGDECIMAL_MAX);
            List subItemList = (List)this.subItemMap.get(osSourceId);
            if (subItemList != null) {
                for (int j = 0; j < subItemList.size(); ++j) {
                    BigDecimal tempBsMaxOSQty;
                    BigDecimal validBsInvQty;
                    BigDecimal bsSimReserveQty;
                    OSSubItemInfo osSubItemInfo = (OSSubItemInfo)subItemList.get(j);
                    String materialId = osSubItemInfo.getMaterial().getId().toString();
                    String projectId = "";
                    String trackNumberId = "";
                    if (osSubItemInfo.getProject() != null && osSubItemInfo.getProject().getId() != null && osSubItemInfo.getProject().getId().toString().length() > 0) {
                        projectId = osSubItemInfo.getProject().getId().toString();
                    }
                    if (osSubItemInfo.getTrackNumber() != null && osSubItemInfo.getTrackNumber().getId() != null && osSubItemInfo.getTrackNumber().getId().toString().length() > 0) {
                        trackNumberId = osSubItemInfo.getTrackNumber().getId().toString();
                    }
                    String simReserveKey = materialId + projectId + trackNumberId;
                    if (this.osCalcParam.isHasSimulationOrder() && (bsSimReserveQty = (BigDecimal)this.simReserveMap.get(simReserveKey)) != null) {
                        osSubItemInfo.setBsSimReserveQty(bsSimReserveQty);
                        BigDecimal simReserveQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialId, (MeasureUnitInfo)osSubItemInfo.getBsUnit(), (MeasureUnitInfo)osSubItemInfo.getUnit(), (BigDecimal)bsSimReserveQty);
                        osSubItemInfo.setSimReserveQty(simReserveQty);
                    }
                    if ((validBsInvQty = osSubItemInfo.getBsInvQty().subtract(osSubItemInfo.getBsStockReserveQty()).subtract(osSubItemInfo.getBsSimReserveQty())).compareTo(SysConstant.BIGZERO) == -1) {
                        validBsInvQty = SysConstant.BIGZERO;
                    }
                    if ((tempBsMaxOSQty = validBsInvQty.divide(osSubItemInfo.getUnitBaseQty(), 8, 4)).compareTo(bsMaxOSQty) != -1) continue;
                    bsMaxOSQty = tempBsMaxOSQty;
                }
            }
            BigDecimal bsReqOSQty = osResultInfo.getBsReqOSQty();
            if (bsMaxOSQty.compareTo(BS_BIGDECIMAL_MAX) == 0) {
                bsMaxOSQty = this.osSimPattern.getValue() == 1 ? bsReqOSQty : SysConstant.BIGZERO;
            }
            BigDecimal bsShortQty = this.osSimPattern.getValue() == 1 ? bsReqOSQty.subtract(bsMaxOSQty) : SysConstant.BIGZERO;
            BigDecimal maxOSQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osResultInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osResultInfo.getBsUnit(), (MeasureUnitInfo)osResultInfo.getUnit(), (BigDecimal)bsMaxOSQty);
            BigDecimal shortQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osResultInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osResultInfo.getBsUnit(), (MeasureUnitInfo)osResultInfo.getUnit(), (BigDecimal)bsShortQty);
            osResultInfo.setBsMaxOSQty(bsMaxOSQty);
            osResultInfo.setBsShortQty(bsShortQty);
            osResultInfo.setMaxOSQty(maxOSQty);
            if (bsShortQty.compareTo(SysConstant.BIGZERO) == 1) {
                osResultInfo.setShortQty(shortQty);
            }
            BigDecimal defaultProductQty = this.osSimPattern.getValue() == 1 ? (osResultInfo.getReqOSQty().compareTo(maxOSQty) == -1 ? osResultInfo.getReqOSQty() : maxOSQty) : maxOSQty;
            osResultInfo.setPrdQty(defaultProductQty);
            BigDecimal actBsOSQty = this.osSimPattern.getValue() == 1 ? (bsReqOSQty.compareTo(bsMaxOSQty) == -1 ? bsReqOSQty : bsMaxOSQty) : bsMaxOSQty;
            if (subItemList == null) continue;
            for (int k = 0; k < subItemList.size(); ++k) {
                BigDecimal validBsInvQty;
                OSSubItemInfo osSubItemInfo = (OSSubItemInfo)subItemList.get(k);
                String materialId = osSubItemInfo.getMaterial().getId().toString();
                String projectId = "";
                String trackNumberId = "";
                if (osSubItemInfo.getProject() != null && osSubItemInfo.getProject().getId() != null && osSubItemInfo.getProject().getId().toString().length() > 0) {
                    projectId = osSubItemInfo.getProject().getId().toString();
                }
                if (osSubItemInfo.getTrackNumber() != null && osSubItemInfo.getTrackNumber().getId() != null && osSubItemInfo.getTrackNumber().getId().toString().length() > 0) {
                    trackNumberId = osSubItemInfo.getTrackNumber().getId().toString();
                }
                String simReserveKey = materialId + projectId + trackNumberId;
                BigDecimal actBsSubQty = actBsOSQty.multiply(osSubItemInfo.getUnitBaseQty());
                if (this.simReserveMap.containsKey(simReserveKey)) {
                    this.simReserveMap.put(simReserveKey, ((BigDecimal)this.simReserveMap.get(simReserveKey)).add(actBsSubQty));
                } else {
                    this.simReserveMap.put(simReserveKey, actBsSubQty);
                }
                BigDecimal bsReqQty = SysConstant.BIGZERO;
                if (this.osSimPattern.getValue() == 1) {
                    bsReqQty = osSubItemInfo.getBsReqQty();
                }
                if ((validBsInvQty = osSubItemInfo.getBsInvQty().subtract(osSubItemInfo.getBsStockReserveQty()).subtract(osSubItemInfo.getBsSimReserveQty())).compareTo(SysConstant.BIGZERO) == -1) {
                    validBsInvQty = SysConstant.BIGZERO;
                }
                BigDecimal bsSubShortQty = bsReqQty.subtract(validBsInvQty);
                if (this.osCalcParam.isShowzero() && bsSubShortQty.compareTo(SysConstant.BIGZERO) == -1) {
                    bsSubShortQty = SysConstant.BIGZERO;
                }
                BigDecimal subShortQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialId, (MeasureUnitInfo)osSubItemInfo.getBsUnit(), (MeasureUnitInfo)osSubItemInfo.getUnit(), (BigDecimal)bsSubShortQty);
                osSubItemInfo.setBsShortQty(bsSubShortQty);
                osSubItemInfo.setShortQty(subShortQty);
            }
        }
    }

    protected void genMMUMap(Context ctx) throws BOSException {
        if (this.subMaterialSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(coll);
        coll.add(new SelectorItemInfo("material.id"));
        coll.add(new SelectorItemInfo("measureUnit.id"));
        coll.add(new SelectorItemInfo("qtyPrecision"));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.subMaterialSet, CompareType.INCLUDE));
        MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        for (int i = 0; i < mmuc.size(); ++i) {
            MultiMeasureUnitInfo muInfo = mmuc.get(i);
            String materialId = muInfo.getMaterial().getId().toString();
            String unitId = muInfo.getMeasureUnit().getId().toString();
            String key = materialId + unitId;
            int precision = muInfo.getQtyPrecision();
            if (this.osmmuMap.containsKey(materialId)) continue;
            this.osmmuMap.put(key, new Integer(precision));
        }
    }

    protected void genOSSubItem4WH(Context ctx) throws BOSException, EASBizException {
        String trackNumberId;
        String projectId;
        String materialId;
        String osSourceId;
        OSSubItemInfo subItemInfo;
        int i;
        this.osSubItem4WHList = new ArrayList();
        this.subItem4WHMap = new HashMap();
        if (this.osSimPattern.getValue() == 0 || this.osCalcParam.getWarehousescope().getValue() == 10) {
            return;
        }
        for (i = 0; i < this.osSubItemList.size(); ++i) {
            subItemInfo = (OSSubItemInfo)this.osSubItemList.get(i);
            osSourceId = subItemInfo.getOSSourceId();
            materialId = subItemInfo.getMaterial().getId().toString();
            projectId = "";
            trackNumberId = "";
            if (subItemInfo.getProject() != null && subItemInfo.getProject().getId() != null && subItemInfo.getProject().getId().toString().length() > 0) {
                projectId = subItemInfo.getProject().getId().toString();
            }
            if (subItemInfo.getTrackNumber() != null && subItemInfo.getTrackNumber().getId() != null && subItemInfo.getTrackNumber().getId().toString().length() > 0) {
                trackNumberId = subItemInfo.getTrackNumber().getId().toString();
            }
            String key = osSourceId + "#" + materialId + projectId + trackNumberId;
            for (int j = 0; j < this.osInvDetailList.size(); ++j) {
                List<OSSubItemInfo> subItem4WHList;
                OSInvDetailInfo oSInvDetailInfo = (OSInvDetailInfo)this.osInvDetailList.get(j);
                String invMaterialId = oSInvDetailInfo.getMaterial().getId().toString();
                if (!materialId.equals(invMaterialId)) continue;
                OSSubItemInfo subItem4WHInfo = new OSSubItemInfo();
                this.osSubItem4WHList.add(subItem4WHInfo);
                subItem4WHInfo.setOSSourceId(osSourceId);
                subItem4WHInfo.setWareHouse(oSInvDetailInfo.getWareHouse());
                subItem4WHInfo.setInvQty(oSInvDetailInfo.getCurStoreQty());
                subItem4WHInfo.setBsInvQty(oSInvDetailInfo.getBsCurStoreQty());
                subItem4WHInfo.setStockReserveQty(SysConstant.BIGZERO);
                subItem4WHInfo.setBsStockReserveQty(SysConstant.BIGZERO);
                subItem4WHInfo.setSimReserveQty(SysConstant.BIGZERO);
                subItem4WHInfo.setBsSimReserveQty(SysConstant.BIGZERO);
                subItem4WHInfo.setUnit(subItemInfo.getUnit());
                subItem4WHInfo.setBsUnit(subItemInfo.getBsUnit());
                subItem4WHInfo.setOperationNo(subItemInfo.getOperationNo());
                subItem4WHInfo.setOperationNumber(subItemInfo.getOperationNumber());
                subItem4WHInfo.setOperationName(subItemInfo.getOperationName());
                subItem4WHInfo.setMaterial(oSInvDetailInfo.getMaterial());
                if (this.subItem4WHMap.containsKey(key)) {
                    subItem4WHList = (List)this.subItem4WHMap.get(key);
                    subItem4WHList.add(subItem4WHInfo);
                    continue;
                }
                subItem4WHList = new ArrayList();
                this.subItem4WHMap.put(key, subItem4WHList);
                subItem4WHList.add(subItem4WHInfo);
            }
        }
        if (this.subItem4WHMap.size() > 0) {
            for (String key : this.subItem4WHMap.keySet()) {
                List subItem4WHList = (List)this.subItem4WHMap.get(key);
                Collections.sort((List)subItem4WHList, (Comparator)this.getSubItem4WHComparator());
                materialId = null;
                String stockReserveKey = key.substring(key.indexOf("#") + 1);
                BigDecimal bsTotalQty = (BigDecimal)this.stockReserveMap.get(stockReserveKey);
                if (bsTotalQty == null) {
                    bsTotalQty = SysConstant.BIGZERO;
                }
                BigDecimal bsAlloQty = SysConstant.BIGZERO;
                for (int i2 = 0; i2 < subItem4WHList.size(); ++i2) {
                    OSSubItemInfo subItem4WHInfo = (OSSubItemInfo)subItem4WHList.get(i2);
                    String warehsId = subItem4WHInfo.getWareHouse().getId().toString();
                    materialId = subItem4WHInfo.getMaterial().getId().toString();
                    String innerKey = stockReserveKey + warehsId;
                    BigDecimal bsStockReserve4WHQty = (BigDecimal)this.stockReserve4WHMap.get(innerKey);
                    if (bsStockReserve4WHQty != null) {
                        BigDecimal bsRemainsQty = subItem4WHInfo.getBsInvQty().subtract(subItem4WHInfo.getBsStockReserveQty());
                        if (bsStockReserve4WHQty.compareTo(SysConstant.BIGZERO) == 1 && bsRemainsQty.compareTo(SysConstant.BIGZERO) == 1) {
                            if (bsStockReserve4WHQty.compareTo(bsRemainsQty) == 1) {
                                subItem4WHInfo.setBsStockReserveQty(subItem4WHInfo.getBsInvQty());
                            } else {
                                subItem4WHInfo.setBsStockReserveQty(subItem4WHInfo.getBsStockReserveQty().add(bsStockReserve4WHQty));
                            }
                        }
                        bsAlloQty = bsAlloQty.add(subItem4WHInfo.getBsStockReserveQty());
                    }
                    BigDecimal stockReserveQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialId, (MeasureUnitInfo)subItem4WHInfo.getBsUnit(), (MeasureUnitInfo)subItem4WHInfo.getUnit(), (BigDecimal)subItem4WHInfo.getBsStockReserveQty());
                    subItem4WHInfo.setStockReserveQty(stockReserveQty);
                }
                BigDecimal bsNoWHQty = bsTotalQty.subtract(bsAlloQty);
                for (int i3 = 0; i3 < subItem4WHList.size(); ++i3) {
                    OSSubItemInfo subItem4WHInfo = (OSSubItemInfo)subItem4WHList.get(i3);
                    BigDecimal bsRemainsQty = subItem4WHInfo.getBsInvQty().subtract(subItem4WHInfo.getBsStockReserveQty());
                    materialId = subItem4WHInfo.getMaterial().getId().toString();
                    if (bsNoWHQty.compareTo(SysConstant.BIGZERO) == 1 && bsRemainsQty.compareTo(SysConstant.BIGZERO) == 1) {
                        if (bsNoWHQty.compareTo(bsRemainsQty) == 1) {
                            subItem4WHInfo.setBsStockReserveQty(subItem4WHInfo.getBsInvQty());
                            bsNoWHQty = bsNoWHQty.subtract(bsRemainsQty);
                        } else {
                            subItem4WHInfo.setBsStockReserveQty(subItem4WHInfo.getBsStockReserveQty().add(bsNoWHQty));
                            bsNoWHQty = SysConstant.BIGZERO;
                        }
                    }
                    BigDecimal stockReserveQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialId, (MeasureUnitInfo)subItem4WHInfo.getBsUnit(), (MeasureUnitInfo)subItem4WHInfo.getUnit(), (BigDecimal)subItem4WHInfo.getBsStockReserveQty());
                    subItem4WHInfo.setStockReserveQty(stockReserveQty);
                }
                if (bsNoWHQty.compareTo(SysConstant.BIGZERO) != 1) continue;
                OSSubItemInfo subItem4WHInfo = (OSSubItemInfo)subItem4WHList.get(0);
                subItem4WHInfo.setBsStockReserveQty(subItem4WHInfo.getBsStockReserveQty().add(bsNoWHQty));
                BigDecimal stockReserveQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialId, (MeasureUnitInfo)subItem4WHInfo.getBsUnit(), (MeasureUnitInfo)subItem4WHInfo.getUnit(), (BigDecimal)subItem4WHInfo.getBsStockReserveQty());
                subItem4WHInfo.setStockReserveQty(stockReserveQty);
            }
        }
        for (i = 0; i < this.osSubItemList.size(); ++i) {
            OSSubItemInfo subItem4WHInfo;
            subItemInfo = (OSSubItemInfo)this.osSubItemList.get(i);
            osSourceId = subItemInfo.getOSSourceId();
            materialId = subItemInfo.getMaterial().getId().toString();
            projectId = "";
            trackNumberId = "";
            if (subItemInfo.getProject() != null && subItemInfo.getProject().getId() != null && subItemInfo.getProject().getId().toString().length() > 0) {
                projectId = subItemInfo.getProject().getId().toString();
            }
            if (subItemInfo.getTrackNumber() != null && subItemInfo.getTrackNumber().getId() != null && subItemInfo.getTrackNumber().getId().toString().length() > 0) {
                trackNumberId = subItemInfo.getTrackNumber().getId().toString();
            }
            String warehsId = subItemInfo.getWareHouse() == null ? null : subItemInfo.getWareHouse().getId().toString();
            BigDecimal reserveQty = subItemInfo.getSimReserveQty();
            if (reserveQty.compareTo(SysConstant.BIGZERO) != 1) continue;
            String key = osSourceId + "#" + materialId + projectId + trackNumberId;
            List subItem4WHList = (List)this.subItem4WHMap.get(key);
            if (subItem4WHList == null || subItem4WHList.size() == 0) {
                return;
            }
            Collections.sort((List)subItem4WHList, (Comparator)this.getSubItem4WHComparator());
            if (warehsId != null) {
                for (int j = 0; j < subItem4WHList.size(); ++j) {
                    subItem4WHInfo = (OSSubItemInfo)subItem4WHList.get(j);
                    String tmpWarehsId = subItem4WHInfo.getWareHouse().getId().toString();
                    if (!tmpWarehsId.equals(warehsId)) continue;
                    BigDecimal remainsQty = subItem4WHInfo.getInvQty().subtract(subItem4WHInfo.getStockReserveQty());
                    if (reserveQty.compareTo(remainsQty) == 1) {
                        subItem4WHInfo.setSimReserveQty(subItem4WHInfo.getSimReserveQty().add(remainsQty));
                        reserveQty = reserveQty.subtract(remainsQty);
                        break;
                    }
                    subItem4WHInfo.setSimReserveQty(reserveQty);
                    reserveQty = SysConstant.BIGZERO;
                    break;
                }
            }
            if (reserveQty.compareTo(SysConstant.BIGZERO) == 1) {
                for (int j = 0; j < subItem4WHList.size(); ++j) {
                    subItem4WHInfo = (OSSubItemInfo)subItem4WHList.get(j);
                    BigDecimal remainsQty = subItem4WHInfo.getInvQty().subtract(subItem4WHInfo.getStockReserveQty()).subtract(subItem4WHInfo.getSimReserveQty());
                    if (reserveQty.compareTo(SysConstant.BIGZERO) != 1 || remainsQty.compareTo(SysConstant.BIGZERO) != 1) continue;
                    if (reserveQty.compareTo(remainsQty) == 1) {
                        subItem4WHInfo.setSimReserveQty(subItem4WHInfo.getSimReserveQty().add(remainsQty));
                        reserveQty = reserveQty.subtract(remainsQty);
                        continue;
                    }
                    subItem4WHInfo.setSimReserveQty(reserveQty);
                    reserveQty = SysConstant.BIGZERO;
                }
            }
            if (reserveQty.compareTo(SysConstant.BIGZERO) != 1) continue;
            OSSubItemInfo subItem4WHInfo2 = (OSSubItemInfo)subItem4WHList.get(0);
            subItem4WHInfo2.setSimReserveQty(subItem4WHInfo2.getSimReserveQty().add(reserveQty));
        }
    }

    protected Comparator getSubItem4WHComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Map whPriorityMap = OSCalculation.this.osCalcParam.getWarehousePriority();
                OSSubItemInfo osSubItemInfo1 = (OSSubItemInfo)arg0;
                String whId1 = osSubItemInfo1.getWareHouse().getId().toString();
                Integer priority1 = (Integer)whPriorityMap.get(whId1);
                OSSubItemInfo osSubItemInfo2 = (OSSubItemInfo)arg1;
                String whId2 = osSubItemInfo2.getWareHouse().getId().toString();
                Integer priority2 = (Integer)whPriorityMap.get(whId2);
                return priority1.compareTo(priority2);
            }
        };
    }

    private MaterialPlanInfo getMaterialPlanInfo(Context ctx, String materialId) throws BOSException {
        MaterialPlanInfo mpInfo = null;
        if (this.materialPlanMap != null && this.materialPlanMap.containsKey(materialId)) {
            mpInfo = (MaterialPlanInfo)this.materialPlanMap.get(materialId);
        }
        if (mpInfo == null) {
            HashSet<String> materialIds = new HashSet<String>();
            materialIds.add(materialId);
            this.cacheMaterialPlanInfo(ctx, materialIds);
            if (this.materialPlanMap != null && this.materialPlanMap.containsKey(materialId)) {
                mpInfo = (MaterialPlanInfo)this.materialPlanMap.get(materialId);
            }
        }
        return mpInfo;
    }

    private void cacheMaterialPlanInfo(Context ctx, Set materialSet) throws BOSException {
        if (materialSet.size() == 0) {
            return;
        }
        if (this.materialPlanMap == null) {
            this.materialPlanMap = new HashMap();
        }
        if (this.productUnitMap == null) {
            this.productUnitMap = new HashMap();
        }
        if (this.keyPartMap == null) {
            this.keyPartMap = new HashMap();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(coll);
        coll.add(new SelectorItemInfo("isKeyPart"));
        coll.add(new SelectorItemInfo("productUnit.id"));
        coll.add(new SelectorItemInfo("productUnit.name"));
        coll.add(new SelectorItemInfo("productUnit.number"));
        coll.add(new SelectorItemInfo("manufactureStrategy.id"));
        coll.add(new SelectorItemInfo("manufactureStrategy.name"));
        coll.add(new SelectorItemInfo("manufactureStrategy.number"));
        coll.add(new SelectorItemInfo("isolatedRule"));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.osOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        IMaterialPlan iMPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
        MaterialPlanCollection collection = iMPlan.getMaterialPlanCollection(view);
        MaterialPlanInfo mpInfo = null;
        int count = collection.size();
        for (int i = 0; i < count; ++i) {
            mpInfo = collection.get(i);
            String materialId = mpInfo.getMaterial().getId().toString();
            if (!this.materialPlanMap.containsKey(materialId)) {
                this.materialPlanMap.put(materialId, mpInfo);
            }
            if (!this.productUnitMap.containsKey(materialId)) {
                this.productUnitMap.put(materialId, mpInfo.getProductUnit());
            }
            if (this.keyPartMap.containsKey(materialId)) continue;
            this.keyPartMap.put(materialId, new Boolean(mpInfo.isIsKeyPart()));
        }
    }

    private String getKeyByManuStrategy(Context ctx, String materialId, ProjectInfo project, TrackNumberInfo trackNumber) throws BOSException {
        MaterialPlanInfo mpInfo;
        String result = materialId;
        String projectId = "";
        String trackNumberId = "";
        if (project != null && project.getId() != null) {
            projectId = project.getId().toString();
        }
        if (trackNumber != null && trackNumber.getId() != null) {
            trackNumberId = trackNumber.getId().toString();
        }
        if ((mpInfo = this.getMaterialPlanInfo(ctx, materialId)) != null && mpInfo.getManufactureStrategy() != null) {
            IsolatedRuleEnum ir;
            String strategyId = mpInfo.getManufactureStrategy().getId().toString();
            result = strategyId.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") ? ((ir = mpInfo.getIsolatedRule()) == IsolatedRuleEnum.ITEM_TRACKNO ? materialId + projectId + trackNumberId : (ir == IsolatedRuleEnum.ITEM ? materialId + projectId : materialId)) : (strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") ? materialId + trackNumberId : materialId);
        }
        return result;
    }
}

