/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.ThrowModeEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BasedataException;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.OSCaculateParamInfo;
import com.kingdee.eas.mm.mo.OSFilterParamInfo;
import com.kingdee.eas.mm.mo.OSResultInfo;
import com.kingdee.eas.mm.mo.OSSourceBillTypeEnum;
import com.kingdee.eas.mm.mo.OSSourceCollection;
import com.kingdee.eas.mm.mo.OSSourceInfo;
import com.kingdee.eas.mm.mo.OrderSimulationException;
import com.kingdee.eas.mm.mo.SimPatternEnum;
import com.kingdee.eas.mm.mo.app.AbstractOrderSimulationFacadeControllerBean;
import com.kingdee.eas.mm.mo.app.OSCalculation;
import com.kingdee.eas.mm.planning.IPlannedOrder;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderNewMappingFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderSimulationFacadeControllerBean
extends AbstractOrderSimulationFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.OrderSimulationFacadeControllerBean");
    private static Map precisionMap = new HashMap();

    @Override
    protected List _getOSSourceCollectionByFilter(Context ctx, OSFilterParamInfo osfilter) throws BOSException, EASBizException {
        ArrayList<Object> result = new ArrayList<Object>();
        OSSourceCollection queryResult = new OSSourceCollection();
        if (osfilter.getHasFlowOrder() == 32) {
            queryResult.addCollection(this.getFlowOrder(osfilter, ctx));
        }
        if (osfilter.getHasDiscreteOrder() == 32) {
            queryResult.addCollection(this.getDiscreteOrder(osfilter, ctx));
        }
        if (osfilter.getHasPlanOrder() == 32) {
            queryResult.addCollection(this.getPlanOrder(osfilter, ctx));
        }
        this.updatePrecisionMap(ctx, queryResult);
        result.add((Object)queryResult);
        result.add(precisionMap);
        return result;
    }

    @Override
    protected List _getOSSourceCollectionByOrder(Context ctx, List orderIds, String orderType, StorageOrgUnitInfo stoOrg) throws BOSException, EASBizException {
        ArrayList<Object> result = new ArrayList<Object>();
        OSSourceCollection queryResult = new OSSourceCollection();
        queryResult = this.setValueByOrderIds(ctx, orderIds, orderType, stoOrg);
        this.updatePrecisionMap(ctx, queryResult);
        result.add((Object)queryResult);
        result.add(precisionMap);
        return result;
    }

    private OSSourceCollection setValueByOrderIds(Context ctx, List orderIds, String orderType, StorageOrgUnitInfo stoOrg) throws BOSException, EASBizException {
        OSSourceCollection queryResult = new OSSourceCollection();
        String ids = this.getStrIds(orderIds);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = this.getFilter(ids);
        if (orderType.equalsIgnoreCase("prdOrder")) {
            FilterInfo filterInfo1 = new FilterInfo();
            filterInfo1.getFilterItems().add(new FilterItemInfo("unit.id is not null"));
            filterInfo1.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)stoOrg.getId().toString(), CompareType.EQUALS));
            filterInfo.mergeFilter(filterInfo1, "AND");
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(this.getFOSelectors());
            viewInfo.setSorter(this.getSorter(0));
            queryResult.addCollection(this.getFOrder(ctx, viewInfo));
        } else if (orderType.equalsIgnoreCase("mnfOrder")) {
            FilterInfo filterInfo1 = new FilterInfo();
            filterInfo1.getFilterItems().add(new FilterItemInfo("unit.id is not null"));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(this.getDOSelectors());
            viewInfo.setSorter(this.getSorter(1));
            queryResult.addCollection(this.getDOrder(ctx, viewInfo));
        }
        return queryResult;
    }

    private SelectorItemCollection getFOSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("bom.id"));
        sic.add(new SelectorItemInfo("bom.name"));
        sic.add(new SelectorItemInfo("bom.number"));
        sic.add(new SelectorItemInfo("formula.id"));
        sic.add(new SelectorItemInfo("formula.name"));
        sic.add(new SelectorItemInfo("formula.number"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        sic.add(new SelectorItemInfo("material.baseUnit.number"));
        sic.add(new SelectorItemInfo("productLine.id"));
        sic.add(new SelectorItemInfo("productLine.name"));
        sic.add(new SelectorItemInfo("productLine.number"));
        sic.add(new SelectorItemInfo("stockEntry.*"));
        return sic;
    }

    private String getStrIds(List orderIds) {
        StringBuffer st = new StringBuffer();
        if (orderIds != null && orderIds.size() > 0) {
            for (String orderId : orderIds) {
                st.append(orderId);
                st.append(",");
            }
            return st.substring(0, st.toString().length() - 1);
        }
        return "";
    }

    private SelectorItemCollection getDOSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        sic.add(new SelectorItemInfo("material.baseUnit.number"));
        sic.add(new SelectorItemInfo("stocks.*"));
        return sic;
    }

    private FilterInfo getFilter(String ids) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemCollection = filter.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("number is not null"));
        filterItemCollection.add(new FilterItemInfo("material is not null"));
        filterItemCollection.add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filterItemCollection.add(new FilterItemInfo("baseStatus", (Object)new Integer(2), CompareType.EQUALS));
        filterItemCollection.add(new FilterItemInfo("baseStatus", (Object)new Integer(1), CompareType.EQUALS));
        filterItemCollection.add(new FilterItemInfo("qty", (Object)new BigDecimal(0), CompareType.GREATER));
        filterItemCollection.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        String maskString = "#0 AND #1 AND (#2 OR #3 OR #4)AND #5 AND #6";
        filter.setMaskString(maskString);
        return filter;
    }

    private SorterItemCollection getSorter(int key) {
        SorterItemCollection sorter = new SorterItemCollection();
        if (key == 0) {
            sorter.add(new SorterItemInfo("startDate"));
        } else if (key == 1) {
            sorter.add(new SorterItemInfo("planBeginDate"));
        }
        return sorter;
    }

    private OSSourceCollection getFOrder(Context ctx, EntityViewInfo viewInfo) throws BOSException {
        OSSourceCollection flowOrderResult = new OSSourceCollection();
        IProductionOrder porder = ProductionOrderFactory.getLocalInstance((Context)ctx);
        ProductionOrderCollection prodCol = porder.getProductionOrderCollection(viewInfo);
        if (prodCol != null && prodCol.size() > 0) {
            for (int i = 0; i < prodCol.size(); ++i) {
                ProductionOrderInfo srcOrder = prodCol.get(i);
                if (srcOrder.getStockEntry() != null) {
                    boolean checkStockentrySuccess = false;
                    ProductionOrderStockEntryCollection stockColl = srcOrder.getStockEntry();
                    for (int s = 0; s < stockColl.size(); ++s) {
                        ProductionOrderStockEntryInfo stockentry;
                        if (stockColl.get(s) == null || !MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)(stockentry = stockColl.get(s)).getIssMode()) && !MaterialIssueModeEnum.KANBANISSMODE.equals((Object)stockentry.getIssMode())) continue;
                        checkStockentrySuccess = true;
                    }
                    if (!checkStockentrySuccess) continue;
                }
                OSSourceInfo os = new OSSourceInfo();
                os.setSourceType(OSSourceBillTypeEnum.FLOWORDER);
                os.setSourceBillNumber(srcOrder.getNumber());
                os.setMaterial(srcOrder.getMaterial());
                os.setMaterialModel(srcOrder.getMaterial() != null ? srcOrder.getMaterial().getModel() : "");
                os.setMaterialName(srcOrder.getMaterial() != null ? srcOrder.getMaterial().getName() : "");
                os.setOrderQty(srcOrder.getQty());
                os.setBsOrderQty(srcOrder.getBaseQty());
                os.setUnit(srcOrder.getUnit());
                os.setBsUnit((MeasureUnitInfo)(srcOrder.getBaseUnit() != null ? srcOrder.getBaseUnit() : (srcOrder.getMaterial() != null ? srcOrder.getMaterial().getBaseUnit() : null)));
                os.setReqOSQty(srcOrder.getQty());
                os.setBsReqOSQty(srcOrder.getBaseQty());
                os.setBom(srcOrder.getBom());
                os.setProductLine(srcOrder.getProductLine());
                os.setFormula(srcOrder.getFormula());
                os.setStartDate(srcOrder.getStartDate());
                os.setEndDate(srcOrder.getEndDate());
                os.setRemark(srcOrder.getRemark());
                os.setBaseStatus(srcOrder.getBaseStatus());
                os.setTrackNumber(srcOrder.getTrackNumber());
                os.setSourceBillId(srcOrder.getId().toString());
                flowOrderResult.add(os);
            }
        }
        return flowOrderResult;
    }

    private OSSourceCollection getDOrder(Context ctx, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        OSSourceCollection manuOrderResult = new OSSourceCollection();
        IManufactureOrder manuOrder = ManufactureOrderFactory.getLocalInstance(ctx);
        ManufactureOrderCollection manuColl = manuOrder.getManufactureOrderCollection(viewInfo);
        if (manuColl != null && manuColl.size() > 0) {
            Iterator it = manuColl.iterator();
            while (it.hasNext()) {
                IBom ibom;
                ManufactureOrderInfo srcOrder = (ManufactureOrderInfo)it.next();
                ManufactureOrderStockCollection stockColl = srcOrder.getStocks();
                if (stockColl != null) {
                    boolean checkStockentrySuccess = false;
                    for (int s = 0; s < stockColl.size(); ++s) {
                        if (stockColl.get(s) == null) continue;
                        ManufactureOrderStockInfo stockentry = stockColl.get(s);
                        MaterialIssueModeEnum issueMode = stockentry.getIssueMode();
                        MaterialProvideTypeEnum provideType = stockentry.getProvideType();
                        if (issueMode != MaterialIssueModeEnum.PRODUCEISSMODE && issueMode != MaterialIssueModeEnum.KANBANISSMODE || provideType != MaterialProvideTypeEnum.CURRENTORGPROVIDE && provideType != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE && provideType != MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE) continue;
                        checkStockentrySuccess = true;
                    }
                    if (!checkStockentrySuccess) continue;
                }
                OSSourceInfo os = new OSSourceInfo();
                os.setSourceType(OSSourceBillTypeEnum.getEnum(20));
                os.setSourceBillNumber(srcOrder.getNumber());
                os.setMaterial(srcOrder.getMaterial());
                os.setMaterialModel(srcOrder.getMaterial() != null ? srcOrder.getMaterial().getModel() : "");
                os.setMaterialName(srcOrder.getMaterial() != null ? srcOrder.getMaterial().getName() : "");
                os.setOrderQty(srcOrder.getQty());
                os.setBsOrderQty(srcOrder.getBaseQty());
                os.setUnit(srcOrder.getUnit());
                os.setBsUnit((MeasureUnitInfo)(srcOrder.getBaseUnit() != null ? srcOrder.getBaseUnit() : (srcOrder.getMaterial() != null ? srcOrder.getMaterial().getBaseUnit() : null)));
                os.setReqOSQty(srcOrder.getQty());
                os.setBsReqOSQty(srcOrder.getBaseQty());
                BomInfo bom = null;
                if (srcOrder.getBomID() != null && srcOrder.getBomID().length() > 0 && (ibom = BomFactory.getLocalInstance((Context)ctx)).exists((IObjectPK)new ObjectUuidPK(srcOrder.getBomID()))) {
                    bom = (BomInfo)ibom.getValue((IObjectPK)new ObjectUuidPK(srcOrder.getBomID()));
                }
                os.setBom(bom);
                os.setStartDate(srcOrder.getPlanBeginDate());
                os.setEndDate(srcOrder.getPlanEndDate());
                os.setBaseStatus(srcOrder.getBaseStatus());
                os.setRemark(srcOrder.getRemark());
                os.setSourceBillId(srcOrder.getId().toString());
                os.setTrackNumber(srcOrder.getTrackNumber());
                os.setProject(srcOrder.getProject());
                manuOrderResult.add(os);
            }
        }
        return manuOrderResult;
    }

    private void updatePrecisionMap(Context ctx, OSSourceCollection queryResultColl) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        ArrayList<String> keyList = new ArrayList<String>();
        String materialId = null;
        String unitId = null;
        String key = null;
        for (int i = 0; i < queryResultColl.size(); ++i) {
            if (queryResultColl != null) {
                materialId = queryResultColl.get(i).getMaterial().getId().toString();
                unitId = queryResultColl.get(i).getUnit().getId().toString();
            }
            if (precisionMap.get(key = materialId + unitId) != null || keyList.contains(key)) continue;
            keyList.add(key);
            if (sqlWhere.length() > 0) {
                sqlWhere.append("or ");
            }
            sqlWhere.append("(material.id = '").append(materialId).append("' and measureUnit.id = '").append(unitId).append("' ) ");
        }
        if (sqlWhere.length() > 0) {
            MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(" where " + sqlWhere.toString());
            int precision = 0;
            for (int i = 0; i < mmuc.size(); ++i) {
                materialId = mmuc.get(i).getMaterial().getId().toString();
                unitId = mmuc.get(i).getMeasureUnit().getId().toString();
                key = materialId + unitId;
                precision = mmuc.get(i).getQtyPrecision();
                precisionMap.put(key, new Integer(precision));
            }
        }
    }

    private OSSourceCollection getPlanOrder(OSFilterParamInfo filterinfo, Context ctx) throws BOSException, EASBizException {
        OSSourceCollection planorderResult = new OSSourceCollection();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = this.buildCommonFilter(filterinfo, OSSourceBillTypeEnum.getEnum(40), ctx);
        filterInfo.getFilterItems().add(new FilterItemInfo("orderType", (Object)new Integer(10), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bom is not null"));
        filterInfo.getFilterItems().add(new FilterItemInfo("productUnit is not null"));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("productUnit.id"));
        sic.add(new SelectorItemInfo("productUnit.name"));
        sic.add(new SelectorItemInfo("productUnit.number"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        sic.add(new SelectorItemInfo("material.baseUnit.number"));
        sic.add(new SelectorItemInfo("bom.*"));
        viewInfo.setSelector(sic);
        IPlannedOrder porder = PlannedOrderFactory.getLocalInstance((Context)ctx);
        PlannedOrderCollection Coll = porder.getPlannedOrderCollection(viewInfo);
        if (Coll != null && Coll.size() > 0) {
            for (int i = 0; i < Coll.size(); ++i) {
                PlannedOrderInfo srcOrder = Coll.get(i);
                OSSourceInfo os = new OSSourceInfo();
                os.setSourceType(OSSourceBillTypeEnum.getEnum(40));
                os.setSourceBillNumber(srcOrder.getNumber());
                os.setMaterial(srcOrder.getMaterial());
                os.setMaterialModel(srcOrder.getMaterial() != null ? srcOrder.getMaterial().getModel() : "");
                os.setMaterialName(srcOrder.getMaterial() != null ? srcOrder.getMaterial().getName() : "");
                os.setOrderQty(srcOrder.getQty());
                os.setBsOrderQty(srcOrder.getBaseQty());
                os.setUnit((MeasureUnitInfo)(srcOrder.getProductUnit() != null ? srcOrder.getProductUnit() : (srcOrder.getMaterial() != null ? srcOrder.getMaterial().getBaseUnit() : null)));
                os.setBsUnit((MeasureUnitInfo)(srcOrder.getUnit() != null ? srcOrder.getUnit() : (srcOrder.getMaterial() != null ? srcOrder.getMaterial().getBaseUnit() : null)));
                if (srcOrder.getBom() != null) {
                    os.setBom(srcOrder.getBom());
                }
                os.setBaseStatus(srcOrder.getBaseStatus());
                os.setStartDate(srcOrder.getStartDate());
                os.setEndDate(srcOrder.getEndDate());
                planorderResult.add(os);
                os.setSourceBillId(srcOrder.getId().toString());
                os.setProject(srcOrder.getProject());
                os.setTrackNumber(srcOrder.getTrackNumber());
                os.setReqOSQty(srcOrder.getQty().subtract(srcOrder.getTotalReleaseQty()));
                os.setBsReqOSQty(srcOrder.getBaseQty().subtract(srcOrder.getBaseTotalReleaseQty()));
            }
        }
        return planorderResult;
    }

    private OSSourceCollection getDiscreteOrder(OSFilterParamInfo filterinfo, Context ctx) throws BOSException, EASBizException {
        OSSourceCollection manuResult = new OSSourceCollection();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = this.buildCommonFilter(filterinfo, OSSourceBillTypeEnum.getEnum(20), ctx);
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id is not null"));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.getDOSelectors());
        manuResult = this.getDOrder(ctx, viewInfo);
        return manuResult;
    }

    private OSSourceCollection getFlowOrder(OSFilterParamInfo filterinfo, Context ctx) throws BOSException {
        OSSourceCollection flowResult = new OSSourceCollection();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = this.buildCommonFilter(filterinfo, OSSourceBillTypeEnum.getEnum(30), ctx);
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id is not null"));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.getFOSelectors());
        flowResult = this.getFOrder(ctx, viewInfo);
        return flowResult;
    }

    private FilterInfo buildCommonFilter(OSFilterParamInfo osFilter, OSSourceBillTypeEnum osenum, Context ctx) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)osFilter.getStorageUnitNum().getNumber()));
        filterInfo.getFilterItems().add(new FilterItemInfo("number is not null"));
        filterInfo.getFilterItems().add(new FilterItemInfo("material is not null"));
        filterInfo.getFilterItems().add(new FilterItemInfo("qty", (Object)new BigDecimal(0), CompareType.GREATER));
        if (osFilter.getMaterialNumFrom() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)osFilter.getMaterialNumFrom().getNumber(), CompareType.GREATER_EQUALS));
        }
        if (osFilter.getMaterialNumTo() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)osFilter.getMaterialNumTo().getNumber(), CompareType.LESS_EQUALS));
        }
        if (osFilter.getOrgunitNums() != null && osFilter.getOrgunitNums().length > 0) {
            HashSet<String> adminOrgSet = new HashSet<String>();
            for (int curIdx = 0; curIdx < osFilter.getOrgunitNums().length; ++curIdx) {
                AdminOrgUnitInfo curOrgInfo = osFilter.getOrgunitNums()[curIdx];
                adminOrgSet.add(curOrgInfo.getNumber());
            }
            if (osenum.getValue() == 30) {
                filterInfo.getFilterItems().add(new FilterItemInfo("workShop.number", adminOrgSet, CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.number", adminOrgSet, CompareType.INCLUDE));
            }
        }
        if (osFilter.getTrackNumStart() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.number", (Object)osFilter.getTrackNumStart().getNumber(), CompareType.GREATER_EQUALS));
        }
        if (osFilter.getTrackNumEnd() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.number", (Object)osFilter.getTrackNumEnd().getNumber(), CompareType.LESS_EQUALS));
        }
        HashSet<Integer> set = new HashSet<Integer>();
        if (osFilter.getHasSave() == 32 || osFilter.getHasSumbmit() == 32 || osFilter.getHasAudit() == 32) {
            if (osFilter.getHasSave() == 32) {
                set.add(new Integer(1));
            }
            if (osFilter.getHasSumbmit() == 32) {
                set.add(new Integer(2));
            }
            if (osFilter.getHasAudit() == 32) {
                set.add(new Integer(4));
            }
        }
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        }
        if (osFilter.getStartdateFrom() != null) {
            if (osenum.getValue() == 20) {
                filterInfo.getFilterItems().add(new FilterItemInfo("planBeginDate", (Object)osFilter.getStartdateFrom(), CompareType.GREATER_EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)osFilter.getStartdateFrom(), CompareType.GREATER_EQUALS));
            }
        }
        if (osFilter.getStartdateTo() != null) {
            if (osenum.getValue() == 20) {
                filterInfo.getFilterItems().add(new FilterItemInfo("planBeginDate", (Object)osFilter.getStartdateTo(), CompareType.LESS_EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)osFilter.getStartdateTo(), CompareType.LESS_EQUALS));
            }
        }
        if (osFilter.getEnddateFrom() != null) {
            if (osenum.getValue() == 20) {
                filterInfo.getFilterItems().add(new FilterItemInfo("planEndDate", (Object)osFilter.getEnddateFrom(), CompareType.GREATER_EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)osFilter.getEnddateFrom(), CompareType.GREATER_EQUALS));
            }
        }
        if (osFilter.getEnddateTo() != null) {
            if (osenum.getValue() == 20) {
                filterInfo.getFilterItems().add(new FilterItemInfo("planEndDate", (Object)osFilter.getEnddateTo(), CompareType.LESS_EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)osFilter.getEnddateTo(), CompareType.LESS_EQUALS));
            }
        }
        return filterInfo;
    }

    @Override
    protected Map _oSCalculate(Context ctx, List sourceList, OSCaculateParamInfo calcParam, Map mmuMap, StorageOrgUnitInfo orgUnitInfo, SimPatternEnum simPattern) throws BOSException, EASBizException {
        OSCalculation cal = new OSCalculation();
        return cal._oSCalculate(ctx, sourceList, calcParam, mmuMap, orgUnitInfo, simPattern);
    }

    private String parseCollection2String(Collection coll) {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        StringBuffer paramBuffer = new StringBuffer();
        String paramString = null;
        for (String id : coll) {
            paramBuffer.append("'").append(id).append("',");
        }
        paramString = paramBuffer.substring(0, paramBuffer.lastIndexOf(","));
        return paramString;
    }

    private Map[] getPlannedOrderDataMap(Object[] plaObj) {
        String[] colNames = new String[]{"startDate", "endDate", "releaseQty", "baseReleaseQty", "id", "isClose"};
        Map[] m = new Map[1];
        int length = colNames.length;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < length; ++i) {
            map.put(colNames[i], plaObj[i]);
        }
        m[0] = new HashMap();
        m[0] = map;
        return m;
    }

    @Override
    protected String _orderGenerate(Context ctx, String orgId, OSResultInfo osResultInfo, OSSourceInfo osSourceInfo) throws BOSException, EASBizException {
        String destId = null;
        OSSourceBillTypeEnum sourceType = osSourceInfo.getSourceType();
        ThrowModeEnum throwMode = osSourceInfo.getThrowMode();
        String sourceId = osSourceInfo.getSourceBillId();
        BigDecimal bsQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osSourceInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osSourceInfo.getUnit(), (MeasureUnitInfo)osSourceInfo.getBsUnit(), (BigDecimal)osResultInfo.getPrdQty());
        boolean isClose = false;
        if (sourceType == OSSourceBillTypeEnum.PLANORDER) {
            CoreBaseInfo retrivedInfo = PlannedOrderFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)osSourceInfo.getSourceBillId())));
            if (retrivedInfo == null) {
                return null;
            }
            if (osResultInfo.getReqOSQty() != null && osResultInfo.getReqOSQty().compareTo(osResultInfo.getPrdQty()) == 0) {
                isClose = true;
            }
            Object[] plaObj = new Object[]{osSourceInfo.getStartDate(), osSourceInfo.getEndDate(), osResultInfo.getPrdQty(), bsQty, sourceId, isClose};
            StringBuffer errorDetail = new StringBuffer();
            Map map = PlannedOrderNewMappingFacadeFactory.getLocalInstance((Context)ctx).mapping(this.getPlannedOrderDataMap(plaObj));
            if (map.size() != 0) {
                for (String key : map.keySet()) {
                    errorDetail.append(key).append("  ").append(map.get(key)).append("\n");
                }
            }
            if (map.size() > 0) {
                throw new BasedataException(BasedataException.BLANK, (Object[])new String[]{errorDetail.toString()});
            }
            ProductionOrderInfo prdInfo = new ProductionOrderInfo();
            String bosTypePrd = prdInfo.getBOSType().toString();
            ManufactureOrderInfo mnfInfo = new ManufactureOrderInfo();
            String bosTypeMnf = mnfInfo.getBOSType().toString();
            ArrayList prdIdList = BotRelationUtil.getDestObjectIdByDestType((Context)ctx, (String)sourceId, (String)bosTypePrd);
            ArrayList mnfIdList = null;
            if (prdIdList.size() == 0) {
                mnfIdList = BotRelationUtil.getDestObjectIdByDestType((Context)ctx, (String)sourceId, (String)bosTypeMnf);
            }
            String prdIdString = this.parseCollection2String(prdIdList);
            String mnfIdString = this.parseCollection2String(mnfIdList);
            if (prdIdList.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                SelectorItemCollection coll = new SelectorItemCollection();
                SorterItemCollection sortColl = new SorterItemCollection();
                view.setFilter(filter);
                view.setSelector(coll);
                view.setSorter(sortColl);
                coll.add(new SelectorItemInfo("id"));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)prdIdString, CompareType.INNER));
                SorterItemInfo sorter = new SorterItemInfo("createTime");
                sorter.setSortType(SortType.DESCEND);
                sortColl.add(sorter);
                ProductionOrderCollection prdColl = ProductionOrderFactory.getLocalInstance((Context)ctx).getProductionOrderCollection(view);
                if (prdColl != null && prdColl.size() > 0) {
                    ProductionOrderInfo productionOrderInfo = prdColl.get(0);
                    destId = productionOrderInfo.getId().toString();
                }
            } else if (null != mnfIdList && mnfIdList.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                SelectorItemCollection coll = new SelectorItemCollection();
                SorterItemCollection sortColl = new SorterItemCollection();
                view.setFilter(filter);
                view.setSelector(coll);
                view.setSorter(sortColl);
                coll.add(new SelectorItemInfo("id"));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)mnfIdString, CompareType.INNER));
                SorterItemInfo sorter = new SorterItemInfo("createTime");
                sorter.setSortType(SortType.DESCEND);
                sortColl.add(sorter);
                ManufactureOrderCollection mnfColl = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(view);
                if (mnfColl != null && mnfColl.size() > 0) {
                    ManufactureOrderInfo manufactureOrderInfo = mnfColl.get(0);
                    destId = manufactureOrderInfo.getId().toString();
                }
            }
        } else if (sourceType == OSSourceBillTypeEnum.HANDINPUT) {
            StorageOrgUnitInfo orgInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)));
            if (throwMode == ThrowModeEnum.FLOW) {
                ProductionOrderInfo orderInfo = new ProductionOrderInfo();
                orderInfo.setMaterial(osSourceInfo.getMaterial());
                orderInfo.setStorageOrgUnit(orgInfo);
                orderInfo.setTrackNumber(osSourceInfo.getTrackNumber());
                orderInfo.setUnit(osSourceInfo.getUnit());
                orderInfo.setBaseUnit(osSourceInfo.getBsUnit());
                orderInfo.setQty(osResultInfo.getPrdQty());
                orderInfo.setBaseQty(bsQty);
                orderInfo.setBom(osSourceInfo.getBom());
                orderInfo.setFormula(osSourceInfo.getFormula());
                orderInfo.setProductLine(osSourceInfo.getProductLine());
                orderInfo.setStartDate(osSourceInfo.getStartDate());
                orderInfo.setEndDate(osSourceInfo.getEndDate());
                orderInfo.setExpectEndDate(osSourceInfo.getEndDate());
                orderInfo.setRemark(osSourceInfo.getRemark());
                destId = ProductionOrderFactory.getLocalInstance((Context)ctx).genPrdOrder(orderInfo);
            } else if (throwMode == ThrowModeEnum.DISCRETE) {
                ManufactureOrderInfo orderInfo = new ManufactureOrderInfo();
                orderInfo.setMaterial(osSourceInfo.getMaterial());
                orderInfo.setStorageOrgUnit(orgInfo);
                orderInfo.setProject(osSourceInfo.getProject());
                orderInfo.setTrackNumber(osSourceInfo.getTrackNumber());
                orderInfo.setUnit(osSourceInfo.getUnit());
                orderInfo.setBaseUnit(osSourceInfo.getBsUnit());
                orderInfo.setQty(osResultInfo.getPrdQty());
                BigDecimal bsReqOSQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)osSourceInfo.getMaterial().getId().toString(), (MeasureUnitInfo)osSourceInfo.getUnit(), (MeasureUnitInfo)osSourceInfo.getBsUnit(), (BigDecimal)osResultInfo.getPrdQty());
                orderInfo.setBaseQty(bsReqOSQty);
                orderInfo.setBomID(osSourceInfo.getBom().getId().toString());
                orderInfo.setBomNum(osSourceInfo.getBom().getNumber());
                orderInfo.setPlanBeginDate(new Timestamp(osSourceInfo.getStartDate().getTime()));
                orderInfo.setPlanEndDate(new Timestamp(osSourceInfo.getEndDate().getTime()));
                orderInfo.setRemark(osSourceInfo.getRemark());
                destId = ManufactureOrderFactory.getLocalInstance(ctx).genMnfOrder(orderInfo);
            }
        }
        return destId;
    }

    @Override
    protected String _orderRelease(Context ctx, String orgId, String orderId, String orderNumber) throws BOSException, EASBizException {
        String exceptionMsg = null;
        ProductionOrderInfo prdInfo = new ProductionOrderInfo();
        BOSObjectType bosTypePrd = prdInfo.getBOSType();
        ManufactureOrderInfo mnfInfo = new ManufactureOrderInfo();
        BOSObjectType bosTypeMnf = mnfInfo.getBOSType();
        BOSUuid orderUuid = BOSUuid.read((String)orderId);
        ObjectUuidPK orderPK = new ObjectUuidPK(orderUuid);
        BOSObjectType bosTypeOrder = orderUuid.getType();
        ObjectUuidPK userPK = new ObjectUuidPK(ctx.getCaller().toString());
        ObjectUuidPK orgPK = new ObjectUuidPK(BOSUuid.read((String)orgId));
        IPermission iPer = PermissionFactory.getLocalInstance((Context)ctx);
        if (bosTypeOrder.equals((Object)bosTypePrd)) {
            try {
                iPer.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "mm_productionOrder_released");
            }
            catch (BOSException e1) {
                throw new OrderSimulationException(OrderSimulationException.PERM_PRDORDER);
            }
            ProductionOrderInfo orderInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)orderPK);
            if (orderInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                throw new OrderSimulationException(OrderSimulationException.NOTAUDIT_NOTRELEASE);
            }
            ProductionOrderFactory.getLocalInstance((Context)ctx).released((IObjectPK)orderPK);
        } else if (bosTypeOrder.equals((Object)bosTypeMnf)) {
            try {
                iPer.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "mm_mo_released");
            }
            catch (BOSException e1) {
                throw new OrderSimulationException(OrderSimulationException.PERM_MNFORDER);
            }
            ManufactureOrderInfo orderInfo = (ManufactureOrderInfo)ManufactureOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)orderPK);
            if (orderInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                throw new OrderSimulationException(OrderSimulationException.NOTAUDIT_NOTRELEASE);
            }
            ManufactureOrderFactory.getLocalInstance(ctx).released((IObjectPK)orderPK);
        }
        return exceptionMsg;
    }
}

