/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.mm.mo.app.AbstractProductionScheduleFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ProductionScheduleFacadeControllerBean
extends AbstractProductionScheduleFacadeControllerBean {
    private static final int eachExecuteSize = 500;

    @Override
    protected Map _prepareData(Context ctx, Collection ids) throws BOSException {
        String ps_tableSchema = this.getProScheduleTableSchema();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            String tempTableName = null;
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(ps_tableSchema);
            this.buildProductionScheduleData(ctx, tempTableName, ids);
            returnMap.put("TABLENAME", tempTableName);
            returnMap.put("ROWCOUNT", new Integer(this.getRowCount(ctx, tempTableName)));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    @Override
    protected IRowSet _getDataForOnePage(Context ctx, String tableName, int start, int length) throws BOSException {
        StringBuffer proSchedule = new StringBuffer();
        proSchedule.append(" SELECT * ");
        proSchedule.append(" FROM " + tableName);
        proSchedule.append(" ORDER BY FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)proSchedule.toString(), (int)start, (int)length);
        return rs;
    }

    protected int getRowCount(Context ctx, String tableName) throws BOSException {
        String sql = " SELECT count(1) as CNO FROM " + tableName;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            rs.next();
            return rs.getInt("CNO");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    protected void buildProductionScheduleData(Context ctx, String tableName, Collection ids) throws BOSException {
        this.getManOrderBaseInfo(ctx, tableName, ids);
        String moLaborHourTable = this.calMOLaborHour(ctx, ids);
        String reportLaborHourTable = this.calReportLaborHour(ctx, ids);
        this.calLaborFinishRate(ctx, tableName, moLaborHourTable, reportLaborHourTable);
        this._releaseTempTable(ctx, moLaborHourTable);
        this._releaseTempTable(ctx, reportLaborHourTable);
    }

    protected void getManOrderBaseInfo(Context ctx, String tableName, Collection ids) throws BOSException {
        String curLocale = ctx.getLocale().toString();
        StringBuffer getMoData = new StringBuffer();
        getMoData.append("INSERT INTO " + tableName);
        getMoData.append("(FID,FNumber,FStorageOrgUnitID,FIsKeyPart,FMaterialNumber,");
        getMoData.append(" FProjectNumber,FTrackNumber,FMaterialName,FUnitName,");
        getMoData.append(" FAdminOrgUnitName,FDispatcherName,FBizTypeName,");
        getMoData.append(" FBizDate,FBaseStatus,");
        getMoData.append(" FQty,FFinishedQty,FToStoreQty,FQtyPrecision,");
        getMoData.append(" FFinishRate,FInWareHsRate,");
        getMoData.append(" FLot,");
        getMoData.append(" FMaterialModel,FPlanBeginDate,FPlanEndDate,FSaleOrderNumber,FLongNumber)");
        getMoData.append("  SELECT t1.FID,t1.FNumber,t1.FStorageOrgUnitID,t4.FIsKeyPart,");
        getMoData.append(" t2.FNumber,t5.FNumber,t6.FNumber");
        getMoData.append(",t2.FName_" + curLocale);
        getMoData.append(",t3.FName_" + curLocale);
        getMoData.append(",t7.FName_" + curLocale);
        getMoData.append(",t8.FName_" + curLocale);
        getMoData.append(",t9.FName_" + curLocale);
        getMoData.append(",t1.FBizDate,t1.FBaseStatus,");
        getMoData.append("t1.FQty-t1.FTotalSplitQty,t1.FFinishedQty,t1.FToStroreQty,t10.FQtyPrecision,");
        getMoData.append("round(isnull(t1.FFinishedQty/nullif(t1.FQty-t1.FTotalSplitQty,0),0)*100,2),");
        getMoData.append("round(isnull(t1.ftoStroreQty/nullif(t1.FQty-t1.FTotalSplitQty,0),0)*100,2)");
        getMoData.append(",t1.FLot");
        getMoData.append(",t2.FModel");
        getMoData.append(",t1.FPlanBeginDate");
        getMoData.append(",t1.FPlanEndDate");
        getMoData.append(",t1.FRelatingOrderNum");
        getMoData.append(",t1.FLongNumber");
        getMoData.append(" FROM T_MM_ManufactureOrder as t1 ");
        getMoData.append(" left outer join T_BD_Material as t2 on t1.FMaterialID = t2.FID");
        getMoData.append(" left outer join T_BD_MeasureUnit as t3 on t1.FUnitID = t3.FID");
        getMoData.append(" left outer join T_BD_MaterialPlan as t4 ");
        getMoData.append(" on t1.FStorageOrgUnitID = t4.FOrgUnit and t1.FMaterialID = t4.FMaterialID ");
        getMoData.append(" left outer join T_MM_Project as t5 on  t1.FProjectID = t5.FID ");
        getMoData.append(" left outer join T_MM_TrackNumber as t6 on t1.FTrackID = t6.FID ");
        getMoData.append(" left outer join T_ORG_Admin as t7 on t1.FAdminOrgUnitID = t7.FID ");
        getMoData.append(" left outer join T_BD_Person as t8 on t1.FDispatcherID = t8.FID");
        getMoData.append(" left outer join T_SCM_BizType as t9 on t1.FBizTypeID = T9.FID ");
        getMoData.append(" left outer join T_BD_MultiMeasureUnit as t10  ");
        getMoData.append(" on t1.FMaterialID = t10.FMaterialID and t1.FUnitID = t10.FMeasureUnitID ");
        StringBuffer whereStr = new StringBuffer();
        StringBuffer eachExcuteStr = new StringBuffer();
        if (ids.size() > 0) {
            int time;
            String[] idArray = ids.toArray(new String[0]);
            int begin = 0;
            int end = 0;
            int n = time = idArray.length % 500 == 0 ? idArray.length / 500 : idArray.length / 500 + 1;
            for (int i = 0; i < time; ++i) {
                begin = 500 * i;
                end = i + 1 < time ? 500 * (i + 1) : idArray.length;
                HashSet<String> idStr = new HashSet<String>(end - begin);
                for (int idBegin = begin; idBegin < end; ++idBegin) {
                    if (idArray[idBegin] == null) continue;
                    idStr.add(idArray[idBegin]);
                }
                eachExcuteStr.setLength(0);
                whereStr.setLength(0);
                whereStr.append(" WHERE t1.FID = ?");
                int size = idStr.size();
                for (int j = 1; j < size; ++j) {
                    whereStr.append(" or t1.FID = ?");
                }
                whereStr.append(" ");
                eachExcuteStr.append(getMoData).append(whereStr);
                DbUtil.execute((Context)ctx, (String)eachExcuteStr.toString(), (Object[])idStr.toArray(new String[0]));
            }
        }
    }

    protected String calMOLaborHour(Context ctx, Collection ids) throws BOSException {
        String tempTableName = this.createLaborHourTmpTable(ctx);
        StringBuffer calLaborHour = new StringBuffer();
        calLaborHour.append("INSERT INTO " + tempTableName);
        calLaborHour.append("(FMoID,FTotalLaborHour,FTimeUnit)");
        calLaborHour.append("(SELECT DISTINCT t3.FID,sum(t3.oprLaborHour),2");
        calLaborHour.append(" FROM ");
        calLaborHour.append("(SELECT t1.FID,");
        calLaborHour.append(" case when t2.FTimeUnit = 3");
        calLaborHour.append(" then round(decimal((t2.FPrepareTime+CEILING(isnull((t1.FQty-t1.FTotalSplitQty)/nullif(t2.FProcessBatch,0),1))*t2.FWorkTime)/60,21,8),4)");
        calLaborHour.append(" when t2.FTimeUnit = 4");
        calLaborHour.append(" then round(decimal((t2.FPrepareTime+CEILING(isnull((t1.FQty-t1.FTotalSplitQty)/nullif(t2.FProcessBatch,0),1))*t2.FWorkTime)/3600,21,8),4)");
        calLaborHour.append(" else round(t2.FPrepareTime+CEILING(isnull((t1.FQty-t1.FTotalSplitQty)/nullif(t2.FProcessBatch,0),1))*t2.FWorkTime,4)");
        calLaborHour.append(" end as oprLaborHour");
        calLaborHour.append(" FROM T_MM_ManufactureOrder as t1 ");
        calLaborHour.append(" LEFT OUTER JOIN T_MM_MFTOrderTechnics as t2 on t1.FID = t2.FParentID ");
        if (ids.size() > 0) {
            calLaborHour.append(" where t1.FID = ?");
            int size = ids.size();
            for (int i = 1; i < size; ++i) {
                calLaborHour.append(" or t1.FID = ?");
            }
            calLaborHour.append(") as t3 ");
            calLaborHour.append(" GROUP BY t3.FID )");
            DbUtil.execute((Context)ctx, (String)calLaborHour.toString(), (Object[])ids.toArray(new String[0]));
        }
        return tempTableName;
    }

    protected String calReportLaborHour(Context ctx, Collection ids) throws BOSException {
        String tempTableName = this.createLaborHourTmpTable(ctx);
        StringBuffer calReportHour = new StringBuffer();
        calReportHour.append("INSERT INTO " + tempTableName);
        calReportHour.append("(FMoID,FTotalLaborHour,FTimeUnit)");
        calReportHour.append("(SELECT DISTINCT t3.FMoID,isnull(sum(t3.reportLaborHour),0.0000),2");
        calReportHour.append(" FROM ");
        calReportHour.append("(SELECT t1.FDmesOrderID as FMoID,");
        calReportHour.append(" case when t2.FTimeUnit = 3");
        calReportHour.append(" then round(decimal((t2.FPrepareTime+t2.FProcessTime)/60,21,8),4)");
        calReportHour.append(" when t2.FTimeUnit = 4");
        calReportHour.append(" then round(decimal((t2.FPrepareTime+t2.FProcessTime)/3600,21,8),4)");
        calReportHour.append(" else t2.FPrepareTime+t2.FProcessTime");
        calReportHour.append(" end as reportLaborHour");
        calReportHour.append(" FROM T_MM_CompletionReport as t1 ");
        calReportHour.append(" LEFT OUTER JOIN T_MM_CompletionRAT as t2 on t1.FID = t2.FParentID ");
        if (ids.size() > 0) {
            calReportHour.append(" where t1.FDmesOrderID = ?");
            int size = ids.size();
            for (int i = 1; i < size; ++i) {
                calReportHour.append(" or t1.FDmesOrderID = ?");
            }
            calReportHour.append(") as t3 ");
            calReportHour.append(" GROUP BY t3.FMoID )");
            DbUtil.execute((Context)ctx, (String)calReportHour.toString(), (Object[])ids.toArray(new String[0]));
        }
        return tempTableName;
    }

    protected void calLaborFinishRate(Context ctx, String baseTable, String moLaborHourTable, String reportLaborHourTable) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE " + baseTable + " AS t1 ");
        updateSql.append("SET (FTotalLaborHour,FTotalReportHour,FLaborFinishRate) =");
        updateSql.append("(SELECT t2.FTotalLaborHour,isnull(t3.FTotalLaborHour,0.0000), ");
        updateSql.append("\tround(isnull(t3.FTotalLaborHour/nullif(t2.FTotalLaborHour,0),0)*100,2)");
        updateSql.append(" FROM " + moLaborHourTable + " as t2 ");
        updateSql.append(" LEFT OUTER JOIN " + reportLaborHourTable + " as t3 ");
        updateSql.append(" ON T2.FMoID = T3.FMoID ");
        updateSql.append(" WHERE t2.FMoID = t1.FID)");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    protected String getProScheduleTableSchema() {
        StringBuffer tableSchema = new StringBuffer();
        tableSchema.append("create table ProductionSchedule(");
        tableSchema.append("FID  varchar(44),");
        tableSchema.append("FNumber  nvarchar(80),");
        tableSchema.append("FTrackNumber nvarchar(80),");
        tableSchema.append("FProjectNumber nvarchar(80),");
        tableSchema.append("FStorageOrgUnitID nvarchar(80),");
        tableSchema.append("FBizDate datetime,");
        tableSchema.append("FAdminOrgUnitName nvarchar(80),");
        tableSchema.append("FDispatcherName nvarchar(80),");
        tableSchema.append("FBaseStatus int,");
        tableSchema.append("FMaterialNumber nvarchar(80),");
        tableSchema.append("FMaterialName nvarchar(80),");
        tableSchema.append("FUnitName nvarchar(80),");
        tableSchema.append("FQtyPrecision int,");
        tableSchema.append("FIsKeyPart nvarchar(80),");
        tableSchema.append("FQty numeric(21,8),");
        tableSchema.append("FFinishedQty numeric(21,8),");
        tableSchema.append("FToStoreQty numeric(21,8),");
        tableSchema.append("FTotalLaborHour numeric(21,8),");
        tableSchema.append("FTotalReportHour numeric(21,8),");
        tableSchema.append("FFinishRate numeric(21,8),");
        tableSchema.append("FInWareHsRate numeric(21,8),");
        tableSchema.append("FLaborFinishRate numeric(21,8),");
        tableSchema.append("FBizTypeName nvarchar(80),");
        tableSchema.append("FMaterialModel nvarchar(255),");
        tableSchema.append("FPlanBeginDate datetime,");
        tableSchema.append("FPlanEndDate datetime,");
        tableSchema.append("FSaleOrderNumber nvarchar(80),");
        tableSchema.append("FLot nvarchar(255),");
        tableSchema.append("FLongNumber nvarchar(400))");
        return tableSchema.toString();
    }

    protected String createLaborHourTmpTable(Context ctx) throws BOSException {
        StringBuffer tableSchema = new StringBuffer();
        tableSchema.append("CREATE TABLE MOLaborHour(");
        tableSchema.append("FMoID  varchar(44),");
        tableSchema.append("FTotalLaborHour numeric(21,8),");
        tableSchema.append("FTimeUnit int )");
        String tempTableName = null;
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(tableSchema.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }
}

