/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.app.AbstractRecBillBackFlushFacadeControllerBean;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeCollection;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeInfo;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.mm.sfc.ICompletionReport;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RecBillBackFlushFacadeControllerBean
extends AbstractRecBillBackFlushFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.RecBillBackFlushFacadeControllerBean");
    private static final String MATERIALREQ_BOSTYPE = "500AB75E";
    private static final String BACKFLUSH_BOTOPID = "2aFD3ydGQd+RMkYN1ZVWawRRIsQ=";

    @Override
    protected String _recBillBackFlushBySuit(Context ctx, String recBillID) throws BOSException, EASBizException {
        SelectorItemCollection orderSic = new SelectorItemCollection();
        orderSic.add(new SelectorItemInfo("id"));
        orderSic.add(new SelectorItemInfo("name"));
        orderSic.add(new SelectorItemInfo("number"));
        orderSic.add(new SelectorItemInfo("totalQty"));
        orderSic.add(new SelectorItemInfo("material.id"));
        orderSic.add(new SelectorItemInfo("material.name"));
        orderSic.add(new SelectorItemInfo("material.number"));
        orderSic.add(new SelectorItemInfo("entry.manuBillEntryID"));
        orderSic.add(new SelectorItemInfo("entry.manuBillID"));
        orderSic.add(new SelectorItemInfo("entry.qty"));
        orderSic.add(new SelectorItemInfo("entry.baseQty"));
        orderSic.add(new SelectorItemInfo("entry.material.id"));
        orderSic.add(new SelectorItemInfo("entry.costObject.*"));
        orderSic.add(new SelectorItemInfo("costCenterOrgUnit.*"));
        IManufactureRecBill recInterface = ManufactureRecBillFactory.getLocalInstance((Context)ctx);
        ManufactureRecBillInfo recInfo = (ManufactureRecBillInfo)recInterface.getValue((IObjectPK)new ObjectUuidPK(recBillID), orderSic);
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"recBillBackFlushBySuit", (BOSObjectType)recInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(recInfo.getId()), (String)recInfo.getNumber(), (String)"im_manufactRec_OrderMaterialReq");
        ManufactureRecBillEntryCollection entryColletion = recInfo.getEntry();
        HashSet<String> orderIdSet = new HashSet<String>();
        HashMap<String, BigDecimal> orderQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, CostObjectInfo> costObjects = new HashMap<String, CostObjectInfo>();
        for (int i = 0; i < entryColletion.size(); ++i) {
            ManufactureRecBillEntryInfo entryInfo = entryColletion.get(i);
            String key = entryInfo.getManuBillID() + entryInfo.getMaterial().getId().toString();
            orderIdSet.add(entryInfo.getManuBillID());
            costObjects.put(entryInfo.getManuBillID(), entryInfo.getCostObject());
            if (orderQtyMap.containsKey(key)) {
                orderQtyMap.put(key, entryInfo.getQty().add((BigDecimal)orderQtyMap.get(key)));
                continue;
            }
            orderQtyMap.put(key, entryInfo.getQty());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", orderIdSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("firstOperNo"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("sourceBillTypeId"));
        sic.add(new SelectorItemInfo("srcBillNum"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("stocks.material.id"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filterInfo);
        CoreBillBaseCollection moCol = new CoreBillBaseCollection();
        ManufactureOrderCollection manuorderCollection = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(viewInfo);
        for (int i = 0; i < manuorderCollection.size(); ++i) {
            ManufactureOrderInfo moInfoOld = manuorderCollection.get(i);
            ManufactureOrderInfo moInfo = (ManufactureOrderInfo)moInfoOld.clone();
            if (moInfo == null) continue;
            ManufactureOrderStockInfo stockInfo = null;
            ManufactureOrderStockCollection cloneCollection = new ManufactureOrderStockCollection();
            String key = moInfoOld.getId().toString() + moInfo.getMaterial().getId().toString();
            if (!orderQtyMap.containsKey(key)) continue;
            BigDecimal recQty = (BigDecimal)orderQtyMap.get(key);
            Iterator stockIter = moInfo.getStocks().iterator();
            while (stockIter.hasNext()) {
                stockInfo = (ManufactureOrderStockInfo)stockIter.next();
                if (stockInfo.getIssueMode() != MaterialIssueModeEnum.PRODUCEISSMODE && stockInfo.getProvideType() != MaterialProvideTypeEnum.CURRENTORGPROVIDE && stockInfo.getProvideType() != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) continue;
                SCMEntryDataVO dataVO = RecBillBackFlushFacadeControllerBean.getMaterialMmu(ctx, stockInfo);
                int prec = RecBillBackFlushFacadeControllerBean.getPrec(dataVO, stockInfo.getMaterial(), stockInfo.getUnit());
                BigDecimal qty = stockInfo.getPlannedQty().multiply(recQty).divide(moInfo.getQty(), prec, 0).setScale(prec, 0);
                BigDecimal baseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)stockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)stockInfo.getUnit(), (MeasureUnitInfo)stockInfo.getBaseUnit(), (BigDecimal)qty);
                BigDecimal leaveIssueQty = stockInfo.getPlannedQty().subtract(stockInfo.getActIssueQty());
                BigDecimal baseleaveIssueQty = stockInfo.getPlannedBaseQty().subtract(stockInfo.getActIssueBaseQty());
                if (leaveIssueQty.compareTo(qty) < 0) {
                    qty = leaveIssueQty;
                    baseQty = baseleaveIssueQty;
                }
                if (qty.compareTo(new BigDecimal(0)) <= 0) continue;
                stockInfo.setUnIssueQty(qty);
                stockInfo.setUnIssueBaseQty(baseQty);
                cloneCollection.add(stockInfo);
            }
            moInfo.getStocks().clear();
            moInfo.getStocks().addCollection(cloneCollection);
            moCol.add((CoreBillBaseInfo)moInfo);
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = iBTPManager.transformForBotp(moCol, MATERIALREQ_BOSTYPE, (IObjectPK)new ObjectStringPK(BACKFLUSH_BOTOPID));
        IObjectCollection destBillCols = btpResult.getBills();
        MaterialReqBillInfo materialReqBillInfo = null;
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            materialReqBillInfo = (MaterialReqBillInfo)destBillCols.getObject(i);
            BOTRelationInfo botInfo = new BOTRelationInfo();
            botInfo.setSrcObjectID(recInfo.getId().toString());
            botInfo.setSrcEntityID(recInfo.getBOSType().toString());
            botInfo.setDestObjectID(materialReqBillInfo.getId().toString());
            botInfo.setDestEntityID(materialReqBillInfo.getBOSType().toString());
            botInfo.setOperatorID("unknown");
            botInfo.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(botInfo);
            CostCenterOrgUnitInfo costOrgInfo = recInfo.getCostCenterOrgUnit();
            materialReqBillInfo.setCostCenterOrgUnit(costOrgInfo);
            for (MaterialReqBillEntryInfo entryInfo : materialReqBillInfo.getEntry()) {
                entryInfo.setCostObject((CostObjectInfo)costObjects.get(entryInfo.getSourceBillId()));
            }
        }
        String materialPK = materialReqBillInfo.getId().toString();
        SelectorItemCollection materialReqBillSic = new SelectorItemCollection();
        materialReqBillSic.add(new SelectorItemInfo("id"));
        materialReqBillSic.add(new SelectorItemInfo("costCenterOrgUnit.*"));
        materialReqBillSic.add(new SelectorItemInfo("entry.costObject.*"));
        MaterialReqBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)materialReqBillInfo, materialReqBillSic);
        this.deleteBotpRelation(materialPK, ctx);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return materialPK;
    }

    private void deleteBotpRelation(String materialPK, Context ctx) throws EASBizException, BOSException {
        StringBuffer botpsql = new StringBuffer();
        botpsql.append("delete from T_BOT_RelationEntry where FDestObjectID in(");
        botpsql.append(" select t.fid from T_IM_MaterialReqBill t where t.fid = '" + materialPK + "')");
        DbUtil.execute((Context)ctx, (String)botpsql.toString());
    }

    private static SCMEntryDataVO getMaterialMmu(Context ctx, ManufactureOrderStockInfo stockinfo) throws EASBizException, BOSException {
        ArrayList<MaterialInfo> materialLst = new ArrayList<MaterialInfo>();
        ArrayList<MeasureUnitInfo> unitLst = new ArrayList<MeasureUnitInfo>();
        ArrayList<MeasureUnitInfo> baseunitLst = new ArrayList<MeasureUnitInfo>();
        materialLst.add(stockinfo.getMaterial());
        unitLst.add(stockinfo.getUnit());
        baseunitLst.add(stockinfo.getBaseUnit());
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materialLst.toArray(new MaterialInfo[materialLst.size()]));
        vo.setBaseMeasureUnitInfos(baseunitLst.toArray(new MeasureUnitInfo[baseunitLst.size()]));
        vo.setMeasureUnitInfos(unitLst.toArray(new MeasureUnitInfo[unitLst.size()]));
        return SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(vo);
    }

    private static int getPrec(SCMEntryDataVO vo, MaterialInfo material, MeasureUnitInfo unitInfo) {
        int prec = 4;
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (vo != null && vo.getMmuPrecisions() != null && vo.getMmuPrecisions().get(key) != null) {
                prec = (Integer)vo.getMmuPrecisions().get(key);
            }
        }
        return prec;
    }

    protected String _completionBackFlushBySuit(Context ctx, String completionID) throws BOSException, EASBizException {
        SelectorItemCollection orderSic = new SelectorItemCollection();
        orderSic.add(new SelectorItemInfo("id"));
        orderSic.add(new SelectorItemInfo("number"));
        orderSic.add(new SelectorItemInfo("opNo"));
        orderSic.add(new SelectorItemInfo("dmesOrder.id"));
        orderSic.add(new SelectorItemInfo("AmountTime.reportAmount"));
        ICompletionReport completionInterface = CompletionReportFactory.getLocalInstance((Context)ctx);
        CompletionReportInfo completionInfo = (CompletionReportInfo)completionInterface.getValue((IObjectPK)new ObjectUuidPK(completionID), orderSic);
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"completionBySuit", (BOSObjectType)completionInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(completionInfo.getId()), (String)completionInfo.getNumber(), (String)"mm_report_pickBySuit");
        CompletionReportAmountTimeCollection amountCollection = completionInfo.getAmountTime();
        BigDecimal sumQty = new BigDecimal("0.00");
        for (int i = 0; i < amountCollection.size(); ++i) {
            CompletionReportAmountTimeInfo entryInfo = amountCollection.get(i);
            sumQty = entryInfo.getReportAmount().add(sumQty);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)completionInfo.getDmesOrder().getId().toString(), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("firstOperNo"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("sourceBillTypeId"));
        sic.add(new SelectorItemInfo("srcBillNum"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("stocks.material.id"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filterInfo);
        CoreBillBaseCollection moCol = new CoreBillBaseCollection();
        ManufactureOrderCollection manuorderCollection = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(viewInfo);
        for (int i = 0; i < manuorderCollection.size(); ++i) {
            ManufactureOrderInfo moInfoOld = manuorderCollection.get(i);
            ManufactureOrderInfo moInfo = (ManufactureOrderInfo)moInfoOld.clone();
            if (moInfo == null) continue;
            ManufactureOrderStockInfo stockInfo = null;
            ManufactureOrderStockCollection cloneCollection = new ManufactureOrderStockCollection();
            Iterator stockIter = moInfo.getStocks().iterator();
            while (stockIter.hasNext()) {
                stockInfo = (ManufactureOrderStockInfo)stockIter.next();
                if (stockInfo.getIssueMode() != MaterialIssueModeEnum.PRODUCEISSMODE && stockInfo.getProvideType() != MaterialProvideTypeEnum.CURRENTORGPROVIDE && stockInfo.getProvideType() != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE || stockInfo.getOperationNo() > completionInfo.getOpNo()) continue;
                SCMEntryDataVO dataVO = RecBillBackFlushFacadeControllerBean.getMaterialMmu(ctx, stockInfo);
                int prec = RecBillBackFlushFacadeControllerBean.getPrec(dataVO, stockInfo.getMaterial(), stockInfo.getUnit());
                BigDecimal qty = stockInfo.getPlannedQty().multiply(sumQty).divide(moInfo.getQty(), prec, 0).setScale(prec, 0);
                BigDecimal baseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)stockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)stockInfo.getUnit(), (MeasureUnitInfo)stockInfo.getBaseUnit(), (BigDecimal)qty);
                BigDecimal leaveIssueQty = stockInfo.getPlannedQty().subtract(stockInfo.getActIssueQty());
                BigDecimal baseleaveIssueQty = stockInfo.getPlannedBaseQty().subtract(stockInfo.getActIssueBaseQty());
                if (leaveIssueQty.compareTo(qty) < 0) {
                    qty = leaveIssueQty;
                    baseQty = baseleaveIssueQty;
                }
                if (qty.compareTo(new BigDecimal(0)) <= 0) continue;
                stockInfo.setUnIssueQty(qty);
                stockInfo.setUnIssueBaseQty(baseQty);
                cloneCollection.add(stockInfo);
            }
            moInfo.getStocks().clear();
            moInfo.getStocks().addCollection(cloneCollection);
            moCol.add((CoreBillBaseInfo)moInfo);
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = iBTPManager.transformForBotp(moCol, MATERIALREQ_BOSTYPE, (IObjectPK)new ObjectStringPK(BACKFLUSH_BOTOPID));
        IObjectCollection destBillCols = btpResult.getBills();
        MaterialReqBillInfo materialReqBillInfo = null;
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            materialReqBillInfo = (MaterialReqBillInfo)destBillCols.getObject(i);
            BOTRelationInfo botInfo = new BOTRelationInfo();
            botInfo.setSrcObjectID(completionInfo.getId().toString());
            botInfo.setSrcEntityID(completionInfo.getBOSType().toString());
            botInfo.setDestObjectID(materialReqBillInfo.getId().toString());
            botInfo.setDestEntityID(materialReqBillInfo.getBOSType().toString());
            botInfo.setOperatorID("unknown");
            botInfo.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(botInfo);
        }
        String materialPK = "";
        if (null != materialReqBillInfo) {
            materialPK = materialReqBillInfo.getId().toString();
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return materialPK;
    }
}

