/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.OrderStockTransferTypeEnum;
import com.kingdee.eas.mm.mo.STCalcParamInfo;
import com.kingdee.eas.mm.mo.STGroupEnum;
import com.kingdee.eas.mm.mo.STRuleEnum;
import com.kingdee.eas.mm.mo.STStockInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class STCalculation {
    public static final int PRECISION_MAX = 8;
    public static String botpid = "giiMPjm6QXyaWclGR1QETQRRIsQ=";
    private Map storagetQtyMap = new HashMap();
    private Map stockReserveMap = new HashMap();
    private Map stockSimulateMap = new HashMap();
    private Map invMap = new HashMap();
    private Map transferBatchMap = new HashMap();
    private Map transferQtyMap = new HashMap();
    private Map transferNoBatchQtyMap = new HashMap();
    private Map stIdDestEntryIdMap = new HashMap();
    private Map receiptQtyMap;
    private Context context;
    private StorageOrgUnitInfo storageOrgUnitInfo;
    private Map sTStockMap;
    private String storageUnitId;
    private final BigDecimal ZERO = SysConstant.BIGZERO;
    private static final String STOCK_COLLELCTION_KEY = "mnfStockCollection";
    private static final String STORAGEORGUNITINFO_KEY = "storageOrgUnitInfo";
    private static final String WITHOUT_WAREHOUSE_KEY = "withoutWarehouseList";
    private STRuleEnum sTRuleEnum;
    private STCalcParamInfo calcParam;
    private static final String IS_BUILD = "isBuild";
    private static final String ID_MAP_KEY = "idMap";
    private static final String STOCK_TRANSACTION_FACADE_TYPE = "66DC591C";
    private static final String TRANSFER_ORDER_BILL_TYPE = "5C2A1F0C";
    private static final String STOCK_TRANSFER_BILL_TYPE = "2239F30A";
    private static final String MANUFACTURE_ORDER_TYPE = "1D0D80DD";
    private static final String BOT_TYPE = "59302EC6";
    private static final String BOT_ENTRY_TYPE = "B99C354C";
    private static final String TRANSFER_ORDER_BILL_KEY = "transferOrderBillCollection";
    private static final String STOCK_TRANSFER_BILL_KEY = "stockTransferBillCollection";
    private static final String BOT_RELATION_KEY = "botRelationCollection";
    private static final String BOT_RELATION_ENTRY_KEY = "botRelationEntryCollection";
    private static final String BIZ_TYPE__321_ID = "d8e80652-011a-1000-e000-04c5c0a812202407435C";
    private static final String BIZ_TYPE__331_ID = "d8e80652-011b-1000-e000-04c5c0a812202407435C";
    private static final String BIZ_TYPE__310_ID = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
    private static final String STORE_TYPE__USUALLY = "181875d5-0105-1000-e000-0111c0a812fd97D461A6";
    private static final String STORESTATUSID_USABLE = "181875d5-0105-1000-e000-012ec0a812fd62A73FA5";
    private static final Format midDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String planVersionNumber = "901";

    public STCalculation() {
    }

    public STCalculation(STCalcParamInfo calcParam, STRuleEnum sTRuleEnum, Map sTSourceReQtyMap, String storageUnitId) {
        this.calcParam = calcParam;
        this.sTRuleEnum = sTRuleEnum;
        this.receiptQtyMap = sTSourceReQtyMap;
        this.storageUnitId = storageUnitId;
    }

    protected Map sTCalculate(Context ctx, ManufactureOrderCollection mnfOrderCollection, Map sTStockCalMap, Map sTSourceMap) throws BOSException, EASBizException {
        this.context = ctx;
        Map sTStockFilterMap = this.filterByParamInfo(sTStockCalMap);
        this.calcStorageQty(ctx, sTStockFilterMap);
        this.calcReserveMap(ctx, mnfOrderCollection, sTStockFilterMap);
        this.calcSimulateInvMap(sTStockFilterMap);
        return this.manageMaps(sTStockFilterMap, ctx);
    }

    protected Map prepareDestBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Map sTStockMap;
        this.context = ctx;
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)paramMap.get(STORAGEORGUNITINFO_KEY);
        TransferOrderBillCollection transferOrderBillCollection = new TransferOrderBillCollection();
        StockTransferBillCollection stockTransferBillCollection = new StockTransferBillCollection();
        BOTRelationCollection botRelationCollection = new BOTRelationCollection();
        BOTRelationEntryCollection botRelationEntryCollection = new BOTRelationEntryCollection();
        STGroupEnum groupEnum = (STGroupEnum)((Object)paramMap.get("STGroupEnum"));
        this.sTStockMap = sTStockMap = (Map)paramMap.get("sTStockMap");
        ManufactureOrderStockCollection mnfStockCollection = (ManufactureOrderStockCollection)((Object)sTStockMap.get(STOCK_COLLELCTION_KEY));
        this.removeZeroRecord(sTStockMap, mnfStockCollection);
        Map groupMap = this.group(mnfStockCollection, groupEnum);
        Map resultMap = this.assembleBillCollection(ctx, groupMap, groupEnum, transferOrderBillCollection, stockTransferBillCollection, botRelationCollection, botRelationEntryCollection);
        resultMap.put(TRANSFER_ORDER_BILL_KEY, transferOrderBillCollection);
        resultMap.put(STOCK_TRANSFER_BILL_KEY, stockTransferBillCollection);
        resultMap.put(BOT_RELATION_KEY, botRelationCollection);
        resultMap.put(BOT_RELATION_ENTRY_KEY, botRelationEntryCollection);
        resultMap.put(IS_BUILD, new Boolean(false));
        return resultMap;
    }

    private void removeZeroRecord(Map sTStockMap, ManufactureOrderStockCollection mnfStockCollection) {
        String isRemove = (String)sTStockMap.get("isRemoveZero");
        Map idMap = (Map)sTStockMap.get(ID_MAP_KEY);
        if ("1".equals(isRemove)) {
            for (int i = mnfStockCollection.size() - 1; i >= 0; --i) {
                ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(i);
                STStockInfo sTStockInfo = (STStockInfo)sTStockMap.get((String)idMap.get(mnfStockInfo.getId().toString()));
                if (sTStockInfo.getReceiptQty().signum() > 0) continue;
                mnfStockCollection.removeObject((IObjectValue)mnfStockInfo);
            }
        }
    }

    protected void generateDestBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        int i;
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)paramMap.get(STORAGEORGUNITINFO_KEY);
        String transferOrderPermission = "transferorder_new";
        String stockTransferPermission = "stocktransfer_new";
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK storagePk = new ObjectUuidPK(this.storageOrgUnitInfo.getId());
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        TransferOrderBillCollection toCollection = (TransferOrderBillCollection)paramMap.get(TRANSFER_ORDER_BILL_KEY);
        StockTransferBillCollection stCollection = (StockTransferBillCollection)paramMap.get(STOCK_TRANSFER_BILL_KEY);
        BOTRelationCollection botCol = (BOTRelationCollection)paramMap.get(BOT_RELATION_KEY);
        BOTRelationEntryCollection botEntryCol = (BOTRelationEntryCollection)paramMap.get(BOT_RELATION_ENTRY_KEY);
        ITransferOrderBill transferOrderBill = TransferOrderBillFactory.getLocalInstance((Context)ctx);
        IStockTransferBill stockTransferBill = StockTransferBillFactory.getLocalInstance((Context)ctx);
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        if (toCollection != null && toCollection.size() > 0) {
            ipermission.checkFunctionPermission(userPK, (IObjectPK)storagePk, transferOrderPermission);
            for (i = 0; i < toCollection.size(); ++i) {
                TransferOrderBillInfo toInfo = toCollection.get(i);
                this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(toInfo.getId()), (IObjectValue)toInfo, this.getTransferOrderBOSType());
                transferOrderBill.save((CoreBaseInfo)toInfo);
            }
        }
        if (stCollection != null && stCollection.size() > 0) {
            ipermission.checkFunctionPermission(userPK, (IObjectPK)storagePk, stockTransferPermission);
            for (i = 0; i < stCollection.size(); ++i) {
                StockTransferBillInfo stInfo = stCollection.get(i);
                this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(stInfo.getId()), (IObjectValue)stInfo, this.getStockTransferBOSType());
                stockTransferBill.save((CoreBaseInfo)stInfo);
            }
        }
        if (botCol != null && botCol.size() > 0) {
            for (i = 0; i < botCol.size(); ++i) {
                BOTRelationInfo boInfo = botCol.get(i);
                botRelation.addnew(boInfo);
            }
        }
        if (botEntryCol != null && botEntryCol.size() > 0) {
            Connection conn = null;
            PreparedStatement batchStatement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                String batchStatementSql = "insert into t_bot_relationentry(FID,FSRCOBJECTID,FDESTOBJECTID,FSRCENTRYID,FDESTENTRYID,FSRCENTRYPROPNAME,FDESTENTRYPROPNAME,FSRCPROPERTYNAME,FDESTPROPERTYNAME,FVALUE,FKEYID) values (?,?,?,?,?,?,?,?,?,?,?)";
                batchStatement = conn.prepareStatement(batchStatementSql);
                for (int i2 = 0; i2 < botEntryCol.size(); ++i2) {
                    BOTRelationEntryInfo boInfo = botEntryCol.get(i2);
                    batchStatement.setString(1, boInfo.getId().toString());
                    batchStatement.setString(2, boInfo.getSrcObjectID());
                    batchStatement.setString(3, boInfo.getDestObjectID());
                    batchStatement.setString(4, boInfo.getSrcEntryID());
                    batchStatement.setString(5, boInfo.getDestEntryID());
                    batchStatement.setString(6, boInfo.getSrcEntryPropName());
                    batchStatement.setString(7, boInfo.getDestEntryPropName());
                    batchStatement.setString(8, boInfo.getSrcPropertyName());
                    batchStatement.setString(9, boInfo.getDestPropertyName());
                    batchStatement.setString(10, boInfo.getValue());
                    batchStatement.setString(11, boInfo.getRelation() != null ? boInfo.getRelation().getId().toString() : botCol.get(0).getId().toString());
                    batchStatement.addBatch();
                }
                batchStatement.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException(e.getMessage());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
    }

    protected void deleteDestBill(Context ctx, Map billMap) throws BOSException, EASBizException {
        IObjectPK[] idArray;
        TransferOrderBillCollection toCollection = (TransferOrderBillCollection)billMap.get(TRANSFER_ORDER_BILL_KEY);
        StockTransferBillCollection stCollection = (StockTransferBillCollection)billMap.get(STOCK_TRANSFER_BILL_KEY);
        BOTRelationCollection botCol = (BOTRelationCollection)billMap.get(BOT_RELATION_KEY);
        BOTRelationEntryCollection botEntryCol = (BOTRelationEntryCollection)billMap.get(BOT_RELATION_ENTRY_KEY);
        ITransferOrderBill transferOrderBill = TransferOrderBillFactory.getLocalInstance((Context)ctx);
        IStockTransferBill stockTransferBill = StockTransferBillFactory.getLocalInstance((Context)ctx);
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        if (botEntryCol != null && botEntryCol.size() > 0) {
            StringBuffer idStrs = new StringBuffer();
            for (int i = 0; i < botEntryCol.size(); ++i) {
                BOTRelationEntryInfo boEntryInfo = botEntryCol.get(i);
                idStrs.append("'" + boEntryInfo.getId().toString() + "', ");
            }
            String idStr = idStrs.toString().trim().substring(0, idStrs.toString().trim().length() - 1);
            String delSQL = "delete from  t_bot_relationentry where FID in (" + idStr + ")";
            DbUtil.execute((Context)ctx, (String)delSQL);
        }
        if (botCol != null && botCol.size() > 0) {
            for (int i = 0; i < botCol.size(); ++i) {
                BOTRelationInfo boInfo = botCol.get(i);
                botRelation.delete((IObjectPK)new ObjectUuidPK(boInfo.getId()));
            }
        }
        if (toCollection != null && toCollection.size() > 0) {
            idArray = new IObjectPK[toCollection.size()];
            for (int i = 0; i < toCollection.size(); ++i) {
                TransferOrderBillInfo toInfo = toCollection.get(i);
                idArray[i] = new ObjectUuidPK(toInfo.getId());
                transferOrderBill.delete(idArray[i]);
            }
        }
        if (stCollection != null && stCollection.size() > 0) {
            idArray = new IObjectPK[stCollection.size()];
            for (int i = 0; i < stCollection.size(); ++i) {
                StockTransferBillInfo stInfo = stCollection.get(i);
                idArray[i] = new ObjectUuidPK(stInfo.getId());
                stockTransferBill.delete(idArray[i]);
            }
        }
    }

    private Map manageMaps(Map sTStockFilterMap, Context ctx) throws EASBizException, BOSException {
        Map groupedCollectionMap;
        Set stockGroupSet;
        Map multiMeasureUnitMap = this.getMeasureUnitMapByStockColl(sTStockFilterMap);
        TreeMap<String, Object> resutlMap = new TreeMap<String, Object>();
        ManufactureOrderStockCollection mnfStockCollection = new ManufactureOrderStockCollection();
        int sumWayValue = this.getSumWayValue();
        if (sumWayValue == 10) {
            if (sTStockFilterMap != null && sTStockFilterMap.size() > 0) {
                Set keyFilterSet = sTStockFilterMap.keySet();
                for (String keyFilterStr : keyFilterSet) {
                    STStockInfo stFilterInfo = (STStockInfo)sTStockFilterMap.get(keyFilterStr);
                    ManufactureOrderStockInfo mnfStockInfo = stFilterInfo.getStockEntryInfo();
                    mnfStockCollection.add(mnfStockInfo);
                    this.refSTInfo(ctx, resutlMap, multiMeasureUnitMap, stFilterInfo);
                }
            }
        } else if (sumWayValue == 20 && (stockGroupSet = (groupedCollectionMap = this.groupStockByMeterial(sTStockFilterMap)).keySet()) != null && stockGroupSet.size() > 0) {
            for (String key : stockGroupSet) {
                List stockList = (List)groupedCollectionMap.get(key);
                if (stockList == null || stockList.size() <= 0) continue;
                if (stockList.size() > 1) {
                    HashMap billRelationMap = new HashMap();
                    BigDecimal bsInvQty = this.ZERO;
                    BigDecimal bsStockReserveQty = this.ZERO;
                    BigDecimal bsReqQty = this.ZERO;
                    BigDecimal bsReceiptQty = this.ZERO;
                    BigDecimal bsTotalReceiptQty = this.ZERO;
                    BigDecimal bsTransferBatch = this.ZERO;
                    Timestamp demandTime = null;
                    for (int i = 0; i < stockList.size(); ++i) {
                        Set<String> entrySet;
                        STStockInfo stGroupInfo = (STStockInfo)stockList.get(i);
                        ManufactureOrderStockInfo mnfStockInfo = stGroupInfo.getStockEntryInfo();
                        if (billRelationMap.get(mnfStockInfo.getParent().getId().toString()) != null) {
                            entrySet = (Set)billRelationMap.get(mnfStockInfo.getParent().getId().toString());
                            entrySet.add(mnfStockInfo.getId().toString());
                        } else {
                            entrySet = new HashSet<String>();
                            entrySet.add(mnfStockInfo.getId().toString());
                            billRelationMap.put(mnfStockInfo.getParent().getId().toString(), entrySet);
                        }
                        if (i == 0) {
                            bsInvQty = (BigDecimal)this.storagetQtyMap.get(mnfStockInfo.getId().toString());
                            bsStockReserveQty = this.stockReserveMap.get(mnfStockInfo.getId().toString()) != null ? (BigDecimal)this.stockReserveMap.get(mnfStockInfo.getId().toString()) : this.ZERO;
                        }
                        bsReqQty = bsReqQty.add(mnfStockInfo.getPlannedBaseQty().subtract(mnfStockInfo.getActIssueBaseQty()).add(mnfStockInfo.getRejectedBaseQty()));
                        bsReceiptQty = bsReceiptQty.add(this.transferQtyMap.get(mnfStockInfo.getId().toString()) != null ? (BigDecimal)this.transferQtyMap.get(mnfStockInfo.getId().toString()) : this.ZERO);
                        bsTotalReceiptQty = bsTotalReceiptQty.add(mnfStockInfo.getTotalReceiptBaseQty());
                        if (i == 0) {
                            BigDecimal bigDecimal = bsTransferBatch = this.transferBatchMap.get(mnfStockInfo.getId().toString()) != null ? (BigDecimal)this.transferBatchMap.get(mnfStockInfo.getId().toString()) : this.ZERO;
                        }
                        if (mnfStockInfo.getDemandTime() == null) continue;
                        if (i == 0) {
                            demandTime = mnfStockInfo.getDemandTime();
                            continue;
                        }
                        if (null == demandTime || ((Date)demandTime).compareTo(mnfStockInfo.getDemandTime()) <= 0) continue;
                        demandTime = mnfStockInfo.getDemandTime();
                    }
                    ManufactureOrderStockInfo mnfStockInfo = new ManufactureOrderStockInfo();
                    STStockInfo sTStockInfo = (STStockInfo)stockList.get(0);
                    mnfStockInfo.setMaterial(sTStockInfo.getStockEntryInfo().getMaterial());
                    BOSUuid id = BOSUuid.create((String)STOCK_TRANSACTION_FACADE_TYPE);
                    sTStockInfo.setId(id.toString());
                    mnfStockInfo.setId(id);
                    mnfStockInfo.setUnit(this.getMaterialUnit(mnfStockInfo));
                    mnfStockInfo.setDemandTime(demandTime);
                    mnfStockInfo.setWarehouse(sTStockInfo.getStockEntryInfo().getWarehouse());
                    mnfStockInfo.setReceiptStroageOrgUnit(sTStockInfo.getStockEntryInfo().getReceiptStroageOrgUnit());
                    mnfStockInfo.setReceiptStock(sTStockInfo.getStockEntryInfo().getReceiptStock());
                    mnfStockInfo.setTransferType(sTStockInfo.getStockEntryInfo().getTransferType());
                    sTStockInfo.setMaterialId(mnfStockInfo.getMaterial().getId().toString());
                    sTStockInfo.setBsUnitId(mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit().getId().toString() : mnfStockInfo.getMaterial().getBaseUnit().getId().toString());
                    sTStockInfo.setBsInvQty(bsInvQty);
                    sTStockInfo.setInvQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), sTStockInfo.getBsInvQty()));
                    sTStockInfo.setBsStockReserveQty(bsStockReserveQty);
                    sTStockInfo.setStockReserveQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), sTStockInfo.getBsStockReserveQty()));
                    sTStockInfo.setBsReqQty(bsReqQty);
                    sTStockInfo.setReqQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), sTStockInfo.getBsReqQty()));
                    sTStockInfo.setBsTransferBatch(bsTransferBatch);
                    sTStockInfo.setTransferBatch(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), sTStockInfo.getBsTransferBatch()));
                    BigDecimal tranferBatchBaseQty = this.getTranferBatchQty(bsReceiptQty, bsTransferBatch);
                    sTStockInfo.setBsReceiptQty(tranferBatchBaseQty);
                    sTStockInfo.setReceiptQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), sTStockInfo.getBsReceiptQty()));
                    sTStockInfo.setBsTotalReceiptQty(bsTotalReceiptQty);
                    sTStockInfo.setTotalReceiptQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), sTStockInfo.getBsTotalReceiptQty()));
                    sTStockInfo.setBillRelationMap(billRelationMap);
                    resutlMap.put(sTStockInfo.getId(), sTStockInfo);
                    this.mapId(resutlMap, mnfStockInfo.getId().toString(), sTStockInfo.getId().toString());
                    mnfStockCollection.add(mnfStockInfo);
                    continue;
                }
                STStockInfo sTStockInfo = (STStockInfo)stockList.get(0);
                ManufactureOrderStockInfo mnfStockInfo = sTStockInfo.getStockEntryInfo();
                this.refSTInfo(ctx, resutlMap, multiMeasureUnitMap, sTStockInfo);
                mnfStockCollection.add(mnfStockInfo);
            }
        }
        resutlMap.put(STOCK_COLLELCTION_KEY, (Object)mnfStockCollection);
        return resutlMap;
    }

    private Map getMeasureUnitMapByStockColl(Map sTStockFilterMap) throws BOSException {
        if (sTStockFilterMap == null || sTStockFilterMap.size() <= 0) {
            return null;
        }
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> measureUnitSet = new HashSet<String>();
        HashMap<String, MultiMeasureUnitInfo> multiMeasureUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
        Set keyFilterSet = sTStockFilterMap.keySet();
        for (String keyFilterStr : keyFilterSet) {
            STStockInfo stFilterInfo = (STStockInfo)sTStockFilterMap.get(keyFilterStr);
            ManufactureOrderStockInfo mnfStockInfo = stFilterInfo.getStockEntryInfo();
            materialSet.add(mnfStockInfo.getMaterial().getId().toString());
            measureUnitSet.add(mnfStockInfo.getUnit().getId().toString());
            measureUnitSet.add(mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit().getId().toString() : mnfStockInfo.getMaterial().getBaseUnit().getId().toString());
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.context);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", measureUnitSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        MultiMeasureUnitCollection multiMeasureUntiColl = multiUnit.getMultiMeasureUnitCollection(view);
        if (multiMeasureUntiColl != null && multiMeasureUntiColl.size() > 0) {
            for (int i = 0; i < multiMeasureUntiColl.size(); ++i) {
                MultiMeasureUnitInfo multiMeasureUnitInfo = multiMeasureUntiColl.get(i);
                String materialId = multiMeasureUnitInfo.getMaterial().getId().toString();
                String measureUnitId = multiMeasureUnitInfo.getMeasureUnit().getId().toString();
                multiMeasureUnitMap.put(materialId + measureUnitId, multiMeasureUnitInfo);
            }
        }
        return multiMeasureUnitMap;
    }

    private BigDecimal getExchangePrecisionQty(Map multiMeasureUnitMap, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        if (unitInfo == null || otherUnitInfo == null) {
            return null;
        }
        String unitId = unitInfo.getId().toString();
        String otherUnitId = otherUnitInfo.getId().toString();
        MultiMeasureUnitInfo multiUnifInfo = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(materialID + unitId);
        MultiMeasureUnitInfo othermultiUnifInfo = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(materialID + otherUnitId);
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    private BigDecimal getTranferBatchQty(BigDecimal bsReceiptQty, BigDecimal transferBatchBaseQty) {
        if (!this.isTransferBatch() || transferBatchBaseQty.signum() <= 0) {
            return bsReceiptQty;
        }
        BigDecimal subtractDivdeTrabatch = bsReceiptQty.divide(transferBatchBaseQty, 0, 0);
        return subtractDivdeTrabatch.multiply(transferBatchBaseQty);
    }

    private void mapId(Map resutlMap, String mnfStockInfoId, String stInfoId) {
        if (resutlMap.get(ID_MAP_KEY) == null) {
            resutlMap.put(ID_MAP_KEY, new HashMap());
            Map idMap = (Map)resutlMap.get(ID_MAP_KEY);
            idMap.put(mnfStockInfoId, stInfoId);
            idMap.put(stInfoId, mnfStockInfoId);
        } else {
            Map idMap = (Map)resutlMap.get(ID_MAP_KEY);
            idMap.put(mnfStockInfoId, stInfoId);
            idMap.put(stInfoId, mnfStockInfoId);
        }
    }

    private void refSTInfo(Context ctx, Map resutlMap, Map multiMeasureUnitMap, STStockInfo stFilterInfo) throws EASBizException, BOSException {
        ManufactureOrderStockInfo mnfStockInfo = stFilterInfo.getStockEntryInfo();
        String id = BOSUuid.create((String)STOCK_TRANSACTION_FACADE_TYPE).toString();
        stFilterInfo.setId(id);
        stFilterInfo.setOrderId(mnfStockInfo.getParent().getId().toString());
        stFilterInfo.setStockEntryId(mnfStockInfo.getId().toString());
        stFilterInfo.setMaterialId(mnfStockInfo.getMaterial().getId().toString());
        stFilterInfo.setUnitId(mnfStockInfo.getUnit().getId().toString());
        stFilterInfo.setBsUnitId(mnfStockInfo.getBaseUnit().getId().toString());
        stFilterInfo.setBsInvQty((BigDecimal)this.storagetQtyMap.get(mnfStockInfo.getId().toString()));
        stFilterInfo.setInvQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), stFilterInfo.getBsInvQty()));
        stFilterInfo.setBsStockReserveQty((BigDecimal)this.stockReserveMap.get(mnfStockInfo.getId().toString()));
        stFilterInfo.setStockReserveQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), stFilterInfo.getBsStockReserveQty()));
        BigDecimal bsReqQty = mnfStockInfo.getPlannedBaseQty().subtract(mnfStockInfo.getActIssueBaseQty()).add(mnfStockInfo.getRejectedBaseQty());
        stFilterInfo.setBsReqQty(bsReqQty.compareTo(this.ZERO) > 0 ? bsReqQty : this.ZERO);
        stFilterInfo.setReqQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), stFilterInfo.getBsReqQty()));
        BigDecimal bsReceiptQty = this.transferQtyMap.get(mnfStockInfo.getId().toString()) != null ? (BigDecimal)this.transferQtyMap.get(mnfStockInfo.getId().toString()) : this.ZERO;
        BigDecimal transferBatchBaseQty = (BigDecimal)this.transferBatchMap.get(mnfStockInfo.getId().toString());
        stFilterInfo.setBsTransferBatch(transferBatchBaseQty);
        stFilterInfo.setTransferBatch(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), stFilterInfo.getBsTransferBatch()));
        stFilterInfo.setBsReceiptQty(this.getTranferBatchQty(bsReceiptQty, transferBatchBaseQty));
        stFilterInfo.setReceiptQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), stFilterInfo.getBsReceiptQty()));
        stFilterInfo.setBsTotalReceiptQty(mnfStockInfo.getTotalReceiptBaseQty());
        stFilterInfo.setTotalReceiptQty(this.getExchangePrecisionQty(multiMeasureUnitMap, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getBaseUnit() != null ? mnfStockInfo.getBaseUnit() : mnfStockInfo.getMaterial().getBaseUnit(), mnfStockInfo.getUnit(), stFilterInfo.getBsTotalReceiptQty()));
        stFilterInfo.setWarehouseId(mnfStockInfo.getWarehouse() != null ? mnfStockInfo.getWarehouse().getId().toString() : "");
        stFilterInfo.setFromStorageOrgId(mnfStockInfo.getReceiptStroageOrgUnit() != null ? mnfStockInfo.getReceiptStroageOrgUnit().getId().toString() : "");
        stFilterInfo.setFromWarehsId(mnfStockInfo.getReceiptStock() != null ? mnfStockInfo.getReceiptStock().getId().toString() : "");
        stFilterInfo.setOperationNo(String.valueOf(mnfStockInfo.getOperationNo()));
        stFilterInfo.setOperationName(mnfStockInfo.getOperation() != null ? mnfStockInfo.getOperation().getName() : "");
        resutlMap.put(stFilterInfo.getId(), stFilterInfo);
        this.mapId(resutlMap, mnfStockInfo.getId().toString(), stFilterInfo.getId().toString());
        HashMap billRelationMap = new HashMap();
        HashSet<String> entrySet = new HashSet<String>();
        entrySet.add(mnfStockInfo.getId().toString());
        billRelationMap.put(mnfStockInfo.getParent().getId().toString(), entrySet);
        stFilterInfo.setBillRelationMap(billRelationMap);
    }

    private void calcStorageQty(Context ctx, Map sTStockFilterMap) throws BOSException, EASBizException {
        if (sTStockFilterMap != null && sTStockFilterMap.size() > 0) {
            Set keyFilterSet = sTStockFilterMap.keySet();
            for (String keyFilterStr : keyFilterSet) {
                STStockInfo stFilterInfo = (STStockInfo)sTStockFilterMap.get(keyFilterStr);
                this.setStoragQty(ctx, stFilterInfo);
                this.setTransferBatch(stFilterInfo);
            }
        }
    }

    private void setStoragQty(Context ctx, STStockInfo stFilterInfo) throws BOSException, EASBizException {
        ManufactureOrderStockInfo mnfStockInfo = stFilterInfo.getStockEntryInfo();
        IInventory inventory = InventoryFactory.getLocalInstance((Context)this.context);
        if (mnfStockInfo.getWarehouse() == null) {
            this.storagetQtyMap.put(mnfStockInfo.getId().toString(), this.ZERO);
            return;
        }
        ResultSet stResult = null;
        String orgId = mnfStockInfo.getParent().getStorageOrgUnit().getId() != null ? mnfStockInfo.getParent().getStorageOrgUnit().getId().toString() : "";
        try {
            stResult = StoreCommonUtil.getPlanVersionSetStoretypeAndStorestate((Context)ctx, (String)planVersionNumber, (String)orgId);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        Object[] st = this.StoretypeAndStorestate(stResult);
        Set stoType = (Set)st[0];
        Set stoStatus = (Set)st[1];
        String materialId = mnfStockInfo.getMaterial().getId().toString();
        String warehouseId = mnfStockInfo.getWarehouse().getId().toString();
        String projectId = stFilterInfo.getProjectId() != null ? stFilterInfo.getProjectId().toString() : "";
        String trackNumberId = stFilterInfo.getTrackNumId() != null ? stFilterInfo.getTrackNumId().toString() : "";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("warehouse.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("storetype.id"));
        sic.add(new SelectorItemInfo("storestatus.id"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseId));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.storageUnitId));
        if (projectId != null && projectId.length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectId));
        }
        if (trackNumberId != null && trackNumberId.length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)trackNumberId));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storetype.id", (Object)stoType, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("storestatus.id", (Object)stoStatus, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        InventoryCollection inventoryCollection = inventory.getInventoryCollection(view);
        BigDecimal sumBaseBaseQty = this.ZERO;
        if (inventoryCollection != null) {
            for (int i = 0; i < inventoryCollection.size(); ++i) {
                InventoryInfo inventoryInfo = inventoryCollection.get(i);
                BigDecimal baseQty = inventoryInfo.getBaseQty();
                sumBaseBaseQty = sumBaseBaseQty.add(baseQty);
            }
            this.storagetQtyMap.put(mnfStockInfo.getId().toString(), sumBaseBaseQty);
            this.storagetQtyMap.put(materialId + warehouseId + projectId + trackNumberId, sumBaseBaseQty);
        }
    }

    private void setTransferBatch(STStockInfo stFilterInfo) throws BOSException, EASBizException {
        ManufactureOrderStockInfo mnfStockInfo = stFilterInfo.getStockEntryInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mnfStockInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.storageUnitId, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("productUnit.id"));
        selector.add(new SelectorItemInfo("productUnit.name"));
        selector.add(new SelectorItemInfo("productUnit.number"));
        selector.add(new SelectorItemInfo("transferBatch"));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        viewer.setSelector(selector);
        MaterialPlanCollection plans = MaterialPlanFactory.getLocalInstance((Context)this.context).getMaterialPlanCollection(viewer);
        if (plans != null && plans.size() > 0) {
            MeasureUnitInfo productUnit;
            MaterialPlanInfo planInfo = plans.get(0);
            BigDecimal transferBatchQty = planInfo.getTransferBatch();
            if (transferBatchQty == null) {
                transferBatchQty = this.ZERO;
            }
            if ((productUnit = planInfo.getProductUnit()) != null && productUnit.getId() != null) {
                BigDecimal transferBatchBaseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.context, (String)mnfStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)productUnit, (MeasureUnitInfo)mnfStockInfo.getMaterial().getBaseUnit(), (BigDecimal)transferBatchQty);
                this.transferBatchMap.put(mnfStockInfo.getId().toString(), transferBatchBaseQty);
            } else {
                this.transferBatchMap.put(mnfStockInfo.getId().toString(), this.ZERO);
            }
        }
    }

    private MeasureUnitInfo getMaterialUnit(ManufactureOrderStockInfo mnfStockInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mnfStockInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("productUnit.id"));
        selector.add(new SelectorItemInfo("productUnit.name"));
        selector.add(new SelectorItemInfo("productUnit.number"));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        viewer.setSelector(selector);
        MaterialPlanCollection plans = MaterialPlanFactory.getLocalInstance((Context)this.context).getMaterialPlanCollection(viewer);
        if (plans != null && plans.size() > 0) {
            MaterialPlanInfo planInfo = plans.get(0);
            return planInfo.getProductUnit();
        }
        return null;
    }

    private void calcReserveMap(Context ctx, ManufactureOrderCollection mnfOrderCollection, Map sTStockFilterMap) throws BOSException, EASBizException {
        String moIds = this.getStrIds(mnfOrderCollection);
        if (sTStockFilterMap != null && sTStockFilterMap.size() > 0) {
            Set keyFilterSet = sTStockFilterMap.keySet();
            for (String keyFilterStr : keyFilterSet) {
                STStockInfo stFilterInfo = (STStockInfo)sTStockFilterMap.get(keyFilterStr);
                ManufactureOrderStockInfo mfnStockInfo = stFilterInfo.getStockEntryInfo();
                if (mfnStockInfo.getWarehouse() == null) {
                    this.stockReserveMap.put(mfnStockInfo.getId().toString(), this.ZERO);
                    continue;
                }
                String materialId = mfnStockInfo.getMaterial().getId().toString();
                String warehouseId = mfnStockInfo.getWarehouse().getId().toString();
                String projectId = stFilterInfo.getProjectId() != null ? stFilterInfo.getProjectId().toString() : "";
                String trackNumberId = stFilterInfo.getTrackNumId() != null ? stFilterInfo.getTrackNumId().toString() : "";
                Timestamp demandTime = mfnStockInfo.getDemandTime();
                String formatTimestamp = midDateFormat.format(demandTime);
                demandTime = Timestamp.valueOf(formatTimestamp);
                BigDecimal moOccupyBaseQty = null;
                StringBuffer moOcuSqlBuffer = new StringBuffer();
                moOcuSqlBuffer.append("SELECT sum(case when k.FplannedQty-k.FactIssueQty+k.FrejectedQty<0 then 0 else k.FplannedQty-k.FactIssueQty+k.FrejectedQty end) as moOccupyQty ");
                moOcuSqlBuffer.append(", ");
                moOcuSqlBuffer.append("sum(case when k.FplannedBaseQty-k.FactIssuebaseQty+k.FrejectedbaseQty<0 then 0 else k.FplannedbaseQty-k.FactIssuebaseQty+k.FrejectedbaseQty end) as moOccupyBaseQty ");
                moOcuSqlBuffer.append(" FROM T_MM_MFTOrderStock k ");
                moOcuSqlBuffer.append("INNER JOIN T_MM_MANUFACTUREORDER o ON o.FID=K.FParentID ");
                moOcuSqlBuffer.append("inner join T_MM_ProductTransactionType tt on tt.FID=o.FTransactionTypeID ");
                moOcuSqlBuffer.append("WHERE ");
                moOcuSqlBuffer.append("O.FID NOT IN (" + moIds + ") ");
                moOcuSqlBuffer.append("and o.FBaseStatus in (4,5,8) ");
                moOcuSqlBuffer.append("and k.FmaterialId = '" + materialId + "' ");
                moOcuSqlBuffer.append("and k.FwarehouseId = '" + warehouseId + "' ");
                moOcuSqlBuffer.append("and o.FStorageOrgUnitId = '" + this.storageUnitId + "' ");
                if (projectId != null && projectId.length() > 0) {
                    moOcuSqlBuffer.append("and o.FProjectID = '" + projectId + "' ");
                }
                if (trackNumberId != null && trackNumberId.length() > 0) {
                    moOcuSqlBuffer.append("and o.FTrackID = '" + trackNumberId + "' ");
                }
                moOcuSqlBuffer.append("and k.fissuemode IN (11010,11020) ");
                moOcuSqlBuffer.append("and k.fprovidetype IN (10910,10920) ");
                moOcuSqlBuffer.append("and k.fdemandtime < to_date('" + demandTime.toString() + "')");
                try {
                    IRowSet moRs = DbUtil.executeQuery((Context)this.context, (String)moOcuSqlBuffer.toString());
                    while (moRs.next()) {
                        moOccupyBaseQty = moRs.getBigDecimal("moOccupyBaseQty") != null ? moRs.getBigDecimal("moOccupyBaseQty") : this.ZERO;
                    }
                    BigDecimal occupyQty = moOccupyBaseQty;
                    this.stockReserveMap.put(mfnStockInfo.getId().toString(), occupyQty);
                    this.stockReserveMap.put(materialId + warehouseId + projectId + trackNumberId, occupyQty);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void calcSimulateInvMap(Map sTStockFilterMap) throws EASBizException, BOSException {
        Map stockGroupMap = this.groupStockByMeterialWarehouse(sTStockFilterMap);
        List o = (List)stockGroupMap.remove(WITHOUT_WAREHOUSE_KEY);
        this.calcWithoutWarsehosueTransferQty(o);
        this.calcSimulateInvTransferQty(stockGroupMap);
    }

    private void calcWithoutWarsehosueTransferQty(List withoutWarehouseList) throws EASBizException, BOSException {
        if (withoutWarehouseList != null && withoutWarehouseList.size() > 0) {
            for (int i = 0; i < withoutWarehouseList.size(); ++i) {
                STStockInfo stStockInfo = (STStockInfo)withoutWarehouseList.get(i);
                this.calcTranferQty(stStockInfo);
            }
        }
    }

    private void calcSimulateInvTransferQty(Map stockGroupMap) throws EASBizException, BOSException {
        Set stockGroupSet = stockGroupMap.keySet();
        if (stockGroupSet != null && stockGroupSet.size() > 0) {
            Iterator it = stockGroupSet.iterator();
            while (it.hasNext()) {
                List stockList = (List)stockGroupMap.get(it.next());
                if (stockList == null || stockList.size() <= 0) continue;
                BigDecimal simulateBaseQty = null;
                BigDecimal wholeInvQty = null;
                for (int i = 0; i < stockList.size(); ++i) {
                    String trackNumberId;
                    STStockInfo stStockInfo = (STStockInfo)stockList.get(i);
                    ManufactureOrderStockInfo mnfStockInfo = stStockInfo.getStockEntryInfo();
                    String materialId = mnfStockInfo.getMaterial().getId().toString();
                    String warehouseId = mnfStockInfo.getWarehouse().getId().toString();
                    String projectId = stStockInfo.getProjectId() != null ? stStockInfo.getProjectId().toString() : "";
                    String string = trackNumberId = stStockInfo.getTrackNumId() != null ? stStockInfo.getTrackNumId().toString() : "";
                    if (i == 0) {
                        this.stockSimulateMap.put(mnfStockInfo.getId().toString(), this.ZERO);
                        this.stockSimulateMap.put(materialId + warehouseId + projectId + trackNumberId, this.ZERO);
                        BigDecimal storageQty = (BigDecimal)this.storagetQtyMap.get(materialId + warehouseId + projectId + trackNumberId);
                        BigDecimal reserveQty = (BigDecimal)this.stockReserveMap.get(materialId + warehouseId + projectId + trackNumberId);
                        BigDecimal invQty = storageQty.subtract(reserveQty);
                        this.invMap.put(materialId + warehouseId + projectId + trackNumberId, invQty);
                        this.calcTranferQty(stStockInfo);
                        BigDecimal[] qtyArray = this.calcNextSimuAndInv(stStockInfo);
                        simulateBaseQty = qtyArray[0];
                        wholeInvQty = qtyArray[1];
                        continue;
                    }
                    this.stockSimulateMap.put(mnfStockInfo.getId().toString(), simulateBaseQty);
                    this.stockSimulateMap.put(materialId + warehouseId + projectId + trackNumberId, simulateBaseQty);
                    this.invMap.put(materialId + warehouseId + projectId + trackNumberId, wholeInvQty);
                    this.calcTranferQty(stStockInfo);
                    BigDecimal[] SI = this.calcNextSimuAndInv(stStockInfo, simulateBaseQty, wholeInvQty);
                    simulateBaseQty = SI[0];
                    wholeInvQty = SI[1];
                }
            }
        }
    }

    private BigDecimal[] calcNextSimuAndInv(STStockInfo stStockInfo) {
        ManufactureOrderStockInfo mnfStockInfo = stStockInfo.getStockEntryInfo();
        BigDecimal[] qtyArray = new BigDecimal[2];
        BigDecimal simulateBaseQty = this.ZERO;
        BigDecimal wholeInvQty = this.ZERO;
        String materialId = mnfStockInfo.getMaterial().getId().toString();
        String warehouseId = mnfStockInfo.getWarehouse().getId().toString();
        String projectId = stStockInfo.getProjectId() != null ? stStockInfo.getProjectId().toString() : "";
        String trackNumberId = stStockInfo.getTrackNumId() != null ? stStockInfo.getTrackNumId().toString() : "";
        BigDecimal invQty = (BigDecimal)this.invMap.get(materialId + warehouseId + projectId + trackNumberId);
        BigDecimal transferQty = (BigDecimal)this.transferNoBatchQtyMap.get(mnfStockInfo.getId().toString());
        if (!this.isInvetory()) {
            qtyArray[0] = simulateBaseQty;
            qtyArray[1] = invQty;
            return qtyArray;
        }
        BigDecimal subtract = transferQty.subtract(invQty);
        if (subtract.compareTo(this.ZERO) > 0) {
            simulateBaseQty = invQty;
            wholeInvQty = this.ZERO;
        } else {
            simulateBaseQty = transferQty;
            wholeInvQty = invQty.subtract(transferQty);
        }
        qtyArray[0] = simulateBaseQty;
        qtyArray[1] = wholeInvQty;
        return qtyArray;
    }

    private BigDecimal[] calcNextSimuAndInv(STStockInfo stStockInfo, BigDecimal simulateBaseQty, BigDecimal wholeInvQty) {
        ManufactureOrderStockInfo mnfStockInfo = stStockInfo.getStockEntryInfo();
        BigDecimal[] qtyArray = new BigDecimal[2];
        String materialId = mnfStockInfo.getMaterial().getId().toString();
        String warehouseId = mnfStockInfo.getWarehouse().getId().toString();
        String projectId = stStockInfo.getProjectId() != null ? stStockInfo.getProjectId().toString() : "";
        String trackNumberId = stStockInfo.getTrackNumId() != null ? stStockInfo.getTrackNumId().toString() : "";
        BigDecimal invQty = (BigDecimal)this.invMap.get(materialId + warehouseId + projectId + trackNumberId);
        BigDecimal transferQty = (BigDecimal)this.transferNoBatchQtyMap.get(mnfStockInfo.getId().toString());
        if (!this.isInvetory()) {
            qtyArray[0] = simulateBaseQty;
            qtyArray[1] = invQty;
            return qtyArray;
        }
        BigDecimal subtract = transferQty.subtract(invQty);
        if (subtract.compareTo(this.ZERO) > 0) {
            simulateBaseQty = invQty.add(simulateBaseQty);
            wholeInvQty = this.ZERO;
        } else {
            simulateBaseQty = transferQty.add(simulateBaseQty);
            wholeInvQty = invQty.subtract(transferQty);
        }
        qtyArray[0] = simulateBaseQty;
        qtyArray[1] = wholeInvQty;
        return qtyArray;
    }

    private void calcTranferQty(STStockInfo stStockInfo) throws EASBizException, BOSException {
        ManufactureOrderStockInfo mnfStockInfo = stStockInfo.getStockEntryInfo();
        String projectId = stStockInfo.getProjectId() != null ? stStockInfo.getProjectId().toString() : "";
        String trackNumberId = stStockInfo.getTrackNumId() != null ? stStockInfo.getTrackNumId().toString() : "";
        BigDecimal planBaseQty = mnfStockInfo.getPlannedBaseQty();
        BigDecimal totalReceiptBaseQty = mnfStockInfo.getTotalReceiptBaseQty();
        BigDecimal actIssueBaseQty = mnfStockInfo.getActIssueBaseQty();
        BigDecimal rejectedBaseQty = mnfStockInfo.getRejectedBaseQty();
        BigDecimal receitpQty = (BigDecimal)this.receiptQtyMap.get(mnfStockInfo.getParent().getId().toString());
        BigDecimal unitQty = mnfStockInfo.getUnitQty();
        BigDecimal invBaseQty = this.ZERO;
        if (mnfStockInfo.getWarehouse() != null) {
            invBaseQty = (BigDecimal)this.invMap.get(mnfStockInfo.getMaterial().getId().toString() + mnfStockInfo.getWarehouse().getId().toString() + projectId + trackNumberId);
        }
        BigDecimal resultTransferBaseQty = this.ZERO;
        BigDecimal resultNoBatchTransferBaseQty = this.ZERO;
        if (this.sTRuleEnum == STRuleEnum.NORMAL) {
            BigDecimal requiredBaseQty = planBaseQty.subtract(actIssueBaseQty).add(rejectedBaseQty);
            if (requiredBaseQty.compareTo(this.ZERO) < 0) {
                requiredBaseQty = this.ZERO;
            }
            resultNoBatchTransferBaseQty = requiredBaseQty;
            resultTransferBaseQty = this.isInvetory() ? (requiredBaseQty.subtract(invBaseQty).compareTo(this.ZERO) > 0 ? requiredBaseQty.subtract(invBaseQty) : this.ZERO) : (requiredBaseQty.compareTo(this.ZERO) > 0 ? requiredBaseQty : this.ZERO);
        } else if (this.sTRuleEnum == STRuleEnum.SUIT) {
            BigDecimal z = unitQty.multiply(receitpQty);
            z = SCMUtils.getExchangePrecisionQtyForServer((Context)this.context, (String)mnfStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)mnfStockInfo.getUnit(), (MeasureUnitInfo)mnfStockInfo.getMaterial().getBaseUnit(), (BigDecimal)z);
            if (z.compareTo(this.ZERO) < 0) {
                z = this.ZERO;
            }
            resultNoBatchTransferBaseQty = z;
            resultTransferBaseQty = this.isInvetory() ? (z.subtract(invBaseQty).compareTo(this.ZERO) > 0 ? z.subtract(invBaseQty) : this.ZERO) : z;
        } else if (this.sTRuleEnum == STRuleEnum.REINFORCE) {
            BigDecimal y = unitQty.multiply(receitpQty);
            y = SCMUtils.getExchangePrecisionQtyForServer((Context)this.context, (String)mnfStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)mnfStockInfo.getUnit(), (MeasureUnitInfo)mnfStockInfo.getMaterial().getBaseUnit(), (BigDecimal)y);
            if ((y = y.subtract(actIssueBaseQty).add(rejectedBaseQty)).compareTo(this.ZERO) < 0) {
                y = this.ZERO;
            }
            resultNoBatchTransferBaseQty = y;
            resultTransferBaseQty = this.isInvetory() ? (y.subtract(invBaseQty).compareTo(this.ZERO) > 0 ? y.subtract(invBaseQty) : this.ZERO) : y;
        }
        this.transferQtyMap.put(mnfStockInfo.getId().toString(), resultTransferBaseQty);
        this.transferNoBatchQtyMap.put(mnfStockInfo.getId().toString(), resultNoBatchTransferBaseQty);
    }

    private boolean isTransferBatch() {
        return this.calcParam.getIsExportBatch().equals("true");
    }

    private boolean isInvetory() {
        return this.calcParam.getIsEnableQty().equals("true");
    }

    private int getSumWayValue() {
        if (Integer.parseInt(this.calcParam.getSumWayValue()) == 10) {
            return 10;
        }
        if (Integer.parseInt(this.calcParam.getSumWayValue()) == 20) {
            return 20;
        }
        return 0;
    }

    private Map groupStockByMeterialWarehouse(Map sTStockFilterMap) {
        HashMap stockGroupMap = new HashMap();
        ArrayList<STStockInfo> noWarehouseList = new ArrayList<STStockInfo>();
        stockGroupMap.put(WITHOUT_WAREHOUSE_KEY, noWarehouseList);
        if (sTStockFilterMap != null && sTStockFilterMap.size() > 0) {
            Set keyFilterSet = sTStockFilterMap.keySet();
            for (String keyFilterStr : keyFilterSet) {
                List<STStockInfo> stockList;
                String trackNumberId;
                STStockInfo stFilterInfo = (STStockInfo)sTStockFilterMap.get(keyFilterStr);
                ManufactureOrderStockInfo mnfStockInfo = stFilterInfo.getStockEntryInfo();
                if (mnfStockInfo.getWarehouse() == null) {
                    this.stockSimulateMap.put(mnfStockInfo.getId().toString(), this.ZERO);
                    this.invMap.put(mnfStockInfo.getId().toString(), this.ZERO);
                    noWarehouseList.add(stFilterInfo);
                    continue;
                }
                String materialId = mnfStockInfo.getMaterial().getId().toString();
                String warehouseId = mnfStockInfo.getWarehouse().getId().toString();
                String projectId = stFilterInfo.getProjectId() != null ? stFilterInfo.getProjectId().toString() : "";
                String string = trackNumberId = stFilterInfo.getTrackNumId() != null ? stFilterInfo.getTrackNumId().toString() : "";
                if (!stockGroupMap.containsKey(materialId + warehouseId + projectId + trackNumberId)) {
                    stockList = new ArrayList<STStockInfo>();
                    stockList.add(stFilterInfo);
                    stockGroupMap.put(materialId + warehouseId + projectId + trackNumberId, stockList);
                    continue;
                }
                stockList = (List)stockGroupMap.get(materialId + warehouseId + projectId + trackNumberId);
                stockList.add(stFilterInfo);
            }
        }
        return stockGroupMap;
    }

    private Map groupStockByMeterial(Map sTStockFilterMap) {
        HashMap stockGroupMap = new HashMap();
        if (sTStockFilterMap != null && sTStockFilterMap.size() > 0) {
            Set keyFilterSet = sTStockFilterMap.keySet();
            for (String keyFilterStr : keyFilterSet) {
                List<STStockInfo> stockList;
                STStockInfo stFilterInfo = (STStockInfo)sTStockFilterMap.get(keyFilterStr);
                ManufactureOrderStockInfo mnfStockInfo = stFilterInfo.getStockEntryInfo();
                String materialKey = mnfStockInfo.getMaterial().getId().toString();
                String warehouseKey = null;
                String exportStorageUnitKey = null;
                String exportWarehouseKey = null;
                String projectIdKey = null;
                String trackNumberIdKey = null;
                warehouseKey = mnfStockInfo.getWarehouse() == null ? "wnull" : mnfStockInfo.getWarehouse().getId().toString();
                exportStorageUnitKey = mnfStockInfo.getReceiptStroageOrgUnit() == null ? "esnull" : mnfStockInfo.getReceiptStroageOrgUnit().getId().toString();
                exportWarehouseKey = mnfStockInfo.getReceiptStock() == null ? "ewnull" : mnfStockInfo.getReceiptStock().getId().toString();
                projectIdKey = stFilterInfo.getProjectId() == null ? "pjnull" : stFilterInfo.getProjectId().toString();
                trackNumberIdKey = stFilterInfo.getTrackNumId() == null ? "trnull" : stFilterInfo.getTrackNumId().toString();
                if (!stockGroupMap.containsKey(materialKey + warehouseKey + exportStorageUnitKey + exportWarehouseKey + projectIdKey + trackNumberIdKey)) {
                    stockList = new ArrayList<STStockInfo>();
                    stockList.add(stFilterInfo);
                    stockGroupMap.put(materialKey + warehouseKey + exportStorageUnitKey + exportWarehouseKey + projectIdKey + trackNumberIdKey, stockList);
                    continue;
                }
                stockList = (List)stockGroupMap.get(materialKey + warehouseKey + exportStorageUnitKey + exportWarehouseKey + projectIdKey + trackNumberIdKey);
                stockList.add(stFilterInfo);
            }
        }
        return stockGroupMap;
    }

    public ManufactureOrderCollection sortOrderCollectionByPlanBeginDate(ManufactureOrderCollection collection) {
        int i;
        ArrayList<ManufactureOrderInfo> sortList = new ArrayList<ManufactureOrderInfo>();
        if (collection != null && collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                sortList.add(collection.get(i));
            }
        }
        Collections.sort(sortList, (Comparator)new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ManufactureOrderInfo info1 = (ManufactureOrderInfo)arg0;
                ManufactureOrderInfo info2 = (ManufactureOrderInfo)arg1;
                if (info1.getPlanBeginDate().compareTo(info2.getPlanBeginDate()) == 0) {
                    return 0;
                }
                if (info1.getPlanBeginDate().compareTo(info2.getPlanBeginDate()) < 0) {
                    return -1;
                }
                if (info1.getPlanBeginDate().compareTo(info2.getPlanBeginDate()) > 0) {
                    return 1;
                }
                return 0;
            }
        });
        for (i = 0; i < sortList.size(); ++i) {
            collection.add((ManufactureOrderInfo)sortList.get(i));
        }
        return collection;
    }

    private String getStrIds(ManufactureOrderCollection collection) {
        StringBuffer st = new StringBuffer();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            ManufactureOrderInfo info = (ManufactureOrderInfo)it.next();
            st.append("'");
            st.append(info.getId());
            st.append("'");
            st.append(",");
        }
        return st.substring(0, st.toString().length() - 1);
    }

    private Map filterByParamInfo(Map sTStockCalMap) throws BOSException {
        if (this.calcParam == null) {
            return sTStockCalMap;
        }
        String materialNumFrom = this.calcParam.getMaterialNumFrom();
        String materialNumTo = this.calcParam.getMaterialNumTo();
        String dateRequiredFrom = this.calcParam.getDateRequiredFrom();
        String dateRequiredTo = this.calcParam.getDateRequiredTo();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            if (dateRequiredFrom != null && dateRequiredFrom.length() > 0) {
                dateFrom = dateFormat.parse(dateRequiredFrom);
            }
            if (dateRequiredTo != null && dateRequiredTo.length() > 0) {
                dateTo = dateFormat.parse(dateRequiredTo);
            }
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage());
        }
        Set pickingWarehouseNumSet = this.calcParam.getPickingWarehouseNum();
        Set exportStorageUnitNumSet = this.calcParam.getExportStorageUnitNum();
        Set exportWarehouseNumSet = this.calcParam.getExportWarehouseNum();
        String backFlushValue = this.calcParam.getBackFlushValue();
        if (sTStockCalMap != null && sTStockCalMap.size() > 0) {
            Set keySet = sTStockCalMap.keySet();
            Iterator itSTstock = keySet.iterator();
            while (itSTstock.hasNext()) {
                boolean flag;
                String keyStr = (String)itSTstock.next();
                STStockInfo stInfo = (STStockInfo)sTStockCalMap.get(keyStr);
                ManufactureOrderStockInfo manufactureOrderStockInfo = stInfo.getStockEntryInfo();
                BigDecimal receiptQty = (BigDecimal)this.receiptQtyMap.get(manufactureOrderStockInfo.getParent().getId().toString());
                if (receiptQty.compareTo(this.ZERO) <= 0) {
                    itSTstock.remove();
                    sTStockCalMap.remove(keyStr);
                    continue;
                }
                if (materialNumFrom != null && materialNumFrom.length() > 0 && materialNumTo != null && materialNumTo.length() > 0) {
                    if (manufactureOrderStockInfo.getMaterial().getNumber().compareTo(materialNumFrom) < 0 || manufactureOrderStockInfo.getMaterial().getNumber().compareTo(materialNumTo) > 0) {
                        itSTstock.remove();
                        sTStockCalMap.remove(keyStr);
                        continue;
                    }
                } else if (materialNumFrom != null && materialNumFrom.length() > 0 && (materialNumTo == null || materialNumTo.length() == 0)) {
                    if (manufactureOrderStockInfo.getMaterial().getNumber().compareTo(materialNumFrom) < 0) {
                        itSTstock.remove();
                        sTStockCalMap.remove(keyStr);
                        continue;
                    }
                } else if (materialNumTo != null && materialNumTo.length() > 0 && (materialNumFrom == null || materialNumFrom.length() == 0) && manufactureOrderStockInfo.getMaterial().getNumber().compareTo(materialNumTo) > 0) {
                    itSTstock.remove();
                    sTStockCalMap.remove(keyStr);
                    continue;
                }
                if (dateRequiredFrom != null && dateRequiredFrom.length() > 0 && dateRequiredTo != null && dateRequiredTo.length() > 0) {
                    if (manufactureOrderStockInfo.getDemandTime().compareTo(dateFrom) < 0 || manufactureOrderStockInfo.getDemandTime().compareTo(dateTo) > 0) {
                        itSTstock.remove();
                        sTStockCalMap.remove(keyStr);
                        continue;
                    }
                } else if (dateRequiredFrom != null && dateRequiredFrom.length() > 0 && (dateRequiredTo == null || dateRequiredTo.length() == 0)) {
                    if (manufactureOrderStockInfo.getDemandTime().compareTo(dateFrom) < 0) {
                        itSTstock.remove();
                        sTStockCalMap.remove(keyStr);
                        continue;
                    }
                } else if (dateRequiredTo != null && dateRequiredTo.length() > 0 && (dateRequiredFrom == null || dateRequiredFrom.length() == 0) && manufactureOrderStockInfo.getDemandTime().compareTo(dateTo) > 0) {
                    sTStockCalMap.remove(keyStr);
                    continue;
                }
                if (pickingWarehouseNumSet != null && pickingWarehouseNumSet.size() > 0 && manufactureOrderStockInfo.getWarehouse() != null) {
                    flag = false;
                    for (String pickingWarehouseNum : pickingWarehouseNumSet) {
                        if (!manufactureOrderStockInfo.getWarehouse().getNumber().equals(pickingWarehouseNum)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        itSTstock.remove();
                        sTStockCalMap.remove(keyStr);
                        continue;
                    }
                }
                if (exportStorageUnitNumSet != null && exportStorageUnitNumSet.size() > 0 && manufactureOrderStockInfo.getReceiptStroageOrgUnit() != null) {
                    flag = false;
                    for (String exportStorageUnitNum : exportStorageUnitNumSet) {
                        if (!manufactureOrderStockInfo.getReceiptStroageOrgUnit().getNumber().equals(exportStorageUnitNum)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        itSTstock.remove();
                        sTStockCalMap.remove(keyStr);
                        continue;
                    }
                }
                if (exportWarehouseNumSet != null && exportWarehouseNumSet.size() > 0 && manufactureOrderStockInfo.getReceiptStock() != null) {
                    flag = false;
                    for (String exportWarehouseNum : exportWarehouseNumSet) {
                        if (!manufactureOrderStockInfo.getReceiptStock().getNumber().equals(exportWarehouseNum)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        itSTstock.remove();
                        sTStockCalMap.remove(keyStr);
                        continue;
                    }
                }
                if (backFlushValue == null || backFlushValue.length() <= 0) continue;
                if (Integer.parseInt(backFlushValue) == 10) {
                    if (manufactureOrderStockInfo.isIsBackflush()) continue;
                    itSTstock.remove();
                    sTStockCalMap.remove(keyStr);
                    continue;
                }
                if (Integer.parseInt(backFlushValue) != 20 || !manufactureOrderStockInfo.isIsBackflush()) continue;
                itSTstock.remove();
                sTStockCalMap.remove(keyStr);
            }
        }
        return sTStockCalMap;
    }

    private Map group(ManufactureOrderStockCollection mnfStockCollection, STGroupEnum groupEnum) {
        HashMap stockGroupMap;
        block6: {
            block8: {
                block7: {
                    stockGroupMap = new HashMap();
                    if (mnfStockCollection == null) break block6;
                    if (groupEnum != STGroupEnum.NOGROUP) break block7;
                    for (int i = 0; i < mnfStockCollection.size(); ++i) {
                        ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(i);
                        ArrayList<ManufactureOrderStockInfo> stockList = new ArrayList<ManufactureOrderStockInfo>();
                        stockList.add(mnfStockInfo);
                        stockGroupMap.put(mnfStockInfo.getId().toString(), stockList);
                    }
                    break block6;
                }
                if (groupEnum != STGroupEnum.OUTSTORAGEWAREHOUSE) break block8;
                if (mnfStockCollection == null || mnfStockCollection.size() <= 0) break block6;
                for (int i = 0; i < mnfStockCollection.size(); ++i) {
                    List<ManufactureOrderStockInfo> stockList;
                    ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(i);
                    String exportStorageId = null;
                    String exportWarehouseId = null;
                    exportStorageId = mnfStockInfo.getReceiptStroageOrgUnit() != null ? mnfStockInfo.getReceiptStroageOrgUnit().getId().toString() : "esnull";
                    exportWarehouseId = mnfStockInfo.getReceiptStock() != null ? mnfStockInfo.getReceiptStock().getId().toString() : "ewnull";
                    if (!stockGroupMap.containsKey(exportStorageId + exportWarehouseId)) {
                        stockList = new ArrayList<ManufactureOrderStockInfo>();
                        stockList.add(mnfStockInfo);
                        stockGroupMap.put(exportStorageId + exportWarehouseId, stockList);
                        continue;
                    }
                    stockList = (List)stockGroupMap.get(exportStorageId + exportWarehouseId);
                    stockList.add(mnfStockInfo);
                }
                break block6;
            }
            if (groupEnum == STGroupEnum.OUTSTORAGE && mnfStockCollection != null && mnfStockCollection.size() > 0) {
                for (int i = 0; i < mnfStockCollection.size(); ++i) {
                    List<ManufactureOrderStockInfo> stockList;
                    ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(i);
                    String exportStorageId = null;
                    exportStorageId = mnfStockInfo.getReceiptStroageOrgUnit() != null ? mnfStockInfo.getReceiptStroageOrgUnit().getId().toString() : "esnull";
                    if (!stockGroupMap.containsKey(exportStorageId)) {
                        stockList = new ArrayList<ManufactureOrderStockInfo>();
                        stockList.add(mnfStockInfo);
                        stockGroupMap.put(exportStorageId, stockList);
                        continue;
                    }
                    stockList = (List)stockGroupMap.get(exportStorageId);
                    stockList.add(mnfStockInfo);
                }
            }
        }
        return stockGroupMap;
    }

    private Map assembleBillCollection(Context ctx, Map groupMap, STGroupEnum groupEnum, TransferOrderBillCollection transferOrderBillCollection, StockTransferBillCollection stockTransferBillCollection, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection) throws EASBizException, BOSException {
        HashMap resultMap = new HashMap();
        Set keySet = groupMap.keySet();
        if (keySet != null && keySet.size() > 0) {
            for (String key : keySet) {
                List stockList = (List)groupMap.get(key);
                TransferOrderBillInfo transferOrderBillInfo = new TransferOrderBillInfo();
                StockTransferBillInfo stockTransferBillInfo = new StockTransferBillInfo();
                this.assembleBillInfo(ctx, stockList, groupEnum, transferOrderBillInfo, stockTransferBillInfo, botRelationCollection, botRelationEntryCollection);
                if (transferOrderBillInfo != null && transferOrderBillInfo.getEntry() != null && transferOrderBillInfo.getEntry().size() > 0) {
                    transferOrderBillCollection.add(transferOrderBillInfo);
                }
                if (stockTransferBillInfo == null || stockTransferBillInfo.getEntry() == null || stockTransferBillInfo.getEntry().size() <= 0) continue;
                stockTransferBillCollection.add(stockTransferBillInfo);
            }
        }
        return resultMap;
    }

    private void assembleBillInfo(Context ctx, List stockList, STGroupEnum groupEnum, TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection) throws BOSException, EASBizException {
        if (groupEnum == STGroupEnum.NOGROUP) {
            ManufactureOrderStockInfo mnfStockInfo = (ManufactureOrderStockInfo)stockList.get(0);
            this.assembleDetail(ctx, mnfStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
            this.convertBOTP(transferOrderBillInfo, stockTransferBillInfo, botRelationCollection, botRelationEntryCollection, mnfStockInfo);
        } else if (groupEnum == STGroupEnum.OUTSTORAGEWAREHOUSE || groupEnum == STGroupEnum.OUTSTORAGE) {
            for (int i = 0; i < stockList.size(); ++i) {
                ManufactureOrderStockInfo mnfStockInfo = (ManufactureOrderStockInfo)stockList.get(i);
                if (i == 0) {
                    this.assembleDetail(ctx, mnfStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
                    continue;
                }
                OrderStockTransferTypeEnum orderTransEnum = mnfStockInfo.getTransferType();
                if (orderTransEnum == OrderStockTransferTypeEnum.WAREHOUSE || orderTransEnum == OrderStockTransferTypeEnum.NULL || orderTransEnum == OrderStockTransferTypeEnum.STORAGE) {
                    if (stockTransferBillInfo.getId() != null) {
                        this.assembleDetail(ctx, mnfStockInfo, transferOrderBillInfo, stockTransferBillInfo, false);
                        continue;
                    }
                    this.assembleDetail(ctx, mnfStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
                    continue;
                }
                if (orderTransEnum != OrderStockTransferTypeEnum.FINANCE) continue;
                if (transferOrderBillInfo.getId() != null) {
                    this.assembleDetail(ctx, mnfStockInfo, transferOrderBillInfo, stockTransferBillInfo, false);
                    continue;
                }
                this.assembleDetail(ctx, mnfStockInfo, transferOrderBillInfo, stockTransferBillInfo, true);
            }
            this.convertBOTP(transferOrderBillInfo, stockTransferBillInfo, botRelationCollection, botRelationEntryCollection, stockList);
        }
    }

    private void convertBOTP(TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection, ManufactureOrderStockInfo mnfStockInfo) throws BOSException {
        Map idMap = (Map)this.sTStockMap.get(ID_MAP_KEY);
        String stId = (String)idMap.get(mnfStockInfo.getId().toString());
        STStockInfo stStockInfo = (STStockInfo)this.sTStockMap.get(stId);
        Map billRelationMap = stStockInfo.getBillRelationMap();
        Set mapEntrySet = billRelationMap.entrySet();
        for (Map.Entry mapEntry : mapEntrySet) {
            String orderId = (String)mapEntry.getKey();
            BOTRelationInfo botRelationInfo = new BOTRelationInfo();
            botRelationInfo.setId(BOSUuid.create((BOSObjectType)botRelationInfo.getBOSType()));
            botRelationInfo.setSrcEntityID(MANUFACTURE_ORDER_TYPE);
            botRelationInfo.setBOTMappingID(botpid);
            botRelationInfo.setSrcObjectID(orderId);
            if (transferOrderBillInfo != null && transferOrderBillInfo.getEntry() != null && transferOrderBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID(TRANSFER_ORDER_BILL_TYPE);
                botRelationInfo.setDestObjectID(transferOrderBillInfo.getId().toString());
            } else if (stockTransferBillInfo != null && stockTransferBillInfo.getEntry() != null && stockTransferBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID(STOCK_TRANSFER_BILL_TYPE);
                botRelationInfo.setDestObjectID(stockTransferBillInfo.getId().toString());
            }
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.context);
            Timestamp currentDate = iSCMBillCommonFacade.getServerDate();
            botRelationInfo.setDate((Date)currentDate);
            botRelationInfo.setOperatorID(this.context.getCaller().toString());
            botRelationInfo.setIsEffected(true);
            botRelationInfo.setType(0);
            botRelationCollection.add(botRelationInfo);
            Set stockIdSet = (Set)mapEntry.getValue();
            for (String stockId : stockIdSet) {
                String[] destObjectEntryId = (String[])this.stIdDestEntryIdMap.get(stId);
                BOTRelationEntryInfo botRelationEntryInfo = new BOTRelationEntryInfo();
                botRelationEntryInfo.setId(BOSUuid.create((BOSObjectType)botRelationEntryInfo.getBOSType()));
                botRelationEntryInfo.setSrcEntryID(stockId);
                botRelationEntryInfo.setSrcObjectID(orderId);
                botRelationEntryInfo.setDestObjectID(destObjectEntryId[0]);
                botRelationEntryInfo.setDestEntryID(destObjectEntryId[1]);
                botRelationEntryInfo.setSrcEntryPropName("__src.stocks");
                botRelationEntryInfo.setDestEntryPropName("__dest.entry");
                botRelationEntryInfo.setDestPropertyName("id");
                botRelationInfo.getRelationEntries().add(botRelationEntryInfo);
                botRelationEntryInfo.setRelation(botRelationInfo);
            }
        }
    }

    private void convertBOTP(TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, BOTRelationCollection botRelationCollection, BOTRelationEntryCollection botRelationEntryCollection, List stockList) throws BOSException {
        Map idMap = (Map)this.sTStockMap.get(ID_MAP_KEY);
        HashSet<String> orderIdSet = new HashSet<String>();
        for (int i = 0; i < stockList.size(); ++i) {
            ManufactureOrderStockInfo mnfStockInfo = (ManufactureOrderStockInfo)stockList.get(i);
            String stId = (String)idMap.get(mnfStockInfo.getId().toString());
            STStockInfo stStockInfo = (STStockInfo)this.sTStockMap.get(stId);
            Map idRelationMap = stStockInfo.getBillRelationMap();
            Set orderSet = idRelationMap.keySet();
            for (String orderId : orderSet) {
                orderIdSet.add(orderId);
                Set stockSet = (Set)idRelationMap.get(orderId);
                for (String stockId : stockSet) {
                    String[] destObjectEntryId = (String[])this.stIdDestEntryIdMap.get(stId);
                    BOTRelationEntryInfo botRelationEntryInfo = new BOTRelationEntryInfo();
                    botRelationEntryInfo.setId(BOSUuid.create((String)BOT_ENTRY_TYPE));
                    botRelationEntryInfo.setSrcEntryID(stockId);
                    botRelationEntryInfo.setSrcObjectID(orderId);
                    botRelationEntryInfo.setDestObjectID(destObjectEntryId[0]);
                    botRelationEntryInfo.setDestEntryID(destObjectEntryId[1]);
                    botRelationEntryInfo.setSrcEntryPropName("__src.stocks");
                    botRelationEntryInfo.setDestEntryPropName("__dest.entry");
                    botRelationEntryInfo.setDestPropertyName("id");
                    botRelationEntryCollection.add(botRelationEntryInfo);
                }
            }
        }
        for (String orderId : orderIdSet) {
            BOTRelationInfo botRelationInfo = new BOTRelationInfo();
            botRelationInfo.setId(BOSUuid.create((String)BOT_TYPE));
            botRelationInfo.setSrcEntityID(MANUFACTURE_ORDER_TYPE);
            botRelationInfo.setSrcObjectID(orderId);
            if (transferOrderBillInfo != null && transferOrderBillInfo.getEntry() != null && transferOrderBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID(TRANSFER_ORDER_BILL_TYPE);
                botRelationInfo.setDestObjectID(transferOrderBillInfo.getId().toString());
            } else if (stockTransferBillInfo != null && stockTransferBillInfo.getEntry() != null && stockTransferBillInfo.getEntry().size() > 0) {
                botRelationInfo.setDestEntityID(STOCK_TRANSFER_BILL_TYPE);
                botRelationInfo.setDestObjectID(stockTransferBillInfo.getId().toString());
            }
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.context);
            Timestamp currentDate = iSCMBillCommonFacade.getServerDate();
            botRelationInfo.setDate((Date)currentDate);
            botRelationInfo.setOperatorID(this.context.getCaller().toString());
            botRelationInfo.setIsEffected(true);
            botRelationInfo.setBOTMappingID(botpid);
            botRelationInfo.setType(0);
            botRelationCollection.add(botRelationInfo);
        }
    }

    private void assembleDetail(Context ctx, ManufactureOrderStockInfo mnfStockInfo, TransferOrderBillInfo transferOrderBillInfo, StockTransferBillInfo stockTransferBillInfo, boolean flag) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.context);
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.context);
        Timestamp bizDate = iSCMBillCommonFacade.getServerDate();
        StorageOrgUnitInfo exportStorageInfo = mnfStockInfo.getReceiptStroageOrgUnit();
        CompanyOrgUnitInfo companyOriUnitInfo = null;
        if (exportStorageInfo != null) {
            companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(exportStorageInfo.getId());
        }
        StorageOrgUnitInfo inStorageOrgUnitInfo = this.storageOrgUnitInfo;
        CompanyOrgUnitInfo inCompanyOriUnitInfo = null;
        if (inStorageOrgUnitInfo != null) {
            inCompanyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(inStorageOrgUnitInfo.getId());
        }
        OrderStockTransferTypeEnum orderTransEnum = mnfStockInfo.getTransferType();
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"B2aZSVXaSx6qxdfekgCmrEY+1VI="));
        if (orderTransEnum == OrderStockTransferTypeEnum.WAREHOUSE || orderTransEnum == OrderStockTransferTypeEnum.STORAGE) {
            if (flag) {
                stockTransferBillInfo.setId(BOSUuid.create((BOSObjectType)stockTransferBillInfo.getBOSType()));
                this.setBizType1(stockTransferBillInfo, mnfStockInfo);
                stockTransferBillInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)stockTransferBillInfo, this.storageOrgUnitInfo.getId().toString()));
                stockTransferBillInfo.setBizDate((Date)bizDate);
                stockTransferBillInfo.setIssueCompanyOrgUnit(companyOriUnitInfo);
                stockTransferBillInfo.setIssueStorageOrgUnit(exportStorageInfo);
                stockTransferBillInfo.setReceiptCompanyOrgUnit(inCompanyOriUnitInfo);
                stockTransferBillInfo.setReceiptStorageOrgUnit(inStorageOrgUnitInfo);
                stockTransferBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                stockTransferBillInfo.setSourceBillType(billTypeInfo);
            }
            StockTransferBillEntryInfo entryInfo = new StockTransferBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setMaterial(mnfStockInfo.getMaterial());
            Map idMap = (Map)this.sTStockMap.get(ID_MAP_KEY);
            String stId = (String)idMap.get(mnfStockInfo.getId().toString());
            STStockInfo stStockInfo = (STStockInfo)this.sTStockMap.get(stId);
            BigDecimal qty = stStockInfo.getReceiptQty();
            entryInfo.setBaseUnit(mnfStockInfo.getMaterial().getBaseUnit());
            entryInfo.setQty(qty);
            entryInfo.setBaseQty(SCMUtils.getExchangePrecisionQtyForServer((Context)this.context, (String)mnfStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)mnfStockInfo.getUnit(), (MeasureUnitInfo)mnfStockInfo.getMaterial().getBaseUnit(), (BigDecimal)qty));
            entryInfo.setUnit(mnfStockInfo.getUnit());
            entryInfo.setAssistUnit(mnfStockInfo.getMaterial().getAssistUnit());
            entryInfo.setIssuePlanDate((Date)mnfStockInfo.getDemandTime());
            entryInfo.setReceiptPlanDate((Date)mnfStockInfo.getDemandTime());
            entryInfo.setIssueWarehouse(mnfStockInfo.getReceiptStock());
            entryInfo.setReceiptWarehouse(mnfStockInfo.getWarehouse());
            if (orderTransEnum == OrderStockTransferTypeEnum.STORAGE && mnfStockInfo.getMaterial() != null && mnfStockInfo.getMaterial().getId() != null && exportStorageInfo != null && exportStorageInfo.getId() != null) {
                MaterialPlanInfo matPlnInfo = this.matPlanInfo(ctx, mnfStockInfo.getMaterial().getId().toString(), exportStorageInfo.getId().toString());
                if (matPlnInfo != null && matPlnInfo.getPlanningMode() != null) {
                    if (matPlnInfo.getPlanningMode().equals((Object)PlanningModeEnum.MRP) || matPlnInfo.getPlanningMode().equals((Object)PlanningModeEnum.MPS)) {
                        entryInfo.setIsMrpCal(true);
                    } else {
                        entryInfo.setIsMrpCal(false);
                    }
                } else {
                    entryInfo.setIsMrpCal(false);
                }
            } else {
                entryInfo.setIsMrpCal(false);
            }
            entryInfo.setTrackNumber(stStockInfo.getTrackNumberInfo() != null ? stStockInfo.getTrackNumberInfo() : null);
            entryInfo.setProject(stStockInfo.getProjectInfo() != null ? stStockInfo.getProjectInfo() : null);
            entryInfo.setSourceBillType(billTypeInfo);
            this.setStoreType2(entryInfo);
            this.setStoreState2(entryInfo);
            entryInfo.setRemark(stStockInfo.getRemark());
            stockTransferBillInfo.getEntry().add(entryInfo);
            entryInfo.setParent(stockTransferBillInfo);
            String[] ids = new String[]{stockTransferBillInfo.getId().toString(), entryInfo.getId().toString()};
            this.stIdDestEntryIdMap.put(stId, ids);
        } else if (orderTransEnum == OrderStockTransferTypeEnum.FINANCE) {
            if (flag) {
                transferOrderBillInfo.setId(BOSUuid.create((BOSObjectType)transferOrderBillInfo.getBOSType()));
                this.setBizType2(transferOrderBillInfo);
                transferOrderBillInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)transferOrderBillInfo, this.storageOrgUnitInfo.getId().toString()));
                transferOrderBillInfo.setBizDate((Date)bizDate);
                transferOrderBillInfo.setIssueCompanyOrgUnit(companyOriUnitInfo);
                transferOrderBillInfo.setReceiptCompanyOrgUnit(inCompanyOriUnitInfo);
                transferOrderBillInfo.setIssueStorageOrgUnit(exportStorageInfo);
                transferOrderBillInfo.setReceiptStorageOrgUnit(inStorageOrgUnitInfo);
                transferOrderBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                transferOrderBillInfo.setSourceBillType(billTypeInfo);
            }
            TransferOrderBillEntryInfo entryInfo = new TransferOrderBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setMaterial(mnfStockInfo.getMaterial());
            Map idMap = (Map)this.sTStockMap.get(ID_MAP_KEY);
            String stId = (String)idMap.get(mnfStockInfo.getId().toString());
            STStockInfo stStockInfo = (STStockInfo)this.sTStockMap.get(stId);
            BigDecimal qty = stStockInfo.getReceiptQty();
            entryInfo.setBaseUnit(mnfStockInfo.getMaterial().getBaseUnit());
            entryInfo.setQty(qty);
            entryInfo.setBaseQty(SCMUtils.getExchangePrecisionQtyForServer((Context)this.context, (String)mnfStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)mnfStockInfo.getUnit(), (MeasureUnitInfo)mnfStockInfo.getMaterial().getBaseUnit(), (BigDecimal)qty));
            entryInfo.setUnit(mnfStockInfo.getUnit());
            entryInfo.setIssueWarehouse(mnfStockInfo.getReceiptStock());
            entryInfo.setReceiptWarehouse(mnfStockInfo.getWarehouse());
            entryInfo.setIssueStorageOrgUnit(exportStorageInfo);
            entryInfo.setReceiveStorageOrgUnit(inStorageOrgUnitInfo);
            entryInfo.setIssuePlanDate((Date)mnfStockInfo.getDemandTime());
            entryInfo.setReceiptPlanDate((Date)mnfStockInfo.getDemandTime());
            if (mnfStockInfo.getMaterial() != null && mnfStockInfo.getMaterial().getId() != null && exportStorageInfo != null && exportStorageInfo.getId() != null) {
                MaterialPlanInfo matPlnInfo = this.matPlanInfo(ctx, mnfStockInfo.getMaterial().getId().toString(), exportStorageInfo.getId().toString());
                if (matPlnInfo != null && matPlnInfo.getPlanningMode() != null) {
                    if (matPlnInfo.getPlanningMode().equals((Object)PlanningModeEnum.MRP) || matPlnInfo.getPlanningMode().equals((Object)PlanningModeEnum.MPS)) {
                        entryInfo.setIsMrpCal(true);
                    } else {
                        entryInfo.setIsMrpCal(false);
                    }
                } else {
                    entryInfo.setIsMrpCal(false);
                }
            } else {
                entryInfo.setIsMrpCal(false);
            }
            entryInfo.setTrackNumber(stStockInfo.getTrackNumberInfo() != null ? stStockInfo.getTrackNumberInfo() : null);
            entryInfo.setProject(stStockInfo.getProjectInfo() != null ? stStockInfo.getProjectInfo() : null);
            entryInfo.setSourceBillType(billTypeInfo);
            entryInfo.setRemark(stStockInfo.getRemark());
            transferOrderBillInfo.getEntry().add(entryInfo);
            entryInfo.setParent(transferOrderBillInfo);
            String[] ids = new String[]{transferOrderBillInfo.getId().toString(), entryInfo.getId().toString()};
            this.stIdDestEntryIdMap.put(stId, ids);
        }
    }

    private MaterialPlanInfo matPlanInfo(Context ctx, String matID, String storageID) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("planningMode"));
        entityViewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)matID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        MaterialPlanCollection collection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entityViewInfo);
        if (collection != null && collection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = collection.get(0);
            return materialPlanInfo;
        }
        return null;
    }

    private void setStoreState2(StockTransferBillEntryInfo entryInfo) {
        StoreStateInfo storeStateInfo = new StoreStateInfo();
        storeStateInfo.setId(BOSUuid.read((String)STORESTATUSID_USABLE));
        entryInfo.setStoreState(storeStateInfo);
    }

    private void setStoreType2(StockTransferBillEntryInfo entryInfo) {
        StoreTypeInfo storeTypeInfo = new StoreTypeInfo();
        storeTypeInfo.setId(BOSUuid.read((String)STORE_TYPE__USUALLY));
        entryInfo.setStoreType(storeTypeInfo);
    }

    private void setBizType2(TransferOrderBillInfo transferOrderBillInfo) throws BOSException, EASBizException, UuidException {
        BizTypeInfo bizTypeInfo = this.getBizTypeInfoById(BIZ_TYPE__310_ID);
        transferOrderBillInfo.setBizType(bizTypeInfo);
    }

    private BizTypeInfo getBizTypeInfoById(String id) throws BOSException, EASBizException {
        IBizType bizType = BizTypeFactory.getLocalInstance((Context)this.context);
        BizTypeInfo bizTypeInfo = bizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        return bizTypeInfo;
    }

    private void setBizType1(StockTransferBillInfo stockTransferBillInfo, ManufactureOrderStockInfo mnfStockInfo) throws EASBizException, BOSException {
        BizTypeInfo bizTypeInfo = null;
        bizTypeInfo = mnfStockInfo.getTransferType() == OrderStockTransferTypeEnum.STORAGE ? this.getBizTypeInfoById(BIZ_TYPE__321_ID) : this.getBizTypeInfoById(BIZ_TYPE__331_ID);
        stockTransferBillInfo.setBizType(bizTypeInfo);
    }

    protected boolean checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model, BOSObjectType bosType) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (this.isSameNumber(ctx, pk, model, bosType)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{aSCMBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model, BOSObjectType bosType) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this.exists(ctx, filter, bosType);
    }

    private boolean exists(Context ctx, FilterInfo filter, BOSObjectType bosType) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            boolean bl = this.getDAO(ctx, cn, bosType).exists(filter);
            return bl;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private IORMappingDAO getDAO(Context ctx, Connection cn, BOSObjectType bosType) {
        return ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
    }

    protected BOSObjectType getStockTransferBOSType() {
        return new BOSObjectType(STOCK_TRANSFER_BILL_TYPE);
    }

    protected BOSObjectType getTransferOrderBOSType() {
        return new BOSObjectType(TRANSFER_ORDER_BILL_TYPE);
    }

    private Object[] StoretypeAndStorestate(ResultSet rs) throws BOSException {
        Object[] st = new Object[2];
        HashSet<String> type = new HashSet<String>();
        HashSet<String> status = new HashSet<String>();
        try {
            while (rs.next()) {
                if (rs.getString("fstoretype") != null) {
                    type.add(rs.getString("fstoretype"));
                }
                if (rs.getString("fstorestate") == null) continue;
                status.add(rs.getString("fstorestate"));
            }
            st[0] = type;
            st[1] = status;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return st;
    }
}

