/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.CodingRulerSrvHelper;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.ScrapOrderCollection;
import com.kingdee.eas.mm.mo.ScrapOrderEntryCollection;
import com.kingdee.eas.mm.mo.ScrapOrderEntryInfo;
import com.kingdee.eas.mm.mo.ScrapOrderFactory;
import com.kingdee.eas.mm.mo.ScrapOrderInfo;
import com.kingdee.eas.mm.mo.ScrapTypeEnum;
import com.kingdee.eas.mm.mo.app.AbstractScrapOrderControllerBean;
import com.kingdee.eas.mm.mo.app.MaterialWriteBackSO;
import com.kingdee.eas.mm.mo.app.ScrapOrderUpdaterMO;
import com.kingdee.eas.mm.planning.IReqPlanReceiveReqDataFacade;
import com.kingdee.eas.mm.planning.ReqPlanReceiveReqDataFacadeFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ScrapOrderControllerBean
extends AbstractScrapOrderControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 1L;
    private static String path = "com.kingdee.eas.mm.mo.ScrapOrderResource";

    @Override
    public IObjectValue _createNewSO(Context ctx, boolean isUseAgent, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs;
        ScrapOrderInfo info = new ScrapOrderInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        info.setBizDate(curDate);
        info.setScrapType(ScrapTypeEnum.BecauseOfWork);
        info.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        info.setLastUpdateTime(null);
        info.setLastUpdateUser(null);
        info.setAuditor(null);
        info.setAuditTime(null);
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo billTypeInfo = (BillTypeInfo)iBillType.getValue((IObjectPK)new ObjectStringPK("YnsvoPSeRzCK0b/jEufQpkY+1VI="));
        info.setBillType(billTypeInfo);
        if (storageOrgUnitInfo == null && (mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits(ctx.getCaller(), OrgType.Storage, "mm_scrapOrder_addNew")) != null && mainOrgs.length > 0) {
            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            storageOrgUnitInfo = (StorageOrgUnitInfo)mainOrgs[0];
        }
        if (storageOrgUnitInfo != null) {
            info.setStorageOrgUnit(storageOrgUnitInfo);
            info.setAdminOrgUnit(this.getDefaultAdminOrg(ctx, storageOrgUnitInfo.getId().toString()));
        }
        return info;
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        return this._createNewSO(ctx, isUseAgent, null);
    }

    protected String getBillTypeId() {
        return "YnsvoPSeRzCK0b/jEufQpkY+1VI=";
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.mo.app.sobizprocess.xml";
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScrapOrderInfo info = (ScrapOrderInfo)model;
        BigDecimal number = new BigDecimal("0.0");
        for (int i = 0; i < info.getEntries().size(); ++i) {
            ScrapOrderEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getAssCoefficient() != null) continue;
            entryInfo.setAssCoefficient(number);
        }
        IObjectPK pk = super._save(ctx, model);
        this.markBOTPRelation(ctx, info);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScrapOrderInfo so = (ScrapOrderInfo)model;
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("YnsvoPSeRzCK0b/jEufQpkY+1VI="));
        so.setBillType(billTypeInfo);
        IObjectPK pk = super._submit(ctx, (IObjectValue)so);
        this.markBOTPRelation(ctx, so);
        try {
            this.afterSubmit(ctx, so);
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
        String orgUnitID = so.getStorageOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, so, orgUnitID, 4)) {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"Audit", (BOSObjectType)so.getBOSType(), (IObjectPK)pk, (String)so.getNumber(), (String)"mm_scrapOrder_audit");
            this.audit(ctx, pk);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        return pk;
    }

    protected void _audit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        this.batchAudit(ctx, entrys);
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ScrapOrderInfo info = (ScrapOrderInfo)model;
        CodingRulerSrvHelper codeHelper = new CodingRulerSrvHelper();
        codeHelper.setBizOrgPropertyName("storageOrgUnit");
        codeHelper.checkNumber(ctx, (ICoreBase)ScrapOrderFactory.getLocalInstance(ctx), model, (OrgUnitInfo)info.getStorageOrgUnit());
        return true;
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            try {
                this.submitCheck(ctx, batchResults);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            this.auditOrUnAuditExecute(ctx, batchResults, true);
        } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.unAuditBatchCheck(ctx, batchResults);
            this.auditOrUnAuditExecute(ctx, batchResults, false);
        }
    }

    private void submitCheck(Context ctx, BatchActionResults batchResults) throws BOSException, SQLException, EASBizException {
        Date now;
        ScrapOrderCollection coll = (ScrapOrderCollection)batchResults.getObjCollection();
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        StringBuffer materialIds = new StringBuffer();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        StringBuffer sql = new StringBuffer();
        try {
            now = dtformat.parse(dtformat.format(new Date()));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap crossOrgMap = new HashMap();
        HashSet<String> crossOrgSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            materialIds.setLength(0);
            ScrapOrderInfo scrapOrder = coll.get(i);
            String id = scrapOrder.getId() == null ? "NEWID" : scrapOrder.getId().toString();
            ScrapOrderEntryCollection enrtyColl = scrapOrder.getEntries();
            for (int j = 0; j < enrtyColl.size(); ++j) {
                List<String> seqList;
                ScrapOrderEntryInfo scrapOrderEntry = enrtyColl.get(j);
                String seq = String.valueOf(j + 1);
                String[] params = new String[]{seq};
                if (scrapOrderEntry.isIsSupplyMaterial()) {
                    if (scrapOrderEntry.getRequireDate() == null) {
                        batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"REQUIREDATE_LESS_NOW_All", (String[])params));
                    } else if (scrapOrderEntry.getRequireDate().compareTo(now) < 0) {
                        batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"REQUIREDATE_LESS_NOW_All", (String[])params));
                    }
                    if (scrapOrderEntry.getSupplyRequiredQty() == null) {
                        batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"SupplyRequiredQty_Must_Great_Zero_ALL", (String[])params));
                    } else if (scrapOrderEntry.getSupplyRequiredQty().compareTo(new BigDecimal("0.0")) <= 0) {
                        batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"SupplyRequiredQty_Must_Great_Zero_ALL", (String[])params));
                    }
                }
                if (!ScrapTypeEnum.BecauseOfRedundancy.equals((Object)scrapOrderEntry.getScrapType())) {
                    if (scrapOrderEntry.getScrapQty() == null) {
                        batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"ScrapQty_Must_Great_Zero_ALL", (String[])params));
                    } else if (scrapOrderEntry.getScrapQty().compareTo(new BigDecimal("0.0")) <= 0) {
                        batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"ScrapQty_Must_Great_Zero_ALL", (String[])params));
                    }
                    if (scrapOrderEntry.getSupplyRequiredQty() != null && scrapOrderEntry.getScrapQty().compareTo(scrapOrderEntry.getSupplyRequiredQty()) < 0) {
                        batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"SupplyRequiredQty_Great_ScrapQty_ALL", (String[])params));
                    }
                    if (!MMUtils.isEmptyString((String)scrapOrderEntry.getLot())) continue;
                    if (materialIds.length() != 0) {
                        materialIds.append(",");
                    }
                    materialIds.append("'").append(scrapOrderEntry.getMaterial().getId().toString()).append("'");
                    map.put(scrapOrderEntry.getMaterial().getId().toString(), params);
                }
                if (scrapOrderEntry.getProvideType() != MaterialProvideTypeEnum.SPANORGPROVIDE && scrapOrderEntry.getProvideType() != MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE) continue;
                String keyID = scrapOrderEntry.getMaterial().getId().toString() + "_" + scrapOrderEntry.getStorageOrgUnit().getId().toString();
                if (crossOrgMap.containsKey(keyID)) {
                    seqList = (List)crossOrgMap.get(keyID);
                    seqList.add(String.valueOf(scrapOrderEntry.getProvideType().getValue()));
                } else {
                    seqList = new ArrayList();
                    seqList.add(String.valueOf(scrapOrderEntry.getProvideType().getValue()));
                    crossOrgMap.put(keyID, seqList);
                }
                if (crossOrgSet.contains(keyID)) continue;
                crossOrgSet.add(keyID);
            }
            if (materialIds.length() != 0) {
                sql.append("select FMaterialID from T_BD_MaterialInventory where FMaterialID in (").append(materialIds).append(") and ").append("FOrgUnit = '").append(scrapOrder.getStorageOrgUnit().getId().toString()).append("' and FIsLotNumber = 1");
                IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    batchResults.addError(id, ResourceUtils.getMessageForServer((String)path, (String)"Lot_Require", (String[])((String[])map.get(rs.getString(1)))));
                }
            }
            Set outSet = MMUtils.getCrossOrgMaterialSupplyOrgSet((Context)ctx, crossOrgSet);
            for (String materialOrg : outSet) {
                String[] array = materialOrg.split("_");
                String sqlMaterialName = "select fname_" + ScrapOrderControllerBean.getLocale() + " as name from T_BD_Material where fid='" + array[0] + "'";
                String sqlOrgName = "select fname_" + ScrapOrderControllerBean.getLocale() + " as name from T_ORG_Storage where fid='" + array[1] + "'";
                String materialName = "";
                String orgName = "";
                IRowSet rs_m = DbUtil.executeQuery((Context)ctx, (String)sqlMaterialName);
                IRowSet rs_o = DbUtil.executeQuery((Context)ctx, (String)sqlOrgName);
                try {
                    while (rs_m != null && rs_m.next()) {
                        materialName = rs_m.getString("name");
                    }
                    while (rs_o != null && rs_o.next()) {
                        orgName = rs_o.getString("name");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                List tmpList = (List)crossOrgMap.get(materialOrg);
                for (int k = 0; k < tmpList.size(); ++k) {
                    String provideTypeName = MaterialProvideTypeEnum.getEnum((int)Integer.parseInt(tmpList.get(k).toString())).getAlias();
                    String msgInfo = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"MID_AUDIT_CHECK", (String[])new String[]{provideTypeName, materialName, orgName});
                    batchResults.addError(id, msgInfo);
                }
            }
        }
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            return new Locale("L2");
        }
    }

    private void unAuditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        this.checkUnCheckParam(ctx, batchResults);
        this.checkRelationBill(ctx, batchResults);
    }

    private void checkRelationBill(Context ctx, BatchActionResults batchResults) throws BOSException, SQLDataException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select distinct FSrcObjectID from t_bot_Relation ").append("where FSrcObjectID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            String msg = ScrapOrderControllerBean.getString(ctx, "HAS_FOLLOWBILL");
            while (rs != null && rs.next()) {
                batchResults.addError(rs.getString("FSrcObjectID"), msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkUnCheckParam(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        String msg = null;
        sqlBuffer.append("select T.FID COPOID, T.FStorageOrgUnitID StorageOrgUnitID ").append("from T_MM_ScrapOrder T ").append("where T.FID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        msg = ResourceBase.getString((String)"com.kingdee.eas.mm.planning.CooperatePlanOrderResource", (String)"PARAM_UNAUDIT_NOT_ALLOEWED", (Locale)ctx.getLocale());
        try {
            while (rs.next()) {
                boolean isUnAudit = false;
                String strAutoAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, rs.getString("StorageOrgUnitID"), this.getBillTypeId());
                if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equals("1")) {
                    isUnAudit = true;
                }
                if (isUnAudit) continue;
                batchResults.addError(rs.getString("COPOID"), msg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void auditOrUnAuditExecute(Context ctx, BatchActionResults batchResults, boolean isAudit) throws BOSException, EASBizException {
        try {
            this.billUpdate(ctx, batchResults, isAudit);
            if (batchResults.getToDoIdsArray().length == 0) {
                return;
            }
            this.updateFields(ctx, SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray()));
            this.sendRequirements(ctx, SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray()), isAudit);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void billUpdate(Context ctx, BatchActionResults batchResults, boolean isAudit) throws EASBizException, BOSException {
        ScrapOrderUpdaterMO billUpdater = new ScrapOrderUpdaterMO(ctx);
        billUpdater.setBatchResults(batchResults);
        billUpdater.setAuditAction(isAudit);
        billUpdater.execute();
    }

    private void sendRequirements(Context ctx, String ids, boolean isAudit) throws Exception {
        BizActionEnum bizAction = isAudit ? BizActionEnum.AUDIT : BizActionEnum.UNAUDIT;
        IReqPlanReceiveReqDataFacade reqPlanReceiveReqDataFacade = ReqPlanReceiveReqDataFacadeFactory.getLocalInstance((Context)ctx);
        reqPlanReceiveReqDataFacade.receiveReqPlanDate("YnsvoPSeRzCK0b/jEufQpkY+1VI=", ids, bizAction);
    }

    private String createTmpReqPlanDataTable(Context ctx) throws Exception {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append(" CREATE TABLE tmpReqPlanData (");
        createTableSQL.append(" FSrcBillID varchar(44),");
        createTableSQL.append(" FSrcBILLTYPEID varchar(44),");
        createTableSQL.append(" FSrcEntryID varchar(44),");
        createTableSQL.append(" fStorageOrgUnitID varchar(44),");
        createTableSQL.append(" fEntryStorageOrgUnitID varchar(44),");
        createTableSQL.append(" fBillID varchar(44),");
        createTableSQL.append(" FEntryID varchar(44),");
        createTableSQL.append(" fSeq INT DEFAULT 0 NOT NULL,");
        createTableSQL.append(" fNumber NVARCHAR(80),");
        createTableSQL.append(" FBILLTYPEID varchar(44),");
        createTableSQL.append(" fRequireDate DateTime,");
        createTableSQL.append(" fMaterialID varchar(44),");
        createTableSQL.append(" fUnitID varchar(44),");
        createTableSQL.append(" fBaseUnitID varchar(44),");
        createTableSQL.append(" fQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" fBaseQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" fOriginType INT,");
        createTableSQL.append(" fOperationType INT,");
        createTableSQL.append(" fCreatorID varchar(44),");
        createTableSQL.append(" fProjectID varchar(44),");
        createTableSQL.append(" fTrackNumberID varchar(44))");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL.toString());
    }

    private void releaseTempTable(Context ctx, String tableName) {
        if (!MMUtils.isEmptyString((String)tableName)) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tableName);
        }
    }

    public void updateFields(Context ctx, String ids) throws BOSException {
        String sql1 = "update T_MM_ScrapOrderEntry set FUnBaseBackQty = (FBaseScrapQty - FBaseBackQty)  where fparentid in (" + ids + ")";
        String sql2 = "update T_MM_ScrapOrderEntry set FUnBaseSuppliedQty = (FBaseSupplyRequiredQty-FBaseSuppliedQty) where FIsSupplyMaterial = 1 and fparentid in (" + ids + ")";
        DbUtil.execute((Context)ctx, (String)sql1);
        DbUtil.execute((Context)ctx, (String)sql2);
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.mo.ScrapOrderResource";
        return ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
    }

    private void afterSubmit(Context ctx, ScrapOrderInfo info) throws BOSException, EASBizException, SQLException {
        Object[] idStrArray = new String[]{info.getId().toString()};
        String idStr = SQLUtil.arrayToString((Object[])idStrArray);
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ScrapOrderEntry as t0  ").append("set FBaseUnitID = ").append("(select t2.fmeasureunitid from t_bd_multimeasureunit t2 ").append("where t0.FMaterialID = t2.FMaterialID  and t2.fisBasicUnit=1 ) ").append("where t0.FParentID in (").append(idStr).append(") ");
        sqls.add(updateSql.toString());
        updateSql.setLength(0);
        updateSql.append("update T_MM_ScrapOrderEntry as t0  ").append("set (FBaseScrapQty ,FBaseSupplyRequiredQty ,FBaseSuppliedQty,FBaseBackQty,FProductBaseQty) = ").append("(select round(decimal(t0.FScrapQty * decimal(t2.FBaseConvsRate, 21, 8),21,8),t3.FQtyPrecision) ").append(", round(decimal(t0.FSupplyRequiredQty * decimal(t2.FBaseConvsRate, 21, 8),21,8),t3.FQtyPrecision) ").append(", round(decimal(t0.FSuppliedQty * decimal(t2.FBaseConvsRate, 21, 8),21,8),t3.FQtyPrecision) ").append(",round(decimal(t0.FBackQty * decimal(t2.FBaseConvsRate, 21, 8),21,8),t3.FQtyPrecision) ").append(",round(decimal(t0.FProductQty * decimal(t2.FBaseConvsRate, 21, 8),21,8),t3.FQtyPrecision) ").append(" from t_bd_multimeasureunit t2 , T_MM_ScrapOrder t1 ,t_bd_multimeasureunit t3").append(" where t0.FParentID = t1.FID ").append(" and t0.FMaterialID = t2.FMaterialID and t0.FUnitID = t2.fmeasureunitid ").append(" and t0.FMaterialID = t3.FMaterialID and t0.FBaseUnitID = t3.fmeasureunitid ").append(" and t1.FID in (").append(idStr).append(") ").append(")");
        sqls.add(updateSql.toString());
        String headComOrgId = null;
        String orgId = info.getStorageOrgUnit().getId().toString();
        String querySql = "select t1.ftounitid from T_ORG_UnitRelation t1,T_ORG_TypeRelation t3 where  t1.ftyperelationid=t3.fid and t1.ffromunitID=? and t3.ffromtype=4 and t3.ftotype=1";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{orgId});
        while (rs.next()) {
            headComOrgId = rs.getString(1);
        }
        if (!MMUtils.isEmptyString(headComOrgId)) {
            updateSql.setLength(0);
            updateSql.append("update t_mm_scraporderentry  set fisspancomorg = 1 where fid in ").append("(select t1.fid from t_mm_scraporderentry t1,T_ORG_UnitRelation t2,T_ORG_TypeRelation t3 ").append("where t1.fparentid in (").append(idStr).append(") and t1.fprovidetype=10930 ").append("and t2.ftyperelationid=t3.fid and t2.ffromunitID=t1.FStorageOrgUnitID and t3.ffromtype=4 and t3.ftotype=1 ").append("and t2.ftounitid<>'").append(headComOrgId).append("')");
            sqls.add(updateSql.toString());
        }
        DBUtil.execBatchSql((Context)ctx, sqls, (boolean)true);
    }

    @Override
    protected void _log4PrintAction(Context ctx) throws BOSException {
        IObjectPK pklog = LogUtil.beginLog((Context)ctx, (String)"print", (BOSObjectType)new ScrapOrderInfo().getBOSType(), null, null, (String)"mm_scrapOrder_print");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
    }

    @Override
    protected void _materialWriteBack(Context ctx, String tempTableName, int bizAction, TransactionTypeInfo transTypeInfo) throws BOSException, EASBizException {
        MaterialWriteBackSO billUpdater = new MaterialWriteBackSO(ctx);
        billUpdater.setSourceDataTable(tempTableName);
        billUpdater.setAuditAction(bizAction == 103);
        billUpdater.setTransTypeInfo(transTypeInfo);
        billUpdater.setUpdateHead(false);
        billUpdater.execute();
    }

    private AdminOrgUnitInfo getDefaultAdminOrg(Context ctx, String orgID) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = iUser.getUserByID(ctx.getCaller());
        if (user == null || user.getPerson() == null || user.getPerson().getId() == null) {
            return null;
        }
        String personId = user.getPerson().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        SorterItemInfo sorterItem = new SorterItemInfo("isPrimary");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        AdminOrgUnitInfo adminOrg = null;
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection coll = iPositionMember.getPositionMemberCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            adminOrg = coll.get(0).getPosition().getAdminOrgUnit();
            StringBuffer sqlBuffer = new StringBuffer(128);
            sqlBuffer.append(" SELECT a.FToUnitID id FROM T_ORG_UnitRelation a ").append("   INNER JOIN T_ORG_TypeRelation b ").append("     ON a.FTypeRelationID = b.FID ").append(" WHERE a.FFromUnitID = ").append("'" + orgID + "'").append(" AND ").append("       a.FToUnitID = ").append("'" + adminOrg.getId().toString() + "'").append(" AND ").append("       b.FFromType = 4 AND b.FToType = 0");
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            if (rowSet == null || rowSet.size() <= 0) {
                adminOrg = null;
            }
        }
        return adminOrg;
    }

    private void markBOTPRelation(Context ctx, ScrapOrderInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        String srcBosType = new ManufactureOrderInfo().getBOSType().toString();
        String destBosType = new ScrapOrderInfo().getBOSType().toString();
        BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationByDestObjId(info.getId().toString(), srcBosType);
        ScrapOrderEntryCollection entryColl = info.getEntries();
        ScrapOrderEntryInfo entryInfo = null;
        ArrayList<String> srcObjectList = new ArrayList<String>();
        String srcObjectId = null;
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                entryInfo = entryColl.get(i);
                srcObjectId = entryInfo.getSourceBillId();
                if (srcObjectId == null || srcObjectId.equals("") || srcObjectList.contains(srcObjectId)) continue;
                srcObjectList.add(srcObjectId);
            }
            IBOTRelation iRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < srcObjectList.size(); ++i) {
                BOTRelationInfo relationInfo = new BOTRelationInfo();
                relationInfo.setSrcEntityID(srcBosType);
                relationInfo.setSrcObjectID((String)srcObjectList.get(i));
                relationInfo.setDestEntityID(destBosType);
                relationInfo.setDestObjectID(info.getId().toString());
                relationInfo.setDate(new Date());
                relationInfo.setOperatorID(ctx.getCaller().toString());
                relationInfo.setIsEffected(true);
                relationInfo.setType(1);
                iRelation.addnew(relationInfo);
            }
        }
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() <= 0) {
            return;
        }
        for (int curIdx = 0; curIdx < collection.size(); ++curIdx) {
            ScrapOrderEntryInfo curEntry;
            Iterator ite;
            ScrapOrderInfo curOrder = (ScrapOrderInfo)collection.getObject(curIdx);
            if (curOrder == null || curOrder.getEntries() == null || curOrder.getEntries().size() <= 0) continue;
            ScrapOrderEntryCollection curEntries = curOrder.getEntries();
            if (curOrder.getExtendedProperty("SRCBILLTYPE") != null && curOrder.getExtendedProperty("SRCBILLTYPE").equals("671")) {
                ite = curEntries.iterator();
                while (ite.hasNext()) {
                    curEntry = (ScrapOrderEntryInfo)ite.next();
                    if (curEntry.getScrapQty() == null || curEntry.getScrapQty().compareTo(SysConstant.BIGZERO) <= 0) {
                        ite.remove();
                        continue;
                    }
                    if (curEntry.getUnitQty() == null || curEntry.getUnitQty().compareTo(SysConstant.BIGZERO) <= 0 || curEntry.getUnitBaseQty() == null || curEntry.getUnitBaseQty().compareTo(SysConstant.BIGZERO) <= 0) continue;
                    curEntry.setProductQty(curEntry.getScrapQty().divide(curEntry.getUnitQty()).setScale(8, 4));
                    curEntry.setProductBaseQty(curEntry.getBaseScrapQty().divide(curEntry.getUnitBaseQty()).setScale(8, 4));
                }
            } else {
                ite = curEntries.iterator();
                while (ite.hasNext()) {
                    curEntry = (ScrapOrderEntryInfo)ite.next();
                    if (!curEntry.getScrapType().equals((Object)ScrapTypeEnum.BecauseOfWork)) {
                        ite.remove();
                        continue;
                    }
                    curEntry.setScrapQty(null);
                }
            }
            StringBuffer moIds = new StringBuffer(64);
            moIds.append(" '-1' ");
            HashMap<String, String> moMap = new HashMap<String, String>();
            Iterator ite2 = curEntries.iterator();
            while (ite2.hasNext()) {
                ScrapOrderEntryInfo curEntry2 = (ScrapOrderEntryInfo)ite2.next();
                if (moMap.containsKey(curEntry2.getSourceBillId())) continue;
                moMap.put(curEntry2.getSourceBillId(), curEntry2.getSourceBillId());
                moIds.append(", '");
                moIds.append(curEntry2.getSourceBillId());
                moIds.append("'");
            }
            CoreBaseCollection technics = ManufactureOrderTechnicsFactory.getLocalInstance(ctx).getCollection("where parent in (" + moIds.toString() + ")");
            if (technics == null || technics.size() <= 0) {
                return;
            }
            HashMap<String, ManufactureOrderTechnicsInfo> opNumTechMap = new HashMap<String, ManufactureOrderTechnicsInfo>();
            String curKey = null;
            for (int curTechIdx = 0; curTechIdx < technics.size(); ++curTechIdx) {
                ManufactureOrderTechnicsInfo curTechInfo = (ManufactureOrderTechnicsInfo)technics.get(curTechIdx);
                curKey = curTechInfo.getParent().getId().toString() + "@" + curTechInfo.getOperationNo();
                opNumTechMap.put(curKey, curTechInfo);
            }
            for (int entryIdx = 0; entryIdx < curEntries.size(); ++entryIdx) {
                ScrapOrderEntryInfo curEntry3 = curEntries.get(entryIdx);
                int curOpNum = curEntry3.getOperationNo();
                if (curOpNum <= 0 || !opNumTechMap.containsKey(curKey = curEntry3.getSourceBillId() + "@" + curOpNum)) continue;
                ManufactureOrderTechnicsInfo tarTech = (ManufactureOrderTechnicsInfo)opNumTechMap.get(curKey);
                curEntry3.setProcessOrgUnit(tarTech.getStorageOrgUnit());
                curEntry3.setProcessDept(tarTech.getAdminOrgUnit());
                curEntry3.setTechnic(tarTech);
            }
        }
    }
}

