/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ScrapOrderException;
import com.kingdee.eas.mm.mo.app.MOFinish;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public class ScrapOrderUpdaterMO
extends BillUpdater {
    public ScrapOrderUpdaterMO(Context ctx) {
        super(ctx);
    }

    private String createTempTable(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("CREATE TABLE ls (").append("FBillID varchar(44) null,").append("FSourceBillID varchar(44) null,").append("FSourceBillEntryId varchar(44) null,").append("FBaseQty numeric(21,8) not null default 0, ").append("FQty numeric(21,8) not null default 0, ").append("FSeq INT not null default 0, ").append("FScrapType INT not null default -1 ").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    public void execute() throws BOSException, EASBizException {
        String tempTable = this.createTempTable(this.ctx);
        IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(this.ctx);
        this.setTargetTable("T_MM_MFTOrderStock");
        this.setSourceDataTable(tempTable);
        this.setTransfUnit(true);
        this.setUpdateHead(false);
        String autofinish_tempTable = this.createTempTable(this.ctx);
        String insert_data = " insert into " + autofinish_tempTable + " ( FBillID, FSourceBillID )  ( select so.fid, so.FSourceBillID from T_MM_ScrapOrder as so  where so.fid in (" + SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray()) + " ) )";
        DbUtil.execute((Context)this.ctx, (String)insert_data);
        if (this.isAuditAction) {
            this.updateTempTable(tempTable, null);
            if (!this.hasContent(tempTable)) {
                return;
            }
            this.setUnBaseQtyExpression("FActIssueBaseQty+FFeedingBaseQty+FMaterialFeedingBaseQty-FRejectedBaseQty-FScrapBaseQty-FMaterialScrapBaseQty");
            this.qtyCheck();
            if (this.batchResults.getToDoIdsArray().length == 0) {
                return;
            }
            this.executeWriteBack(tempTable, moBiz, 10, this.isAuditAction);
            this.executeWriteBack(tempTable, moBiz, 20, this.isAuditAction);
            MOFinish.moDefaultUnAutoFinish(this.ctx, autofinish_tempTable);
        } else {
            if (this.batchResults.getToDoIdsArray().length == 0) {
                return;
            }
            this.executeWriteBack(tempTable, moBiz, 10, this.isAuditAction);
            this.executeWriteBack(tempTable, moBiz, 20, this.isAuditAction);
            MOFinish.autoFinish(this.ctx, autofinish_tempTable, true);
        }
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        pool.releaseTable(this.sourceDataTable);
        pool.releaseTable(autofinish_tempTable);
    }

    private void executeWriteBack(String tempTable, IManufactureOrder moBiz, int scrapType, boolean isAuditAction) throws BOSException, EASBizException {
        this.deleteTempTableRow(tempTable);
        this.updateTempTable(tempTable, new Integer(scrapType));
        if (!this.hasContent(tempTable)) {
            return;
        }
        if (10 == scrapType) {
            this.setBaseQtyFields(new String[]{"FScrapBaseQty"});
            this.setQtyFields(new String[]{"FScrapQty"});
        } else if (20 == scrapType) {
            this.setBaseQtyFields(new String[]{"FMaterialScrapBaseQty"});
            this.setQtyFields(new String[]{"FMaterialScrapQty"});
        }
        if (isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+"});
            this.setQtyOperation(new String[]{"+"});
        } else {
            this.setBaseQtyOperation(new String[]{"-"});
            this.setQtyOperation(new String[]{"-"});
        }
        this.writeBack();
        moBiz.calculateWIP(this.sourceDataTable);
    }

    private void deleteTempTableRow(String tableName) throws BOSException {
        String delSql = "delete from " + tableName;
        String[] str = new String[]{delSql};
        DBUtil.execute((Context)this.ctx, (String[])str);
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        boolean ret = true;
        String expr = this.compileExpr(this.unBaseQtyExpression);
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select FBillID,FScrapType,FSeq from ");
        sqlBuf.append(this.sourceDataTable).append(" t0 ").append("inner join (").append("select t1.FID from ").append(this.targetTable).append(" t1  ").append("inner join (select tt.").append(this.getFID()).append(" FSRCID,sum(tt.FBaseQty) sum_baseqty from ").append(this.sourceDataTable).append(" tt ").append("group by ").append(this.getFID()).append(") t2 ").append("on t1.FID = t2.FSRCID and ").append(expr).append(" < t2.sum_baseqty ").append(") t20 on t0.").append(this.getFID()).append(" = t20.FID ").append("where t20.FID is not null ").append(" order by  FBillID,FSeq ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            int i = 0;
            HashMap<String, String> errMap = new HashMap<String, String>();
            HashMap<String, String> errSeqMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                String billID = rs.getString("FBillID");
                if (!errMap.containsKey(billID)) {
                    errMap.put(billID, "1");
                    ++i;
                    errSeqMap.put(billID, " " + rs.getInt("Fseq"));
                    continue;
                }
                errSeqMap.put(billID, (String)errSeqMap.get(billID) + "," + rs.getInt("Fseq"));
            }
            if (i > 0) {
                Iterator iter = errMap.keySet().iterator();
                Object[] seq = null;
                String billID = null;
                while (iter.hasNext()) {
                    billID = (String)iter.next();
                    seq = new String[]{(String)errSeqMap.get(billID)};
                    this.batchResults.addError(billID, (Exception)((Object)new ScrapOrderException(ScrapOrderException.SCRAPQTY_MORE_OTHERQTY, seq)));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ret;
    }

    private String compileExpr(String expr) {
        char[] expChars = expr.toCharArray();
        StringBuffer expBuf = new StringBuffer();
        for (int i = 0; i < expChars.length; ++i) {
            if ((expChars[i] >= 'a' && expChars[i] <= 'z' || expChars[i] >= 'A' && expChars[i] <= 'Z') && (i == 0 || i > 0 && (expChars[i - 1] == '+' || expChars[i - 1] == '-' || expChars[i - 1] == ' ' || expChars[i - 1] == '('))) {
                expBuf.append("t1.");
            }
            expBuf.append(expChars[i]);
        }
        return expBuf.toString();
    }

    private void updateTempTable(String tempTable, Integer scrapType) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        String idStr = SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray());
        updateSql.append("insert into ").append(tempTable).append(" (FBillID,FSourceBillID,FSourceBillEntryId ,FBaseQty,FQty,FSeq,FScrapType)").append("select t0.fid,t0.FSourceBillID,t1.FSourceBillEntryID,t1.FBaseScrapQty,FScrapQty,t1.FSeq,t1.FScrapType ").append("from  T_MM_ScrapOrder as t0,T_MM_ScrapOrderEntry as t1 ").append("where t0.fid=t1.fparentid ").append("and fparentid in (").append(idStr).append(") and t0.FSourceBillTypeID is not null ");
        if (scrapType != null) {
            updateSql.append(" and t1.FScrapType = " + scrapType);
        } else {
            updateSql.append(" and t1.FScrapType in (").append(10).append(",").append(20).append(") ");
        }
        MRPUtil.executeUpdate((Context)this.ctx, (String)updateSql.toString());
    }

    private boolean hasContent(String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) from ").append(tempTable);
        int count = 0;
        try {
            IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (count > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

