/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.STCalcParamInfo;
import com.kingdee.eas.mm.mo.STRuleEnum;
import com.kingdee.eas.mm.mo.STSourceInfo;
import com.kingdee.eas.mm.mo.STStockInfo;
import com.kingdee.eas.mm.mo.app.AbstractStockTransactionEditFacadeControllerBean;
import com.kingdee.eas.mm.mo.app.STCalculation;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockTransactionEditFacadeControllerBean
extends AbstractStockTransactionEditFacadeControllerBean {
    private static final long serialVersionUID = -1128566176449183532L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.StockTransactionEditFacadeControllerBean");
    private static StringBuffer precisionSql = new StringBuffer();
    private static List keyIdList = new ArrayList();
    private static Map precisionMap = new HashMap();
    private static final BigDecimal ZERO = SysConstant.BIGZERO;

    @Override
    protected List _sTSourceList(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, List orderIds, int stRule) throws BOSException, EASBizException {
        List resultList = this.getMOCollByOrderIds(ctx, storageOrgUnitInfo, orderIds, stRule);
        return resultList;
    }

    private String getStrIds(List orderIds) {
        StringBuffer st = new StringBuffer();
        if (orderIds != null && orderIds.size() > 0) {
            for (String orderId : orderIds) {
                st.append(orderId);
                st.append(",");
            }
            return st.substring(0, st.toString().length() - 1);
        }
        return "";
    }

    protected List getMOCollByOrderIds(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, List orderIds, int stRule) throws BOSException, EASBizException {
        ArrayList<Object> resultList = new ArrayList<Object>();
        String ids = this.getStrIds(orderIds);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSelectors());
        viewInfo.setFilter(this.getFilter(storageOrgUnitInfo, ids));
        viewInfo.setSorter(this.getSorter());
        IManufactureOrder manuOrder = ManufactureOrderFactory.getLocalInstance(ctx);
        ManufactureOrderCollection mnfOrderCollection = manuOrder.getManufactureOrderCollection(viewInfo);
        this.setPrecisionMap(ctx, mnfOrderCollection);
        Object[] objects = this.getStockColl(mnfOrderCollection, ctx);
        resultList.add((Object)mnfOrderCollection);
        resultList.add(objects[0]);
        resultList.add(precisionMap);
        resultList.add(objects[1]);
        return resultList;
    }

    private void setPrecisionMap(Context ctx, ManufactureOrderCollection mnfOrderCollection) throws BOSException {
        if (mnfOrderCollection != null && mnfOrderCollection.size() > 0) {
            Iterator it = mnfOrderCollection.iterator();
            while (it.hasNext()) {
                ManufactureOrderInfo mnfOrderInfo = (ManufactureOrderInfo)it.next();
                String materialId = mnfOrderInfo.getMaterial().getId().toString();
                String unitId = mnfOrderInfo.getUnit().getId().toString();
                this.buildSql(materialId, unitId);
                ManufactureOrderStockCollection mnfOrderStockCollection = mnfOrderInfo.getStocks();
                if (mnfOrderStockCollection == null || mnfOrderStockCollection.size() <= 0) continue;
                for (int i = 0; i < mnfOrderStockCollection.size(); ++i) {
                    ManufactureOrderStockInfo mnfOrderStockInfo = mnfOrderStockCollection.get(i);
                    this.buildSql(mnfOrderStockInfo.getMaterial().getId().toString(), mnfOrderStockInfo.getUnit().getId().toString());
                }
            }
        }
        this.executePrecisionSql(ctx);
    }

    private void buildSql(String materialId, String unitId) {
        StringBuffer key = new StringBuffer();
        key.append(materialId);
        key.append(unitId);
        if (!keyIdList.contains(key.toString())) {
            keyIdList.add(key.toString());
            if (precisionSql.length() > 0) {
                precisionSql.append("or ");
            }
            precisionSql.append("(material.id = '").append(materialId).append("' and measureUnit.id = '").append(unitId).append("' ) ");
        }
    }

    private void executePrecisionSql(Context ctx) throws BOSException {
        MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(" where " + precisionSql.toString());
        int precision = 0;
        String materialId = "";
        String unitId = "";
        String key = "";
        for (int i = 0; i < mmuc.size(); ++i) {
            precision = mmuc.get(i).getQtyPrecision();
            materialId = mmuc.get(i).getMaterial().getId().toString();
            unitId = mmuc.get(i).getMeasureUnit().getId().toString();
            key = materialId + unitId;
            precisionMap.put(key, new Integer(precision));
        }
    }

    protected Object[] getStockColl(ManufactureOrderCollection mnfOrderCollection, Context ctx) throws BOSException, EASBizException {
        Object[] objects = new Object[2];
        HashMap<String, STSourceInfo> sTSourceMap = new HashMap<String, STSourceInfo>();
        HashMap<String, STStockInfo> sTStockCalMap = new HashMap<String, STStockInfo>();
        Iterator it = mnfOrderCollection.iterator();
        while (it.hasNext()) {
            ManufactureOrderInfo mnfOrderInfo = (ManufactureOrderInfo)it.next();
            STSourceInfo stSourceInfo = new STSourceInfo();
            ManufactureOrderStockCollection mnfOrderStockCollection = mnfOrderInfo.getStocks();
            BigDecimal maxBaseReceiptQty = ZERO;
            BigDecimal minBaseReceiptQty = ZERO;
            if (mnfOrderStockCollection != null && mnfOrderStockCollection.size() > 0) {
                int count = 0;
                for (int i = 0; i < mnfOrderStockCollection.size(); ++i) {
                    ManufactureOrderStockInfo mnfOrderStockInfo = mnfOrderStockCollection.get(i);
                    STStockInfo stStockInfo = new STStockInfo();
                    boolean isStockAllot = mnfOrderStockInfo.isIsStockAllot();
                    MaterialIssueModeEnum issueMode = mnfOrderStockInfo.getIssueMode();
                    MaterialProvideTypeEnum provideType = mnfOrderStockInfo.getProvideType();
                    if (!isStockAllot || issueMode != MaterialIssueModeEnum.PRODUCEISSMODE || provideType != MaterialProvideTypeEnum.CURRENTORGPROVIDE && provideType != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) continue;
                    stStockInfo.setStockEntryInfo(mnfOrderStockInfo);
                    BigDecimal unitQty = mnfOrderStockInfo.getUnitQty();
                    BigDecimal unitBaseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)mnfOrderStockInfo.getMaterial().getId().toString(), (MeasureUnitInfo)mnfOrderStockInfo.getUnit(), (MeasureUnitInfo)mnfOrderStockInfo.getMaterial().getBaseUnit(), (BigDecimal)unitQty);
                    BigDecimal totalBaseReceiptQty = mnfOrderStockInfo.getTotalReceiptBaseQty();
                    this.setParentInfo(mnfOrderInfo, mnfOrderStockInfo);
                    if (totalBaseReceiptQty == null) {
                        totalBaseReceiptQty = ZERO;
                    }
                    stStockInfo.setOrderId(mnfOrderInfo.getId().toString());
                    stStockInfo.setStockEntryId(mnfOrderStockInfo.getId().toString());
                    int billType = 1;
                    Object[] pAndT = StoreCommonUtil.getProjectNumberAndTrackNumber((Context)ctx, (ProjectInfo)mnfOrderInfo.getProject(), (TrackNumberInfo)mnfOrderInfo.getTrackNumber(), (String)mnfOrderInfo.getStorageOrgUnit().getId().toString(), (String)mnfOrderStockInfo.getMaterial().getId().toString(), (int)billType);
                    ProjectInfo pi = (ProjectInfo)pAndT[0];
                    TrackNumberInfo ti = (TrackNumberInfo)pAndT[1];
                    stStockInfo.setProjectId(pi != null && pi.getId() != null ? pi.getId().toString() : null);
                    stStockInfo.setProjectInfo(pi);
                    stStockInfo.setTrackNumId(ti != null && ti.getId() != null ? ti.getId().toString() : null);
                    stStockInfo.setTrackNumberInfo(ti);
                    sTStockCalMap.put(mnfOrderStockInfo.getId().toString(), stStockInfo);
                    BigDecimal unitBaseQtyDivTR = ZERO;
                    if (totalBaseReceiptQty.compareTo(ZERO) > 0 && unitBaseQty.compareTo(ZERO) != 0) {
                        unitBaseQtyDivTR = totalBaseReceiptQty.divide(unitBaseQty, 8, 4);
                    }
                    if (count == 0) {
                        maxBaseReceiptQty = unitBaseQtyDivTR;
                        minBaseReceiptQty = unitBaseQtyDivTR;
                    } else {
                        if (unitBaseQtyDivTR.compareTo(maxBaseReceiptQty) > 0) {
                            maxBaseReceiptQty = unitBaseQtyDivTR;
                        }
                        if (unitBaseQtyDivTR.compareTo(minBaseReceiptQty) < 0) {
                            minBaseReceiptQty = unitBaseQtyDivTR;
                        }
                    }
                    ++count;
                }
            }
            stSourceInfo.setOrderId(mnfOrderInfo.getId().toString());
            stSourceInfo.setPrdId(mnfOrderInfo.getMaterial().getId().toString());
            stSourceInfo.setUnitId(mnfOrderInfo.getUnit().getId().toString());
            stSourceInfo.setBsUnitId(mnfOrderInfo.getMaterial().getBaseUnit().getId().toString());
            stSourceInfo.setProjectId(mnfOrderInfo.getProject() != null && mnfOrderInfo.getProject().getId() != null ? mnfOrderInfo.getProject().getId().toString() : null);
            stSourceInfo.setTrackNumId(mnfOrderInfo.getTrackNumber() != null && mnfOrderInfo.getTrackNumber().getId() != null ? mnfOrderInfo.getTrackNumber().getId().toString() : null);
            stSourceInfo.setBsMaxReceiptQty(maxBaseReceiptQty.setScale(0, 4));
            stSourceInfo.setBsMinReceiptQty(minBaseReceiptQty.setScale(0, 4));
            stSourceInfo.setMaxReceiptQty(maxBaseReceiptQty.setScale(0, 4));
            stSourceInfo.setMinReceiptQty(minBaseReceiptQty.setScale(0, 4));
            sTSourceMap.put(mnfOrderInfo.getId().toString(), stSourceInfo);
        }
        objects[0] = sTSourceMap;
        objects[1] = sTStockCalMap;
        return objects;
    }

    private void setParentInfo(ManufactureOrderInfo mnfOrderInfo, ManufactureOrderStockInfo mnfOrderStockInfo) {
        mnfOrderStockInfo.setParent(mnfOrderInfo);
    }

    protected FilterInfo getFilter(StorageOrgUnitInfo storageOrgUnitInfo, String ids) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemCollection = filter.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        if (storageOrgUnitInfo != null) {
            filterItemCollection.add(new FilterItemInfo("storageOrgUnit", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    protected SorterItemCollection getSorter() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("planBeginDate"));
        sorter.add(new SorterItemInfo("number"));
        return sorter;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("trackNumber.*"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("routing.*"));
        sic.add(new SelectorItemInfo("transactionType.name"));
        sic.add(new SelectorItemInfo("dispatcher.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("baseUnit.*"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("replaceMaterial.name"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit1.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit1.id"));
        sic.add(new SelectorItemInfo("stocks.material.*"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.*"));
        sic.add(new SelectorItemInfo("stocks.unit.*"));
        sic.add(new SelectorItemInfo("stocks.material.assistUnit.*"));
        sic.add(new SelectorItemInfo("stocks.warehouse.name"));
        sic.add(new SelectorItemInfo("stocks.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("stocks.warehouse.number"));
        sic.add(new SelectorItemInfo("stocks.warehouse.id"));
        sic.add(new SelectorItemInfo("stocks.location.id"));
        sic.add(new SelectorItemInfo("stocks.location.number"));
        sic.add(new SelectorItemInfo("stocks.location.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stocks.workcenter.number"));
        sic.add(new SelectorItemInfo("stocks.operationNo"));
        sic.add(new SelectorItemInfo("stocks.workcenter.id"));
        sic.add(new SelectorItemInfo("stocks.workcenter.name"));
        sic.add(new SelectorItemInfo("stocks.operation.number"));
        sic.add(new SelectorItemInfo("stocks.operation.name"));
        sic.add(new SelectorItemInfo("stocks.operation.id"));
        sic.add(new SelectorItemInfo("defaultWarehous.name"));
        sic.add(new SelectorItemInfo("defaultWarehous.number"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.receiptStroageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stocks.receiptStroageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.receiptStroageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stocks.receiptStock.id"));
        sic.add(new SelectorItemInfo("stocks.receiptStock.name"));
        sic.add(new SelectorItemInfo("stocks.receiptStock.number"));
        return sic;
    }

    @Override
    protected Map _sTCalculate(Context ctx, ManufactureOrderCollection mnfOrderCollection, Map sTStockCalMap, Map sTSourceMap, Map sTSourceReBaseQtyMap, STCalcParamInfo calcParam, STRuleEnum ruleEnum, String storageUnitId) throws BOSException, EASBizException {
        STCalculation calculation = new STCalculation(calcParam, ruleEnum, sTSourceReBaseQtyMap, storageUnitId);
        Map resultMap = calculation.sTCalculate(ctx, mnfOrderCollection, sTStockCalMap, sTSourceMap);
        return resultMap;
    }

    @Override
    protected Map _prepareDestBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        STCalculation calculation = new STCalculation();
        return calculation.prepareDestBill(ctx, paramMap);
    }

    @Override
    protected void _generateDestBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        STCalculation calculation = new STCalculation();
        calculation.generateDestBill(ctx, paramMap);
    }

    @Override
    protected void _deleteDestBill(Context ctx, Map billMap) throws BOSException, EASBizException {
        STCalculation calculation = new STCalculation();
        calculation.deleteDestBill(ctx, billMap);
    }
}

