/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.mo.app.release.enhancement.MMLoadDataService;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ClearReferenceProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ExpectOutputsProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.LotProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.MOHeaderDataProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ManufactureOrderSubmitProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.MaterialInventoryProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.MaterialPlanProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.ProductTransactionProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.SchedulProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.StockProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.processor.impl.TechnicsProcessor;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ProcessorRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.SqlDataLoaderRequestQueue;
import org.apache.log4j.Logger;

public class PlanningOrderReleaseMO {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.PlanningOrderReleaseMO");

    public BatchActionResults doit(Context ctx, IObjectCollection collection) throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        logger.info((Object)"------------------------------------------------------------------------");
        logger.info((Object)("befor doing memeory is: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + " M "));
        logger.info((Object)("collection size= " + collection.size()));
        logger.info((Object)("mo release begin at: " + begin));
        ctx.put((Object)"dynaNum", (Object)new Integer(100));
        ObjectDataLoaderRequestQueue objectDataLoaderRequestQueue = null;
        SqlDataLoaderRequestQueue sqlDataLoaderRequestQueue = null;
        ProcessorRequestQueue processorRequestQueue = null;
        if (!MMLoadDataService.isInitial()) {
            int[] threadCount = this.initThreadCount(collection);
            if (0 < threadCount[0]) {
                objectDataLoaderRequestQueue = new ObjectDataLoaderRequestQueue(threadCount[0]);
            }
            if (0 < threadCount[1]) {
                sqlDataLoaderRequestQueue = new SqlDataLoaderRequestQueue(threadCount[1]);
            }
            if (0 < threadCount[2]) {
                processorRequestQueue = new ProcessorRequestQueue(threadCount[2]);
            }
        } else {
            objectDataLoaderRequestQueue = MMLoadDataService.getObjectDataLoaderRequestQueue();
            sqlDataLoaderRequestQueue = MMLoadDataService.getSqlDataLoaderRequestQueue();
            processorRequestQueue = MMLoadDataService.getProcessorRequestQueue();
        }
        try {
            if (!MMLoadDataService.isInitial()) {
                if (null != objectDataLoaderRequestQueue) {
                    objectDataLoaderRequestQueue.startThreads();
                }
                if (null != sqlDataLoaderRequestQueue) {
                    sqlDataLoaderRequestQueue.startThreads();
                }
                if (null != processorRequestQueue) {
                    processorRequestQueue.startThreads();
                }
            }
            MaterialPlanProcessor materialPlanProcessor = new MaterialPlanProcessor(ctx, collection, objectDataLoaderRequestQueue);
            materialPlanProcessor.doing();
            MaterialInventoryProcessor materialInventoryProcessor = new MaterialInventoryProcessor(ctx, collection, objectDataLoaderRequestQueue);
            materialInventoryProcessor.doing();
            ProductTransactionProcessor productTransactionProcessor = new ProductTransactionProcessor(ctx, collection, objectDataLoaderRequestQueue);
            productTransactionProcessor.doing();
            MOHeaderDataProcessor mOHeaderDataProcessor = new MOHeaderDataProcessor(ctx, collection, objectDataLoaderRequestQueue);
            mOHeaderDataProcessor.doing();
            TechnicsProcessor technicsProcessor = new TechnicsProcessor(ctx, collection, objectDataLoaderRequestQueue, processorRequestQueue);
            technicsProcessor.doing();
            StockProcessor stockProcessor = new StockProcessor(ctx, collection, objectDataLoaderRequestQueue, sqlDataLoaderRequestQueue, processorRequestQueue);
            stockProcessor.doing();
            ExpectOutputsProcessor expectOutputsProcessor = new ExpectOutputsProcessor(ctx, collection);
            expectOutputsProcessor.doing();
            String[] cleanItems = new String[]{"pBom_ex", "materialPlan_ex", "bomEntryInfo_ex", "multimeasureunit_ex"};
            ClearReferenceProcessor releaseMemoryProcessor = new ClearReferenceProcessor(ctx, collection, cleanItems);
            releaseMemoryProcessor.doing();
            SchedulProcessor schedulProcessor = new SchedulProcessor(ctx, collection);
            schedulProcessor.doing();
            LotProcessor lotProcessor = new LotProcessor(ctx, collection);
            lotProcessor.doing();
            logger.info((Object)("mo release before submit  at: " + System.currentTimeMillis() + " total spend: " + (System.currentTimeMillis() - begin) / 1000L + " S"));
            logger.info((Object)("mo release before submit  memeory is: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + " M "));
            BatchActionResults result = this.submitMo(ctx, collection, processorRequestQueue);
            logger.info((Object)("mo release end at: " + System.currentTimeMillis() + " total spend: " + (System.currentTimeMillis() - begin) / 1000L + " S"));
            logger.info((Object)("mo release end memeory is: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + " M "));
            BatchActionResults batchActionResults = result;
            return batchActionResults;
        }
        catch (Exception e) {
            logger.info((Object)("mo release catch unhandle exception: " + e.getMessage()));
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)"mo release execute finally");
            if (!MMLoadDataService.isInitial()) {
                if (null != objectDataLoaderRequestQueue) {
                    objectDataLoaderRequestQueue.stopThreads();
                }
                if (null != sqlDataLoaderRequestQueue) {
                    sqlDataLoaderRequestQueue.stopThreads();
                }
                if (null != processorRequestQueue) {
                    processorRequestQueue.stopThreads();
                }
            }
            ctx.put((Object)"isPlannedOrderRelease", (Object)new Boolean(false));
        }
    }

    public BatchActionResults submitMo(Context ctx, IObjectCollection collection, ProcessorRequestQueue processorRequestQueue) throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        logger.info((Object)("mo submit begin at: " + begin));
        ManufactureOrderSubmitProcessor submitMoProcessor = new ManufactureOrderSubmitProcessor(ctx, collection, processorRequestQueue);
        submitMoProcessor.doing();
        logger.info((Object)("mo submit end at: " + System.currentTimeMillis() + " total spend: " + (System.currentTimeMillis() - begin) / 1000L + " S"));
        return submitMoProcessor.getResults();
    }

    protected int[] initThreadCount(IObjectCollection collection) {
        if (null == collection || 50 >= collection.size()) {
            return new int[]{0, 0, 0};
        }
        return new int[]{3, 2, 2};
    }
}

