/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.DataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractDataLoader
implements DataLoader {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractDataLoader");
    protected static final int MAXSIZE = 100;
    protected Context ctx;
    protected int index;
    protected Map result = new HashMap();
    protected List futureList = new ArrayList();
    protected Map dumpMap = new HashMap();

    public AbstractDataLoader(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void loadData() throws EASBizException, BOSException {
        if (0 < this.index) {
            Future future = this.loading();
            this.futureList.add(future);
        }
    }

    public abstract Future loading() throws EASBizException, BOSException;

    public abstract void dealResult(Future var1) throws EASBizException, BOSException;

    @Override
    public Map getResultMap() throws EASBizException, BOSException {
        logger.info((Object)(this.getLogDesc() + " begin waiting future and future size[" + this.futureList.size() + "]"));
        int count = this.futureList.size();
        for (int i = 0; i < count; ++i) {
            Future future = (Future)this.futureList.get(i);
            logger.info((Object)(this.getLogDesc() + " begin waiting future[" + String.valueOf(i) + "]"));
            this.dealResult(future);
            logger.info((Object)(this.getLogDesc() + " end waiting future[" + String.valueOf(i) + "]"));
        }
        return this.result;
    }

    protected void clear() {
        this.index = 0;
    }

    protected int getMaxSize() {
        return 100;
    }

    public String getLogDesc() {
        String str = this.getClass().getName();
        int i = str.lastIndexOf(".");
        str = str.substring(i + 1, str.length());
        str = "thread is: " + Thread.currentThread().getName() + " dataloader is: " + str + " ";
        return str;
    }

    public Context getCtx() {
        return this.ctx;
    }
}

