/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.ObjectDataLoaderRequestQueue;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.request.ObjectDataLoaderRequest;
import org.apache.log4j.Logger;

public abstract class AbstractObjectDataLoader
extends AbstractDataLoader {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractObjectDataLoader");
    protected EntityViewInfo view = new EntityViewInfo();
    protected FilterInfo filter = new FilterInfo();
    protected FilterInfo fixedFilter = new FilterInfo();
    protected StringBuffer mask = new StringBuffer();
    protected SelectorItemCollection selector;
    protected SorterItemCollection sorter;
    protected ObjectDataLoaderRequestQueue requestQueue;

    public AbstractObjectDataLoader(Context ctx) {
        super(ctx);
    }

    public AbstractObjectDataLoader(Context ctx, SelectorItemCollection selector) {
        super(ctx);
        if (null == selector) {
            this.selector = new SelectorItemCollection();
            this.selector.add(new SelectorItemInfo("id"));
        } else {
            this.selector = selector;
        }
    }

    public AbstractObjectDataLoader(Context ctx, SelectorItemCollection selector, ObjectDataLoaderRequestQueue requestQueue) {
        this(ctx, selector);
        this.requestQueue = requestQueue;
    }

    public abstract IObjectCollection getCollection(EntityViewInfo var1) throws EASBizException, BOSException;

    @Override
    public Future loading() throws EASBizException, BOSException {
        Future future = new Future();
        FilterInfo filter1 = (FilterInfo)this.filter.clone();
        SelectorItemCollection selector1 = (SelectorItemCollection)this.selector.clone();
        String mask1 = this.mask.toString();
        ObjectDataLoaderRequest request = new ObjectDataLoaderRequest(future, this, filter1, selector1, mask1);
        if (null != this.requestQueue) {
            logger.info((Object)(this.getLogDesc() + " main thread user blockedQueue! "));
            try {
                this.requestQueue.putRequest(request);
            }
            catch (InterruptedException e) {
                logger.info((Object)(this.getLogDesc() + " ERROR:"), (Throwable)e);
                logger.info((Object)(this.getLogDesc() + " main thread put request error: " + e.getMessage()));
                future.setException(e);
            }
        } else {
            logger.info((Object)(this.getLogDesc() + " main thread user itselef! "));
            request.doing();
        }
        return future;
    }

    @Override
    protected void clear() {
        super.clear();
        this.view = new EntityViewInfo();
        this.filter = new FilterInfo();
        this.mask = new StringBuffer();
    }

    public void setFixedFilter(FilterInfo fixedFilter) {
        this.fixedFilter = fixedFilter;
    }

    public FilterInfo getFixedFilter() {
        return this.fixedFilter;
    }

    public SorterItemCollection getSorter() {
        return this.sorter;
    }

    public void setSorter(SorterItemCollection sorter) {
        this.sorter = sorter;
    }
}

