/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.mo.app.release.enhancement.dataloader.AbstractSqlDataLoader;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.future.Future;
import com.kingdee.eas.mm.mo.app.release.enhancement.threadsupport.queue.SqlDataLoaderRequestQueue;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class BomExpendTempTableDataLoader
extends AbstractSqlDataLoader {
    public static final String SELECTSQL = "SELECT * FROM TABLE WHERE ";
    public static final String BASEQTY = "baseQty_ex";
    public static final String UNITQTY = "unitQty_ex";
    public static final String DEMANDDATE = "demandDate_ex";
    String tempTableName;
    public static final String TRACKID = "trackId";

    public BomExpendTempTableDataLoader(Context ctx, String tempTableName) {
        super(ctx);
        this.tempTableName = tempTableName;
    }

    public BomExpendTempTableDataLoader(Context ctx, String tempTableName, SqlDataLoaderRequestQueue requestQueue) {
        super(ctx, requestQueue);
        this.tempTableName = tempTableName;
    }

    public BomExpendTempTableDataLoader setCondition(String trackId) throws EASBizException, BOSException {
        if (this.canAdd(trackId)) {
            if (this.getMaxSize() == this.index) {
                this.loadData();
                this.clear();
            }
            if (this.sb.length() > 0) {
                this.sb.append(" OR ");
            }
            this.sb.append(" FTraceID = '" + trackId + "'");
            ++this.index;
        }
        return this;
    }

    protected boolean canAdd(String trackId) {
        return !EmptyUtil.isEmpty((String)trackId) && !this.checkDump(trackId);
    }

    protected boolean checkDump(String trackId) {
        boolean flag = false;
        if (this.dumpMap.containsKey(trackId)) {
            flag = true;
        } else {
            this.dumpMap.put(trackId, null);
        }
        return flag;
    }

    @Override
    public String getSelectSql(String sql) {
        return SELECTSQL.replaceAll("TABLE", this.tempTableName) + sql;
    }

    @Override
    public void getCollection(IRowSet rs, IObjectCollection collection) throws EASBizException, BOSException {
        String trackId = "";
        String preTrackId = "";
        PBOMInfo info = null;
        HashMap<String, PBOMInfo> result = new HashMap<String, PBOMInfo>();
        try {
            while (null != rs && rs.next()) {
                trackId = rs.getString("FTraceID");
                if (!result.containsKey(trackId)) {
                    info = new PBOMInfo();
                    info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                    info.put(TRACKID, (Object)trackId);
                    StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                    sou.setId(BOSUuid.read((String)rs.getString("fstorageOrgUnitId")));
                    info.setStorageOrgUnit(sou);
                    result.put(trackId, info);
                } else {
                    info = (PBOMInfo)result.get(trackId);
                }
                PBOMEntryInfo entry = new PBOMEntryInfo();
                entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                BomEntryInfo bei = new BomEntryInfo();
                bei.setId(BOSUuid.read((String)rs.getString("fBomEntryBillId")));
                bei.setOutputType(MaterialProductEnum.getEnum((int)rs.getInt("FOutputType")));
                MaterialInfo mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)rs.getString("FChildMaterialID")));
                bei.setMaterial(mi);
                MeasureUnitInfo mui = new MeasureUnitInfo();
                mui.setId(BOSUuid.read((String)rs.getString("fBaseUnitId")));
                bei.setBaseUnit(mui);
                bei.setBigDecimal(BASEQTY, rs.getBigDecimal("FBaseQty"));
                bei.setBigDecimal(UNITQTY, rs.getBigDecimal("FUnitQty"));
                bei.setTimestamp(DEMANDDATE, rs.getTimestamp("fDate"));
                bei.setOperationNo(rs.getInt("fOperationNo"));
                entry.setBomItem(bei);
                entry.setUnitQty(rs.getBigDecimal("FUnitQty"));
                info.getPbomEntry().add(entry);
            }
            for (Map.Entry entry : result.entrySet()) {
                collection.addObject((IObjectValue)((PBOMInfo)entry.getValue()));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public IObjectCollection createCollection() {
        return new PBOMCollection();
    }

    @Override
    public void dealResult(Future future) throws EASBizException, BOSException {
        PBOMCollection collection = (PBOMCollection)future.getResult();
        int countj = collection.size();
        for (int j = 0; j < countj; ++j) {
            PBOMInfo info = collection.get(j);
            String key = (String)info.get(TRACKID);
            this.result.put(key, info);
        }
    }
}

